<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Pengeluaran extends CI_Controller {
	function __construct(){
		error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	

	//pengeluaran divisi-divisi
	public function pengeluaran_divisi(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");
		$data['divisi']=$this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");

		$ar_akun=array('status =' => "on", "id_sekolah = " => $id_sekolah, "akun.id_akun like " => "1.%");
        $data['akun1'] = $this->m_models->getJoin1where("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $ar_akun, "nama_akun", "asc");

        //memunculkan akun beban
        $ar_beban=array('status =' => "on", "id_sekolah = " => $id_sekolah, "akun.id_akun like " => "5.%");
        $data['beban_divisi'] = $this->m_models->getJoin1where("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $ar_beban, "nama_akun", "asc");

		$this->load->view('pengeluaran/beban_divisi',$data);
		$this->load->view('template/footer');
	}

	public function simpan_pengeluaran_divisi(){
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;

        $tgl = date_db($this->input->post('tgl', TRUE));
        $akun2 = $this->input->post('id_akun', TRUE);
        $akun1 = $this->input->post('akun1', TRUE);
        $urai = $this->input->post('uraian', TRUE);
        $pemohon = $this->input->post('pemohon', TRUE);
        $nominal = nominalIndo($this->input->post('nominal', TRUE));
        $uraian=$urai."_".$pemohon;
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
		$no_jurnal=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1' => $uraian, 'debet1' => "0", 'kredit1' => $nominal, 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => $nominal, 'kredit2' => "0", 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "pengeluaran divisi", 'id_tahun'=>$id_ta, 'nrp'=>$nrp);
		if ($this->m_models->save_data($no_jurnal, 'jurnal') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diajukan ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('pengeluaran/pengeluaran_divisi');
	}
}