<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Pemasukan extends CI_Controller {
	function __construct(){
		error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
		$this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
	}

	//pemasukan nominal dari siswa
	public function pemasukan(){
		$this->load->view('template/header');

		$id = date('ymdHis');
        $id_log =  $id . rand(10,99);


        $data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		foreach ($data['thn_akademik'] as $ta){
			$data['ta']=$ta->id_tahun;
			$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "kategori", "Sekolah", "id_sekolah", "asc");
		}

		$kelas=$this->input->post('kelas', TRUE);
		$sklh=$this->input->post('sekolah', TRUE);
		

		$this->load->view('pemasukan/i_pemasukan',$data);
		$this->load->view('template/footer');
	}

	public function cekkelas(){
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		foreach ($data['thn_akademik'] as $ta){
			$sekolah=$this->input->get('sekolah', TRUE);
			$data['sklh']=$sekolah;
			$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $sekolah, "id_sekolah", "asc");
			foreach ($data['sekolah'] as $s) {
				$arraywhere = array('id_sekolah =' => $sekolah);
				$data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $arraywhere, "nama_kelas", "asc");
			}

			$exp=$this->input->get('kelas', TRUE);
			$ex=explode("-", $exp);
			$kelas=$ex[1];
			$sklh=$ex[0];
			$data['kls']=$kelas;

			if (($kelas != "")&&($sklh != "")){
				$tabel=$this->m_models->getTabelSiswa($sklh, "siswa");
				$rmbel=$this->m_models->getTabelSiswa($sklh, "rombongan_belajar");
				$data['tsiswa']=$tabel;
				$data['trombel']=$rmbel;
				$data['id_sekolah']=$sklh;

				$arr = array($rmbel.".id_kelas ="=> $kelas, 'status_aktif'=>'Aktif');
				$data['siswa'] = $this->m_models->getJoin1where("*", $rmbel, $tabel, "$tabel.id_siswa=$rmbel.id_siswa",$arr, "nama_lengkap", "asc");
				$data['jsiswa'] = $this->m_models->getRowsJoin1Where("*", $rmbel, $tabel, "$tabel.id_siswa=$rmbel.id_siswa",$arr, "nama_lengkap", "asc");


				$arpemb = array('id_tahun =' => $ta->id_tahun, 'id_kelas =' => $kelas);
				$data['pembayaran'] = $this->m_models->getJoin1where("*", "k_daftarjenis_pembayaran", "k_daftar_pos", "k_daftar_pos.id_daftar_pos=k_daftarjenis_pembayaran.id_daftar_pos", $arpemb, "nama_pos", "asc");
			}
		}

		$this->load->view('pemasukan/cekkelas', $data);
	}

	public function pemasukan_divisi(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");
		$data['divisi']=$this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		$ar_akun=array('status =' => "on", "id_sekolah = " => $id_sekolah, "akun.nama_akun like " => "KAS %");
        $data['akun2'] = $this->m_models->get_data("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "join pilihan_akun on pilihan_akun.id_akun=akun.id_akun where status='on' and id_sekolah='$id_sekolah' and akun.nama_akun like '%KAS %' or akun.nama_akun like '%BANK %' order by nama_akun asc");

		$this->load->view('pemasukan/pemasukan_divisi',$data);
		$this->load->view('template/footer');
	}

	public function ceksekolah(){
        $idsekolah = $this->input->get('idsekolah', TRUE);
        $ar_akun=array('status =' => "on", "id_sekolah = " => $idsekolah, "akun.id_akun like " => "1.%");
        $data['akun1'] = $this->m_models->getJoin1where("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $ar_akun, "nama_akun", "asc");

        $this->load->view('pemasukan/ceksekolah',$data);
    }

    
    public function simpan_masuk_divisi(){
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;

        $tgl = date_db($this->input->post('tgl', TRUE));
        $idsekolah = $this->input->post('idsekolah', TRUE);
        $akun1 = $this->input->post('akun1', TRUE);
        $akun2 = $this->input->post('akun2', TRUE);
        $urai = $this->input->post('uraian', TRUE);
        $pemohon = $this->input->post('pemohon', TRUE);
        $nominal = nominalIndo($this->input->post('nominal', TRUE));
        $uraian=$urai."_".$pemohon;
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
		$no_jurnal=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => '0', 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => '0', 'kredit2' => $nominal, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "pengeluaran divisi", 'id_tahun'=>$id_ta, 'nrp'=>$nrp);
		$simpan=$this->m_models->save_data($no_jurnal, 'jurnal');

		$no_transaksi_div = $this->m_models->notransaksi_jurnal($idsekolah);
		$no_jurnal_div=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi_div, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => '0', 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => '0', 'kredit2' => $nominal, 'id_sekolah' => $idsekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Proses", 'asal' => "pemasukan divisi", 'id_tahun'=>$id_ta, 'nrp'=>$nrp);
		$simpan_div=$this->m_models->save_data($no_jurnal_div, 'jurnal');
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diajukan ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('pemasukan/pemasukan_divisi');	
	}

	public function resume_dp_divisi(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$dari = $this->input->post('dari', TRUE); 
		$sampai = $this->input->post('sampai', TRUE); 
		$data['dari']=$dari;
		$data['sampai']=$sampai;

		if (($dari != "") && ($sampai != "")){
			$arraywhere = array('asal =' => "pemasukan divisi", 'tgl >=' => $dari, 'tgl <=' => $sampai);
			$data['jurnal'] = $this->m_models->getTabelwhere("*", "jurnal", $arraywhere, "tgl", "asc");
		}
		$this->load->view('pemasukan/resume_dp_divisi',$data);
		$this->load->view('template/footer');
	}

	public function print_dp_divisi(){
		$nrp=$this->session->userdata['nrp'];
		$no_transaksi = $this->uri->segment(3)."/".$this->uri->segment(4)."/".$this->uri->segment(5)."/".$this->uri->segment(6)."/".$this->uri->segment(7);
		$data['id_sekolah']=$this->m_models->getSession($nrp, "id_sekolah");

		if ($no_transaksi != ""){
			$arraywhere = array('no_transaksi =' => $no_transaksi);
			$data['jurnal'] = $this->m_models->getTabelwhere("*", "jurnal", $arraywhere, "tgl", "asc");
		}


		$this->load->library('pdf');
		$customPaper = array(0,0,912.0114899085,528.0066520523);
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('pemasukan/print_dp_divisi', $data);
		$this->pdf->render();
		$this->pdf->stream("Kwitansi_DP_Divisi.pdf", array('Attachment'=>0));

		//$this->load->view('pemasukan/print_dp_divisi',$data);
	}

	public function app_pemasukan_divisi(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
		$data['id_sekolah'] = $id_sekolah;
		$arraywhere = array('asal =' => "pemasukan divisi", 'approve3' => 'Proses', 'id_sekolah' => $id_sekolah);
		$data['jurnal'] = $this->m_models->getTabelwhere("*", "jurnal", $arraywhere, "tgl", "asc");
		$this->load->view('pemasukan/app_pemasukan_divisi',$data);
		$this->load->view('template/footer');
	}

	public function app_masuk_div(){
		$nrp=$this->session->userdata['nrp'];
		$no_transaksi = $this->uri->segment(3)."/".$this->uri->segment(4)."/".$this->uri->segment(5)."/".$this->uri->segment(6)."/".$this->uri->segment(7);
		$ket = $this->uri->segment(8);
		$data['id_sekolah']=$this->m_models->getSession($nrp, "id_sekolah");

		if ($no_transaksi != ""){
			if ($ket=="A"){
				$arraywhere = array('approve3' => 'Approve');
				$simpan=$this->m_models->update_data($no_transaksi, "no_transaksi", $arraywhere, "jurnal");
			} else {
				$arraywhere = array('approve3' => 'Batal');
				$simpan=$this->m_models->update_data($no_transaksi, "no_transaksi", $arraywhere, "jurnal");
			}
		}
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('pemasukan/app_pemasukan_divisi');	
	}

	public function setor_simtitis(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
        $data['akun'] = $this->m_models->get_data("nama_akun", "simtitis", "join akun on akun.id_akun=simtitis.akun_jurnal group by akun_jurnal order by nama_akun asc");

		$this->load->view('pemasukan/setor_simtitis',$data);
		$this->load->view('template/footer');	
	}

	public function simpan_setor_simtitis(){
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;

        $tgl = date_db($this->input->post('tgl', TRUE));
        $akun = $this->input->post('akun', TRUE);
        if ($id_sekolah=="28"){
        	#koperasi
        	$akun1="1.1.1.34";
        	$akun2=$akun;
        } else if ($id_sekolah=="18"){
        	#keuangan
        	$akun1=$akun;
        	$akun2="1.1.1.34";
        }
        $urai = $this->input->post('uraian', TRUE);
        $pemohon = $this->input->post('pemohon', TRUE);
        $nominal = nominalIndo($this->input->post('nominal', TRUE));
        $uraian=$urai."_".$pemohon;
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
		$no_jurnal=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => '0', 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => '0', 'kredit2' => $nominal, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "pengeluaran divisi", 'id_tahun'=>$id_ta, 'nrp'=>$nrp);
		$simpan=$this->m_models->save_data($no_jurnal, 'jurnal');

		$no_transaksi_div = $this->m_models->notransaksi_jurnal($idsekolah);
		$no_jurnal_div=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi_div, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => '0', 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => '0', 'kredit2' => $nominal, 'id_sekolah' => $idsekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Proses", 'asal' => "pemasukan divisi", 'id_tahun'=>$id_ta, 'nrp'=>$nrp);
		$simpan_div=$this->m_models->save_data($no_jurnal_div, 'jurnal');
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diajukan ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('pemasukan/setor_simtitis');	
	}

	public function mutasi_bank(){
		$this->load->view('template/header');
		$this->load->view('pemasukan/mutasi_bank',$data);
		$this->load->view('template/footer');
	}

	public function download_file_import($nm_file, $tipe_file){
		$this->load->view('template/header');
		$this->load->helper('download');
		
		force_download('assets/upload/mutasi_bank.xlsx', NULL);
	}

	public function upload(){
		$nrp=$this->session->userdata['nrp'];
		$hariini=date("Y-m-d");
	  	$fileName = $this->input->post('file', TRUE);

	  	$config['upload_path'] = './assets/upload/'; 
	  	$config['file_name'] = $fileName;
	  	$config['allowed_types'] = 'xls|xlsx|csv|ods|ots';
	  	$config['max_size'] = 10000;

	  	$this->load->library('upload', $config);
	  	$this->upload->initialize($config); 
	  
	  	if (!$this->upload->do_upload('file')) {
	   		$error = array('error' => $this->upload->display_errors());
	   		$this->session->set_flashdata('msg','Ada kesalah dalam upload'); 
	   		redirect('Welcome'); 
	  	} else {
	   		$media = $this->upload->data();
	   		$inputFileName = 'assets/upload/'.$media['file_name'];
	   
	   		try {
			    $inputFileType = IOFactory::identify($inputFileName);
			    $objReader = IOFactory::createReader($inputFileType);
			    $objPHPExcel = $objReader->load($inputFileName);
	   		} catch(Exception $e) {
	    		die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
	   		}

		   $sheet = $objPHPExcel->getSheet(0);
		   $highestRow = $sheet->getHighestRow();
		   $highestColumn = $sheet->getHighestColumn(); echo "$highestRow";

	   		for ($row = 2; $row <= $highestRow; $row++){
	     		$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);

		 		$data = array(
		     		"id_mb"=> '',
		     		"tgl_input"=> $hariini,
		     		"tgl"=> $rowData[0][0],
		     		"id_va"=> $rowData[0][1],
		     		"nama"=> $rowData[0][2],
		     		"nominal"=> $rowData[0][3],
		     		"petugas"=> $nrp
		    	); 
		    	$this->db->insert("k_mutasi_bank",$data);
	   		} 
		   	// delet file
	        unlink($inputFileName);

	   		$this->session->set_flashdata('msg','Berhasil upload ...!!'); 
	   		redirect('pemasukan/mutasi_bank');
	  	}  
	} 
}