<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Pegawai extends CI_Controller {
	function __construct(){
	    error_reporting(0);
		parent::__construct();
        $this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])){
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	public function sendSMS($number,$textpesan){			
		$curl = curl_init();		
		$text = (string)$textpesan;		
		$num = (string)$number;		
		$usernusa="al-multazam_api";		
		$passnusa="cafmusry";		
		curl_setopt_array($curl, array(			
			CURLOPT_RETURNTRANSFER => 1,			
			CURLOPT_URL => 'http://api.nusasms.com/api/v3/sendsms/plain',			
			CURLOPT_POST => true,			
			CURLOPT_POSTFIELDS => array(				
				'user' => 'al-multazam_api',				
				'password' => 'cafmusry',				
				'SMSText' => $text,				
				'GSM' => $num			
			)		
		));		
		$resp = curl_exec($curl);		
		if (!$resp) {
			die('Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl));		
		}			
		//header('Content-type: text/xml'); /*if you want to output to be an xml*/			//echo $resp;		curl_close($curl);		}
	}
	
	
	//fungsi menampilkan data pegawai
	public function pegawai(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
	
		$this->load->view('pegawai/pegawai');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	
	//fungsi input data pegawai, riwayat pendidikan, kk, dsb
	public function input_pegawai(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$hariini=date("Y");
		$sub=substr($hariini,2,2);
       /* $jpe = $this->m_models->getRows('pegawai');
        $jpeg = $jpe+19; */
        $jpe = $this->m_models->getAll('pegawai order by nrp desc limit 1');
        foreach ($jpe as $j){
        	$n=substr($j->nrp,2,4);
        }
        $jpeg = $n+1;

		//menambahkan angka nol
		if($jpeg < 10) {
			$nourut = '000'.$jpeg;
		}else if($jpeg < 100)	{
			$nourut = '00'.$jpeg;
		}else if($jpeg < 1000){
			$nourut = '0'.$jpeg;
		}else {
			$nourut = $jpeg;
		}
		$data['nrp']="$sub$nourut";
        $data['jabatan'] = $this->m_models->getAll('jabatan');
        $data['pangkat'] = $this->m_models->getAll('golongan');
        $data['kontrak_kerja'] = $this->m_models->getAll('kontrak');
        //$data['tingkat_pend'] = $this->m_models->getAll('tingkat_pendidikan');
        $ap=array('id_tp >=' => '1', 'id_tp <=' => '10');
		$data['tingkat_pend'] = $this->m_models->getTabelwhere("*", "tingkat_pendidikan", $ap, "id_tp", "asc");
        $data['profesi'] = $this->m_models->getAll('profesi');
        $data['penempatan'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");
		$data['provinsi'] = $this->m_models->getTabelOrder("*", "provinsi", "nama", "asc");
		$data['level_user'] = $this->m_models->getAll("level_user WHERE id_level='1' or id_level='3'  or id_level='4'  or id_level='6'  or id_level='7'  or id_level='10'  or id_level='12'  or id_level='13'  or id_level='15'  or id_level='20'  or id_level='21'  or id_level='31'  or id_level='32'  or id_level='45'  or id_level='46'  or id_level='47'  or id_level='56'  or id_level='58'  or id_level='71'  or id_level='80'  or id_level='82'  or id_level='87'  or id_level='90'  or id_level='106'  or id_level='109'  or id_level='110'  or id_level='116'  or id_level='117'  or id_level='118'  or id_level='119'  or id_level='120'  or id_level='121'  or id_level='122'  or id_level='123'  or id_level='125'  or id_level='126' or id_level='127' or id_level='129' or id_level='130' or id_level='136' or id_level='141' ORDER BY nama_level ASC");
		$this->load->view('pegawai/f_pegawai',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function form_anggota_kk(){
        //$data['tingkat_pend'] = $this->m_models->getAll('tingkat_pendidikan');
         $ap=array('id_tp >=' => '1', 'id_tp <=' => '10');
		$data['tingkat_pend'] = $this->m_models->getTabelwhere("*", "tingkat_pendidikan", $ap, "id_tp", "asc");
        $data['profesi'] = $this->m_models->getAll('profesi');
		$this->load->view('pegawai/form_anggota_kk', $data);
	}

	public function cekkab(){
		$id_prov=$this->input->get('prov');
		$id_kab=$this->input->get('kab');
		$id_kec=$this->input->get('kec');

		$data['kabupaten'] = $this->m_models->getwhere("*", "kabupaten", "id_prov", $id_prov, "nama", "asc");
		$data['kecamatan'] = $this->m_models->getwhere("*", "kecamatan", "id_kab", $id_kab, "nama", "asc");
		$data['kelurahan'] = $this->m_models->getwhere("*", "kelurahan", "id_kec", $id_kec, "nama", "asc");
		$this->load->view('pegawai/cekkab', $data);
	}

	//fungsi untuk simpan data pegawai
	public function simpan_pegawai(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
        $nip = $this->input->post('nip');
		$nuptk = $this->input->post('nuptk');
		$nrp = $this->input->post('nrp');
		$no_ktp = $this->input->post('no_ktp');
		$nama = htmlspecialchars($this->input->post('nama'));
		$tmp_lahir = $this->input->post('tmp_lahir');
		$tgl_lahir = date_db($this->input->post('tgl_lahir'));
		$jk = $this->input->post('jk');
		$gol_darah = $this->input->post('gol_darah');
		$alamat = $this->input->post('alamat');
		$desa = $this->input->post('desa');
		$kec = $this->input->post('kec');
		$kab = $this->input->post('kab');
		$agama = $this->input->post('agama');
		$status_marital = $this->input->post('status_marital');
		$warganegara = $this->input->post('warganegara');
		$no_hp1 = $this->input->post('no_hp1');
		$no_hp2 = $this->input->post('no_hp2');
		$tgl_masuk = date_db($this->input->post('tgl_masuk'));
		$status_aktif = $this->input->post('status_aktif');
		$status_kary = $this->input->post('status_kary');
		$jab = $this->input->post('jab');
		$pangkat = $this->input->post('pangkat');
		$foto = $this->input->post('foto');
		$email = $this->input->post('email');
		$penempatan = $this->input->post('penempatan');
		$ktp=$this->input->post('ktp');
		$kk=$this->input->post('kk');
		$ijazah=$this->input->post('ijazah');
		$skck=$this->input->post('skck');
		$ket_dokter=$this->input->post('ket_dokter');
		$rekomendasi_kerja=$this->input->post('rekomendasi_kerja');
		$sertf_ahli=$this->input->post('sert_keahlian');
		$kartu_kuning=$this->input->post('kartu_kuning');
		$npwp=$this->input->post('NPWP');
		$jab2 = $this->input->post('jab2');
		$penempatan2 = $this->input->post('penempatan2');
		$prov = $this->input->post('prov');

		$tgl_masuk_baru = date_db($this->input->post('tgl_masuk_baru'));
		$status_pegawai = $this->input->post('status_pegawai');
		$kategori = $this->input->post('kategori');
		$ijazah_terbaru = $this->input->post('ijazah_terbaru');
		$tgl_ijazah_baru = $this->input->post('tgl_ijazah_baru');

		//upload foto
		// setting konfigurasi upload
        $config['upload_path'] = './img_pegawai/';
        $config['allowed_types'] = 'jpg|png|jpeg|JPG|PNG';
        $config['image_library']='gd2';
        $config['source_image']='./img_pegawai/'.$gbr['file_name'];
        $config['create_thumb']= FALSE;
       	$config['maintain_ratio']= FALSE;
        $config['quality']= '50%';
        $config['width']= 250;
        $config['height']= 250;
        $config['new_image']= './img_pegawai/'.$gbr['file_name']; 
        $this->load->library('image_lib', $config);
        $this->image_lib->resize();

        // load library upload
        $this->load->library('upload', $config);
        if (!$this->upload->do_upload('gambar')) {
            $error = $this->upload->display_errors();
            // menampilkan pesan error
            print_r($error);
        } else {
           // $result = $this->upload->data();
            $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => './img_pegawai/'. $data_upload['file_name'],
                    'maintain_ratio' => false,
                    'create_thumb' => true,
                    'quality' => '90%',
                    'width' => 354,
                    'height' => 472 
                ));
                 
                if($this->image_lib->resize()){
                    $output = '<h4>Thumb - hasil Resize</h4>';
                    $output .= img('./img_pegawai/thumb/'.$data_upload['raw_name'].'_thumb'.$data_upload['file_ext']);
                    $output .= '<h4 style="margin-top: 30px">Gambar Original</h4>';
                    $output .= img('./img_pegawai/thumb/'.$data_upload['file_name']);
                     
                    $data['output'] = $output;
                } else {
                    $data['error'] = $this->image_lib->display_errors();
                } 
        } 
        $dataNRP = $this->m_models->getDataByIDQ("pegawai", "nrp", $nrp);
        if (($nrp != "") and ($dataNRP == 0)){
			$jkk = $this->m_models->getRowsWhere("*", "pegawai", "nrp", $nrp, "nama", "asc");
			if ($jkk == 0){
				$pwd="827ccb0eea8a706c4c34a16891f84e7b";
				$simpan_peg=$this->db->query("INSERT INTO pegawai VALUES ('$nrp', '$nuptk', '$nip', '$nama', '$tmp_lahir','$tgl_lahir', '$jk', '$tgl_masuk', '$alamat', '$desa', '$kec', '$kab', '$prov', '$email', '".$data_upload['raw_name'].'_thumb'.$data_upload['file_ext']."', '$status_marital', '$status_aktif', '$jab', '$no_hp1', '$ting_pend', '$gol_darah', '$agama',  '$no_ktp', '0', '$skck', '$ktp', '$kk', '$ijazah', '$kartu_kuning', '$ket_dokter', '$npwp', '$rekomen_kerja', '$sertf_ahli','$warganegara','$status_kary','$no_hp2', '$pangkat','$penempatan', '$jab2', 'penempatan2', '0', '$tgl_masuk_baru', '$status_pegawai', '$kategori', '$ijazah_terbaru', '$tgl_ijazah_baru' )") or die (mysql_error());

				#level user
				$lu=$this->input->post('level_user');
				for ($k=0; $k < count($lu); $k++) { 
					$level_user .= "$lu[$k]+"; 
				}
				$simpan_login=$this->db->query("INSERT INTO tb_pengguna VALUES ('', '$nama', '$nrp', '$pwd', 'on','$level_user', '0000-00-00 00:00:00', '$nrp', '12345')") or die (mysql_error());

				//$ar_peg= array('nrp'=>$nrp, 'nuptk' => $nuptk, 'nip' => $nip, 'nama' => $nama, 'tmp_lhr' => $tmp_lahir,'tgl_lhr' => $tgl_lahir, 'jk' => $jk, 'tgl_masuk' => $tgl_masuk, 'alamat' => $alamat, 'kel' => $desa, 'kec' => $kec, 'kota' => $kab, 'prov' => $prov, 'email' => $email, 'foto' => $foto, 'st_marital' => $status_marital, 'status_aktf' => $status_aktif, 'id_jabatan' => $jab, 'tlp' => $no_hp1, 'pend_akhir' => $ting_pend, 'gol_darah' => $gol_darah, 'agama' => $agama, 'no_ktp' => $no_ktp, 'saldo_awal' => '0', 'skck' => $skck, 'ktp' => $ktp, 'kk' => $kk, 'ijazah' => $, 'kartu_kuning' => $, 'ket_dokter' => $, 'npwp' => $, 'rekomen_kerja' => $, 'sertifikat_keahlian' => $, 'warga_negara' => $, 'id_kontrak' => $, 'no_hp2' => $, 'id_golongan' => $, 'id_sekolah' => $, 'id_jabatan2' => $, 'id_sekolah2' => $);

				if ($simpan_peg == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}

				$jenjang_pend = $this->input->post('jenjang'.$i);
				$ting_pend = $this->input->post('ting_pend');
				for ($i=0; $i<=10; $i++){
					$jenjang = $jenjang_pend[$i];
					$nm_sekolah = $this->input->post('nm_sekolah'.$jenjang);
					$kota = $this->input->post('kota'.$jenjang);
					$thn_lulus = $this->input->post('thn_lulus'.$jenjang);
					$fakultas = $this->input->post('fakultas'.$jenjang);
					$jurusan = $this->input->post('jurusan'.$jenjang); 
					if (($nm_sekolah != "")){
						$this->db->query("INSERT INTO riwayat_pend_peg VALUES ('', '$nrp', '$jenjang', '$nm_sekolah', '$kota', '$thn_lulus', '$fakultas', '$jurusan')") or die (mysql_error());
					}
				}
				
				for ($j=1; $j<=5; $j++){
					$periode = $this->input->post('periode'.$j); 
					$tmp_kerja = $this->input->post('tmp_kerja'.$j);
					$posisi = $this->input->post('posisi'.$j);
					if (($periode != "") && ($tmp_kerja != "") && ($posisi != "")){
						$this->db->query("INSERT INTO peng_kerja VALUES ('', '$nrp', '$periode', '$tmp_kerja', '$posisi')") or die (mysql_error());
					}
				}
				
				//kartu keluarga
				$jml_anggota = $this->input->post('jml_anggota'); 
				$no_kk = $this->input->post('no_kk'); 
				$blok_kk = $this->input->post('blok_kk'); 
				$rt_kk = $this->input->post('rt_kk'); 
				$rw_kk = $this->input->post('rw_kk'); 
				$desa_kk = $this->input->post('desa_kk'); 
				$kec_kk = $this->input->post('kec_kk'); 
				$kab_kk = $this->input->post('kab_kk'); 
				$kode_pos_kk = $this->input->post('kode_pos_kk'); 
				$provinsi_kk = $this->input->post('provinsi_kk');  
				for ($a=1; $a<=$jml_anggota; $a++){ 
					$no_penduduk_kk = $this->input->post('no_penduduk_kk'.$a); 
					$nama_kk = $this->input->post('nama_kk'.$a); 
					$tmp_lahir_kk = $this->input->post('tmp_lahir_kk'.$a); 
					$tgl_lahir_kk = $this->input->post('tgl_lahir_kk'.$a); 
					$jk_kk = $this->input->post('jk_kk'.$a); 
					$agama_kk = $this->input->post('agama_kk'.$a); 
					$pend_kk = $this->input->post('pend_kk'.$a); 
					$pekerjaan_kk = $this->input->post('pekerjaan_kk'.$a); 
					$status_marital_kk = $this->input->post('status_marital_kk'.$a); 
					$hub_kk = $this->input->post('hub_kk'.$a); 
					$warganegara_kk = $this->input->post('warganegara_kk'.$a); 
					$paspor_kk = $this->input->post('paspor_kk'.$a); 
					$kitas_kk = $this->input->post('kitas_kk'.$a); 
					$ayah_kk = $this->input->post('ayah_kk'.$a); 
					$ibu_kk = $this->input->post('ibu_kk'.$a); 
					$keadaan_kk = $this->input->post('keadaan_kk'.$a); 
					$anggota_kk = $this->input->post('anggota_kk'.$a); 
					
					$this->db->query("INSERT INTO kartu_keluarga VALUES ('', '$no_penduduk_kk', '$no_kk', '$nrp', '$nama_kk','$blok_kk', '$rt_kk', '$rw_kk', '$desa_kk', '$kec_kk', '$kab_kk', '$kode_pos_kk', '$provinsi_kk', '$jk_kk', '$tmp_lahir_kk', '$tgl_lahir_kk', '$agama_kk', '$pend_kk', '$pekerjaan_kk', '$status_marital_kk', '$hub_kk',  '$warganegara_kk', '$paspor_kk', '$kitas_kk', '$ayah_kk', '$ibu_kk', '$keadaan_kk', now(), now(), '$anggota_kk', 'Aktif')") or die (mysql_error());
				}
			} else {
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		} else {
			$this->session->set_flashdata('gagal', 'NRP sudah digunakan. Silahkan mencoba kembali !!!');
		}
		
		$data['pegawai'] = $this->m_models->getAll('pegawai');
		redirect('pegawai/lihat_pegawai');
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk lihat data pegawai
	function lihat_pegawai(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 

	    if (($id_sekolah=="8") or ($id_sekolah=="13") or ($id_sekolah=="39")){
	    	//$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
			$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$ar=array('status_aktif' => 'on', 'id_sekolah'=>$id_sekolah);
			$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
		}

		
		$jenjang = $this->input->post('jenjang'); 
		$status = $this->input->post('status'); 
		if (($jenjang != "")&&($status != "")){
			if (($jenjang=="all") && ($status=="all")){
				if (($id_sekolah=="8") or ($id_sekolah=="13")){
					$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
				} else {
					$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where (id_sekolah='$id_sekolah' or id_sekolah2='$id_sekolah') order by nama asc");
				}
			} else if (($jenjang!="all") && ($status=="all")){ 
				$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where id_sekolah='$jenjang' or id_sekolah2='$jenjang' order by nama asc");
			} else if (($jenjang=="all") && ($status!="all")){ 
				if (($id_sekolah=="8") or ($id_sekolah=="13")or ($id_sekolah=="39")){
					$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan and status_aktf='$status' order by nama asc");
				} else {
					$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where (id_sekolah='$jenjang' or id_sekolah2='$jenjang') and status_aktf='$status' order by nama asc");
				}
			} else if (($jenjang!="all") && ($status!="all")){
				$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where (id_sekolah='$jenjang' or id_sekolah2='$jenjang') and status_aktf='$status' order by nama asc");
			} 
			foreach ($data['pegawai'] as $p) {
				$arr=array('nrp' => $p->nrp);
				$data['login'] = $this->m_models->getTabelwhere("*", "tb_pengguna", $arr, "id_pengguna", "asc");
				$data[username][$p->nrp] = $data['login'][0]->username;
				$data[password][$p->nrp] = $data['login'][0]->pwd;
			}
		}
		
		
		
		$this->load->view('pegawai/lihat_pegawai',$data);

		$this->load->view('template/footer');
	}

	function download_dt_pegawai(){
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    if (($id_sekolah=="8") or ($id_sekolah=="13")or ($id_sekolah=="39")){
	    	$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
		} else {
			$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where id_sekolah='$id_sekolah' or id_sekolah2='$id_sekolah' order by nama asc");
		}
		
		foreach ($data['pegawai'] as $peg) {
			$data['pend_akhir'] = $this->m_models->getAll("riwayat_pend_peg where nrp='$peg->nrp' and id_tp='$peg->pend_akhir'");
			$data[institusi][$peg->nrp]=$data['pend_akhir'][0]->sekolah;
			$data[fakultas][$peg->nrp]=$data['pend_akhir'][0]->fakultas;
			$data[jurusan][$peg->nrp]=$data['pend_akhir'][0]->jurusan;
		}
		

		$this->load->view('pegawai/download_dt_pegawai',$data);
	}

	function get_pegawai() {
        header('Content-Type: application/json');
        echo $this->m_models->get_pegawai();
    }

	
	//fungsi untuk detail data pegawai
	public function detail_pegawai($nrp){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp = $this->uri->segment(3);
		$data['reward'] = $this->m_models->getAll("peg_reward where nrp='$nrp' order by tanggal_kegiatan asc");
		$data['punish'] = $this->m_models->getAll("peg_punish where nrp='$nrp' order by tanggal_punish asc");
		$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where nrp='$nrp' order by nama asc");
		$data['pend_akhir'] = $this->m_models->getAll("riwayat_pend_peg join pegawai on pegawai.nrp=riwayat_pend_peg.nrp join tingkat_pendidikan on riwayat_pend_peg.id_tp= tingkat_pendidikan.id_tp where riwayat_pend_peg.nrp='$nrp'");
		$data['pengalaman'] = $this->m_models->getAll("peng_kerja join pegawai on pegawai.nrp=peng_kerja.nrp where peng_kerja.nrp='$nrp'");
		$data['no_kk'] = $this->m_models->getAll("kartu_keluarga join pegawai on pegawai.nrp=kartu_keluarga.nrp where kartu_keluarga.nrp='$nrp'");
		$nokk=$data['no_kk'][0]->no_kk;
		$data['kartu_keluarga'] = $this->m_models->getAll("kartu_keluarga where no_kk='$nokk'");
		$data['kepalakeluarga'] = $this->m_models->getAll("kartu_keluarga where no_kk='$nokk' and status_hubungan='Kepala Keluarga'");
		$pangkat=$data['pegawai'][0]->id_golongan;
		$kontrak=$data['pegawai'][0]->kontrak;
		$sekolah=$data['pegawai'][0]->id_sekolah;
		$data['golongan'] = $this->m_models->getAll("golongan where id_golongan='$pangkat'");
		$data['kontrak'] = $this->m_models->getAll("kontrak where id_kontrak='$kontrak'");
		$data['penempatan'] = $this->m_models->getAll("sekolah where id_sekolah='$sekolah' order by nama");
		
		$this->load->view('pegawai/detail_pegawai',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	
	//fungsi untuk edit data pegawai
	public function edit_pegawai($nrp){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp = $this->uri->segment(3);
		$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where nrp='$nrp' order by nama asc");
		$data['pend_akhir'] = $this->m_models->getAll("riwayat_pend_peg join pegawai on pegawai.nrp=riwayat_pend_peg.nrp join tingkat_pendidikan on riwayat_pend_peg.id_tp= tingkat_pendidikan.id_tp where riwayat_pend_peg.nrp='$nrp'");
		$data['pengalaman'] = $this->m_models->getAll("peng_kerja join pegawai on pegawai.nrp=peng_kerja.nrp where peng_kerja.nrp='$nrp'");
		$data['no_kk'] = $this->m_models->getAll("kartu_keluarga join pegawai on pegawai.nrp=kartu_keluarga.nrp where kartu_keluarga.nrp='$nrp'");
		$nokk=$data['no_kk'][0]->no_kk;
		$data['kartu_keluarga'] = $this->m_models->getAll("kartu_keluarga where no_kk='$nokk'");
		$pangkat=$data['pegawai'][0]->id_golongan;
		$kontrak=$data['pegawai'][0]->kontrak;
		$data['golongan'] = $this->m_models->getAll("golongan");
		$data['kontrak'] = $this->m_models->getAll("kontrak");
		$data['penempatan'] = $this->m_models->getAll("sekolah order by nama");
		
		$levusr = all("tb_pengguna","nrp",$nrp,"hak_akses");
		$tl = substr_count($levusr,"+");
		$h = array();
		for($k=0;$k<=$tl;$k++){
			$kn = explode("+",$levusr);
				$nama_lev = all("level_user","id_level",$kn[$k],"nama_level");
				$h[] = $nama_lev;
			
		}
		$data['leveluser'] = implode(",",$h);
		
        $data['jabatan'] = $this->m_models->getAll('jabatan');
        $data['pangkat'] = $this->m_models->getAll('golongan');
        $data['tingkat_pend'] = $this->m_models->getAll('tingkat_pendidikan');
		$id_pend=$data['tingkat_pend'][0]->id_tp;
		$data['rpend'] = $this->m_models->getAll("riwayat_pend_peg where nrp='$nrp' and id_tp='$id_tp'");
		$data['level_user'] = $this->m_models->getAll("level_user WHERE id_level='1' or id_level='3'  or id_level='4'  or id_level='6'  or id_level='7'  or id_level='10'  or id_level='12'  or id_level='13'  or id_level='15'  or id_level='20'  or id_level='21'  or id_level='31'  or id_level='32'  or id_level='45'  or id_level='46'  or id_level='47'  or id_level='56'  or id_level='58'  or id_level='71'  or id_level='80'  or id_level='82'  or id_level='87'  or id_level='90'  or id_level='106'  or id_level='109'  or id_level='110'  or id_level='116'  or id_level='117'  or id_level='118'  or id_level='119'  or id_level='120'  or id_level='121'  or id_level='122'  or id_level='123'  or id_level='125'  or id_level='126' or id_level='127' or id_level='129' or id_level='130' or id_level='136' or id_level='141' ORDER BY nama_level ASC");

		$data['dt_lu']=$this->m_models->getAll("tb_pengguna where nrp='$nrp' and activity='on' order by id_pengguna desc");
		$data['hak_akses']=$data['dt_lu'][0]->hak_akses;


		$data['provinsi'] = $this->m_models->getTabelOrder("*", "provinsi", "nama", "asc");
		foreach ($data['pegawai'] as $p) { 
			$data['kabupaten'] = $this->m_models->getwhere("*", "kabupaten", "id_prov", $p->prov, "nama", "asc");
			$data['kecamatan'] = $this->m_models->getwhere("*", "kecamatan", "id_kab", $p->kota, "nama", "asc");
			$data['kelurahan'] = $this->m_models->getwhere("*", "kelurahan", "id_kec", $p->kec, "nama", "asc");
		}
		$this->load->view('pegawai/edit_pegawai',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	function updatepegawai(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 

	    if (($id_sekolah=="8") or ($id_sekolah=="13") or ($id_sekolah=="39")){
	    	//$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
			$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$ar=array('status_aktif' => 'on', 'id_sekolah'=>$id_sekolah);
			$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
		}

		
		$jenjang = $this->input->post('jenjang'); 
		$status = $this->input->post('status'); 
		if (($jenjang != "")&&($status != "")){
			if (($jenjang=="all") && ($status=="all")){
				if (($id_sekolah=="8") or ($id_sekolah=="13")){
					$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
				} else {
					$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where (id_sekolah='$id_sekolah' or id_sekolah2='$id_sekolah') order by nama asc");
				}
			} else if (($jenjang!="all") && ($status=="all")){ 
				$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where id_sekolah='$jenjang' or id_sekolah2='$jenjang' order by nama asc");
			} else if (($jenjang=="all") && ($status!="all")){ 
				if (($id_sekolah=="8") or ($id_sekolah=="13")or ($id_sekolah=="39")){
					$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan and status_aktf='$status' order by nama asc");
				} else {
					$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where (id_sekolah='$jenjang' or id_sekolah2='$jenjang') and status_aktf='$status' order by nama asc");
				}
			} else if (($jenjang!="all") && ($status!="all")){
				$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where (id_sekolah='$jenjang' or id_sekolah2='$jenjang') and status_aktf='$status' order by nama asc");
			} 
		}


		//$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
		$this->load->view('pegawai/updatepegawai',$data);
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk simpan data pegawai
	public function update_pegawai(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
        $nip = $this->input->post('nip');
		$nuptk = $this->input->post('nuptk');
		$nrp = $this->input->post('nrp');
		$no_ktp = $this->input->post('no_ktp');
		$nama = addslashes($this->input->post('nama'));
		//$nama = mysql_real_escape_string($this->input->post('nama')); 
		$tmp_lahir = $this->input->post('tmp_lahir');
		$tgl_lahir = $this->input->post('tgl_lahir');
		$jk = $this->input->post('jk');
		$gol_darah = $this->input->post('gol_darah');
		$alamat = $this->input->post('alamat');
		$desa = $this->input->post('desa');
		$kec = $this->input->post('kec');
		$kab = $this->input->post('kab');
		$agama = $this->input->post('agama');
		$status_marital = $this->input->post('status_marital');
		$warganegara = $this->input->post('warganegara');
		$no_hp1 = $this->input->post('no_hp1');
		$no_hp2 = $this->input->post('no_hp2');
		$tgl_masuk = $this->input->post('tgl_masuk');
		$status_aktif = $this->input->post('status_aktif');
		$status_kary = $this->input->post('status_kary');
		$jab = $this->input->post('jab');
		$pangkat = $this->input->post('pangkat');
		$foto = $this->input->post('foto');
		$email = $this->input->post('email');
		$penempatan = $this->input->post('penempatan');
		$penempatan2 = $this->input->post('penempatan2');
		$jab2 = $this->input->post('jab2');

		$ting_pend = $this->input->post('ting_pend');
		$jenjang_pend = $this->input->post('jenjang'.$i);
		for ($i=0; $i<=10; $i++){
			$jenjang = $jenjang_pend[$i];
			//$nm_sekolah = $this->input->post('nm_sekolah'.$jenjang[$i]);
			$nm_sekolah = $this->input->post('nm_sekolah'.$jenjang);
			$kota = $this->input->post('kota'.$jenjang);
			$thn_lulus = $this->input->post('thn_lulus'.$jenjang);
			$fakultas = $this->input->post('fakultas'.$jenjang);
			$jurusan = $this->input->post('jurusan'.$jenjang);
			if (($nm_sekolah != "")){
				$jrpend = $this->m_models->getRows("riwayat_pend_peg where nrp='$nrp' and id_tp='$jenjang'"); 
				if ($jrpend != 0){
					$this->db->query("UPDATE riwayat_pend_peg SET `sekolah`='$nm_sekolah',`kota`='$kota', `thn_lulus`='$thn_lulus',`fakultas`='$fakultas',`jurusan`='$jurusan' WHERE nrp='$nrp' and id_rpend='$jenjang'") or die (mysql_error());
				} else {
					$this->db->query("INSERT INTO riwayat_pend_peg VALUES ('', '$nrp', '$jenjang', '$nm_sekolah', '$kota', '$thn_lulus', '$fakultas', '$jurusan')") or die (mysql_error());
				}
			}
		}
		
		for ($j=1; $j<=5; $j++){
			$periode = $this->input->post('periode'.$j); 
			$tmp_kerja = $this->input->post('tmp_kerja'.$j);
			$posisi = $this->input->post('posisi'.$j);
			$id_pk = $this->input->post('id_pk'.$j);
			$jpeng_kerja = $this->m_models->getRows("peng_kerja join pegawai on pegawai.nrp=peng_kerja.nrp where peng_kerja.id_pk='$id_pk'");
			
			if (($periode != "") && ($tmp_kerja != "") && ($posisi != "")){
				if ($jpeng_kerja != 0){
					$this->db->query("UPDATE peng_kerja SET `periode`='$periode',`tempat`='$tempat', `posisi`='$posisi' WHERE id_pk='$id_pk'") or die (mysql_error());
				} else {
					$this->db->query("INSERT INTO peng_kerja VALUES ('', '$nrp', '$periode', '$tmp_kerja', '$posisi')") or die (mysql_error());
				}
				
			}
		} 

		#level user
		/*$lu=$this->input->post('level_user');
		for ($k=0; $k < count($lu); $k++) { 
			$level_user .= "$lu[$k]+"; 
		}

		if ($level_user != ""){
			$a_lu=array("hak_akses"=>$level_user);
			$data['up_leveluser'] = $this->m_models->update_data($nrp, "nrp", $a_lu, "tb_pengguna");
		}*/
		
		#level user
		$lu=$this->input->post('level_user');
		if($lu!=""){
		for ($k=0; $k < count($lu); $k++) { 
			$level_user .= "$lu[$k]+"; 
		}

		$a_lu=array("hak_akses"=>$level_user);
		$data['up_leveluser'] = $this->m_models->update_data($nrp, "nrp", $a_lu, "tb_pengguna");
		}
		

		//$tgl_masuk_baru = date_db($this->input->post('tgl_masuk_baru'));
		$tgl_masuk_baru = $this->input->post('tgl_masuk_baru');
		$status_pegawai = $this->input->post('status_pegawai');
		$kategori = $this->input->post('kategori');
		$ijazah_terbaru = $this->input->post('ijazah_terbaru');
		//$tgl_ijazah_baru = date_db($this->input->post('tgl_ijazah_baru'));
		$tgl_ijazah_baru = $this->input->post('tgl_ijazah_baru');
		

			//upload foto
			// setting konfigurasi upload
	        $config['upload_path'] = './img_pegawai/';
	        $config['allowed_types'] = 'jpg|png|jpeg|JPG|PNG';
	        $config['image_library']='gd2';
	        $config['source_image']='./img_pegawai/'.$gbr['file_name'];
	        $config['create_thumb']= FALSE;
	       	$config['maintain_ratio']= FALSE;
	        $config['quality']= '50%';
	        $config['width']= 1024;
	        $config['height']= 768;
	        $config['new_image']= './img_pegawai/'.$gbr['file_name'];
	        $this->load->library('image_lib', $config);
	        $this->image_lib->resize();

	        // load library upload
	        $this->load->library('upload', $config);
	        if (!$this->upload->do_upload('gambar')) {
	            $error = $this->upload->display_errors();
	            // menampilkan pesan error
	            //$dt_upd=$this->db->query("UPDATE `pegawai` SET `nuptk`='$nuptk',`nip`='$nip',`nama`='$nama',`tmp_lhr`='$tmp_lahir',`tgl_lhr`='$tgl_lahir',`jk`='$jk',`tgl_masuk`='$tgl_masuk',`alamat`='$alamat',`kel`='$desa',`kec`='$kec',`kota`='$kab',`email`='$email',`st_marital`='$status_marital', `status_aktf`='$status_aktif',`id_jabatan`='$jab',`tlp`='$no_hp1',`pend_akhir`='$ting_pend',`gol_darah`='$gol_darah',`agama`='$agama',`no_ktp`='$no_ktp',`saldo_awal`='0',`skck`='$skck',`ktp`='$ktp',`kk`='$kk',`ijazah`='$ijazah',`kartu_kuning`='$kartu_kuning',`ket_dokter`='$ket_dokter',`npwp`='$npwp',`rekomen_kerja`='$rekomen_kerja',`sertifikat_keahlian`='$sertf_ahli',`warga_negara`='$warganegara',`id_kontrak`='$status_kary',`no_hp2`='$no_hp2',`id_golongan`='$pangkat',`id_sekolah`='$penempatan',`id_jabatan2`='$jab2',`id_sekolah2`='$penempatan2' WHERE nrp='$nrp'") or die (mysql_error());
	            $dt_upd=$this->db->query("UPDATE `pegawai` SET `nuptk`='$nuptk',`nip`='$nip',`nama`='$nama',`tmp_lhr`='$tmp_lahir',`tgl_lhr`='$tgl_lahir',`jk`='$jk',`tgl_masuk`='$tgl_masuk',`alamat`='$alamat',`kel`='$desa',`kec`='$kec',`kota`='$kab',`email`='$email',`st_marital`='$status_marital',`id_jabatan`='$jab',`tlp`='$no_hp1',`pend_akhir`='$ting_pend',`gol_darah`='$gol_darah',`agama`='$agama',`no_ktp`='$no_ktp',`saldo_awal`='0',`skck`='$skck',`ktp`='$ktp',`kk`='$kk',`ijazah`='$ijazah',`kartu_kuning`='$kartu_kuning',`ket_dokter`='$ket_dokter',`npwp`='$npwp',`rekomen_kerja`='$rekomen_kerja',`sertifikat_keahlian`='$sertf_ahli',`warga_negara`='$warganegara',`id_kontrak`='$status_kary',`no_hp2`='$no_hp2',`id_golongan`='$pangkat',`id_sekolah`='$penempatan',`id_jabatan2`='$jab2',`id_sekolah2`='$penempatan2', status_aktf='$status_aktif', tgl_masuk_baru='$tgl_masuk_baru', status_pegawai='$status_pegawai', kategori='$kategori', ijazah_baru='$ijazah_terbaru', tgl_ijazah_baru='$tgl_ijazah_baru' WHERE nrp='$nrp'") or die (mysql_error());

	        } else { 
	            $data_upload = $this->upload->data();
	                $this->image_lib->initialize(array(
	                    'image_library' => 'gd2',
	                    'source_image' => './img_pegawai/'. $data_upload['file_name'],
	                    'maintain_ratio' => false,
	                    'create_thumb' => true,
	                    'quality' => '90%',
	                    'width' => 354,
	                    'height' => 472 
	                ));
	                 
	                if($this->image_lib->resize()){	                     
	                   	//$dt_upd=$this->db->query("UPDATE `pegawai` SET `nuptk`='$nuptk',`nip`='$nip',`nama`='$nama',`tmp_lhr`='$tmp_lahir',`tgl_lhr`='$tgl_lahir',`jk`='$jk',`tgl_masuk`='$tgl_masuk',`alamat`='$alamat',`kel`='$desa',`kec`='$kec',`kota`='$kab',`email`='$email',`foto`='".$data_upload['raw_name'].'_thumb'.$data_upload['file_ext']."',`st_marital`='$status_marital', `status_aktf`='$status_aktif',`id_jabatan`='$jab',`tlp`='$no_hp1',`pend_akhir`='$ting_pend',`gol_darah`='$gol_darah',`agama`='$agama',`no_ktp`='$no_ktp',`saldo_awal`='0',`skck`='$skck',`ktp`='$ktp',`kk`='$kk',`ijazah`='$ijazah',`kartu_kuning`='$kartu_kuning',`ket_dokter`='$ket_dokter',`npwp`='$npwp',`rekomen_kerja`='$rekomen_kerja',`sertifikat_keahlian`='$sertf_ahli',`warga_negara`='$warganegara',`id_kontrak`='$status_kary',`no_hp2`='$no_hp2',`id_golongan`='$pangkat',`id_sekolah`='$penempatan',`id_jabatan2`='$jab2',`id_sekolah2`='$penempatan2' WHERE nrp='$nrp'") or die (mysql_error());
	                   	$dt_upd=$this->db->query("UPDATE `pegawai` SET `nuptk`='$nuptk',`nip`='$nip',`nama`='$nama',`tmp_lhr`='$tmp_lahir',`tgl_lhr`='$tgl_lahir',`jk`='$jk',`tgl_masuk`='$tgl_masuk',`alamat`='$alamat',`kel`='$desa',`kec`='$kec',`kota`='$kab',`email`='$email',`foto`='".$data_upload['raw_name'].'_thumb'.$data_upload['file_ext']."',`st_marital`='$status_marital',`id_jabatan`='$jab',`tlp`='$no_hp1',`pend_akhir`='$ting_pend',`gol_darah`='$gol_darah',`agama`='$agama',`no_ktp`='$no_ktp',`saldo_awal`='0',`skck`='$skck',`ktp`='$ktp',`kk`='$kk',`ijazah`='$ijazah',`kartu_kuning`='$kartu_kuning',`ket_dokter`='$ket_dokter',`npwp`='$npwp',`rekomen_kerja`='$rekomen_kerja',`sertifikat_keahlian`='$sertf_ahli',`warga_negara`='$warganegara',`id_kontrak`='$status_kary',`no_hp2`='$no_hp2',`id_golongan`='$pangkat',`id_sekolah`='$penempatan',`id_jabatan2`='$jab2',`id_sekolah2`='$penempatan2', status_aktf='$status_aktif', tgl_masuk_baru='$tgl_masuk_baru', status_pegawai='$status_pegawai', kategori='$kategori', ijazah_baru='$ijazah_terbaru', tgl_ijazah_baru='$tgl_ijazah_baru' WHERE nrp='$nrp'") or die (mysql_error());

	                } else {
	                    $data['error'] = $this->image_lib->display_errors();
	                }
	        } 
			
		if ($dt_upd == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
        }

		redirect('pegawai/updatepegawai');
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	
	//fungsi untuk resign pegawai
	public function resign(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$this->load->view('pegawai/resign');

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk input resign pegawai
	public function input_resign(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");

	    if (($id_sekolah=="13") or ($id_sekolah=="39")){
	    	$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama");
	    } else {
	    	$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' and nrp= '$nrp' order by nama");
	    }

		
		$this->load->view('pegawai/f_resign',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk simpan resign pegawai
	public function simpan_resign(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nrp = $this->input->post('nrp');
		$tgl_pengajuan = date_db($this->input->post('tgl_pengajuan'));
		$alasan = $this->input->post('alasan');
		$tgl_keluar = date_db($this->input->post('tgl_keluar'));
		
		$this->db->query("INSERT INTO resign VALUES ('','$nrp', '$tgl_pengajuan', '$alasan', '$tgl_keluar', 'Proses', 'Proses', 'Proses')") or die (mysql_error());
		$this->db->query("UPDATE pegawai set status_aktf='Tidak Aktif' where nrp='$nrp'") or die (mysql_error());

		redirect('pegawai/lihat_resign');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	
	//fungsi untuk lihat data resign pegawai
	public function lihat_resign(){
		$this->load->view('template/header');
		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");

		$dari = $this->input->post('dari');
		$sampai = $this->input->post('sampai'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		//$jenjang = $this->input->post('jenjang');
 
		//$data['resign'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan join resign on resign.nrp=pegawai.nrp where pegawai.nrp in (select nrp from resign) and resign.status='Accept' order by tgl_keluar");
		if (($dari != "") && ($sampai != "")){
			//$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Approve', 'id_sekolah'=>$jenjang, 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai);
			$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Approve', 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai);
			$data['resign'] = $this->m_models->getJoin2where("*", "pegawai" , "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "resign", "resign on resign.nrp=pegawai.nrp",$arr,"", "nama","asc"); 
		}
		
		$this->load->view('pegawai/lihat_resign',$data);
		$this->load->view('template/footer');
	}

	public function download_resign_pegawai(){
		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");

		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		if (($dari != "") && ($sampai != "")){
			$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Approve', 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai);
			$data['resign'] = $this->m_models->getJoin2where("*", "pegawai" , "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "resign", "resign on resign.nrp=pegawai.nrp",$arr,"", "nama","asc"); 
		}
		
		$this->load->view('pegawai/download_resign_pegawai',$data);
	}
	
	//fungsi untuk pengajuan data resign pegawai
	public function pengajuan_resign(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp;
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "resign");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");

		$ar_or=array('Approve1' => 'Proses', 'Approve2'=>'Proses', 'Approve3'=>'Proses');
		//$data['p_cuti']=$this->m_models->getTabelAOrWhere("*", "resign", $ar_or, "tgl_pengajuan", "asc");
		$data['p_cuti']=$this->m_models->getAll("resign where approve1 != 'Reject' or approve2 != 'Reject' or approve3 != 'Reject' or approve3 != 'Approve' order by tgl_pengajuan asc");
		foreach ($data['p_cuti'] as $pc){
			$id_sekolah=all("pegawai", "nrp", $pc->nrp, "id_sekolah");
			$nrp_cuti=$pc->nrp; 
			$alurApp[$nrp_cuti]=$this->m_models->alurApp($hak_akses, "resign", $id_sekolah);
			/*if ($alurApp[$nrp_cuti]=="approve1"){
				$arr=array('Approve1' => 'Proses', 'nrp'=>$nrp_cuti);
			} else if ($alurApp[$nrp_cuti]=="approve2"){
				$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'nrp'=>$nrp_cuti);
			} else if ($alurApp[$nrp_cuti]=="approve3"){
				$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'nrp'=>$nrp_cuti);
			} */

			if ($hak_akses==4){
				if ($alurApp[$nrp_cuti]=="approve1"){
					$arr=array('Approve1' => 'Proses', 'resign.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				} else if ($alurApp[$nrp_cuti]=="approve2"){
					$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'resign.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				} else if ($alurApp[$nrp_cuti]=="approve3"){
					$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'resign.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				}
			} else {
				if ($alurApp[$nrp_cuti]=="approve1"){
					$arr=array('Approve1' => 'Proses', 'resign.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				} else if ($alurApp[$nrp_cuti]=="approve2"){
					$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'resign.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				} else if ($alurApp[$nrp_cuti]=="approve3"){
					$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'resign.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				}
			}
			//$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "resign", $arr, "tgl_pengajuan", "asc");
			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "resign", "pegawai", "pegawai.nrp=resign.nrp", $arr, "tgl_pengajuan", "asc");

			foreach ($data['peng_cuti'] as $pc) {
				$n++;
				$data['id_resign'][]=$pc->id_resign;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
				$data['alasan'][]=$pc->alasan;
				$data['tgl_keluar'][]=$pc->tgl_keluar;
			}
			$data['n']=$n;
		}
		
		
		$this->load->view('pegawai/pengajuan_resign',$data);
		$this->load->view('template/footer');
	}
	
	public function app_pengajuan_resign(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_jab_app=all("pegawai", "nrp", $nrp, "id_jabatan");
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$hariini=date("Y-m-d");
		$time=date("H:i:s");


        $id_resign = $this->input->post('id_resign', TRUE);
        $ket = $this->input->post('ket', TRUE); 
        $alasan = $this->input->post('alasan', TRUE); 

		$arr=array('id_resign' => $id_resign);
		$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "resign", $arr, "tgl_pengajuan", "asc");
		$id_sekolah=all("pegawai", "nrp", $data['peng_cuti'][0]->nrp, "id_sekolah");
		$ar=array('id_sekolah' => $id_sekolah, 'pengajuan'=>"resign");
		$data['app_pengajuan'] = $this->m_models->getTabelwhere("*", "approval_pengajuan", $ar, "id_app", "asc");
		$id_ap=$data['app_pengajuan'][0]->id_ap; 

		$alur=$this->m_models->cekAlurApp($hak_akses, "resign");
		$cekalur = $this->m_models->cekAlurAppNext($hak_akses, "resign", $alur, $id_sekolah); 
		if ($ket == "A"){
			$k="Approve";
			if ($cekalur==0){
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve', 'Approve2' => 'Approve','Approve3' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve', 'Approve3' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			} else {
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			}
		} else if ($ket == "R"){
			$k="Reject";
			if ($alur == "approve1"){
				$ar_app=array('Approve1' => 'Reject');
			} else if ($alur == "approve2"){
				$ar_app=array('Approve2' => 'Reject');
			} else if ($alur == "approve3"){
				$ar_app=array('Approve3' => 'Reject');
			} 
		}

		//update pengajuan resign
		$data['update_data'] = $this->m_models->update_data($id_resign, "id_resign", $ar_app, "resign");
		$update=$this->db->query("update pegawai set status_aktf='Tidak Aktif' where nrp in (select nrp from resign where id_resign='$id_resign')");
			
		//menambahkan ke history update
		$j_cuti = array('tgl'=>$hariini, 'waktu' => $time, 'nrp' => $nrp, 'id_ap' => $id_ap, 'id_pengajuan' => $id_resign, 'status'=>$k, 'keterangan'=>$alasan, 'id_jabatan'=>$id_jab_app, 'level_app'=>$alur);
		if ($this->m_models->save_data($j_cuti, 'approval_history') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil di'.$k.' ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}

		redirect('pegawai/pengajuan_resign');
		$this->load->view('template/footer');
	}
	
	//fungsi untuk pelatihan
	public function pelatihan(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$this->load->view('pegawai/pelatihan');

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk input pelatihan pegawai
	public function input_pelatihan(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama");
		$this->load->view('pegawai/f_pelatihan',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk simpan pelatihan pegawai
	public function simpan_pelatihan(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nrp = $this->input->post('nrp');
		$tgl_pengajuan = date_db($this->input->post('tgl_pengajuan'));
		$nama_lembaga = $this->input->post('nama_lembaga');
		$tmp_lembaga = $this->input->post('tmp_lembaga');
		$alamat = $this->input->post('alamat');
		$tgl_mulai = date_db($this->input->post('tgl_mulai'));
		$tgl_selesai = date_db($this->input->post('tgl_selesai'));
		$nama_pelatihan = $this->input->post('nama_pelatihan');
		$no_sertifikat = $this->input->post('no_sertifikat');
		
		$this->db->query("INSERT INTO pelatihan VALUES ('','$nrp', '$tgl_pengajuan', '$nama_lembaga', '$tmp_lembaga', '$alamat', '$tgl_mulai', '$tgl_selesai', '$nama_pelatihan', '$no_sertifikat')") or die (mysql_error());

		redirect('pegawai/lihat_pelatihan');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	
	//fungsi untuk lihat data pelatihan pegawai
	public function lihat_pelatihan(){
		$this->load->view('template/header');
		$dari = $this->input->post('dari');
		$sampai = $this->input->post('sampai');

		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$ar = array('tgl_pengajuan >=' => $dari, 'tgl_pengajuan <='=>$sampai);
			$data['pelatihan'] = $this->m_models->getJoin1where("*", "pelatihan", "pegawai", "pegawai.nrp=pelatihan.nrp", $ar, "tgl_mulai_ps", "asc");
		}

		$this->load->view('pegawai/lihat_pelatihan',$data);
		$this->load->view('template/footer');
	}

	public function download_pelatihan(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);

		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$ar = array('tgl_pengajuan >=' => $dari, 'tgl_pengajuan <='=>$sampai);
			$data['pelatihan'] = $this->m_models->getJoin1where("*", "pelatihan", "pegawai", "pegawai.nrp=pelatihan.nrp", $ar, "tgl_mulai_ps", "asc");
		}
		$this->load->view('pegawai/download_pelatihan',$data);
	}
	
	
	//fungsi untuk mutasi
	public function mutasi(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$this->load->view('pegawai/mutasi');

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk input mutasi pegawai
	public function form_mutasi(){
        $data['jabatan'] = $this->m_models->getAll('jabatan');
        $data['penempatan'] = $this->m_models->getAll('sekolah order by nama');
		$this->load->view('pegawai/form_mutasi',$data);
	}
	
	public function input_mutasi(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama");
        $data['jabatan'] = $this->m_models->getAll('jabatan');
        $data['penempatan'] = $this->m_models->getAll('sekolah order by nama');
		$this->load->view('pegawai/f_mutasi',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	//fungsi untuk simpan mutasi pegawai
	public function simpan_mutasi(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nrp = $this->input->post('nrp');
		$jenis_mutasi = $this->input->post('jenis_mutasi');
		$t_mutasi = $this->input->post('tmp_mutasi');
		$j_mutasi = $this->input->post('jab_mutasi');
		$tgl_pengajuan = date_db($this->input->post('tgl_pengajuan'));
		$alasan = $this->input->post('alasan');
		
		$data['pegawai'] = $this->m_models->getAll("pegawai where nrp='$nrp' order by nama");
		$tmp_asal=$data['pegawai'][0]->id_sekolah;
		$jab_asal=$data['pegawai'][0]->id_jabatan;
		
		if (($t_mutasi=="") && ($j_mutasi!="")){
			$jab_mutasi=$j_mutasi;
			$tmp_mutasi=$tmp_asal;
		} else if (($t_mutasi!="") && ($j_mutasi=="")){
			$jab_mutasi=$jab_asal;
			$tmp_mutasi=$t_mutasi;
		} else if (($t_mutasi!="") && ($j_mutasi!="")){
			$jab_mutasi=$j_mutasi;
			$tmp_mutasi=$t_mutasi;
		} 
		$this->db->query("INSERT INTO mutasi_pegawai VALUES ('','$nrp', '$jenis_mutasi', '$tmp_asal', '$jab_asal', '$tmp_mutasi', '$jab_mutasi', '$_SESSION[nrp]', 'Proses', 'Proses', 'Proses', 'Proses', '$tgl_pengajuan','0000-00-00','$alasan','')") or die (mysql_error());

		redirect('pegawai/lihat_mutasi');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	
	//fungsi untuk lihat data mutasi pegawai
	public function lihat_mutasi(){
		$this->load->view('template/header');
		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");

		$dari = $this->input->post('dari');
		$sampai = $this->input->post('sampai'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		//$jenjang = $this->input->post('jenjang');
		if (($dari != "") && ($sampai != "")){
			//$data['mutasi'] = $this->m_models->getDataJoin("mutasi_pegawai.*, pegawai.*, jabatan.*, sekolah.id_sekolah, sekolah.nama as nm_sekolah","mutasi_pegawai","join pegawai on pegawai.nrp=mutasi_pegawai.nrp join sekolah on sekolah.id_sekolah=mutasi_pegawai.tmp_asal join jabatan on jabatan.id_jabatan=mutasi_pegawai.jabatan_asal where approve1='Approve' and approve2='Approve' and approve3='Approve' and pegawai.id_sekolah=$jenjang and proses_mutasi='Selesai' and tgl_pengajuan >= '$dari' and tgl_pengajuan <= '$sampai' ");
			$data['mutasi'] = $this->m_models->getDataJoin("mutasi_pegawai.*, pegawai.*, jabatan.*, sekolah.id_sekolah, sekolah.nama as nm_sekolah","mutasi_pegawai","join pegawai on pegawai.nrp=mutasi_pegawai.nrp join sekolah on sekolah.id_sekolah=mutasi_pegawai.tmp_asal join jabatan on jabatan.id_jabatan=mutasi_pegawai.jabatan_asal where approve1='Approve' and approve2='Approve' and approve3='Approve' and proses_mutasi='Selesai' and tgl_pengajuan >= '$dari' and tgl_pengajuan <= '$sampai' ");
			foreach ($data['mutasi'] as $mts){
				$tmp_asal=all("sekolah", "id_sekolah", $mts->tmp_asal, "nama");
				$jab_asal=all("jabatan", "id_jabatan", $mts->jabatan_asal, "nama_jabatan");
				$tmp_tujuan=all("sekolah", "id_sekolah", $mts->tmp_mutasi, "nama");
				$jab_tujuan=all("jabatan", "id_jabatan", $mts->jab_mutasi, "nama_jabatan");
				
				$data['arr']=array("$mts->nrp", "$mts->nama", "$tmp_asal", "$jab_asal", "$tmp_tujuan", "$jab_tujuan", "$mts->tgl_pengajuan", "$mts->tgl_pindah", "$mts->alasan", "$mts->no_sk");
			}
		}
		
		$this->load->view('pegawai/lihat_mutasi',$data);
		$this->load->view('template/footer');
	}

	public function download_mutasi(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		if (($dari != "") && ($sampai != "")){
			//$data['mutasi'] = $this->m_models->getDataJoin("mutasi_pegawai.*, pegawai.*, jabatan.*, sekolah.id_sekolah, sekolah.nama as nm_sekolah","mutasi_pegawai","join pegawai on pegawai.nrp=mutasi_pegawai.nrp join sekolah on sekolah.id_sekolah=mutasi_pegawai.tmp_asal join jabatan on jabatan.id_jabatan=mutasi_pegawai.jabatan_asal where approve1='Approve' and approve2='Approve' and approve3='Approve' and pegawai.id_sekolah=$jenjang and proses_mutasi='Selesai' and tgl_pengajuan >= '$dari' and tgl_pengajuan <= '$sampai' ");
			$data['mutasi'] = $this->m_models->getDataJoin("mutasi_pegawai.*, pegawai.*, jabatan.*, sekolah.id_sekolah, sekolah.nama as nm_sekolah","mutasi_pegawai","join pegawai on pegawai.nrp=mutasi_pegawai.nrp join sekolah on sekolah.id_sekolah=mutasi_pegawai.tmp_asal join jabatan on jabatan.id_jabatan=mutasi_pegawai.jabatan_asal where approve1='Approve' and approve2='Approve' and approve3='Approve' and proses_mutasi='Selesai' and tgl_pengajuan >= '$dari' and tgl_pengajuan <= '$sampai' ");
			foreach ($data['mutasi'] as $mts){
				$tmp_asal=all("sekolah", "id_sekolah", $mts->tmp_asal, "nama");
				$jab_asal=all("jabatan", "id_jabatan", $mts->jabatan_asal, "nama_jabatan");
				$tmp_tujuan=all("sekolah", "id_sekolah", $mts->tmp_mutasi, "nama");
				$jab_tujuan=all("jabatan", "id_jabatan", $mts->jab_mutasi, "nama_jabatan");
				
				$data['arr']=array("$mts->nrp", "$mts->nama", "$tmp_asal", "$jab_asal", "$tmp_tujuan", "$jab_tujuan", "$mts->tgl_pengajuan", "$mts->tgl_pindah", "$mts->alasan", "$mts->no_sk");
			}
		}
		
		$this->load->view('pegawai/download_mutasi',$data);
	}
	
	public function pengajuan_mutasi(){
		$this->load->view('template/header');
		$id_sekolah_usr=$this->m_models->getSession($nrp, "id_sekolah");
		//$data['mutasi'] = $this->m_models->getDataJoin("mutasi_pegawai.*, pegawai.*, jabatan.*, sekolah.id_sekolah, sekolah.nama as nm_sekolah","mutasi_pegawai","join pegawai on pegawai.nrp=mutasi_pegawai.nrp join sekolah on sekolah.id_sekolah=mutasi_pegawai.tmp_asal join jabatan on jabatan.id_jabatan=mutasi_pegawai.jabatan_asal where app1='Proses'");
		if ($id_sekolah_usr=="8"){
			$arr=array('approve1' => 'Approve', 'approve2'=>'Proses');
			$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "mutasi_pegawai", $arr, "tgl_pengajuan", "asc");
		} else if (($id_sekolah_usr=="13")or ($id_sekolah_usr=="39")){
			$data['mutasi'] = $this->m_models->getwhere("*", "mutasi_pegawai", "approve1", 'Proses', "tgl_pengajuan", "asc");
		}
	    
		$this->load->view('pegawai/pengajuan_mutasi',$data);
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function app_pengajuan_mutasi(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$id_sekolah_usr=$this->m_models->getSession($nrp, "id_sekolah");
		$id_mutasi = $this->uri->segment(3);
		$ket = $this->uri->segment(4); 
		if ($ket=="A"){
			$update=$this->db->query("update mutasi_pegawai set app1='Approve' where id_mp='$id_mutasi'");
		} else if ($ket=="R"){
			$update=$this->db->query("update mutasi_pegawai set app1='Batal' where id_mp='$id_mutasi'");
		}

		if ($id_sekolah_usr=="8"){
			//menambahkan ke history update

			$data['m'] = $this->m_models->getwhere("*", "mutasi_pegawai", "id_mp", $id_mutasi);
			$arkary=array('id_jabatan' =>$data['m'][0]->jab_mutasi, 'id_sekolah'=>$data['m'][0]->tmp_mutasi);
			$dt_kar=$this->m_models->update_data($data['m'][0]->nrp, "nrp", $arkary, "pegawai");
			$arrwhere=array('approve2' =>'Approve');
			if ($this->m_models->update_data($id_mutasi, "id_mp", $arrwhere, "mutasi_pegawai") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil di Approve ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		} else if (($id_sekolah_usr=="13")or ($id_sekolah_usr=="39")){
			//menambahkan ke history update
			$arrwhere=array('approve1' =>'Approve');
			if ($this->m_models->update_data($id_mutasi, "id_mp", $arrwhere, "mutasi_pegawai") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil di Approve ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}

			
		
		redirect('pegawai/pengajuan_mutasi');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	//kenaikan pangkat
	public function naik_pangkat(){
		$this->load->view('template/header');
		$this->load->view('pegawai/kenaikan_pangkat');
		$this->load->view('template/footer');
	}

	public function pengajuan_pangkat(){
		$this->load->view('template/header');
		$where=array('pegawai.status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getJoin1where("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "sekolah", "pegawai.id_sekolah=sekolah.id_sekolah", $where, "pegawai.nama", "asc");
		$data['golongan'] = $this->m_models->getTabelOrder("*", "golongan", "golongan", "asc");

		$hariini=date("Y-m-d");
		$tgldari = $this->input->post('tgldari');
		$tglke = $this->input->post('tglke');
		$pegawai = $this->input->post('pegawai');
		$penilai = $this->input->post('penilai');
		$atasan_penilai = $this->input->post('atasan_penilai');
		$golongan = $this->input->post('golongan');
		$masa_kerja = $this->input->post('masa_kerja');
		$kesetiaan = $this->input->post('kesetiaan');
		$prestasi_kerja = $this->input->post('prestasi_kerja');
		$tanggung_jawab = $this->input->post('tanggung_jawab');
		$ketaatan = $this->input->post('ketaatan');
		$kejujuran = $this->input->post('kejujuran');
		$kerjasama = $this->input->post('kerjasama');
		$prakarsa = $this->input->post('prakarsa');
		$kepemimpinan = $this->input->post('kepemimpinan');
		$jml_nilai=$kesetiaan+$prestasi_kerja+$tanggung_jawab+$ketaatan+$kejujuran+$kerjasama+$prakarsa+$kepemimpinan;
		$rata2nilai=$jml_nilai/8;

		if (($tgldari != "") && ($tglke != "") && ($pegawai != "") && ($penilai != "") && ($atasan_penilai != "") && ($golongan != "") && ($prestasi_kerja != "")){
			$data['golpeg'] = $this->m_models->getwhere("*", "pegawai", "nrp", $pegawai);
			$golawal=$data['golpeg'][0]->id_golongan;
			$naik_pangkat = array('tgl_penilaian_awal' => $tgldari, 'tgl_penilaian_akhir' => $tglke, 'nrp' => $pegawai, '	tgl_pengajuan' => $hariini, 'id_golongan_dari' => $golawal, 'id_golongan_ke' => $golongan, 'masa_kerja' => $masa_kerja, 'id_penilai' => $penilai, 'status_penilai' => "Proses", 'tgl_penilai' => "0000-00-00", 'id_atasan_penilai' => $atasan_penilai, 'status_atasan_penilai' => "Proses", 'status_kenaikan_pangkat' => "Proses" );
			$data['simpan_kenaikan'] = $this->m_models->save_data($naik_pangkat, "kenaikan_pangkat");


			$arraywhere=array('tgl_penilaian_awal =' => $tgldari, 'tgl_penilaian_akhir =' => $tglke, 'nrp =' => $pegawai, '	tgl_pengajuan =' => $hariini, 'id_golongan_dari =' => $golawal, 'id_golongan_ke =' => $golongan, 'masa_kerja =' => $masa_kerja, 'id_penilai =' => $penilai, 'status_penilai =' => "Proses", 'tgl_penilai =' => "0000-00-00", 'id_atasan_penilai =' => $atasan_penilai, 'status_atasan_penilai =' => "Proses", 'status_kenaikan_pangkat =' => "Proses");
			$data['npangkat'] = $this->m_models->getTabelwhere("*", "kenaikan_pangkat", $arraywhere, "nrp", "asc");
			$id_kenaikan_pangkat=$data['npangkat'][0]->id_kenaikan_pangkat;
			$nilai = array('id_kenaikan_pangkat' => $id_kenaikan_pangkat, 'kesetiaan' => $kesetiaan, 'prestasi_kerja' => $prestasi_kerja, '	tanggung_jawab' => $tanggung_jawab, 'ketaatan' => $ketaatan, 'kejujuran' => $kejujuran, 'kerjasama' => $kerjasama, 'prakarsa' => $prakarsa, 'kepemimpinan' => $kepemimpinan, 'jml_nilai' => $jml_nilai, 'ratarata_nilai' => $rata2nilai);
			$data['simpan_kenaikan'] = $this->m_models->save_data($nilai, "penilaian");
			redirect('pegawai/pengajuan_pangkat');
		} else {
			$this->load->view('pegawai/pengajuan_pangkat',$data);
		}
		$this->load->view('template/footer');
	}
		
	public function app_penilai_pangkat(){
		$this->load->view('template/header');
		$nrp_penilai=$this->session->userdata['nrp'];
		$arraywhere=array('status_penilai =' => "Proses", 'id_penilai =' => $nrp_penilai, 'status_kenaikan_pangkat =' => "Proses");
		$data['k_pangkat'] = $this->m_models->getJoin2where("*", "kenaikan_pangkat", "penilaian", "penilaian.id_kenaikan_pangkat=kenaikan_pangkat.id_kenaikan_pangkat","pegawai", "pegawai.nrp=kenaikan_pangkat.nrp", $arraywhere, "", 
		 "tgl_pengajuan", "asc");
		$id_jabatan=$data['k_pangkat'][0]->id_jabatan;
		$id_sekolah=$data['k_pangkat'][0]->id_sekolah; 
		$id_golongan=$data['k_pangkat'][0]->id_golongan_dari;
		$id_golongan_ke=$data['k_pangkat'][0]->id_golongan_ke;
		$id_penilai=$data['k_pangkat'][0]->id_penilai;		
		$id_atasan_penilai=$data['k_pangkat'][0]->id_atasan_penilai;
		$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $id_jabatan);
		$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $id_sekolah);
		$data['golongan'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $id_golongan);
		$data['gol_tuj'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $id_golongan_ke);
		$wherepenilai=array('nrp =' => $id_penilai);
		$data['penilai'] = $this->m_models->getJoin2where("pegawai.*, jabatan.nama_jabatan, sekolah.nama as nm_sekolah", "pegawai", "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "sekolah", "sekolah.id_sekolah=pegawai.id_sekolah", $wherepenilai, "", "nama", "asc");
		$data['gol_tuj'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $id_golongan_ke);
		$arr = array('jabatan' => $data['jabatan'][0]->nama_jabatan, 'sekolah' => $data['sekolah'][0]->nama);

		//update data
		$id_kenaikan_pangkat = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		if ($id_kenaikan_pangkat != ""){
			$hariini=date("Y-m-d");
			if ($ket=="S"){
				$arrwhere=array('status_penilai' =>'Setuju', 'tgl_penilai' => $hariini);
			} else {
				$arrwhere=array('status_penilai' =>'Tolak', 'tgl_penilai' => $hariini);
			}
			$data['update_data'] = $this->m_models->update_data($id_kenaikan_pangkat, "id_kenaikan_pangkat", $arrwhere, "kenaikan_pangkat");
			redirect('pegawai/app_penilai_pangkat');
		} else {
			$this->load->view('pegawai/app_penilai_pangkat', $data);
		}
		
		$this->load->view('template/footer');
	}

	public function app_atasan_penilai_pangkat(){
		$this->load->view('template/header');
		$nrp_penilai=$this->session->userdata['nrp'];
		$arraywhere=array('status_penilai =' => "Setuju", 'id_atasan_penilai =' => $nrp_penilai, 'status_kenaikan_pangkat =' => "Proses", 'status_atasan_penilai' => "Proses");
		$data['k_pangkat'] = $this->m_models->getJoin2where("*", "kenaikan_pangkat", "penilaian", "penilaian.id_kenaikan_pangkat=kenaikan_pangkat.id_kenaikan_pangkat","pegawai", "pegawai.nrp=kenaikan_pangkat.nrp", $arraywhere, "",  "tgl_pengajuan", "asc");
		$id_jabatan=$data['k_pangkat'][0]->id_jabatan;
		$id_sekolah=$data['k_pangkat'][0]->id_sekolah; 
		$id_golongan=$data['k_pangkat'][0]->id_golongan_dari;
		$id_golongan_ke=$data['k_pangkat'][0]->id_golongan_ke;
		$id_atasan_penilai=$data['k_pangkat'][0]->id_atasan_penilai;
		$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $id_jabatan);
		$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $id_sekolah);
		$data['golongan'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $id_golongan);
		$data['gol_tuj'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $id_golongan_ke);
		$wherepenilai=array('nrp =' => $id_atasan_penilai);
		$data['penilai'] = $this->m_models->getJoin2where("pegawai.*, jabatan.nama_jabatan, sekolah.nama as nm_sekolah", "pegawai", "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "sekolah", "sekolah.id_sekolah=pegawai.id_sekolah", $wherepenilai, "", "nama", "asc");
		$data['gol_tuj'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $id_golongan_ke);
		$arr = array('jabatan' => $data['jabatan'][0]->nama_jabatan, 'sekolah' => $data['sekolah'][0]->nama);

		//update data
		$id_kenaikan_pangkat = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		if ($id_kenaikan_pangkat != ""){
			$hariini=date("Y-m-d");
			if ($ket=="S"){
				$arrwhere=array('status_atasan_penilai' =>'Setuju', 'tgl_persetujuan' => $hariini);
			} else {
				$arrwhere=array('status_atasan_penilai' =>'Tolak', 'tgl_persetujuan' => $hariini);
			}
			$data['update_data'] = $this->m_models->update_data($id_kenaikan_pangkat, "id_kenaikan_pangkat", $arrwhere, "kenaikan_pangkat");
			redirect('pegawai/app_atasan_penilai_pangkat');
		} else {
			$this->load->view('pegawai/app_atasan_penilai_pangkat', $data);
		}
		$this->load->view('template/footer');
	}

	public function data_kenaikan_pangkat(){
		$this->load->view('template/header');
		$nrp_penilai=$this->session->userdata['nrp'];

		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");

		$dari = $this->input->post('dari');
		$sampai = $this->input->post('sampai'); 
		$jenjang = $this->input->post('jenjang');

		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[jenjang]=$jenjang;
		if (($dari != "") && ($sampai != "") && ($jenjang != "")){
			if ($jenjang=="all"){
				$arraywhere=array('status_penilai =' => "Setuju", 'status_kenaikan_pangkat =' => "Setuju", 'status_atasan_penilai' => "Setuju", 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai);
			} else {
				$arraywhere=array('status_penilai =' => "Setuju", 'status_kenaikan_pangkat =' => "Setuju", 'status_atasan_penilai' => "Setuju", 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai, 'pegawai.id_sekolah'=>$jenjang);
			}
			
			
			$data['k_pangkat'] = $this->m_models->getJoin2where("*", "kenaikan_pangkat", "penilaian", "penilaian.id_kenaikan_pangkat=kenaikan_pangkat.id_kenaikan_pangkat","pegawai", "pegawai.nrp=kenaikan_pangkat.nrp", $arraywhere, "",  "tgl_pengajuan", "asc");
			foreach ($data['k_pangkat'] as $kp) {
				$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $kp->id_jabatan);
				$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $kp->id_sekolah);
				$data['golongan'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $kp->id_golongan_dari);
				$data['gol_tuj'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $kp->id_golongan_ke);
				$wherepenilai=array('nrp =' => $kp->id_penilai);
				$data['penilai'] = $this->m_models->getJoin2where("pegawai.*, jabatan.nama_jabatan, sekolah.nama as nm_sekolah", "pegawai", "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "sekolah", "sekolah.id_sekolah=pegawai.id_sekolah", $wherepenilai, "",  "nama", "asc");
				$whereatasanpenilai=array('nrp =' => $kp->id_atasan_penilai);
				$data['atasan_penilai'] = $this->m_models->getJoin2where("pegawai.*, jabatan.nama_jabatan, sekolah.nama as nm_sekolah", "pegawai", "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "sekolah", "sekolah.id_sekolah=pegawai.id_sekolah", $whereatasanpenilai, "", "nama", "asc");
				$arr = array('jabatan' => $data['jabatan'][0]->nama_jabatan, 'sekolah' => $data['sekolah'][0]->nama);
			}
		}
		$this->load->view('pegawai/data_kenaikan_pangkat', $data);
		$this->load->view('template/footer');
	}

	public function download_kenaikan_pangkat(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$jenjang = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[jenjang]=$jenjang;
		if (($dari != "") && ($sampai != "") && ($jenjang != "")){
			$arraywhere=array('status_penilai =' => "Setuju", 'status_kenaikan_pangkat =' => "Setuju", 'status_atasan_penilai' => "Setuju", 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai, 'pegawai.id_sekolah'=>$jenjang);
			$data['k_pangkat'] = $this->m_models->getJoin2where("*", "kenaikan_pangkat", "penilaian", "penilaian.id_kenaikan_pangkat=kenaikan_pangkat.id_kenaikan_pangkat","pegawai", "pegawai.nrp=kenaikan_pangkat.nrp", $arraywhere, "",  "tgl_pengajuan", "asc");
			foreach ($data['k_pangkat'] as $kp) {
				$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $kp->id_jabatan);
				$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $kp->id_sekolah);
				$data['golongan'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $kp->id_golongan_dari);
				$data['gol_tuj'] = $this->m_models->getwhere("*", "golongan", "id_golongan", $kp->id_golongan_ke);
				$wherepenilai=array('nrp =' => $kp->id_penilai);
				$data['penilai'] = $this->m_models->getJoin2where("pegawai.*, jabatan.nama_jabatan, sekolah.nama as nm_sekolah", "pegawai", "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "sekolah", "sekolah.id_sekolah=pegawai.id_sekolah", $wherepenilai, "",  "nama", "asc");
				$whereatasanpenilai=array('nrp =' => $kp->id_atasan_penilai);
				$data['atasan_penilai'] = $this->m_models->getJoin2where("pegawai.*, jabatan.nama_jabatan, sekolah.nama as nm_sekolah", "pegawai", "jabatan", "jabatan.id_jabatan=pegawai.id_jabatan", "sekolah", "sekolah.id_sekolah=pegawai.id_sekolah", $whereatasanpenilai, "", "nama", "asc");
				$arr = array('jabatan' => $data['jabatan'][0]->nama_jabatan, 'sekolah' => $data['sekolah'][0]->nama);
			}
		}
		$this->load->view('pegawai/download_kenaikan_pangkat', $data);
	}
	
	public function input_k_keluarga(){
		$this->load->view('template/header');
		$where=array('pegawai.status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getJoin1where("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "sekolah", "pegawai.id_sekolah=sekolah.id_sekolah", $where, "pegawai.nama", "asc");

		$data['tingkat_pend'] = $this->m_models->getAll('tingkat_pendidikan');
		$data['profesi'] = $this->m_models->getAll('profesi');

		//input kartu keluarga
		$nrp = $this->input->post('pegawai');
		$jml_anggota = $this->input->post('jml_anggota'); 
		$no_kk = $this->input->post('no_kk'); 
		$blok_kk = $this->input->post('blok_kk'); 
		$rt_kk = $this->input->post('rt_kk'); 
		$rw_kk = $this->input->post('rw_kk'); 
		$desa_kk = $this->input->post('desa_kk'); 
		$kec_kk = $this->input->post('kec_kk'); 
		$kab_kk = $this->input->post('kab_kk'); 
		$kode_pos_kk = $this->input->post('kode_pos_kk'); 
		$provinsi_kk = $this->input->post('provinsi_kk');  
		if (($nrp != "") && ($jml_anggota != "") && ($no_kk != "") && ($blok_kk != "") && ($rt_kk != "") && ($rw_kk != "") && ($desa_kk != "") && ($kec_kk != "") && ($kab_kk != "") && ($kode_pos_kk != "") && ($provinsi_kk != "")){
			for ($a=1; $a<=$jml_anggota; $a++){ 
				$no_penduduk_kk = $this->input->post('no_penduduk_kk'.$a); 
				$nama_kk = $this->input->post('nama_kk'.$a); 
				$tmp_lahir_kk = $this->input->post('tmp_lahir_kk'.$a); 
				$tgl_lahir_kk = $this->input->post('tgl_lahir_kk'.$a); 
				$jk_kk = $this->input->post('jk_kk'.$a); 
				$agama_kk = $this->input->post('agama_kk'.$a); 
				$pend_kk = $this->input->post('pend_kk'.$a); 
				$pekerjaan_kk = $this->input->post('pekerjaan_kk'.$a); 
				$status_marital_kk = $this->input->post('status_marital_kk'.$a); 
				$hub_kk = $this->input->post('hub_kk'.$a); 
				$warganegara_kk = $this->input->post('warganegara_kk'.$a); 
				$paspor_kk = $this->input->post('paspor_kk'.$a); 
				$kitas_kk = $this->input->post('kitas_kk'.$a); 
				$ayah_kk = $this->input->post('ayah_kk'.$a); 
				$ibu_kk = $this->input->post('ibu_kk'.$a); 
				$keadaan_kk = $this->input->post('keadaan_kk'.$a); 
				$anggota_kk = $this->input->post('anggota_kk'.$a); 
				
				$this->db->query("INSERT INTO kartu_keluarga VALUES ('', '$no_penduduk_kk', '$no_kk', '$nrp', '$nama_kk','$blok_kk', '$rt_kk', '$rw_kk', '$desa_kk', '$kec_kk', '$kab_kk', '$kode_pos_kk', '$provinsi_kk', '$jk_kk', '$tmp_lahir_kk', '$tgl_lahir_kk', '$agama_kk', '$pend_kk', '$pekerjaan_kk', '$status_marital_kk', '$hub_kk',  '$warganegara_kk', '$paspor_kk', '$kitas_kk', '$ayah_kk', '$ibu_kk', '$keadaan_kk', now(), now(), '$anggota_kk', 'Aktif')") or die (mysql_error());
			}
			redirect('pegawai/lihat_pegawai');
		} else {
			$this->load->view('pegawai/input_k_keluarga',$data);
		}
		$this->load->view('template/footer');
	}

	public function pembaharuan_kk(){
		$this->load->view('template/header');
		$where=array('pegawai.status_aktf =' => "Aktif", 'status_kk =' => 'Aktif');
		//$data['pegawai'] = $this->m_models->getJoin2where("pegawai.*, sekolah.nama as nm_sekolah, kartu_keluarga.*", "pegawai", "sekolah", "pegawai.id_sekolah=sekolah.id_sekolah","kartu_keluarga", "kartu_keluarga.nikk=pegawai.no_ktp", $where, "", "pegawai.nrp", "asc");
		$data['pegawai'] = $this->m_models->get_data("pegawai.*, sekolah.nama as nm_sekolah, kartu_keluarga.*", "pegawai", " join sekolah on pegawai.id_sekolah=sekolah.id_sekolah join kartu_keluarga on kartu_keluarga.nikk=pegawai.no_ktp where pegawai.status_aktf ='Aktif' and status_kk='Aktif' group by kartu_keluarga.no_kk order by pegawai.nrp asc");
		
			//redirect('pegawai/lihat_pegawai');
			$this->load->view('pegawai/pembaharuan_kk',$data);
		$this->load->view('template/footer');
	}

	public function form_pembaharuan_kk(){
		$nrp = $this->input->get('nrp'); 
		$data['k_keluarga'] = $this->m_models->getwhereGroup("*", "kartu_keluarga", "nrp", $nrp, "no_kk", "no_urut", "asc");
		foreach ($data['k_keluarga'] as $kk) {
			$data['kartu_keluarga'] = $this->m_models->getwhere("*", "kartu_keluarga", "no_kk", $kk->no_kk, "no_urut", "asc");
			$data['tingkat_pend'] = $this->m_models->getAll('tingkat_pendidikan');
			$data['profesi'] = $this->m_models->getAll('profesi');
		} 
		$this->load->view('pegawai/form_pembaharuan_kk',$data);
	}
	
	public function update_kk(){
		$this->load->view('template/header');
		$nrp = $this->input->post('pegawai');
		$jml_anggota = $this->input->post('jml_anggota'); 
		$no_kk = $this->input->post('no_kk'); 
		$blok_kk = $this->input->post('blok_kk'); 
		$rt_kk = $this->input->post('rt_kk'); 
		$rw_kk = $this->input->post('rw_kk'); 
		$desa_kk = $this->input->post('desa_kk'); 
		$kec_kk = $this->input->post('kec_kk'); 
		$kab_kk = $this->input->post('kab_kk'); 
		$kode_pos_kk = $this->input->post('kode_pos_kk'); 
		$provinsi_kk = $this->input->post('provinsi_kk');  

		$jkk = $this->m_models->getRowsWhere("*", "kartu_keluarga", "no_kk", $no_kk, "no_urut", "asc");
		$arwhere=array('blok' =>$blok_kk, 'rt' =>$rt_kk, 'rw' =>$rw_kk,'desa' =>$desa_kk,'kec' =>$kec_kk,'kota' =>$kab_kk,'kode_pos' =>$kode_pos_kk,'provinsi' =>$provinsi_kk);
		$data['update_data'] = $this->m_models->update_data($no_kk, "no_kk", $arwhere, "kartu_keluarga");
		
		if (($nrp != "") && ($no_kk != "") && ($blok_kk != "") && ($rt_kk != "") && ($rw_kk != "") && ($desa_kk != "") && ($kec_kk != "") && ($kab_kk != "") && ($kode_pos_kk != "") && ($provinsi_kk != "")){ 
			for ($b=1; $b<=$jkk; $b++){ 
				$no_urut = $this->input->post('no_urut'.$b); 
				$no_penduduk_kk = $this->input->post('no_penduduk_kk'.$b);
				$nama_kk = $this->input->post('nama_kk'.$b); 
				$tmp_lahir_kk = $this->input->post('tmp_lahir_kk'.$b); 
				$tgl_lahir_kk = $this->input->post('tgl_lahir_kk'.$b); 
				$jk_kk = $this->input->post('jk_kk'.$b); 
				$agama_kk = $this->input->post('agama_kk'.$b); 
				$pend_kk = $this->input->post('pend_kk'.$b); 
				$pekerjaan_kk = $this->input->post('pekerjaan_kk'.$b); 
				$status_marital_kk = $this->input->post('status_marital_kk'.$b); 
				$hub_kk = $this->input->post('hub_kk'.$b); 
				$warganegara_kk = $this->input->post('warganegara_kk'.$b); 
				$paspor_kk = $this->input->post('paspor_kk'.$b); 
				$kitas_kk = $this->input->post('kitas_kk'.$b); 
				$ayah_kk = $this->input->post('ayah_kk'.$b); 
				$ibu_kk = $this->input->post('ibu_kk'.$b); 
				$keadaan_kk = $this->input->post('keadaan_kk'.$b); 
				$anggota_kk = $this->input->post('anggota_kk'.$b); 
				$hariini=date("Y-m-d");
				$arrwhere=array('nikk' =>$no_penduduk_kk, 'nama_lengkap' =>$nama_kk, 'tmp_lahir' =>$tmp_lahir_kk,'tgl_lahir' =>$tgl_lahir_kk,'agama' =>$agama_kk,'pendidikan' =>$pend_kk,'pekerjaan' =>$pekerjaan_kk,'status_marital' =>$status_marital_kk,'status_hubungan' =>$hub_kk,'kewarganegaraan' =>$warganegara_kk,'no_paspor' =>$paspor_kk,'no_kitap' =>$kitas_kk,'nama_ayah' =>$ayah_kk,'nama_ibu' =>$ibu_kk,'status_keadaan' =>$keadaan_kk, 'tgl_mutakhir' =>$hariini,'status_anggota_kk' =>$anggota_kk, 'jk' => $jk_kk);
				$data['update_data'] = $this->m_models->update_data($no_urut, "no_urut", $arrwhere, "kartu_keluarga");
			}
			if ($jml_anggota != ""){
				for ($a=1; $a<=$jml_anggota; $a++){ 
					$no_penduduk_kk1 = $this->input->post('no_penduduk_kk'.$a);  echo "$jml_anggota $no_penduduk_kk1";
					$nama_kk1 = $this->input->post('nama_kk'.$a); 
					$tmp_lahir_kk1 = $this->input->post('tmp_lahir_kk'.$a); 
					$tgl_lahir_kk1 = $this->input->post('tgl_lahir_kk'.$a); 
					$jk_kk1 = $this->input->post('jk_kk'.$a); 
					$agama_kk1 = $this->input->post('agama_kk'.$a); 
					$pend_kk1 = $this->input->post('pend_kk'.$a); 
					$pekerjaan_kk1 = $this->input->post('pekerjaan_kk'.$a); 
					$status_marital_kk1 = $this->input->post('status_marital_kk'.$a); 
					$hub_kk1 = $this->input->post('hub_kk'.$a); 
					$warganegara_kk1 = $this->input->post('warganegara_kk'.$a); 
					$paspor_kk1 = $this->input->post('paspor_kk'.$a); 
					$kitas_kk1 = $this->input->post('kitas_kk'.$a); 
					$ayah_kk1 = $this->input->post('ayah_kk'.$a); 
					$ibu_kk1 = $this->input->post('ibu_kk'.$a); 
					$keadaan_kk1 = $this->input->post('keadaan_kk'.$a); 
					$anggota_kk1 = $this->input->post('anggota_kk'.$a); 
					
					$this->db->query("INSERT INTO kartu_keluarga VALUES ('', '$no_penduduk_kk1', '$no_kk1', '$nrp1', '$nama_kk1','$blok_kk1', '$rt_kk1', '$rw_kk1', '$desa_kk1', '$kec_kk1', '$kab_kk1', '$kode_pos_kk1', '$provinsi_kk1', '$jk_kk1', '$tmp_lahir_kk1', '$tgl_lahir_kk1', '$agama_kk1', '$pend_kk1', '$pekerjaan_kk1', '$status_marital_kk1', '$hub_kk1',  '$warganegara_kk1', '$paspor_kk1', '$kitas_kk1', '$ayah_kk1', '$ibu_kk1', '$keadaan_kk1', now(), now(), '$anggota_kk1', 'Aktif')") or die (mysql_error());
				}
			}
			redirect('pegawai/lihat_pegawai');
		} else {
			$this->load->view('pegawai/pembaharuan_kk');
		}		
		$this->load->view('template/footer');
	}


	//cuti
	public function jenis_cuti(){
		$this->load->view('template/header'); 
        $jenis_cuti = $this->input->post('jenis_cuti', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);
        if ($jenis_cuti != ""){
          	$nourut = $this->m_models->no_urut("peg_jenis_cuti");
			$no_cuti="CUTI$nourut";

        	$j_cuti = array('id_j_cuti'=>$no_cuti,'jenis_cuti' => $jenis_cuti, 'keterangan' => $keterangan);
			if ($this->m_models->save_data($j_cuti, 'peg_jenis_cuti') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_cuti');
		}
		$data[jenis_cuti]=$this->m_models->getTabelOrder("*", "peg_jenis_cuti", "jenis_cuti", "asc");
		$this->load->view('pegawai/jenis_cuti',$data);
		$this->load->view('template/footer');
	}

	public function input_cuti(){
		$this->load->view('template/header'); 
		//$nrp=$this->session->userdata['nrp'];
		$data[jenis_cuti] = $this->m_models->getAll("peg_jenis_cuti");

		$ar=array('status_aktf =' => "Aktif");
		$data['dtpegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ar, "nama", "asc");

        $nrp = $this->input->post('nrp', TRUE);
        $jenis_cuti = $this->input->post('jenis_cuti', TRUE);
        $waktu_awal = date_db($this->input->post('waktu_awal', TRUE));
        $waktu_akhir = date_db($this->input->post('waktu_akhir', TRUE));
        $alasan = $this->input->post('alasan', TRUE);
        $alamat = $this->input->post('alamat', TRUE);
        $no_hp = $this->input->post('no_hp', TRUE);
        $nama = $this->input->post('nama', TRUE);
        $no_hp_keluarga = $this->input->post('no_hp_keluarga', TRUE);

        if (($jenis_cuti != "")&&($waktu_awal != "")&&($waktu_akhir != "")&&($alamat != "")&&($no_hp != "")){
          	$no_urut = $this->m_models->no_urut("peg_cuti");
          	$no_cuti="PCUTI$no_urut";
          	$hariini=date("Y-m-d");
        	$j_cuti = array('id_pcuti'=>$no_cuti,'nrp' => $nrp, 'jenis_cuti' => $jenis_cuti, 'alasan' => $alasan, 'alamat' => $alamat, 'tgl_mulai' => $waktu_awal, 'tgl_selesai'=>$waktu_akhir, 'no_hp'=>$no_hp, 'nama_keluarga'=>$nama, 'nohp_keluarga'=>$no_hp_keluarga, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'tgl_pengajuan'=>$hariini);
        	$simpan=$this->m_models->save_data($j_cuti, 'peg_cuti');
        	if ($jenis_cuti=="CUTI0002"){
        		$ar_app=array('st_marital' => 'Menikah');
        		$data['update_data'] = $this->m_models->update_data($nrp, "nrp", $ar_app, "pegawai");
        	}
 
        	/*$id_jab_app=cekAjuanNext($nrp, "cuti", "approve2");

        	$id_sekolah=all("pegawai", "nrp", $nrp, "id_sekolah");
			$data['pegawai'] = $this->m_models->getAll("pegawai where (id_jabatan='$id_jab_app' or id_jabatan2='$id_jab_app') and (id_sekolah='$id_sekolah' or id_sekolah2='$id_sekolah')");

        	#jika jabatan kepsek maka baca juga unit nya, jika tidak maka langsung cek jabatannya saja
			$numberhp=all("pegawai", "nrp", $data['pegawai'][0]->nrp, "tlp");				
			$pesantext=$nama_ajuan.", Bagian ".$bagian." telah mengajukan cuti, silahkan login untuk approval : http://berkah.almultazam.sch.id/";
			$this->sendSMS($numberhp,$pesantext);*/


			if ($simpan == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/input_cuti');
		}
		$this->load->view('pegawai/i_cuti',$data);
		$this->load->view('template/footer');
	}

	public function pengajuan_cuti(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp;
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['hak_akses']=$hak_akses;
		//echo $hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "cuti");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");

		$ar_or=array('Approve1' => 'Proses', 'Approve2'=>'Proses', 'Approve3'=>'Proses');
		//$data['p_cuti']=$this->m_models->getTabelAOrWhere("*", "peg_cuti", $ar_or, "tgl_pengajuan", "asc");
		//$data['p_cuti']=$this->m_models->getAll("peg_cuti where approve1 != 'Reject' or approve2 != 'Reject' or approve3 != 'Reject' or approve3 != 'Approve' order by tgl_pengajuan asc");
		$data['p_cuti']=$this->m_models->getAll("peg_cuti where Approve1 = 'Approve' and approve2 = 'Approve' and approve3 = 'Proses' and tgl_pengajuan >='2022-08-01' order by tgl_pengajuan asc"); 
		foreach ($data['p_cuti'] as $pc){
			$id_sekolah=all("pegawai", "nrp", $pc->nrp, "id_sekolah");
			$nrp_cuti=$pc->nrp; 
			$alurApp[$nrp_cuti]=$this->m_models->alurApp($hak_akses, "cuti", $id_sekolah);

			/*if ($hak_akses==4){
				if ($alurApp[$nrp_cuti]=="approve1"){
					$arr=array('Approve1' => 'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				} else if ($alurApp[$nrp_cuti]=="approve2"){
					$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				} else if ($alurApp[$nrp_cuti]=="approve3"){
					$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				}
			} else {
				if ($alurApp[$nrp_cuti]=="approve1"){
					$arr=array('Approve1' => 'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				} else if ($alurApp[$nrp_cuti]=="approve2"){ 
					$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				} else if ($alurApp[$nrp_cuti]=="approve3"){
					$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				}
			}*/
		        $arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'peg_cuti.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
			//if ($alurApp[$nrp_cuti] == ""){
				$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");
				foreach ($data['peng_cuti'] as $pc) { 
					$n++;
					$data['id_pcuti'][]=$pc->id_pcuti;
					$data['nrp_ajuan'][]=$pc->nrp;
					$data['jenis_cuti'][]=$pc->jenis_cuti;
					$data['alasan'][]=$pc->alasan;
					$data['alamat'][]=$pc->alamat;
					$data['tgl_mulai'][]=$pc->tgl_mulai;
					$data['tgl_selesai'][]=$pc->tgl_selesai;
					$data['no_hp'][]=$pc->no_hp;
					$data['nama_keluarga'][]=$pc->nama_keluarga;
					$data['nohp_keluarga'][]=$pc->nohp_keluarga;
					$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
				}
			//}
			$data['n']=$n;
		}
		$this->load->view('pegawai/pengajuan_cuti', $data);
		$this->load->view('template/footer');
	}

	public function app_pengajuan_cuti(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_jab_app=all("pegawai", "nrp", $nrp, "id_jabatan");
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		//$id_pcuti = $this->uri->segment(3);
		//$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");
		$time=date("H:i:s");


        $id_pcuti = $this->input->post('id_pcuti', TRUE);
        $ket = $this->input->post('ket', TRUE); 
        $alasan = $this->input->post('alasan', TRUE); 

		$arr=array('id_pcuti' => $id_pcuti);
		$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "peg_cuti", $arr, "tgl_pengajuan", "asc");
		$id_sekolah=all("pegawai", "nrp", $data['peng_cuti'][0]->nrp, "id_sekolah");
		$ar=array('id_sekolah' => $id_sekolah, 'pengajuan'=>"cuti");
		$data['app_pengajuan'] = $this->m_models->getTabelwhere("*", "approval_pengajuan", $ar, "id_app", "asc");
		$id_ap=$data['app_pengajuan'][0]->id_ap;
		$nama_ajuan=all("pegawai", "nrp", $data['peng_cuti'][0]->nrp, "nama");
		$bagian=all("sekolah", "id_sekolah", $id_sekolah, "nama");


		$alur=$this->m_models->cekAlurApp($hak_akses, "cuti");
		$cekalur = $this->m_models->cekAlurAppNext($hak_akses, "cuti", $alur, $id_sekolah); 
		if ($ket == "A"){
			$k="Approve";
			if ($cekalur==0){
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve', 'Approve2' => 'Approve','Approve3' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve', 'Approve3' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			} else {
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			}
		} else if ($ket == "R"){
			$k="Reject";
			if ($alur == "approve1"){
				$ar_app=array('Approve1' => 'Reject');
			} else if ($alur == "approve2"){
				$ar_app=array('Approve2' => 'Reject');
			} else if ($alur == "approve3"){
				$ar_app=array('Approve3' => 'Reject');
			} 
		}

		//update pengajuan cuti
		$data['update_data'] = $this->m_models->update_data($id_pcuti, "id_pcuti", $ar_app, "peg_cuti");
			
		//menambahkan ke history update
		$j_cuti = array('tgl'=>$hariini, 'waktu' => $time, 'nrp' => $nrp, 'id_ap' => $id_ap, 'id_pengajuan' => $id_pcuti, 'status'=>$k, 'keterangan'=>$alasan, 'id_jabatan'=>$id_jab_app, 'level_app'=>$alur);

		#kirim sms untuk proses selanjurnya
		if ($ket=="A"){
			if ($alur == "approve1"){
				#pengajuan untuk app kedua
				$jab_next_app=cekAjuanNext($nrp, "cuti", "approve2");	

				#jika jabatan kepsek maka baca juga unit nya, jika tidak maka langsung cek jabatannya saja
				$numberhp=all("pegawai", "nrp", $nrp, "tlp");				
				$pesantext=$nama_ajuan.", Bagian ".$bagian." telah mengajukan cuti, silahkan login untuk approval : http://berkah.almultazam.sch.id/";
				$this->sendSMS($numberhp,$pesantext);
			} else if ($alur == "approve2"){
				#pengajuan untuk app ketiga
				$jab_next_app=cekAjuanNext($nrp, "cuti", "approve3");

				#jika jabatan kepsek maka baca juga unit nya, jika tidak maka langsung cek jabatannya saja
				$numberhp=all("pegawai", "nrp", $nrp, "tlp");				
				$pesantext=$nama_ajuan.", Bagian ".$bagian." telah mengajukan cuti, silahkan login untuk approval : http://berkah.almultazam.sch.id/";
				$this->sendSMS($numberhp,$pesantext);
			} else if ($alur == "approve3"){
				#pengajuan sudah di app semua
				
			} 
		}
		


		if ($this->m_models->save_data($j_cuti, 'approval_history') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil di'.$k.' ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}

		redirect('pegawai/pengajuan_cuti'); 
		$this->load->view('template/footer');
	}

	public function rekap_cuti(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp; 
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "cuti");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");
		$data['divisi'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");
        $dari = $this->input->post('dari', TRUE);
        $sampai = $this->input->post('sampai', TRUE);
        //$jenjang = $this->input->post('jenjang', TRUE);
        $data[dari]=$dari;
        $data[sampai]=$sampai;
      //  $data[jenjang]=$jenjang;

        if (($dari != "") && ($sampai != "")){
        	$arr=array( 'tgl_mulai >='=>$dari, 'tgl_mulai <='=>$sampai);
			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc){
				$n++;
				$data['id_pcuti'][]=$pc->id_pcuti;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['jenis_cuti'][]=$pc->jenis_cuti;
				$data['alasan'][]=$pc->alasan;
				$data['alamat'][]=$pc->alamat;
				$data['tgl_mulai'][]=$pc->tgl_mulai;
				$data['tgl_selesai'][]=$pc->tgl_selesai;
				$data['no_hp'][]=$pc->no_hp;
				$data['nama_keluarga'][]=$pc->nama_keluarga;
				$data['nohp_keluarga'][]=$pc->nohp_keluarga;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
			} 
			$data['n']=$n;
		}
		$this->load->view('pegawai/rekap_cuti', $data);
		$this->load->view('template/footer');
	}

	
	public function datacutipeg(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp; 
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "cuti");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");
		$data['divisi'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");

        	
			$data['peng_cuti'] = $this->m_models->getJoin1("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc){
				$n++;
				$data['id_pcuti'][]=$pc->id_pcuti;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['jenis_cuti'][]=$pc->jenis_cuti;
				$data['alasan'][]=$pc->alasan;
				$data['alamat'][]=$pc->alamat;
				$data['tgl_mulai'][]=$pc->tgl_mulai;
				$data['tgl_selesai'][]=$pc->tgl_selesai;
				$data['no_hp'][]=$pc->no_hp;
				$data['nama_keluarga'][]=$pc->nama_keluarga;
				$data['nohp_keluarga'][]=$pc->nohp_keluarga;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
			} 
			$data['n']=$n;

		$this->load->view('pegawai/datacutipeg', $data);
		$this->load->view('template/footer');
	}

	
	public function download_rekap_cuti(){
        $dari = $this->uri->segment(3);
        $sampai = $this->uri->segment(4);

        if (($dari != "") && ($sampai != "")){
        	$arr=array('tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai);
			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc){
				$n++;
				$data['id_pcuti'][]=$pc->id_pcuti;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['jenis_cuti'][]=$pc->jenis_cuti;
				$data['alasan'][]=$pc->alasan;
				$data['alamat'][]=$pc->alamat;
				$data['tgl_mulai'][]=$pc->tgl_mulai;
				$data['tgl_selesai'][]=$pc->tgl_selesai;
				$data['no_hp'][]=$pc->no_hp;
				$data['nama_keluarga'][]=$pc->nama_keluarga;
				$data['nohp_keluarga'][]=$pc->nohp_keluarga;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
			} 
			$data['n']=$n;
		}
		$this->load->view('pegawai/download_rekap_cuti', $data);
	}

  //Update Cuti Pegawai
public function updatecutipeg(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp; 
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "cuti");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");
		$data['divisi'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");

        	
			$data['peng_cuti'] = $this->m_models->getJoin1("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc){
				$n++;
				$data['id_pcuti'][]=$pc->id_pcuti;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['jenis_cuti'][]=$pc->jenis_cuti;
				$data['alasan'][]=$pc->alasan;
				$data['alamat'][]=$pc->alamat;
				$data['tgl_mulai'][]=$pc->tgl_mulai;
				$data['tgl_selesai'][]=$pc->tgl_selesai;
				$data['no_hp'][]=$pc->no_hp;
				$data['nama_keluarga'][]=$pc->nama_keluarga;
				$data['nohp_keluarga'][]=$pc->nohp_keluarga;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
			} 
			$data['n']=$n;

		$this->load->view('pegawai/updatecutipeg', $data);
		$this->load->view('template/footer');
	}

	public function edit_cuti_pegawai(){
		$this->load->view('template/header'); 
		//$nrp=$this->session->userdata['nrp'];
		$id_pcuti=$this->uri->segment(3);
		//echo $id_pcuti;
		$data['nrp']=$nrp; 
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "cuti");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");
		$data['divisi'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");
			$data['jenis_cuti'] = $this->m_models->getAll("peg_jenis_cuti");
        	$arr=array("id_pcuti"=>$id_pcuti);
			//$data['peng_cuti'] = $this->m_models->getJoin1("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");*/

			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_cuti", "pegawai", "pegawai.nrp=peg_cuti.nrp", $arr, "tgl_pengajuan", "asc");
			/*foreach ($data['peng_cuti'] as $pc){
				$n++;
				$data['id_pcuti'][]=$pc->id_pcuti;
				$data['nama'][]=$pc->nama;
				$data['nrp_ajuan'][]=$pc->nrp;
				//$data['jenis_cuti'][]=$pc->jenis_cuti;
				$data['alasan'][]=$pc->alasan;
				$data['alamat'][]=$pc->alamat;
				$data['tgl_mulai'][]=$pc->tgl_mulai;
				$data['tgl_selesai'][]=$pc->tgl_selesai;
				$data['no_hp'][]=$pc->no_hp;
				$data['nama_keluarga'][]=$pc->nama_keluarga;
				$data['nohp_keluarga'][]=$pc->nohp_keluarga;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
			} 
			$data['n']=$n;*/

		$this->load->view('pegawai/edit_cuti_pegawai', $data);
		$this->load->view('template/footer');
	}

	public function simpan_edit_cuti(){
		$this->load->view('template/header'); 
		//$nrp=$this->session->userdata['nrp'];
		

       
        $id_pcuti = $this->input->post('id_pcuti', TRUE);
        $jenis_cuti = $this->input->post('jenis_cuti', TRUE);
        $waktu_awal = $this->input->post('waktu_awal', TRUE);
        $waktu_akhir = $this->input->post('waktu_akhir', TRUE);
        $alasan = $this->input->post('alasan', TRUE);
        $alamat = $this->input->post('alamat', TRUE);
        $no_hp = $this->input->post('no_hp', TRUE);
        $nama = $this->input->post('nama', TRUE);
        $no_hp_keluarga = $this->input->post('no_hp_keluarga', TRUE);

        if (($jenis_cuti != "")&&($waktu_awal != "")&&($waktu_akhir != "")&&($alamat != "")&&($no_hp != "")){

          	$ar_app=array('jenis_cuti' => $jenis_cuti, 'tgl_mulai' => $waktu_awal,'tgl_selesai' => $waktu_akhir,'alasan' => $alasan,'no_hp' => $no_hp,'nama_keluarga' => $nama,'nohp_keluarga' => $no_hp_keluarga);
            $data['update_data'] = $this->m_models->update_data($id_pcuti, "id_pcuti", $ar_app, "peg_cuti");
		
        	/*$id_jab_app=cekAjuanNext($nrp, "cuti", "approve2");

        	$id_sekolah=all("pegawai", "nrp", $nrp, "id_sekolah");
			$data['pegawai'] = $this->m_models->getAll("pegawai where (id_jabatan='$id_jab_app' or id_jabatan2='$id_jab_app') and (id_sekolah='$id_sekolah' or id_sekolah2='$id_sekolah')");

        	#jika jabatan kepsek maka baca juga unit nya, jika tidak maka langsung cek jabatannya saja
			$numberhp=all("pegawai", "nrp", $data['pegawai'][0]->nrp, "tlp");				
			$pesantext=$nama_ajuan.", Bagian ".$bagian." telah mengajukan cuti, silahkan login untuk approval : http://berkah.almultazam.sch.id/";
			$this->sendSMS($numberhp,$pesantext);*/


			if ($data['update_data'] == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/updatecutipeg');
		}
	}



	
	//izin study
	public function izin_studi(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data[hak_akses]=$this->session->userdata['hak_akses'];

		$arr=array('id_tp !=' => '1', 'id_tp !=' => '11');
		$data['ting_pend'] = $this->m_models->getTabelwhere("*", "tingkat_pendidikan", $arr, "id_tp", "asc");
		$hariini=date("Y-m-d");

        $jenjang = $this->input->post('jenjang', TRUE);
        $waktu_awal = date_db($this->input->post('waktu_awal', TRUE));
        $waktu_akhir = date_db($this->input->post('waktu_akhir', TRUE));
        $nama_sekolah = $this->input->post('nama_sekolah', TRUE);
        $fakultas = $this->input->post('fakultas', TRUE);
        $prodi = $this->input->post('prodi', TRUE);
        $alamat = $this->input->post('alamat', TRUE);
        $nohp_sekolah = $this->input->post('nohp_sekolah', TRUE);
        $nohp_pegawai = $this->input->post('nohp_pegawai', TRUE);
        $alasan = $this->input->post('alasan', TRUE);

        if (($jenjang != "") && ($waktu_awal != "") && ($waktu_akhir != "")){
        	$j_cuti = array('nrp'=>$nrp,'id_tp' => $jenjang, 'wkt_awal' => $waktu_awal, 'wkt_akhir' => $waktu_akhir, 'nama_sekolah' => $nama_sekolah, 'fakultas' => $fakultas, 'prodi'=>$prodi, 'alamat'=>$alamat, 'nohp_sekolah'=>$nohp_sekolah, 'nohp_pegawai'=>$nohp_pegawai,'tgl_pengajuan'=>$hariini,'alasan'=>$alasan, 'approve1'=>'Proses', 'approve2'=>'Proses', 'approve3'=>'Proses');
			if ($this->m_models->save_data($j_cuti, 'peg_izin_studi') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/izin_studi');
		}
		
		$this->load->view('pegawai/i_izin_studi',$data);
		$this->load->view('template/footer');
	}

	public function pengajuan_izin_studi(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp;
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "izin study");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");

		$ar_or=array('Approve1' => 'Proses', 'Approve2'=>'Proses', 'Approve3'=>'Proses');
		//$data['p_cuti']=$this->m_models->getTabelAOrWhere("*", "peg_izin_studi", $ar_or, "tgl_pengajuan", "asc");
		$data['p_cuti']=$this->m_models->getAll("peg_izin_studi where approve1 != 'Reject' or approve2 != 'Reject' or approve3 != 'Reject' or approve3 != 'Approve' order by tgl_pengajuan asc");
		foreach ($data['p_cuti'] as $pc){
			$id_sekolah=all("pegawai", "nrp", $pc->nrp, "id_sekolah");
			$nrp_cuti=$pc->nrp; 
			$alurApp[$nrp_cuti]=$this->m_models->alurApp($hak_akses, "izin study", $id_sekolah);
			/*if ($alurApp[$nrp_cuti]=="approve1"){
				$arr=array('Approve1' => 'Proses', 'nrp'=>$nrp_cuti);
			} else if ($alurApp[$nrp_cuti]=="approve2"){
				$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'nrp'=>$nrp_cuti);
			} else if ($alurApp[$nrp_cuti]=="approve3"){
				$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'nrp'=>$nrp_cuti);
			}*/

			if ($hak_akses==4){
				if ($alurApp[$nrp_cuti]=="approve1"){
					$arr=array('Approve1' => 'Proses', 'peg_izin_studi.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				} else if ($alurApp[$nrp_cuti]=="approve2"){
					$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'peg_izin_studi.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				} else if ($alurApp[$nrp_cuti]=="approve3"){
					$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'peg_izin_studi.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti, 'id_sekolah'=>$idsekolah);
				}
			} else {
				if ($alurApp[$nrp_cuti]=="approve1"){
					$arr=array('Approve1' => 'Proses', 'peg_izin_studi.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				} else if ($alurApp[$nrp_cuti]=="approve2"){
					$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'peg_izin_studi.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				} else if ($alurApp[$nrp_cuti]=="approve3"){
					$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'peg_izin_studi.nrp'=>$nrp_cuti, 'id_pcuti'=>$pc->id_pcuti);
				}
			}

			//$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "peg_izin_studi", $arr, "tgl_pengajuan", "asc");	
			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_izin_studi", "pegawai", "pegawai.nrp=peg_izin_studi.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc) {
				$n++;
				$data['id_izinstudy'][]=$pc->id_izinstudy;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['id_tp'][]=$pc->id_tp;
				$data['wkt_awal'][]=$pc->wkt_awal;
				$data['wkt_akhir'][]=$pc->wkt_akhir;
				$data['nama_sekolah'][]=$pc->nama_sekolah;
				$data['fakultas'][]=$pc->fakultas;
				$data['prodi'][]=$pc->prodi;
				$data['alamat'][]=$pc->alamat;
				$data['nohp_sekolah'][]=$pc->nohp_sekolah;
				$data['nohp_pegawai'][]=$pc->nohp_pegawai;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
				$data['alasan'][]=$pc->alasan;
			}
			$data['n']=$n;
		}
		$this->load->view('pegawai/pengajuan_izin_studi', $data);
		$this->load->view('template/footer');
	}

	public function app_pengajuan_izinstudy(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_jab_app=all("pegawai", "nrp", $nrp, "id_jabatan");
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$hariini=date("Y-m-d");
		$time=date("H:i:s");


        $id_izinstudy = $this->input->post('id_izinstudy', TRUE);
        $ket = $this->input->post('ket', TRUE); 
        $alasan = $this->input->post('alasan', TRUE); 

		$arr=array('id_izinstudy' => $id_izinstudy);
		$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "peg_izin_studi", $arr, "tgl_pengajuan", "asc");
		$id_sekolah=all("pegawai", "nrp", $data['peng_cuti'][0]->nrp, "id_sekolah");
		$ar=array('id_sekolah' => $id_sekolah, 'pengajuan'=>"izin study");
		$data['app_pengajuan'] = $this->m_models->getTabelwhere("*", "approval_pengajuan", $ar, "id_app", "asc");
		$id_ap=$data['app_pengajuan'][0]->id_ap; 

		$alur=$this->m_models->cekAlurApp($hak_akses, "izin study");
		$cekalur = $this->m_models->cekAlurAppNext($hak_akses, "izin study", $alur, $id_sekolah); 
		if ($ket == "A"){
			$k="Approve";
			if ($cekalur==0){
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve', 'Approve2' => 'Approve','Approve3' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve', 'Approve3' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			} else {
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			}
		} else if ($ket == "R"){
			$k="Reject";
			if ($alur == "approve1"){
				$ar_app=array('Approve1' => 'Reject');
			} else if ($alur == "approve2"){
				$ar_app=array('Approve2' => 'Reject');
			} else if ($alur == "approve3"){
				$ar_app=array('Approve3' => 'Reject');
			} 
		}

		//update pengajuan cuti
		$data['update_data'] = $this->m_models->update_data($id_izinstudy, "id_izinstudy", $ar_app, "peg_izin_studi");
			
		//menambahkan ke history update
		$j_cuti = array('tgl'=>$hariini, 'waktu' => $time, 'nrp' => $nrp, 'id_ap' => $id_ap, 'id_pengajuan' => $id_izinstudy, 'status'=>$k, 'keterangan'=>$alasan, 'id_jabatan'=>$id_jab_app, 'level_app'=>$alur);
		if ($this->m_models->save_data($j_cuti, 'approval_history') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil di'.$k.' ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}

		redirect('pegawai/pengajuan_izin_studi'); 
		$this->load->view('template/footer');
	}

	public function lap_izin_studi(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp;
		//$hak_akses=$this->session->userdata['hak_akses'];
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");
		$data['hak_akses']=$hak_akses;
		$alur=$this->m_models->cekAlurApp($hak_akses, "izin study");
		$data['id_jab_user']=$this->m_models->getSession($nrp, "id_jabatan");
		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
        $dari = $this->input->post('dari', TRUE);
        $sampai = $this->input->post('sampai', TRUE);
        $jenjang = $this->input->post('jenjang', TRUE);
        $data[dari]=$dari;
        $data[sampai]=$sampai;
        $data[jenjang]=$jenjang;

        if (($dari != "") && ($sampai !="") && ($jenjang != "")){
        	$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Approve', 'id_sekolah'=>$jenjang);
			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_izin_studi", "pegawai", "pegawai.nrp=peg_izin_studi.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc) {
				$n++;
				$data['id_izinstudy'][]=$pc->id_izinstudy;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['id_tp'][]=$pc->id_tp;
				$data['wkt_awal'][]=$pc->wkt_awal;
				$data['wkt_akhir'][]=$pc->wkt_akhir;
				$data['nama_sekolah'][]=$pc->nama_sekolah;
				$data['fakultas'][]=$pc->fakultas;
				$data['prodi'][]=$pc->prodi;
				$data['alamat'][]=$pc->alamat;
				$data['nohp_sekolah'][]=$pc->nohp_sekolah;
				$data['nohp_pegawai'][]=$pc->nohp_pegawai;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
				$data['alasan'][]=$pc->alasan;
			}
			$data['n']=$n;
        }
			
		$this->load->view('pegawai/lap_izin_studi', $data);
		$this->load->view('template/footer');
	}

	public function download_lap_izin_study(){
        $dari = $this->input->post('dari', TRUE);
        $sampai = $this->input->post('sampai', TRUE);
        $jenjang = $this->input->post('jenjang', TRUE);
        $dari = $this->uri->segment(3);
        $sampai = $this->uri->segment(4);
        $jenjang = $this->uri->segment(5);

        if (($dari != "") && ($sampai !="") && ($jenjang != "")){
        	$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Approve', 'id_sekolah'=>$jenjang);
			$data['peng_cuti'] = $this->m_models->getJoin1where("*", "peg_izin_studi", "pegawai", "pegawai.nrp=peg_izin_studi.nrp", $arr, "tgl_pengajuan", "asc");
			foreach ($data['peng_cuti'] as $pc) {
				$n++;
				$data['id_izinstudy'][]=$pc->id_izinstudy;
				$data['nrp_ajuan'][]=$pc->nrp;
				$data['id_tp'][]=$pc->id_tp;
				$data['wkt_awal'][]=$pc->wkt_awal;
				$data['wkt_akhir'][]=$pc->wkt_akhir;
				$data['nama_sekolah'][]=$pc->nama_sekolah;
				$data['fakultas'][]=$pc->fakultas;
				$data['prodi'][]=$pc->prodi;
				$data['alamat'][]=$pc->alamat;
				$data['nohp_sekolah'][]=$pc->nohp_sekolah;
				$data['nohp_pegawai'][]=$pc->nohp_pegawai;
				$data['tgl_pengajuan'][]=$pc->tgl_pengajuan;
				$data['alasan'][]=$pc->alasan;
			}
			$data['n']=$n;
        }
			
		$this->load->view('pegawai/download_lap_izin_study', $data);
	}


	//input jenis kegiatan pegawai
	public function jenis_kegiatan(){
		$this->load->view('template/header'); 
        $jenis_kegiatan = $this->input->post('jenis_kegiatan', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);
        if ($jenis_kegiatan != ""){
          	$nourut = $this->m_models->no_urut_keg("peg_kegiatan","id_j_kegiatan");
			$no_cuti="KEG$nourut";

        	$j_cuti = array('id_j_kegiatan'=>$no_cuti,'jenis_kegiatan' => $jenis_kegiatan, 'keterangan' => $keterangan);
			if ($this->m_models->save_data($j_cuti, 'peg_kegiatan') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_kegiatan');
		}
		$data[jenis_kegiatan]=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");
		$this->load->view('pegawai/i_kegiatan',$data);
		$this->load->view('template/footer');
	}


	public function anggota_kegiatan(){
		$this->load->view('template/header'); 
		$data[jenis_kegiatan]=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");
		$data[sekolah]=$this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;
		$data[id_ta]=$data['thn_akademik'][0]->id_tahun;
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");


		$jenis = $this->input->post('jenis', TRUE);
		$divisi = $this->input->post('divisi', TRUE);
		$peg = $this->input->post('pegawai', TRUE);
		$jml = $this->input->post('jml', TRUE);
		if (($jenis != "") && ($divisi != "") && ($jml != "")){
			for ($i=0; $i <= $jml; $i++){
				$pegawai = $peg[$i]; 
				if ($pegawai != ""){
					$j_keg = array('id_j_kegiatan'=>$jenis, 'nrp' => $pegawai, 'id_sekolah' => $divisi, 'status' => 'on', 'id_tahun'=>$id_ta);
					if ($this->m_models->save_data($j_keg, 'peg_anggota_kegiatan') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}
			redirect('pegawai/anggota_kegiatan');
		}

		$thn_akdmk = $this->input->post('thn_akdmk', TRUE);
		if ($thn_akdmk != ""){
			$data['anggota_kegiatan'] = $this->m_models->getwhere("*", "peg_anggota_kegiatan", "id_tahun", $thn_akdmk, "id_j_kegiatan", "asc");
		}
		$this->load->view('pegawai/i_anggota_kegiatan',$data);
		$this->load->view('template/footer');
	}

	public function cekpegawai(){
		$id_sekolah=$this->input->get('divisi', TRUE);
		if ($id_sekolah=="all"){
			$data['pegawai'] = $this->m_models->getAll("pegawai order by nama asc");
			$data['jpegawai'] = $this->m_models->getRows("pegawai order by nama asc");
		} else {
			$data['pegawai'] = $this->m_models->getwhere("*", "pegawai", "id_sekolah", $id_sekolah, "nama", "asc");
			$data['jpegawai'] = $this->m_models->getRowsWhere("*", "pegawai", "id_sekolah", $id_sekolah, "nama", "asc");
		}
		
		$this->load->view('pegawai/cekpegawai',$data);
	}

	public function absensi_kegiatan(){
		$this->load->view('template/header'); 
		$nrp_input=$this->session->userdata['nrp']; 
		$data['jenis_kegiatan']=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");

		$id_ta = $this->input->post('id_ta', TRUE);
		$tgl = date_db($this->input->post('tgl', TRUE));
		$tmp = $this->input->post('tmp', TRUE);
		$jenis = $this->input->post('jenis', TRUE);
		$jml = $this->input->post('jml', TRUE);
		$nrp = $this->input->post('nrp', TRUE);
		$id_sekolah = $this->input->post('id_sekolah', TRUE);
		$mulai = $this->input->post('mulai', TRUE);
		$selesai = $this->input->post('selesai', TRUE);

		if (($id_ta != "") && ($tgl != "") && ($tmp != "") && ($jml != "")){
			for ($i=0; $i < $jml; $i++){
				$nrp_peg=$nrp[$i];

				$kehadiran = $this->input->post('kehadiran'.$nrp_peg, TRUE);
				//$mulai = time_db($this->input->post('mulai'.$nrp_peg, TRUE));
				//$selesai = time_db($this->input->post('selesai'.$nrp_peg, TRUE));
				$ket = $this->input->post('ket'.$nrp_peg, TRUE); 

				$j_keg = array('nrp'=>$nrp_peg, 'tgl' => $tgl, 'time_in' => $mulai, 'time_out' => $selesai, 'absensi'=>$kehadiran, 'id_j_kegiatan'=>$jenis, 'id_tahun'=>$id_ta, 'id_sekolah'=>$id_sekolah, 'nrp_input'=>$nrp_input, 'ket_absensi'=>$ket);
				if ($this->m_models->save_data($j_keg, 'peg_absensi_kegiatan') == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
			redirect('pegawai/absensi_kegiatan'); 
		}
		
		$this->load->view('pegawai/i_absensi_kegiatan',$data);
		$this->load->view('template/footer');
	}

	public function cekanggotakeg(){
		$jenis=$this->input->get('jenis', TRUE); 

		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;
		$data['idta']=$id_ta;
		$aa=array('id_tahun =' => $id_ta, 'id_j_kegiatan ='=>$jenis);
		$data['anggota_kegiatan'] = $this->m_models->getTabelwhere("*", "peg_anggota_kegiatan", $aa, "id_j_kegiatan", "asc");
		$data['jak'] = $this->m_models->getRowsAWhere("*", "peg_anggota_kegiatan", $aa, "id_j_kegiatan", "asc");

		$this->load->view('pegawai/cekanggotakeg',$data);
	}

	public function resume_absen_keg(){
		$this->load->view('template/header'); 
		$nrp_input=$this->session->userdata['nrp']; 
		$data['jenis_kegiatan']=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['id_ta']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");


		$id_tahun = $this->input->post('thn_akdmk', TRUE);
		$id_j_kegiatan = $this->input->post('jenis_keg', TRUE);
		$data[id_tahun]=$id_tahun;
		$data[id_j_kegiatan]=$id_j_kegiatan;
		if (($id_tahun != "")&&($id_j_kegiatan != "")){ 
			$data['t_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "id_tahun", $id_tahun, "tahun2", "desc");
			$data['periode']=$data['t_akademik'][0]->periode;
			$data['j_kegiatan'] = $this->m_models->getwhere("*", "peg_kegiatan", "id_j_kegiatan", $id_j_kegiatan, "jenis_kegiatan", "desc");
			$data['kegiatan'] = $data['j_kegiatan'][0]->jenis_kegiatan;

			$aa=array('id_tahun =' => $id_tahun, 'id_j_kegiatan ='=>$id_j_kegiatan);
			$data['anggota_kegiatan'] = $this->m_models->getTabelwhere("*", "peg_absensi_kegiatan", $aa, "id_j_kegiatan", "asc");
		}

		$this->load->view('pegawai/rekap_absensi_kegiatan',$data);
		$this->load->view('template/footer');
	}
	
	public function update_rabsenkeg(){
		$this->load->view('template/header'); 
		$nrp_input=$this->session->userdata['nrp']; 
		$id = $this->uri->segment(3);
		//$data['jenis_kegiatan']=$this->m_models->getTabelOrder("*", "peg_absensi_kegiatan", "id_abs_kegiatan", "asc");
		$data['jenis_kegiatan']=$this->m_models->get_data("*", "peg_absensi_kegiatan", " where id_abs_kegiatan ='".$id."'");
		
		

		$this->load->view('pegawai/update_rabsenkeg',$data);
		$this->load->view('template/footer');
	}
	
	public function save_update_rabsenkeg(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$id = $this->input->post('id_abs');
		$time_in = $this->input->post('time_in');
		$time_out = $this->input->post('time_out');
		$absensi = $this->input->post('absensi');
		$ket_absensi = $this->input->post('ket_absensi');
		
			$jkeg= array('time_in'=>$time_in, 'time_out' => $time_out, 'absensi'=>$absensi, 'ket_absensi'=>$ket_absensi);
			if ($this->m_models->update_data($id, "id_abs_kegiatan", $jkeg, "peg_absensi_kegiatan") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diupdate');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/resume_absen_keg');
	}

	public function download_resume_abs_keg(){
		$nrp_input=$this->session->userdata['nrp']; 
		$data['jenis_kegiatan']=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['id_ta']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");

		$id_j_kegiatan = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4); 
		if (($id_tahun != "")&&($id_j_kegiatan != "")){ 
			$data['t_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "id_tahun", $id_tahun, "tahun2", "desc");
			$data['periode']=$data['t_akademik'][0]->periode;
			$data['j_kegiatan'] = $this->m_models->getwhere("*", "peg_kegiatan", "id_j_kegiatan", $id_j_kegiatan, "jenis_kegiatan", "desc");
			$data['kegiatan'] = $data['j_kegiatan'][0]->jenis_kegiatan;

			$aa=array('id_tahun =' => $id_tahun, 'id_j_kegiatan ='=>$id_j_kegiatan);
			$data['anggota_kegiatan'] = $this->m_models->getTabelwhere("*", "peg_absensi_kegiatan", $aa, "id_j_kegiatan", "asc");
		}

		$this->load->view('pegawai/download_resume_abs_keg',$data);
	}

	//input angket kepuasan santri
	public function pertanyaan_angket(){
		$this->load->view('template/header'); 
		$kategori = $this->input->post('kategori', TRUE);
		if ($kategori != ""){
			$ar_angket=array('status =' => "on", 'kategori =' => $kategori);
			$data['pertanyaan_angket'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $ar_angket, "pertanyaan", "asc");
		}

		//$data['pertanyaan_angket'] = $this->m_models->getwhere("*", "peg_angket_pertanyaan", "status", 'on', "pertanyaan", "asc");

		$this->load->view('pegawai/i_pertanyaan_angket',$data);
		$this->load->view('template/footer');
	}

	public function simpan_tanya_angket(){
		$pertanyaan = $this->input->post('pertanyaan', TRUE);
		$kategori = $this->input->post('kategori', TRUE);
		if (($pertanyaan != "") && ($kategori != "")){
			for ($i=1; $i<=5; $i++){
				$pilihan[]= $this->input->post('pilihan'.$i, TRUE);
			}
			$nourut = $this->m_models->no_urut("peg_angket_pertanyaan"); 
			$no_pq="PQ$nourut";

			$j_pq = array('id_p_angket'=>$no_pq, 'pertanyaan' => $pertanyaan, 'pilihan1' => $pilihan[0], 'pilihan2' => $pilihan[1], 'pilihan3' => $pilihan[2], 'pilihan4' => $pilihan[3], 'pilihan5' => $pilihan[4], 'kategori'=>$kategori);
			if ($this->m_models->save_data($j_pq, 'peg_angket_pertanyaan') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/pertanyaan_angket');
		} 
	}

	public function off_pert_angket(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_p_angket = $this->uri->segment(3);
		if ($id_p_angket != ""){
			$j_off= array('tgl_off'=>$hariini, 'nrp_off' => $nrp, 'status'=>'off');
			if ($this->m_models->update_data($id_p_angket, "id_p_angket", $j_off, "peg_angket_pertanyaan") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dioff');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/pertanyaan_angket');
		}
		$this->load->view('pegawai/i_pertanyaan_angket',$data);
		$this->load->view('template/footer');
	}

	public function angket_kepuasan(){
		$this->load->view('template/header'); 
		$id_siswa=$this->session->userdata['id_siswa']; 
		$ar_angket=array('status =' => "on", 'kategori =' => 'Siswa');
		$data['pertanyaan_angket'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $ar_angket, "pertanyaan", "asc");

		$arraywhere=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arraywhere, "nama", "asc");

		//angket kepuasan
		$hariini=date("Y-m-d");
		$no = $this->input->post('no', TRUE);
		$nrp = $this->input->post('nrp', TRUE);
		$kesan = $this->input->post('kesan', TRUE);
		$idpq = $this->input->post('id_pq', TRUE);
		if ($no != 0){
			for ($i=0; $i<=$no; $i++){
				$id_pq = $idpq[$i];
				$pilihan = $this->input->post('pilihan'.$id_pq, TRUE);

				if (($id_pq != "")&&($id_siswa != "")){
					if ($pilihan == ""){
						$j_pq = array('tgl'=>$hariini, 'id_siswa' => $id_siswa, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $kesan);
					} else {
						$j_pq = array('tgl'=>$hariini, 'id_siswa' => $id_siswa, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $pilihan);
					}
					if ($this->m_models->save_data($j_pq, 'peg_jawaban_angket') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				} else if ($id_pq != ""){
					if ($pilihan == ""){
						$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $kesan);
					} else {
						$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $pilihan);
					}
					if ($this->m_models->save_data($j_pq, 'peg_jawaban_angket') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			} 
		}

		//data favorit
		$nrp_input=$this->session->userdata['nrp']; 
		$id_siswa=$this->session->userdata['id_siswa']; 
		if ($nrp_input != ""){
			$user=$nrp_input;
		} else {
			$user=$id_siswa;
		}
		$ak=array('jenis =' => 'kriteria', 'status =' => 'on');
		$data['kriteria'] = $this->m_models->getTabelwhere("*", "peg_saran", $ak, "nama_saran", "asc");
		$af=array('jenis =' => 'favorit', 'status =' => 'on');
		$data['favorit'] = $this->m_models->getTabelwhere("*", "peg_saran", $af, "nama_saran", "asc");
		foreach ($data['favorit'] as $f){
			if ($f->id_saran=="7"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and jk='Laki-laki' and ((id_jabatan = '6' or id_jabatan = '7') or (id_jabatan2 = '6' or id_jabatan2 = '7')) order by pegawai.nama asc");
			} else if ($f->id_saran=="8"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and jk='Perempuan' and ((id_jabatan = '6' or id_jabatan = '7') or (id_jabatan2 = '6' or id_jabatan2 = '7')) order by pegawai.nama asc");
			} else if ($f->id_saran=="9"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and ((id_jabatan = '52' or id_jabatan = '83') or (id_jabatan2 = '52' or id_jabatan2 = '83')) order by pegawai.nama asc");
			} else if ($f->id_saran=="10"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and ((id_jabatan = '45' or id_jabatan = '61' or id_jabatan = '66') or (id_jabatan2 = '45' or id_jabatan2 = '61' or id_jabatan2 = '66')) order by pegawai.nama asc");
			} else if ($f->id_saran=="11"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and (id_jabatan = '42' or id_jabatan2 = '42') order by pegawai.nama asc");
			} else if ($f->id_saran=="12"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and (id_jabatan = '65' or id_jabatan2 = '65') order by pegawai.nama asc");
			} else {
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and (id_jabatan != '' or id_jabatan2 != '') order by pegawai.nama asc");
			}
		}

		
		//$data['pegawai'] = $this->m_models->getJoin1where("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "sekolah", "pegawai.id_sekolah=sekolah.id_sekolah", $where, "pegawai.nama", "asc");

		$hariini=date("Y-m-d");
		$no1 = $this->input->post('no1', TRUE);
		$idsaran = $this->input->post('id_saran', TRUE);
		if ($no1 != ""){
			for ($i=0; $i <= $no1; $i++) { 
				$id_saran=$idsaran[$i]; 
				$nrp_fav = $this->input->post('nrp'.$id_saran, TRUE); 
				if (($id_saran != "")&&($nrp_fav != "")){
					$j_fav= array('tgl'=>$hariini, 'nrp_input' => $user, 'id_saran' => $id_saran, 'nrp_fav' => $nrp_fav);
				}
				//$data[s_fav]=$this->m_models->save_data($j_fav, 'peg_favorit');
				if ($this->m_models->save_data($j_fav, 'peg_favorit') == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
			redirect('pegawai/angket_kepuasan');
		}

			
		$this->load->view('pegawai/angket_kepuasan_santri',$data);
		$this->load->view('template/footer');
	}

	public function resume_angket(){
		$this->load->view('template/header'); 
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
		$kategori = $this->input->post('kategori', TRUE); 
		$data[dari]=$tgl_dari;
		$data[sampai]=$tgl_sampai;
		$data[kategori]=$kategori;

		if ($kategori=="Siswa"){
			$aa=array('status =' => 'on', 'kategori'=>"Siswa");
		} else if ($kategori=="Pegawai"){
			$aa=array('status =' => 'on', 'kategori'=>"Pegawai");
		} else if ($kategori=="Orang Tua"){
			$aa=array('status =' => 'on', 'kategori'=>"Orang Tua");
		} else if ($kategori=="Pihak Luar"){
			$aa=array('status =' => 'on', 'kategori'=>"Pihak Luar");
		} 
		$data[kategori]=$kategori;
		

		if ($tgl_dari!= null AND $tgl_sampai != null && $kategori != "") {
			$data['pertanyaan'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $aa, "pertanyaan", "asc");
			foreach ($data['pertanyaan'] as $p){
				$aang = array('tgl >= ' => $tgl_dari, 'tgl <= ' => $tgl_sampai, 'id_p_angket = '=>$p->id_p_angket);
				$data['dt_angket']=$this->m_models->getAwhereGroup("*", "peg_jawaban_angket", $aang, "tgl, nrp", "tgl", "asc");
				//$data['dt_angket'][$p->id_p_angket]=$this->m_models->getTabelwhere("*", "peg_jawaban_angket", $aang, "tgl", "asc");
				foreach ($data['dt_angket'] as $dt_angket){
					$ar_a = array('tgl >= ' => $dt_angket->tgl, 'id_p_angket = '=>$p->id_p_angket, 'nrp'=>$dt_angket->nrp);
					$data['dtangket']=$this->m_models->getTabelwhere("*", "peg_jawaban_angket", $ar_a, "tgl", "asc");
					foreach ($data['dtangket'] as $da) {
						$data[jawaban][$p->id_p_angket][$dt_angket->tgl][$dt_angket->nrp]=$da->jawaban; 
					}
				}
			}
		}
		
		$this->load->view('pegawai/rekap_angket',$data);
		$this->load->view('template/footer');
	}

	public function download_resume_angket(){
		$tgl_dari = $this->uri->segment(3);
		$tgl_sampai = $this->uri->segment(4);
		$kategori = $this->uri->segment(5);

		$data[dari]=$tgl_dari;
		$data[sampai]=$tgl_sampai;
		$data[kategori]=$kategori;

		if ($kategori=="Siswa"){
			$aa=array('status =' => 'on', 'kategori'=>"Siswa");
		} else if ($kategori=="Pegawai"){
			$aa=array('status =' => 'on', 'kategori'=>"Pegawai");
		} else if ($kategori=="Orang Tua"){
			$aa=array('status =' => 'on', 'kategori'=>"Orang Tua");
		} else if ($kategori=="Pihak Luar"){
			$aa=array('status =' => 'on', 'kategori'=>"Pihak Luar");
		} 
		

		if ($tgl_dari!= null AND $tgl_sampai != null && $kategori != "") {
			$data['pertanyaan'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $aa, "pertanyaan", "asc");
			foreach ($data['pertanyaan'] as $p){
				$aang = array('tgl >= ' => $tgl_dari, 'tgl <= ' => $tgl_sampai, 'id_p_angket = '=>$p->id_p_angket);
				$data['dt_angket']=$this->m_models->getAwhereGroup("*", "peg_jawaban_angket", $aang, "tgl, nrp", "tgl", "asc");
				//$data['dt_angket'][$p->id_p_angket]=$this->m_models->getTabelwhere("*", "peg_jawaban_angket", $aang, "tgl", "asc");
				foreach ($data['dt_angket'] as $dt_angket){
					$ar_a = array('tgl >= ' => $dt_angket->tgl, 'id_p_angket = '=>$p->id_p_angket, 'nrp'=>$dt_angket->nrp);
					$data['dtangket']=$this->m_models->getTabelwhere("*", "peg_jawaban_angket", $ar_a, "tgl", "asc");
					foreach ($data['dtangket'] as $da) {
						$data[jawaban][$p->id_p_angket][$dt_angket->tgl][$dt_angket->nrp]=$da->jawaban; 
					}
				}
			}
		}
		
		$this->load->view('pegawai/download_resume_angket',$data);
	}


	//masukan kritik saran
	public function jenis_masukan(){
		$this->load->view('template/header'); 
		$id_siswa=$this->session->userdata['id_siswa']; 
		
		$hariini=date("Y-m-d");
		$keterangan = $this->input->post('keterangan', TRUE); 
		$jenis = $this->input->post('jenis', TRUE);
		if (($jenis != "")&&($keterangan != "")){
			$j_jm= array('nama_saran'=>$keterangan, 'jenis' => $jenis, 'status' => 'on');
			if ($this->m_models->save_data($j_jm, 'peg_saran') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_masukan');
		}
		$data['jenis_masukan'] = $this->m_models->getwhere("*", "peg_saran", "status", 'on', "jenis", "asc");
		$this->load->view('pegawai/jenis_masukan_saran',$data);
		$this->load->view('template/footer');
	}

	public function off_m_saran(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_saran = $this->uri->segment(3);
		if ($id_saran != ""){
			$j_off= array('tgl_off'=>$hariini, 'nrp_off' => $nrp, 'status'=>'off');
			if ($this->m_models->update_data($id_saran, "id_saran", $j_off, "peg_saran") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dioff');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_masukan');
		}
		$this->load->view('pegawai/jenis_masukan_saran',$data);
		$this->load->view('template/footer');
	}

	public function masukan_kritik_saran(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$where=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getJoin1where("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "sekolah", "pegawai.id_sekolah=sekolah.id_sekolah", $where, "pegawai.nama", "asc");
		$data['sekolah']=$this->m_models->get_data("id_sekolah, nama", "sekolah", "where status_aktif='on' order by nama asc");

		$hariini=date("Y-m-d");
		$nrp_kritik = $this->input->post('nrp_kritik', TRUE);
		$kritik = $this->input->post('kritik', TRUE);
		$saran = $this->input->post('saran', TRUE);
		$no = $this->input->post('no', TRUE);
		$idsaran = $this->input->post('id_saran', TRUE);
		if (($saran != "")&&($kritik != "")&&($nrp_kritik != "")){
			$j_kritik= array('tgl'=>$hariini, 'nrp_tujuan' => $nrp_kritik, 'nrp_input' => $nrp, 'kritik' => $kritik, 'saran' => $saran);
			if ($this->m_models->save_data($j_kritik, 'peg_kritik_saran') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/masukan_kritik_saran');
		}

		$this->load->view('pegawai/masukan_kritik_saran',$data);
		$this->load->view('template/footer');
	}

	public function masukan_kritik_saran_bagian(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_sekolah = $this->input->post('id_sekolah', TRUE);
		$kritik = $this->input->post('kritik', TRUE);
		$saran = $this->input->post('saran', TRUE);
		$no = $this->input->post('no', TRUE);
		$idsaran = $this->input->post('id_saran', TRUE);
		if (($saran != "")&&($kritik != "")&&($id_sekolah != "")){
			$j_kritik= array('tgl'=>$hariini, 'bagian_tujuan' => $id_sekolah, 'nrp_input' => $nrp, 'kritik' => $kritik, 'saran' => $saran);
			if ($this->m_models->save_data($j_kritik, 'peg_kritik_saran_bagian') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/masukan_kritik_saran');
		}
	}

	public function pegawai_favorit(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$ak=array('jenis =' => 'kriteria', 'status =' => 'on');
		$data['kriteria'] = $this->m_models->getTabelwhere("*", "peg_saran", $ak, "nama_saran", "asc");
		$af=array('jenis =' => 'favorit', 'status =' => 'on');
		$data['favorit'] = $this->m_models->getTabelwhere("*", "peg_saran", $af, "nama_saran", "asc");
		$where=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getJoin1where("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "sekolah", "pegawai.id_sekolah=sekolah.id_sekolah", $where, "pegawai.nama", "asc");

		$hariini=date("Y-m-d");
		$no = $this->input->post('no', TRUE);
		$idsaran = $this->input->post('id_saran', TRUE);
		if ($no != ""){
			for ($i=0; $i <= $no; $i++) { 
				$id_saran=$idsaran[$i]; 
				$nrp_fav = $this->input->post('nrp'.$id_saran, TRUE); 
				if (($id_saran != "")&&($nrp_fav != "")){
					$j_fav= array('tgl'=>$hariini, 'nrp_input' => $nrp, 'id_saran' => $id_saran, 'nrp_fav' => $nrp_fav);
				}
				//$data[s_fav]=$this->m_models->save_data($j_fav, 'peg_favorit');
				if ($this->m_models->save_data($j_fav, 'peg_favorit') == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
			redirect('pegawai/pegawai_favorit');
		}
		$this->load->view('pegawai/pegawai_favorit',$data);
		$this->load->view('template/footer');
	}

	public function resume_kritik_saran(){
		$this->load->view('template/header'); 
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);

		$aks = array('tgl >= ' => $tgl_dari, 'tgl <= ' => $tgl_sampai); 
		if ($tgl_dari!= null AND $tgl_sampai != null){
			$data[kritiksaran]=$this->m_models->getTabelwhere("*", "peg_kritik_saran", $aks, "tgl", "asc");
			$data[kritiksaran_bagian]=$this->m_models->getTabelwhere("*", "peg_kritik_saran_bagian", $aks, "tgl", "asc");
		}
		
		$this->load->view('pegawai/rekap_kritik_saran',$data);
		$this->load->view('template/footer');
	}

	public function resume_favorit(){
		$this->load->view('template/header'); 
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);

		$af=array('jenis =' => 'favorit', 'status =' => 'on');
		$data['favorit'] = $this->m_models->getTabelwhere("*", "peg_saran", $af, "nama_saran", "asc");

		if ($tgl_dari!= null AND $tgl_sampai != null){
			foreach ($data['favorit'] as $fav){
				$afav = array('tgl >= ' => $tgl_dari, 'tgl <= ' => $tgl_sampai, 'id_saran = '=>$fav->id_saran);
				$data['dt_favorit']=$this->m_models->getAwhereGroup("*", "peg_favorit", $afav, "tgl, nrp_input", "tgl", "asc");
				foreach ($data['dt_favorit'] as $dt_fav){
					//menampilkan data
					$arfav = array('tgl' => $dt_fav->tgl, 'id_saran = '=>$fav->id_saran, 'nrp_input'=>$dt_fav->nrp_input);
					$data['dtfavorit']=$this->m_models->getTabelwhere("*", "peg_favorit", $arfav, "tgl", "asc");
					foreach ($data['dtfavorit'] as $dtfav){
						$data[nrp_fav][$fav->id_saran][$dt_fav->tgl][$dt_fav->nrp_input]=$dtfav->nrp_fav;
					}
				}
			}
		}
		
		$this->load->view('pegawai/rekap_favorit',$data);
		$this->load->view('template/footer');
	}

	public function surat_pengajuan(){
		$this->load->view('template/header'); 
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
		$pengajuan = $this->input->post('pengajuan', TRUE);

		$data['jenis_pengajuan'] = $this->m_models->getTableGroup("*", "approval_pengajuan", "pengajuan", "pengajuan", "asc");

		if ($tgl_dari!= null AND $tgl_sampai != null){
			if ($pengajuan=="cuti"){
				$tabel="peg_cuti";
			} else if ($pengajuan=="izin study"){
				$tabel="peg_izin_studi";
			} else if ($pengajuan=="resign"){
				$tabel="resign";
			} else if ($pengajuan=="mutasi"){
				$tabel="mutasi_pegawai";
			}
			$ar_ajuan = array('tgl_pengajuan >= ' => $tgl_dari, 'tgl_pengajuan <= ' => $tgl_sampai);
			$data['dt_pengajuan']=$this->m_models->getTabelwhere("*", $tabel, $ar_ajuan, "tgl_pengajuan", "asc");
			$data['j_pengajuan']=$pengajuan;
		}
		
		$this->load->view('pegawai/surat_pengajuan',$data);
		$this->load->view('template/footer');
	}

	public function download_pengajuan(){
		$id = $this->uri->segment(3);
		$pengajuan = $this->uri->segment(4);
		$data['j_pengajuan']=$pengajuan;
		$data['id_p']=$id;

		if ($pengajuan=="cuti"){
			$tabel="peg_cuti";
			$id_p="id_pcuti";
		} else if ($pengajuan=="izin study"){
			$tabel="peg_izin_studi";
			$id_p="id_izinstudy";
		} else if ($pengajuan=="resign"){
			$tabel="resign";
			$id_p="id_resign";
		} else if ($pengajuan=="mutasi"){
			$tabel="mutasi_pegawai";
			$id_p="id_mp";
		}
		$ar_ajuan = array($id_p => $id);
		$data['dt_pengajuan']=$this->m_models->getTabelwhere("*", $tabel, $ar_ajuan, "tgl_pengajuan", "asc");
		$data['jml_app'] = $this->m_models->getRowsWhere("*", "approval_history", "id_pengajuan", $id, "tgl", "asc");

		$ar_appajuan = array('id_pengajuan' => $id);
		$data['app_pengajuan']=$this->m_models->getTabelwhere("*", "approval_history", $ar_appajuan, "level_app", "asc");
		foreach ($data['app_pengajuan'] as $app_ajuan) {
			$data['nrp'][]=$app_ajuan->nrp;
		}
		
		$this->load->view('pegawai/download_pengajuan',$data);
	}

	public function master_bpjs(){
		$this->load->view('template/header');
		$nrp_input=$this->session->userdata['nrp']; 
		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		$hariini=date("Y-m-d");
		$jml = $this->input->post('jml', TRUE);	
		$n = $this->input->post('nrp', TRUE);
		if ($jml != ""){
			for ($i=0; $i <= $jml; $i++){ 
				$nrp=$n[$i];
				$istri = $this->input->post('istri'.$nrp, TRUE);
				$anak = $this->input->post('anak'.$nrp, TRUE);
				$tambahan = $this->input->post('tambahan'.$nrp, TRUE);
				$iu = $this->input->post('iuran'.$nrp, TRUE);
				$jnom=substr_count($iu, "."); 
				if ($jnom==0){
					$iuran=$iu;
				} else {
					$iuran=str_replace(".","",$iu);
				}

				if ($nrp != ""){
					$j_bpjs= array('nrp_peserta'=>$nrp, 'istri' => $istri, 'anak' => $anak, 'tambahan' => $tambahan, 'iuran'=>$iuran, 'status'=>'on', 'tgl_input'=>$hariini, 'nrp_input'=>$nrp_input);
					if ($this->m_models->save_data($j_bpjs, 'peg_bpjs') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}
			redirect('pegawai/master_bpjs');
		}

		$ar_bpjs= array('status' => 'on');
		//$data['dt_bpjs']=$this->m_models->getJoin1where("*", "peg_bpjs", "pegawai", "pegawai.nrp=peg_bpjs.nrp_peserta", $ar_bpjs, "nama", "asc");
		$data['dt_bpjs']=$this->m_models->getJoin1("*", "peg_bpjs", "pegawai", "pegawai.nrp=peg_bpjs.nrp_peserta", "nama", "asc");

		$this->load->view('pegawai/m_data_bpjs',$data);
		$this->load->view('template/footer');
	}

	public function cek_pegawai(){
		$id_sekolah = $this->input->get('id_sekolah', TRUE);
		$ar = array('status_aktf' => 'Aktif', 'id_sekolah'=>$id_sekolah);
		$data['pegawai']=$this->m_models->getTabelwhere("*", "pegawai", $ar, "nama", "asc");
		$data['jpegawai']=$this->m_models->getRowsAWhere("*", "pegawai", $ar, "nama", "asc");
		$this->load->view('pegawai/cek_pegawai',$data);
	}

	public function download_master_bpjs(){
		$data['dt_bpjs']=$this->m_models->getJoin1("*", "peg_bpjs", "pegawai", "pegawai.nrp=peg_bpjs.nrp_peserta", "nama", "asc");

		$this->load->view('pegawai/download_master_bpjs',$data);
	}

	public function rekap_bpjs(){
		$this->load->view('template/header');
		$bln = $this->input->post('bln', TRUE);	
		$thn = $this->input->post('thn', TRUE);	
		$data[bln]=$bln;
		$data[thn]=$thn;
		$data[period]="$thn-$bln";
		if (($bln != "")&&($thn != "")){
			$periode="$thn-$bln-31";
			$ar_bpjs= array('status' => 'on', 'tgl_off'=>'0000-00-00', 'tgl_input <='=>$periode);
			$data['dt_bpjs']=$this->m_models->getJoin1where("*", "peg_bpjs", "pegawai", "pegawai.nrp=peg_bpjs.nrp_peserta", $ar_bpjs, "nama", "asc");
		}
		$this->load->view('pegawai/rekap_dt_bpjs',$data);
		$this->load->view('template/footer');
	}

	public function download_dt_bpjs(){
		$bln = $this->uri->segment(3);	
		$thn = $this->uri->segment(4);	
		$data[bln]=$bln;
		$data[thn]=$thn;
		$data[period]="$thn-$bln";
		if (($bln != "")&&($thn != "")){
			$periode="$thn-$bln-31";
			$ar_bpjs= array('status' => 'on', 'tgl_off'=>'0000-00-00', 'tgl_input <='=>$periode);
			$data['dt_bpjs']=$this->m_models->getJoin1where("*", "peg_bpjs", "pegawai", "pegawai.nrp=peg_bpjs.nrp_peserta", $ar_bpjs, "nama", "asc");
		}
		$this->load->view('pegawai/download_dt_bpjs',$data);
	}

	public function off_bpjs(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_p_bpjs = $this->uri->segment(3);
		if ($id_p_bpjs != ""){
			$j_off= array('tgl_off'=>$hariini, 'nrp_off' => $nrp, 'status'=>'off');
			if ($this->m_models->update_data($id_p_bpjs, "id_p_bpjs", $j_off, "peg_bpjs") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dioff');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/master_bpjs');
		} 
		$this->load->view('pegawai/m_data_bpjs',$data);
		$this->load->view('template/footer');
	}

	public function jenis_ajuan_kegiatan(){
		$this->load->view('template/header'); 
        $jenis_kegiatan = $this->input->post('jenis_kegiatan', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);
        if ($jenis_kegiatan != ""){
          	$nourut = $this->m_models->no_urut("peg_jeniskegiatan");
			$no_cuti="JKEG$nourut";

        	$j_cuti = array('id_jenis_keg'=>$no_cuti,'jenis_kegiatan' => $jenis_kegiatan, 'keterangan' => $keterangan, 'status'=>'on');
			if ($this->m_models->save_data($j_cuti, 'peg_jeniskegiatan') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_ajuan_kegiatan');
		}
		$data[jenis_kegiatan]=$this->m_models->getTabelOrder("*", "peg_jeniskegiatan", "jenis_kegiatan", "asc");
		$this->load->view('pegawai/jenis_ajuan_keg',$data);
		$this->load->view('template/footer');
	}
	
	public function ajuan_kegiatan(){ 
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['jenis_kegiatan'] = $this->m_models->getwhere("*", "peg_jeniskegiatan", "status", "on", "jenis_kegiatan", "asc");
        $jenis_kegiatan = $this->input->post('jenis_kegiatan', TRUE);
        $nama_kegiatan = $this->input->post('nama_kegiatan', TRUE); 
        $latar_belakang = $this->input->post('latar_belakang', TRUE); 
        $tujuan = $this->input->post('tujuan', TRUE); 
        $narasumber = $this->input->post('narasumber', TRUE); 
        $peserta = $this->input->post('peserta', TRUE); 
        $tgl_mulai = date_db($this->input->post('tgl_mulai', TRUE)); 
        $tgl_selesai = date_db($this->input->post('tgl_selesai', TRUE)); 
        $waktu_mulai = time_db($this->input->post('waktu_mulai', TRUE)); 
        $waktu_selesai = time_db($this->input->post('waktu_selesai', TRUE)); 
        $tempat = $this->input->post('tempat', TRUE); 
        $hariini=date("Y-m-d");
        if (($jenis_kegiatan != "") && ($nama_kegiatan != "") && ($latar_belakang != "") && ($tujuan != "") && ($tgl_mulai != "")){
          	$nourut = $this->m_models->no_urut("peg_pengajuan_kegiatan");
			$no_cuti="PKEG$nourut";

        	$j_ajuan = array('id_ajuan_kegiatan'=>$no_cuti,'id_jenis_keg' => $jenis_kegiatan, 'nama_kegiatan' => $nama_kegiatan, 'latarbelakang'=>$latar_belakang, 'tujuan'=>$tujuan, 'narasumber'=>$narasumber, 'peserta'=>$peserta, 'tgl_mulai'=>$tgl_mulai, 'tgl_selesai'=>$tgl_selesai, 'wkt_mulai'=>$waktu_mulai, 'wkt_selesai'=>$waktu_selesai, 'tmp_kegiatan'=>$tempat, 'nrp'=>$nrp, 'approve1'=>'Proses', 'approve2'=>'Proses', 'approve3'=>'Proses', 'tgl_pengajuan'=>$hariini);

        	$jml_anggaran = $this->input->post('anggaran', TRUE);
        	$nama_anggaran = $this->input->post('nama_anggaran', TRUE);
	        $volume = $this->input->post('volume', TRUE);
	       	$biaya = $this->input->post('biaya', TRUE);
        	for ($i=0; $i <= $jml_anggaran; $i++){ 
        		$nm_anggaran=$nama_anggaran[$i];
        		$vol = $volume[$i];
        		$jnom=substr_count($biaya[$i], "."); 
        		if ($jnom==0){
					$biay=$biaya[$i];
				} else {
					$biay=str_replace(".","",$biaya[$i]);
				}
        		if (($nm_anggaran != "") && ($vol != "") && ($biay != "")){
        			$a_anggaran=array('id_ajuan_kegiatan'=>$no_cuti,'nama_anggaran' => $nm_anggaran, 'volume' => $vol, 'biaya'=>$biay);
	        		$simpan=$this->m_models->save_data($a_anggaran, 'peg_anggaran_kegiatan');
        		}
        	}

			if ($this->m_models->save_data($j_ajuan, 'peg_pengajuan_kegiatan') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/ajuan_kegiatan');
		}
		
		$this->load->view('pegawai/ajuan_kegiatan',$data); 
		$this->load->view('template/footer');
	}
	
	public function jmlAnggaran(){
		$data[anggaran]=$this->input->get('anggaran');
		$this->load->view('pegawai/jmlAnggaran', $data);
	}

	public function approval_ajuan_kegiatan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['ajuan_kegiatan'] = $this->m_models->getwhere("*", "peg_pengajuan_kegiatan", "approve1", 'Proses', "tgl_pengajuan", "asc");
		foreach ($data['ajuan_kegiatan'] as $ak){
			$biaya=0; 
			$data['anggaran'] = $this->m_models->getwhere("*", "peg_anggaran_kegiatan", "id_ajuan_kegiatan", $ak->id_ajuan_kegiatan, "id_anggaran_keg", "asc");
			foreach ($data['anggaran'] as $ang) { 
				$biaya += $ang->biaya;  
				$id_ajuan_kegiatan=$ak->id_ajuan_kegiatan;
				$data['tot_biaya'][$id_ajuan_kegiatan]=$biaya;
			}
		}
		$this->load->view('pegawai/approval_ajuan_kegiatan',$data);
		$this->load->view('template/footer');
	}

	public function app_ajuan_keg(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_jab_app=all("pegawai", "nrp", $nrp, "id_jabatan");

		$id_ajuan_kegiatan = $this->input->post('id_ajuan_kegiatan', TRUE);
        $ket = $this->input->post('ket', TRUE);
        $alasan = $this->input->post('alasan', TRUE);

		//update pengajuan 
		if ($ket=="A"){
			$k="Approve";
			$ar_app=array('Approve1' => 'Approve', 'Approve2' => 'Approve','Approve3' => 'Approve');
		} else if ($ket=="R"){
			$k="Reject";
			$ar_app=array('approve1' => 'Reject');
		}
		$data['update_data'] = $this->m_models->update_data($id_ajuan_kegiatan, "id_ajuan_kegiatan", $ar_app, "peg_pengajuan_kegiatan");

		//menambahkan ke history update
		$hariini=date("Y-m-d");
		$time=date("H:i:s");
		$j_cuti = array('tgl'=>$hariini, 'waktu' => $time, 'nrp' => $nrp, 'id_pengajuan' => '$id_ajuan_kegiatan', 'status'=>$k, 'keterangan'=>$alasan, 'id_jabatan'=>$id_jab_app, 'level_app'=>'approve1');
		if ($this->m_models->save_data($j_cuti, 'approval_history') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil di '.$k.' ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}

		redirect('pegawai/approval_ajuan_kegiatan');
		$this->load->view('template/footer');
	}

	public function detail_anggaran_keg(){
		$this->load->view('template/header'); 
		$id_ajuan_kegiatan = $this->uri->segment(3);
		$data['anggaran'] = $this->m_models->getwhere("*", "peg_anggaran_kegiatan", "id_ajuan_kegiatan", $id_ajuan_kegiatan, "id_anggaran_keg", "asc");
		$this->load->view('pegawai/detail_anggaran_keg',$data);
		$this->load->view('template/footer');
	}

	public function lap_ajuan_kegiatan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$ar_j=array('status =' => 'on');
		$data['jenis_kegiatan'] = $this->m_models->getTabelwhere("*", "peg_jeniskegiatan", $ar_j, "jenis_kegiatan", "asc");

		$dari = $this->input->post('dari');
		$sampai = $this->input->post('sampai'); 
		$jenis_keg = $this->input->post('jenis_keg'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[jenis_keg]=$jenis_keg;

		//$data['ajuan_kegiatan'] = $this->m_models->getwhere("*", "peg_pengajuan_kegiatan", "approve1", 'Proses', "tgl_pengajuan", "asc");
		if (($dari != "") && ($sampai != "") && ($jenis_keg != "")){
			$ap=array('approve1 =' => 'Approve', 'approve2=' => 'Approve', 'approve3 = '=>'Approve', 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai, 'id_jenis_keg'=>$jenis_keg); 
			$data['ajuan_kegiatan'] = $this->m_models->getTabelwhere("*", "peg_pengajuan_kegiatan", $ap, "tgl_pengajuan", "asc");
			foreach ($data['ajuan_kegiatan'] as $ak){
				$biaya=0; 
				$data['anggaran'] = $this->m_models->getwhere("*", "peg_anggaran_kegiatan", "id_ajuan_kegiatan", $ak->id_ajuan_kegiatan, "id_anggaran_keg", "asc");
				foreach ($data['anggaran'] as $ang){
					$biaya += $ang->biaya;  
					$id_ajuan_kegiatan=$ak->id_ajuan_kegiatan;
					$data['tot_biaya'][$id_ajuan_kegiatan]=$biaya;
				}
			}
		}
			
		$this->load->view('pegawai/lap_ajuan_kegiatan',$data);
		$this->load->view('template/footer');
	}

	public function download_lap_ajuan_kegiatan(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$jenis_keg = $this->uri->segment(5);

		if (($dari != "") && ($sampai != "") && ($jenis_keg != "")){
			$ap=array('approve1 =' => 'Approve', 'approve2=' => 'Approve', 'approve3 = '=>'Approve', 'tgl_pengajuan >='=>$dari, 'tgl_pengajuan <='=>$sampai, 'id_jenis_keg'=>$jenis_keg); 
			$data['ajuan_kegiatan'] = $this->m_models->getTabelwhere("*", "peg_pengajuan_kegiatan", $ap, "tgl_pengajuan", "asc");
			foreach ($data['ajuan_kegiatan'] as $ak){
				$biaya=0; 
				$data['anggaran'] = $this->m_models->getwhere("*", "peg_anggaran_kegiatan", "id_ajuan_kegiatan", $ak->id_ajuan_kegiatan, "id_anggaran_keg", "asc");
				foreach ($data['anggaran'] as $ang){
					$biaya += $ang->biaya;  
					$id_ajuan_kegiatan=$ak->id_ajuan_kegiatan;
					$data['tot_biaya'][$id_ajuan_kegiatan]=$biaya;
				}
			}
		}
			
		$this->load->view('pegawai/download_lap_ajuan_kegiatan',$data);
	}

	public function jenis_program_lpj(){
		$this->load->view('template/header'); 
		
        $program = $this->input->post('program', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);
        $nourut = $this->m_models->no_urut("peg_program_lpj");
		$no_ajuan="PKEG$nourut";

        if (($program != "")&&($keterangan != "")){
			$a_prog= array('id_prog_lpj'=>$no_ajuan, 'nama_program' => $program, 'keterangan' => $keterangan, 'status' => 'on');
			if ($this->m_models->save_data($a_prog, 'peg_program_lpj') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_program_lpj');
		}


		$data['j_prog'] = $this->m_models->getwhere("*", "peg_program_lpj", "status", 'on', "nama_program", "asc");
		$this->load->view('pegawai/jenis_program_lpj',$data);
		$this->load->view('template/footer');
	}

	public function off_jprog_lpj(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_prog_lpj = $this->uri->segment(3);
		if ($id_prog_lpj != ""){
			$j_off= array('tgl_off'=>$hariini, 'nrp_off' => $nrp, 'status'=>'off');
			if ($this->m_models->update_data($id_prog_lpj, "id_prog_lpj", $j_off, "peg_program_lpj") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dioff');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/jenis_program_lpj');
		}
		$this->load->view('pegawai/jenis_program_lpj',$data);
		$this->load->view('template/footer');
	}


	public function lap_kinerja_lpj(){
		$this->load->view('template/header'); 
		$hariini=date("Y-m-d");
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah=all("pegawai", "nrp", $nrp, "id_sekolah");
        $no = $this->input->post('no', TRUE);
        $indikator = $this->input->post('indikator', TRUE);
        $id_prog = $this->input->post('id_prog', TRUE);
       	$nourut = $this->m_models->no_urutGroup("peg_lap_lpj", "id_lap_lpj", "id_lap_lpj");
		$no_ajuan="LPJ$nourut";
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;

		if ($no != 0){
			for ($k=0; $k <= $no; $k++) { 
				$indikatr=$indikator[$k];
				$idprog=$id_prog[$k];
				if (($indikatr != "")&&($idprog != "")){
					$a_prog= array('id_lap_lpj'=>$no_ajuan, 'id_prog_lpj' => $idprog, 'indikator' => $indikatr, 'nrp'=>$nrp, 'id_sekolah'=>$id_sekolah, 'tgl'=>$hariini, 'id_tahun'=>$id_ta);
					if ($this->m_models->save_data($a_prog, 'peg_lap_lpj') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}

			$jumlahFile= count(array_filter($_FILES['file']['name'])); 
			$this->load->library('upload');
			if($jumlahFile != "0"){ 		
				for ($i = 0; $i <= $jumlahFile; $i++) :
					$_FILES['userfile']['name']     = $_FILES['file']['name'][$i];
					$_FILES['userfile']['type']     = $_FILES['file']['type'][$i];
					$_FILES['userfile']['tmp_name'] = $_FILES['file']['tmp_name'][$i];
					$_FILES['userfile']['error']    = $_FILES['file']['error'][$i];
					$_FILES['userfile']['size']     = $_FILES['file']['size'][$i];
					
					$config = array(
						'encrypt_name'      => FALSE,
						'maintain_ratio'    => FALSE,
						'create_thumb'      => FALSE,
						'allowed_types'     => 'jpg|png|jpeg|JPG|PNG',
						'overwrite'         => FALSE,
						'file_name'			=> time().$_FILES['userfile']['name'],
						'upload_path'       => './img_lap_lpj/'
					);

					$this->upload->initialize($config); 
					if (!$this->upload->do_upload()){
						$er = $this->upload->display_errors();
			            print_r($er);
					}else{ 
						$data = array('upload_data' => $this->upload->data());
						$a_img= array('img_lpj'=>$config[file_name], 'id_lap_lpj' => $no_ajuan);
						$this->m_models->save_data($a_img, 'peg_lpj_img');
					}
				endfor;
			}

			redirect('pegawai/lap_kinerja_lpj'); 
		}

        $ap=array('status =' => 'on', 'id_prog_lpj !=' => 'PKEG0015'); 
		$data['j_prog'] = $this->m_models->getTabelwhere("*", "peg_program_lpj", $ap, "id_prog_lpj", "asc");
		$this->load->view('pegawai/lap_kinerja_lpj',$data);
		$this->load->view('template/footer');
	}

	public function lap_lpj(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
        
		$data['j_prog'] = $this->m_models->getTableGroup("*", "peg_lap_lpj", "id_lap_lpj", "id_prog_lpj", "asc");
		foreach ($data['j_prog'] as $j) {
			$id_lap_lpj=$j->id_lap_lpj;
			$ap=array('id_lap_lpj =' => $id_lap_lpj, 'id_prog_lpj =' => 'PKEG0002'); 
			$data['jprog'] = $this->m_models->getTabelwhere("*", "peg_lap_lpj", $ap, "id_prog_lpj", "asc");
			foreach ($data['jprog'] as $jp) {
				$data['nm_prog'][$id_lap_lpj]=$jp->indikator;
			}
		}
		$this->load->view('pegawai/laporan_lpj',$data);
		$this->load->view('template/footer');
	}

	public function detail_lpj(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
        $id_lap_lpj = $this->uri->segment(3);
		$ap=array('id_lap_lpj =' => $id_lap_lpj); 
		$data['jprog'] = $this->m_models->getTabelwhere("*", "peg_lap_lpj", $ap, "id_prog_lpj", "asc");
		$id_tahun=$data['jprog'][0]->id_tahun;

		$data['jimg'] = $this->m_models->getwhere("*", "peg_lpj_img", "id_lap_lpj", $id_lap_lpj, "id_lpj_img", "asc");

		$this->load->view('pegawai/detail_lpj',$data);
		$this->load->view('template/footer');
	}

	public function download_lpj(){ 
		$nrp=$this->session->userdata['nrp'];
        $id_lap_lpj = $this->uri->segment(3);
		$ap=array('id_lap_lpj =' => $id_lap_lpj); 
		$data['jprog'] = $this->m_models->getTabelwhere("*", "peg_lap_lpj", $ap, "id_prog_lpj", "asc");

		$data['jimg'] = $this->m_models->getwhere("*", "peg_lpj_img", "id_lap_lpj", $id_lap_lpj, "id_lpj_img", "asc");

		$this->load->view('pegawai/download_lpj',$data);
	}

	public function jmlfoto(){
		$data[jml]=$this->input->get('jml', TRUE);
		$this->load->view('pegawai/jmlfoto', $data);
	}


	public function input_taklimat(){
		$this->load->view('template/header'); 
		$hariini=date("Y-m-d");
		$nrp=$this->session->userdata['nrp']; 
        $no = $this->input->post('no', TRUE); 
        $kutipan = $this->input->post('kutipan', TRUE);
        $dari = $this->input->post('dari', TRUE);
        $hal = $this->input->post('hal', TRUE);
        $uraian = $this->input->post('uraian', TRUE);
        $jml = $this->input->post('jml', TRUE);

        if (($no != "")&&($kutipan != "")){
	        for ($i=0; $i < $jml; $i++) { 
	        	$t_hal=$hal[$i];
	        	$t_dari=$dari[$i];
	        	$t_uraian=$uraian[$i];

				$a_prog= array('no_taklimat'=>$no, 'kutipan' => $kutipan, 'dari' => $t_dari, 'hal' => $t_hal, 'uraian'=>$t_uraian, 'tgl_input'=>$hariini, 'nrp'=>$nrp);
				$simpan=$this->m_models->save_data($a_prog, 'peg_taklimat');
			}
			if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/input_taklimat');
        }
         
		$data['taklimat'] = $this->m_models->getTableGroup("*", "peg_taklimat", "no_taklimat", "tgl_input", "asc");
		$this->load->view('pegawai/i_taklimat',$data);
		$this->load->view('template/footer');
	}

	public function jmltaklimat(){
		$data[jml]=$this->input->get('jml', TRUE);
		$this->load->view('pegawai/jmltaklimat', $data);
	}

	public function detail_taklimat(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$id_taklimat = $this->uri->segment(3);

		$data['taklimat'] = $this->m_models->getwhere("*", "peg_taklimat", "id_taklimat", $id_taklimat, "tgl_input", "asc");
		$no_taklimat=$data['taklimat'][0]->no_taklimat;
		$data[no_taklimat]=$no_taklimat;
		$data[kutipan]=$data['taklimat'][0]->kutipan;
		$data['dt_taklimat'] = $this->m_models->getwhere("*", "peg_taklimat", "no_taklimat", $no_taklimat, "tgl_input", "asc");
		$this->load->view('pegawai/detail_taklimat',$data);
		$this->load->view('template/footer');
	}

	public function download_taklimat(){ 
		$nrp=$this->session->userdata['nrp']; 

		$id_taklimat = $this->uri->segment(3); 

		$data['taklimat'] = $this->m_models->getwhere("*", "peg_taklimat", "id_taklimat", $id_taklimat, "tgl_input", "asc");
		$no_taklimat=$data['taklimat'][0]->no_taklimat;
		$data[no_taklimat]=$no_taklimat;
		$data[kutipan]=$data['taklimat'][0]->kutipan;
		$data['dt_taklimat'] = $this->m_models->getwhere("*", "peg_taklimat", "no_taklimat", $no_taklimat, "tgl_input", "asc");
		$this->load->view('pegawai/download_taklimat',$data);
	}

	#status pengajuan
	public function status_pengajuan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$data['nrp_user']=$nrp;
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
		$pengajuan = $this->input->post('pengajuan', TRUE);

		$data['jenis_pengajuan'] = $this->m_models->getTableGroup("*", "approval_pengajuan", "pengajuan", "pengajuan", "asc");

		if ($tgl_dari!= null AND $tgl_sampai != null){
			if ($pengajuan=="cuti"){
				$tabel="peg_cuti";
			} else if ($pengajuan=="izin study"){
				$tabel="peg_izin_studi";
			} else if ($pengajuan=="resign"){
				$tabel="resign";
			} else if ($pengajuan=="mutasi"){
				$tabel="mutasi_pegawai";
			}
			if (($id_sekolah=="8") or ($id_sekolah=="13")or ($id_sekolah=="39")){
				$ar_ajuan = array('tgl_pengajuan >= ' => $tgl_dari, 'tgl_pengajuan <= ' => $tgl_sampai);
			} else {
				$ar_ajuan = array('tgl_pengajuan >= ' => $tgl_dari, 'tgl_pengajuan <= ' => $tgl_sampai, 'nrp'=>$nrp);
			}
			
			$data['dt_pengajuan']=$this->m_models->getTabelwhere("*", $tabel, $ar_ajuan, "tgl_pengajuan", "asc");
			$data['j_pengajuan']=$pengajuan;

			foreach ($data['dt_pengajuan'] as $p) {
				if ($p->approve1=="Proses"){
					$app="approve1";
					$ket="Proses";
				} else if (($p->approve1=="Approve") && ($p->approve2=="Proses")){
					$app="approve2";
					$ket="Proses";
				} else if (($p->approve1=="Approve") && ($p->approve2=="Approve") && ($p->approve3=="Proses")){
					$app="approve3";
					$ket="Proses";
				} else if (($p->approve1=="Approve") && ($p->approve2=="Approve") && ($p->approve3=="Approve")){
					$app="approve3";
					$ket="Approve";
				} else if ($p->approve1=="Reject"){
					$app="approve1";
					$ket="Reject";
				} else if (($p->approve1=="Approve") && ($p->approve2=="Reject")){
					$app="approve2";
					$ket="Reject";
				} else if (($p->approve1=="Approve") && ($p->approve2=="Approve") && ($p->approve3=="Reject")){
					$app="approve3";
					$ket="Reject";
				}
				if ($pengajuan=="cuti"){
					$data[status][$p->id_pcuti]=$ket." ".cekStatusPengajuan($p->nrp, $pengajuan, $app);
				} else if ($pengajuan=="izin study"){
					$data[status][$p->id_izinstudy]=$ket." ".cekStatusPengajuan($p->nrp, $pengajuan, $app);
				} else if ($pengajuan=="resign"){
					$data[status][$p->id_resign]=$ket." ".cekStatusPengajuan($p->nrp, $pengajuan, $app);
				} else if ($pengajuan=="mutasi"){
					$data[status][$p->id_mp]=$ket." ".cekStatusPengajuan($p->nrp, $pengajuan, $app);
				}
				
			}
			
		}

		$this->load->view('pegawai/status_pengajuan',$data);
		$this->load->view('template/footer');
	}

	#kenaikan pengkat secara periode 4 tahun sekali
	public function kenaikan_pangkat(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$data[thnbln]=date("Y-m");

		$ar_ajuan = array("status_aktf"=>'Aktif' , 'tgl_masuk !=' => '0000-00-00');
		$data['dt_pengajuan']=$this->m_models->getTabelwhere("*", "pegawai", $ar_ajuan, "nama", "asc");

		$this->load->view('pegawai/kenaikan_pangkat_periodik',$data);
		$this->load->view('template/footer');
	}


	#import data master bpjs
	public function import_master_bpjs(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$data[thnbln]=date("Y-m");

		$ar_ajuan = array("status_aktf"=>'Aktif' , 'tgl_masuk !=' => '0000-00-00');
		$data['dt_pengajuan']=$this->m_models->getTabelwhere("*", "pegawai", $ar_ajuan, "nama", "asc");

		$this->load->view('pegawai/import_master_bpjs',$data);
		$this->load->view('template/footer');
	}

	public function upload_m_bpjs(){
		$nrp=$this->session->userdata['nrp']; 
	  	$fileName = $this->input->post('file', TRUE);

	  	$config['upload_path'] = './assets/upload/'; 
		$config['file_name'] = $fileName;
		$config['allowed_types'] = 'xls|xlsx|csv|ods|ots';
		$config['max_size'] = 10000;

	  	$this->load->library('upload', $config);
	  	$this->upload->initialize($config); 
	  
	  	if (!$this->upload->do_upload('file')) {
		   	$error = array('error' => $this->upload->display_errors());
		   	$this->session->set_flashdata('msg','Ada kesalahan dalam upload'); 
			redirect('pegawai/import_master_bpjs');
	  	} else { 
		   	$media = $this->upload->data();
		   	$inputFileName = 'assets/upload/'.$media['file_name'];
		   
		  	try {
			    $inputFileType = IOFactory::identify($inputFileName);
			    $objReader = IOFactory::createReader($inputFileType);
			    $objPHPExcel = $objReader->load($inputFileName);
		   	} catch(Exception $e) {
		    	die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
	   		}

		    $sheet = $objPHPExcel->getSheet(0);
		   	$highestRow = $sheet->getHighestRow();
		   	$highestColumn = $sheet->getHighestColumn();
		   	$hariini=date("Y-m-d");

	   		for ($row = 2; $row <= $highestRow; $row++){  
		     	$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,
		       	NULL,
		       	TRUE,
		       	FALSE);

		       	$arkary=array('status' =>'off', 'tgl_off'=>$hariini, 'nrp_off'=>$nrp); 
				$dt_kar=$this->m_models->update_data($rowData[0][0], "nrp_peserta", $arkary, "peg_bpjs"); 

			 	$ar_i = array(
			     	"id_p_bpjs"=> '',
			     	"nrp_peserta"=> $rowData[0][0],
			     	"istri"=> $rowData[0][1],
			     	"anak"=> $rowData[0][2],
			     	"tambahan"=> $rowData[0][3],
			     	"iuran"=> $rowData[0][4],
			     	"status"=> 'on', 
			     	"tgl_input"=>$hariini, 
			     	"nrp_input"=>$nrp
	    		); 
	    		if ($rowData[0][0] != ""){
	    			$this->m_models->save_data($ar_i, 'peg_bpjs');
	    		}
	   		} 
		   	// delete file
	        unlink($inputFileName);

	   		$this->session->set_flashdata('msg','Berhasil upload ...!!'); 
	   		redirect('pegawai/import_master_bpjs'); 
	  	}  
	} 

	public function download_file_m_bpjs($nm_file, $tipe_file){
		$this->load->view('template/header');
		$this->load->helper('download');
		
		force_download('assets/upload/'.$nm_file.'.'.$tipe_file, NULL);
	}

	#status angket
	public function status_angket(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_status = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");

		if ($id_status != ""){
			$j_off= array('tgl'=>$hariini, 'petugas' => $nrp, 'status'=>$ket);
			if ($this->m_models->update_data($id_status, "id_status", $j_off, "peg_status_angket") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil di '.$ket.' ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('pegawai/status_angket');
		}

        $data['angket'] = $this->m_models->getTabelOrder("*", "peg_status_angket", "nama_angket", "asc");

		$this->load->view('pegawai/statusangket',$data);
		$this->load->view('template/footer');
	}

	public function statistik_pegawai(){
		$this->load->view('template/header');

		$data['list_sdm']=$this->m_models->get_data("id_sekolah, nama", "sekolah", "where nama not like '%2%'");
		foreach ($data['list_sdm'] as $sdm){
			$id_sekolah=$sdm->id_sekolah;
			//echo $id_sekolah;
			$data['pegawai']=$this->m_models->getDataByID("pegawai", "id_sekolah", $id_sekolah);
			$ap=array('id_sekolah' => $id_sekolah, "status_aktf"=>"Aktif", "id_jabatan!="=>"42", "id_jabatan!="=>"65");
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ap, "nrp", "asc");
			$jml=0; $jkp=0; $jkl=0;
				foreach ($data['pegawai'] as $peg){
					$jml=$jml+1;
					$jk=$peg->jk;
					if($jk=='Perempuan'){
						$jkp=$jkp+1;
						$j_p += 1;
					}else if($jk=='Laki-laki'){
						$jkl=$jkl+1;
						$j_l += 1;
					}
					$arr_jum[$id_sekolah] = $jml;
					$arr_jkp[$id_sekolah]['Perempuan'] = $jkp;
					$arr_jkl[$id_sekolah]['Laki-laki'] = $jkl;
				}
			//$al=array("status_aktf"=>"Tidak Aktif", "jk"=>"Laki-laki", "id_sekolah not in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_laki'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Laki-laki' and (id_jabatan!='42' and id_jabatan!='65') and id_sekolah not in (select id_sekolah from sekolah where nama like '%2%') order by nrp asc");

			$ap=array("status_aktf"=>"Tidak Aktif", "jk"=>"Perempuan", "id_sekolah not in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_pr'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Perempuan' and (id_jabatan!='42' and id_jabatan!='65') and id_sekolah not in (select id_sekolah from sekolah where nama like '%2%')");
		}
		$data['tjml'] = $arr_jum;
		$data['tjkp'] = $arr_jkp;
		$data['tjkl'] = $arr_jkl;

		$data['jkp'] = $j_p;
		$data['jkl'] = $j_l;

		#AM 2
		$data['listsdm']=$this->m_models->get_data("id_sekolah, nama", "sekolah", " where nama like '%2%'");
		foreach ($data['listsdm'] as $sdm2){
			$id_sekolah2=$sdm2->id_sekolah;
			//echo $id_sekolah;
			$data['pegawai2']=$this->m_models->getDataByID("pegawai", "id_sekolah", $id_sekolah2);
			$ap2=array('id_sekolah' => $id_sekolah2, "status_aktf"=>"Aktif", "id_jabatan!="=>"42", "id_jabatan!="=>"65");
			$data['pegawai2'] = $this->m_models->getTabelwhere("*", "pegawai", $ap2, "nrp", "asc");
			$jml2=0; $jkp2=0; $jkl2=0;
				foreach ($data['pegawai2'] as $peg2){
					$jml2=$jml2+1;
					$jk2=$peg2->jk;
					if($jk2=='Perempuan'){
						$jkp2=$jkp2+1;
						$j_p2 += 1;
					}else if($jk2=='Laki-laki'){
						$jkl2=$jkl2+1;
						$j_l2 += 1;
					}
					$arr_jum2[$id_sekolah2] = $jml2;
					$arr_jkp2[$id_sekolah2]['Perempuan'] = $jkp2;
					$arr_jkl2[$id_sekolah2]['Laki-laki'] = $jkl2;
				}
			$al2=array("status_aktf"=>"Tidak Aktif", "jk"=>"Laki-laki", "id_sekolah in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_laki2'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Laki-laki' and (id_jabatan!='42' and id_jabatan!='65') and id_sekolah in (select id_sekolah from sekolah where nama like '%2%')");

			$ap2=array("status_aktf"=>"Tidak Aktif", "jk"=>"Perempuan", "id_sekolah in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_pr2'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Perempuan' and (id_jabatan!='42' and id_jabatan!='65') and id_sekolah in (select id_sekolah from sekolah where nama like '%2%')");
		}
		$data['tjml2'] = $arr_jum2;
		$data['tjkp2'] = $arr_jkp2;
		$data['tjkl2'] = $arr_jkl2;

		$data['jkp2'] = $j_p2;
		$data['jkl2'] = $j_l2;



		// Dapur dan laundry Al Multazam 1
		$data['list_sdm']=$this->m_models->get_data("id_sekolah, nama", "sekolah", "where nama not like '%2%'");
		foreach ($data['list_sdm'] as $sdm3){
			$id_sekolah3=$sdm3->id_sekolah;
			//echo $id_sekolah;
			//$data['pegawai']=$this->m_models->getDataByID("pegawai", "id_sekolah", $id_sekolah3);
			$ap=array('id_sekolah' => $id_sekolah3, "status_aktf"=>"Aktif", "id_jabatan="=>"42");
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ap, "nrp", "asc");
			$jml3=0; $jkp3=0; $jkl3=0;
				foreach ($data['pegawai'] as $peg3){
					$jml3=$jml3+1;
					$jk3=$peg3->jk;
					if($jk3=='Perempuan'){
						$jkp3=$jkp3+1;
						$j_p3 += 1;
					}else if($jk3=='Laki-laki'){
						$jkl3=$jkl3+1;
						$j_l3 += 1;
					}
					$arr_jum3[$id_sekolah] = $jml3;
					$arr_jkp3[$id_sekolah]['Perempuan'] = $jkp3;
					$arr_jkl3[$id_sekolah]['Laki-laki'] = $jkl3; 
				}
			//$al=array("status_aktf"=>"Tidak Aktif", "jk"=>"Laki-laki", "id_sekolah not in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_laki3'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Laki-laki' and id_jabatan='42' and id_sekolah not in (select id_sekolah from sekolah where nama like '%2%') order by nrp asc");

			$ap3=array("status_aktf"=>"Tidak Aktif", "jk"=>"Perempuan", "id_sekolah not in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_pr3'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Perempuan' and id_jabatan='42' and id_sekolah not in (select id_sekolah from sekolah where nama like '%2%')");
		}
		$data['tjml3'] = $arr_jum3;
		$data['tjkp3'] = $arr_jkp3;
		$data['tjkl3'] = $arr_jkl3;

		$data['jkp3'] = $j_p3;
		$data['jkl3'] = $j_l3;




		$data['list_sdm']=$this->m_models->get_data("id_sekolah, nama", "sekolah", "where nama not like '%2%'");
		foreach ($data['list_sdm'] as $sdm4){
			$id_sekolah4=$sdm4->id_sekolah;
			//echo $id_sekolah;
			//$data['pegawai']=$this->m_models->getDataByID("pegawai", "id_sekolah", $id_sekolah4);
			$ap=array('id_sekolah' => $id_sekolah4, "status_aktf"=>"Aktif", "id_jabatan="=>"65");
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ap, "nrp", "asc");
			$jml4=0; $jkp4=0; $jkl4=0;
				foreach ($data['pegawai'] as $peg4){
					$jml4=$jml4+1;
					$jk4=$peg4->jk;
					if($jk4=='Perempuan'){
						$jkp4=$jkp4+1;
						$j_p4 += 1;
					}else if($jk4=='Laki-laki'){
						$jkl4=$jkl4+1;
						$j_l4 += 1;
					}
					$arr_jum4[$id_sekolah] = $jml4;
					$arr_jkp4[$id_sekolah]['Perempuan'] = $jkp4;
					$arr_jkl4[$id_sekolah]['Laki-laki'] = $jkl4;
				}
			//$al=array("status_aktf"=>"Tidak Aktif", "jk"=>"Laki-laki", "id_sekolah not in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_laki4'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Laki-laki' and id_jabatan='65' and id_sekolah not in (select id_sekolah from sekolah where nama like '%2%') order by nrp asc");

			//$ap4=array("status_aktf"=>"Tidak Aktif", "jk"=>"Perempuan", "id_sekolah not in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_pr4'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Perempuan' and id_jabatan='65' and id_sekolah not in (select id_sekolah from sekolah where nama like '%2%')");
		}
		$data['tjml4'] = $arr_jum4;
		$data['tjkp4'] = $arr_jkp4;
		$data['tjkl4'] = $arr_jkl4;

		$data['jkp4'] = $j_p4;
		$data['jkl4'] = $j_l4;

		#AM 2
		#Dapur AM 2
		$data['listsdm']=$this->m_models->get_data("id_sekolah, nama", "sekolah", "where nama like '%2%'");
		foreach ($data['listsdm'] as $sdm5){
			$id_sekolah5=$sdm5->id_sekolah;
			//echo $id_sekolah;
			//$data['pegawai3']=$this->m_models->getDataByID("pegawai", "id_sekolah", $id_sekolah2);
			/*$ap2=array('id_sekolah' => $id_sekolah2, "status_aktf"=>"Aktif", "id_jabatan!="=>"42");
			$data['pegawai2'] = $this->m_models->getTabelwhere("*", "pegawai", $ap2, "nrp", "asc");*/
			$data['pegawai5'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' and id_jabatan='42' and id_sekolah='$id_sekolah5'");

			$jml5=0; $jkp5=0; $jkl5=0;
				foreach ($data['pegawai5'] as $peg5){
					$jml5=$jml5+1;
					$jk5=$peg5->jk;
					if($jk5=='Perempuan'){
						$jkp5=$jkp5+1;
						$j_p5 += 1;
					}else if($jk5=='Laki-laki'){
						$jkl5=$jkl5+1;
						$j_l5 += 1;
					}

					$arr_jum5[$id_sekolah5] = $jml5;
					$arr_jkp5[$id_sekolah5]['Perempuan'] = $jkp5;
					$arr_jkl5[$id_sekolah5]['Laki-laki'] = $jkl5;
				}
			$al5=array("status_aktf"=>"Tidak Aktif", "jk"=>"Laki-laki", "id_sekolah in"=>"(select id_sekolah from sekolah where nama like %2%)");
			$data['nonaktif_laki5'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Laki-laki' and id_jabatan='42'and id_sekolah in (select id_sekolah from sekolah where nama like '%2%')");

			$ap5=array("status_aktf"=>"Tidak Aktif", "jk"=>"Perempuan", "id_sekolah in"=>"(select id_sekolah from sekolah where nama not like %2%)");
			$data['nonaktif_pr5'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Perempuan' and id_jabatan='42'  and id_sekolah in (select id_sekolah from sekolah where nama like '%2%')");
		}
		$data['tjml5'] = $arr_jum5;
		$data['tjkp5'] = $arr_jkp5;
		$data['tjkl5'] = $arr_jkl5;

		$data['jkp5'] = $j_p5;
		$data['jkl5'] = $j_l5;


		#Laundry AM2
		$data['listsdm']=$this->m_models->get_data("id_sekolah, nama", "sekolah", "where nama like '%2%'");
		foreach ($data['listsdm'] as $sdm6){
			$id_sekolah6=$sdm6->id_sekolah;

			//echo $id_sekolah;
			//$data['pegawai3']=$this->m_models->getDataByID("pegawai", "id_sekolah", $id_sekolah2);
			/*$ap2=array('id_sekolah' => $id_sekolah2, "status_aktf"=>"Aktif", "id_jabatan!="=>"42");
			$data['pegawai2'] = $this->m_models->getTabelwhere("*", "pegawai", $ap2, "nrp", "asc");*/
			$data['pegawai6'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' and id_jabatan='65' and id_sekolah='$id_sekolah6'");

			$jml6=0; $jkp6=0; $jkl6=0;
				foreach ($data['pegawai6'] as $peg6){
					$jml6=$jml6+1;
					$jk6=$peg6->jk;
					if($jk6=='Perempuan'){
						$jkp6=$jkp6+1;
						$j_p6 += 1;
					}else if($jk6=='Laki-laki'){
						$jkl6=$jkl6+1;
						$j_l6 += 1;
					}

					$arr_jum6[$id_sekolah6] = $jml6;
					$arr_jkp6[$id_sekolah6]['Perempuan'] = $jkp6;
					$arr_jkl6[$id_sekolah6]['Laki-laki'] = $jkl6;
				}
			$al6=array("status_aktf"=>"Tidak Aktif", "jk"=>"Laki-laki", "id_sekolah in"=>"(select id_sekolah from sekolah where nama like '%2%')");
			$data['nonaktif_laki6'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Laki-laki' and id_jabatan='65' and id_sekolah in (select id_sekolah from sekolah where nama  like '%2%')");

			$ap4=array("status_aktf"=>"Tidak Aktif", "jk"=>"Perempuan", "id_sekolah in"=>"(select id_sekolah from sekolah where nama not like '%2%')");
			$data['nonaktif_pr6'] = $this->m_models->getRows("pegawai where status_aktf='Tidak Aktif' and jk='Perempuan' and id_jabatan='65' and id_sekolah in (select id_sekolah from sekolah where nama  like '%2%')");
		}
		$data['tjml6'] = $arr_jum6;
		$data['tjkp6'] = $arr_jkp6;
		$data['tjkl6'] = $arr_jkl6;

		$data['jkp6'] = $j_p6;
		$data['jkl6'] = $j_l6;




		$this->load->view('pegawai/statistik_pegawai',$data);
		$this->load->view('template/footer');
	}

	public function cekNrp(){
		$nrp=$this->input->get("nrp");
		$dataNRP = $this->m_models->getDataByIDQ("pegawai", "nrp", $nrp);
		if($dataNRP == 0){
			echo "<div class='alert alert-success' id='idhide' val='false'><i class='fa fa-check'></i> nrp tersedia</div>";
		}else{
			echo "<div class='alert alert-danger' id='idhide' val='true'><i class='fa fa-remove'></i> nrp sudah ada</div>";
		}
	}

	
	public function ptt(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 

		$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan where TIMESTAMPDIFF(YEAR, tgl_masuk, NOW()) < 1 and status_aktf='Aktif' order by nama asc");


		$this->load->view('pegawai/ptt',$data);

		$this->load->view('template/footer');
	}

	public function update_ptt(){
		$nrp = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		if ($ket=="tl"){
			$ar_u=array("status_aktf"=>"Tidak Aktif");
			$up_ptt = $this->m_models->update_data($nrp, "nrp", $ar_u, "pegawai");
		} 
		if ($up_ptt == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
        }

		redirect('pegawai/ptt');
	}


	function login_pegawai(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");

	    if (($id_sekolah=="8") or ($id_sekolah=="13")){
	    	//$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
			$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$ar=array('status_aktif' => 'on', 'id_sekolah'=>$id_sekolah);
			$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
		}

		
		$status = $this->input->post('status'); 
		if ($status != ""){
			if ($status=="all"){
				$data['pegawai'] = $this->m_models->getAll('pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan order by nama asc');
			} else if ($status!="all"){ 
				$data['pegawai'] = $this->m_models->getAll("pegawai join jabatan on jabatan.id_jabatan=pegawai.id_jabatan and status_aktf='$status' order by nama asc");
			} 
			foreach ($data['pegawai'] as $p) {
				$arr=array('nrp' => $p->nrp);
				$data['login'] = $this->m_models->getTabelwhere("*", "tb_pengguna", $arr, "id_pengguna", "asc");
				$data['username'][$p->nrp] = $data['login'][0]->username;
				$data['password'][$p->nrp] = $data['login'][0]->pwd;
				$data['last_aktif'][$p->nrp] = $data['login'][0]->last_aktif;
				$ex=explode("+", $data['login'][0]->hak_akses);
				for ($i=0; $i < count($ex); $i++) { 
					$data['level_user'][$p->nrp] .= all("level_user", "id_level", $ex[$i], "nama_level").", ";
				}				
			}
		}
		
		$this->load->view('pegawai/login_pegawai',$data);

		$this->load->view('template/footer');
	}

	
	function kenaikan_golongan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_sekolah']=$id_sekolah;
	    $bulan = $this->input->post('bulan');
	    $tahun = $this->input->post('tahun');
	    $periode=$tahun."-".$bulan;
	    $data['periode']=$periode;
	    $data['bulan']=$bulan;

	    $ap=array('status_aktf'=>"Aktif", 'id_sekolah != '=>'11', 'id_sekolah !='=>'10', 'id_sekolah!='=>'19', 'id_sekolah !=  '=>'20');
		$data['pegawai'] = $this->m_models->getTabelwhere("nrp, nama, id_sekolah, pend_akhir, tgl_masuk, tgl_masuk_baru, tgl_ijazah_baru, id_golongan, ijazah_baru", "pegawai", $ap, "nrp", "asc");
		
		$this->load->view('pegawai/kenaikan_golongan',$data);
		$this->load->view('template/footer');
	}


	function data_golongan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $data['id_sekolah']=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_jabatan']=$this->m_models->getSession($nrp, "id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 

	    if (($id_sekolah=="8") or ($id_sekolah=="13") or ($id_sekolah=="39")){
			$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$ar=array('status_aktif' => 'on', 'id_sekolah'=>$id_sekolah);
			$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
		}

	    $jenjang = $this->input->post('jenjang');

	    $ap=array('status_aktf'=>"Aktif", 'id_sekolah'=>$jenjang);
		$data['pegawai'] = $this->m_models->getTabelwhere("nrp, nama, id_sekolah, pend_akhir, tgl_masuk, tgl_masuk_baru, tgl_ijazah_baru, id_golongan, ijazah_baru", "pegawai", $ap, "nrp", "asc");
		$data['golongan']=$this->m_models->getAll("golongan");
		
		$this->load->view('pegawai/data_golongan',$data);
		$this->load->view('template/footer');
	}
	
	
	public function resume_absen_thn(){
		$this->load->view('template/header'); 
		$nrp_input=$this->session->userdata['nrp']; 
		$data['jenis_kegiatan']=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['id_ta']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		

		$tahun = $this->input->post('tahun', TRUE);
		//$id_j_kegiatan = $this->input->post('jenis_keg', TRUE);
		$data[tahun]=$tahun;
		$tawal =$tahun."-01-01";
		$takhir =$tahun."-12-31";
		$data[id_j_kegiatan]=$id_j_kegiatan;
		if ($tahun != ""){ 
		   $data['peg'] = $this->m_models->get_data("nama,nrp,id_sekolah,id_jabatan","pegawai","where status_aktf='Aktif' and nrp <> '1' order by id_sekolah,nama asc");
		
			$data['t_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "id_tahun", $id_tahun, "tahun2", "desc");
			$data['periode']=$data['t_akademik'][0]->periode;
			
			$data['kegiatan'] = $this->m_models->get_data("peg_absensi_kegiatan.id_j_kegiatan,jenis_kegiatan,tgl","peg_absensi_kegiatan join peg_kegiatan on peg_absensi_kegiatan.id_j_kegiatan = peg_kegiatan.id_j_kegiatan"," where peg_absensi_kegiatan.tgl between '$tawal' and '$takhir' group by tgl, peg_absensi_kegiatan.id_j_kegiatan");
			$data['jkegiatan'] = $this->m_models->getRows("peg_absensi_kegiatan join peg_kegiatan on peg_absensi_kegiatan.id_j_kegiatan = peg_kegiatan.id_j_kegiatan  where peg_absensi_kegiatan.tgl between '$tawal' and '$takhir' group by tgl, peg_absensi_kegiatan.id_j_kegiatan");
			
			foreach ($data['peg'] as $pg){
				$hadirkeg = $this->m_models->get_data("absensi,ket_absensi,tgl,id_j_kegiatan","peg_absensi_kegiatan","where nrp='$pg->nrp' and tgl between '$tawal' and '$takhir' ");
				foreach ($hadirkeg as $h){
					$data['ket_absen'][$pg->nrp][$h->tgl][$h->id_j_kegiatan] = $h->ket_absensi;
					$data['abs'][$pg->nrp][$h->tgl][$h->id_j_kegiatan] = $h->absensi;
				}
			}
		}
		$this->load->view('pegawai/rekap_absensi_tahunan',$data);
		$this->load->view('template/footer');
	}
	
	public function download_resume_abs_keg_tahunan(){
		$nrp_input=$this->session->userdata['nrp']; 
		$data['jenis_kegiatan']=$this->m_models->getTabelOrder("*", "peg_kegiatan", "jenis_kegiatan", "asc");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['id_ta']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		

		$tahun = $this->uri->segment(3);
		//$id_j_kegiatan = $this->input->post('jenis_keg', TRUE);
		$data[tahun]=$tahun;
		$tawal =$tahun."-01-01";
		$takhir =$tahun."-12-31";
		$data[id_j_kegiatan]=$id_j_kegiatan;
		if ($tahun != ""){ 
		   $data['peg'] = $this->m_models->get_data("nama,nrp,id_sekolah,id_jabatan","pegawai","where status_aktf='Aktif' and nrp <> '1' order by id_sekolah,nama asc");
		
			$data['t_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "id_tahun", $id_tahun, "tahun2", "desc");
			$data['periode']=$data['t_akademik'][0]->periode;
			
			$data['kegiatan'] = $this->m_models->get_data("peg_absensi_kegiatan.id_j_kegiatan,jenis_kegiatan,tgl","peg_absensi_kegiatan join peg_kegiatan on peg_absensi_kegiatan.id_j_kegiatan = peg_kegiatan.id_j_kegiatan"," where peg_absensi_kegiatan.tgl between '$tawal' and '$takhir' group by tgl, peg_absensi_kegiatan.id_j_kegiatan");
			$data['jkegiatan'] = $this->m_models->getRows("peg_absensi_kegiatan join peg_kegiatan on peg_absensi_kegiatan.id_j_kegiatan = peg_kegiatan.id_j_kegiatan  where peg_absensi_kegiatan.tgl between '$tawal' and '$takhir' group by tgl, peg_absensi_kegiatan.id_j_kegiatan");
			
			foreach ($data['peg'] as $pg){
				$hadirkeg = $this->m_models->get_data("absensi,ket_absensi,tgl,id_j_kegiatan","peg_absensi_kegiatan","where nrp='$pg->nrp' and tgl between '$tawal' and '$takhir' ");
				foreach ($hadirkeg as $h){
					$data['ket_absen'][$pg->nrp][$h->tgl][$h->id_j_kegiatan] = $h->ket_absensi;
					$data['abs'][$pg->nrp][$h->tgl][$h->id_j_kegiatan] = $h->absensi;
				}
			}
		}

		$this->load->view('pegawai/download_resume_abs_keg_tahunan',$data);
	}
	
	
	
	
}