<?php
error_reporting(0);defined('BASEPATH') OR exit('No direct script access allowed');
class Odoj extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
	}

	function http_request($url){
	    // persiapkan curl
	    $ch = curl_init(); 

	    // set url 
	    curl_setopt($ch, CURLOPT_URL, $url);

	    // return the transfer as a string 
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 

	    // $output contains the output string 
	    $output = curl_exec($ch); 

	    // tutup curl 
	    curl_close($ch);      

	    // mengembalikan hasil curl
	    return $output;
	}

	function rekap(){
		$this->load->view('template/header');

        $data['group'] = $this->m_models->get_data("*", "odoj_group", "ORDER BY id_group ASC");

		# tampilkan data ke view
		$this->load->view('odoj/rekap', $data); 

		$this->load->view('template/footer');	
	}

	function getPeriodeRekap(){
		$jenis_periode = $this->input->get('jenis_periode'); 

		if ($jenis_periode != null) {
			$data['jenis_periode'] = $jenis_periode;
			$this->load->view('odoj/f_periode_rekap', $data);
		}

		$this->load->view('template/js');
	}

	function rekap_data(){
		$jenis_periode = $this->input->post('jenis_periode', TRUE);
		$id_group = $this->input->post('group_odoj', TRUE);

		if ($jenis_periode == 'harian' && $id_group != NULL) {

			$rentangtanggal = $this->input->post('rentangtanggal', TRUE);
			$exp = explode("-", $rentangtanggal);
			$tanggal_mulai = to_Ymd2(trim($exp[0]));
			$tanggal_sampai = to_Ymd2(trim($exp[1]));
			
			$this->rekap_data_harian($id_group, $tanggal_mulai, $tanggal_sampai);

		}elseif ($jenis_periode == 'bulanan' && $id_group != NULL) {
			$bln1 = $this->input->post('bln', TRUE);
			$thn1 = $this->input->post('thn', TRUE);
			$bln2 = $this->input->post('bln2', TRUE);
			$thn2 = $this->input->post('thn2', TRUE);

			$bulan1 = $thn1.$bln1;
			$bulan2 = $thn2.$bln2;

			if ( $bulan1 <= $bulan2 ) {
				$bulan1 = $thn1.'-'.$bln1;
				$bulan2 = $thn2.'-'.$bln2;
			}else{
				$bulan1 = $thn2.'-'.$bln2;
				$bulan2 = $thn1.'-'.$bln1;				
			}

			$this->rekap_data_bulanan($id_group, $bulan1, $bulan2);
		}else{
			$this->session->set_flashdata('info', 'Kriteria pencarian belum dipilih, silakan lengkapi form.');
			$this->load->view('odoj/notification'); 
		}
	}

	function rekap_data_harian($id_group, $tanggal_mulai, $tanggal_sampai){

		$log = $this->http_request("https://core.simalmultazam.com/public/odoj_rekap_harian/$id_group/$tanggal_mulai/$tanggal_sampai?MAYkey=256007");
		$data['odoj'] = json_decode($log, TRUE);

		$dt1 = new DateTime($tanggal_mulai);
		$dt2 = new DateTime($tanggal_sampai);
		$interval = $dt1->diff($dt2);

		$data['jumlah_hari'] = $interval->days;
		$data['tanggal_mulai'] = $tanggal_mulai;
		$data['tanggal_sampai'] = $tanggal_sampai;

		$this->load->view('odoj/rekap_data_harian', $data);

	}

	function rekap_data_bulanan($id_group, $bulan1, $bulan2){

		$log = $this->http_request("https://core.simalmultazam.com/public/odoj_rekap_bulanan/$id_group/$bulan1/$bulan2?MAYkey=256007");
		// ubah string JSON menjadi array
		$data['odoj'] = json_decode($log, TRUE);

		$this->load->view('odoj/rekap_data_bulanan', $data);

	}

	function getPeriodeBulananODOJ($bulan1){
		# mencari tanggal pertama hari ke berapa di minggu itu
		# minggu hari ke 0, senin hari ke 2 dst
		
		$tgl_satu_bulan1 = $bulan1.'-01';
		$tgl_satu_bulan1_harike = date('w',strtotime($tgl_satu_bulan1));

		# mencari tgl pertama minggu pertama
		switch ($tgl_satu_bulan1_harike) {
			case '0':
				$tgl_1_minggu_1 = date('Y-m-d', strtotime("+1 day", strtotime($tgl_satu_bulan1)));
				break;
			case '1':
				$tgl_1_minggu_1 = $tgl_satu_bulan1;
				break;
			case '2':
				$tgl_1_minggu_1 = date('Y-m-d', strtotime("-1 day", strtotime($tgl_satu_bulan1)));
				break;
			case '3':
				$tgl_1_minggu_1 = date('Y-m-d', strtotime("-2 day", strtotime($tgl_satu_bulan1)));
				break;
			case '4':
				$tgl_1_minggu_1 = date('Y-m-d', strtotime("-3 day", strtotime($tgl_satu_bulan1)));
				break;
			case '5':
				$tgl_1_minggu_1 = date('Y-m-d', strtotime("+3 day", strtotime($tgl_satu_bulan1)));
				break;
			case '6':
				$tgl_1_minggu_1 = date('Y-m-d', strtotime("+2 day", strtotime($tgl_satu_bulan1)));
				break;
			default:
				$tgl_1_minggu_1 = '0000-00-00';
				break;
		}

		$data['tgl_pertama'] = $tgl_1_minggu_1;

		$hari_kamis_minggu_5 = date('Y-m-d', strtotime("+31 day", strtotime($tgl_1_minggu_1)));

		$bulan_minggu_5 = substr($hari_kamis_minggu_5, 5, 2);
		$bulan_bulan1 = substr($bulan1, 5, 2);

		if ($bulan_minggu_5 == $bulan_bulan1) {
			$data['tgl_terakhir'] = date('Y-m-d', strtotime("+34 day", strtotime($tgl_1_minggu_1)));
		}else{
			$data['tgl_terakhir'] = date('Y-m-d', strtotime("+27 day", strtotime($tgl_1_minggu_1)));
		}

		return $data;
	}

	function rangking(){
		$this->load->view('template/header');

		$periode_bulan_odoj = $this->getPeriodeBulananODOJ(date('Y-m'));
		$tgl_pertama = preg_replace("/[^0-9]/", "", $periode_bulan_odoj['tgl_pertama']);
		$tgl_terakhir = preg_replace("/[^0-9]/", "", $periode_bulan_odoj['tgl_terakhir']);  
		$tgl_cari = date('Ymd');

		if ($tgl_cari >= $tgl_pertama AND $tgl_cari <= $tgl_terakhir) {
			$data['periode_bulan_odoj'] = $periode_bulan_odoj;
		}else{
			$periode_bulan_odoj = $this->getPeriodeBulananODOJ(date('Y-m', strtotime(date('Y-m') . '- 1 month')));
			$tgl_pertama = preg_replace("/[^0-9]/", "", $periode_bulan_odoj['tgl_pertama']);
			$tgl_terakhir = preg_replace("/[^0-9]/", "", $periode_bulan_odoj['tgl_terakhir']);  
			$tgl_cari = date('Ymd');
			if ($tgl_cari >= $tgl_pertama AND $tgl_cari <= $tgl_terakhir) {
				$data['periode_bulan_odoj'] = $periode_bulan_odoj;
			}else{
				$periode_bulan_odoj = $this->getPeriodeBulananODOJ(date('Y-m', strtotime(date('Y-m') . '+ 1 month')));
			}
		}

		# tampilkan data ke view
		$this->load->view('odoj/rangking', $data); 

		$this->load->view('template/footer');	
	}

	function getGroupOdoj(){
		$jenis = $this->input->get('jenis'); 

		$data['jenis'] = $jenis;
		$data['group'] = $this->m_models->get_data("*", "odoj_group", "ORDER BY id_group ASC");

		$this->load->view('odoj/f_group_odoj', $data);

		$this->load->view('template/js');
	}

	function rangking_data(){
		$rentangtanggal = $this->input->post('rentangtanggal', TRUE);
		$exp = explode("-", $rentangtanggal);
		$tanggal_mulai = to_Ymd2(trim($exp[0]));
		$tanggal_sampai = to_Ymd2(trim($exp[1]));

		$jumlah_ranking = $this->input->post('jumlah_ranking', TRUE);
		$jenis = $this->input->post('jenis', TRUE);

		if ($jumlah_ranking != 0 ) {
			$log = $this->http_request("https://core.simalmultazam.com/public/odoj_rangking/$jenis/$jumlah_ranking/$tanggal_mulai/$tanggal_sampai?MAYkey=256007");
			$data['odoj'] = json_decode($log, TRUE);

			if ($jenis == 'individu') {

				$this->load->view('odoj/rangking_data_individu', $data);

			}elseif ($jenis == 'kelompok') { 

				$this->load->view('odoj/rangking_data_kelompok', $data);
			}

		}else{
			$this->session->set_flashdata('info', 'Silakan isi jumlah data yang akan ditampilkan!');
			$this->load->view('odoj/notification'); 
		}
	}

}