<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Menu extends CI_Controller {
	function __construct() {
		parent::__construct();
		$this->load->helper('url');
        $this->load->library('pagination');
        $this->load->library('session');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	public function menu_utama(){ 
		//menampilkan tampilan header konten
		$this->load->view('template/header');
	
		$icon = $this->input->post('icon', TRUE);
		$judul = $this->input->post('judul', TRUE);
		if (($icon != "") && ($judul != "")){
			$nilai = array('jdl_menu_utama' => $judul, 'lnk_menu_utama'=> '#', 'icon_menu_utama'=>'fa '.$icon);
			if($this->m_models->save_data($nilai,"menu_utama") == TRUE){
	    		$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    	}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	} 
			redirect('menu/menu_utama');
		}

		$data['menuutama']=$this->m_models->getAll("menu_utama");
		$this->load->view('menu/menu_utama',$data);		
		$this->load->view('template/footer');
	}

	public function sub_menu(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['level_user'] = $this->m_models->getTabelOrder("*", "level_user", "nama_level", "asc");
		$data['menu_utama'] = $this->m_models->getTabelOrder("*", "menu_utama", "jdl_menu_utama", "asc");
		$data['sub_menu'] = $this->m_models->getJoin1("*", "sub_menu", "menu_utama", "menu_utama.id_menu_utama=sub_menu.id_menu_utama", "jdl_submenu", "asc");
		$menu_utama = $this->input->post('menu_utama', TRUE);
		$icon = $this->input->post('icon', TRUE);
		$judul = $this->input->post('judul', TRUE);	
		if (($menu_utama != "") && ($judul != "")&& ($icon != "")){
			$this->db->query("INSERT INTO sub_menu VALUES ('', '$judul','$menu_utama', 'fa $icon','')") or die (mysql_error());
			redirect('menu/sub_menu');
		} else {
			$this->load->view('menu/sub_menu',$data);
		}
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function link_menu(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['link_menu'] = $this->m_models->getJoin2("*", "link_menu", "level_user", "level_user.id_level=link_menu.akses_lvl", "menu_utama", "menu_utama.id_menu_utama=link_menu.id_menu_utama", "jdl_linkmenu", "asc");


		$data['menuutama'] = $this->m_models->getwhere("*", "menu_utama","id_menu_utama", $sub_menu, "jdl_menu_utama", "asc");
		$data['level_user'] = $this->m_models->getTabelOrder("*", "level_user", "nama_level", "asc");
		$data['submenu'] = $this->m_models->getTabelOrder("*", "sub_menu", "jdl_submenu", "asc");
		$sub_menu = $this->input->post('sub_menu', TRUE);
		$icon = $this->input->post('icon', TRUE);
		$judul = $this->input->post('judul', TRUE);	
		$link = $this->input->post('link', TRUE);
		$direktori = $this->input->post('direktori', TRUE);		
		$akses = $this->input->post('akses', TRUE);

		$data['menuutama'] = $this->m_models->getwhere("*", "sub_menu","id_submenu", $sub_menu, "jdl_submenu", "asc");
		$id_menu_utama=$data[menuutama][0]->id_menu_utama;

		if (($sub_menu != "") && ($judul != "")&& ($icon != "")&& ($direktori != "")&& ($akses != "")&& ($link != "")){
			$this->db->query("INSERT INTO link_menu VALUES ('', '$judul','$link', '$id_menu_utama', '$sub_menu', 'fa $icon','$akses','$direktori','on')") or die (mysql_error());
			redirect('menu/link_menu');
		} else { 
			$this->load->view('menu/link_menu',$data);
		}
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function menu_config(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['link_menu'] = $this->m_models->getTableGroup("*", "link_menu", "jdl_linkmenu", "jdl_linkmenu", "asc");
		$data['level_user'] = $this->m_models->getTabelOrder("*", "level_user", "nama_level", "asc");

		$link_menu = $this->input->post('link_menu', TRUE);
		$akses = $this->input->post('akses', TRUE);
		
		$data['level_user'] = $this->m_models->getwhere("*", "link_menu", "id_linkmenu", $link_menu, "jdl_linkmenu", "asc");
		foreach ($data['level_user']as $lu) {
			
		}

		if (($link_menu != "") && ($akses != "")){
			$nilai = array('jdl_linkmenu' => $lu->jdl_linkmenu, 'lnk_linkmenu'=> $lu->lnk_linkmenu, 'id_menu_utama'=>$lu->id_menu_utama, 'id_submenu'=>$id_submenu , 'icon_linkmenu'=> $icon_linkmenu, 'akses_lvl'=>$akses, 'direktori'=> $lu->direktori, 'status' => 'on');
			$data['simpanmenu'] = $this->m_models->save_data($nilai, "link_menu");
			redirect('menu/menu_config');
		}
		$this->load->view('menu/menu_config',$data);
		$this->load->view('template/footer');
	}

	
}
