<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Lowongan extends CI_Controller {	
	function __construct(){
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	public function sendSMS($number,$textpesan){				
		$curl = curl_init();		
		$text = (string)$textpesan;		
		$num = (string)$number;		
		$usernusa="al-multazam_api";		
		$passnusa="cafmusry";		
		curl_setopt_array($curl, array(			
			CURLOPT_RETURNTRANSFER => 1,			
			CURLOPT_URL => 'http://api.nusasms.com/api/v3/sendsms/plain',			
			CURLOPT_POST => true,			
			CURLOPT_POSTFIELDS => array(				
				'user' => 'al-multazam_api',				
				'password' => 'cafmusry',				
				'SMSText' => $text,				
				'GSM' => $num			
			)		
		));		
		$resp = curl_exec($curl);		
		if (!$resp) {			
			die('Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl));		
		}
	}

	public function kelola_pekerjaan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$pekerjaan = $this->input->post('pekerjaan', TRUE);
		$keterangan = $this->input->post('keterangan', TRUE);
		$hariini=date("Y-m-d");
		if (($pekerjaan != "")){
			$a_pa= array('pekerjaan'=>$pekerjaan, 'keterangan' => $keterangan, 'tgl_input'=>$hariini, 'nrp_input'=>$nrp, 'status'=>'on');
			if ($this->m_models->save_data($a_pa, 'lowongan_pekerjaan') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('lowongan/kelola_pekerjaan');
		}

		$data['pekerjaan'] = $this->m_models->getTabelOrder("*", "lowongan_pekerjaan", "pekerjaan", "asc");		

		$this->load->view('lowongan/daftar_pekerjaan', $data);
		$this->load->view('template/footer');
	}

	public function update_pekerjaan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_pekerjaan = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_pekerjaan != ""){
			$j_off= array('status'=>$status);
			if ($this->m_models->update_data($id_pekerjaan, "id_pekerjaan", $j_off, "lowongan_pekerjaan") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('lowongan/kelola_pekerjaan');
		}
		$this->load->view('template/footer');
	}

	#data pelamar
	public function data_pelamar(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$status = $this->input->post('status', TRUE);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[status]=$status;

		if (($dari != "") && ($sampai != "") && ($status != "")){
			$ars = array('tgl_daftar >= ' => $dari, 'tgl_daftar <='=>$sampai, 'status'=>$status);
        	$data['dt_pelamar'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelamar", $ars, "nama", "asc");
		}

		$this->load->view('lowongan/data_pelamar', $data);
		$this->load->view('template/footer');
	}

	public function detail_pendaftar(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$kode_pelamar = $this->uri->segment(3);
		$data[kode_pelamar]=$kode_pelamar;

		if ($kode_pelamar != ""){
			$ars = array('kode_pelamar' => $kode_pelamar);
        	$data['dt_pelamar'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelamar", $ars, "nama", "asc");
        	foreach ($data['dt_pelamar'] as $pelamar){
        		$ar_keluarga = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_keluarga'] = $this->m_models->getTabelwhere("*", "lowongan_dt_keluarga", $ar_keluarga, "id_dt_keluarga", "asc");
        		
        		$ar_pendidikan = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_pendidikan'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pendidikan", $ar_pendidikan, "id_dt_pend", "asc");

        		$ar_pelatihan = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_pelatihan'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelatihan", $ar_pelatihan, "id_dt_pelatihan", "asc");

        		$ar_kerja = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_kerja'] = $this->m_models->getTabelwhere("*", "lowongan_pengalaman_kerja", $ar_kerja, "id_pengalaman", "asc");

        		$data['dt_photo'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'photo'");
        		$data[photo]=$data['dt_photo'][0]->nama_file;

        		$data['dt_cv'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'cv'");
        		$data[cv]=$data['dt_cv'][0]->nama_file;

        		$data['dt_ijazah'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'ijazah'");
        		$data[ijazah]=$data['dt_ijazah'][0]->nama_file;

        		$data['dt_transkrip_nilai'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'transkrip nilai'");
        		$data[transkrip_nilai]=$data['dt_transkrip_nilai'][0]->nama_file;

        		$data['dt_sertifikat'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'sertifikat'");
        		$data[sertifikat]=$data['dt_sertifikat'][0]->nama_file;

        		$data['dt_ktp'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'ktp'");
        		$data[ktp]=$data['dt_ktp'][0]->nama_file;

        		$data['dt_skck'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'skck'");
        		$data[skck]=$data['dt_skck'][0]->nama_file;

        		$data['dt_ket_dokter'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'ket_dokter'");
        		$data[ket_dokter]=$data['dt_ket_dokter'][0]->nama_file;

        		$data['dt_kartu_kuning'] = $this->m_models->getSpesific("lowongan_berkas_pelamar", "kode_pelamar='$pelamar->kode_pelamar' and nama_dokumen = 'kartu_kuning'");
        		$data[kartu_kuning]=$data['dt_kartu_kuning'][0]->nama_file;
        	}
		}

		$this->load->view('lowongan/detail_pendaftar', $data);
		$this->load->view('template/footer');
	}

	public function download_dt_pendaftar(){
		$nrp=$this->session->userdata['nrp']; 
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$status = $this->uri->segment(5);

		$ars = array('tgl_daftar >= ' => $dari, 'tgl_daftar <='=>$sampai, 'status'=>$status);
       	$data['dt_pelamar'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelamar", $ars, "nama", "asc");
       	foreach ($data['dt_pelamar'] as $pelamar){
       		$ar_keluarga = array('kode_pelamar' => $pelamar->kode_pelamar);
       		$data['dt_keluarga'][$pelamar->kode_pelamar] = $this->m_models->getTabelwhere("*", "lowongan_dt_keluarga", $ar_keluarga, "id_dt_keluarga", "asc");

       		$ar_pendidikan = array('kode_pelamar' => $pelamar->kode_pelamar);
       		$data['dt_pendidikan'][$pelamar->kode_pelamar] = $this->m_models->getTabelwhere("*", "lowongan_dt_pendidikan", $ar_pendidikan, "id_dt_pend", "asc");

       		$ar_pelatihan = array('kode_pelamar' => $pelamar->kode_pelamar);
       		$data['dt_pelatihan'][$pelamar->kode_pelamar] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelatihan", $ar_pelatihan, "id_dt_pelatihan", "asc");

       		$ar_kerja = array('kode_pelamar' => $pelamar->kode_pelamar);
       		$data['dt_kerja'][$pelamar->kode_pelamar] = $this->m_models->getTabelwhere("*", "lowongan_pengalaman_kerja", $ar_kerja, "id_pengalaman", "asc");
       	}

		$this->load->view('lowongan/download_dt_pendaftar', $data);
	}

	public function download_detail_pelamar(){
		$nrp=$this->session->userdata['nrp']; 
		$kode_pelamar = $this->uri->segment(3);

			$ars = array('kode_pelamar' => $kode_pelamar);
        	$data['dt_pelamar'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelamar", $ars, "nama", "asc");
        	foreach ($data['dt_pelamar'] as $pelamar){
        		$ar_keluarga = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_keluarga'] = $this->m_models->getTabelwhere("*", "lowongan_dt_keluarga", $ar_keluarga, "id_dt_keluarga", "asc");
        		
        		$ar_pendidikan = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_pendidikan'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pendidikan", $ar_pendidikan, "id_dt_pend", "asc");

        		$ar_pelatihan = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_pelatihan'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelatihan", $ar_pelatihan, "id_dt_pelatihan", "asc");

        		$ar_kerja = array('kode_pelamar' => $pelamar->kode_pelamar);
        		$data['dt_kerja'] = $this->m_models->getTabelwhere("*", "lowongan_pengalaman_kerja", $ar_kerja, "id_pengalaman", "asc");
        	}

		$this->load->view('lowongan/download_detail_pelamar', $data);

		$this->load->library('pdf');
		$this->pdf->setPaper("A4", 'portrait');
		$this->pdf->load_view('lowongan/download_detail_pelamar', $data);
		$this->pdf->render();
		$this->pdf->stream("Resume Palamar.pdf", array('Attachment'=>0));
	}

	public function proses_pelamar(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$data[dari]=$dari;
		$data[sampai]=$sampai;

		if (($dari != "") && ($sampai != "")){
			$ars = array('status' => 'Proses','tgl_daftar >= ' => $dari, 'tgl_daftar <='=>$sampai );
	       	$data['dt_pelamar'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelamar", $ars, "tgl_daftar", "asc");

	        $data['jabatan'] = $this->m_models->getAll('jabatan');
	        $data['penempatan'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");
	    }

		$this->load->view('lowongan/proses_pelamar', $data);
		$this->load->view('template/footer');
	}
	
	public function simpan_proses_pelamar(){
		$nrp=$this->session->userdata['nrp']; 
		$no = $this->input->post('no', TRUE);
		$hariini=date("Y-m-d H:i:s");
		if ($no != ""){
			for ($i=0; $i < $no; $i++){
				$kode = $this->input->post('kode', TRUE);
				$kode_pelamar=$kode[$i];
				$status = $this->input->post('status'.$kode_pelamar, TRUE);
				$id_jabatan = $this->input->post('jab'.$kode_pelamar, TRUE);
				$id_sekolah = $this->input->post('penempatan'.$kode_pelamar, TRUE);
				$tgl_masuk = $this->input->post('tgl_masuk'.$kode_pelamar, TRUE);
				if (($kode_pelamar != "") && ($status != "")){
					$arkary=array('status' =>$status, 'tgl_proses'=>$hariini, 'nrp_proses'=>$nrp);
					$up_pelamar=$this->m_models->update_data($kode_pelamar, "kode_pelamar", $arkary, "lowongan_dt_pelamar");

					$nama_pelamar=all("lowongan_dt_pelamar", $kode_pelamar, "kode_pelamar", "nama");
					$telp=all("lowongan_dt_pelamar", $kode_pelamar, "kode_pelamar", "tlp");
					$id_pekerjaan=all("lowongan_dt_pelamar", $kode_pelamar, "kode_pelamar", "id_pekerjaan");
					$pekerjaan=all("lowongan_pekerjaan", "id_pekerjaan", $id_pekerjaan, "pekerjaan");

					#kirim sms
					$numberhp=$telp;	
					$exnama=explode(" ",$nama_pelamar);
					$vnama=$exnama[0]." ".$exnama[1];	
					if ($status=="Terima"){
						$pesantext="Assalamualaikum,".$vnama." . Selamat anda diterima bekerja untuk bagian ".$pekerjaan." di Al-Multazam. Syukron. HRD YPI AMHK";

						$ars = array('kode_pelamar' => $kode_pelamar);
        				$data['dt_pelamar'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pelamar", $ars, "nama", "asc");
        				#simpan pegawai
						$nrp=ambilnrp();
						$a_pa= array('nrp'=>$nrp, 'nama' => $data['dt_pelamar'][0]->nama, 'tmp_lhr'=>$data['dt_pelamar'][0]->tmp_lhr, 'tgl_lhr'=>$data['dt_pelamar'][0]->tgl_lhr, 'jk'=>$data['dt_pelamar'][0]->jk, 'tgl_masuk' => $tgl_masuk, 'alamat'=>$data['dt_pelamar'][0]->alamat." Rt.".$data['dt_pelamar'][0]->rt." Rw".$data['dt_pelamar'][0]->rw, 'kel'=>$data['dt_pelamar'][0]->kel, 'kec'=>$data['dt_pelamar'][0]->kec, 'kota' => $data['dt_pelamar'][0]->kota, 'prov'=>$data['dt_pelamar'][0]->prov, 'email'=>$data['dt_pelamar'][0]->email, 'foto'=>'user-default.png', 'st_marital' => $data['dt_pelamar'][0]->st_marital, 'status_aktf'=>'Aktif', 'id_jabatan'=>$id_jabatan, 'tlp'=>$data['dt_pelamar'][0]->tlp, 'pend_akhir' => $data['dt_pelamar'][0]->pend_akhir, 'gol_darah'=>$data['dt_pelamar'][0]->gol_darah, 'agama'=>$data['dt_pelamar'][0]->agama, 'no_ktp'=>$data['dt_pelamar'][0]->nik, 'saldo_awal'=>0, 'warga_negara'=>$data['dt_pelamar'][0]->warga_negara, 'id_sekolah' => $id_sekolah, 'sinkronisasi'=>0);
						$simpan_pegawai=$this->m_models->save_data($a_pa, 'pegawai');

						#login
						$pwd="827ccb0eea8a706c4c34a16891f84e7b";
						$ar_l=array("nama_pengguna"=>$data['dt_pelamar'][0]->nama, "username"=>$nrp, "password"=>$pwd, "activity"=>"on", "hak_akses"=>"127", "nrp"=>$nrp, "pwd"=>"12345");
						$simpan_login=$this->m_models->save_data($ar_l, 'tb_pengguna');

						#pendidikan
        				$data['dt_pend'] = $this->m_models->getTabelwhere("*", "lowongan_dt_pendidikan", $ars, "id_tp", "asc");
        				foreach ($data['dt_pend'] as $pend) {
        					$ar_pend=array("nrp"=>$nrp, "id_tp"=>$pend->id_tp, "sekolah"=>$pend->tmp_pendidikan, "kota"=>$pend->kota, "thn_lulus"=>$pend->thn_lulus, "fakultas"=>$pend->fakultas, "jurusan"=>$pend->jurusan);
							$simpan_pend=$this->m_models->save_data($ar_pend, 'riwayat_pend_peg');
        				}

						#pengalaman kerja
						$data['dt_peng'] = $this->m_models->getTabelwhere("*", "lowongan_pengalaman_kerja", $ars, "nama_perusahaan", "asc");
						foreach ($data['dt_peng'] as $peng){
							$ar_peng=array("nrp"=>$nrp, "periode"=>$peng->tahun, "tempat"=>$peng->nama_perusahaan, "posisi"=>$peng->jabatan);
							$simpan_peng=$this->m_models->save_data($ar_peng, 'peng_kerja');
						}
						 
					} else if ($status=="Tolak"){
						$pesantext="Assalamualaikum,".$vnama." . Terimakasih sudah melamar di YPI Al Multazam, mohon maaf sdr/i belum bisa bergabung di YPI Al Multazam. Keep spirit. Syukron. HRD YPI AMHK";
					}
					
					$this->sendSMS($numberhp,$pesantext);
				}
			}	
		}
		
		redirect('lowongan/proses_pelamar');
	}



}