<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Laporan_perpus extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
		$this->load->model('perpus_models');
	}

	function get_terlambat($tanggal_jatuh_tempo, $tanggal_pengembalian){
		$this->load->helper('absen');
		# cari selilih hari
		$selisih_hari = get_selisih_hari($tanggal_jatuh_tempo, $tanggal_pengembalian);

		# cari + atau - nilai selilihnya
		$jatuh_tempo = preg_replace('/[^0-9]/', '', $tanggal_jatuh_tempo);
		$pengembalian = preg_replace('/[^0-9]/', '', $tanggal_pengembalian);

		if ($pengembalian > $jatuh_tempo) {
			$nilai_selisih_hari = '+'.$selisih_hari;
		}elseif($pengembalian == $jatuh_tempo){
			$nilai_selisih_hari = $selisih_hari;
		}else{
			$nilai_selisih_hari = '-'.$selisih_hari;
		}

		return $nilai_selisih_hari;
	}

	function get_hari_telat($tanggal_jatuh_tempo, $tanggal_pengembalian){
		$this->load->helper('absen');
		# cari selilih hari
		$selisih_hari = get_selisih_hari($tanggal_jatuh_tempo, $tanggal_pengembalian);

		# cari + atau - nilai selilihnya
		$jatuh_tempo = preg_replace('/[^0-9]/', '', $tanggal_jatuh_tempo);
		$pengembalian = preg_replace('/[^0-9]/', '', $tanggal_pengembalian);

		if ($pengembalian > $jatuh_tempo) {
			$nilai_selisih_hari = $selisih_hari;
		}elseif($pengembalian == $jatuh_tempo){
			$nilai_selisih_hari = $selisih_hari;
		}else{
			$nilai_selisih_hari = '0';
		}

		return $nilai_selisih_hari;
	}

	function get_penerbit($id, $field_id){
		if ($field_id == 'id_biblio') {
			$arraywhere = array('perpus_biblio.id_biblio' => $id);
			$penerbit = $this->m_models->getJoin1where("perpus_penerbit.nama", "perpus_biblio", "perpus_penerbit", "perpus_penerbit.id_penerbit=perpus_biblio.id_penerbit", $arraywhere, "id_biblio", "ASC" );
			return $penerbit[0]->nama;
		}
	}

	function get_pengarang($id, $field_id){
		if ($field_id == 'id_biblio') {
			$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $id);
			$penulis = $this->m_models->getJoin1where("perpus_penulis.nama", "perpus_biblio_pengarang", "perpus_penulis", "perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis", $arraywhere, "id_biblio", "ASC" );
			$i = 0;
			foreach ($penulis as $key) {
				if ($i > 0) {
					$nama_pengarang = ','.$key->nama;
				}else{
					$nama_pengarang = $key->nama;
				}
				$pengarang = $pengarang .' '. $nama_pengarang;
				$i++;
			}
			return $pengarang;
		}
	}

	function rentang_tanggal_db($rentangtanggal){
		$exp = explode("-", $rentangtanggal);

		# mencari tanggal pertama
		$tanggal1 = explode("/", trim($exp[0]));
		$tanggal1_db = $tanggal1[2].'-'.$tanggal1[1].'-'.$tanggal1[0];

		# mencari tanggal kedua
		$tanggal2 = explode("/", trim($exp[1]));
		$tanggal2_db = $tanggal2[2].'-'.$tanggal2[1].'-'.$tanggal2[0];

		$periode = array('tanggal1' => $tanggal1_db, 'tanggal2' => $tanggal2_db);

		return $periode;
	}

	function get_biblio($id_biblio){
		$bibliografi = $this->m_models->get_data("*", "perpus_biblio", "WHERE id_biblio='$id_biblio' ");
		foreach ($bibliografi as $biblio) {
        	# kolom judul
        	$judul_paralel = '';
        	$judul_terjemah = '';
        	$pengarang = '';

        	if ($biblio->judul_paralel != '') {
        		$judul_paralel = ' : '.$biblio->judul_paralel;
        	}
        	if ($biblio->judul_terjemah != '') {
        		$judul_terjemah = ' : '.$biblio->judul_terjemah;
        	}        	

        	# mencari kepengerangan
	       	$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $biblio->id_biblio);
        	$kepengarangan = $this->m_models->getJoin1where("perpus_penulis.nama", "perpus_biblio_pengarang","perpus_penulis", "perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis", $arraywhere, "perpus_biblio_pengarang.id_biblio_pengarang", "desc");
        	foreach ($kepengarangan as $key) {
        		$pengarang = '<br>'.$key->nama;
        	}
        	
        	# kolom kepenerbitana
        	$tempat = '';
        	$penerbit = '';

        	if ($biblio->id_tempat != 0 AND $biblio->id_penerbit != 0) {
        		$data_tempat = $this->m_models->get_data("*", "perpus_tempat", "WHERE id_tempat='$biblio->id_tempat' ");
        		foreach ($data_tempat as $key) {
        			$tempat = $key->nama_tempat.' : ';
        		}
        	}elseif($biblio->id_tempat != 0){
        		$data_tempat = $this->m_models->get_data("*", "perpus_tempat", "WHERE id_tempat='$biblio->id_tempat' ");
        		foreach ($data_tempat as $key) {
        			$tempat = $key->nama_tempat;
        		}
        	}
        	if ($biblio->id_penerbit != 0 AND $biblio->tahun_terbit != '') {
        		$data_penerbit = $this->m_models->get_data("*", "perpus_penerbit", "WHERE id_penerbit='$biblio->id_penerbit' ");
        		foreach ($data_penerbit as $key) {
        			$penerbit = $key->nama.', ';
        		}
        	}elseif($biblio->id_penerbit != 0){
        		$data_penerbit = $this->m_models->get_data("*", "perpus_penerbit", "WHERE id_penerbit='$biblio->id_penerbit' ");
        		foreach ($data_penerbit as $key) {
        			$penerbit = $key->nama;
        		}
        	}

        	$edisi = '';
        	if ($biblio->edisi != '') {
        		$edisi = $biblio->edisi.'<br>';
        	}

        	$data_biblio = '<b>'.$biblio->judul.$judul_paralel.$judul_terjemah.$pengarang.'</b><br><br>'.$edisi.$tempat.$penerbit.$biblio->tahun_terbit.'<br>'.$biblio->deskripsi_fisik;

        	return $data_biblio;
		}
	}


	#laporan_peminjaman
	function laporan_peminjaman(){
		$this->load->view('template/header');
		
		# mencari petugas transaksi
		$data['petugas'] = $this->m_models->getJoin1Group("pegawai.nama, pegawai.nrp", "perpus_pinjaman", "pegawai", "perpus_pinjaman.nrp=pegawai.nrp", "perpus_pinjaman.nrp", "pegawai.nama", "ASC");
		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_peminjaman', $data); 

		$this->load->view('template/footer');
	}

	function get_kriteria_anggota(){
	//	$this->load->view('template/head');
		$kriteria_anggota = $this->input->get('kriteria_anggota'); 

		if ($kriteria_anggota == 'semua_kriteria') {
			$data['kriteria_anggota'] = 'semua_kriteria';
		}elseif ($kriteria_anggota == 'id_anggota') {
			$data['kriteria_anggota'] = 'id_anggota';
		}elseif ($kriteria_anggota == 'nama_anggota') {
			$data['kriteria_anggota'] = 'nama_anggota';
		}elseif ($kriteria_anggota == 'instansi') {
			$data['kriteria_anggota'] = 'instansi';

			$data['instansi'] = $this->m_models->get_data("id_instansi, nama", "perpus_instansi", "ORDER BY id_sekolah ASC");

		}

		$this->load->view('perpustakaan/f_kriteria_anggota', $data);

	//	$this->load->view('template/js');
	}

	function get_kriteria_koleksi(){
	//	$this->load->view('template/head');
		$kriteria_koleksi = $this->input->get('kriteria_koleksi'); 

		if ($kriteria_koleksi == 'semua_kriteria') {
			$data['kriteria_koleksi'] = 'semua_kriteria';
		}elseif ($kriteria_koleksi == 'kode_inv') {
			$data['kriteria_koleksi'] = 'kode_inv';
		}elseif ($kriteria_koleksi == 'klasifikasi') {
			$data['kriteria_koleksi'] = 'klasifikasi';
		}

		$this->load->view('perpustakaan/f_kriteria_koleksi', $data);

	//	$this->load->view('template/js');
	}

	function laporan_peminjaman_html(){ 
		$this->load->view('template/head');
		$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
		$periode = $this->input->post('periode', TRUE);
	//	$kriteria_anggota = $this->input->post('kriteria_anggota', TRUE);
		$id_anggota = $this->input->post('id_anggota', TRUE);
		$nama_anggota = $this->input->post('nama_anggota', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
	//	$kriteria_koleksi = $this->input->post('kriteria_koleksi', TRUE);
		$kode_inv = $this->input->post('kode_inv', TRUE);
		$klasifikasi = $this->input->post('klasifikasi');
		$petugas = $this->input->post('petugas');
		$belum_dikembalikan = $this->input->post('belum_dikembalikan', TRUE);
		$sudah_dikembalikan = $this->input->post('sudah_dikembalikan', TRUE);
		$lewat_jatuh_tempo = $this->input->post('lewat_jatuh_tempo', TRUE);
		$belum_jatuh_tempo = $this->input->post('belum_jatuh_tempo', TRUE);

		$export_excel = $this->input->post('export_excel', TRUE);

	//	echo "$periode ".$periode.'<br>';
	//	echo "kriteria_anggota ".$kriteria_anggota.'<br>';
	//	echo "id_anggota ".$id_anggota.'<br>';
	//	echo "id_instansi ".$id_instansi.'<br>';
	//	echo "kriteria_koleksi ".$kriteria_koleksi.'<br>';
	//	echo "kode_inv ".$kode_inv.'<br>';
	//	echo "klasifikasi ".$klasifikasi.'<br>';
	//	echo "petugas ".$petugas.'<br>';
	//	echo "belum_dikembalikan ".$belum_dikembalikan.'<br>';
	//	echo "sudah_dikembalikan ".$sudah_dikembalikan.'<br>';
	//	echo "lewat_jatuh_tempo ".$lewat_jatuh_tempo.'<br>';
	//	echo "belum_jatuh_tempo ".$belum_jatuh_tempo.'<br>'; 

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
		
		# data petugas perpus
		$data_petugas = $this->m_models->getAll("perpus_petugas");
		foreach ($data_petugas as $key) { 
			$nrp_petugas[] = $key->nrp;
			$petugas_perpus[$key->nrp] = $key->nama_petugas;
		}
	
		$arraywhere = array('tanggal_pinjam >=' => $tanggal['tanggal1'], 'tanggal_pinjam <=' => $tanggal['tanggal2'] );
		# cek jika kriteria anggota dipilih maka tambahkan data kriteria nggota ke arraywhere
		if ($id_anggota != null) {
			$arraywhere['perpus_pinjaman.id_user like'] = "%".$id_anggota."%";
		}
		if ($id_instansi != null) {
			$arraywhere['perpus_anggota.id_instansi'] = $id_instansi;
		}
		if ($kode_inv != null) {
			$arraywhere['perpus_pinjaman.kode_inv like'] = "%".$kode_inv."%";
		}
		if ($nama_anggota != null) {
			$arraywhere['perpus_anggota.nama like'] = "%".$nama_anggota."%";
		}
		if ($petugas != 'semua_petugas') {
			$arraywhere['perpus_pinjaman.nrp'] = $petugas;
		}
		if ($belum_dikembalikan == 'on' AND $sudah_dikembalikan == NULL) { 
			$arraywhere['perpus_pinjaman.dikembalikan'] = '0';
		}
		if ($belum_dikembalikan == null AND $sudah_dikembalikan == 'on') { 
			$arraywhere['perpus_pinjaman.dikembalikan'] = '1';
		}

		$q_pinjaman = $this->perpus_models->getJoin4where("perpus_pinjaman.*, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama as nama_anggota, perpus_anggota.id_instansi, perpus_pengembalian.nrp as petugas_pengambilan, pegawai.nama", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv", 
			"perpus_anggota", "perpus_anggota.id_user=perpus_pinjaman.id_user", 
			'perpus_pengembalian', "perpus_pengembalian.id_pinjaman=perpus_pinjaman.id_pinjaman", 
			"pegawai", "pegawai.nrp=perpus_pinjaman.nrp", 
			$arraywhere, "id_pinjaman", "DESC");
		$no = 0;
		foreach ($q_pinjaman as $key) { 
			# cek tanggal pengembalian jika belum dikembalikan beri tanggal sekaran
			if ($key->dikembalikan == '1') {
				$tanggal_pengembalian = shortdate_indo2($key->tanggal_pengembalian);
				$tgl_pengembalian = $key->tanggal_pengembalian;
			}else{
				$tanggal_pengembalian = '';
				date_default_timezone_set('Asia/Jakarta');
				$tgl_pengembalian = date('Y-m-d');
			}

			# cari petugas pengambilan
			$nrp_petugas_pengambilan = $key->petugas_pengambilan;
			if (in_array($nrp_petugas_pengambilan, $nrp_petugas)) {
				$petugas_pengambilan = $petugas_perpus[$nrp_petugas_pengambilan];
			}else{
				$petugas_pengambilan = '';
			}
			
			# hitung hari telat 
			$telat = $this->get_hari_telat($key->tanggal_jatuh_tempo, $tgl_pengembalian);

			# cari nama kelas atau nama sekolah untuk keterangan di excel
			# jika instansi SDM carinya nama sekolah
			if ($key->id_instansi == '1') {
				$sekolah = $this->m_models->getDataByID("sekolah", 'id_sekolah', $key->id_kelas);
				$keterangan = $sekolah[0]->nama;
			}else{
				$kelas = $this->m_models->getDataByID("kelas", 'id_kelas', $key->id_kelas);
				$keterangan = "";
				if (isset($kelas[0]->nama_kelas)) {
					$keterangan = $kelas[0]->nama_kelas;
				}
			}
			
			# jika Belum melewati tanggal jatuh tempo di check
			if ($belum_jatuh_tempo == 'on' AND $lewat_jatuh_tempo == NULL) {
				if ($telat == 0) {
					$biblio = $this->get_biblio($key->id_biblio);
					
					$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pinjam);
					$pinjaman[$no]['tanggal_jatuh_tempo'] = shortdate_indo2($key->tanggal_jatuh_tempo);
					$pinjaman[$no]['tanggal_pengembalian'] = $tanggal_pengembalian;
					$pinjaman[$no]['telat'] = $telat;
					$pinjaman[$no]['kode_inv'] = $key->kode_inv;
					$pinjaman[$no]['bibliografi'] = $biblio;
					$pinjaman[$no]['id_anggota'] = $key->id_user;
					$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
					$pinjaman[$no]['petugas'] = $key->nama;
					$pinjaman[$no]['petugas_pengambilan'] = $petugas_pengambilan;
					$pinjaman[$no]['keterangan'] = $keterangan;
					$no++;
				}
			}elseif ($belum_jatuh_tempo == NULL AND $lewat_jatuh_tempo == 'on') {
				if ($telat > 0) {
					$biblio = $this->get_biblio($key->id_biblio);

					$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pinjam);
					$pinjaman[$no]['tanggal_jatuh_tempo'] = shortdate_indo2($key->tanggal_jatuh_tempo);
					$pinjaman[$no]['tanggal_pengembalian'] = $tanggal_pengembalian;
					$pinjaman[$no]['telat'] = $telat;
					$pinjaman[$no]['kode_inv'] = $key->kode_inv;
					$pinjaman[$no]['bibliografi'] = $biblio;
					$pinjaman[$no]['id_anggota'] = $key->id_user;
					$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
					$pinjaman[$no]['petugas'] = $key->nama;
					$pinjaman[$no]['petugas_pengambilan'] = $petugas_pengambilan;
					$pinjaman[$no]['keterangan'] = $keterangan;
					$no++;
				}
			}else{		
				$biblio = $this->get_biblio($key->id_biblio);

				$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pinjam);
				$pinjaman[$no]['tanggal_jatuh_tempo'] = shortdate_indo2($key->tanggal_jatuh_tempo);
				$pinjaman[$no]['tanggal_pengembalian'] = $tanggal_pengembalian;
				$pinjaman[$no]['telat'] = $telat;
				$pinjaman[$no]['kode_inv'] = $key->kode_inv;
				$pinjaman[$no]['bibliografi'] = $biblio;
				$pinjaman[$no]['id_anggota'] = $key->id_user;
				$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
				$pinjaman[$no]['petugas'] = $key->nama;
				$pinjaman[$no]['petugas_pengambilan'] = $petugas_pengambilan;
				$pinjaman[$no]['keterangan'] = $keterangan;
				$no++;				
			}
		}

		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($export_excel == 'export_excel') {
			$this->load->view('perpustakaan/laporan_peminjaman_excel', $data);
		}else{
			$this->load->view('perpustakaan/laporan_peminjaman_html', $data);
		}

		$this->load->view('template/js');
	
	}

	#get_kriteria_perpanjangan 
	# dipake sama laporan perpanjangan n laporan pelanggaran
	function get_kriteria_perpanjangan(){
		$this->load->view('template/head');
		$kriteria_perpanjangan = $this->input->get('kriteria_perpanjangan'); 

		if ($kriteria_perpanjangan == 'semua_kriteria') {
			$data['kriteria_perpanjangan'] = 'semua_kriteria';
		}elseif ($kriteria_perpanjangan == 'id_anggota') {
			$data['kriteria_perpanjangan'] = 'id_anggota';
		}elseif ($kriteria_perpanjangan == 'nama_anggota') {
			$data['kriteria_perpanjangan'] = 'nama_anggota';
		}elseif ($kriteria_perpanjangan == 'petugas') {
			$data['kriteria_perpanjangan'] = 'petugas_perpanjangan';

			# mencari petugas transaksi
			$data['petugas'] = $this->m_models->getJoin1Group("pegawai.nama, pegawai.nrp", "perpus_pinjaman", "pegawai", "perpus_pinjaman.nrp=pegawai.nrp", "perpus_pinjaman.nrp", "pegawai.nama", "ASC");

		}elseif ($kriteria_perpanjangan == 'kode_inv') {
			$data['kriteria_perpanjangan'] = 'kode_inv';
		}elseif ($kriteria_perpanjangan == 'petugas_peminjaman') {
			$data['kriteria_perpanjangan'] = 'petugas_peminjaman';
			# mencari petugas transaksi
			$data['petugas'] = $this->m_models->getAll("perpus_petugas ORDER BY nama_petugas ASC");
		}elseif ($kriteria_perpanjangan == 'petugas_pengembalian') {
			$data['kriteria_perpanjangan'] = 'petugas_pengembalian';
			# mencari petugas transaksi
			$data['petugas'] = $this->m_models->getAll("perpus_petugas ORDER BY nama_petugas ASC");
		}

		$this->load->view('perpustakaan/f_kriteria_perpanjangan', $data);

		$this->load->view('template/js');
	}

	#laporan_peminjaman
	function laporan_perpanjangan(){
		$this->load->view('template/header');
		
		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_perpanjangan', $data); 

		$this->load->view('template/footer');
	}

	function laporan_perpanjangan_data(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_anggota = $this->input->post('id_anggota', TRUE);
		$nama_anggota = $this->input->post('nama_anggota', TRUE);
		$petugas_perpanjangan = $this->input->post('petugas_perpanjangan', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
		
		# data petugas perpus
		$data_petugas = $this->m_models->getAll("perpus_petugas");
		foreach ($data_petugas as $key) { 
			$nrp_petugas[] = $key->nrp;
			$petugas_perpus[$key->nrp] = $key->nama_petugas;
		}
	
		$arraywhere = array('perpus_perpanjangan.tanggal_perpanjangan >=' => $tanggal['tanggal1'], 'perpus_perpanjangan.tanggal_perpanjangan <=' => $tanggal['tanggal2'] );

		# cek jika kriteria anggota dipilih maka tambahkan data kriteria nggota ke arraywhere
		if ($id_anggota != null) {
			$arraywhere['perpus_pinjaman.id_user like'] = "%".$id_anggota."%";
		}
		if ($nama_anggota != null) {
			$arraywhere['perpus_anggota.nama like'] = "%".$nama_anggota."%";
		}
		if ($petugas_perpanjangan != 'semua_petugas' AND $petugas_perpanjangan != null) {
			$arraywhere['perpus_perpanjangan.nrp'] = $petugas_perpanjangan;
		}

		
		$q_pinjaman = $this->m_models->getJoin3where("perpus_pinjaman.*, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama as nama_anggota, perpus_perpanjangan.tanggal_perpanjangan, perpus_perpanjangan.tanggal_jatuh_tempo_perpanjangan, perpus_perpanjangan.nrp as petugas_perpanjangan", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv", 
			"perpus_anggota", "perpus_anggota.id_user=perpus_pinjaman.id_user", 
			'perpus_perpanjangan', "perpus_perpanjangan.id_pinjaman=perpus_pinjaman.id_pinjaman", 
			$arraywhere, "perpus_perpanjangan.id_perpanjangan", "DESC");

		$no = 0;
		foreach ($q_pinjaman as $key) {
			# cek tanggal pengembalian jika belum dikembalikan beri tanggal sekaran
			if ($key->dikembalikan == '1') {
				$tanggal_pengembalian = shortdate_indo2($key->tanggal_pengembalian);
			}else{
				$tanggal_pengembalian = '';
			}

			# cari petugas pengambilan
			
			$nrp_petugas_perpanjangan = $key->petugas_perpanjangan;
			if (in_array($nrp_petugas_perpanjangan, $nrp_petugas)) {
				$petugas_perpanjangan = $petugas_perpus[$nrp_petugas_perpanjangan];
			}else{
				$petugas_perpanjangan = '';
			}
			
			$biblio = $this->get_biblio($key->id_biblio);

			$pinjaman[$no]['tanggal_perpanjangan'] = shortdate_indo2($key->tanggal_perpanjangan);
			$pinjaman[$no]['jatuh_tempo_perpanjangan'] = shortdate_indo2($key->tanggal_jatuh_tempo_perpanjangan);
			$pinjaman[$no]['tanggal_pengembalian'] = $tanggal_pengembalian;
			$pinjaman[$no]['kode_inv'] = $key->kode_inv;
			$pinjaman[$no]['bibliografi'] = $biblio;
			$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
			$pinjaman[$no]['petugas_perpanjangan'] = $petugas_perpanjangan;
			$no++;			
		}

		
		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($export_excel == 'export_excel') {
			$this->load->view('perpustakaan/laporan_perpanjangan_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_perpanjangan_html', $data);
		}

		$this->load->view('template/js');
	
	}

	#laporan_pengembalian_terlambat
	function laporan_pengembalian_terlambat(){
		$this->load->view('template/header');

		$arraywhere = array('dikembalikan' => '1' );

		$data['anggota'] = $this->m_models->getJoin1where("perpus_pinjaman.id_user, perpus_anggota.nama as nama_anggota", "perpus_pinjaman", "perpus_anggota", "perpus_anggota.id_user=perpus_pinjaman.id_user", 
			$arraywhere, "perpus_anggota.nama", "ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_pengembalian_terlambat', $data); 

		$this->load->view('template/footer');
	}


	function laporan_pengembalian_terlambat_data(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_anggota = $this->input->post('id_anggota', TRUE);
		$nama_anggota = $this->input->post('nama_anggota', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
		
		$arraywhere = array(
			'perpus_pinjaman.tanggal_pengembalian >=' => $tanggal['tanggal1'], 
			'perpus_pinjaman.tanggal_pengembalian <=' => $tanggal['tanggal2'], 
			'perpus_pelanggaran.jenis_pelanggaran' => 'Telat'
		);

		# cek jika kriteria anggota dipilih maka tambahkan data kriteria nggota ke arraywhere
		if ($id_anggota != null) {
			$arraywhere['perpus_pinjaman.id_user'] = $id_anggota;
		}
		if ($nama_anggota != null) {
			$arraywhere['perpus_anggota.nama like'] = "%".$nama_anggota."%";
		}
		
		$q_pinjaman = $this->m_models->getJoin3where("perpus_pinjaman.*, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama as nama_anggota, perpus_pelanggaran.jenis_pelanggaran ", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv", 
			"perpus_anggota", "perpus_anggota.id_user=perpus_pinjaman.id_user", 
			'perpus_pelanggaran', "perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman", 
			$arraywhere, "perpus_pinjaman.tanggal_pengembalian", "DESC");

		$no = 0;
		foreach ($q_pinjaman as $key) {
			# cek tanggal pengembalian jika belum dikembalikan beri tanggal sekaran
			$tanggal_pengembalian = shortdate_indo2($key->tanggal_pengembalian);
			$tgl_pengembalian = $key->tanggal_pengembalian;

			# hitung hari telat 
			$telat = $this->get_terlambat($key->tanggal_jatuh_tempo, $tgl_pengembalian);

			$pinjaman[$no]['tanggal'] = mediumdate_indo($key->tanggal_pengembalian);
			//$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
			$pinjaman[$no]['kode_inv'] = $key->kode_inv;
			$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pinjam);
			$pinjaman[$no]['tanggal_jatuh_tempo'] = shortdate_indo2($key->tanggal_jatuh_tempo);
			$pinjaman[$no]['tanggal_pengembalian'] = $tanggal_pengembalian;
			$pinjaman[$no]['hari_telat'] = $telat;
			$no++;			
		}

		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($export_excel == 'export_excel') {
			$this->load->view('perpustakaan/laporan_pengembalian_terlambat_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_pengembalian_terlambat_html', $data);
		}

		$this->load->view('template/js');
	
	}

	#laporan_peminjaman
	function laporan_pelanggaran(){
		$this->load->view('template/header');
		
		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_pelanggaran', $data); 

		$this->load->view('template/footer');
	}

	function laporan_pelanggaran_data(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_anggota = $this->input->post('id_anggota', TRUE);
		$nama_anggota = $this->input->post('nama_anggota', TRUE);
		$kode_inv = $this->input->post('kode_inv', TRUE);
		$petugas_peminjaman = $this->input->post('petugas_peminjaman', TRUE);
		$petugas_pengembalian = $this->input->post('petugas_pengembalian', TRUE);
		$telat = $this->input->post('telat', TRUE);
		$hilang = $this->input->post('hilang', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
		
		# data petugas perpus
		$data_petugas = $this->m_models->getAll("perpus_petugas");
		foreach ($data_petugas as $key) { 
			$nrp_petugas[] = $key->nrp;
			$petugas_perpus[$key->nrp] = $key->nama_petugas;
		}
	
		$arraywhere = array(
			'perpus_pinjaman.tanggal_pengembalian >=' => $tanggal['tanggal1'], 
			'perpus_pinjaman.tanggal_pengembalian <=' => $tanggal['tanggal2']
		);

		# cek jika kriteria anggota dipilih maka tambahkan data kriteria nggota ke arraywhere
		if ($id_anggota != null) {
			$arraywhere['perpus_pinjaman.id_user'] = $id_anggota;
		}
		if ($nama_anggota != null) {
			$arraywhere['perpus_anggota.nama like'] = "%".$nama_anggota."%";
		}
		if ($kode_inv != null) {
			$arraywhere['perpus_pinjaman.kode_inv like'] = "%".$kode_inv."%";
		}
		if ($petugas_peminjaman != 'semua_petugas' AND $petugas_peminjaman != null) {
			$arraywhere['perpus_pinjaman.nrp like'] = $petugas_peminjaman;
		}
		if ($petugas_pengembalian != 'semua_petugas' AND $petugas_pengembalian != null) {
			$arraywhere['perpus_pelanggaran.nrp like'] = "%".$petugas_pengembalian."%";
		}
		if ($telat == 'on' AND $hilang == null) {
			$arraywhere['perpus_pelanggaran.jenis_pelanggaran'] = 'Telat';
		}
		if ($hilang == 'on' AND $telat == null) {
			$arraywhere['perpus_pelanggaran.jenis_pelanggaran'] = 'Hilang';
		}
		
		$q_pinjaman = $this->m_models->getJoin3where("perpus_pinjaman.*, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama as nama_anggota, perpus_pelanggaran.nrp as petugas_pengembalian, perpus_pelanggaran.jenis_pelanggaran, perpus_pelanggaran.jumlah_bayar, perpus_pelanggaran.id_aturan_kehilangan", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv", 
			"perpus_anggota", "perpus_anggota.id_user=perpus_pinjaman.id_user", 
			'perpus_pelanggaran', "perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman", 
			$arraywhere, "perpus_pinjaman.tanggal_pengembalian", "DESC");

		$no = 0;
		foreach ($q_pinjaman as $key) {
			# cek tanggal pengembalian jika belum dikembalikan beri tanggal sekaran
			$tanggal_pengembalian = shortdate_indo2($key->tanggal_pengembalian);
			$tgl_pengembalian = $key->tanggal_pengembalian;

			# cari biblio
			$biblio = $this->get_biblio($key->id_biblio);

			# hitung hari telat 
			$telat = $this->get_hari_telat($key->tanggal_jatuh_tempo, $tgl_pengembalian);

			# cari petugas
			$nrp_petugas_peminjaman = $key->nrp;
			$petugas_peminjaman = "";
			if (isset($petugas_perpus[$nrp_petugas_peminjaman])) {
				$petugas_peminjaman = $petugas_perpus[$nrp_petugas_peminjaman];
			}
			$nrp_petugas_pengambilan = $key->petugas_pengembalian;
			$petugas_pengambilan = "";
			if (isset($petugas_perpus[$nrp_petugas_pengambilan])) {
				$petugas_pengambilan = $petugas_perpus[$nrp_petugas_pengambilan];
			}

			$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pengembalian);
			$pinjaman[$no]['tanggal_jatuh_tempo'] = shortdate_indo2($key->tanggal_jatuh_tempo);
			$pinjaman[$no]['tanggal_pengembalian'] = $tanggal_pengembalian;
			$pinjaman[$no]['hari_telat'] = $telat;
			$pinjaman[$no]['jenis_pelanggaran'] = $key->jenis_pelanggaran;
			$pinjaman[$no]['sanksi'] = '';
			$pinjaman[$no]['denda'] = $key->jumlah_bayar;
			$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
			$pinjaman[$no]['kode_inv'] = $key->kode_inv;
			$pinjaman[$no]['biblio'] = $biblio;
			$pinjaman[$no]['petugas_peminjaman'] = $petugas_peminjaman;
			$pinjaman[$no]['petugas_pengembalian'] = $petugas_pengambilan;
			
			$no++;			
		}

		
		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($export_excel == 'export_excel') {
			$this->load->view('perpustakaan/laporan_pelanggaran_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_pelanggaran_html', $data);
		}

		$this->load->view('template/js');
	}

	#laporan_peminjaman
	function laporan_anggota_sering_meminjam(){
		$this->load->view('template/header');

		$data['instansi'] = $this->m_models->get_data("id_instansi, nama", "perpus_instansi", "ORDER BY id_sekolah ASC");
		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_anggota_sering_meminjam', $data); 

		$this->load->view('template/footer');
	}

	function laporan_anggota_sering_meminjam_frek(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$jumlah_ranking = $this->input->post('jumlah_ranking', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);
		$frekuensi_excel = $this->input->post('frekuensi_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
		
	
		$arraywhere = array(
			'perpus_pinjaman.tanggal_pinjam >=' => $tanggal['tanggal1'], 
			'perpus_pinjaman.tanggal_pinjam <=' => $tanggal['tanggal2']
		);

		if ($id_instansi != 'semua_instansi') {
			$arraywhere['perpus_anggota.id_instansi'] = $id_instansi;
		}
	
		$q_pinjaman = $this->perpus_models->getJoin2whereGroupLimit("COUNT(perpus_pinjaman.id_user) AS freq, perpus_pinjaman.tanggal_pinjam, perpus_pinjaman.id_user, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama as nama_anggota", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv", 
			"perpus_anggota", "perpus_anggota.id_user=perpus_pinjaman.id_user", 
			$arraywhere, "perpus_pinjaman.id_user", "freq", "DESC", $jumlah_ranking);

		$no = 0;
		foreach ($q_pinjaman as $key) {

			$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pinjam);
			$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
			$pinjaman[$no]['jumlah'] = $key->freq;			
			$no++;			
		}

		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($frekuensi_excel == 'frekuensi_excel') {
			$this->load->view('perpustakaan/laporan_anggota_sering_meminjam_frek_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_anggota_sering_meminjam_frek_html', $data);
		}

		$this->load->view('template/js');
	
	}

	function laporan_anggota_sering_meminjam_data(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$jumlah_ranking = $this->input->post('jumlah_ranking', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);
		$frekuensi_excel = $this->input->post('frekuensi_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
	
		if ($id_instansi != 'semua_instansi') {
			$q_pinjaman = $this->perpus_models->get_table("p.id_user, p.tanggal_pinjam, p.kode_inv, 
				perpus_bahan_pustaka.id_biblio, perpus_anggota.nama,
	  			(SELECT COUNT('x') FROM perpus_pinjaman cp WHERE cp.id_user = p.id_user) as freq
				FROM perpus_pinjaman p
				JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=p.kode_inv
				JOIN perpus_anggota ON perpus_anggota.id_user=p.id_user
				WHERE p.tanggal_pinjam >= '".$tanggal['tanggal1']."' AND p.tanggal_pinjam <= '".$tanggal['tanggal2']."' AND perpus_anggota.id_instansi = '".$id_instansi."'
				order by freq DESC limit ". $jumlah_ranking
	  		);

		}else{ 
			$q_pinjaman = $this->perpus_models->get_table("p.id_user, p.tanggal_pinjam, p.kode_inv, 
				perpus_bahan_pustaka.id_biblio, perpus_anggota.nama,
	  			(SELECT COUNT('x') FROM perpus_pinjaman cp WHERE cp.id_user = p.id_user) as freq
				FROM perpus_pinjaman p
				JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=p.kode_inv
				JOIN perpus_anggota ON perpus_anggota.id_user=p.id_user
				WHERE p.tanggal_pinjam >= '".$tanggal['tanggal1']."' AND p.tanggal_pinjam <= '".$tanggal['tanggal2']."'
				order by freq DESC limit ". $jumlah_ranking
	  		);			
		}

		$no = 0;
		foreach ($q_pinjaman as $key) {
			# cari biblio
			$biblio = $this->get_biblio($key->id_biblio);

			$pinjaman[$no]['tanggal_pinjam'] = shortdate_indo2($key->tanggal_pinjam);
			$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama;
			$pinjaman[$no]['kode_inv'] = $key->kode_inv;	
			$pinjaman[$no]['biblio'] = $biblio;			
			$no++;			
		}

		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($data_excel == 'data_excel') {
			$this->load->view('perpustakaan/laporan_anggota_sering_meminjam_data_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_anggota_sering_meminjam_data_html', $data);
		}

		$this->load->view('template/js');
	}

	#statistik_peminjaman
	function statistik_peminjaman(){
		$this->load->view('template/header');

		$data['instansi'] = $this->m_models->get_data("id_instansi, nama, id_sekolah", "perpus_instansi", "ORDER BY id_sekolah ASC");
		# tampilkan data ke view
		$this->load->view('perpustakaan/statistik_peminjaman', $data); 

		$this->load->view('template/footer');
	}

	function statistik_peminjaman_grafik(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$bulan_dari = $this->input->post('bulan_dari', TRUE);
		$tahun_dari = $this->input->post('tahun_dari', TRUE);
		$bulan_sampai = $this->input->post('bulan_sampai', TRUE);
		$tahun_sampai = $this->input->post('tahun_sampai', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);
		$data_pdf = $this->input->post('data_pdf', TRUE);

		$datetime1 = date_create($tahun_dari.'-'.$bulan_dari.'-01');
		$datetime2 = date_create($tahun_sampai.'-'.$bulan_sampai.'-28');
		$interval = date_diff($datetime1, $datetime2);
		$sel_bulan = $interval->format('%m');
		$sel_tahun = $interval->format('%y');
		$jml_bulan = ($sel_tahun * 12) + ($sel_bulan + 1);
		$bulan_awal = date('Y-m', strtotime(date($tahun_dari.'-'.$bulan_dari) . '- 1 month')); 
		
		
		if ($id_instansi != 'semua_instansi') { 
			if (strpos($id_instansi, '-') !== false) {
				$exp = explode("-", $id_instansi);
				$id_sekolah = $exp[1];

				$tahun_bulan = $bulan_awal;
				for ($i=0; $i < $jml_bulan; $i++) { 
					$tahun_bulan = date('Y-m', strtotime(date($tahun_bulan) . '+ 1 month'));
					$arraywhere = array('perpus_pinjaman.tanggal_pinjam like' => $tahun_bulan.'%', 'perpus_anggota.id_instansi' => '1',  'perpus_pinjaman.id_kelas' => $id_sekolah);
					$pinjaman[] = $this->m_models->getRowsJoin1Where("perpus_pinjaman.id_pinjaman", "perpus_pinjaman", "perpus_anggota", "perpus_pinjaman.id_user=perpus_anggota.id_user", $arraywhere, 'id_pinjaman', 'ASC');
					$nama_bulan = bulan(intval(substr($tahun_bulan, 5, 2)));
					$bulan[] = $nama_bulan;
				}
			}else{
				$tahun_bulan = $bulan_awal;
				for ($i=0; $i < $jml_bulan; $i++) { 
					$tahun_bulan = date('Y-m', strtotime(date($tahun_bulan) . '+ 1 month'));
					$arraywhere = array('perpus_pinjaman.tanggal_pinjam like' => $tahun_bulan.'%', 'perpus_anggota.id_instansi' => $id_instansi );
					$pinjaman[] = $this->m_models->getRowsJoin1Where("perpus_pinjaman.id_pinjaman", "perpus_pinjaman", "perpus_anggota", "perpus_pinjaman.id_user=perpus_anggota.id_user", $arraywhere, 'id_pinjaman', 'ASC');
					$nama_bulan = bulan(intval(substr($tahun_bulan, 5, 2)));
					$bulan[] = $nama_bulan;
				}
			}

		}else{ 
			$tahun_bulan = $bulan_awal;
			for ($i=0; $i < $jml_bulan; $i++) { 
				$tahun_bulan = date('Y-m', strtotime(date($tahun_bulan) . '+ 1 month'));
				$arraywhere = array('perpus_pinjaman.tanggal_pinjam like' => $tahun_bulan.'%' );
				$pinjaman[] = $this->m_models->getRowsJoin1Where("perpus_pinjaman.id_pinjaman", "perpus_pinjaman", "perpus_anggota", "perpus_pinjaman.id_user=perpus_anggota.id_user", $arraywhere, 'id_pinjaman', 'ASC');
				$nama_bulan = bulan(intval(substr($tahun_bulan, 5, 2)));
				$bulan[] = $nama_bulan;
			}			
		}

		$data['pinjaman'] = $pinjaman;
		$data['bulan'] = $bulan;

		# cari tahun akademik
		$tanggal = $tahun_dari.'-'.$bulan_dari.'-25';
		$ta = $this->m_models->get_data("periode", "tahun_akademik", "WHERE tanggal_mulai <= '$tanggal' AND tanggal_selesai >= '$tanggal'");
		$data['tahun_akademik'] = $ta[0]->periode;

		# cari instansi
		if (strpos($id_instansi, '-') !== false) {
			$exp = explode("-", $id_instansi);
			$id_sekolah = $exp[1];
			$sekolah = $this->m_models->get_data("nama", "sekolah", "WHERE id_sekolah='$id_sekolah' ");
			$data['nama_instansi'] = 'SDM '.$sekolah[0]->nama;
		}elseif($id_instansi =='semua_instansi'){
			$data['nama_instansi'] = 'Al-Multazam';
		}else{
			$instansi = $this->m_models->get_data("nama", "perpus_instansi", "WHERE id_instansi='$id_instansi' ");
			$data['nama_instansi'] = $instansi[0]->nama;
		}

		if ($data_excel == 'data_excel') {
			$this->load->view('perpustakaan/statistik_peminjaman_grafik_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/statistik_peminjaman_grafik_html', $data);
		}

		$this->load->view('template/js');
	}


	function laporan_anggota_sering_berkunjung(){
		$this->load->view('template/header');

		$data['instansi'] = $this->m_models->get_data("id_instansi, nama", "perpus_instansi", "ORDER BY id_sekolah ASC");
		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_anggota_sering_berkunjung', $data); 

		$this->load->view('template/footer');
	}

	function laporan_anggota_sering_berkunjung_frek(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$jumlah_ranking = $this->input->post('jumlah_ranking', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);
		$frekuensi_excel = $this->input->post('frekuensi_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
		
	
		$arraywhere = array(
			'perpus_kunjungan.waktu >=' => $tanggal['tanggal1'], 
			'perpus_kunjungan.waktu <=' => $tanggal['tanggal2']
		);

		if ($id_instansi != 'semua_instansi') {
			$arraywhere['perpus_anggota.id_instansi'] = $id_instansi;
		}
	
		$q_kunjungan = $this->perpus_models->getJoin1whereGroupLimit("COUNT(perpus_kunjungan.id_user) AS freq, perpus_kunjungan.waktu, perpus_kunjungan.id_user, perpus_anggota.nama as nama_anggota", "perpus_kunjungan", 
			"perpus_anggota", "perpus_anggota.id_user=perpus_kunjungan.id_user", 
			$arraywhere, "perpus_kunjungan.id_user", "freq", "DESC", $jumlah_ranking);

		$no = 0;
		foreach ($q_kunjungan as $key) {

			$pinjaman[$no]['waktu_kunjungan'] = shortdate_indo3($key->waktu);
			$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama_anggota;
			$pinjaman[$no]['jumlah'] = $key->freq;			
			$no++;			
		}

		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($frekuensi_excel == 'frekuensi_excel') {
			$this->load->view('perpustakaan/laporan_anggota_sering_berkunjung_frek_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_anggota_sering_berkunjung_frek_html', $data);
		}

		$this->load->view('template/js');
	
	}

function laporan_anggota_sering_berkunjung_data(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$jumlah_ranking = $this->input->post('jumlah_ranking', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);
		$frekuensi_excel = $this->input->post('frekuensi_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
	
		if ($id_instansi != 'semua_instansi') {
			$q_pinjaman = $this->perpus_models->get_table("p.id_user, p.waktu, perpus_anggota.nama,
	  			(SELECT COUNT('x') FROM perpus_kunjungan cp WHERE cp.id_user = p.id_user) as freq
				FROM perpus_kunjungan p
				JOIN perpus_anggota ON perpus_anggota.id_user=p.id_user
				WHERE p.waktu >= '".$tanggal['tanggal1']."' AND p.waktu <= '".$tanggal['tanggal2']."' AND perpus_anggota.id_instansi = '".$id_instansi."'
				order by freq DESC limit ". $jumlah_ranking
	  		);

		}else{ 
			$q_pinjaman = $this->perpus_models->get_table("p.id_user, p.waktu, perpus_anggota.nama,
	  			(SELECT COUNT('x') FROM perpus_kunjungan cp WHERE cp.id_user = p.id_user) as freq
				FROM perpus_kunjungan p
				JOIN perpus_anggota ON perpus_anggota.id_user=p.id_user
				WHERE p.waktu >= '".$tanggal['tanggal1']."' AND p.waktu <= '".$tanggal['tanggal2']."'
				order by freq DESC limit ". $jumlah_ranking
	  		);			
		}

		$no = 0;
		foreach ($q_pinjaman as $key) {

			$pinjaman[$no]['waktu_kunjungan'] = shortdate_indo3($key->waktu);
			$pinjaman[$no]['id_anggota'] = $key->id_user;
			$pinjaman[$no]['nama_anggota'] = $key->nama;
		//	$pinjaman[$no]['kode_inv'] = $key->kode_inv;	
		//	$pinjaman[$no]['biblio'] = $biblio;			
			$no++;			
		}

		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pinjaman'] = $pinjaman;
		}
	
		if ($data_excel == 'data_excel') {
			$this->load->view('perpustakaan/laporan_anggota_sering_berkunjung_data_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_anggota_sering_berkunjung_data_html', $data);
		}

		$this->load->view('template/js');
	}

#statistik_peminjaman
	function statistik_kunjungan(){
		$this->load->view('template/header');

		$data['instansi'] = $this->m_models->get_data("id_instansi, nama, id_sekolah", "perpus_instansi", "ORDER BY id_sekolah ASC");
		# tampilkan data ke view
		$this->load->view('perpustakaan/statistik_kunjungan', $data); 

		$this->load->view('template/footer');
	}

	function statistik_kunjungan_grafik(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$bulan_dari = $this->input->post('bulan_dari', TRUE);
		$tahun_dari = $this->input->post('tahun_dari', TRUE);
		$bulan_sampai = $this->input->post('bulan_sampai', TRUE);
		$tahun_sampai = $this->input->post('tahun_sampai', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);
		$data_pdf = $this->input->post('data_pdf', TRUE);

		$datetime1 = date_create($tahun_dari.'-'.$bulan_dari.'-01');
		$datetime2 = date_create($tahun_sampai.'-'.$bulan_sampai.'-28');
		$interval = date_diff($datetime1, $datetime2);
		$sel_bulan = $interval->format('%m');
		$sel_tahun = $interval->format('%y');
		$jml_bulan = ($sel_tahun * 12) + ($sel_bulan + 1);
		$bulan_awal = date('Y-m', strtotime(date($tahun_dari.'-'.$bulan_dari) . '- 1 month')); 
		
		
		if ($id_instansi != 'semua_instansi') { 
			if (strpos($id_instansi, '-') !== false) {
				$exp = explode("-", $id_instansi);
				$id_sekolah = $exp[1];

				$tahun_bulan = $bulan_awal;
				for ($i=0; $i < $jml_bulan; $i++) { 
					$tahun_bulan = date('Y-m', strtotime(date($tahun_bulan) . '+ 1 month'));
					$arraywhere = array('perpus_kunjungan.waktu like' => $tahun_bulan.'%', 'perpus_anggota.id_instansi' => '1',  'perpus_kunjungan.id_kelas' => $id_sekolah);
					$kunjungan[] = $this->m_models->getRowsJoin1Where("perpus_kunjungan.id_kunjungan", "perpus_kunjungan", "perpus_anggota", "perpus_kunjungan.id_user=perpus_anggota.id_user", $arraywhere, 'id_kunjungan', 'ASC');
					$nama_bulan = bulan(intval(substr($tahun_bulan, 5, 2)));
					$bulan[] = $nama_bulan;
				}
			}else{
				$tahun_bulan = $bulan_awal;
				for ($i=0; $i < $jml_bulan; $i++) { 
					$tahun_bulan = date('Y-m', strtotime(date($tahun_bulan) . '+ 1 month'));
					$arraywhere = array('perpus_kunjungan.waktu like' => $tahun_bulan.'%', 'perpus_anggota.id_instansi' => $id_instansi );
					$kunjungan[] = $this->m_models->getRowsJoin1Where("perpus_kunjungan.id_kunjungan", "perpus_kunjungan", "perpus_anggota", "perpus_kunjungan.id_user=perpus_anggota.id_user", $arraywhere, 'id_kunjungan', 'ASC');
					$nama_bulan = bulan(intval(substr($tahun_bulan, 5, 2)));
					$bulan[] = $nama_bulan;
				}
			}

		}else{ 
			$tahun_bulan = $bulan_awal;
			for ($i=0; $i < $jml_bulan; $i++) { 
				$tahun_bulan = date('Y-m', strtotime(date($tahun_bulan) . '+ 1 month'));
				$arraywhere = array('perpus_kunjungan.waktu like' => $tahun_bulan.'%' );
				$kunjungan[] = $this->m_models->getRowsJoin1Where("perpus_kunjungan.id_kunjungan", "perpus_kunjungan", "perpus_anggota", "perpus_kunjungan.id_user=perpus_anggota.id_user", $arraywhere, 'id_kunjungan', 'ASC');
				$nama_bulan = bulan(intval(substr($tahun_bulan, 5, 2)));
				$bulan[] = $nama_bulan;
			}			
		}

		$data['kunjungan'] = $kunjungan;
		$data['bulan'] = $bulan;

		# cari tahun akademik
		$tanggal = $tahun_dari.'-'.$bulan_dari.'-25';
		$ta = $this->m_models->get_data("periode", "tahun_akademik", "WHERE tanggal_mulai <= '$tanggal' AND tanggal_selesai >= '$tanggal'");
		$data['tahun_akademik'] = $ta[0]->periode;

		# cari instansi
		if (strpos($id_instansi, '-') !== false) {
			$exp = explode("-", $id_instansi);
			$id_sekolah = $exp[1];
			$sekolah = $this->m_models->get_data("nama", "sekolah", "WHERE id_sekolah='$id_sekolah' ");
			$data['nama_instansi'] = 'SDM '.$sekolah[0]->nama;
		}elseif($id_instansi =='semua_instansi'){
			$data['nama_instansi'] = 'Al-Multazam';
		}else{
			$instansi = $this->m_models->get_data("nama", "perpus_instansi", "WHERE id_instansi='$id_instansi' ");
			$data['nama_instansi'] = $instansi[0]->nama;
		}

		if ($data_excel == 'data_excel') {
			$this->load->view('perpustakaan/statistik_kunjungan_grafik_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/statistik_kunjungan_grafik_html', $data);
		}

		$this->load->view('template/js');
	}


	function laporan_bahan_pustaka(){
		$this->load->view('template/header');

		$data['instansi'] = $this->m_models->get_data("id_instansi, nama", "perpus_instansi", "ORDER BY id_sekolah ASC");

		$data['klasifikasi'] = array(
			'0' => '000-Karya Umum', 
			'1' => '100-Filsafat dan Fsikologi', 
			'2' => '200-Agama',
			'3' => '300-Sosial',
			'4' => '400-Bahasa',
			'5' => '500-Ilmu Murni',
			'6' => '600-Ilmu Terapan',
			'7' => '700-Olah Raga dan Kesenian',
			'8' => '800-Kesusasteraan',
			'9' => '900-Sejarah dan Geografi',
		);


		$d_bahan_pustaka = $this->m_models->get_data("(CASE WHEN b.klasifikasi LIKE '0%' THEN '0'
         		WHEN b.klasifikasi LIKE '1%' THEN '1'
         		WHEN b.klasifikasi LIKE '2%' THEN '2'
         		WHEN b.klasifikasi LIKE '3%' THEN '3'
         		WHEN b.klasifikasi LIKE '4%' THEN '4'
         		WHEN b.klasifikasi LIKE '5%' THEN '5'
         		WHEN b.klasifikasi LIKE '6%' THEN '6'
         		WHEN b.klasifikasi LIKE '7%' THEN '7'
         		WHEN b.klasifikasi LIKE '8%' THEN '8'
         		WHEN b.klasifikasi LIKE '9%' THEN '9'
    		END) as kalsifikasi_grp, COUNT(*) AS jumlah, bp.id_status_item AS status_item, b.id_kategori_buku AS kategori_buku", 
    		"perpus_bahan_pustaka AS bp", 
    		"JOIN perpus_biblio AS b ON bp.id_biblio=b.id_biblio WHERE bp.id_jenis_pustaka='1'
    		GROUP BY (CASE WHEN b.klasifikasi LIKE '0%' THEN '0'
         		WHEN b.klasifikasi LIKE '1%' THEN '1'
         		WHEN b.klasifikasi LIKE '2%' THEN '2'
         		WHEN b.klasifikasi LIKE '3%' THEN '3'
         		WHEN b.klasifikasi LIKE '4%' THEN '4'
         		WHEN b.klasifikasi LIKE '5%' THEN '5'
         		WHEN b.klasifikasi LIKE '6%' THEN '6'
         		WHEN b.klasifikasi LIKE '7%' THEN '7'
         		WHEN b.klasifikasi LIKE '8%' THEN '8'
         		WHEN b.klasifikasi LIKE '9%' THEN '9'
    		END), bp.id_status_item, b.id_kategori_buku ORDER BY b.klasifikasi ASC ");

		foreach ($d_bahan_pustaka as $key) {
			$bahan_pustaka[$key->kalsifikasi_grp][$key->kategori_buku][$key->status_item] = $key->jumlah;
		}

		$data['buku'] = $bahan_pustaka;

		$d_bahan_pustaka = $this->m_models->get_data("(CASE WHEN b.klasifikasi LIKE '0%' THEN '0'
         		WHEN b.klasifikasi LIKE '1%' THEN '1'
         		WHEN b.klasifikasi LIKE '2%' THEN '2'
         		WHEN b.klasifikasi LIKE '3%' THEN '3'
         		WHEN b.klasifikasi LIKE '4%' THEN '4'
         		WHEN b.klasifikasi LIKE '5%' THEN '5'
         		WHEN b.klasifikasi LIKE '6%' THEN '6'
         		WHEN b.klasifikasi LIKE '7%' THEN '7'
         		WHEN b.klasifikasi LIKE '8%' THEN '8'
         		WHEN b.klasifikasi LIKE '9%' THEN '9'
    		END) as kalsifikasi_grp, COUNT(*) AS jumlah, bp.id_jenis_pustaka", 
    		"perpus_bahan_pustaka AS bp", 
    		"JOIN perpus_biblio AS b ON bp.id_biblio=b.id_biblio WHERE bp.id_jenis_pustaka!='1'
    		GROUP BY (CASE WHEN b.klasifikasi LIKE '0%' THEN '0'
         		WHEN b.klasifikasi LIKE '1%' THEN '1'
         		WHEN b.klasifikasi LIKE '2%' THEN '2'
         		WHEN b.klasifikasi LIKE '3%' THEN '3'
         		WHEN b.klasifikasi LIKE '4%' THEN '4'
         		WHEN b.klasifikasi LIKE '5%' THEN '5'
         		WHEN b.klasifikasi LIKE '6%' THEN '6'
         		WHEN b.klasifikasi LIKE '7%' THEN '7'
         		WHEN b.klasifikasi LIKE '8%' THEN '8'
         		WHEN b.klasifikasi LIKE '9%' THEN '9'
    		END), bp.id_jenis_pustaka ORDER BY b.klasifikasi ASC ");

		foreach ($d_bahan_pustaka as $key) {
			$koleksi[$key->kalsifikasi_grp][$key->id_jenis_pustaka] = $key->jumlah;
		}

		$data['koleksi'] = $koleksi;

		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_bahan_pustaka', $data); 

		$this->load->view('template/footer');

		# melihat buku yang tidak ada kategori sama belum ada klasifikasinya
		// SELECT bp.kode_inv, b.judul, b.klasifikasi, b.id_kategori_buku
  //       		FROM perpus_bahan_pustaka AS bp 
  //               JOIN perpus_biblio AS b ON bp.id_biblio=b.id_biblio 
  //               WHERE bp.id_jenis_pustaka='1' 					
  //               	AND b.klasifikasi NOT LIKE '0%'
  //            		AND b.klasifikasi NOT LIKE '1%' 
  //            		AND b.klasifikasi NOT LIKE '2%' 
  //            		AND b.klasifikasi NOT LIKE '3%' 
  //            		AND b.klasifikasi NOT LIKE '4%' 
  //            		AND b.klasifikasi NOT LIKE '5%'
  //            		AND b.klasifikasi NOT LIKE '6%' 
  //            		AND b.klasifikasi NOT LIKE '7%' 
  //            		AND b.klasifikasi NOT LIKE '8%' 
  //            		AND b.klasifikasi NOT LIKE '9%'
  //       		ORDER BY bp.kode_inv ASC
  //       		
  //       		mencari biblio CD 3 dan malajah 2 yang belum ada klasnya
  //       		SELECT bp.kode_inv, b.judul, b.id_biblio, b.klasifikasi
        		// FROM perpus_biblio AS b 
          //       JOIN perpus_bahan_pustaka AS bp ON bp.id_biblio=b.id_biblio WHERE bp.id_jenis_pustaka='2' 
          //       	AND b.klasifikasi NOT LIKE '0%'
          //    		AND b.klasifikasi NOT LIKE '1%' 
          //    		AND b.klasifikasi NOT LIKE '2%' 
          //    		AND b.klasifikasi NOT LIKE '3%' 
          //    		AND b.klasifikasi NOT LIKE '4%' 
          //    		AND b.klasifikasi NOT LIKE '5%'
          //    		AND b.klasifikasi NOT LIKE '6%' 
          //    		AND b.klasifikasi NOT LIKE '7%' 
          //    		AND b.klasifikasi NOT LIKE '8%' 
          //    		AND b.klasifikasi NOT LIKE '9%'
          //       GROUP BY b.id_biblio
        		// ORDER BY bp.kode_inv ASC
	}


	function telat(){
		$this->load->helper('absen');

		//echo get_selisih_hari('2019-02-18', '2019-04-04');
			    	date_default_timezone_set('Asia/Jakarta');
			$awal  = date_create('2019-03-01'.' 00:00:00');
			$akhir = date_create('2019-04-04'.' 00:00:00'); 
			$diff  = $awal->diff($akhir);
			
			// echo $diff->y . ' tahun, ';
			// echo $diff->m . ' bulan, ';
			// echo $diff->d . ' hari, ';
			// echo $diff->h . ' jam, ';
			// echo $diff->i . ' menit, ';
			// echo $diff->s . ' detik, ';
			

			echo $diff->days;

	}

	function laporan_kunjungan(){
		$this->load->view('template/header');

		$data['instansi'] = $this->m_models->get_data("id_instansi, nama", "perpus_instansi", "ORDER BY id_sekolah ASC");
		# tampilkan data ke view
		$this->load->view('perpustakaan/laporan_kunjungan', $data); 

		$this->load->view('template/footer');
	}

	function laporan_kunjungan_data(){ 
		$this->load->view('template/head');
	//	$posted  = $this->input->post(); 
	//	var_dump($posted);
		# get POST pencarian
	
		$periode = $this->input->post('periode', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);
		$data_excel = $this->input->post('data_excel', TRUE);

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);
	
		if ($id_instansi != 'semua_instansi') {
			$data['kunjungan'] = $this->perpus_models->get_table("p.id_user, p.waktu, perpus_anggota.nama, perpus_instansi.nama AS instansi
				FROM perpus_anggota
				RIGHT JOIN perpus_kunjungan p ON perpus_anggota.id_user=p.id_user
				LEFT JOIN perpus_instansi ON perpus_anggota.id_instansi=perpus_instansi.id_instansi
				WHERE p.waktu >= '".$tanggal['tanggal1']."' AND p.waktu <= '".$tanggal['tanggal2']."' AND perpus_anggota.id_instansi = '".$id_instansi."'
				order by p.waktu ASC"
	  		);

		}else{ 
			$data['kunjungan'] = $this->perpus_models->get_table("p.id_user, p.waktu, perpus_anggota.nama, perpus_instansi.nama AS instansi
				FROM perpus_anggota
				RIGHT JOIN perpus_kunjungan p ON perpus_anggota.id_user=p.id_user
				LEFT JOIN perpus_instansi ON perpus_anggota.id_instansi=perpus_instansi.id_instansi
				WHERE p.waktu >= '".$tanggal['tanggal1']."' AND p.waktu <= '".$tanggal['tanggal2']."'
				order by p.waktu ASC"
	  		);			
		}
	
		if ($data_excel == 'data_excel') {
			$this->load->view('perpustakaan/laporan_kunjungan_data_excel', $data);
		}else{ 
			$this->load->view('perpustakaan/laporan_kunjungan_data_html', $data);
		}

		$this->load->view('template/js');
	}


}