<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Lap_keuangan extends CI_Controller {
	function __construct() {
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	function jurnal(){ 
	   $this->load->view('template/header');
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_sekolah']=$nm_sekolah;
	    $data['nm_sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");
	    $where=array('id_sekolah =' => $id_sekolah);
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");

        $akun1 = $this->input->post('akun1');
        $akun2 = $this->input->post('akun2');
        $urai = $this->input->post('uraian');
        $pemohon = $this->input->post('pemohon');
        $nom = $this->input->post('nominal');
        $jenjang = $this->input->post('jenjang');
        $tgl = $this->input->post('tgl');
        $uraian = $urai."_".$pemohon;

        $jnom=substr_count($nom, ".");
		if ($jnom==0){
			$nominal=$nom;
		} else {
			$nominal=str_replace(".","",$nom);
		}
        
        $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
        foreach ($data['tahun'] as $tahun){ 
			if (($akun1 != "") && ($akun2 != "") && ($nominal != "")){
				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$tanggal=date("Y-m-d");
				$no_jurnal=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => "0", 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $nominal, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve",'asal' => "jurnal harian", 'id_tahun'=>$tahun->id_tahun, 'nrp'=> $nrp);
				if ($this->m_models->save_data($no_jurnal, "jurnal") == TRUE) {
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
        }
	    $this->load->view('laporan_keuangan/input_jurnal', $data); 
	   	$this->load->view('template/footer');
  	}  

  	
  	function bukubesar(){ 
	   	$this->load->view('template/header');
  		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_sekolah']=$nm_sekolah;
	    $data['nm_sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");
	    $where=array('id_sekolah =' => $id_sekolah);
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    	if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    		$ar_div = array('status_aktif' => "on");
			} else {
				$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
			}
	    	$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
	    }

	    $tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
    	$tahun = $this->input->post('tahun', TRUE);
    	$akun = $this->input->post('akun', TRUE);
    	$jenjang = $this->input->post('jenjang', TRUE);
    	$data['akn']=$akun;
    	$data['id_akun']=$akun;
    	$data['nm_akun']=all("akun", "id_akun", $akun, "nama_akun");
    	if (($tahun != "") && ($akun != "")&& ($jenjang != "")){
	        $arwherep1 = array('akun.id_akun =' => $akun);
	        $data['akunp1'] = $this->m_models->getJoin1where("akun.*, rules_akun.debet, rules_akun.kredit, rules_akun.normal", "akun", "rules_akun", "rules_akun.id_akun=akun.id_akun",$arwherep1, "akun.id_akun", "asc");
	        foreach ($data['akunp1'] as $akunp1){
	        	$data['nm_akun']=$akunp1->nama_akun;
	        	$data['id_akun']=$akunp1->id_akun;
	        	$data['t1'] = $akunp1->debet;
	            $data['t2'] = $akunp1->kredit;
	            $data['normal'] = $akunp1->normal;
	        }
	            $arjurnal = array('approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'id_tahun = ' => $tahun, 'id_sekolah = '=>$jenjang, 'tgl >='=>$tgl_dari, 'tgl <='=>$tgl_sampai);
		        $arorw = "(akun1 ='$akun' or akun2 = '$akun')";
		        $data['jurnal']= $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal, $arorw, "tgl", "asc");
				foreach ($data['jurnal'] as $jurnal){
					$arwhere1 = array('id_akun like ' => $jurnal->akun1);
					$data['akun1'] = $this->m_models->getTabelwhere("*", "akun", $arwhere1, "id_akun", "asc");
					foreach ($data['akun1'] as $akun1){
			          	$data['nm_akun1'][]=$akun1->nama_akun; 
			        } 
			       	$arwhere2 = array('id_akun like ' => $jurnal->akun2);
					$data['akun2'] = $this->m_models->getTabelwhere("*", "akun", $arwhere2, "id_akun", "asc");
				    foreach ($data['akun2'] as $akun2){
				      	$data['nm_akun2'][]=$akun2->nama_akun; 
			        }
				}


				//saldo awal jurnal
				$arjurnal1 = array('approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'id_tahun = ' => $tahun, 'id_sekolah = '=>$jenjang, 'tgl <'=>$tgl_dari);
		        $arorw1 = "(akun1 ='$akun' or akun2 = '$akun')";
		        $data['jurnal1']= $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal1, $arorw1, "tgl", "asc");
				foreach ($data['jurnal1'] as $j){
					if ($j->akun1==$akun){
		        		$deb=$j->debet1;
		        		$kre=$j->kredit1;
		        	} else if ($j->akun2==$akun){
		        		$deb=$j->debet2;
		        		$kre=$j->kredit2;
		        	}
		        	$data['debet'][$akun] += $deb;
        			$data['kredit'][$akun] += $kre;
				}

				//saldo akhir jurnal
				$arjurnal2 = array('approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'id_tahun = ' => $tahun, 'id_sekolah = '=>$jenjang, 'tgl <='=>$tgl_sampai);
		        $arorw2 = "(akun1 ='$akun' or akun2 = '$akun')";
		        $data['jurnal2']= $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal2, $arorw2, "tgl", "asc");
				foreach ($data['jurnal2'] as $j1){
					if ($j1->akun1==$akun){
		        		$deb1=$j1->debet1;
		        		$kre1=$j1->kredit1;
		        	} else if ($j1->akun2==$akun){
		        		$deb1=$j1->debet2;
		        		$kre1=$j1->kredit2;
		        	} 
		        	$data['debet1'][$akun] += $deb1;
        			$data['kredit1'][$akun] += $kre1;
				}
    	}

    	 $this->load->view('laporan_keuangan/bukubesar', $data); 
	   	$this->load->view('template/footer');
    }


    function aruskas(){ 
	   	$this->load->view('template/header');
  		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_sekolah']=$nm_sekolah;
	    $data['nm_sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");
	    $where=array('id_sekolah =' => $id_sekolah);
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    	if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    		$ar_div = array('status_aktif' => "on");
			} else {
				$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
			}
	    	$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
	    }

	    $tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
    	$tahun = $this->input->post('tahun', TRUE);
    	$jenjang = $this->input->post('jenjang', TRUE);
    	$data['akn']=$akun;
    	if (($tahun != "") && ($jenjang != "")){
    		$debet=0; $kredit=0;
 			foreach ($data['akun'] as $akun) { 
		        $arjurnal = array('approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'id_tahun = ' => $tahun, 'id_sekolah = '=>$jenjang, 'tgl >='=>$tgl_dari, 'tgl <='=>$tgl_sampai);
		        $arorw = "(akun1 ='$akun->id_akun' or akun2 = '$akun->id_akun')";
		        $data['jurnal']= $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal, $arorw, "tgl", "asc");
		        foreach ($data['jurnal'] as $j){
		        	if ($j->akun1==$akun->id_akun){
		        		$deb=$j->debet1;
		        		$kre=$j->kredit1;
		        	} else if ($j->akun2==$akun->id_akun){
		        		$deb=$j->debet2;
		        		$kre=$j->kredit2;
		        	}
		        	$data['debet'][$akun->id_akun] += $deb;
        			$data['kredit'][$akun->id_akun] += $kre;
		        }

				//saldo awal jurnal
				$arjurnal1 = array('approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'id_tahun = ' => $tahun, 'id_sekolah = '=>$jenjang, 'tgl <'=>$tgl_dari);
		        $arorw1 = "(akun1 ='$akun->id_akun' or akun2 = '$akun->id_akun')";
		        $data['jurnal1']= $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal1, $arorw1, "tgl", "asc");
				foreach ($data['jurnal1'] as $j1){
		        	if ($j1->akun1==$akun->id_akun){
		        		$deb1=$j1->debet1;
		        		$kre1=$j1->kredit1;
		        	} else if ($j1->akun2==$akun->id_akun){
		        		$deb1=$j1->debet2;
		        		$kre1=$j1->kredit2;
		        	}
		        	$data['debet1'][$akun->id_akun] += $deb1;
        			$data['kredit1'][$akun->id_akun] += $kre1;
		        }

				//saldo awal jurnal
				$arjurnal2 = array('approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'id_tahun = ' => $tahun, 'id_sekolah = '=>$jenjang, 'tgl <='=>$tgl_sampai);
		        $arorw2 = "(akun1 ='$akun->id_akun' or akun2 = '$akun->id_akun')";
		        $data['jurnal2']= $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal2, $arorw2, "tgl", "asc");
				foreach ($data['jurnal2'] as $j2){ 
		        	if ($j2->akun1==$akun->id_akun){
		        		$deb2=$j2->debet1;
		        		$kre2=$j2->kredit1;
		        	} else if ($j2->akun2==$akun->id_akun){
		        		$deb2=$j2->debet2;
		        		$kre2=$j2->kredit2;
		        	}
		        	$data['debet2'][$akun->id_akun] += $deb2;
        			$data['kredit2'][$akun->id_akun] += $kre2;
		        }
			}
    	}

    	$this->load->view('laporan_keuangan/jurnal_aruskas', $data); 
	   	$this->load->view('template/footer');
    }
    
    //pengajuan jurnal keuangan
    function pengajuan_jurnal(){ 
	   $this->load->view('template/header');
	    $hak_akses=$this->session->userdata['hak_akses'];
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_sekolah']=$nm_sekolah;
	    $data['nm_sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");


		$ar_or=array('approve1' => 'Proses', 'approve2'=>'Proses', 'approve3'=>'Proses');
		$data['p_cuti']=$this->m_models->getTabelAOrWhere("*", "jurnal", $ar_or, "tgl", "asc");
		foreach ($data['p_cuti'] as $pc){
			$id_sekolah=all("pegawai", "nrp", $pc->nrp, "id_sekolah");
			$nrp_cuti=$pc->nrp; 
			$alurApp[$nrp_cuti]=$this->m_models->alurApp($hak_akses, "jurnal", $id_sekolah);
			if ($alurApp[$nrp_cuti]=="approve1"){
				$arr=array('Approve1' => 'Proses', 'nrp'=>$nrp_cuti);
			} else if ($alurApp[$nrp_cuti]=="approve2"){
				$arr=array('Approve1' => 'Approve', 'Approve2'=>'Proses', 'nrp'=>$nrp_cuti);
			} else if ($alurApp[$nrp_cuti]=="approve3"){
				$arr=array('Approve1' => 'Approve','Approve2'=>'Approve', 'Approve3'=>'Proses', 'nrp'=>$nrp_cuti);
			}
			$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "jurnal", $arr, "tgl", "asc");	
			foreach ($data['peng_cuti'] as $pc) {
				$n++;
				$data['id_sekolah'][]=$pc->id_sekolah;
				$data['no_transaksi'][]=$pc->no_transaksi;
				$data['tgl'][]=$pc->tgl;
				$data['akun1'][]=$pc->akun1;
				$data['akun2'][]=$pc->akun2;
				$data['uraian1'][]=$pc->uraian1;
				$data['debet1'][]=$pc->debet1;
				$data['kredit1'][]=$pc->kredit1;
				$data['approve1'][]=$pc->approve1;
				$data['approve2'][]=$pc->approve2;
				$data['approve3'][]=$pc->approve3;
			}
		}
	 
	    $this->load->view('laporan_keuangan/ajuan_jurnal', $data); 
	   	$this->load->view('template/footer');
  	}  
	

	public function app_pengajuan_jurnal(){
		$nrp=$this->session->userdata['nrp'];
		$id_jab_app=all("pegawai", "nrp", $nrp, "id_jabatan");
		$hak_akses=$this->session->userdata['hak_akses'];
		$hariini=date("Y-m-d");
		$time=date("H:i:s");


        $id_resign = $this->input->post('id_resign', TRUE);
        $ket = $this->input->post('ket', TRUE); 
        $alasan = $this->input->post('alasan', TRUE); 

		$arr=array('id_resign' => $id_resign);
		$data['peng_cuti'] = $this->m_models->getTabelwhere("*", "resign", $arr, "tgl_pengajuan", "asc");
		$id_sekolah=all("pegawai", "nrp", $data['peng_cuti'][0]->nrp, "id_sekolah");
		$ar=array('id_sekolah' => $id_sekolah, 'pengajuan'=>"resign");
		$data['app_pengajuan'] = $this->m_models->getTabelwhere("*", "approval_pengajuan", $ar, "id_app", "asc");
		$id_ap=$data['app_pengajuan'][0]->id_ap; 

		$alur=$this->m_models->cekAlurApp($hak_akses, "resign");
		$cekalur = $this->m_models->cekAlurAppNext($hak_akses, "resign", $alur, $id_sekolah); 
		if ($ket == "A"){
			$k="Approve";
			if ($cekalur==0){
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve', 'Approve2' => 'Approve','Approve3' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve', 'Approve3' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			} else {
				if ($alur == "approve1"){
					$ar_app=array('Approve1' => 'Approve');
				} else if ($alur == "approve2"){
					$ar_app=array('Approve2' => 'Approve');
				} else if ($alur == "approve3"){
					$ar_app=array('Approve3' => 'Approve');
				} 
			}
		} else if ($ket == "R"){
			$k="Reject";
			if ($alur == "approve1"){
				$ar_app=array('Approve1' => 'Reject');
			} else if ($alur == "approve2"){
				$ar_app=array('Approve2' => 'Reject');
			} else if ($alur == "approve3"){
				$ar_app=array('Approve3' => 'Reject');
			} 
		}

		//update pengajuan resign
		$data['update_data'] = $this->m_models->update_data($id_resign, "id_resign", $ar_app, "resign");
		//$update=$this->db->query("update pegawai set status_aktf='Tidak Aktif' where nrp in (select nrp from resign where id_resign='$id_resign')");
			
		//menambahkan ke history update
		$j_cuti = array('tgl'=>$hariini, 'waktu' => $time, 'nrp' => $nrp, 'id_ap' => $id_ap, 'id_pengajuan' => $id_resign, 'status'=>$k, 'keterangan'=>$alasan, 'id_jabatan'=>$id_jab_app, 'level_app'=>$alur);
		/*if ($this->m_models->save_data($j_cuti, 'approval_history') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil di'.$k.' ');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}*/

		redirect('lap_keuangan/pengajuan_jurnal');
	}


	function laporan_aktivitas(){ 
	   	$this->load->view('template/header');
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun2", "desc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=date("Y");
	    	if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    		$ar_div = array('status_aktif' => "on");
			} else {
				$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
			}
	    	$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
	    }

    	$tahun = $this->input->post('tahun', TRUE);
    	$bln = $this->input->post('bln', TRUE);
    	$bulan = $tahun."-".$bln."-";
    	$idsekolah = $this->input->post('jenjang', TRUE);
    	$data['dt_idsekolah']=$idsekolah;
    	$data['id_tahun']=$tahun;
    	$data['bln']=$bulan; 
    	$id_ta=all("tahun_akademik", "tahun2", $tahun, "id_tahun");
    	if (($tahun != "") && ($bulan != "") && ($idsekolah != "")){
    		//pendapatan laba rugi
    		$where=array('id_sekolah =' => $idsekolah, 'akun.id_akun like '=>'4.%');
			$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
			foreach ($data['akun'] as $a) {
				//sub akun
				$nominall=0;
				$ar_pndpt = array('id_sub_akun like' => "4.%");
	    		$data['subakun'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_pndpt, "nama_sub_akun", "asc");
				foreach ($data['subakun'] as $sa) { 
					if ($sa->id_sub_akun==$a->id_sub_akun){
						$nominall += $this->m_models->saldo_jurnal($a->id_akun, $id_ta, $idsekolah, $bulan); 
						$data['nominal'][$sa->id_sub_akun]=$nominal;
					}
				} 
			}


			//beban laba rugi
			$arwheres1 = array('id_sekolah =' => $idsekolah, 'akun.id_akun like '=>'5.%');
			$data['akun1'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $arwheres1, "akun.id_akun", "asc");
			foreach ($data['akun1'] as $a1){
				//sub akun
				$nominal1=0;
				$ar_beban = array('id_sub_akun like' => "5.%");
	    		$data['subakun1'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_beban, "nama_sub_akun", "asc");
				foreach ($data['subakun1'] as $sa1) { 
					if ($sa1->id_sub_akun==$a1->id_sub_akun){ 
						$nominal1 += $this->m_models->saldo_jurnal($a1->id_akun, $id_ta, $idsekolah, $bulan);
						$data['nominal1'][$sa->id_sub_akun]=$nominal1;
					}
				}
			}
		}


	    $this->load->view('laporan_keuangan/labarugi', $data); 
	   	$this->load->view('template/footer');
  	} 


  	function posisi_keuangan(){ 
	   	$this->load->view('template/header');
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun2", "desc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=date("Y");
	    	if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    		$ar_div = array('status_aktif' => "on");
			} else {
				$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
			}
	    	$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
	    }

    	$tombol = $this->input->post('submit', TRUE); 
    	$data['tombol']=$tombol;
    	$hariini=date("Y-m-d");

    	$tahun = $this->input->post('tahun', TRUE);
    	$bln = $this->input->post('bln', TRUE); 
    	$bulan = $tahun."-".$bln."-";
    	$idsekolah = $this->input->post('jenjang', TRUE);
    	$data['dt_idsekolah']=$idsekolah;
    	$data['id_tahun']=$tahun;
    	$data['bln']=$bulan; 
    	$id_ta=all("tahun_akademik", "tahun2", $tahun, "id_tahun");
    	if (($tahun != "") && ($bulan != "") && ($idsekolah != "")){
    		//memunculkan nama sub akun untuk akun 1 
			$ar_a1 = array('id_sub_akun like ' => "1.%");
	    	$data['akun1'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_a1, "id_sub_akun", "asc");
	    	foreach ($data['akun1'] as $ak1){
	    		$data['a1'][]=$ak1->nama_sub_akun; 
	    		$data['id_s_akun'][]=$ak1->id_sub_akun; 

	    		//akun 1
		    	$a_a1=array('id_sub_akun' => $ak1->id_sub_akun);
		    	$data['akn1'] = $this->m_models->getTabelwhere("*", "akun", $a_a1, "id_akun", "asc");
		    	foreach ($data['akn1'] as $akn1) {
		    		$data['nama_akun1'][]=$akn1->nama_akun;
		    		$data['id_akun1'][]=$akn1->id_akun;
		    		$data['id_sub_akun1'][]=$akn1->id_sub_akun;
					$n_aktiva = $this->m_models->saldo_jurnal($akn1->id_akun, $id_ta, $idsekolah, $bulan);
					$j_aktiva[] = $n_aktiva;

					//simpan ke tabel neraca
					if ($n_aktiva != 0){
						$l_neraca_a=array('tanggal' => $hariini, 'petugas' => $nrp, 'akun' => $akn1->id_akun, 'nominal' => $n_aktiva, 'id_sekolah' => $idsekolah, 'id_tahun' => $id_ta, 'periode' => $bulan);
			    		$simpan=$this->m_models->save_data($l_neraca_a, "k_neraca");	
					}
		    	}
	    		$data['j_a1']=$this->m_models->getRowsAWhere("*", "akun", $ar_a1, "id_akun", "asc");
	    	}
	    	$data['ja1']=$this->m_models->getRowsAWhere("*", "sub_akun", $ar_a1, "nama_sub_akun", "asc");


	    	//memunculkan nama sub akun untuk akun 2 dan 3
			$ar_a2 = array('id_sub_akun like '=> '2.%', 'id_sub_akun like'=>'3.%');
	    	$data['akun2'] = $this->m_models->getTabelOr("*", "sub_akun", $ar_a2, "nama_sub_akun", "asc");
	    	foreach ($data['akun2'] as $ak2) {
	    		$data['a2'][]=$ak2->nama_sub_akun;
	    		$data['id_s_akun2'][]=$ak2->id_sub_akun; 
	    		$no++;

	    		//akun 2 dan 3
		    	$a_a2=array('id_sub_akun' => $ak2->id_sub_akun);
		    	$data['akn2'] = $this->m_models->getTabelwhere("*", "akun", $a_a2, "id_akun", "asc");
		    	foreach ($data['akn2'] as $akn2) {
		    		$n++;
		    		$data['nama_akun2'][]=$akn2->nama_akun;
		    		$data['id_akun2'][]=$akn2->id_akun;
		    		$data['id_sub_akun2'][]=$akn2->id_sub_akun;
					$n_pasiva = $this->m_models->saldo_jurnal($akn2->id_akun, $id_ta, $idsekolah, $bulan);
					$j_pasiva[] = $n_pasiva;

					//simpan ke neraca
					if ($n_pasiva != 0){
						$l_neraca_p=array('tanggal' => $hariini, 'petugas' => $nrp, 'akun' => $akn2->id_akun, 'nominal' => $n_pasiva, 'id_sekolah' => $idsekolah, 'id_tahun' => $id_ta, 'periode' => $bulan);
			    		$simpan=$this->m_models->save_data($l_neraca_p, "k_neraca");
					}
		    	}
	    		$data['j_a2']=$n;
	    	}
	    	$data['ja2']=$no;

	    	if ($tombol=="update"){
				if ($simpan == TRUE) {
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				redirect('lap_keuangan/posisi_keuangan');
	    	}

    	}

	    $this->load->view('laporan_keuangan/neraca', $data); 
	   	$this->load->view('template/footer');
  	}  


  	# resume laporan laba rugi untuk tiap2 divisi
  	function resume_lap_aktivitas(){ 
	   	$this->load->view('template/header');
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun2", "desc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=date("Y");
	    }

    	$tahun = $this->input->post('tahun', TRUE);
    	$bln = $this->input->post('bln', TRUE);
    	$bulan = $tahun."-".$bln."-";
    	$data['id_tahun']=$tahun;
    	$data['bln']=$bulan; 
    	$id_ta=all("tahun_akademik", "tahun2", $tahun, "id_tahun");
    	if (($tahun != "") && ($bulan != "")){
    		$ar_div = array('status_aktif' => "on");
	    	$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
	    	foreach ($data['divisi'] as $div) {
	    		$idsekolah=$div->id_sekolah;
	    		//pendapatan laba rugi
	    		$where=array('id_sekolah =' => $idsekolah, 'akun.id_akun like '=>'4.%');
				$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
				foreach ($data['akun'] as $a){
					//sub akun
					$nominall=0;
					$ar_pndpt = array('id_sub_akun like' => "4.%");
		    		$data['subakun'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_pndpt, "nama_sub_akun", "asc");
					foreach ($data['subakun'] as $sa) { 
						if ($sa->id_sub_akun==$a->id_sub_akun){
							$nominall += $this->m_models->saldo_jurnal($a->id_akun, $id_ta, $idsekolah, $bulan); 
							$data['nominal'][$sa->id_sub_akun]=$nominal;
						}
					} 
				}


				//beban laba rugi
				$arwheres1 = array('id_sekolah =' => $idsekolah, 'akun.id_akun like '=>'5.%');
				$data['akun1'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $arwheres1, "akun.id_akun", "asc");
				foreach ($data['akun1'] as $a1){
					//sub akun
					$nominal1=0;
					$ar_beban = array('id_sub_akun like' => "5.%");
		    		$data['subakun1'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_beban, "nama_sub_akun", "asc");
					foreach ($data['subakun1'] as $sa1) { 
						if ($sa1->id_sub_akun==$a1->id_sub_akun){ 
							$nominal1 += $this->m_models->saldo_jurnal($a1->id_akun, $id_ta, $idsekolah, $bulan);
							$data['nominal1'][$sa->id_sub_akun]=$nominal1;
						}
					}
				}
			}
		}


	    $this->load->view('laporan_keuangan/resume_lap_aktivitas', $data); 
	   	$this->load->view('template/footer');
  	} 

  	
  	function printresumelabarugi(){ 
		$tahun = $this->uri->segment(3);
		$bulan = $this->uri->segment(4);
		$data['bln']=$bulan;
		$data['id_tahun']=$tahun;

    	if (($tahun != "") && ($bulan != "")){
    		$ar_div = array('status_aktif' => "on");
	    	$data['divisi'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
	    	foreach ($data['divisi'] as $div) {
	    		$idsekolah=$div->id_sekolah;
	    		//pendapatan laba rugi
	    		$where=array('id_sekolah =' => $idsekolah, 'akun.id_akun like '=>'4.%');
				$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
				foreach ($data['akun'] as $a){
					//sub akun
					$nominall=0;
					$ar_pndpt = array('id_sub_akun like' => "4.%");
		    		$data['subakun'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_pndpt, "nama_sub_akun", "asc");
					foreach ($data['subakun'] as $sa) { 
						if ($sa->id_sub_akun==$a->id_sub_akun){
							$nominall += $this->m_models->saldo_jurnal($a->id_akun, $id_ta, $idsekolah, $bulan); 
							$data['nominal'][$sa->id_sub_akun]=$nominal;
						}
					} 
				}


				//beban laba rugi
				$arwheres1 = array('id_sekolah =' => $idsekolah, 'akun.id_akun like '=>'5.%');
				$data['akun1'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $arwheres1, "akun.id_akun", "asc");
				foreach ($data['akun1'] as $a1){
					//sub akun
					$nominal1=0;
					$ar_beban = array('id_sub_akun like' => "5.%");
		    		$data['subakun1'] = $this->m_models->getTabelwhere("*", "sub_akun", $ar_beban, "nama_sub_akun", "asc");
					foreach ($data['subakun1'] as $sa1) { 
						if ($sa1->id_sub_akun==$a1->id_sub_akun){ 
							$nominal1 += $this->m_models->saldo_jurnal($a1->id_akun, $id_ta, $idsekolah, $bulan);
							$data['nominal1'][$sa->id_sub_akun]=$nominal1;
						}
					}
				}
			}  
		}

	    $this->load->library('pdf');
		$this->pdf->setPaper("A4", 'portrait');
		$this->pdf->load_view('laporan_keuangan/printresumelabarugi', $data); 
		$this->pdf->render();
		$this->pdf->stream("Resume_Lap_Aktivitas.pdf", array('Attachment'=>0));
  	} 

  	#mutasi kas dari kas penerimaan dari wali santri ke bagian kas pusat
  	function mutasi_kas(){ 
	   	$this->load->view('template/header');
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $data['id_sekolah']=$nm_sekolah;
	    $data['nm_sekolah']=all("sekolah", "id_sekolah", $id_sekolah, "nama");
	    $where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like '=>'1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");

        $akun1 = $this->input->post('akun1');
        $akun2 = $this->input->post('akun2');
        $urai = $this->input->post('uraian');
        $pemohon = $this->input->post('pemohon');
        $nom = $this->input->post('nominal');
        $jenjang = $id_sekolah;
        $tgl = date_db($this->input->post('tgl'));
        $uraian = $urai."_".$pemohon;

        $jnom=substr_count($nom, ".");
		if ($jnom==0){
			$nominal=$nom;
		} else {
			$nominal=str_replace(".","",$nom);
		}
        $hariini=date("Y-m-d");
        $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
        foreach ($data['tahun'] as $tahun){ 
			if (($akun1 != "") && ($akun2 != "") && ($nominal != "")){
				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$tanggal=date("Y-m-d");
				/*$no_jurnal=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => "0", 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $nominal, 'id_sekolah' => $id_sekolah,'approve1' => "Proses",'approve2' => "Proses",'approve3' => "Proses",'asal' => "mutasi kas", 'id_tahun'=>$tahun->id_tahun, 'nrp'=> $nrp); $simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal"); */

				$command="$tgl|$akun1|$uraian|$nominal|$akun2|$id_sekolah|$tahun->id_tahun|$nrp";
				$ar_mutasi=array('tgl'=>$tgl, 'nominal'=>$nominal, 'tgl_input'=>$hariini, 'user_input'=>$nrp, 'command'=>$command, 'keterangan'=>"Penerimaan Kas", 'status'=>'Proses');
				if ($this->m_models->save_data($ar_mutasi, "k_mutasi_kas") == TRUE) {
					$this->session->set_flashdata('sukses', 'Data berhasil diajukan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
        }
	    $this->load->view('laporan_keuangan/mutasi_kas_penerimaan', $data); 
	   	$this->load->view('template/footer');
  	} 

  	function app_mutasi_kas(){
	   	$this->load->view('template/header');
	    $e=explode("+", $this->session->userdata['hak_akses']);
	    $nrp_user=$this->session->userdata['nrp'];

	    $data['hak_akses'] = $this->m_models->getAll("tb_pengguna where hak_akses like '%130%' and activity='on'");
	   	$nrp_= $data['hak_akses'][0]->nrp;

	    if ($e[0]=="130"){
	    	$ar_mutasi = array('status' => "Proses", 'user_input !='=>$nrp_user);
	    } else { 
	    	$ar_mutasi = array('status' => "Proses", 'user_input ='=>$nrp_);
	    }
		$data['mutasi_kas'] = $this->m_models->getTabelwhere("*", "k_mutasi_kas", $ar_mutasi, "tgl", "asc");


		$id_mutasi = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");
		if (($id_mutasi != "") && ($ket != "")){
			$ar_app=array('status' => $ket, 'tgl_approve'=>$hariini, 'user_approve'=>$nrp_user);
			$data['update_data'] = $this->m_models->update_data($id_mutasi, "id_mutasi", $ar_app, "k_mutasi_kas");
			if ($ket=="Approve"){
        		$data['mutasi'] = $this->m_models->getwhere("*", "k_mutasi_kas", "id_mutasi", $id_mutasi, "tgl", "asc");
        		$ex=explode("|", $data['mutasi'][0]->command);
        		$tgl=$ex[0];
        		$akun1=$ex[1];
        		$uraian=$ex[2];
        		$nominal=$ex[3];
        		$akun2=$ex[4];
        		$id_sekolah=$ex[5];
        		$tahun=$ex[6];
        		$nrp=$ex[7];
        		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
        		$no_jurnal=array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => "0", 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $nominal, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "mutasi kas", 'id_tahun'=>$tahun, 'nrp'=> $nrp); 
        		$simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal");
				redirect('lap_keuangan/app_mutasi_kas');
			}
		}

	    $this->load->view('laporan_keuangan/approval_mutasi_kas', $data); 
	   	$this->load->view('template/footer');
  	} 

  	function hapus_jurnal(){
	   	$this->load->view('template/header');
	   	$no_transaksi = $this->input->post('no_transaksi', TRUE);
	   	if ($no_transaksi != ""){
	   		$arjurnal = array("no_transaksi"=>$no_transaksi);
			$data['jurnal']= $this->m_models->getTabelwhere("*", "jurnal", $arjurnal, "tgl", "asc");
			foreach ($data['jurnal'] as $j) {
				$akun=$j->akun1;
				$arwherep1 = array('akun.id_akun =' => $akun);
		        $data['akunp1'] = $this->m_models->getJoin1where("akun.*, rules_akun.debet, rules_akun.kredit, rules_akun.normal", "akun", "rules_akun", "rules_akun.id_akun=akun.id_akun",$arwherep1, "akun.id_akun", "asc");
		        foreach ($data['akunp1'] as $akunp1){
		        	$data['nm_akun']=$akunp1->nama_akun;
		        	$data['id_akun']=$akunp1->id_akun;
		        	$data['t1'] = $akunp1->debet;
		            $data['t2'] = $akunp1->kredit;
		            $data['normal'] = $akunp1->normal;
		        }
			}
	   	}
	    $this->load->view('laporan_keuangan/hapus_jurnal', $data); 
	   	$this->load->view('template/footer');
  	} 

  	public function app_hapus_jurnal(){
		$nrp=$this->session->userdata['nrp'];
		$id_jab_app=all("pegawai", "nrp", $nrp, "id_jabatan");
		$hak_akses=$this->m_models->getSession($nrp, "id_jabatan");

		$no_transaksi = $this->input->post('no_transaksi');
		$alasan = $this->input->post('alasan');

		if(($no_transaksi != "") && ($alasan != "")){
			$ar = array('no_transaksi' => $no_transaksi);
	    	$data['jurnal'] = $this->m_models->getTabelwhere("*", "jurnal", $ar, "tgl", "asc");

			$no_jurnal=array('tgl' => $data['jurnal'][0]->tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $data['jurnal'][0]->akun1, 'uraian1' => $data['jurnal'][0]->uraian1, 'debet1' => $data['jurnal'][0]->debet1, 'kredit1' => $data['jurnal'][0]->kredit1, 'akun2' => $data['jurnal'][0]->akun2, 'uraian2' => $data['jurnal'][0]->uraian2, 'debet2' => $data['jurnal'][0]->debet2, 'kredit2' => $data['jurnal'][0]->kredit2, 'id_sekolah' => $data['jurnal'][0]->id_sekolah,'asal' => $data['jurnal'][0]->asal, 'id_tahun'=>$data['jurnal'][0]->id_tahun, 'nrp'=> $data['jurnal'][0]->nrp, 'keterangan'=>$data['jurnal'][0]->keterangan, 'alasan'=>$alasan, 'nrp_hapus'=>$nrp);
			$simpan=$this->m_models->save_data($no_jurnal, "k_hapus_jurnal");

			$hapus=$this->m_models->delete_data($no_transaksi, "no_transaksi", "jurnal");
		}


		if ($hapus == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}

		redirect('laporan_keuangan/hapus_jurnal');
	}



}