<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Keuangan extends CI_Controller {
	function __construct(){
		error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
		$this->load->library(array("PHPExcel","PHPExcel/IOFactory.php"));
	}
	
	public function input_daftar_pos(){
		$this->load->view('template/header');
		$this->load->view('keuangan/i_daftar_pos');
		$this->load->view('template/footer');
	}

	public function simpan_daftar_pos(){
		$nama_pos = $this->input->post('nama_pos', TRUE);
		$ket = $this->input->post('ket', TRUE);
		$jenis = $this->input->post('jenis', TRUE);
		$id_akun = $this->input->post('id_akun', TRUE);

		$ar_pos = array('nama_pos' => $nama_pos, 'keterangan' => $ket, 'jenis' => $jenis, 'id_akun'=>$id_akun);
		if($this->m_models->save_data($ar_pos, "k_daftar_pos") == TRUE){
	    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
    	}
		redirect('keuangan/master_pembayaran'); 
		//redirect('keuangan/input_daftar_pos');
	}

	public function daftar_pos(){
		$this->load->view('template/header');
		$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_ps_daftarpos", "id_pos", "asc");
		$this->load->view('keuangan/l_daftar_pos', $data);
		$this->load->view('template/footer');
	}

	
	public function input_jenis_pembayaran(){
		$this->load->view('template/header');
		//$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_daftar_pos", "nama_pos", "asc");
		$data['daftar_pos'] = $this->m_models->getSpesific("k_daftar_pos", "id_daftar_pos not in (select pos_utama from k_rincian_pos)");

		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    	$ar = array('status =' => 'on');
	        $data['kategri'] = $this->m_models->getTabelwhere("*", "k_kategori_pembayaran", $ar, "kategori", "asc");
	    }

		$this->load->view('keuangan/i_jenis_pembayaran', $data);
		$this->load->view('template/footer');
	}

	public function simpan_jenis_pembayaran(){
		$ta = $this->input->post('ta', TRUE);
		$pos = $this->input->post('pos', TRUE);
		$kelas = $this->input->post('kelas', TRUE);
		$nom = $this->input->post('nominal', TRUE);
		$jkls = $this->input->post('jkls', TRUE);
		$no = $this->input->post('no', TRUE);
		$id_kategori = $this->input->post('id_kategori', TRUE);
		$periode = $this->input->post('periode', TRUE); 
		for ($i=0; $i<=$jkls; $i++){
			if ($kelas[$i] != ""){
				for ($j=0; $j < $no; $j++) { 
					$idkategori=$id_kategori[$j];
					$nominal = db_nominal($this->input->post('nominal'.$idkategori, TRUE));
					$ar_pos = array('id_daftar_pos' => $pos, 'id_tahun' => $ta, 'id_kelas' => $kelas[$i], 'nominal'=>$nominal, 'status'=>'on', 'id_kategori'=>$idkategori, 'periode'=>$periode);
					$simpan = $this->m_models->save_data($ar_pos, "k_daftarjenis_pembayaran");
				}
			}
		}
		if($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('keuangan/master_pembayaran'); 
		//redirect('keuangan/input_jenis_pembayaran'); 
	}

	public function cekkelas(){
		$ta=$this->input->get('ta', TRUE);
		$data['kelas'] = $this->m_models->getwhere("*", "tingkatan_kelas", "status_aktif", 'Aktif', "id_jenjang", "asc");
		$data['jkelas'] = $this->m_models->getRowsWhere("*", "tingkatan_kelas", "status_aktif", 'Aktif', "id_jenjang", "asc");
		$this->load->view('keuangan/cekkelas', $data);
	}

	public function daftar_jenis_pembayaran(){
		$this->load->view('template/header');

		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    }

		$thn = $this->input->post('tahun', TRUE);
		if ($thn != ""){
			$arwherep1 = array('id_tahun =' => $thn);
	        $data['jenis_bayar'] = $this->m_models->getTabelwhere("*", "k_daftarjenis_pembayaran", $arwherep1, "id_daftar_pos", "asc");
		}

		$this->load->view('keuangan/l_jenis_pembayaran', $data);
		$this->load->view('template/footer');
	}

	
	public function input_kategori_pembayaran(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$kategori = $this->input->post('kategori', TRUE);
		$ket = $this->input->post('ket', TRUE);
		if (($kategori != "")){
			$ar_pos = array('kategori' => $kategori, 'keterangan' => $ket, 'status' => 'on', 'nrp'=>$nrp);
			if($this->m_models->save_data($ar_pos, "k_kategori_pembayaran") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('keuangan/master_pembayaran'); 
			//redirect('keuangan/input_kategori_pembayaran'); 
		} 

		$data['kategori']=$this->m_models->getTabelOrder("*", "k_kategori_pembayaran", "kategori", "asc");

		$this->load->view('keuangan/i_kategori_pemb', $data);
		$this->load->view('template/footer');
	}

	public function update_kategoripemb(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_kategori = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_kategori != ""){
			$j_off= array('status'=>$status);
			if ($this->m_models->update_data($id_kategori, "id_kategori", $j_off, "k_kategori_pembayaran") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('keuangan/master_pembayaran'); 
			//redirect('keuangan/input_kategori_pembayaran');
		}
		$this->load->view('template/footer');
	}

	public function input_rincian_pos(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$pos = $this->input->post('pos', TRUE);
		$rincian = $this->input->post('rincian', TRUE);

		$j=$this->m_models->getRows("k_daftar_pos");
		$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
		$id_tahun=$data['tahun'][0]->id_tahun; 
		if ($j != 0){ 
			for ($i=0; $i <= $j ; $i++) {  
				$rinci=$rincian[$i]; 
				if ($rinci != ""){
					$ar_pos = array('pos_utama' => $pos, 'pos_rincian' => $rinci, 'status' => 'on', 'id_tahun'=>$id_tahun);
					if($this->m_models->save_data($ar_pos, "k_rincian_pos") == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				    }else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}
			redirect('keuangan/master_pembayaran'); 
			//redirect('keuangan/input_rincian_pos'); 
		}
		
		$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_daftar_pos", "nama_pos", "asc");

		$this->load->view('keuangan/i_rincian_pos', $data);
		$this->load->view('template/footer');
	}

	
	public function master_pembayaran(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		//input daftar pos
		$ar_akn = array('akun.id_akun like ' => '4.%');
	    $data['akun'] = $this->m_models->getJoin1where("*", "akun", "sub_akun", "sub_akun.id_sub_akun=akun.id_sub_akun", $ar_akn, "id_akun", "asc");

		//jenis pembayaran
		$data['daftar_pos'] = $this->m_models->getSpesific("k_daftar_pos", "id_daftar_pos not in (select pos_utama from k_rincian_pos)");
		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    	$ar = array('status =' => 'on');
	        $data['kategri'] = $this->m_models->getTabelwhere("*", "k_kategori_pembayaran", $ar, "kategori", "asc");
	    }

		//kategori
		$data['kategori']=$this->m_models->getTabelOrder("*", "k_kategori_pembayaran", "kategori", "asc");

		//rincian pos
		$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_daftar_pos", "nama_pos", "asc");

		$this->load->view('keuangan/master_pembayaran', $data);
		$this->load->view('template/footer');
	}


	//kategori siswa
	public function kategori_siswa(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$ar = array('status_aktif =' => 'on', 'kategori'=>'Sekolah');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "id_sekolah", "asc");

		$jenjang=$this->input->post('jenjang', TRUE);
		$no=$this->input->post('no', TRUE);
		$id_siswa=$this->input->post('id_siswa', TRUE);
		if (($jenjang != "") && ($no != "")){
			for ($i=0; $i <= $no; $i++){ 
				$idsiswa = $id_siswa[$i];
				$kategori=$this->input->post('kategori'.$idsiswa, TRUE);
				
				$j_up= array('id_kategori'=>$kategori);
				$updte=$this->m_models->update_data($idsiswa, "id_siswa", $j_up, "siswa_".$jenjang);
			}

			if ($updte == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('keuangan/kategori_siswa');
		}

		$this->load->view('keuangan/kategori_siswa', $data);
		$this->load->view('template/footer');
	}

	public function ceksekolah(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('id_sekolah', TRUE);
		$kl=$this->input->get('kelas', TRUE);
		$data['id_sekolah']=$id_sekolah;
		$ex=explode("-", $kl);
		$idsekolah=$ex[0];
		$data['kls']=$ex[1]; 
		$id_tahun=ta_berjalan(); 

		$ar = array('id_sekolah'=>$id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar, "nama_kelas", "asc");

	    if ($kl != ""){ 
	    	$jnjg=db_jenjang($idsekolah); 
	    	$data['jenjang']=$jnjg;
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$ex[1], $rbel.".id_tahun"=>$id_tahun, $rbel.".id_sekolah"=>$idsekolah);
			//$ar_r = array('status_aktif =' => 'Aktif');
		    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

		    $ar_kat = array('status'=>'on');
		    $data['kategori'] = $this->m_models->getTabelwhere("*", "k_kategori_pembayaran", $ar_kat, "id_kategori", "asc");
	    }

		$this->load->view('keuangan/ceksekolah', $data);
	}



	public function transaksi_pembayaran(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		
		$ar = array('status_aktif =' => 'on', 'kategori'=>'Sekolah');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "id_sekolah", "asc");
		
		$this->load->view('keuangan/transaksi_pembayaran_siswa', $data);
		$this->load->view('template/footer');
	}

	public function ceksiswa(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('jenjang', TRUE);
		$data['id_sekolah']=$id_sekolah;
		$jnjg=db_jenjang($id_sekolah); 
		$data['id_tahun']=ta_berjalan();


		$ar = array('status_aktif =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
	    $data['siswa'] = $this->m_models->getTabelwhere("*", "siswa_".$jnjg, $ar, "nama_lengkap", "asc");

		$this->load->view('keuangan/ceksiswa', $data);
	}


	public function cekdtsiswa(){
		$this->load->view('template/js');
		$idsiswa=$this->input->get("idsiswa", TRUE); 
		$data['idsiswa']=$idsiswa;
		$jenjang=db_siswa($idsiswa);
		$data['nis']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nis");
		$data['nama']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nama_lengkap");
		$data['status']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "status_aktif");
		$data['kelas']=kelas($jenjang, $idsiswa, ta_berjalan());
		$data['id_tahun']=ta_berjalan();
		$data['wali']=nama_wali($idsiswa);
		$data['hp_wali']=hp_wali($idsiswa);
		$this->load->view('keuangan/ceksiswa', $data);

		//tampilan pembayaran siswa
		$id_sekolah = substr($idsiswa,0,3);
		$jenjang=db_jenjang($id_sekolah);
		$ar = array('id_siswa =' => $idsiswa);
	    $data['rombel'] = $this->m_models->getTabelwhere("*", "rombongan_belajar_".$jenjang, $ar, "id_tahun", "asc");
	    $data['kelas']=$data['rombel'][0]->id_kelas;
	    foreach ($data['rombel'] as $r){
	    	$id_kategori_siswa=all("siswa_".$jenjang, "id_siswa", $idsiswa, "id_kategori");
	    	$data['id_kategori_siswa']=$id_kategori_siswa;

	    	$ar_pos=array('jenis =' => 'Penerimaan');
	   		$data['daftarpos'] = $this->m_models->getTabelwhere("*", "k_daftar_pos", $ar_pos, "nama_pos", "asc"); 

	    	//kategori bebas
	    	$ar_jp = array('id_kelas =' => $r->id_kelas, 'id_tahun'=>$r->id_tahun, 'periode'=>'Bebas', 'id_kategori'=>$id_kategori_siswa);
	   		$data['j_pembbebas'][$r->id_rombongan] = $this->m_models->getTabelwhere("*", "k_daftarjenis_pembayaran", $ar_jp, "id_tahun", "asc");
	    	$data['j_pemb_bebas'] = $this->m_models->getTabelwhere("*", "k_daftarjenis_pembayaran", $ar_jp, "id_tahun", "asc");
	    	foreach ($data['j_pemb_bebas'] as $jpb){
		    	$ar_rp = array('pos_rincian =' => $jpb->id_daftar_pos, 'id_tahun'=>$r->id_tahun);
		    	$j_rincian = $this->m_models->getRowsAWhere("*", "k_rincian_pos", $ar_rp, "pos_rincian", "asc");
		    	if ($j_rincian != 0){ 
		    		$data['pos'] = $this->m_models->getAll(k_daftar_pos);
		    		$data['nominal'][$jpb->id_daftar_pos]=0;
		    		foreach ($data['pos'] as $p){
			    		$data['rincian'] = $this->m_models->getTabelwhere("*", "k_rincian_pos", $ar_rp, "pos_rincian", "asc");
			    		//foreach ($data['rincian'] as $r_pos){
			    			$pos_utama=$data['rincian'][0]->pos_utama;
			    			if ($p->id_daftar_pos==$pos_utama){
			    				$nominal += $jpb->nominal; 
			    				$data['nominal'][$jpb->id_daftar_pos] = $nominal; 
			    				$data['nominal_pos'][$pos_utama] = $nominal; 
			    				$data['nm_pos'][$pos_utama]=all("k_daftar_pos", "id_daftar_pos", $data[rincian][0]->pos_utama, "nama_pos");

			    				//pembayaran tagihan siswa
			    				$ar_r = array('pos_rincian =' => $jpb->id_daftar_pos, 'id_tahun'=>$r->id_tahun, 'pos_utama'=>$pos_utama);
		    					$data['rincian_pos'] = $this->m_models->getTabelwhere("*", "k_rincian_pos", $ar_r, "pos_rincian", "asc");
					    		foreach ($data['rincian_pos'] as $rinci) {
					    			$ar_pemb1=array('id_siswa' => $idsiswa,'id_tahun'=>$r->id_tahun, 'id_daftar_pos'=> $rinci->pos_rincian);
						    		//$data[pemb_siswa]=$this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_pemb, "id_pemb_siswa", "asc");
									$data['pemb_siswa1']= $this->m_models->getSpesific("k_pembayaran_siswa", "id_daftar_pos in (select pos_rincian from k_rincian_pos where pos_utama='$pos_utama' and pos_rincian='$jpb->id_daftar_pos') and id_daftar_pos='$rinci->pos_rincian' and id_tahun='$r->id_tahun' and id_siswa=$idsiswa order by id_pemb_siswa");
						    		foreach ($data['pemb_siswa1'] as $ps1){
						    			$nominal_ps1 += $ps1->nominal; 
						    			$data['nominal_ps'][$pos_utama]=$nominal_ps1;
						    		}
					    		}
			    			}
			    		//}
		    		} 
		    		$data['nominal'][$jpb->id_daftar_pos] = $nominal;
		    	} else { 
		    		$data['nominal'][$jpb->id_daftar_pos] = $jpb->nominal;
		    		$data['nominal_pos'][$jpb->id_daftar_pos] = $jpb->nominal;
		    		$data['nm_pos'][$jpb->id_daftar_pos]=all("k_daftar_pos", "id_daftar_pos", $jpb->id_daftar_pos, "nama_pos");

		    		
		    		//pembayaran tagihan siswa
			    	$ar_pemb=array('id_siswa' => $idsiswa,'id_tahun'=>$r->id_tahun, 'id_daftar_pos'=> $jpb->id_daftar_pos);
		    		$data['pemb_siswa']=$this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "asc");
		    		foreach ($data['pemb_siswa'] as $ps) {
		    			$nominal_ps += $ps->nominal;
		    			$data['nominal_ps'][$jpb->id_daftar_pos]=$nominal_ps;
		    		}
		    	}
	    	}

	    	//bulanan
	    	$ar_jpb = array('id_kelas =' => $r->id_kelas, 'id_tahun'=>$r->id_tahun, 'periode'=>'Bulanan', 'id_kategori'=>$id_kategori_siswa);
	   		$data['j_pembbulanan'][$r->id_rombongan] = $this->m_models->getTabelwhere("*", "k_daftarjenis_pembayaran", $ar_jpb, "id_tahun", "asc");
	    	$data['j_pemb_bulanan'] = $this->m_models->getTabelwhere("*", "k_daftarjenis_pembayaran", $ar_jpb, "id_tahun", "asc");
	    	foreach ($data['j_pemb_bulanan'] as $jpbln){
		    	$ar_rpb = array('pos_rincian =' => $jpbln->id_daftar_pos, 'id_tahun'=>$r->id_tahun);
		    	$j_rincianb = $this->m_models->getRowsAWhere("*", "k_rincian_pos", $ar_rpb, "pos_rincian", "asc");
		    	if ($j_rincianb != 0){ 
		    		$data['posb'] = $this->m_models->getAll(k_daftar_pos);
		    		$data['nominal_bln'][$jpbln->id_daftar_pos]=0;
		    		foreach ($data['posb'] as $p_bln){
			    		$data['rincian_bln'] = $this->m_models->getTabelwhere("*", "k_rincian_pos", $ar_rpb, "pos_rincian", "asc");
			    		foreach ($data['rincian_bln'] as $r_pos_bln){
			    			if ($p_bln->id_daftar_pos==$r_pos_bln->pos_utama){
			    				$data['nominal_bln'][$jpbln->id_daftar_pos] += $jpbln->nominal;
			    			}
			    		}
		    		}
		    	} else {
		    		$data['nominal_bln'][$jpbln->id_daftar_pos] = $jpbln->nominal;
		    	} 

		    	//mengecek apakah sudah dilakukan pembayaran atau belum
		    	$data['jml_pembayaran'][$jpbln->id_daftar_pos]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jpbln->id_daftar_pos, $jpbln->periode, '');
		    	$data['sisa'][$jpbln->id_daftar_pos]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jpbln->id_daftar_pos, $jpbln->periode, '');

		    	
	    	}
	    }

	    //riwayat transaksi sebelumnya
	    $ar_ts = array('id_siswa =' => $idsiswa, 'id_tahun'=>$r->id_tahun);
    	$data['riwayat_transaksi'] = $this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_ts, "tgl_bayar", "desc");

	    //transaksi saat ini
		$nrp=$this->session->userdata['nrp']; 
	    $idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $where=array('id_sekolah =' => $idsekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");

		$this->load->view('keuangan/trans_pembayaran_siswa', $data);

	}

	public function simpan_transaksi(){
		$petugas=$this->session->userdata['nrp']; 
		$tgl = date_db($this->input->post('tgl', TRUE));
		$akun1 = $this->input->post('akun1', TRUE);
		$no = $this->input->post('no', TRUE);
		$id_siswa = $this->input->post('id_siswa', TRUE);
		$id_tahun = $this->input->post('id_tahun', TRUE);
		$id_daftar_pos = $this->input->post('id_daftar_pos', TRUE);
		$id_kategori_siswa = $this->input->post('id_kategori_siswa', TRUE); 
		$tombol = $this->input->post('tombol', TRUE); 
		$id_sekolah = substr($id_siswa,0,3);
		$tombol = $this->input->post('tombol', TRUE); 


		for ($i=0; $i <= $no; $i++){ 
			$id_daftarpos=$id_daftar_pos[$i]; 
			$periode = $this->input->post('periode'.$id_daftarpos, TRUE);
			$nominal = db_nominal($this->input->post('nominal'.$id_daftarpos, TRUE)); 
			$kelas=cekkls($id_siswa, $id_tahun);

	   		if ($periode=="Bebas"){
	   			$period=$tgl;
	   		} else if ($periode=="Bulanan"){
	   			$period=$tgl;
	   		}
	   		$nm_pos=all("k_daftar_pos", "id_daftar_pos", $id_daftarpos, "nama_pos");
	   		$jenjang=db_siswa($id_siswa);
	   		$nm_siswa=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
	   		$uraian="Pembayaran $nm_pos a.n $nm_siswa";

	   		if ($nominal != 0){
	   			//mengecek id daftar pos sesuai dg rinciannya
	   			$ar_rp = array('status =' => 'on', 'id_tahun'=>$id_tahun, 'pos_utama'=>$id_daftarpos);
		    	$j_rincian = $this->m_models->getRowsAWhere("*", "k_rincian_pos", $ar_rp, "pos_rincian", "asc");
		    	if ($j_rincian != 0){ 
		    		$data['rincian_pos'] = $this->m_models->getTabelwhere("*", "k_rincian_pos", $ar_rp, "pos_rincian", "asc");
		    		$nomi=0;
		    		foreach ($data['rincian_pos'] as $rp){
		    			$n++;
		    			$id_pos_rincian=$rp->pos_rincian; 
		    			if ($nomi <= 0){
		    				$ar_dp = array('id_kelas =' => $kelas, 'id_tahun'=>$id_tahun, 'periode'=>$periode, 'id_kategori'=>$id_kategori_siswa, 'id_daftar_pos'=>$id_pos_rincian, 'status'=>'on');
		   					$data['daftar_pos']= $this->m_models->getTabelwhere("*", "k_daftarjenis_pembayaran", $ar_dp, "id_daftar_pos", "asc");
		   					foreach ($data['daftar_pos'] as $dp){
		   						$nominal_tagihan=$dp->nominal;
		   						$nominal_pembayaran=cekpembayaransiswa($id_siswa, $id_tahun, $id_pos_rincian);
		   						#menghitung sisa nominal pembayaran
		   						$sisa_tagihan=$nominal_tagihan-$nominal_pembayaran;
		   						#mengecek apakah pembayaran yg telah dilakukan kurang dari tagihan atau tidak
		   						if ($sisa_tagihan > 0){
		   							#sisa pembayaran dikurangi dg nominal yg akan dilakukan pembayaran sekarang
		   							if ($n==1){
		   								$nomi=$sisa_tagihan-$nominal;
		   								$nomii = $nomi;
		   								$nom_byr = $nomii;
		   							} else {
		   								$nomii = $sisa_tagihan-abs($nomi);
		   								$nom_byr=abs($nomii);
		   							}
		   							
		   							#mengecek apakah pembayarannya sesuai dg tagihan atau tidak 
		   							if ($nomii <= 0){
		   								$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
							   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$sisa_tagihan, 'nrp_user'=>$petugas, 'id_daftar_pos'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
							   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

							   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$sisa_tagihan, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$sisa_tagihan, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
										//$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
		   							}  else {
		   								$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
							   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$nom_byr, 'nrp_user'=>$petugas, 'id_daftar_pos'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
							   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

							   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nom_byr, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nom_byr, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
										//$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
		   							}
		   						} else {
		   							if ($n==1){
		   								$nomi=$nominal_tagihan-$nominal;
		   								$nomii = $nomi;
		   								$nom_byr = $nomii;
		   							} else {
		   								$nomii = $nominal_tagihan-abs($nomi);
		   								$nom_byr=abs($nomii);
		   							}
		   							#mengecek apakah pembayarannya sesuai dg tagihan atau tidak 
		   							if ($nomii <= 0){
		   								$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
							   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$nominal_tagihan, 'nrp_user'=>$nrp, 'id_daftar_pos'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
							   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

							   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal_tagihan, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nominal_tagihan, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
										//$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
		   							}  else {
		   								$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
							   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$nom_byr, 'nrp_user'=>$petugas, 'id_daftar_pos'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
							   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

							   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nom_byr, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nom_byr, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
										//$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
		   							}
		   						}
		   					}
		    			}
		    		}
		    	} else if ($j_rincian==0){ 
		    		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
					$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$nominal, 'nrp_user'=>$petugas, 'id_daftar_pos'=>$id_daftarpos, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
					$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

					$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
					//$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
		    	}
	   		} 		
		}

		if ($tombol=="simpan"){
			if($simpan == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/transaksi_pembayaran');
		} else if ($tombol=="simpanprint"){
			redirect('keuangan/print_bukti_transaksi/'.$id_siswa."/".$tgl."/".$petugas);
		}
	}

	#print bukti transaksi
	public function print_bukti_transaksi(){
		$id_siswa = $this->uri->segment(3);
		$tgl = $this->uri->segment(4);
		$petugas = $this->uri->segment(5);
		$nrp=$this->session->userdata['nrp']; 
		$data['id_sekolah']=$this->m_models->getSession($nrp, "id_sekolah");

		$ar_ps = array('id_siswa =' => $id_siswa, 'tgl_bayar ='=>$tgl, 'nrp_user'=>$petugas);
		$data['pemb_siswa'] = $this->m_models->getTabelGroup("*", "k_pembayaran_siswa", $ar_ps, "pos_utama", "id_pemb_siswa", "asc");
		foreach ($data['pemb_siswa'] as $ps) {
			$arps = array('id_siswa =' => $id_siswa, 'tgl_bayar ='=>$tgl, 'nrp_user'=>$petugas, 'pos_utama'=>$ps->pos_utama);
			$data['pembsiswa'] = $this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $arps, "id_pemb_siswa", "asc");
		    $nominal=0;
		    foreach ($data['pembsiswa'] as $p){
		    	$nominal += $p->nominal;
		    	$data['nominal'][$ps->pos_utama] = $nominal;
		    	$data['nama_pos'][$ps->pos_utama] = $ps->pos_utama;
		    	$jml_total += $p->nominal;
		    }
		}
		$data['jml_total'] = $jml_total;
		   

	    $data['nama']=all("siswa_".db_siswa($id_siswa), "id_siswa", $id_siswa, "nama_lengkap");
		$data['nis']=all("siswa_".db_siswa($id_siswa), "id_siswa", $id_siswa, "nis");
		$id_kelas=all("rombongan_belajar_".db_siswa($id_siswa), "id_siswa", $id_siswa, "id_kelas");
		$data['kelas']=all("kelas", "id_kelas", $id_kelas, "nama_kelas");
		$data['status_siswa']=all("siswa_".db_siswa($id_siswa), "id_siswa", $id_siswa, "status_aktif");

		$data['metode']=all("akun", "id_akun", $data['pemb_siswa'][0]->sistem, "nama_akun");
		$data['petugas']=all("pegawai", "nrp", $data['pemb_siswa'][0]->nrp_user, "nama");
		$data['no_bukti']=$data['pemb_siswa'][0]->no_transaksi;
		$data['tgl_bayar']=$tgl;

		$this->load->view('keuangan/print_bukti_transaksi',$data);
		$this->load->library('pdf');
		//$this->pdf->setPaper("A4", 'portrait');
		$customPaper = array(0,0,912.0114899085,528.0066520523);
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('keuangan/print_bukti_transaksi', $data);
		$this->pdf->render();
		$this->pdf->stream("Laporan_Pembayaran_Siswa.pdf", array('Attachment'=>0));
	}



	# jenis pembayaran siswa
	public function jenis_pemb_siswa(){
		$this->load->view('template/header');
		$data['daftar_pos'] = $this->m_models->getTabelOrder("*", "k_daftar_pos", "nama_pos", "asc");

		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $data['thn_on']=ta_berjalan();

		$this->load->view('keuangan/jenis_pemb_siswa',$data);
		$this->load->view('template/footer');
	}

	public function cekkategori(){
		$this->load->view('template/head');
		$this->load->view('template/js');
		$kategori=$this->input->get('kategori', TRUE);
		$data['kategori']=$kategori; 
		$id_tahun=ta_berjalan();

		//jika kategori siswa memunculkan semua siswa yg masih on
		$ar_seklah = array('status_aktif =' => 'on', 'kategori ='=>'Sekolah');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_seklah, "nama", "asc");

		//kategori kelas
		$ar_kelas = array('id_tahun =' => $id_tahun, 'id_sekolah !='=>7);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar_kelas, "id_tingkatan_kelas", "asc");

		//kategori tingkat
		$ar_tingkat = array('status_aktif =' => 'Aktif', 'id_tp !='=>"8");
	    $data['tingkat'] = $this->m_models->getTabelwhere("*", "tingkatan_kelas", $ar_tingkat, "id_tp", "asc");

		$this->load->view('keuangan/cekkategori', $data);
	}

	//laporan pembayaran siswa
	public function lap_pembayaran(){
		$this->load->view('template/header');
		$ar = array('nama_akun not like' => '%PRS%', 'nama_akun not like ' => '%PPDB%');
		$ar_or = "(id_akun like '1.1.1%' or id_akun like '1.1.3.%')";
		$data['akun'] = $this->m_models->getTabelwhereOr("*", "akun", $ar, $ar_or, "id_akun", "asc");
		$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_daftar_pos", "nama_pos", "asc");

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE); 
		$metode = $this->input->post('metode', TRUE); 
		$jenis_pos = $this->input->post('jenis_pos', TRUE); 
		$data['dari']=$dari;
		$data['sampai']=$sampai;
		$data['metode']=$metode;
		$data['jenis_pos']=$jenis_pos;

		if (($dari != "") && ($sampai != "")){ 
			if (($metode == "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai);
			} else if (($metode != "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode);
			} else if (($metode != "all") && ($jenis_pos != "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode, 'id_daftar_pos'=>$jenis_pos);
			} else if (($metode == "all") && ($jenis_pos != "all")){ 
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'id_daftar_pos'=>$jenis_pos );
			}
			$data['pemb_siswa']=$this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "asc");

			$ar=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai);
			$data['byr_siswa']=$this->m_models->getAwhereGroup("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "tgl_bayar", "asc");
			foreach ($data['byr_siswa'] as $bs) {
				foreach ($data['pemb_siswa'] as $p) {
					if ($p->tgl_bayar == $bs->tgl_bayar){
						$data['nominal'][$bs->tgl_bayar] += $p->nominal;
						$data['tgl_bayar'][$bs->tgl_bayar] = $bs->tgl_bayar;
					}
				}
			}
				
		}


		$this->load->view('keuangan/lap_pemb_siswa',$data); 
		$this->load->view('template/footer');
	}

	public function download_lap_bayar_siswa(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$metode = $this->uri->segment(5);
		$jenis_pos = $this->uri->segment(6);

		$data['dari']=$dari;
		$data['sampai']=$sampai;
		$data['metode']=$metode;
		$data['jenis_pos']=$jenis_pos;

		if (($dari != "") && ($sampai != "")){ 
			if (($metode == "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai);
			} else if (($metode != "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode);
			} else if (($metode != "all") && ($jenis_pos != "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode, 'id_daftar_pos'=>$jenis_pos);
			} else if (($metode == "all") && ($jenis_pos != "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'id_daftar_pos'=>$jenis_pos );
			}
			$data['pemb_siswa']=$this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "asc");

			$ar=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai);
			$data['byr_siswa']=$this->m_models->getAwhereGroup("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "tgl_bayar", "asc");
			foreach ($data['byr_siswa'] as $bs) {
				foreach ($data['pemb_siswa'] as $p) {
					if ($p->tgl_bayar == $bs->tgl_bayar){
						$data['nominal'][$bs->tgl_bayar] += $p->nominal;
						$data['tgl_bayar'][$bs->tgl_bayar] = $bs->tgl_bayar;
					}
				}
			}
		}
		$this->load->view('keuangan/cetak_lap_pemb_siswa',$data); 

		$this->load->library('pdf');
		$this->pdf->setPaper("A4", 'portrait');
		$this->pdf->load_view('keuangan/cetak_lap_pemb_siswa', $data);
		$this->pdf->render();
		$this->pdf->stream("Laporan_Pembayaran_Siswa.pdf", array('Attachment'=>0));
	}


	// rekap pembayaran siswa
	public function rekap_pembayaran(){
		$this->load->view('template/header');
		$ar = array('nama_akun not like' => '%PRS%', 'nama_akun not like ' => '%PPDB%');
		$ar_or = "(id_akun like '1.1.1%' or id_akun like '1.1.3.%')";
		$data['akun'] = $this->m_models->getTabelwhereOr("*", "akun", $ar, $ar_or, "id_akun", "asc");
		$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_ps_daftarpos", "pos_utama", "asc");

		$dari = $this->input->post('dari', TRUE); 
		$sampai = $this->input->post('sampai', TRUE); 
		$metode = $this->input->post('metode', TRUE); 
		$jenis_pos = $this->input->post('jenis_pos', TRUE); 
		$data['dari']=$dari;
		$data['sampai']=$sampai;
		$data['metode']=$metode;
		$data['jenis_pos']=$jenis_pos;

		if (($dari != "") && ($sampai != "")){ 
			if (($metode == "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai);
			} else if (($metode != "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode);
			} else if (($metode != "all") && ($jenis_pos != "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode, 'pos_utama'=>$jenis_pos);
			} else if (($metode == "all") && ($jenis_pos != "all")){ 
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'pos_utama'=>$jenis_pos );
			}
			$data['pemb_siswa']=$this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "asc");

			foreach ($data['akun'] as $a){
				foreach ($data['daftar_pos'] as $dp){
					foreach ($data['pemb_siswa'] as $p){
						if ($p->sistem == $a->id_akun){
							if ($dp->pos_utama==$p->pos_utama){
								$no++;
								$ar=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$a->id_akun, 'pos_utama'=>$p->pos_utama);
								$data['j_trans'][$a->id_akun][$p->pos_utama]=$this->m_models->getRowsAWhere("*", "k_pembayaran_siswa", $ar, "tgl_bayar", "asc");
								$data['j_siswa'][$a->id_akun][$p->pos_utama]=$this->m_models->getAwhereGroupRows("*", "k_pembayaran_siswa", $ar, "id_siswa", "tgl_bayar", "asc");
								$data['nama_akun'][$a->id_akun][$p->pos_utama] = $a->nama_akun;
								$data['nama_pos'][$a->id_akun][$p->pos_utama] = all("k_ps_daftarpos", "pos_utama", $pos_utama, "nama_pos");
								$data['nominal'][$a->id_akun][$p->pos_utama] += $p->nominal;
							}
						}	
					}
				}
			}
		}

		$this->load->view('keuangan/rekap_pemb_siswa',$data); 
		$this->load->view('template/footer');
	}

	public function download_rekap_bayar_siswa(){
		$ar = array('nama_akun not like' => '%PRS%', 'nama_akun not like ' => '%PPDB%');
		$ar_or = "(id_akun like '1.1.1%' or id_akun like '1.1.3.%')";
		$data['akun'] = $this->m_models->getTabelwhereOr("*", "akun", $ar, $ar_or, "id_akun", "asc");
		$data['daftar_pos']=$this->m_models->getTabelOrder("*", "k_daftar_pos", "nama_pos", "asc");

		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$metode = $this->uri->segment(5);
		$jenis_pos = $this->uri->segment(6);

		$data['dari']=$dari;
		$data['sampai']=$sampai;
		$data['metode']=$metode;
		$data['jenis_pos']=$jenis_pos;

		if (($dari != "") && ($sampai != "")){ 
			if (($metode == "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai);
			} else if (($metode != "all") && ($jenis_pos == "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode);
			} else if (($metode != "all") && ($jenis_pos != "all")){
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$metode, 'id_daftar_pos'=>$jenis_pos);
			} else if (($metode == "all") && ($jenis_pos != "all")){ 
				$ar_pemb=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'id_daftar_pos'=>$jenis_pos );
			}
			$data['pemb_siswa']=$this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_pemb, "tgl_bayar", "asc");

			foreach ($data['akun'] as $a){
				foreach ($data['daftar_pos'] as $dp){
					foreach ($data['pemb_siswa'] as $p){
						if ($p->sistem == $a->id_akun){
							if ($dp->id_daftar_pos==$p->id_daftar_pos){
								$no++;
								$ar=array('tgl_bayar >=' => $dari,'tgl_bayar <='=>$sampai, 'sistem'=>$a->id_akun, 'id_daftar_pos'=>$p->id_daftar_pos);
								$data['j_trans'][$a->id_akun][$p->id_daftar_pos]=$this->m_models->getRowsAWhere("*", "k_pembayaran_siswa", $ar, "tgl_bayar", "asc");
								$data['j_siswa'][$a->id_akun][$p->id_daftar_pos]=$this->m_models->getAwhereGroupRows("*", "k_pembayaran_siswa", $ar, "id_siswa", "tgl_bayar", "asc");
								$data['nama_akun'][$a->id_akun][$p->id_daftar_pos] = $a->nama_akun;
								$data['nama_pos'][$a->id_akun][$p->id_daftar_pos] = all("k_daftar_pos", "id_daftar_pos", $id_daftar_pos, "nama_pos");
								$data['nominal'][$a->id_akun][$p->id_daftar_pos] += $p->nominal;
							}
						}	
					}
				}
			}
		}
		$this->load->view('keuangan/cetak_rekap_bayar_siswa',$data); 
		$this->load->library('pdf');
		$this->pdf->setPaper("A4", 'portrait');
		$this->pdf->load_view('keuangan/cetak_rekap_bayar_siswa', $data);
		$this->pdf->render();
		$this->pdf->stream("Laporan_Pembayaran_Siswa.pdf", array('Attachment'=>0));
	}

	//data tunggakan pembayaran siswa
	public function data_tunggakan(){
		$this->load->view('template/header');
		$data['thn_akademik']=$this->m_models->getTabelOrder("*", "tahun_akademik", "id_tahun", "desc");
		$data['thn_on']=ta_berjalan();
		$ta_awal = $this->input->post('ta_awal', TRUE); 
		$ta_akhir = $this->input->post('ta_akhir', TRUE); 
		$bln = $this->input->post('bln', TRUE);  
		$ex=explode("-", $this->input->post('idsekolah', TRUE));  
		$ta = $ex[0];
		$idsekolah = $ex[1];
		$kelas = $this->input->post('kelas', TRUE);  
		$data['ta_awal']=all("tahun_akademik", "id_tahun", $ta_awal, "periode");
		$data['ta_akhir']=all("tahun_akademik", "id_tahun", $ta_akhir, "periode"); 
		$data['bulan']=$bln;
		$data['kelas']=$kelas;
		$data['id_sekolah']=$idsekolah;
		$data['taawal']=$ta_awal;
		$data['taakhir']=$ta_akhir;

		if (($ta_awal != "") && ($ta_akhir != "") && ($bln != "") && ($idsekolah != "") && ($kelas != "")){
	    	$jenjang=db_jenjang($idsekolah); 
			$rbel="rombongan_belajar_".$jenjang;
			$sswa="siswa_".$jenjang;
		   /* $ar = array('id_siswa =' => $idsiswa, "rombongan_belajar_".$jenjang.".id_tahun"=>$id_tahun);
		    $data['rombel'] = $this->m_models->getJoin1where("kelas.id_kelas, id_tingkatan_kelas, rombongan_belajar_".$jenjang.".id_tahun", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $ar, "id_tingkatan_kelas", "asc");
		    $data['kelas']=$data['rombel'][0]->id_kelas;*/

		    $ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun >= "=>$ta_awal, $rbel.".id_tahun <="=>$ta_akhir, $rbel.".id_sekolah"=>$idsekolah);
		    $data['rombel'] = $this->m_models->getJoin2Awhere("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", "kelas", "kelas.id_kelas=".$rbel.".id_kelas", $ar_r, "nama_lengkap", "asc");
		    $tagihan_bebas=0;
		    foreach ($data['rombel'] as $r){ 
		    	$idsiswa=$r->id_siswa;
		    	$id_tahun=$r->id_tahun;

		    	//kategori bebas
		    	$ar_jp = array('id_kelas like ' => "%".$r->id_tingkatan_kelas."%", 'jenis'=>'Bebas');
		   		$data['j_pembbebas'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "pos_utama", "asc");
		   		$data['j_pbebas'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "asc");
		   		$nom_bebas=0; $jml_bayar_bebas=0; $nominal=0;
		   		foreach ($data['j_pbebas'] as $jp_bebas){
		   			$mk = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bebas', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bebas->pos_utama);
			   		$data['mkhusus'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
			   		$jkhusus = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
			   		if ($jkhusus != 0){
			   			foreach ($data['mkhusus'] as $jsb){
					   		$nom_bebas += $jsb->nominal;
					   	}
			   		} else {
			   			$nominal += $jp_bebas->nominal;
			   			$nom_bebas=$nominal;
			   		}

		   			$nominal_bebas = $nom_bebas;
		   			$jml_bayar_bebas=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
		   			$data['tagihan_bebas'][$idsiswa]=$nominal_bebas-$jml_bayar_bebas;
		   		}

		    	//bulanan
		    	$ar_jpb = array('id_kelas like ' => "%".$r->id_tingkatan_kelas."%", 'jenis'=>'Bulanan');
		   		$data['j_pembbulanan'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "pos_utama", "asc");
		   		$data['j_pbulanan'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "asc");
		   		$nominalb=0; $nom_bulanan=0; $nombulanan=0; $jml_bayar_bulanan=0;
		   		foreach ($data['j_pbulanan'] as $jp_bulanan){
		   			$mkb = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bulanan', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bulanan->pos_utama);
			   		$data['mkhususb'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
			   		$jkhususb = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
			   		if ($jkhususb != 0){
			   			$nom_bulanan=0;
			   			foreach ($data['mkhususb'] as $jsbln){
				   			$nom_bulanan += $jsbln->nominal;
				   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] = $nom_bulanan;
				   		}
			   		} else { 
			   			$nominalb = $jp_bulanan->nominal;
			   			$nom_bulanan += $nominalb; 
			   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] = $nominalb;
			   		}
		   			$bln=date("m"); 
		   			$nombulanan = $nom_bulanan*cekblnBayaran($bln); 
		   			$data['tunggakan_bulanan'][$jp_bulanan->pos_utama] = $nombulanan;

			    	//mengecek apakah sudah dilakukan pembayaran atau belum
			    	$jml_bayar_bulanan=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
			    	$data['tagihan_bulanan'][$idsiswa] = $nombulanan - $jml_bayar_bulanan;
		    	}
		    }
		}

		$this->load->view('keuangan/tunggakan_siswa',$data); 
		$this->load->view('template/footer');
	}

	public function download_tunggakan_siswa(){
		$ta_awal = $this->uri->segment(3);
		$ta_akhir = $this->uri->segment(4);
		$idsekolah = $this->uri->segment(5);
		$kelas = $this->uri->segment(6);
		$bln = $this->uri->segment(7); 
		if (($ta_awal != "") && ($ta_akhir != "") && ($bln != "") && ($idsekolah != "") && ($kelas != "")){
	    	$jenjang=db_jenjang($idsekolah); 
			$rbel="rombongan_belajar_".$jenjang; 
			$sswa="siswa_".$jenjang;
		   /* $ar = array('id_siswa =' => $idsiswa, "rombongan_belajar_".$jenjang.".id_tahun"=>$id_tahun);
		    $data['rombel'] = $this->m_models->getJoin1where("kelas.id_kelas, id_tingkatan_kelas, rombongan_belajar_".$jenjang.".id_tahun", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $ar, "id_tingkatan_kelas", "asc");
		    $data['kelas']=$data['rombel'][0]->id_kelas;*/

		    $ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun >= "=>$ta_awal, $rbel.".id_tahun <="=>$ta_akhir, $rbel.".id_sekolah"=>$idsekolah);
		    $data['rombelajar'] = $this->m_models->getJoin2Awhere("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", "kelas", "kelas.id_kelas=".$rbel.".id_kelas", $ar_r, "nama_lengkap", "asc");
		    $tagihan_bebas=0;
		    foreach ($data['rombelajar'] as $rb){
		    	$idsiswa=$rb->id_siswa;
		    	//$data['idsiswa']=$idsiswa; echo "$idsiswa<br>";

				$jenjang=db_siswa($idsiswa);
				$data['nis'][$idsiswa]=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nis");
				$data['nama'][$idsiswa]=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nama_lengkap");
				$data['status'][$idsiswa]=all("siswa_".$jenjang, "id_siswa", $idsiswa, "status_aktif");
				$data['kelas'][$idsiswa]=kelas($jenjang, $idsiswa, ta_berjalan());
				$data['id_tahun'][$idsiswa]=ta_berjalan();
				$data['wali'][$idsiswa]=nama_wali($idsiswa);
				$data['hp_wali'][$idsiswa]=hp_wali($idsiswa);
				$this->load->view('keuangan/ceksiswa', $data);
				$id_tahun=ta_berjalan();

				//tampilan pembayaran siswa
				$id_sekolah = substr($idsiswa,0,3);
				$ar = array('id_siswa =' => $idsiswa, "rombongan_belajar_".$jenjang.".id_tahun"=>$id_tahun);
			    //$data['rombel'] = $this->m_models->getTabelwhere("*", "rombongan_belajar_".$jenjang, $ar, "id_tahun", "asc");
			    $data['rombel'] = $this->m_models->getJoin1where("kelas.id_kelas, id_tingkatan_kelas, rombongan_belajar_".$jenjang.".id_tahun", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $ar, "id_tingkatan_kelas", "asc");
			   // $data['kelas']=$data['rombel'][0]->id_kelas;
			    foreach ($data['rombel'] as $r){ 
			    	$nominal_khusus=all("k_ps_m_khusus", "id_siswa", $idsiswa, "nominal");

			    	//kategori bebas
			    	$ar_jp = array('id_kelas like ' => "%".$r->id_tingkatan_kelas."%", 'jenis'=>'Bebas');
			   		$data['j_pembbebas'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "pos_utama", "asc");
			   		$data['j_pbebas'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "asc");
			   		$nom_bebas=0; $nominal=0;
			   		foreach ($data['j_pbebas'] as $jp_bebas){
			   			$mk = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bebas', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bebas->pos_utama);
				   		$data['mkhusus'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
				   		$jkhusus = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
				   		if ($jkhusus != 0){
				   			foreach ($data['mkhusus'] as $jsb){
						   		$nom_bebas += $jsb->nominal;
						   	}
				   		} else {
				   			$nominal += $jp_bebas->nominal;
				   			$nom_bebas=$nominal;
				   		}

			   			$data['nominal_bebas'][$jp_bebas->pos_utama][$idsiswa] = $nom_bebas;

			   			$data['jml_bayar_bebas'][$jp_bebas->pos_utama][$idsiswa]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
				    	$data['sisa'][$jp_bebas->pos_utama][$idsiswa]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
			   		}
 

			    	//bulanan
			    	$ar_jpb = array('id_kelas like ' => "%".$r->id_tingkatan_kelas."%", 'jenis'=>'Bulanan');
			   		$data['j_pembbulanan'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "pos_utama", "asc");
			   		$data['j_pbulanan'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "asc");
			   		$nominalb=0; $nom_bulanan=0; $nombulanan=0;
			   		foreach ($data['j_pbulanan'] as $jp_bulanan){
			   			$mkb = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bulanan', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bulanan->pos_utama);
				   		$data['mkhususb'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
				   		$jkhususb = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
				   		if ($jkhususb != 0){
				   			$nom_bulanan=0;
				   			foreach ($data['mkhususb'] as $jsbln){
					   			$nom_bulanan += $jsbln->nominal;
					   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] = $nom_bulanan;
					   		}
				   		} else { 
				   			$nominalb = $jp_bulanan->nominal;
				   			$nom_bulanan += $nominalb; 
				   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] = $nom_bulanan;
				   		}
			   			$bln=date("m"); 
			   			$nombulanan = $data['nominal_bulanan'][$jp_bulanan->pos_utama]*cekblnBayaran($bln); 
			   			$data['tunggakan_bulanan'][$jp_bulanan->pos_utama][$idsiswa] = $nombulanan;

				    	//mengecek apakah sudah dilakukan pembayaran atau belum
				    	$data['jml_bayar_bulanan'][$jp_bulanan->pos_utama][$idsiswa]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
				    	//$data['sisa'][$jp_bebas->pos_utama]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
			    	}
			    }
			}
		}
		

		$this->load->view('keuangan/download_tunggakan_siswa',$data); 
		/*$this->load->library('pdf');
		//$this->pdf->setPaper("A4", 'portrait');
		$customPaper = array(0,0,912.0114899085,528.0066520523);
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('keuangan/download_tunggakan_siswa', $data);
		$this->pdf->render();
		$this->pdf->stream("Tunggakan_Siswa.pdf", array('Attachment'=>0));*/
	}

	#detail data rincian tunggakan siswa
	public function detail_tunggakan_siswa(){
		$this->load->view('template/header');
		$idsiswa = $this->uri->segment(3);

		$jenjang=db_siswa($idsiswa);
		$data['nis']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nis");
		$data['nama']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nama_lengkap");
		$data['status']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "status_aktif");
		$data['kelas']=kelas($jenjang, $idsiswa, ta_berjalan());
		$data['id_tahun']=ta_berjalan();
		$data['wali']=nama_wali($idsiswa);
		$data['hp_wali']=hp_wali($idsiswa);
		$this->load->view('keuangan/ceksiswa', $data);
		$id_tahun=ta_berjalan();

		//tampilan pembayaran siswa
		$id_sekolah = substr($idsiswa,0,3);
		$ar = array('id_siswa =' => $idsiswa, "rombongan_belajar_".$jenjang.".id_tahun"=>$id_tahun);
	    //$data['rombel'] = $this->m_models->getTabelwhere("*", "rombongan_belajar_".$jenjang, $ar, "id_tahun", "asc");
	    $data['rombel'] = $this->m_models->getJoin1where("kelas.id_kelas, id_tingkatan_kelas, rombongan_belajar_".$jenjang.".id_tahun", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $ar, "id_tingkatan_kelas", "asc");
	   // $data['kelas']=$data['rombel'][0]->id_kelas;
	    foreach ($data['rombel'] as $r){ 
	    	$nominal_khusus=all("k_ps_m_khusus", "id_siswa", $idsiswa, "nominal");

	    	//kategori bebas
	    	$ar_jp = array('id_kelas like ' => "%".$r->id_tingkatan_kelas."%", 'jenis'=>'Bebas');
	   		$data['j_pembbebas'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "pos_utama", "asc");
	   		$data['j_pbebas'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "asc");
	   		foreach ($data['j_pbebas'] as $jp_bebas){
	   			$mk = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bebas', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bebas->pos_utama);
		   		$data['mkhusus'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
		   		$jkhusus = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
		   		if ($jkhusus != 0){
		   			foreach ($data['mkhusus'] as $jsb){
				   		$nom_bebas += $jsb->nominal;
				   	}
		   		} else {
		   			$nominal += $jp_bebas->nominal;
		   			$nom_bebas=$nominal;
		   		}

	   			$data['nominal_bebas'][$jp_bebas->pos_utama] = $nom_bebas;

	   			$data['jml_bayar_bebas'][$jp_bebas->pos_utama]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
		    	$data['sisa'][$jp_bebas->pos_utama]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
	   		}


	    	//bulanan
	    	$ar_jpb = array('id_kelas like ' => "%".$r->id_tingkatan_kelas."%", 'jenis'=>'Bulanan');
	   		$data['j_pembbulanan'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "pos_utama", "asc");
	   		$data['j_pbulanan'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "asc");
	   		$nominalb=0; $nom_bulanan=0;
	   		foreach ($data['j_pbulanan'] as $jp_bulanan){
	   			$mkb = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bulanan', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bulanan->pos_utama);
		   		$data['mkhususb'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
		   		$jkhususb = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
		   		if ($jkhususb != 0){
		   			$nom_bulanan=0;
		   			foreach ($data['mkhususb'] as $jsbln){
			   			$nom_bulanan += $jsbln->nominal;
			   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] = $nom_bulanan;
			   		}
		   		} else { 
		   			$nominalb = $jp_bulanan->nominal;
		   			$nom_bulanan += $nominalb; 
		   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] += $nominalb;
		   		}
	   			$bln=date("m"); 
	   			$nombulanan = $data['nominal_bulanan'][$jp_bulanan->pos_utama]*cekblnBayaran($bln); 
	   			$data['tunggakan_bulanan'][$jp_bulanan->pos_utama] = $nombulanan;

		    	//mengecek apakah sudah dilakukan pembayaran atau belum
		    	$data['jml_bayar_bulanan'][$jp_bulanan->pos_utama]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
		    	//$data['sisa'][$jp_bebas->pos_utama]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
	    	}
	    }
		

		$this->load->view('keuangan/detail_tunggakan_siswa',$data); 
		$this->load->view('template/footer');
	}



	public function cekdtsekolah(){
		$tahun=$this->input->get('tahun', TRUE); 
		$data['tahun']=$tahun;

		$ex=explode("-", $this->input->get('id_sekolah', TRUE));
		$id_sekolah=$ex[1];
		$id_tahun=$ex[0];
		$data['id_sekolah']=$this->input->get('id_sekolah', TRUE);

		$ar_sklh = array('status_aktif' => 'on', 'kategori'=>'Sekolah');
		$data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_sklh, "nama", "asc");

		$ar = array('id_sekolah'=>$id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar, "nama_kelas", "asc");

		$this->load->view('tabungan/ceksekolah_tab', $data);
	}

	function riwayat_pembayaran(){
		$this->load->view('template/header');
		$data['thn_akademik']=$this->m_models->getTabelOrder("*", "tahun_akademik", "id_tahun", "desc");
		$data['thn_on']=ta_berjalan();

		$ta_akhir = $this->input->post('ta_akhir', TRUE); 
		$ex=explode("-", $this->input->post('idsekolah', TRUE));  
		$ta = $ex[0];
		$idsekolah = $ex[1];
		$kelas = $this->input->post('kelas', TRUE);  
		$data['ta_awal']=all("tahun_akademik", "id_tahun", $ta_akhir, "periode");

		if ($ta_akhir != ""){
			$jenjang=db_jenjang($idsekolah); 
			$rbel="rombongan_belajar_".$jenjang;
			$sswa="siswa_".$jenjang;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun <="=>$ta_akhir, $rbel.".id_sekolah"=>$idsekolah);
		    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");
		    $tagihan_bebas=0;
		    foreach ($data['rombel'] as $r){
		    	$idsiswa=$r->id_siswa;

				//riwayat transaksi sebelumnya
			    $ar_ts = array('id_siswa =' => $idsiswa, 'id_tahun'=>$ta_akhir);
		    	$data['riwayat_transaksi'][$idsiswa] = $this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_ts, "tgl_bayar", "desc");
		    	foreach ($data['riwayat_transaksi'][$idsiswa] as $rt){		    		
                    $no++;
                    $data['nis'][$r->id_siswa][$no]=all($sswa, "id_siswa", $rt->id_siswa, "nis");
                    $data['nama'][$r->id_siswa][$no]=all($sswa, "id_siswa", $rt->id_siswa, "nama_lengkap");
                    $data['tgl_bayar'][$r->id_siswa][$no]=$rt->tgl_bayar;
                    $data['no_transaksi'][$r->id_siswa][$no]=$rt->no_transaksi;
                    $data['metode'][$r->id_siswa][$no]=all("akun", "id_akun", $rt->sistem, "nama_akun");
                    $data['petugas'][$r->id_siswa][$no]=all("pegawai", "nrp", $rt->nrp_user, "nama");
                    $data['nominal'][$r->id_siswa][$no]=$rt->nominal;
		    	}
		    }
		    $data['no']=$no;
		}
    	$this->load->view('keuangan/riwayat_pemb_siswa',$data); 
		$this->load->view('template/footer');
	}

	public function beasiswa(){
		$this->load->view('template/header');
		$data['thn_akademik']=$this->m_models->getTabelOrder("*", "tahun_akademik", "id_tahun", "desc");
		$data['thn_on']=ta_berjalan();

		$ar_sklh = array('status_aktif' => 'on', 'id_sekolah >='=>'1', 'id_sekolah <='=>'6');
		$data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_sklh, "nama", "asc");


		$tahun=$this->input->post('tahun', TRUE);
		if ($tahun != ""){
			$ar = array('id_tahun'=>$tahun);
			$data['beasiswa'] = $this->m_models->getTabelwhere("*", "k_beasiswa", $ar, "id_kelas", "asc");
			foreach ($data['beasiswa'] as $b) {
				$jenjang=db_siswa($b->id_siswa);

				$ar_s = array('id_siswa' => $b->id_siswa);
				$data['siswa'] = $this->m_models->getTabelwhere("*", "siswa_".$jenjang, $ar_s, "id_siswa", "asc");
				$data['nm_siswa'][$b->id_siswa]=$data['siswa'][0]->nama_lengkap;
				$data['nis'][$b->id_siswa]=$data['siswa'][0]->nis;
			}
		}


    	$this->load->view('keuangan/master_beasiswa',$data); 
		$this->load->view('template/footer');
	}

	public function cekbeasiswa(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('jenjang', TRUE);
		$data['id_sekolah']=$id_sekolah;

		$kls=$this->input->get('kls', TRUE);
		$ex=explode("-", $kls);
		$idsekolah=$ex[0];
		$data['id_kelas']=$ex[1];


		$jnjg=db_jenjang($id_sekolah); 
		$data['jenjang']=$jnjg;
		$id_tahun=ta_berjalan();
		$data['id_tahun']=$id_tahun;


		$ar_sekolah = array('id_sekolah =' => $id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar_sekolah, "nama_kelas", "asc");

		$ar = array('status_aktif =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
	    $data['siswa'] = $this->m_models->getTabelwhere("*", "siswa_".$jnjg, $ar, "nama_lengkap", "asc");

		$this->load->view('keuangan/cekbeasiswa', $data);
	}

	public function cekkls(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$kls=$this->input->get('kls', TRUE);
		$ex=explode("-", $kls);
		$idsekolah=$ex[0];
		$data['id_kelas']=$ex[1]; 
		$data['kls']=$kls;
		$data['idsekolah']=$idsekolah;

	    if ($kls != ""){
	    	$jnjg=db_jenjang($idsekolah); 
	    	$data['jenjang']=$jnjg;
			$data['id_tahun']=ta_berjalan();
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$ex[1], $rbel.".id_tahun"=>ta_berjalan(), $rbel.".id_sekolah"=>$idsekolah);
			$data['siswa'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");
			$data['jsiswa'] = $this->m_models->getRowsJoin1Where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

	    }
		$this->load->view('keuangan/cekbeasiswa', $data);
	}

	public function cekpos(){
		//$this->load->view('template/head');
		//$this->load->view('template/js');

		$ex=explode("-", $this->input->get('jenis', TRUE));
		$idsiswa=$ex[0];
		$idsekolah=$ex[1];
		$idkelas=$ex[2];
		$data['idkelas']=$idkelas;
		$jenis=$ex[3];
		$data['jenis']=$jenis;

		$jnjg=db_jenjang($idsekolah); 
		if ($jenis=="Bulanan"){
			$data['jml_jenis']="Jml Bulan";
		} else {
			$data['jml_jenis']="Jml Nominal";
		}

	    if ($jenis != ""){ //echo "$jenis $idkelas ",ta_berjalan();
			$ar_r = array('jenis'=>$jenis, 'ta_mulai'=>ta_berjalan(), 'id_kelas like'=>'%'.$idkelas.'%', 'status'=>'on');
			#id kelas like id kelas tsb,
			//$data['daftarpos'] = $this->m_models->getJoin1where("*", "k_daftarjenis_pembayaran", "k_daftar_pos", "k_daftar_pos.id_daftar_pos=k_daftarjenis_pembayaran.id_daftar_pos", $ar_r, "id_j_pembayaran", "asc");
			$data['daftarpos'] = $this->m_models->getTabelGroup("pos_utama", "k_ps_daftarpos", $ar_r, "pos_utama", "pos_utama", "asc");
	    }
		$this->load->view('keuangan/cekbeasiswa', $data);
	}

	public function simpan_dt_beasiswa(){
		$jenjang = $this->input->post('jenjang', TRUE);
		$id_kelas = $this->input->post('kls', TRUE);
		$jenis = $this->input->post('jenis', TRUE);
		$daftarpos = $this->input->post('daftarpos', TRUE);
		$jml = $this->input->post('jml', TRUE);
		$jsiswa = $this->input->post('jsiswa', TRUE);
		$id_tahun=ta_berjalan(); 

		$id_siswa = $this->input->post('siswa', TRUE);

		for ($i=0; $i<=$jsiswa; $i++){
			if ($id_siswa[$i] != ""){
				$ar = array('id_siswa' => $id_siswa[$i], 'id_sekolah' => $jenjang, 'id_kelas' => $id_kelas, 'id_tahun'=>$id_tahun, 'jenis'=>$jenis, 'id_daftar_pos'=>$daftarpos, 'jumlah'=>$jml);
				$simpan=$this->m_models->save_data($ar, "k_beasiswa");
			}
		}
		
		if($simpan == TRUE){
	    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
    	}
		redirect('keuangan/beasiswa'); 
	}

	public function pembayaran_siswa(){
		$this->load->view('template/header');
		$data['thn_akademik']=$this->m_models->getTabelOrder("*", "tahun_akademik", "id_tahun", "desc");
		$data['thn_on']=ta_berjalan();

		$ta_akhir = $this->input->post('ta_akhir', TRUE); 
		$ex=explode("-", $this->input->post('idsekolah', TRUE));  
		$ta = $ex[0];
		$idsekolah = $ex[1];
		$kelas = $this->input->post('kelas', TRUE);  
		$data['ta_awal']=all("tahun_akademik", "id_tahun", $ta_akhir, "periode");
		$data['kelas']=all("kelas", "id_kelas", $kelas, "nama_kelas");

		$dari = $this->input->post('dari', TRUE); 
		$sampai = $this->input->post('sampai', TRUE); 
		$data['dari']=$dari;
		$data['sampai']=$sampai;

		if ($ta_akhir != ""){
			$jenjang=db_jenjang($idsekolah); 
			$rbel="rombongan_belajar_".$jenjang;
			$sswa="siswa_".$jenjang;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun <="=>$ta_akhir, $rbel.".id_sekolah"=>$idsekolah);
		    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");
		    $tagihan_bebas=0;
		    foreach ($data['rombel'] as $r){
		    	$idsiswa=$r->id_siswa;

				//riwayat transaksi sebelumnya
			    $ar_ts = array('id_siswa =' => $idsiswa, 'id_tahun'=>$ta_akhir, 'tgl_bayar >= '=>$dari, 'tgl_bayar <= '=>$sampai);
		    	$data['riwayat_transaksi'][$idsiswa] = $this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $ar_ts, "tgl_bayar", "desc");
		    	foreach ($data['riwayat_transaksi'][$idsiswa] as $rt){		    		
                    $no++;
                    $data['nis'][$r->id_siswa][$no]=all($sswa, "id_siswa", $rt->id_siswa, "nis");
                    $data['nama'][$r->id_siswa][$no]=all($sswa, "id_siswa", $rt->id_siswa, "nama_lengkap");
                    $data['tgl_bayar'][$r->id_siswa][$no]=$rt->tgl_bayar;
                    $data['no_transaksi'][$r->id_siswa][$no]=$rt->no_transaksi;
                    $data['metode'][$r->id_siswa][$no]=all("akun", "id_akun", $rt->sistem, "nama_akun");
                    $data['petugas'][$r->id_siswa][$no]=all("pegawai", "nrp", $rt->nrp_user, "nama");
                    $data['nominal'][$r->id_siswa][$no]=$rt->nominal;
		    	}
		    }
		    $data['no']=$no;
		}
    	$this->load->view('keuangan/print_pemb_siswa',$data); 
		$this->load->view('template/footer');
	}

	public function printpembayaran_siswa(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$id_siswa = $this->uri->segment(5);
		$nrp=$this->session->userdata['nrp']; 
		$data['id_sekolah']=$this->m_models->getSession($nrp, "id_sekolah");

		$ar_ps = array('id_siswa =' => $id_siswa, 'tgl_bayar >='=>$dari, 'tgl_bayar <='=>$sampai, 'nrp_user'=>$nrp);
		$data['pemb_siswa'] = $this->m_models->getTabelGroup("*", "k_pembayaran_siswa", $ar_ps, "pos_utama", "id_pemb_siswa", "asc");
		foreach ($data['pemb_siswa'] as $ps) {
			$arps = array('id_siswa =' => $id_siswa, 'tgl_bayar >='=>$dari, 'tgl_bayar <='=>$sampai, 'nrp_user'=>$nrp, 'pos_utama'=>$ps->pos_utama);
			$data['pembsiswa'] = $this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $arps, "id_pemb_siswa", "asc");
		    $nominal=0;
		    foreach ($data['pembsiswa'] as $p){
		    	$nominal += $p->nominal;
		    	$data['nominal'][$ps->pos_utama] = $nominal;
		    	$data['nama_pos'][$ps->pos_utama] = $ps->pos_utama;
		    	$jml_total += $p->nominal;
		    }
		}



	    $data['nama']=all("siswa_".db_siswa($id_siswa), "id_siswa", $id_siswa, "nama_lengkap");
		$data['nis']=all("siswa_".db_siswa($id_siswa), "id_siswa", $id_siswa, "nis");
		$id_kelas=all("rombongan_belajar_".db_siswa($id_siswa), "id_siswa", $id_siswa, "id_kelas");
		$data['kelas']=all("kelas", "id_kelas", $id_kelas, "nama_kelas");
		$data['status_siswa']=all("siswa_".db_siswa($id_siswa), "id_siswa", $id_siswa, "status_aktif");

		$data['metode']=all("akun", "id_akun", $data['pemb_siswa'][0]->sistem, "nama_akun");
		$data['petugas']=all("pegawai", "nrp", $data['pemb_siswa'][0]->nrp_user, "nama");
	//	$data['no_bukti']=$data['pemb_siswa'][0]->no_transaksi;
		$data['sampai']=$sampai;
		$data['dari']=$dari;

		$this->load->view('keuangan/print_transaksi_siswa',$data);
		$this->load->library('pdf');
		//$this->pdf->setPaper("A4", 'portrait');
		$customPaper = array(0,0,912.0114899085,528.0066520523);
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('keuangan/print_transaksi_siswa', $data);
		$this->pdf->render();
		$this->pdf->stream("Bukti_Pembayaran_Siswa.pdf", array('Attachment'=>0));
	}



	#PEMBAYARAN SISWA BARU
	public function master_bayar_siswa(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    	$ar = array('status =' => 'on');
	    }
		$this->load->view('keuangan/master_bayar_siswa', $data);
		$this->load->view('template/footer');
	}

	public function cekrincianpos(){
		$data['jml_rincian']=$this->input->get('jml_rincian', TRUE);
		$ar_akn = array('akun.id_akun like ' => '4.%');
	    $data['akun'] = $this->m_models->getJoin1where("*", "akun", "sub_akun", "sub_akun.id_sub_akun=akun.id_sub_akun", $ar_akn, "id_akun", "asc");
		$this->load->view('keuangan/cekrincianpos', $data);
	}

	public function simpan_master_pemb_siswa(){
		$hariini=date("Y-m-d");
		$nrp=$this->session->userdata['nrp']; 
		$jenis = $this->input->post('jenis', TRUE);
		$nama_pos = $this->input->post('nama_pos', TRUE);
		$jml_rincian = $this->input->post('jml_rincian', TRUE);
		$ta = $this->input->post('ta', TRUE);
		$ta_selesai = $this->input->post('ta_selesai', TRUE);

			#simpan daftar pos
		for ($i=0; $i <=$jml_rincian; $i++){ 
			$rincian_pos = $this->input->post('rincian_pos'.$i, TRUE);
			$id_akun = $this->input->post('id_akun'.$i, TRUE);
			$nominal = $this->input->post('nominal'.$i, TRUE);
			$jkls = $this->input->post('jkls', TRUE);
			$kelas = $this->input->post('kelas', TRUE);
			$kls="";
			for ($j=0; $j <= $jkls; $j++){
				if ($kelas[$j] != ""){
					$kls = "+".$kelas[$j]."+$kls"; 
				}
			}
			
			#simpan rincian pos
			if (($rincian_pos != "")&&($id_akun != "")&&($nominal != "")){
				$ar_pos = array('pos_utama' => $nama_pos, 'pos_rincian' => $rincian_pos, 'id_akun' => $id_akun, 'nominal'=>$nominal, 'jenis'=>$jenis, 'ta_mulai'=>$ta, 'id_kelas'=>$kls,  'status'=>'on', 'tgl_input'=>$hariini, 'nrp_input'=>$nrp);
				$simpan=$this->m_models->save_data($ar_pos, "k_ps_daftarpos");
			}
		}
			
		if($simpan == TRUE){
	    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
    	}
		redirect('keuangan/master_bayar_siswa'); 
	}



	#master untuk siswa dengan nominal khusus
	public function master_khusus(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$id_tahun=ta_berjalan();
		$data['id_tahun']=$id_tahun;

		$ar = array('status_aktif =' => 'on', 'kategori'=>'Sekolah');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "id_sekolah", "asc");

		$id_sekolah=$this->input->post('id_sekolah', TRUE);
		if ($id_sekolah != ""){
			$jenjang=db_jenjang($id_sekolah);
			$data['jenjang']=$jenjang;
			$apk = array('status' => 'on', 'k_ps_m_khusus.id_siswa like'=>$id_sekolah.'%');
	   	 	$data['mkhusus'] = $this->m_models->getJoin1where("*", "k_ps_m_khusus", "siswa_".$jenjang, "siswa_".$jenjang.".id_siswa=k_ps_m_khusus.id_siswa", $apk, "k_ps_m_khusus.id_siswa", "asc");
	   	 	$data['m_khusus'] = $this->m_models->getJoin1whereGroup("*", "k_ps_m_khusus", "siswa_".$jenjang, "siswa_".$jenjang.".id_siswa=k_ps_m_khusus.id_siswa", $apk, "k_ps_m_khusus.id_siswa", "k_ps_m_khusus.id_siswa", "asc");
	   	 	$nom=0;
	   	 	foreach ($data['mkhusus'] as $k) {
	   	 		$nom += $k->nominal;
	   	 		$rincian = "$rincian-".$k->pos_rincian." = ".number_format($k->nominal)."<br>";
	   	 		$data['nominal'][$k->id_siswa]=$nom;
	   	 		$data['rincian'][$k->id_siswa]=$rincian;
	   	 	}
	   	 	
		}


		$this->load->view('keuangan/master_khusus', $data);
		$this->load->view('template/footer');
	}

	public function ceksiswa_mkhusus(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('jenjang', TRUE);
		$data['id_sekolah']=$id_sekolah;
		$id_jenjang=all("sekolah", "id_sekolah", $id_sekolah, "id_jenjang");

		$ar_t = array('status_aktif =' => 'Aktif', 'id_jenjang'=>$id_jenjang);
	    $data['tingkat'] = $this->m_models->getTabelwhere("*", "tingkatan_kelas", $ar_t, "keterangan", "asc");

		$idtingkat=$this->input->get('idtingkat', TRUE); 
		$ex=explode("-", $idtingkat);
		$idsekolah=$ex[0];
		$id_tingkat=$ex[1]; 
		$data['id_tingkat']=$id_tingkat;
		$id_tahun=ta_berjalan();
		$data['id_tahun']=$id_tahun;

		$jnjg=db_jenjang($idsekolah); 
		if ($id_tingkat != ""){ 
		    $t_siswa="siswa_".$jnjg;
		    $t_rombel="rombongan_belajar_".$jnjg; 
			$ar_k = array('id_tingkatan_kelas' => $id_tingkat, $t_rombel.".id_tahun"=>$id_tahun);
			$data['jsiswa'] = $this->m_models->getRowsJoin2Where($t_siswa.".id_siswa, nama_lengkap, nis, nama_kelas", $t_rombel, "kelas", $t_rombel.".id_kelas=kelas.id_kelas", $t_siswa, $t_siswa.".id_siswa=".$t_rombel.".id_siswa", $ar_k, "nama_lengkap", "nama_lengkap", 'asc');
		  	$data['siswa'] = $this->m_models->getJoin2where($t_siswa.".id_siswa, nama_lengkap, nis, nama_kelas", $t_rombel, "kelas", $t_rombel.".id_kelas=kelas.id_kelas", $t_siswa, $t_siswa.".id_siswa=".$t_rombel.".id_siswa", $ar_k, "nama_lengkap", "nama_lengkap", 'asc');

		  	#pos
		  	$arp = array('ta_mulai' => $id_tahun, "id_kelas like "=>"%".$id_tingkat."%"); 
	    	$data['pos_utama'] = $this->m_models->getTabelGroup("pos_utama", "k_ps_daftarpos", $arp, "pos_utama", "pos_utama", "asc");
		}

		$this->load->view('keuangan/ceksiswa_mkhusus', $data);
	}

	public function pos_utama(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$posutama=$this->input->get('pos_utama', TRUE); 
		$ex=explode("-", $posutama);
		$id_tingkat=$ex[0];
		$pos_utama=$ex[1];
		$ar = array('pos_utama' => $pos_utama, "id_kelas like "=>"%".$id_tingkat."%");
	    $data['daftarpos'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar, "id_pos", "asc");
	    $data['jpos'] = $this->m_models->getRowsAWhere("pos_rincian", "k_ps_daftarpos", $ar, "id_pos", "asc");

		$this->load->view('keuangan/pos_utama', $data);
	}

	public function simpan_master_khusus(){
		$hariini=date("Y-m-d");
		$nrp=$this->session->userdata['nrp']; 
		$jenjang = $this->input->post('jenjang', TRUE);
		$pos_utama = $this->input->post('pos_utama', TRUE);
		$idsiswa = $this->input->post('idsiswa', TRUE);
		$id_pos = $this->input->post('id_pos', TRUE);
		$jpos = $this->input->post('jpos', TRUE);
		$jsiswa = $this->input->post('jsiswa', TRUE); echo "$jpos";

		#simpan daftar pos
		for ($i=0; $i <=$jpos; $i++){ 
			$idpos=$id_pos[$i];
			$rincian_pos=all("k_ps_daftarpos", "id_pos", $idpos, "pos_rincian");
			$id_akun=all("k_ps_daftarpos", "id_pos", $idpos, "id_akun");
			$nominal=$this->input->post('nominal'.$idpos, TRUE);
			$jenis=all("k_ps_daftarpos", "id_pos", $idpos, "jenis");
			$periode=all("k_ps_daftarpos", "id_pos", $idpos, "periode");
			$ta=all("k_ps_daftarpos", "id_pos", $idpos, "ta_mulai");
			$ta_selesai=all("k_ps_daftarpos", "id_pos", $idpos, "ta_selesai");
			for ($j=0; $j <= $jsiswa; $j++){
				$id_siswa=$idsiswa[$j];
				#simpan rincian pos
				if (($id_siswa != "") && ($pos_utama != "") && ($nominal != "")){ 
					$ar_pos = array('id_siswa'=>$id_siswa, 'pos_utama' => $pos_utama, 'pos_rincian' => $rincian_pos, 'id_akun' => $id_akun, 'nominal'=>$nominal, 'jenis'=>$jenis, 'periode'=>$periode, 'ta_mulai'=>$ta, 'ta_selesai'=>$ta_selesai, 'status'=>'on', 'tgl_input'=>$hariini, 'nrp_input'=>$nrp);
					$simpan=$this->m_models->save_data($ar_pos, "k_ps_m_khusus");
				}
			}
		}
			
		if($simpan == TRUE){
	    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
    	}
		redirect('keuangan/master_khusus'); 
	}

	

		
	public function e_master_khusus(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$id_siswa = $this->uri->segment(3);
		$pos_utama = $this->uri->segment(4);

		$id_sekolah=$this->input->post('id_sekolah', TRUE);
		if (($id_siswa != "")&&($pos_utama != "")){
			$jenjang=db_siswa($id_siswa);
			$data['jenjang']=$jenjang;
			$apk = array('pos_utama like' => $pos_utama."%", 'k_ps_m_khusus.id_siswa'=>$id_siswa);
	   	 	$data['mkhusus'] = $this->m_models->getJoin1where("*", "k_ps_m_khusus", "siswa_".$jenjang, "siswa_".$jenjang.".id_siswa=k_ps_m_khusus.id_siswa", $apk, "k_ps_m_khusus.id_siswa", "asc");
		}

		$jpos = $this->input->post('jpos', TRUE);
		$id_m_khusus = $this->input->post('id_m_khusus', TRUE);
		$no = $this->input->post('no', TRUE);
		if (($no != "") && ($id_m_khusus != "") && ($jpos != "")){
			for ($i=0; $i <=$no; $i++){
				$id_m_khusus=$id_m_khusus[$i];
				$nominal=$this->input->post('nominal'.$id_m_khusus, TRUE);
				#simpan rincian pos
				if (($nominal != "") && ($id_m_khusus != "")){ 
					$j= array('nominal'=>$nominal,);
					$up=$this->m_models->update_data($id_m_khusus, "id_m_khusus", $j, "k_ps_m_khusus");
				}
			}
				
			if($simpan == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/master_khusus');
		} 

		$this->load->view('keuangan/e_master_khusus', $data);
		$this->load->view('template/footer');
	}



	#pembayaran siswa
	public function cekbyrsiswa(){
		$this->load->view('template/js');
		$idsiswa=$this->input->get("idsiswa", TRUE); 
		$data['idsiswa']=$idsiswa;
		$jenjang=db_siswa($idsiswa);
		$data['nis']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nis");
		$data['nama']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "nama_lengkap");
		$data['status']=all("siswa_".$jenjang, "id_siswa", $idsiswa, "status_aktif");
		$data['kelas']=kelas($jenjang, $idsiswa, ta_berjalan());
		$data['id_tahun']=ta_berjalan();
		$data['wali']=nama_wali($idsiswa);
		$data['hp_wali']=hp_wali($idsiswa);
		$this->load->view('keuangan/ceksiswa', $data);
		$id_tahun=ta_berjalan();

		//tampilan pembayaran siswa
		$id_sekolah = substr($idsiswa,0,3);
		$jenjang=db_jenjang($id_sekolah);
		$ar = array('id_siswa =' => $idsiswa, "rombongan_belajar_".$jenjang.".id_tahun"=>$id_tahun);
	    //$data['rombel'] = $this->m_models->getTabelwhere("*", "rombongan_belajar_".$jenjang, $ar, "id_tahun", "asc");
	    $data['rombel'] = $this->m_models->getJoin1where("kelas.id_kelas, id_tingkatan_kelas, rombongan_belajar_".$jenjang.".id_tahun", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $ar, "id_tingkatan_kelas", "asc");
	    $data['kelas']=$data['rombel'][0]->id_kelas;
	    //$nom_bebas=0; $nominal=0;
	    foreach ($data['rombel'] as $r){
	    	$nominal_khusus=all("k_ps_m_khusus", "id_siswa", $idsiswa, "nominal");
	    	//kategori bebas
	    	$ar_jp = array('id_kelas like ' => "%+".$r->id_tingkatan_kelas."+%", 'jenis'=>'Bebas');
	   		$data['j_pembbebas'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "pos_utama", "asc");
	   		$data['j_pbebas'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jp, "pos_utama", "asc");
	   		$nominal=0; $nom_bebas=0;
	   		foreach ($data['j_pbebas'] as $jp_bebas){
	   			$mk = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bebas', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bebas->pos_utama);
		   		$data['mkhusus'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
		   		$jkhusus = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mk, "id_m_khusus", "asc");
		   		if ($jkhusus != 0){ 
		   			foreach ($data['mkhusus'] as $jsb){
				   		$nom_bebas += $jsb->nominal;
				   		$data['nominal_bebas'][$jp_bebas->pos_utama] += $jsb->nominal;
				   	}
		   		} else { 
		   			$nom_bebas += $jp_bebas->nominal;
		   			$data['nominal_bebas'][$jp_bebas->pos_utama] += $jp_bebas->nominal;
		   		}
		   		

	   			

	   			$data['jml_bayar_bebas'][$jp_bebas->pos_utama]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
		    	$data['sisa'][$jp_bebas->pos_utama]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jp_bebas->pos_utama, $jpbln->periode, '');
	   		}

	    	//bulanan
	    	$ar_jpb = array('id_kelas like ' => "%+".$r->id_tingkatan_kelas."+%", 'jenis'=>'Bulanan');
	   		$data['j_pembbulanan'] = $this->m_models->getAwhereGroup("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "pos_utama", "asc");
	   		$data['j_pbulanan'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_jpb, "pos_utama", "asc");
	   		$nominalb=0; $nom_bulanan=0;
	   		foreach ($data['j_pbulanan'] as $jp_bulanan){
	   			$mkb = array('id_siswa ' => $idsiswa, 'ta_mulai'=>$id_tahun, 'jenis'=>'Bulanan', 'pos_utama'=>$r->id_tingkatan_kelas."-".$jp_bulanan->pos_utama);
		   		$data['mkhususb'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
		   		$jkhususb = $this->m_models->getRowsAWhere("*", "k_ps_m_khusus", $mkb, "id_m_khusus", "asc");
		   		if ($jkhususb != 0){
		   			$nom_bulanan=0;
		   			foreach ($data['mkhususb'] as $jsbln){
			   			$nom_bulanan += $jsbln->nominal;
			   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] = $nom_bulanan;
			   		}
		   		} else { 
		   			$nominalb = $jp_bulanan->nominal;
		   			/*if ($nominalb == 0){ 
			   			$arjpb = array('id_siswa ' => $idsiswa, 'jenis'=>'Bulanan', 'pos_utama'=>$jp_bulanan->pos_utama);
				   		$data['js_bulanan'] = $this->m_models->getTabelwhere("*", "k_ps_m_khusus", $arjp, "nominal", "asc");
				   		$nom_bulanan=0;
				   		foreach ($data['js_bulanan'] as $jsbln){
				   			$nom_bulanan += $jsbln->nominal;
				   			$data['nominal_bulanan'][$jp_bulanan->pos_utama] += $jsbln->nominal;
				   		}
		   			} else { */
		   				$nom_bulanan += $nominalb; 
		   				$data['nominal_bulanan'][$jp_bulanan->pos_utama] += $nominalb;
		   			//} 
		   		}
	   			$bln=date("m"); 
	   			$nombulanan = $data['nominal_bulanan'][$jp_bulanan->pos_utama]*cekblnBayaran($bln); 
	   			$data['tunggakan_bulanan'][$jp_bulanan->pos_utama] = $nombulanan;

		    	//mengecek apakah sudah dilakukan pembayaran atau belum
		    	$data['jml_bayar_bulanan'][$jp_bulanan->pos_utama]=cek_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
		    	//$data['sisa'][$jp_bebas->pos_utama]=sisa_bayar_siswa($idsiswa, $r->id_tahun, $jp_bulanan->pos_utama, $jpbln->periode, '');
	    	}
	    }

	    //riwayat transaksi sebelumnya
	    $ar_ts = array('id_siswa =' => $idsiswa, 'id_tahun'=>$r->id_tahun);
    	$data['riwayat_transaksi'] = $this->m_models->getTabelGroup("*", "k_pembayaran_siswa", $ar_ts, "pos_utama, tgl_bayar, nrp_user", "tgl_bayar", "desc");
    	foreach ($data['riwayat_transaksi'] as $rt){
	   		$art = array('id_siswa =' => $idsiswa, 'id_tahun'=>$r->id_tahun, 'pos_utama'=>$rt->pos_utama, 'tgl_bayar'=>$rt->tgl_bayar, 'nrp_user'=>$rt->nrp_user);
	    	$data['jriwayat'] = $this->m_models->getTabelwhere("*", "k_pembayaran_siswa", $art, "tgl_bayar", "desc");
	    	$nominal=0;
	    	foreach ($data['jriwayat'] as $jr){
	    		$nominal += $jr->nominal;
	    		$data['nominal'][$rt->tgl_bayar][$rt->nrp_user]=$nominal;
	    	}
	    }

	    //transaksi saat ini
		$nrp=$this->session->userdata['nrp']; 
	    $idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $where=array('id_sekolah =' => $idsekolah, 'akun.nama_akun like'=>"%TELLER%", 'nama_akun like '=>'BANK%');
	    $data['akun'] = $this->m_models->getDataJoin("*", "akun", "join pilihan_akun on pilihan_akun.id_akun=akun.id_akun where id_sekolah='$idsekolah' and (nama_akun like '%TELLER%' or nama_akun like '%BANK%')");

		$this->load->view('keuangan/t_pembayaran_siswa', $data);
	}


	public function simpan_transaksi_siswa(){
		$petugas=$this->session->userdata['nrp']; 
		$tgl = date_db($this->input->post('tgl', TRUE));
		$akun1 = $this->input->post('akun1', TRUE);
		$no = $this->input->post('no', TRUE);
		$id_siswa = $this->input->post('id_siswa', TRUE);
		$id_tahun = $this->input->post('id_tahun', TRUE);
		$id_daftar_pos = $this->input->post('pos_utama', TRUE);
		$id_kategori_siswa = $this->input->post('id_kategori_siswa', TRUE); 
		$tombol = $this->input->post('tombol', TRUE); 
		$id_sekolah = substr($id_siswa,0,3);

 		
		for ($i=0; $i <= $no; $i++){ 
			$id_daftarpos= $id_daftar_pos[$i];
			$p = $this->input->post('periode', TRUE);
			$periode = $p[$i];
	 		if ($periode=="Bebas"){
	 			$period=$tgl;
	  		} else if ($periode=="Bulanan"){
	   			$period=$tgl;
	   		}

			if ($id_daftarpos != ""){				
				$nom = db_nominal($this->input->post('nominal', TRUE));
				$nominal = $nom[$i]; 
				$kelas=cekkls($id_siswa, $id_tahun);

		   		$jenjang=db_siswa($id_siswa);
		   		$nm_siswa=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
		   		$uraian="Pembayaran $id_daftarpos a.n $nm_siswa";  
		   		$n=0;
		   		if ($nominal != 0){
		   			//mengecek id daftar pos sesuai dg rinciannya
		   			$ar_rp = array('status =' => 'on', 'ta_mulai'=>$id_tahun, 'pos_utama'=>$id_daftarpos);
			    	$j_rincian = $this->m_models->getRowsAWhere("*", "k_ps_daftarpos", $ar_rp, "pos_rincian", "asc"); 
			    	if ($j_rincian != 0){  
			    		$data['rincian_pos'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $ar_rp, "pos_rincian", "asc");
			    		$nomi=0; $s_tunggakan=0;
			    		foreach ($data['rincian_pos'] as $dp){
			    			$akun=$dp->id_akun;
			    			$n++;
			    			$id_pos_rincian=$dp->pos_rincian; 
			    			//if ($nomi <= 0){
			    					if ($dp->jenis=="Bulanan"){
			    						$bln=date("m"); 
			    						$nominal_tagihan=$dp->nominal*cekblnBayaran($bln); 
			    					} else {
			    						$nominal_tagihan=$dp->nominal;
			    					}
			   						$nominal_pembayaran=cekpembayaransiswa($id_siswa, $id_tahun, $id_daftarpos, $id_pos_rincian);
			   						#menghitung sisa nominal pembayaran 
			   						$sisa_tagihan=$nominal_tagihan-$nominal_pembayaran;  
			   						#mengecek apakah pembayaran yg telah dilakukan kurang dari tagihan atau tidak
			   						//if ($sisa_tagihan > 0){
			   							#sisa pembayaran dikurangi dg nominal yg akan dilakukan pembayaran sekarang
			   							if ($n==1){ 
											$tunggakan = $sisa_tagihan - $nominal;
											if ($tunggakan >= 0){
												if ($nominal != 0){
													$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
										   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$nominal, 'nrp_user'=>$petugas, 'pos_utama'=>$id_daftarpos, 'pos_rincian'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
										   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

										   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
													$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
												}
											} else {
												if ($sisa_tagihan != 0){
													$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
										   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$sisa_tagihan, 'nrp_user'=>$petugas, 'pos_utama'=>$id_daftarpos, 'pos_rincian'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
										   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

										   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$sisa_tagihan, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$sisa_tagihan, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
													$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
												}
											}
											$stunggakan += $tunggakan; //echo "$id_pos_rincian t=$tunggakan s=$sisa_tagihan b=$nominal $n<br>";
										} else {
											if ($n==2){ //echo "2 $nominal<br>";
												if ($stunggakan < 0){
													$tunggakan1 = $sisa_tagihan - abs($stunggakan); //echo "$id_pos_rincian t=$tunggakan1 s=$sisa_tagihan b=$stunggakan $n<br>";
													if ($tunggakan1 >= 0){
														if ($stunggakan != 0){
															$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
												   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>abs($stunggakan), 'nrp_user'=>$petugas, 'pos_utama'=>$id_daftarpos, 'pos_rincian'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
												   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

												   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>abs($stunggakan), 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>abs($stunggakan), 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
															$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
														}
													} else {
														if ($sisa_tagihan != 0){
															$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
												   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$sisa_tagihan, 'nrp_user'=>$petugas, 'pos_utama'=>$id_daftarpos, 'pos_rincian'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
												   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

												   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$sisa_tagihan, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$sisa_tagihan, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
															$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
														}	
													}
													$s_tunggakan += $tunggakan1;
												}
											} else { //echo "3 $nominal $s_tunggakan<br>";
												if ($s_tunggakan < 0){ //echo "4 $nominal<br>";
													$tunggakan1 = $sisa_tagihan - abs($s_tunggakan); //echo "$id_pos_rincian t=$tunggakan1 s=$sisa_tagihan b=$s_tunggakan $n<br>";
													if ($tunggakan1 >= 0){
														if ($s_tunggakan != 0){
															$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
												   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>abs($s_tunggakan), 'nrp_user'=>$petugas, 'pos_utama'=>$id_daftarpos, 'pos_rincian'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
												   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

												   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>abs($s_tunggakan), 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>abs($s_tunggakan), 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
															$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
														}
													} else {// echo "5 $nominal<br>";
														if ($sisa_tagihan != 0){
															#simpan dg tagihan
															$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
												   			$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$sisa_tagihan, 'nrp_user'=>$petugas, 'pos_utama'=>$id_daftarpos, 'pos_rincian'=>$id_pos_rincian, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
												   			$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

												   			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$sisa_tagihan, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$sisa_tagihan, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
															$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");	
														}	
													}
													$s_tunggakan = $tunggakan1;
												} 
											}
										}
			    			//}
			    		}
			    	} else if ($j_rincian==0){
			    		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);
						$ar_trans = array('id_siswa' => $id_siswa, 'id_tahun' => $id_tahun, 'periode' => $period, 'tgl_bayar'=>$tgl, 'nominal'=>$nominal, 'nrp_user'=>$petugas, 'id_daftar_pos'=>$id_daftarpos, 'sistem'=>$akun1, 'no_transaksi'=>$no_transaksi);
						$simpan=$this->m_models->save_data($ar_trans, "k_pembayaran_siswa");

						$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran siswa', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
						$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
			    	}
		   		}
			}
		}
			

		if ($tombol=="simpan"){ 
			if($simpan == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/transaksi_pembayaran');
		} else if ($tombol=="simpanprint"){ 
			redirect('keuangan/print_bukti_transaksi/'.$id_siswa."/".$tgl."/".$petugas);
		}
	}

	public function detail_tunggakan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_siswa = $this->uri->segment(3);
		$pos_utama = $this->uri->segment(4);
		$id_tahun = ta_berjalan();
		$id_kelas = cekkls($id_siswa, $id_tahun);
		$ar_rp = array('status' => 'on', 'ta_mulai'=>$id_tahun, 'pos_utama'=>$pos_utama, 'id_kelas like '=>'%'.$id_kelas.'%');
		$data['rincian_pos'] = $this->m_models->getTabelGroup("*", "k_ps_daftarpos", $ar_rp, "pos_utama", "pos_utama", "asc");
		foreach ($data['rincian_pos'] as $dp){
			$data['nama_pos']=$dp->pos_utama;
			$data['jenis_pos']=$dp->jenis;
			$arp = array('status' => 'on', 'ta_mulai'=>$id_tahun, 'pos_utama'=>$dp->pos_utama, 'id_kelas like '=>'%'.$id_kelas.'%');
			$data['pos'] = $this->m_models->getTabelwhere("*", "k_ps_daftarpos", $arp, "pos_utama", "asc");
			foreach ($data['pos'] as $p) {
				$nominal += $p->nominal;
				$data['jml_nominal'][$dp->pos_utama] = $nominal;
			}
		}

		$this->load->view('keuangan/detail_tunggakan', $data);
		$this->load->view('template/footer');
	}

	public function revisi_pembayaran_siswa(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$cari = $this->input->post('cari', TRUE);		
    	$data['riwayat_transaksi'] = $this->m_models->get_data("*", "k_pembayaran_siswa", "where (id_siswa like '%$cari%' or tgl_bayar like '%$cari%' or pos_utama like '%$cari%' or pos_rincian like '%$cari%') and nrp_user='$nrp' order by tgl_bayar desc limit 20");

		$this->load->view('keuangan/revisi_pembayaran_siswa', $data);
		$this->load->view('template/footer');
	}

	public function rev_pemb_siswa(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_pemb_siswa = $this->uri->segment(3);
		$data['id_pemb_siswa'] = $id_pemb_siswa;

		$id = $this->input->post('id_pemb_siswa', TRUE);	
		$alasan = $this->input->post('alasan', TRUE);
		if (($id != "")&&($alasan != "")){
			$data['riwayat_transaksi'] = $this->m_models->get_data("*", "k_pembayaran_siswa", "where id_pemb_siswa='$id'");
			$command=$data['riwayat_transaksi'][0]->id_siswa."|".$data['riwayat_transaksi'][0]->id_tahun."|".$data['riwayat_transaksi'][0]->periode."|".$data['riwayat_transaksi'][0]->tgl_bayar."|".$data['riwayat_transaksi'][0]->nominal."|".$data['riwayat_transaksi'][0]->nrp_user."|".$data['riwayat_transaksi'][0]->pos_utama."|".$data['riwayat_transaksi'][0]->pos_rincian."|".$data['riwayat_transaksi'][0]->no_transaksi."|".$data['riwayat_transaksi'][0]->periode;
			$ar_pos = array('tgl_input' => $hariini, 'id_pemb_siswa' => $id, 'command' => $command, 'alasan'=>$alasan, 'ket'=>"hapus", 'approve'=>'Proses');
			if($this->m_models->save_data($ar_pos, "k_rev_bayar_siswa") == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/revisi_pembayaran_siswa'); 
		} else {
			$data['riwayat_transaksi'] = $this->m_models->get_data("*", "k_pembayaran_siswa", "where id_pemb_siswa='$id_pemb_siswa'");
			foreach ($data['riwayat_transaksi'] as $rt){
				$jenjang=db_siswa($rt->id_siswa);
				$data['tgl_bayar'] = tgl_indo($rt->tgl_bayar);
				$data['nis'] = all("siswa_".$jenjang, "id_siswa", $rt->id_siswa, "nis");
				$data['nama'] = all("siswa_".$jenjang, "id_siswa", $rt->id_siswa, "nama_lengkap");
				$data['pos_utama'] = $rt->pos_utama;
				$data['pos_rincian'] = $rt->pos_rincian;
				$data['nominal'] = number_format($rt->nominal);
				$data['nama_akun'] = all("akun", "id_akun", $rt->sistem, "nama_akun");
			}
			$this->load->view('keuangan/rev_pemb_siswa', $data);
			$this->load->view('template/footer');
		}
	}

	public function approval_pembayaran_siswa(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$cari = $this->input->post('cari', TRUE);		
    	$data['riwayat_transaksi'] = $this->m_models->get_data("*", "k_rev_bayar_siswa", "join k_pembayaran_siswa on k_pembayaran_siswa.id_pemb_siswa=k_rev_bayar_siswa.id_pemb_siswa where nrp_user='$nrp' and approve='Proses'");

		$this->load->view('keuangan/approval_pembayaran_siswa', $data);
		$this->load->view('template/footer');
	}

	public function app_pemb_siswa(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_pemb_siswa = $this->uri->segment(3);
		$ket = $this->uri->segment(4);

		if (($id_pemb_siswa != "")&&($ket == "A")){
			$j= array('approve'=>"Approve");
			$up=$this->m_models->update_data($id_pemb_siswa, "id_pemb_siswa", $j, "k_rev_bayar_siswa");

			$data['riwayat_transaksi'] = $this->m_models->get_data("*", "k_pembayaran_siswa", "where id_pemb_siswa='$id_pemb_siswa'");
			$no_transaksi=$data['riwayat_transaksi'][0]->no_transaksi;

			$del_jurnal = $this->m_models->delete_data($no_transaksi, "no_transaksi", "jurnal");

			$del_pemb_siswa = $this->m_models->delete_data($id_pemb_siswa, "id_pemb_siswa", "k_pembayaran_siswa");
			
			if($del_pemb_siswa == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/approval_pembayaran_siswa');
		} else if (($id_pemb_siswa != "")&&($ket == "B")){
			$j= array('approve'=>"Batal");
			$up=$this->m_models->update_data($id_pemb_siswa, "id_pemb_siswa", $j, "k_rev_bayar_siswa");
			if($up == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/approval_pembayaran_siswa');
		}	
		$this->load->view('template/footer');
	}

	
	public function va_siswa_baru(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$data['Sekolah']=$this->m_models->getAll('kode_pendaftaran group by kode order by kode asc');

	    $no_daftar=$this->input->post ('no_daftar');
	    $virtual_account=$this->input->post('virtual_account');
	    $id_sekolah=$this->input->post ('id_sekolah');

	    if (($virtual_account != "")&&($no_daftar != "")){
		  	$data=array('no_daftar' => $no_daftar, 'virtual_account' =>$virtual_account, 'id_sekolah' => $id_sekolah, 'nrp' => $nrp, 'tgl_input' =>date('y-m-d'), 'status' => "ON");
		    $data['simpan']=$this->M_models->save_data($data,"k_virtual_account");
		    redirect('keuangan/va_siswa_baru');
   	 	}

		$this->load->view('keuangan/va_siswa_baru', $data);	
		$this->load->view('template/footer');
	}

	public function cek_kelas_siswa(){
	    $id_kode=$this->input->get('id_kode');
		$id_tahun=ta_pendaftaran(); 
	    $array=array("no_daftar like" => $id_kode."%", 'id_tahun'=>$id_tahun, 'psb_kelulusan_pendaftar.status'=>'Lulus');
	    $data['Siswa']=$this->m_models->getJoin1where('*,psb_kelulusan_pendaftar.status as status_l','psb_kelulusan_pendaftar','calon_siswa','no_daftar',$array,'id_kelulusan', 'asc');
	    $this->load->view('keuangan/siswa_prs',$data);
	} 

	public function download_ppdb() {
		$id_tahun=ta_pendaftaran(); 
	    $arraywhere=array('psb_kelulusan_pendaftar.status'=>'Lulus', 'id_tahun'=>$id_tahun);
	    $data['list_calon']=$this->m_models->getJoin1where("*,psb_kelulusan_pendaftar.status as status_l",'psb_kelulusan_pendaftar','calon_siswa','no_daftar',$arraywhere,'id_kelulusan', 'asc');
	    $this->load->view('keuangan/download_format_prs',$data);
    }

    public function upload_va_prs(){
        $nrp=$this->session->userdata['nrp'];
		$hariini=date("Y-m-d");
	  	$fileName = $this->input->post('file', TRUE);

	  	$config['upload_path'] = './assets/upload/'; 
	  	$config['file_name'] = $fileName;
	  	$config['allowed_types'] = 'xls|xlsx|csv|ods|ots';
	  	$config['max_size'] = 100000;

	  	$this->load->library('upload', $config);
	  	$this->upload->initialize($config); 
	  
	  	if (!$this->upload->do_upload('file')) {
	   		$error = array('error' => $this->upload->display_errors());
	   		$this->session->set_flashdata('msg','Ada kesalah dalam upload'); 
	   		redirect('Welcome'); 
	  	} else {
	   		$media = $this->upload->data();
	   		$inputFileName = 'assets/upload/'.$media['file_name'];
	   
	   		try {
			    $inputFileType = IOFactory::identify($inputFileName);
			    $objReader = IOFactory::createReader($inputFileType);
			    $objPHPExcel = $objReader->load($inputFileName);
	   		} catch(Exception $e) {
	    		die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
	   		}

		   $sheet = $objPHPExcel->getSheet(0);
		   $highestRow = $sheet->getHighestRow();
		   $highestColumn = $sheet->getHighestColumn(); 

	   		for ($row = 2; $row <= $highestRow; $row++){
	     		$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);

	     		$ndaftar=substr($rowData[0][1],0,-8);
             
	            $array=array('kode like'=>'%'.$ndaftar.'%');
	            $data['no_daftar']=$this->m_models->getTabelwhere("*", "kode_pendaftaran", $array, "kode", "asc");
              	$id_sekolah=$data['no_daftar'][0]->id_sekolah;

		 		$data = array(
		     		"id_va"=> '',
		     		"no_daftar"=> $rowData[0][1],
		     		"virtual_account"=> $rowData[0][3],
		     		"id_sekolah"=> $id_sekolah,
		     		"nrp"=> $nrp,
		     		"tgl_input"=> $hariini,
		     		"status"=> 'on'
		    	); 
		    	$this->db->insert("k_virtual_account",$data);
	   		} 
		   	// delet file
	        unlink($inputFileName);

	   		$this->session->set_flashdata('msg','Berhasil upload ...!!'); 
	   		redirect('keuangan/va_siswa_baru');
	  	}  
	} 

	public function va_siswa_lama(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$data['Sekolah']=$this->m_models->getAll("sekolah where kategori='Sekolah'");

	    $no_daftar=$this->input->post ('no_daftar');
	    $virtual_account=$this->input->post('virtual_account');
	    $id_sekolah=$this->input->post ('id_sekolah');

	    if (($virtual_account != "")&&($no_daftar != "")){
		  	$data=array('no_daftar' => $no_daftar, 'virtual_account' =>$virtual_account, 'id_sekolah' => $id_sekolah, 'nrp' => $nrp, 'tgl_input' =>date('y-m-d'), 'status' => "ON");
		    $data['simpan']=$this->m_models->save_data($data,"k_virtual_account");
		    redirect('keuangan/va_siswa_baru');
   	 	}

		$this->load->view('keuangan/va_siswa_lama', $data);	
		$this->load->view('template/footer');
	}

	public function cek_kelas_siswa1(){
	    $id_sekolah=$this->input->get('id_sekolah');
	    $jenjang=db_jenjang($id_sekolah); 
	    if ($id_sekolah !=''){
	    	$sklh="siswa_".$jenjang; 
	    	$data['Siswa']=$this->m_models->get_data("*",$sklh,"where id_siswa not in(select id_siswa from k_virtual_account) and status_aktif='Aktif'");
	    }
	    $this->load->view('keuangan/siswa_lama',$data);
	} 

	public function download_siswa(){
	    $id_sekolah=$this->input->post('id_sekolah');
	    $jenjang=db_jenjang($id_sekolah);
	    if ($id_sekolah !=''){
	    	$data['list_siswa_download']=$this->m_models->get_data('*',"siswa_".$jenjang,"where id_siswa not in(select id_siswa from k_virtual_account) and status_aktif='Aktif'");
	    }
	    $this->load->view('keuangan/download_format_va_siswa',$data);
	} 

	 public function upload_va_siswa(){
        $nrp=$this->session->userdata['nrp'];
		$hariini=date("Y-m-d");
	  	$fileName = $this->input->post('file', TRUE);

	  	$config['upload_path'] = './assets/upload/'; 
	  	$config['file_name'] = $fileName;
	  	$config['allowed_types'] = 'xls|xlsx|csv|ods|ots';
	  	$config['max_size'] = 100000;

	  	$this->load->library('upload', $config);
	  	$this->upload->initialize($config); 
	  
	  	if (!$this->upload->do_upload('file')) {
	   		$error = array('error' => $this->upload->display_errors());
	   		$this->session->set_flashdata('msg','Ada kesalah dalam upload'); 
	   		redirect('Welcome');
	  	} else {
	   		$media = $this->upload->data();
	   		$inputFileName = 'assets/upload/'.$media['file_name'];
	   
	   		try {
			    $inputFileType = IOFactory::identify($inputFileName);
			    $objReader = IOFactory::createReader($inputFileType);
			    $objPHPExcel = $objReader->load($inputFileName);
	   		} catch(Exception $e) {
	    		die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
	   		}

		   $sheet = $objPHPExcel->getSheet(0);
		   $highestRow = $sheet->getHighestRow();
		   $highestColumn = $sheet->getHighestColumn(); 

	   		for ($row = 2; $row <= $highestRow; $row++){
	     		$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);

		 		$data = array(
		     		"id_va"=> '',
		     		"id_siswa"=> $id_siswa,
		     		"virtual_account"=> $rowData[0][4],
		     		"id_sekolah"=> $rowData[0][3],
		     		"nrp"=> $nrp,
		     		"tgl_input"=> $hariini,
		     		"status"=> 'on'
		    	); 

		    	$this->db->insert("k_virtual_account",$data);
	   		} 
		   	// delet file
	        unlink($inputFileName);

	   		$this->session->set_flashdata('msg','Berhasil upload ...!!'); 
	   		redirect('keuangan/va_siswa_baru');
	  	}  
	} 


	public function lihat_va(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$data['virtual']=$this->m_models->getTabelOrder("*", "k_virtual_account", "virtual_account", "asc");

		$this->load->view('keuangan/lihat_va', $data);	
		$this->load->view('template/footer');
	}

	
	public function infaq_rutin(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		
		$ar = array('status_aktif =' => 'on', 'kategori'=>'Sekolah');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "id_sekolah", "asc");

		$id_sekolah = $this->input->post('jenjang', TRUE);
		if ($id_sekolah != ""){
			$data['id_sekolah']=$id_sekolah;
			$data['id_tahun']=ta_berjalan();
			$jnjg=db_jenjang($id_sekolah); 
			$ar_i = array('k_infaq_rutin.d_sekolah'=>$id_sekolah);
	    	$data['infaq_rutin'] = $this->m_models->getJoin1where("*", "k_infaq_rutin", "siswa_".$jnjg, "k_infaq_rutin.id_siswa=$siswa_".$jnjg.".id_siswa", $ar_i, "nama_lengkap", "asc");
		}
		
		$this->load->view('keuangan/infaq_rutin', $data);
		$this->load->view('template/footer');
	}

	public function dtsiswa(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('jenjang', TRUE);
		$data['id_sekolah']=$id_sekolah;
		$jnjg=db_jenjang($id_sekolah); 
		$data['id_tahun']=ta_berjalan();


		$ar = array('status_aktif =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
	    $data['siswa'] = $this->m_models->getTabelwhere("*", "siswa_".$jnjg, $ar, "nama_lengkap", "asc");

		$this->load->view('keuangan/dtsiswa', $data);
	}

	public function simpan_infaq_rutin(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_sekolah = $this->input->post('jenjang', TRUE);
		$idsiswa = $this->input->post('idsiswa', TRUE);
		$nominal = $this->input->post('nominal', TRUE);
		for ($i=0; $i <= $no; $i++){ 
			$id_siswa = $idsiswa[$i];
			$ar_i = array('id_siswa' => $id_siswa, 'nominal' => $nominal, 'tgl_input' => $hariini, 'petugas'=>$nrp, 'id_sekolah'=>$id_sekolah);
			$simpan=$this->m_models->save_data($ar_i, "k_infaq_rutin");
		}

		
		if($simpan == TRUE){
	    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
    	}
		redirect('keuangan/infaq_rutin'); 
	}


	public function input_daftarulang(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
	    $idsekolah=$this->m_models->getSession($nrp, "id_sekolah");

		$data['kode_prs']=$this->m_models->getTableGroup("kode, jenjang_am, jk", "kode_pendaftaran", "kode", "kode", "asc");
		$data['akun'] = $this->m_models->getAll("akun join pilihan_akun on pilihan_akun.id_akun=akun.id_akun where id_sekolah='18' and (akun.nama_akun like '%TELLER%' or nama_akun like 'BANK%') order by akun.id_akun asc");

		$tgl = date_db($this->input->post('tgl', TRUE));
		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$sistem = $this->input->post('sistem', TRUE);
		$nodaftar = $this->input->post('no_daftar', TRUE);
		if (($tgl != "") && ($nominal != "") && ($sistem != "") && ($nodaftar != "")){
			for ($i=0; $i < count($nodaftar); $i++) { 
				$no_daftar=$nodaftar[$i];
				$id_tahun=ta_pendaftaran("id_tahun");
				$ar = array('no_daftar' => $no_daftar, 'id_tahun' => $id_tahun, 'tgl_bayar' => $tgl, 'waktu'=>date("h:i:s"), "nominal"=>$nominal, "petugas"=>$nrp, "sistem"=>$sistem);
				$simpan=$this->m_models->save_data($ar, "k_daftar_ulang");
			}
			if($simpan){
			    $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('keuangan/input_daftarulang'); 
		}

		
		$this->load->view('keuangan/input_daftarulang', $data);
		$this->load->view('template/footer');
	}


	public function cekpendaftar(){
		$this->load->view('template/head');
		$kode=$this->input->get('kode_pendaftar', TRUE);
		$id_tahun=ta_pendaftaran("id_tahun");
		$ar = array("id_tahun"=>$id_tahun, "calon_siswa.no_daftar like "=>"$kode%", 'psb_kelulusan_pendaftar.status'=>'Lulus');
		$data['pendaftar']=$this->m_models->getJoin1whereDb2("calon_siswa.no_daftar, calon_siswa.nama_lengkap", "calon_siswa", "psb_kelulusan_pendaftar", "calon_siswa.no_daftar=psb_kelulusan_pendaftar.no_daftar", $ar, "calon_siswa.nama_lengkap", "asc");
		//$data['pendaftar']=$this->m_models->getTabelwhere("*", "calon_siswa", $ar, "no_daftar", "asc");
		$this->load->view('keuangan/cekpendaftar', $data);
	}


	public function lihat_daftarulang(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
	    $idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['tahun'] = $this->m_models->getAll("tahun_akademik");
	    $data['id_tahun']=ta_pendaftaran("id_tahun");

		$ta=$this->input->post('ta', TRUE); 
		if ($ta != ""){
			$data['ta']=$ta;
			$ar = array('k_daftar_ulang.id_tahun' => $ta);
	    	$data['daftar_ulang'] = $this->m_models->getJoin1where("*", "k_daftar_ulang", "calon_siswa", "calon_siswa.no_daftar=k_daftar_ulang.no_daftar", $ar, "k_daftar_ulang.no_daftar", "asc");
		}
	    
		$this->load->view('keuangan/lihat_daftarulang', $data);
		$this->load->view('template/footer');
	}

	public function download_daftar_ulang(){
		$nrp=$this->session->userdata['nrp']; 
	    $idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['tahun'] = $this->m_models->getAll("tahun_akademik");
	    $data['id_tahun']=ta_pendaftaran("id_tahun");

		$ta = $this->uri->segment(3);
		if ($ta != ""){
			$data['ta']=$ta;
			$ar = array('k_daftar_ulang.id_tahun' => $ta);
	    	$data['daftar_ulang'] = $this->m_models->getJoin1where("*", "k_daftar_ulang", "calon_siswa", "calon_siswa.no_daftar=k_daftar_ulang.no_daftar", $ar, "k_daftar_ulang.no_daftar", "asc");
		}
	    
		$this->load->view('keuangan/download_daftar_ulang', $data);
	}

}