<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kesehatan extends CI_Controller {
	 function __construct()
       {
            parent::__construct();
            $this->load->helper('url');
        	$this->load->library('pagination');
		    if (!isset($this->session->userdata['id_pengguna'])) {
		      redirect(base_url("login"));
		    }
            $this->load->library('pagination');
            $this->load->model('m_models'); 
       }

//========================================================================================================================
/*=================================== PEMERIKSAAN KESEHATAN LEVEL PAUD (TK & KOBER) ========================================*/
//========================================================================================================================
		public function input_pemeriksaan()
	{
		$this->load->view('template/header');
		$ar = $this->session->userdata['nrp'];
	
       $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
	   
	   $data['jpen'] = $this->m_models->getAll("sekolah join jenjang_pendidikan on jenjang_pendidikan.id_jenjang = sekolah.id_jenjang where id_sekolah='$idsekolah'");
		
		$data['tampilta'] = $this->m_models->getDataByID("tahun_akademik","status_berjalan","ON");
			  foreach($data['jpen'] as $pnd){
				 $nma = strtolower($pnd->nama_jenjang);
				 $siswa = "".$nma;
				$data['idthn'] = $this->m_models->getDataByID("tahun_akademik","status_berjalan","ON");
				foreach($data['idthn'] as $thn)
				 {
					 //memilih Apakah NRP tersebut adalah wali kelas atau bukan
					 $jumlah = $this->m_models->getRows("kelas where id_tahun='$thn->id_tahun' and nrp='$ar'");
					 
					 if($jumlah > 0)
					 {
						$arraywhere1 = array('id_tahun =' => $thn->id_tahun,'nrp =' => $ar);
						$data['kelas'] = $this->m_models->getTabelwhere("*","kelas",$arraywhere1,"nama_kelas","asc"); 
					 } else {
						$arraywhere1 = array('id_tahun =' => $thn->id_tahun,'id_sekolah=' => $idsekolah);
						$data['kelas'] = $this->m_models->getTabelwhere("*","kelas",$arraywhere1,"nama_kelas","asc");   
					 }	
				 }
			  }
		$this->load->view('kesehatan/f_input_pemeriksaan',$data);
		$this->load->view('template/footer');
	}
	
	//=========================================================================================
	//=========================== Menampilkan Data - Data Siswanya ============================
	//=========================================================================================
	
	public function tampil_siswa()
	{
		$id_kelas = $this->input->get('id_kelas');
		
		$id_sekolah = all("kelas","id_kelas",$id_kelas,"id_sekolah");
		$id_jenjang = all("sekolah","id_sekolah",$id_sekolah,"id_jenjang");
		$nama = all("jenjang_pendidikan","id_jenjang",$id_jenjang,"nama_jenjang");
		$siswa = strtolower($nama);
		
	    $arraywhere=array('status_aktif' => 'Aktif','rombongan_belajar_'.$siswa.'.id_kelas='=>$id_kelas,'rombongan_belajar_'.$siswa.'.status='=>'on');
		$data['siswa']  = $this->m_models->getJoin1where("*","siswa_".$siswa."","rombongan_belajar_".$siswa."","id_siswa",$arraywhere,"nama_panggilan","asc");
					
		$this->load->view('kesehatan/tampil_siswa',$data);
	}
	
	//Simpan Data
	public function simpan_pemeriksaan(){
		$ar = $this->session->userdata['nrp'];
        $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
	
	   $tanggal = $this->input->post('tanggal');
	   $id_kelas = $this->input->post('id_kelas');
	  
		 $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
	  	 $data['jpen'] = $this->m_models->getAll("sekolah join jenjang_pendidikan on jenjang_pendidikan.id_jenjang = sekolah.id_jenjang where id_sekolah='$idsekolah'");

      foreach($data['jpen'] as $pnd){
        $nma = strtolower($pnd->nama_jenjang); 
        $siswa = "".$nma;
		
		$arraywhere=array('id_kelas =' => $id_kelas,'status ='=>'on');
		$data['tampilsiswa']  = $this->m_models->getTabelwhere("*", "rombongan_belajar_".$siswa."",$arraywhere,"id_siswa","asc");
		
		foreach ($data['tampilsiswa'] as $tsiswa)
			{
				$id_siswa = $tsiswa->id_siswa;
				$tb = $this->input->post('tb'.$id_siswa.'');
				$bb = $this->input->post('bb'.$id_siswa.'');
				$catatan = $this->input->post('catatan'.$id_siswa.'');
				
				if(($tb !="") or ($tb !="0"))
				{
				$nnilai=array(
						'id_cek' => '',
						'id_siswa' => $id_siswa, 
						'tanggal' => $tanggal,
						'tb' => $tb,
						'bb' => $bb,
						'catatan' => $catatan);
					$data['simpan_hasil'] = $this->m_models->save_data($nnilai, "paud_cek_kesehatan");
				}					
			}
	  }
		redirect('kesehatan/rekap_hasil_pemeriksaan');
	}
	
	
	//========================= Hasil Rekapitulasi Per Kelas =================================
	public function rekap_hasil_pemeriksaan()
	  { 
		$this->load->view('template/header');
		$ar = $this->session->userdata['nrp'];
		
		   $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		   $data['jpen'] = $this->m_models->getAll("sekolah join jenjang_pendidikan on jenjang_pendidikan.id_jenjang = sekolah.id_jenjang where id_sekolah='$idsekolah'");
		   $data['tampilta'] = $this->m_models->getAll("tahun_akademik");
		
			foreach($data['jpen'] as $pnd){
				 $nma = strtolower($pnd->nama_jenjang);
				 $siswa = "".$nma;
				 //echo $siswa;
				$data['idthn'] = $this->m_models->getDataByID("tahun_akademik","status_berjalan","ON");
				foreach($data['idthn'] as $thn)
				 {
					   $arraywhere1 = array('id_tahun =' => $thn->id_tahun,'nrp =' => $ar);
					   $data['kelas'] = $this->m_models->getTabelwhere("*","kelas",$arraywhere1,"nama_kelas","asc"); 
						foreach ($data['kelas'] as $kls)
						{
							$arraywhere=array('status_aktif' => 'Aktif','rombongan_belajar_'.$siswa.'.id_tahun='=>$thn->id_tahun,'rombongan_belajar_'.$siswa.'.id_kelas='=>$kls->id_kelas,'rombongan_belajar_'.$siswa.'.status='=>'on');
							
							$data['siswa']  = $this->m_models->getJoin1where("*","siswa_".$siswa."","rombongan_belajar_".$siswa."","id_siswa",$arraywhere," nama_panggilan","asc"); 
						}
				 }
		
	  }
	    //Menampilkan nama-nama orang yang sudah dinilai
		$idta = $this->input->post('idta');
		$tanggal = date_db($this->input->post('tanggal'));
		$id_kelas = $this->input->post('id_kelas');
		
		
		
		//menammpilkan dulu id kelasnya
		$id_tingkat = all("kelas","id_kelas",$id_kelas,"id_tingkatan_kelas");
		$id_jenjang = all("tingkatan_kelas","id_tingkatan_kelas",$id_tingkat,"id_jenjang");
		$jenjang = all ("jenjang_pendidikan","id_jenjang",$id_jenjang,"nama_jenjang");
		
		$this->load->view('kesehatan/rekap_hasil_pemeriksaan',$data);
		$this->load->view('template/footer');
 }
 
	//menampilkan Kelas yang dipilih
	public function cek_kelas_siswa()
	{   	
		$id_ta = $this->input->get('idta'); 
		$ar = $this->session->userdata['nrp'];

		//Menghitung Rows nya
		$jumlah  = $this->m_models->getRows("kelas where id_tahun='$id_ta' and nrp='$ar'");
			if($jumlah > 0)
			{			
				$arraywhere=array('id_tahun = ' => $id_ta, 'nrp =' => $ar);
				$data['kelas']  = $this->m_models->getTabelwhere("*", "kelas",$arraywhere,"nama_kelas","asc");
			} else {
				$arraywhere=array('id_tahun = ' => $id_ta);
				$data['kelas']  = $this->m_models->getTabelwhere("*", "kelas",$arraywhere,"nama_kelas","asc");
			}
		$this->load->view('kesehatan/cek_kelas_siswa',$data);
	}
	
//Menampilkan Hasil Pemeriksaan
public function cek_hasil()
	{
		$id_kelas = $this->input->get('id_kelas');
		//mencari id tahun dari kelas tersebut
		$id_tahun = all ("kelas","id_kelas",$id_kelas,"id_tahun");
		
		$data['th'] = $this->m_models->getDataByID("tahun_akademik","id_tahun",$id_tahun);
		
		$id_sekolah = all("kelas","id_kelas",$id_kelas,"id_sekolah");
		$id_jenjang = all("sekolah","id_sekolah",$id_sekolah,"id_jenjang");
		$nama = all("jenjang_pendidikan","id_jenjang",$id_jenjang,"nama_jenjang");
		$siswa = strtolower($nama);
		
	    $arraywhere=array('status_aktif' => 'Aktif','rombongan_belajar_'.$siswa.'.id_kelas='=>$id_kelas,'rombongan_belajar_'.$siswa.'.status='=>'on');
		$data['siswa']  = $this->m_models->getJoin1where("*","siswa_".$siswa."","rombongan_belajar_".$siswa."","id_siswa",$arraywhere,"nama_panggilan","asc");
			
			
		 //mencari Data Hasil Pemeriksaan
		$arraywhere=array('id_tahun' => $id_tahun); 
		$data['hasil'] = $this->m_models->getTabelwhere("*", "paud_cek_kesehatan",$arraywhere,"tanggal","asc");
	
             foreach ($data['hasil'] as $hsl) {
                $id_siswa = $hsl->id_siswa;
				$tgl = $hsl->tanggal;
				$id_tahun = $hsl->id_tahun;
                $bulan = explode("-",$tgl);
				$bulan1 = $bulan[1];
				$tb = $hsl->tb;
				$bb = $hsl->bb;
				
               $arr_tb[$id_siswa][$bulan1][$id_tahun] = $tb;
			   $arr_bb[$id_siswa][$bulan1][$id_tahun] = $bb;
              }
              $data['ttb'] =  $arr_tb;
              $data['tbb'] =  $arr_bb;
		$this->load->view('kesehatan/cek_hasil',$data);
	}
	
//Untuk Melihat Detail Hasil Tes Kesehatan 
	public function detail_cek_hasil(){
		$id_siswa = $this->uri->segment(3);
		
		$this->load->view('template/header');
		$ar = $this->session->userdata['nrp'];
   
		//menampilkan dulu jenajng pendidikannya
		$kode = substr("$id_siswa",0,3);
		$id_jenjang = all("sekolah","id_sekolah",$kode,"id_jenjang");
		$nama_jenjang =  all("jenjang_pendidikan","id_jenjang",$id_jenjang,"nama_jenjang");
		$siswa = strtolower($nama_jenjang);
		
		$data['siswa'] = $this->m_models->getDataByID("siswa_".$siswa."","id_siswa",$id_siswa);
		
		//Menampilkan data yang Sudah tersimpan di database
		$data['hasil'] = $this->m_models->getDataByID("paud_cek_kesehatan","id_siswa", $id_siswa);
		
		$this->load->view('kesehatan/detail_cek_hasil',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	
 /*==================================================================================================================
   ==================================================================================================================*/	

   #getRayon
   	function getRayon(){
		$d_asrama = $this->m_models->getJoin1("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", "b_kamar.nama", "ASC");
		foreach ($d_asrama as $key) {
			$asrama['rayon'][$key->id_kamar] = $key->nama_asrama;
			$asrama['kamar'][$key->id_kamar] = $key->nama;
		}
		return $asrama;
	}

   #penyakit
	function penyakit(){
		$this->load->view('template/header');

		# ambil data alamat
		$data[penyakit] = $this->m_models->getAll("penyakit WHERE status='ON' ORDER BY nama_penyakit ASC");

		# tampilkan data ke view
		$this->load->view('kesehatan/penyakit', $data); 

		$this->load->view('template/footer');
	}

	function tambah_penyakit(){
		$nama_penyakit = $this->input->post('nama_penyakit', TRUE);
        $keterangan  = $this->input->post('keterangan', TRUE);

 		$data = array (
		    'nama_penyakit' => $nama_penyakit,
		    'keterangan'  => $keterangan,
		    'status' => 'ON'
		);

		# proses simpan
		if ($this->m_models->save_data($data,"penyakit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('kesehatan/penyakit');
	}

	function edit_penyakit(){
		$id_penyakit = $this->input->post('id_penyakit', TRUE);
		$nama_penyakit = $this->input->post('nama_penyakit', TRUE);
        $keterangan  = $this->input->post('keterangan', TRUE);

 		$data = array (
		    'nama_penyakit' => $nama_penyakit,
		    'keterangan'  => $keterangan
		);

		# proses simpan
		if ($this->m_models->update_data($id_penyakit, 'id_penyakit', $data, "penyakit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('kesehatan/penyakit');
	}

	function hapus_penyakit(){
		$id_penyakit = $this->input->post('id_penyakit', TRUE);

		$data = array ('status' => 'OFF');

		# proses hapus
		if ($this->m_models->update_data($id_penyakit, 'id_penyakit', $data, 'penyakit') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('kesehatan/penyakit');
	}

	#siswa_sakit
	function siswa_sakit(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);

		if ($tgl_dari != null AND $tgl_sampai != null) { 

			$rayon = $this->getRayon();

			$arrWhere=array('siswa_sakit.tanggal_sakit >='=> $tgl_dari, 'siswa_sakit.tanggal_sakit <='=> $tgl_sampai);
			# cari data siswa dengan kriteria kondisi arrWhere di atas
			$siswa_sakit = $this->m_models->getJoin2Awhere("siswa_sakit.*, kelas.nama_kelas, penyakit.nama_penyakit", "siswa_sakit", "kelas", "siswa_sakit.id_kelas=kelas.id_kelas", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
			foreach ($siswa_sakit as $key) {
				$id_siswa = $key->id_siswa;
				$jenjang = db_siswa($id_siswa);

				$siswa = $this->m_models->get_data("nis, nama_lengkap, jk", "siswa_".$jenjang, "WHERE id_siswa='$id_siswa'");
				$kamar = $this->m_models->get_data("id_kamar", "b_kamar_santri", "WHERE id_siswa='$id_siswa' AND id_tahun='$key->id_tahun' ORDER BY masuk DESC ");
				
				$data_siswa['tanggal'][] = $key->tanggal_sakit;
				$data_siswa['id_siswa_sakit'][] = $key->id_siswa_sakit;
				$data_siswa['id_penyakit'][] = $key->id_penyakit;
				$data_siswa['penyakit'][] = $key->nama_penyakit;
				$data_siswa['nis'][] = $siswa[0]->nis;
				$data_siswa['nama'][] = $siswa[0]->nama_lengkap;
				$data_siswa['jk'][] = $siswa[0]->jk;
				$data_siswa['kelas'][] = $key->nama_kelas;
				$data_siswa['rayon'][] = $rayon['rayon'][$kamar[0]->id_kamar];
				$data_siswa['kamar'][] = $rayon['kamar'][$kamar[0]->id_kamar];
			}

			$data['siswa'] = $data_siswa;
			$data['jumlah_siswa'] = count($siswa_sakit);

			# kirim data penyakit buat edit data
			$data['penyakit'] = $this->m_models->get_data("id_penyakit, nama_penyakit", "penyakit", "where status='ON'");

		}

		# tampilkan data ke view
		$level_user = $this->session->userdata['hak_akses'];
		if ($level_user == '87') {
			$this->load->view('kesehatan/siswa_sakit', $data);
		}else{
			$this->load->view('kesehatan/data_siswa_sakit', $data);
		}
		
		$this->load->view('template/footer');		
	}

	function edit_siswa_sakit(){
		$id_siswa_sakit = $this->input->post('id_siswa_sakit', TRUE);
		$tanggal_sakit = $this->input->post('tanggal_sakit', TRUE);
        $penyakit  = $this->input->post('penyakit', TRUE);
        $keluhan  = $this->input->post('keluhan', TRUE);
        $therapy  = $this->input->post('therapy', TRUE);

 		$data = array (
		    'id_penyakit' => $penyakit,
		    'tanggal_sakit'  => $tanggal_sakit,
		    'keluhan' => $keluhan,
		    'therapy' => $therapy
		);

		# proses simpan
		if ($this->m_models->update_data($id_siswa_sakit, 'id_siswa_sakit', $data, "siswa_sakit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('kesehatan/data_sakit');		
	}

	function hapus_siswa_sakit(){
		$id_siswa_sakit = $this->input->post('id_siswa_sakit', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_siswa_sakit, 'id_siswa_sakit', 'siswa_sakit') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('kesehatan/data_sakit');
	}

	#resume_siswa_sakit
	function resume_siswa_sakit(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
		$pembinaan = $this->input->post('pembinaan', TRUE);

		# kirim kembali data
		$data['pembinaanpilih'] = $pembinaan;
		$data['dari'] = $tgl_dari;
		$data['sampai'] = $tgl_sampai;

		if ($tgl_dari != null AND $tgl_sampai != null) { 

			# cari datakasus penyakit
			for ($i=8; $i <= 13; $i++) { 

				if ($pembinaan=='PutraPutri') {
					$siswa_sakit = $this->m_models->get_data("count(id_siswa_sakit) as jumlah, penyakit.nama_penyakit, kelas.id_tingkatan_kelas", "siswa_sakit", "JOIN penyakit ON siswa_sakit.id_penyakit=penyakit.id_penyakit JOIN kelas ON siswa_sakit.id_kelas=kelas.id_kelas WHERE id_tingkatan_kelas='$i' AND tanggal_sakit >= '$tgl_dari' AND tanggal_sakit <= '$tgl_sampai' GROUP BY penyakit.id_penyakit");
				}else{
					$siswa_sakit = $this->m_models->get_data("count(id_siswa_sakit) as jumlah, penyakit.nama_penyakit, kelas.id_tingkatan_kelas", "siswa_sakit", "JOIN penyakit ON siswa_sakit.id_penyakit=penyakit.id_penyakit JOIN kelas ON siswa_sakit.id_kelas=kelas.id_kelas WHERE id_tingkatan_kelas='$i' AND tanggal_sakit >= '$tgl_dari' AND tanggal_sakit <= '$tgl_sampai' AND pembinaan='$pembinaan' GROUP BY penyakit.id_penyakit");
				}
			
				foreach ($siswa_sakit as $key) {
					$resume[$key->nama_penyakit][$i] = $key->jumlah;
					$jumlah_tmp += $key->jumlah;
				}
			}

			$data['kasus'] = $resume;

			# kirim data penyakit buat edit data
			$data['penyakit'] = $this->m_models->get_data("id_penyakit, nama_penyakit", "penyakit", "where status='ON' ORDER BY nama_penyakit ASC");
		}

		# tampilkan data ke view
		$this->load->view('kesehatan/resume_siswa_sakit', $data);

		$this->load->view('template/footer');		
	}

	#input_sakit
	function data_sakit(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
		$unit = $this->input->post('unit', TRUE);
		$data[unit] = $unit;

		if ($tgl_dari != null AND $tgl_sampai != null) { 
			if ($unit == 'santri' OR $unit == 'stq') {
			//	$rayon = $this->getRayon();
				if ($unit == 'santri') {
					$arrWhere=array('siswa_sakit.tanggal_sakit >='=> $tgl_dari, 'siswa_sakit.tanggal_sakit <='=> $tgl_sampai, 'siswa_sakit.id_sekolah !=' => '7', 'siswa_sakit.id_sekolah !=' => '0');
					# cari data siswa dengan kriteria kondisi arrWhere di atas
					$siswa_sakit = $this->m_models->getJoin4where("siswa_sakit.*, kelas.nama_kelas, penyakit.nama_penyakit, sekolah.nama as sekolah, pegawai.nama as petugas", "siswa_sakit", "kelas", "siswa_sakit.id_kelas=kelas.id_kelas", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", "sekolah", "siswa_sakit.id_sekolah=sekolah.id_sekolah", "pegawai", "siswa_sakit.nrp=pegawai.nrp", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
				}else{ 
					$arrWhere=array('siswa_sakit.tanggal_sakit >='=> $tgl_dari, 'siswa_sakit.tanggal_sakit <='=> $tgl_sampai, 'siswa_sakit.id_sekolah' => '7');
					# cari data siswa dengan kriteria kondisi arrWhere di atas
					$siswa_sakit = $this->m_models->getJoin3where("siswa_sakit.*, penyakit.nama_penyakit, sekolah.nama as sekolah, pegawai.nama as petugas", "siswa_sakit", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", "sekolah", "siswa_sakit.id_sekolah=sekolah.id_sekolah", "pegawai", "siswa_sakit.nrp=pegawai.nrp", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
				}
				
				foreach ($siswa_sakit as $key) {
					$id_siswa = $key->id_siswa;
					$jenjang = db_siswa($id_siswa);

					$siswa = $this->m_models->get_data("nis, nama_lengkap, jk", "siswa_".$jenjang, "WHERE id_siswa='$id_siswa'");
					$kamar = $this->m_models->get_data("id_kamar", "b_kamar_santri", "WHERE id_siswa='$id_siswa' AND id_tahun='$key->id_tahun' ORDER BY masuk DESC ");
					
					$data_siswa['tanggal'][] = $key->tanggal_sakit;
					$data_siswa['id_siswa_sakit'][] = $key->id_siswa_sakit;
					$data_siswa['id_penyakit'][] = $key->id_penyakit;
					$data_siswa['penyakit'][] = $key->nama_penyakit;
					$data_siswa['nis'][] = $siswa[0]->nis;
					$data_siswa['nama'][] = $siswa[0]->nama_lengkap;
					$data_siswa['jk'][] = $siswa[0]->jk;
					$data_siswa['kelas'][] = $key->nama_kelas;
					$data_siswa['sekolah'][] = $key->sekolah;
					$data_siswa['keluhan'][] = $key->keluhan;
					$data_siswa['therapy'][] = $key->therapy;
					$data_siswa['petugas'][] = $key->petugas;
				//	$data_siswa['rayon'][] = $rayon['rayon'][$kamar[0]->id_kamar];
				//	$data_siswa['kamar'][] = $rayon['kamar'][$kamar[0]->id_kamar];
				}

				$data['siswa'] = $data_siswa;
				$data['jumlah_siswa'] = count($siswa_sakit);

			}else{

				$arrWhere=array('siswa_sakit.tanggal_sakit >='=> $tgl_dari, 'siswa_sakit.tanggal_sakit <='=> $tgl_sampai, 'siswa_sakit.id_sekolah' => '0');
				
				# cari data siswa dengan kriteria kondisi arrWhere di atas
				$siswa_sakit = $this->m_models->getJoin2Awhere("siswa_sakit.*, pegawai.nama, pegawai.jk, penyakit.nama_penyakit", "siswa_sakit", "pegawai", "siswa_sakit.id_siswa=pegawai.nrp", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
				foreach ($siswa_sakit as $key) {			
					$data_siswa['tanggal'][] = $key->tanggal_sakit;
					$data_siswa['id_siswa_sakit'][] = $key->id_siswa_sakit;
					$data_siswa['id_penyakit'][] = $key->id_penyakit;
					$data_siswa['penyakit'][] = $key->nama_penyakit;
					$data_siswa['nis'][] = $key->id_siswa;
					$data_siswa['nama'][] = $key->nama;
					$data_siswa['jk'][] = $key->jk;
					$data_siswa['kelas'][] = '';
					$data_siswa['sekolah'][] = 'SDM';
					$data_siswa['keluhan'][] = $key->keluhan;
					$data_siswa['therapy'][] = $key->therapy;
					$data_siswa['petugas'][] = all("pegawai", "nrp", $key->nrp, "nama");
				//	$data_siswa['rayon'][] = $rayon['rayon'][$kamar[0]->id_kamar];
				//	$data_siswa['kamar'][] = $rayon['kamar'][$kamar[0]->id_kamar];
				}

				$data['siswa'] = $data_siswa;
				$data['jumlah_siswa'] = count($siswa_sakit);
			}

			# kirim data penyakit buat edit data
			$data['penyakit'] = $this->m_models->get_data("id_penyakit, nama_penyakit", "penyakit", "where status='ON'");

		}

		# tampilkan data ke view
		$level_user = $this->session->userdata['hak_akses'];
		$arr_level_user = explode("+", $level_user);
		if ( in_array("87", $arr_level_user) ) {
			$this->load->view('kesehatan/data_sakit', $data);
		}else{
			$this->load->view('kesehatan/data_siswa_sakit', $data);
		}
		
		$this->load->view('template/footer');		
	}	

	#resume_siswa_sakit
	function resume_sakit(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);
		$unit = $this->input->post('unit', TRUE);

		# kirim kembali data
		$data['unit'] = $unit;
		$data['dari'] = $tgl_dari;
		$data['sampai'] = $tgl_sampai;

		if ($tgl_dari != null AND $tgl_sampai != null) { 

				if ($unit == 'santri') { 
					$siswa_sakit = $this->m_models->get_data("count(id_siswa_sakit) as jumlah, penyakit.nama_penyakit", "siswa_sakit", "JOIN penyakit ON siswa_sakit.id_penyakit=penyakit.id_penyakit WHERE id_sekolah <> '7' AND id_sekolah != '0' AND tanggal_sakit >= '$tgl_dari' AND tanggal_sakit <= '$tgl_sampai' GROUP BY penyakit.id_penyakit");
				}elseif($unit == 'stq'){
					$siswa_sakit = $this->m_models->get_data("count(id_siswa_sakit) as jumlah, penyakit.nama_penyakit", "siswa_sakit", "JOIN penyakit ON siswa_sakit.id_penyakit=penyakit.id_penyakit WHERE id_sekolah='7' AND tanggal_sakit >= '$tgl_dari' AND tanggal_sakit <= '$tgl_sampai' GROUP BY penyakit.id_penyakit");
				}elseif($unit == 'sdm'){
					$siswa_sakit = $this->m_models->get_data("count(id_siswa_sakit) as jumlah, penyakit.nama_penyakit", "siswa_sakit", "JOIN penyakit ON siswa_sakit.id_penyakit=penyakit.id_penyakit WHERE id_sekolah='0' AND tanggal_sakit >= '$tgl_dari' AND tanggal_sakit <= '$tgl_sampai' GROUP BY penyakit.id_penyakit");
				}elseif($unit == 'semua'){
					$siswa_sakit = $this->m_models->get_data("count(id_siswa_sakit) as jumlah, penyakit.nama_penyakit", "siswa_sakit", "JOIN penyakit ON siswa_sakit.id_penyakit=penyakit.id_penyakit WHERE tanggal_sakit >= '$tgl_dari' AND tanggal_sakit <= '$tgl_sampai' GROUP BY penyakit.id_penyakit");
				}
			
			$data['kasus'] = $siswa_sakit;
		}

		# tampilkan data ke view
		$this->load->view('kesehatan/resume_sakit', $data);

		$this->load->view('template/footer');		
	}

	function cari_data(){
		$this->load->view('template/header');

		# tampilkan data ke view
		$this->load->view('kesehatan/cari_data');

		$this->load->view('template/footer');			
	}

	function getSiswa(){
		$this->load->view('template/head');
		$id_nama = $this->input->get('id_nama'); 
		$unit = $this->input->get('unit'); 
		$data['unit'] = $unit;

		if ($unit == 'sdm') {
			$data['siswa'] = $this->m_models->get_data("nrp, nama, jk, tgl_lhr", "pegawai", "where nama like '%$id_nama%' OR nrp like '%$id_nama%' ORDER BY nama ASC ");
		}else{
			$tabel_siswa = 'siswa_'.strtolower($unit);
			
			$data['siswa'] = $this->m_models->get_data($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".tanggal_lahir", $tabel_siswa, "WHERE nama_lengkap like '%$id_nama%' OR id_siswa like '%$id_nama%' ORDER BY nama_lengkap ASC ");
		}

		$this->load->view('kesehatan/data_cari', $data);
		
		$this->load->view('template/js');
	}

	function getDetail(){
		$this->load->view('template/head');
		$id = $this->input->get('id'); 
		$unit = $this->input->get('unit2'); 
		$data['id'] = $id; 

		if ($unit == 'smp' OR $unit == 'sma') {
			$unit = 'santri';
		}elseif ($unit == 'pt') {
			$unit = 'stq';
		}

		if ($id != null) { 
			if ($unit == 'santri' OR $unit == 'stq') {
				if ($unit == 'santri') {
					$arrWhere=array('siswa_sakit.id_siswa ' => $id);
					# cari data siswa dengan kriteria kondisi arrWhere di atas
					$siswa_sakit = $this->m_models->getJoin4where("siswa_sakit.*, kelas.nama_kelas, penyakit.nama_penyakit, sekolah.nama as sekolah, pegawai.nama as petugas", "siswa_sakit", "kelas", "siswa_sakit.id_kelas=kelas.id_kelas", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", "sekolah", "siswa_sakit.id_sekolah=sekolah.id_sekolah", "pegawai", "siswa_sakit.nrp=pegawai.nrp", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
				}else{ 
					$arrWhere=array('siswa_sakit.id_siswa ' => $id);
					# cari data siswa dengan kriteria kondisi arrWhere di atas
					$siswa_sakit = $this->m_models->getJoin3where("siswa_sakit.*, penyakit.nama_penyakit, sekolah.nama as sekolah, pegawai.nama as petugas", "siswa_sakit", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", "sekolah", "siswa_sakit.id_sekolah=sekolah.id_sekolah", "pegawai", "siswa_sakit.nrp=pegawai.nrp", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
				}
				
				foreach ($siswa_sakit as $key) {
					$id_siswa = $key->id_siswa;
					$jenjang = db_siswa($id_siswa);

					$siswa = $this->m_models->get_data("nis, nama_lengkap, jk", "siswa_".$jenjang, "WHERE id_siswa='$id_siswa'");
					$kamar = $this->m_models->get_data("id_kamar", "b_kamar_santri", "WHERE id_siswa='$id_siswa' AND id_tahun='$key->id_tahun' ORDER BY masuk DESC ");
					
					$data_siswa['tanggal'][] = $key->tanggal_sakit;
					$data_siswa['id_siswa_sakit'][] = $key->id_siswa_sakit;
					$data_siswa['id_penyakit'][] = $key->id_penyakit;
					$data_siswa['penyakit'][] = $key->nama_penyakit;
					$data_siswa['nis'][] = $siswa[0]->nis;
					$data_siswa['nama'][] = $siswa[0]->nama_lengkap;
					$data_siswa['jk'][] = $siswa[0]->jk;
					$data_siswa['kelas'][] = $key->nama_kelas;
					$data_siswa['sekolah'][] = $key->sekolah;
					$data_siswa['keluhan'][] = $key->keluhan;
					$data_siswa['therapy'][] = $key->therapy;
					$data_siswa['petugas'][] = $key->petugas;
				//	$data_siswa['rayon'][] = $rayon['rayon'][$kamar[0]->id_kamar];
				//	$data_siswa['kamar'][] = $rayon['kamar'][$kamar[0]->id_kamar];
				}

				if (count($siswa_sakit)!=0) {
					$data['siswa'] = $data_siswa;
				}
				$data['jumlah_siswa'] = count($siswa_sakit);
				
			}else{

				$arrWhere=array('siswa_sakit.id_siswa' => $id);
				
				# cari data siswa dengan kriteria kondisi arrWhere di atas
				$siswa_sakit = $this->m_models->getJoin2Awhere("siswa_sakit.*, pegawai.nama, pegawai.jk, penyakit.nama_penyakit", "siswa_sakit", "pegawai", "siswa_sakit.id_siswa=pegawai.nrp", "penyakit", "siswa_sakit.id_penyakit=penyakit.id_penyakit", $arrWhere, "siswa_sakit.tanggal_sakit","asc");
				foreach ($siswa_sakit as $key) {			
					$data_siswa['tanggal'][] = $key->tanggal_sakit;
					$data_siswa['id_siswa_sakit'][] = $key->id_siswa_sakit;
					$data_siswa['id_penyakit'][] = $key->id_penyakit;
					$data_siswa['penyakit'][] = $key->nama_penyakit;
					$data_siswa['nis'][] = $key->id_siswa;
					$data_siswa['nama'][] = $key->nama;
					$data_siswa['jk'][] = $key->jk;
					$data_siswa['kelas'][] = '';
					$data_siswa['sekolah'][] = 'SDM';
					$data_siswa['keluhan'][] = $key->keluhan;
					$data_siswa['therapy'][] = $key->therapy;
					$data_siswa['petugas'][] = all("pegawai", "nrp", $key->nrp, "nama");
				//	$data_siswa['rayon'][] = $rayon['rayon'][$kamar[0]->id_kamar];
				//	$data_siswa['kamar'][] = $rayon['kamar'][$kamar[0]->id_kamar];
				}

				if (count($siswa_sakit)!=0) {
					$data['siswa'] = $data_siswa;
				}
				$data['jumlah_siswa'] = count($siswa_sakit);
			}
		}

		$this->load->view('kesehatan/data_detail', $data);
		
		$this->load->view('template/js');
	}
}

?>