<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Jemputan extends CI_Controller {	
	function __construct(){
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	public function input_mobil(){
		$this->load->view('template/header');

        $no_polisi = $this->input->post('no_polisi', TRUE);
        $nama_pemilik = $this->input->post('nama_pemilik', TRUE);
        $alamat = $this->input->post('alamat', TRUE);
        $merk_type = $this->input->post('merk_type', TRUE);
        $jenis_model = $this->input->post('jenis_model', TRUE);
        $thn_pembuatan = $this->input->post('thn_pembuatan', TRUE);
        $thn_perakitan = $this->input->post('thn_perakitan', TRUE);
        $isi_silinder = $this->input->post('isi_silinder', TRUE);
        $warna = $this->input->post('warna', TRUE);
        $nomor_rangka = $this->input->post('nomor_rangka', TRUE);
        $nomor_mesin = $this->input->post('nomor_mesin', TRUE);
        $nomor_bpkb = $this->input->post('nomor_bpkb', TRUE);
        $warna_tnbk = $this->input->post('warna_tnbk', TRUE);
        $bahan_bakar = $this->input->post('bahan_bakar', TRUE);
        $kode_lokasi = $this->input->post('kode_lokasi', TRUE);
        $jml_berat = $this->input->post('jml_berat', TRUE);
        $nomor_pendaftaran = $this->input->post('nomor_pendaftaran', TRUE);
        $berlaku_stnk = date_db($this->input->post('berlaku_stnk', TRUE));
        $berlaku_pajak = date_db($this->input->post('berlaku_pajak', TRUE));

        if (($no_polisi != "") && ($nama_pemilik != "")){
        	$ar_mobil = array('no_polisi'=>$no_polisi, 'alamat' => $alamat, 'status'=>'on', 'nama_pemilik'=>$nama_pemilik, 'merk_type'=>$merk_type, 'jenis_model'=>$jenis_model, 'tahun_pembuatan'=>$thn_pembuatan, 'tahun_perakitan'=>$thn_perakitan, 'isi_silinder'=>$isi_silinder, 'warna'=>$warna, 'nomor_rangka'=>$nomor_rangka, 'nomor_mesin'=>$nomor_mesin, 'nomor_bpkb'=>$nomor_bpkb, 'warna_tnkb'=>$warna_tnbk, 'bahan_bakar'=>$bahan_bakar, 'kode_lokasi'=>$kode_lokasi, 'jml_berat_bolehkan'=>$jml_berat, 'no_pendaftaran'=>$nomor_pendaftaran, 'berlaku_stnk'=>$berlaku_stnk,'berlaku_pajak'=>$berlaku_pajak);
			if ($this->m_models->save_data($ar_mobil, 'jemputan_mobil') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/input_mobil');
        }

		$this->load->view('jemputan/i_mobil');
		$this->load->view('template/footer');
	}

	public function data_mobil(){
		$this->load->view('template/header');

		$data['mobil']=$this->m_models->getTabelOrder("*", "jemputan_mobil", "no_polisi", "asc");

		$this->load->view('jemputan/d_mobil', $data);
		$this->load->view('template/footer');
	}

	public function update_mobil(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_mobil = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_mobil != ""){
			$j_off= array('status'=>$status, 'tgl_off'=>$hariini, 'nrp_off'=>$nrp);
			if ($this->m_models->update_data($id_mobil, "id_mobil", $j_off, "jemputan_mobil") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/data_mobil');
		}
		$this->load->view('template/footer');
	}


	public function input_supir(){
		$this->load->view('template/header');
		$data['provinsi'] = $this->m_models->getTabelOrder("*", "provinsi", "nama", "asc");
        $data['pekerjaan'] = $this->m_models->getTabelOrder("*", "profesi", "nama_profesi", "asc");

        $nik = $this->input->post('nik', TRUE);
        $nama = $this->input->post('nama', TRUE);
        $tmp_lahir = $this->input->post('tmp_lahir', TRUE);
        $tgl_lahir = date_db($this->input->post('tgl_lahir', TRUE));
        $jk = $this->input->post('jk', TRUE);
        $alamat = $this->input->post('alamat', TRUE);
        $rt = $this->input->post('rt', TRUE);
        $rw = $this->input->post('rw', TRUE);
        $prov = $this->input->post('prov', TRUE);
        $desa = $this->input->post('desa', TRUE);
        $kec = $this->input->post('kec', TRUE);
        $kab = $this->input->post('kab', TRUE);
        $kode_pos = $this->input->post('kode_pos', TRUE);
        $gol_darah = $this->input->post('gol_darah', TRUE);
        $agama = $this->input->post('agama', TRUE);
        $status_marital = $this->input->post('status_marital', TRUE);
        $pekerjaan = $this->input->post('pekerjaan', TRUE);
        $warganegara = $this->input->post('warganegara', TRUE);
        $no_hp = $this->input->post('no_hp', TRUE);
        $tinggi = $this->input->post('tinggi', TRUE);
        $no_sim = $this->input->post('no_sim', TRUE);
        $berlaku_sim = $this->input->post('berlaku_sim', TRUE);

        if (($nik != "") && ($nama != "")){
        	$ar_mobil = array('nik'=>$nik, 'nama' => $nama, 'tmp_lahir'=>$tmp_lahir, 'tgl_lahir'=>$tgl_lahir, 'jk'=>$jk, 'alamat'=>$alamat, 'rt'=>$rt, 'rw'=>$rw, 'kel'=>$desa, 'kec'=>$kec, 'kab'=>$kab, 'prov'=>$prov, 'kode_pos'=>$kode_pos, 'gol_darah'=>$gol_darah, 'agama'=>$agama, 'status_marital'=>$status_marital, 'pekerjaan'=>$pekerjaan, 'kewarganegaraan'=>$warganegara, 'no_tlp'=>$no_hp, 'tinggi'=>$tinggi, 'no_sim'=>$no_sim, 'berlaku_sim'=>$berlaku_sim, 'status'=>'on');
			if ($this->m_models->save_data($ar_mobil, 'jemputan_supir') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/input_supir');
        }

		$this->load->view('jemputan/i_supir', $data);
		$this->load->view('template/footer');
	}
	
	public function data_supir(){
		$this->load->view('template/header');

		$data['supir']=$this->m_models->getTabelOrder("*", "jemputan_supir", "nama", "asc");

		$this->load->view('jemputan/d_supir', $data);
		$this->load->view('template/footer');
	}

	public function update_supir(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$nik = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($nik != ""){
			$j_off= array('status'=>$status, 'tgl_off'=>$hariini, 'nrp_off'=>$nrp);
			if ($this->m_models->update_data($nik, "nik", $j_off, "jemputan_supir") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/data_supir');
		}
		$this->load->view('template/footer');
	}


	public function input_jemputan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;

		$as=array('status =' => 'on');
		$data['supir']=$this->m_models->getTabelwhere("*", "jemputan_supir", $as, "nama", "asc");
		$data['mobil']=$this->m_models->getTabelwhere("*", "jemputan_mobil", $as, "no_polisi", "asc");
        $ap=array('status_aktif =' => 'Aktif');
		$data['siswakober'] = $this->m_models->getTabelwhere("*", "siswa_kober", $ap, "nama_lengkap", "asc");
		$data['siswatk'] = $this->m_models->getTabelwhere("*", "siswa_tk", $ap, "nama_lengkap", "asc");
		$data['siswasd'] = $this->m_models->getTabelwhere("*", "siswa_sd", $ap, "nama_lengkap", "asc");

		$jkober = $this->m_models->getRowsWhere("*", "siswa_kober", "status_aktif", 'Aktif', "nama_lengkap", "asc");
		$jtk = $this->m_models->getRowsWhere("*", "siswa_tk", "status_aktif", 'Aktif', "nama_lengkap", "asc");
		$jsd = $this->m_models->getRowsWhere("*", "siswa_sd", "status_aktif", 'Aktif', "nama_lengkap", "asc");

        $nik = $this->input->post('nik', TRUE);
        $id_mobil = $this->input->post('id_mobil', TRUE);
        $kober = $this->input->post('kober', TRUE);
        $tk = $this->input->post('tk', TRUE);
        $sd = $this->input->post('sd', TRUE);

        if (($nik != "") && ($id_mobil != "")){

        	for ($i=0; $i <= $jkober; $i++) { 
        		if ($kober != ""){
        			$d_kober=$kober[$i];
        			if($d_kober != ""){
        				$ar_mobil = array('nik'=>$nik, 'id_mobil' => $id_mobil, 'status'=>'on', 'id_siswa'=>$d_kober, 'nrp_on'=>$nrp, 'id_tahun'=>$id_ta);
	        			$simpan=$this->m_models->save_data($ar_mobil, 'jemputan_master');
        			}
        		}
        	}

        	for ($j=0; $j <= $jtk; $j++) { 
        		if ($tk != ""){
        			$d_tk=$tk[$j];
        			if ($d_tk != ""){
        				$ar_mobil = array('nik'=>$nik, 'id_mobil' => $id_mobil, 'status'=>'on', 'id_siswa'=>$d_tk, 'nrp_on'=>$nrp, 'id_tahun'=>$id_ta);
	        			$simpan=$this->m_models->save_data($ar_mobil, 'jemputan_master');
        			}
        		}
        	}

        	for ($k=0; $k <= $jsd; $k++) { 
        		if ($sd != ""){
        			$d_sd=$sd[$k];
        			if ($d_sd != ""){
        				$ar_mobil = array('nik'=>$nik, 'id_mobil' => $id_mobil, 'status'=>'on', 'id_siswa'=>$d_sd, 'nrp_on'=>$nrp, 'id_tahun'=>$id_ta);
        				$simpan=$this->m_models->save_data($ar_mobil, 'jemputan_master');
        			}
        		}
        	}
        	if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/input_jemputan');
        }

		$this->load->view('jemputan/i_jemputan', $data);
		$this->load->view('template/footer');
	}


	public function data_jemputan(){
		$this->load->view('template/header');
		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik");
	    $data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
	    foreach ($data['tahun'] as $tahun){ 
	    	$data['thn_on']=$tahun->id_tahun;
	    }

		$tahun = $this->input->post('tahun', TRUE);
		$data['tahun']=$tahun;
		if ($tahun != ""){
			$aa=array('id_tahun =' => $tahun);
			$data['jemputan']=$this->m_models->getTabelwhere("*", "jemputan_master", $aa, "nik", "asc");
		}


		$this->load->view('jemputan/d_jemputan', $data);
		$this->load->view('template/footer');
	}

	public function update_m_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_jemputan = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_jemputan != ""){
			$j_off= array('status'=>$status, 'tgl_off'=>$hariini, 'nrp_off'=>$nrp);
			if ($this->m_models->update_data($id_jemputan, "id_jemputan", $j_off, "jemputan_master") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/data_jemputan');
		}
		$this->load->view('template/footer');
	}

	public function setting_jarak(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$as=array('status =' => 'on');
		$data['supir']=$this->m_models->getTabelwhere("*", "jemputan_supir", $as, "nama", "asc");

		$this->load->view('jemputan/set_jarak', $data);
		$this->load->view('template/footer');
	}

	public function ceksupir(){ 
		$nrp=$this->session->userdata['nrp']; 
		$nik = $this->input->get('nik', TRUE); 
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;
		$data['id_tahun']=$id_ta;

		$as=array('nik =' => $nik, 'id_tahun'=>$id_ta, 'status'=>'on');
		$data['m_jemputan']=$this->m_models->getTabelwhere("*", "jemputan_master", $as, "id_siswa", "asc");
		$data['jmptn']=$this->m_models->getRowsAWhere("*", "jemputan_master", $as, "id_siswa", "asc");


		$this->load->view('jemputan/cekjemputan', $data);
	}

	public function simpan_setting_jarak(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$b=date("m");
		$data['bln_now']=$b;

		$id_ta=ta_berjalan();
		$as=array('status =' => 'on', 'id_tahun'=>$id_ta);
		$data['m_jemputan']=$this->m_models->getTabelwhere("*", "master_harga", $as, "id_tahun", "asc");
		$harga=$data['m_jemputan'][0]->nominal;

		$no = $this->input->post('no', TRUE);
		$arr = $this->input->post('arr', TRUE);
		$bln = $this->input->post('bln', TRUE);

		if (($b == "12") && ($bln <= $b)){
			$y=date("Y")-1;
		} else {
			$y=date("Y");
		}

		for ($i=0; $i < $no; $i++){
			$id_jemputan=$arr[$i];
			$jarak = nominalIndo($this->input->post('jarak'.$id_jemputan, TRUE));
			//$hari = nominalIndo($this->input->post('hari'.$id_jemputan, TRUE));
			//$jumlah = ($jarak*$harga)*$hari;
			$jumlah=$jarak*$hari;
			if ($id_jemputan != ""){
				$ar_mobil = array('id_jemputan'=>$id_jemputan, 'jumlah'=>$jarak, 'tgl_input'=>$hariini, 'nrp'=>$nrp, 'id_tahun'=>$id_ta);
				if ($this->m_models->save_data($ar_mobil, 'jemputan_setting') == TRUE) {
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
		}
		redirect('jemputan/setting_jarak');
		$this->load->view('template/footer');
	}

	public function penerimaan_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['thn_on']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thnon']=date("Y");


		$bulan  = $this->input->post('bln', TRUE);
		$thn  = $this->input->post('thn', TRUE); 
		$id_tahun  = $this->input->post('tahun', TRUE); 
		$periode = $thn."-".$bulan."-00";
        $data['bln_pilih'] = $bulan;
        $data['id_tahun']=$id_tahun;
 
		if (($id_tahun != "") && ($bulan != "")){
			$as=array('periode like' => $periode."%", 'jemputan_biaya.id_tahun'=>$id_tahun);
			$data['jemputan']=$this->m_models->getJoin1where("*", "jemputan_biaya", "jemputan_master", "jemputan_master.id_jemputan=jemputan_biaya.id_jemputan", $as, "id_siswa", "asc");

			
			$data['s']=$this->m_models->getTabelOrder("*", "jemputan_supir", "nama", "asc");
			$data['supir']=$this->m_models->getTabelOrder("*", "jemputan_supir", "nama", "asc");
			foreach ($data['supir'] as $spr){ 
				$asj=array('periode like' => $periode."%", 'jemputan_biaya.id_tahun'=>$id_tahun, 'nik'=>$spr->nik);
				$data['jmputan']=$this->m_models->getJoin1where("*", "jemputan_biaya", "jemputan_master", "jemputan_master.id_jemputan=jemputan_biaya.id_jemputan", $asj, "id_siswa", "asc");
				$nominal=0;
				foreach ($data['jmputan'] as $je){
					if ($je->jenis=="¾"){
						$jumlah=$je->harga*0.75;
					} else if ($je->jenis=="½"){
						$jumlah=$je->harga*0.5;
					} else if ($je->jenis=="Full"){
						$jumlah=$je->harga;
					}

					$nominal += $jumlah;
					$data['nominal'][$spr->nik]=$nominal;
				}

				$data['periode']=$periode;
				//pembayaran supir
				$ps=array('id_tahun =' => $id_tahun, 'periode like' => $periode."%", 'nik'=>$spr->nik);
				$data['penerimaan'][$spr->nik]=$this->m_models->getTabelwhere("*", "jemputan_penerimaan_bayar", $ps, "tgl", "asc");
				$data['jpenerimaan'][$spr->nik]=$this->m_models->getRowsAWhere("*", "jemputan_penerimaan_bayar", $ps, "tgl", "asc");
			}
		}		

		$this->load->view('jemputan/penerimaan_jemputan', $data);
		$this->load->view('template/footer');
	}

	public function pembayaran_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		
		/*$tgl  = date_db($this->input->post('tgl', TRUE));
		$bln  = $this->input->post('bln', TRUE);
		$no  = $this->input->post('no', TRUE);
		$id_tahun  = $this->input->post('id_tahun', TRUE);
		$periode  = $this->input->post('periode', TRUE);
		$arr  = $this->input->post('arr', TRUE);
		$tombol  = $this->input->post('tombol', TRUE);


		if (($bln != "")&&($tgl != "")&&($no != "")){
			for ($i=0; $i < $no; $i++){
				$nik=$arr[$i];
				$nominal = $this->input->post('nominal'.$nik, TRUE);
				if ($nik != ""){
					$ar = array('nik'=>$nik, 'tgl' => $tgl, 'periode'=>$periode, 'nominal'=>$nominal, 'petugas'=>$nrp, 'id_tahun'=>$id_tahun);
					if ($this->m_models->save_data($ar, 'jemputan_penerimaan_bayar') == TRUE) {
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}
			if ($tombol=="simpanprint"){
				//redirect('jemputan/print_bukti_pembayaran');
				$this->load->view('jemputan/print_bukti_pembayaran', $data);

			} else if ($tombol=="simpan"){
				redirect('jemputan/pembayaran_jemputan');
			}
			
		}*/

		$this->load->view('jemputan/pembayaran_jemputan', $data);
		$this->load->view('template/footer');
	}

	public function simp_pemb_jemputan(){	
		$nrp=$this->session->userdata['nrp'];	
		$tgl  = date_db($this->input->post('tgl', TRUE));
		$bln  = $this->input->post('bln', TRUE);
		$no  = $this->input->post('no', TRUE);
		$id_tahun  = $this->input->post('id_tahun', TRUE);
		$periode  = $this->input->post('periode', TRUE);
		$arr  = $this->input->post('arr', TRUE);
		$tombol  = $this->input->post('tombol', TRUE);
		$data['periode']=$periode;


		if (($bln != "")&&($tgl != "")&&($no != "")){ echo "$periode";
			for ($i=0; $i < $no; $i++){
				$nik=$arr[$i];
				$nominal = $this->input->post('nominal'.$nik, TRUE);
				if ($nik != ""){
					$ar = array('nik'=>$nik, 'tgl' => $tgl, 'periode'=>$periode."-00", 'nominal'=>$nominal, 'petugas'=>$nrp, 'id_tahun'=>$id_tahun);
					if ($this->m_models->save_data($ar, 'jemputan_penerimaan_bayar') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}
			if ($tombol=="simpanprint"){ 
				//redirect('jemputan/print_bukti_pembayaran');
				$asj=array('periode like' => $periode."%", 'id_tahun'=>$id_tahun, 'petugas'=>$nrp);
				$data['dt_supir']=$this->m_models->getJoin1where("*", "jemputan_penerimaan_bayar", "jemputan_supir", "jemputan_supir.nik=jemputan_penerimaan_bayar.nik", $asj, "nama", "asc");

				$this->load->library('pdf');
				$this->pdf->setPaper("A4", 'portrait');
				$this->pdf->load_view('jemputan/print_bukti_pembayaran', $data);
				$this->pdf->render();
				$this->pdf->stream("print_bukti_pembayaran.pdf", array('Attachment'=>0));

			} else if ($tombol=="simpan"){
				redirect('jemputan/pembayaran_jemputan');
			}
		}
	}

	public function print_bukti_pembayaran(){
		
		$nrp=$this->session->userdata['nrp'];

		$asj=array('periode like' => $periode."%", 'jemputan_biaya.id_tahun'=>$id_tahun, 'nik'=>$nik);
		$data['dt_supir']=$this->m_models->getJoin1where("*", "jemputan_penerimaan_bayar", "jemputan_supir", "jemputan_supir.nik=jemputan_penerimaan_bayar.nik", $asj, "nama", "asc");

		$this->load->library('pdf');
		$this->pdf->setPaper("A4", 'landscape');
		$this->pdf->load_view('jemputan/print_bukti_pembayaran', $data);
		$this->pdf->render();
		$this->pdf->stream("print_bukti_pembayaran.pdf", array('Attachment'=>0));
	}




	public function pemb_supir(){
		$this->load->view('template/js'); 
		$nrp=$this->session->userdata['nrp']; 

		$id_ta=ta_berjalan();
		$data['id_tahun']=$id_ta;
		$bln  = $this->input->get('bln', TRUE); 
		/*$b=date("m");
		if (($b == "12") && ($bln <= $b)){
			$y=date("Y")+1;
		} else {
			$y=date("Y");
		}
		$data['periode']=$y."-".$bln; */
		$data['periode']=cektahun($bln, $id_ta)."-".$bln;

		$as=array('status =' => 'on');
		$data['supir']=$this->m_models->getTabelwhere("*", "jemputan_supir", $as, "nama", "asc");

		$this->load->view('jemputan/pemb_supir', $data);
	}

	public function setting_harga(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$nominal  = db_nominal($this->input->post('nominal', TRUE)); 
		if ($nominal != ""){
			$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
			$id_ta=$data['thn_akademik'][0]->id_tahun;
			$hariini=date("Y-m-d");

			$ar_harga = array('nominal'=>$nominal, 'id_tahun' => $id_ta, 'tgl_input'=>$hariini, 'nrp'=>$nrp, 'jenis'=>"jemputan", 'status'=>'on');
			if ($this->m_models->save_data($ar_harga, 'master_harga') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/setting_harga');
		}
		
		$as=array('jenis =' => 'jemputan');
		$data['set_harga']=$this->m_models->getTabelwhere("*", "master_harga", $as, "id_tahun", "asc");

		$this->load->view('jemputan/set_harga', $data);
		$this->load->view('template/footer');
	}

	public function update_harga(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_harga = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_harga != ""){
			$j_off= array('status'=>$status, 'tgl_off'=>$hariini, 'nrp_off'=>$nrp);
			if ($this->m_models->update_data($id_harga, "id_harga", $j_off, "master_harga") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/setting_harga');
		}
		$this->load->view('template/footer');
	}


	//inputan nominal harga
	public function set_nom_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$as=array('status =' => 'on');
		$data['supir']=$this->m_models->getTabelwhere("*", "jemputan_supir", $as, "nama", "asc");

		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");

		$this->load->view('jemputan/set_nominal_jemputan', $data);
		$this->load->view('template/footer');
	}


	public function ceknomjemputan(){
		$this->load->view('template/js'); 
		$nrp=$this->session->userdata['nrp']; 
		$nik = $this->input->get('nik', TRUE); 
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$id_ta=$data['thn_akademik'][0]->id_tahun;
		$data['id_tahun']=$id_ta;

		$as=array('nik =' => $nik, 'id_tahun'=>$id_ta, 'status'=>'on');
		//$data['m_jemputan']=$this->m_models->getTabelwhere("*", "jemputan_master", $as, "id_siswa", "asc");

		$data['m_jemputan']=$this->m_models->getSpesific("jemputan_master", "nik='$nik' and id_tahun='$id_ta' and status='on' and id_jemputan in (select id_jemputan from jemputan_setting where id_tahun='$id_ta') ");
		$data['jmptn']=$this->m_models->getRowsAWhere("*", "jemputan_master", $as, "id_siswa", "asc");

		foreach ($data['m_jemputan'] as $mj) {
			$a_js=array('id_jemputan =' => $mj->id_jemputan, 'id_tahun'=>$id_ta);
			$data['jemputan_master']=$this->m_models->getTabelwhere("*", "jemputan_setting", $a_js, "id_jemputan", "asc");
			foreach ($data['jemputan_master'] as $jm) {
				$data['harga'][$mj->id_jemputan]=$jm->jumlah;
			}
		}


		$this->load->view('jemputan/ceknomjemputan', $data);
	}

	public function simpan_nom_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$bln = $this->input->post('bln', TRUE);
		$tahun = $this->input->post('tahun', TRUE);
		$nik = $this->input->post('nik', TRUE);
		$no = $this->input->post('no', TRUE);
		$arr = $this->input->post('arr', TRUE);
		$id_ta=ta_berjalan();
		$periode=$tahun."-".$bln."-00";

		for ($i=0; $i < $no; $i++){
			$id_jemputan=$arr[$i];
			$jenis_jemputan = $this->input->post('jenis_jemputan'.$id_jemputan, TRUE);
			$harga = $this->input->post('harga'.$id_jemputan, TRUE); echo "$id_jemputan";
			if ($id_jemputan != ""){
				$ar_mobil = array('id_jemputan'=>$id_jemputan, 'jenis'=>$jenis_jemputan, 'harga'=>$harga, 'periode'=>$periode, 'id_tahun'=>$id_ta, 'nrp'=>$nrp, 'tgl_input'=>$hariini);
				if ($this->m_models->save_data($ar_mobil, 'jemputan_biaya') == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
		}
		redirect('jemputan/set_nom_jemputan');
		$this->load->view('template/footer');
	}


	
	public function biaya_kebersamaan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_ta=ta_berjalan();

		$nominal = nominalIndo($this->input->post('nominal', TRUE));
		if ($nominal != ""){
			$ar_mobil = array('nominal'=>$nominal, 'tgl'=>$hariini, 'nrp'=>$nrp, 'id_tahun'=>$id_ta, 'status'=>'on');
			if ($this->m_models->save_data($ar_mobil, 'jemputan_biayakebersamaan') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/biaya_kebersamaan');
		}
		
		$data['biayabersama']=$this->m_models->getTabelOrder("*", "jemputan_biayakebersamaan", "id_tahun", "asc");

		$this->load->view('jemputan/biayakebersamaan', $data);
		$this->load->view('template/footer');
	}

	
	public function update_biaya_bersama(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$id_bk = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_bk != ""){
			$j_off= array('status'=>$status, 'tgl'=>$hariini, 'nrp'=>$nrp);
			if ($this->m_models->update_data($id_bk, "id_bk", $j_off, "jemputan_biayakebersamaan") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('jemputan/biaya_kebersamaan');
		}
		$this->load->view('template/footer');
	}

	public function lap_tunggakan_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_ta=ta_berjalan();

		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['thn_on']=$data['thn_akademik'][0]->id_tahun;
		$data['supir']=$this->m_models->getTabelOrder("*", "jemputan_supir", "nama", "asc");

		$nik = $this->input->post('nik', TRUE);
		$id_tahun = $this->input->post('tahun', TRUE);
		$data['id_tahun']=$id_tahun;
		$data['nik']=$nik;

		if (($nik == TRUE) and ($id_tahun == TRUE)){
			$as=array('nik =' => $nik, 'id_tahun'=>$id_tahun);
			$data['m_jemputan']=$this->m_models->getTabelGroup("*", "jemputan_master", $as, "id_siswa", "id_siswa", "asc");
		}


		$this->load->view('jemputan/laporan_tunggakan', $data);
		$this->load->view('template/footer');
	}

	public function resume_penerimaan_jemputan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['thn_on']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thnon']=date("Y");

		$bulan  = $this->input->post('bln', TRUE);
		$thn  = $this->input->post('thn', TRUE); 

		$periode = $thn."-".$bulan."-00";
        $data['bln_pilih'] = $bulan;
 
		if (($thn != "") && ($bulan != "")){
			$as=array('periode'=>$periode);
			$data['jemputan']=$this->m_models->getJoin1where("*", "jemputan_penerimaan_bayar", "jemputan_supir", "jemputan_supir.nik=jemputan_penerimaan_bayar.nik", $as, "tgl", "asc");
		}

		$this->load->view('jemputan/resume_penerimaan_jemputan', $data);
		$this->load->view('template/footer');
	}

	#rincian pembayaran jemputan
	public function rincian_pembayaran(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['thn_on']=ta_berjalan();
		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");

		$id_ta  = $this->input->post('tahun', TRUE); 
 
		if ($id_ta != ""){
			$data['id_tahun']=$id_ta;
			$as=array('status =' => 'on');
			$data['supir']=$this->m_models->getTabelwhere("*", "jemputan_supir", $as, "nama", "asc");
		}
		$this->load->view('jemputan/rincian_pembayaran', $data);
		$this->load->view('template/footer');
	}


}