<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Fingerprint extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
	}

	# mengambil data sekolah yang ada simtitisnya
	public function getSekolahSimtitis(){
		$arraywhere=array('sekolah.kategori' => 'Sekolah', 'sekolah.simtitis' => 'Ya');
		return $this->m_models->getJoin1where("sekolah.id_sekolah, sekolah.nama, sekolah.id_jenjang, sekolah.kode_pengenal, sekolah.id_jenjang, jenjang_pendidikan.nama_jenjang", "sekolah","jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", $arraywhere, "id_sekolah", "ASC");
	}

	# mengambil data sekolah yang ada simtitisnya
	public function getSekolah(){
		$arraywhere=array('sekolah.kategori' => 'Sekolah');
		return $this->m_models->getJoin1where("sekolah.id_sekolah, sekolah.nama, sekolah.id_jenjang, sekolah.kode_pengenal, sekolah.id_jenjang, jenjang_pendidikan.nama_jenjang", "sekolah","jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", $arraywhere, "id_sekolah", "ASC");
	}


	  # Master sidik jari
	  public function dup_sidik_jari_siswa(){
		$this->load->view('template/header');
	    # ambil data sekolah
	    $data['sekolah'] = $this->getSekolah();

	    # ambil data dari post input data
	    $sekolah_asal  = $this->input->post('sekolah_asal', TRUE);
	    $sekolah_tujuan  = $this->input->post('sekolah_tujuan', TRUE);

	    # pecah data untuk mendaptakn table siswa dan id_sekolah asal
	    $exp = explode("-", $sekolah_asal);
	    $tabel_siswa_asal = 'siswa_'.strtolower($exp[0]);
	    $kode_sekolah_asal = $exp[1].'%';

	    # pecah data untuk mendaptakn table siswa dan id_sekolah tujuan
	    $exp2 = explode("-", $sekolah_tujuan);
	    $tabel_siswa_tujuan = 'siswa_'.strtolower($exp2[0]);
	    $kode_sekolah_tujuan = $exp2[1].'%';

	    if ($sekolah_asal != null AND $sekolah_tujuan != null) {
	    	# ambil data id siswa sekolah asal diambil dari id siswa tujuan yang mempunyai nis yang sama
	    	$arraywhere=array($tabel_siswa_tujuan.'.status_aktif' => 'Aktif');
			$siswa = $this->m_models->getJoin1where( $tabel_siswa_tujuan.".id_siswa AS id_siswa_tujuan,".$tabel_siswa_asal.".id_siswa AS id_siswa_asal", $tabel_siswa_tujuan, $tabel_siswa_asal, $tabel_siswa_tujuan.".nisn=".$tabel_siswa_asal.".nisn", $arraywhere, $tabel_siswa_tujuan.".id_siswa", "ASC");
			foreach ($siswa as $key) {
				$arr_siswa[$key->id_siswa_tujuan] = $key->id_siswa_asal;
			}

			# ambil data siswa sekolah tujuan yang datanya belum ada di table finger_siswa
			$siswa = $this->m_models->get_data($tabel_siswa_tujuan.".id_siswa,".$tabel_siswa_tujuan.".nama_lengkap", $tabel_siswa_tujuan, "WHERE id_siswa NOT IN ( SELECT id_siswa FROM finger_siswa)");
			//$data[siswa] = $siswa;
			$notif_data = 0;
			foreach ($siswa as $key) {

				$data_finger = $this->m_models->getRowsWhere('user_id', 'finger_siswa', 'id_siswa', $arr_siswa[$key->id_siswa], 'user_id', 'ASC');
				if ($data_finger != 0) {
					$notif_data++;
					
					# ambil data jari sesuai id_siswa_asal
			    	$jari_dulu = $this->m_models->getSpesific("finger_siswa", "id_siswa='".$arr_siswa[$key->id_siswa]."' ORDER BY id_finger DESC LIMIT 1");
			        $user_id = $jari_dulu[0]->user_id;
			        $finger_index = $jari_dulu[0]->finger_index;
			        $finger_template = $jari_dulu[0]->finger_template; 
			   		
			   		# masukan ke dara array untuk di insert ke tabel
			       	$data_jari[$notif_data]['user_id'] = $user_id;
			       	$data_jari[$notif_data]['finger_index'] = $finger_index;
			       	$data_jari[$notif_data]['finger_template'] = $finger_template;
			       	$data_jari[$notif_data]['id_siswa'] = $key->id_siswa;

					# ambil data PHOTO sesuai id_siswa_asal
			      	$user_dulu = $this->m_models->getSpesific("user_finger_siswa", "user_id='".$user_id."' ORDER BY id DESC LIMIT 1");
			       	//$user_id = $user_dulu[0]->user_id;
			       	$user_id_ori = $user_dulu[0]->user_id;
			       	$user_id = $key->id_siswa;
			       	$user_name = $key->nama_lengkap;
			        $photo = $user_dulu[0]->photo;

					# masukan ke dara array untuk di insert ke tabel
					$data_user[$notif_data]['user_id'] = $user_id;
					$data_user[$notif_data]['user_name'] = $user_name;
					$data_user[$notif_data]['photo'] = $photo;

					# masukan ke dara array untuk di insert ke tabel
			        $data_tmp[$notif_data]['user_id'] = $user_id_ori;
			        $data_tmp[$notif_data]['id_siswa'] = $key->id_siswa;

					}
			}

			# proses simpan ke tabel finer_siswa
			$this->m_models->save_batch($data_jari,"finger_siswa");
			# proses simpan ke tabel user_finer_siswa
			$this->m_models->save_batch($data_user,"user_finger_siswa");
			# simpan data ke tabel finger_siswa_tmp
			if ($this->m_models->save_batch($data_tmp,"finger_siswa_tmp") == TRUE) {
		    	$this->session->set_flashdata('sukses', 'Duplikasi Data berhasil disimpan');
		    }else{
		    	$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		    }

			if ($notif_data == 0) {
				$this->session->set_flashdata('tidak_ada', 'Tidak ada data yang di duplikasi !!!');
			}			

	    }
	    # cari data di tabel tmp
		$data['fingerprint'] = $this->m_models->getJoin1('finger_siswa_tmp.id_siswa, user_finger_siswa.user_name', 'finger_siswa_tmp', 'user_finger_siswa', 'finger_siswa_tmp.id_siswa=user_finger_siswa.user_id', 'id_siswa', 'ASC');

	    # tampilkan data ke view
	    $this->load->view('fingerprint/dup_sidik_jari_siswa', $data);
	    $this->load->view('fingerprint/data_duplikasi', $data);

	    $this->load->view('template/footer');
	  }

	public function sidik_jari_siswa(){
		$this->load->view('template/header');

		$data['fingerprint'] = $this->m_models->getJoin1('finger_siswa.id_siswa, user_finger_siswa.user_name', 'finger_siswa', 'user_finger_siswa', 'finger_siswa.id_siswa=user_finger_siswa.user_id', 'id_siswa', 'ASC');

		# tampilkan data ke view
	    $this->load->view('fingerprint/sidik_jari_siswa', $data);
		$this->load->view('template/footer');
	}
}