<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Ekinerja extends CI_Controller {
	function __construct(){
	    error_reporting(0);
		parent::__construct();
        $this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])){
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}
	
	//fungsi untuk lihat data pegawai
	function target_kerja(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['tmulai'] = "02/01/".$thini;
	    $data['tselesai'] = "31/12/".$thini;

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/target_kerja',$data);
		$this->load->view('template/footer');
	}


	// Menyimpan Data Target Kerja
	function simpan_target_kerja(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id_unsur = $this->input->post('id_unsur');
	 	$uraian_tugas = $this->input->post('uraian_tugas');
	 	$ak_dasar = $this->input->post('ak_dasar');
	 	$ak = $this->input->post('ak');
	 	$nilai_kuantitas = $this->input->post('nilai_kuantitas');
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas');
	 	$mutu = $this->input->post('mutu');
	 	$nilai_waktu = $this->input->post('nilai_waktu');
	 	$satuan_waktu = $this->input->post('satuan_waktu');
	 	$biaya = $this->input->post('biaya');
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_target_kerja' =>'',
	 		'nrp'=>$nrp,
	 		'id_unsur'=>$id_unsur,
	 		'uraian_tugas'=>$uraian_tugas,
	 		'ak_dasar'=>$ak_dasar,
	 		'ak'=>$ak,
	 		'nilai_kuantitas'=>$nilai_kuantitas,
	 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
	 		'mutu'=>$mutu,
	 		'nilai_waktu'=>$nilai_waktu, 
	 		'satuan_waktu'=>$satuan_waktu,
	 		'biaya'=>$biaya,
	 		'periode_tahun'=>$periode_tahun,
	 		'tgl_input'=>$tgl_input,
	 		'time_input'=>$time_input
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_target_kerja");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/target_kerja');
	 }


	 //Hapus Target Bulanan
	 function hapus_target_kerja(){
	 	$id_target_kerja=$this->uri->segment(3);
	 	$data['hapus']=$this->m_models->delete_data($id_target_kerja, "id_target_kerja","ekin_target_kerja");



	 	if ($data['hapus'] == TRUE) {
	 		$data['del']=$this->m_models->delete_data($id_target_kerja, "id_target_kerja","ekin_target_bulanan");
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/target_kerja');
	 }

	 // Edit Terget Kerja
	 function edit_target_kerja(){
		$this->load->view('template/header');
		$id_target_kerja=$this->uri->segment(3);

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,id_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,id_satuan_kuantitas,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE id_target_kerja='".$id_target_kerja."'");
		
		$this->load->view('ekinerja/edit_target_kerja',$data);
		$this->load->view('template/footer');
	}

	//Update

	function simpan_edit_targetkerja(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id_unsur = $this->input->post('id_unsur');
	 	$id = $this->input->post('id_target_kerja');
	 	$uraian_tugas = $this->input->post('uraian_tugas');
	 	$ak_dasar = $this->input->post('ak_dasar');
	 	$ak = $this->input->post('ak');
	 	$nilai_kuantitas = $this->input->post('nilai_kuantitas');
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas');
	 	$mutu = $this->input->post('mutu');
	 	$nilai_waktu = $this->input->post('nilai_waktu');
	 	$satuan_waktu = $this->input->post('satuan_waktu');
	 	$biaya = $this->input->post('biaya');
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_unsur'=>$id_unsur,
	 		'uraian_tugas'=>$uraian_tugas,
	 		'ak_dasar'=>$ak_dasar,
	 		'ak'=>$ak,
	 		'nilai_kuantitas'=>$nilai_kuantitas,
	 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
	 		'mutu'=>$mutu,
	 		'nilai_waktu'=>$nilai_waktu, 
	 		'satuan_waktu'=>$satuan_waktu,
	 		'biaya'=>$biaya
	 	);
	 	//update_data($id, $field, $data, $table){

	 	$data['simpan']=$this->m_models->update_data($id,"id_target_kerja",$data,"ekin_target_kerja");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/target_kerja');
	 }

	 // Detail Target Bulanan
	function detail_target_bulanan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    $id = $this->uri->segment(3); 
	    $data['id_target_kerja'] = $id;
	    $nom = $this->uri->segment(4); 
	    $data['nomor'] = $nom;
	    $thini = date("Y");

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $target_kerja = $this->m_models->get_data("id_target_kerja,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE id_target_kerja='".$id."'");

	    foreach ($target_kerja as $tr){
	    	$data['uraian_tugas'] = $tr->uraian_tugas;
	    	$data['ak_dasar'] = $tr->ak_dasar;
	    	$data['ak'] = $tr->ak;
	    	$data['nilai_kuantitas'] = $tr->nilai_kuantitas;
	    	$data['nama_qty'] = $tr->nama_qty;
	    	$data['mutu'] = $tr->mutu;
	    	$data['satuan_waktu'] = $tr->satuan_waktu;
	    	$data['nilai_waktu'] = $tr->nilai_waktu;
	    	$data['biaya'] = $tr->biaya;

	    }

	    // Menampilkan target Bulanan yang telah terisi sebelumnya. Sehingga yang belum diisi tinggal di inputkan saja
	    for($i=1; $i<=12;$i++){
	    	$nbl = array("","01","02","03","04","05","06","07","08","09","10","11","12");
	    	$tahun = all("ekin_target_kerja","id_target_kerja",$id,"periode_tahun");
	    	$kodebul = $nbl[$i];
	    	$period = $tahun."-".$nbl[$i]."-00";
	    	$target_bulan = $this->m_models->get_data("*","ekin_target_bulanan","WHERE nrp='".$nrp."' and id_target_kerja ='".$id."' and periode_bulan='".$period."'");
	    		foreach ($target_bulan as $tbl){
	    			$arr_target[$kodebul][$nrp]['uraian_sub_tugas'] = $tbl->uraian_sub_tugas;
	    			$arr_target[$kodebul][$nrp]['ak_dasar_tb'] = $tbl->ak_dasar_tb;
	    			$arr_target[$kodebul][$nrp]['ak_tb'] = $tbl->ak_tb;
	    			$arr_target[$kodebul][$nrp]['nilai_kuantitas_tb'] = $tbl->nilai_kuantitas_tb;
	    			$arr_target[$kodebul][$nrp]['id_satuan_kuantitas'] = $tbl->id_satuan_kuantitas;
	    			$arr_target[$kodebul][$nrp]['mutu_tb'] = $tbl->mutu_tb;
	    			$arr_target[$kodebul][$nrp]['nilai_waktu_tb'] = $tbl->nilai_waktu_tb;
	    			$arr_target[$kodebul][$nrp]['satuan_waktu_tb'] = $tbl->satuan_waktu_tb;
	    			$arr_target[$kodebul][$nrp]['biaya_tb'] = $tbl->biaya_tb;

	    		}

	    		$data['rtarget'] = $arr_target;
		}
		$this->load->view('ekinerja/detail_target_bulanan',$data);
		$this->load->view('template/footer');
	}


	// Simpan detail tb
function simpan_detail_tb(){
	 	$nrp=$this->session->userdata['nrp'];


	 	$cek = $this->input->post('cek');
	 	$banyak		= count($cek);
	 	$id_target_kerja = $this->input->post('id_target_kerja');
	 	$nomor = $this->input->post('nomor');
	 	
	 	$periode_tahun = all("ekin_target_kerja","id_target_kerja",$id_target_kerja,"periode_tahun");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");

	 for($i=0; $i<$banyak; $i++){

	 	$uraian_sub_tugas = $this->input->post('uraian_sub_tugas'.$cek[$i]);
	 	$ak_dasar_tb = $this->input->post('ak_dasar_tb'.$cek[$i]);
	 	$ak_tb = $this->input->post('ak_tb'.$cek[$i]);
	 	$nilai_kuantitas_tb = $this->input->post('nilai_kuantitas_tb'.$cek[$i]);
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas'.$cek[$i]);
	 	$mutu_tb = $this->input->post('mutu_tb'.$cek[$i]);
	 	$nilai_waktu_tb = $this->input->post('nilai_waktu_tb'.$cek[$i]);
	 	$satuan_waktu_tb = $this->input->post('satuan_waktu_tb'.$cek[$i]);
	 	$biaya_tb = $this->input->post('biaya_tb'.$cek[$i]);

	 	$periode_bulan = $periode_tahun."-".$cek[$i]."-00";

	 	// Menghitung data. Jika data tidak ada sebelumnya maka akan di save. Jika data ada maka akan di update;
	 	$hitung_data = $this->m_models->getRows("ekin_target_bulanan where periode_bulan='".$periode_bulan."' and nrp='".$nrp."' and id_target_kerja='".$id_target_kerja."'");

	 	if($hitung_data==0){
				 	$data=array(
				 		'id_target_bulanan' =>'',
				 		'id_target_kerja'=>$id_target_kerja,
				 		'uraian_sub_tugas'=>$uraian_sub_tugas,
				 		'periode_bulan'=>$periode_bulan,
				 		'ak_dasar_tb'=>$ak_dasar_tb,
				 		'ak_tb'=>$ak_tb,
				 		'nilai_kuantitas_tb'=>$nilai_kuantitas_tb,
				 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
				 		'mutu_tb'=>$mutu_tb,
				 		'nilai_waktu_tb'=>$nilai_waktu_tb, 
				 		'satuan_waktu_tb'=>$satuan_waktu_tb,
				 		'biaya_tb'=>$biaya_tb,
				 		'periode_bulan'=>$periode_bulan,
				 		'nrp'=>$nrp,
				 		'tgl_input_tb'=>$tgl_input,
				 		'time_input_tb'=>$time_input
				 	);
				 	$data['simpan']=$this->m_models->save_data($data,"ekin_target_bulanan");
		} else if ($hitung_data>0){
						//function update_data2($array, $data, $table){
						$uraian_sub_tugas = $this->input->post('uraian_sub_tugas'.$cek[$i]);
					 	$ak_dasar_tb = $this->input->post('ak_dasar_tb'.$cek[$i]);
					 	$ak_tb = $this->input->post('ak_tb'.$cek[$i]);
					 	$nilai_kuantitas_tb = $this->input->post('nilai_kuantitas_tb'.$cek[$i]);
					 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas'.$cek[$i]);
					 	$mutu_tb = $this->input->post('mutu_tb'.$cek[$i]);
					 	$nilai_waktu_tb = $this->input->post('nilai_waktu_tb'.$cek[$i]);
					 	$satuan_waktu_tb = $this->input->post('satuan_waktu_tb'.$cek[$i]);
					 	$biaya_tb = $this->input->post('biaya_tb'.$cek[$i]);

					 	$periode_bulan = $periode_tahun."-".$cek[$i]."-00";


					$arr = array('id_target_kerja'=>$id_target_kerja,'periode_bulan'=>$periode_bulan);
					$data=array(
				 		'uraian_sub_tugas'=>$uraian_sub_tugas,
				 		'periode_bulan'=>$periode_bulan,
				 		'ak_dasar_tb'=>$ak_dasar_tb,
				 		'ak_tb'=>$ak_tb,
				 		'nilai_kuantitas_tb'=>$nilai_kuantitas_tb,
				 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
				 		'mutu_tb'=>$mutu_tb,
				 		'nilai_waktu_tb'=>$nilai_waktu_tb, 
				 		'satuan_waktu_tb'=>$satuan_waktu_tb,
				 		'biaya_tb'=>$biaya_tb
				 	);
				 	$data['simpan']=$this->m_models->update_data2($arr,$data,"ekin_target_bulanan");
		}

	}


	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/detail_target_bulanan/'.$id_target_kerja.'/'.$nomor);
	 }


	 // Menampilkan Hasil Realisasi Kerja Pegawai
	 function realisasi_kerja_jabatan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['thini'] = $thini;
	    $periode_real = $this->input->post("periode_real");
	    $data['pr'] = $periode_real;


	    if($periode_real!=""){
	    	$periode_bl = $this->input->post("periode_bl");
	    	$tahun = $this->input->post("tahun");
	    	$data['bulan'] = $tahun."-".$periode_bl."-00";
	    	$bulan = $tahun."-".$periode_bl."-00";

	    	if($periode_bl==""){

	    // Untuk menampilkan data seluruh nya

	    
	   

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
	   } else if ($periode_bl!=""){
	   	//echo "masuk";
	   		  $data['target_kerja'] = $this->m_models->get_data("id_target_bulanan,uraian_sub_tugas,ak_dasar_tb,ak_tb,nilai_kuantitas_tb,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_bulanan.id_satuan_kuantitas) as nama_qty,mutu_tb,nilai_waktu_tb,satuan_waktu_tb,biaya_tb","ekin_target_bulanan","WHERE nrp='".$nrp."' and periode_bulan='".$bulan."'");


	   }
	}
		
		$this->load->view('ekinerja/realisasi_kerja_jabatan',$data);
		$this->load->view('template/footer');
	}

	 function pilihperiode(){
		$nrp=$this->session->userdata['nrp'];
		$data['periode'] = $this->input->get("periode_real");
		$this->load->view('ekinerja/pilihperiode',$data);
	}

	// Kerja Tambahan
	function realisasi_kerja_tambahan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");

	    // Menampilkan target kerja
	    $data['tugas'] = $this->m_models->get_data("*","ekin_tugas_tambahan","WHERE nrp_input='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/realisasi_kerja_tambahan',$data);
		$this->load->view('template/footer');
	}


	function simpan_rkerja_tambahan(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$uraian_tugas_tambahan = $this->input->post('uraian_tugas_tambahan');
	 	
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_tugas_tambahan' =>'',
	 		'nrp_input'=>$nrp,
	 		'uraian_tugas_tambahan'=>$uraian_tugas_tambahan,
	 		'periode_tahun'=>$periode_tahun,
	 		'tgl_input'=>$tgl_input,
	 		'waktu_input'=>$time_input
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_tugas_tambahan");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/realisasi_kerja_tambahan');
	 }


	 //Hapus Target Bulanan
	 function hapus_rkerja_tambahan(){
	 	$id_tugas_tambahan=$this->uri->segment(3);
	 	$data['hapus']=$this->m_models->delete_data($id_tugas_tambahan, "id_tugas_tambahan","ekin_tugas_tambahan");
	 	if ($data['hapus'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/realisasi_kerja_tambahan');
	 }

	 // Edit Terget Kerja
	 function edit_rkerja_tambahan(){
		$this->load->view('template/header');
		$id_tugas_tambahan=$this->uri->segment(3);


	    // Menampilkan target kerja
	    $data['tugas'] = $this->m_models->get_data("*","ekin_tugas_tambahan","WHERE id_tugas_tambahan='".$id_tugas_tambahan."'");
		
		$this->load->view('ekinerja/edit_rkerja_tambahan',$data);
		$this->load->view('template/footer');
	}

	//Update

	function simpan_edit_rkerja_tambahan(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$uraian_tugas_tambahan = $this->input->post('uraian_tugas_tambahan');
	 	$id = $this->input->post('id_tugas_tambahan');


	 	$data=array(
	 		'uraian_tugas_tambahan'=>$uraian_tugas_tambahan,
	 		
	 	);
	 	//update_data($id, $field, $data, $table){

	 	$data['simpan']=$this->m_models->update_data($id,"id_tugas_tambahan",$data,"ekin_tugas_tambahan");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/realisasi_kerja_tambahan');
	 }


	 // Kerja Tambahan
	function realisasi_kerja_kreativitas(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");

	    // Menampilkan target kerja
	    $data['tugas'] = $this->m_models->get_data("*","ekin_tugas_kreativitas","WHERE nrp_input='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/realisasi_kerja_kreativitas',$data);
		$this->load->view('template/footer');
	}


	function simpan_rkerja_kreativitas(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$uraian_tugas_kreativitas = $this->input->post('uraian_tugas_kreativitas');
	 	
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_tugas_kreativitas' =>'',
	 		'nrp_input'=>$nrp,
	 		'uraian_tugas_tambahan'=>$uraian_tugas_kreativitas,
	 		'periode_tahun'=>$periode_tahun,
	 		'tgl_input'=>$tgl_input,
	 		'waktu_input'=>$time_input
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_tugas_kreativitas");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/realisasi_kerja_kreativitas');
	 }


	 //Hapus Target Bulanan
	 function hapus_rkerja_kreativitas(){
	 	$id_tugas_kreativitas=$this->uri->segment(3);
	 	$data['hapus']=$this->m_models->delete_data($id_tugas_kreativitas, "id_tugas_kreativitas","ekin_tugas_kreativitas");
	 	if ($data['hapus'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/realisasi_kerja_kreativitas');
	 }

	 // Edit Terget Kerja
	 function edit_rkerja_kreativitas(){
		$this->load->view('template/header');
		$id_tugas_tambahan=$this->uri->segment(3);


	    // Menampilkan target kerja
	    $data['tugas'] = $this->m_models->get_data("*","ekin_tugas_kreativitas","WHERE id_tugas_kreativitas='".$id_tugas_kreativitas."'");
		
		$this->load->view('ekinerja/edit_rkerja_kreativitas',$data);
		$this->load->view('template/footer');
	}

	//Update

	function simpan_edit_rkerja_kreativitas(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$uraian_tugas_tambahan = $this->input->post('uraian_tugas_kreativitas');
	 	$id = $this->input->post('id_tugas_kreativitas');


	 	$data=array(
	 		'uraian_tugas_kreativitas'=>$uraian_tugas_kreativitas,
	 		
	 	);
	 	//update_data($id, $field, $data, $table){

	 	$data['simpan']=$this->m_models->update_data($id,"id_tugas_kreativitas",$data,"ekin_tugas_kreativitas");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/realisasi_kerja_kreativitas');
	 }


	 // Aktivitas Kerja

	 function aktivitas_kerja(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$blini = date("m");
		$thini = date("Y");
		if($bulan==""){
			$tg = $thini."-".$blini;
		} else if ($bulan!=""){
			$tg = $tahun."-".$bulan;

		}

	    // Menampilkan target kerja
	    $data['aktva'] = $this->m_models->get_data("*","ekin_m_aktivitas","WHERE status_aktivitas='on'");
	    
	    $data['aktv_kerja'] = $this->m_models->get_data("*","ekin_aktivitas_kerja","WHERE tgl_aktivitas like '".$tg."%'");


	    $data['aktivitas'] = $this->m_models->get_data("*,(SELECT nama_aktivitas from ekin_m_aktivitas where id_m_aktivitas = b.id_m_aktivitas) as nama_aktivitas ","ekin_aktivitas_kerja as b","WHERE tgl_aktivitas like '".$tg."%' and nrp_pengaju='$nrp' order by tgl_aktivitas asc ");

	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");


		
		$this->load->view('ekinerja/aktivitas_kerja',$data);
		$this->load->view('template/footer');
	}

	function getFormAktivitas(){
	//	$this->load->view('template/head');
		$nrp=$this->session->userdata['nrp'];
		$id = $this->input->get('aktivitas'); 
		//echo $id."--abc";
		$data['idk'] = $id;
		$tb = date("Y-m");
		$th = date("Y");
		$data['tugas'] = $this->m_models->get_data("uraian_sub_tugas,id_target_bulanan","ekin_target_bulanan","WHERE periode_bulan like '".$tb."%' and nrp='$nrp' ");
		$data['tambahan'] = $this->m_models->get_data("uraian_tugas_tambahan,id_tugas_tambahan","ekin_tugas_tambahan","WHERE periode_tahun ='".$th."'");

		$this->load->view('ekinerja/form_aktivitas_kerja', $data);
		
	//	$this->load->view('template/js');
	}


	function getFormJabatan(){
	//	$this->load->view('template/head');
		$id = $this->input->get('id_target_bulanan'); 
		
		$data['rincian'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas = ekin_target_bulanan.id_satuan_kuantitas) as nama_satuan","ekin_target_bulanan","WHERE id_target_bulanan='$id'");

		$this->load->view('ekinerja/form_target_bulanan', $data);
		
	//	$this->load->view('template/js');
	}


	function simpan_aktivitas_kerja(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id_m_aktivitas = $this->input->post('aktivitas');
	 	$tgl_aktivitas = $this->input->post('tanggal');
	 	$starttime_aktivitas = $this->input->post('starttime_aktivitas');
	 	$endtime_aktivitas = $this->input->post('endtime_aktivitas');
	 	$uraian_aktivitas = $this->input->post('uraian_aktivitas');
	 	$hasil_aktivitas = $this->input->post('hasil_aktivitas');
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas');
	 	$status_app = "Proses";
	 	$datetime_pengajuan = date ("Y-m-d H:i:s");
	 	$nrp_pengaju = $this->session->userdata['nrp'];
	 	


	 	// Field Tambahan
	 	$periode_tahun_aktivitas = date("Y");
	 	$ak_real = $this->input->post("ak_real");
	 	$nilai_kuantitas_real = $this->input->post("nilai_kuantitas_real");
	 	$mutu_real = $this->input->post("mutu_real");
	 	$biaya_real = $this->input->post("biaya_real");
	 	$lampiran_upload = $this->input->post("lampiran_upload");
	 	$deskripsi_tugas = $this->input->post("deskripsi_tugas");
	 	$manfaat_tugas = $this->input->post("deskripsi_tugas");
	 	$id_tabel_utama = $this->input->post("id_target_bulanan");

	 	if($lampiran_upload !=""){
	 	//setting konfigurasi upload 
        $config['upload_path']   = './dokumen/ekinerja_doc';
        $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|png|jpg|JPG|jpeg|JPEG|PNG';
	   // $config['max_size']       = '5000';
	    $config['max_size']      = '15000000';
	    $tahun = date("Y");
	    $nam = all("pegawai","nrp",$nrp,"nama");
	   	$nama = substr(" ","_",$nam);
	   	$wkt = substr(":","",date("H:i:s"));
	   	$tg = substr("-","",date("Y-m-d"));
	    $config['file_name']       = 'Tugas_Kreativitas_'.$nama.'_'.$wkt.''.$tg;

				       $this->load->library('upload', $config);
			        #foto
			        if (!$this->upload->do_upload('lampiran_upload')){
			            $error = $this->upload->display_errors();
			            print_r($error);
			        } else { 
			            $data_upload = $this->upload->data();
			         }
	 	}



	 	$data=array(
	 		'id_aktivitas' =>'',
	 		'id_m_aktivitas'=>$id_m_aktivitas,
	 		'tgl_aktivitas'=>$tgl_aktivitas,
	 		'starttime_aktivitas'=>$starttime_aktivitas,
	 		'endtime_aktivitas'=>$endtime_aktivitas,
	 		'uraian_aktivitas'=>$uraian_aktivitas,
	 		'hasil_aktivitas'=>$hasil_aktivitas,
	 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
	 		'id_tabel_utama'=>$id_tabel_utama,
	 		'ak_real'=>$ak_real,
	 		'nilai_kuantitas_real'=>$nilai_kuantitas_real,
	 		'mutu_real'=>$mutu_real,
	 		'biaya_real'=>$biaya_real,
	 		'periode_tahun_aktivitas'=>$periode_tahun_aktivitas,
	 		'lampiran_upload'=>$data_upload['file_name'],
	 		'deskripsi_tugas'=>$deskripsi_tugas,
	 		'manfaat_tugas'=>$manfaat_tugas,
	 		'nrp_app'=>'',
	 		'nrp_pengaju'=>$nrp_pengaju,
	 		'status_app'=>$status_app,
	 		'datetime_pengajuan'=>$datetime_pengajuan,
	 		'tgl_app'=>"0000-00-00",
	 		'time_app'=>"00:00:00",
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_aktivitas_kerja");


	 	// Mengupload file jika ada yang harus d upload 



	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/aktivitas_kerja');
	 }



	 // Penilaian Perilaku Kerja

	 function penilaian_perilaku_kerja(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$jabatan=all("pegawai","nrp",$nrp,"id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date ("Y");

	    $periode = $this->input->post("periode");
	    if($periode==""){
	    	$data['periode'] = $thini;
	    	$prd = $thini;
		} else {
			$data['periode'] = $periode;
			$prd = $periode;
		}

	   
	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    $data['pegawai'] = $this->m_models->get_data("nama,nrp,(select nama_jabatan from jabatan where id_jabatan = pegawai.id_jabatan) as nama_jab","pegawai","WHERE status_aktf='Aktif' and id_jabatan in (select id_jabatan from ekin_alur_penilaian where id_jabatan_atasan='$jabatan') ");

			
	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    	foreach ($data['pegawai'] as $pg){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai, count(id_detail_sikap) as skp,tgl_penilaian","ekin_hasil_sikap","WHERE nrp='".$pg->nrp."' and periode_penilaian='".$prd."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$pg->nrp][$asp->id_aspek_sikap] = $n->total_nilai;
					$arr_jdetail[$pg->nrp][$asp->id_aspek_sikap] = $n->skp;
					
					$data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' and tgl_update <= '$n->tgl_penilaian' order by nilai asc");
	    		}
	    		$data['tnilai'] = $arr_total;
				$data['tskp'] = $arr_jdetail;
	  	  }
	    }
	   	



		$this->load->view('ekinerja/penilaian_perilaku_kerja',$data);
		$this->load->view('template/footer');
	}


	function detail_perilaku_kerja(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$nr = $this->uri->segment(3);
		$per = $this->uri->segment(4);
		$jabatan=all("pegawai","nrp",$nrp,"id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date ("Y");

	    $periode = $this->input->post("periode");
	    $id_asp = $this->input->post("id_aspek_sikap");
	    if($periode==""){
	    	$data['periode'] = $thini;
		} else {
			$data['periode'] = $periode;
		}
	   
	    $data['aspek'] = $this->m_models->get_data("nama_aspek_sikap,id_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");
	    $data['nama_peg'] = all("pegawai","nrp",$nr,"nama");
	    $data['nrp'] = $nr;
	   
	    $data['nama_aspek'] = all("ekin_aspek_sikap","id_aspek_sikap",$id_asp,"nama_aspek_sikap");
	    $data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' order by nilai asc");
	    $data['kualitas'] = $this->m_models->get_data("kualitas_nilai,nilai","ekin_konversi_nilai","where status_nilai='on' order by nilai asc");

	    // Menampilkan hasil nilai
	    $data['detail'] = $this->m_models->get_data("nama_detail_sikap,id_detail_sikap,id_aspek_sikap","ekin_detail_aspek_sikap","where status_detail_sikap='on' and id_aspek_sikap='".$id_asp."'");
	    $data['jdetail'] = $this->m_models->getRows("ekin_detail_aspek_sikap where status_detail_sikap='on' and id_aspek_sikap='".$id_asp."'");
	    foreach ($data['detail'] as $det){
	    	$nilai_k = $this->m_models->get_data("jawaban","ekin_hasil_sikap","WHERE nrp='".$nr."' and periode_penilaian='".$per."' and id_detail_sikap='".$det->id_detail_sikap."'");
	    	foreach ($nilai_k as $nk){
	    			$arr_hasil[$nr][$det->id_detail_sikap] = $nk->jawaban;
	    	}
	    		$data['rnilai'] = $arr_hasil;
	    }


	    // Menghitung total nilai
	    $data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai","ekin_hasil_sikap","WHERE nrp='".$nr."' and periode_penilaian='".$per."' and id_aspek_sikap='".$id_asp."'");
	    		foreach ($data['nilai'] as $n){
	    			$data['total'] = $n->total_nilai;

	    			
	    		}

		$this->load->view('ekinerja/detail_perilaku_kerja',$data);
		$this->load->view('template/footer');
	}



	function input_perilaku_kerja(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$nr = $this->uri->segment(3);
		$per = $this->uri->segment(4);
		$jabatan=all("pegawai","nrp",$nrp,"id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date ("Y");

	    $periode = $this->input->post("periode");
	    $id_asp = $this->input->post("id_aspek_sikap");
	    if($periode==""){
	    	$data['periode'] = $thini;
		} else {
			$data['periode'] = $periode;
		}


	   
	    $data['aspek'] = $this->m_models->get_data("nama_aspek_sikap,id_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");
	    $data['nama_peg'] = all("pegawai","nrp",$nr,"nama");
	    $data['nrp'] = $nr;
	   
	    $data['nama_aspek'] = all("ekin_aspek_sikap","id_aspek_sikap",$id_asp,"nama_aspek_sikap");
	    $data['id_asp'] = $id_asp;
	    $data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' order by nilai asc");
	    $data['kualitas'] = $this->m_models->get_data("kualitas_nilai,nilai","ekin_konversi_nilai","where status_nilai='on' order by nilai asc");

	    // Menampilkan hasil nilai
	    $data['detail'] = $this->m_models->get_data("nama_detail_sikap,id_detail_sikap,id_aspek_sikap","ekin_detail_aspek_sikap","where status_detail_sikap='on' and id_aspek_sikap='".$id_asp."'");
	    $data['jdetail'] = $this->m_models->getRows("ekin_detail_aspek_sikap where status_detail_sikap='on' and id_aspek_sikap='".$id_asp."'");
	    foreach ($data['detail'] as $det){
	    			
	    	$nilai_k = $this->m_models->get_data("jawaban","ekin_hasil_sikap","WHERE nrp='".$nr."' and periode_penilaian='".$per."' and id_detail_sikap='".$det->id_detail_sikap."'");
	    	foreach ($nilai_k as $nk){
	    			$arr_hasil[$nr][$det->id_detail_sikap] = $nk->jawaban;
	    	}
	    		$data['rnilai'] = $arr_hasil;
	    }
		$this->load->view('ekinerja/input_perilaku_kerja',$data);
		$this->load->view('template/footer');
	}

function simpan_perilaku_kerja(){
	 	$nrp_penilai=$this->session->userdata['nrp'];


	 	
	 	$periode_tahun = all("ekin_target_kerja","id_target_kerja",$id_target_kerja,"periode_tahun");
	 	$tgl_penilaian = date("Y-m-d");
	 	$time_input = date("H:i:s");

	 
	 	$nr = $this->input->post('nrp');
	 	$id_jabatan = all("pegawai","nrp",$nr,"id_jabatan");
	 	$periode = $this->input->post('periode');
	 	$id_aspek_sikap = $this->input->post('id_aspek_sikap');
	 	

	 $data['detail'] = $data['detail'] = $this->m_models->get_data("nama_detail_sikap,id_detail_sikap,id_aspek_sikap","ekin_detail_aspek_sikap","where status_detail_sikap='on' and id_aspek_sikap='".$id_aspek_sikap."'");
	 foreach ($data['detail'] as $det){

	 	// Menghitung data. Jika data tidak ada sebelumnya maka akan di save. Jika data ada maka akan di update;
	 	$hitung_data = $this->m_models->getRows("ekin_hasil_sikap where periode_penilaian='".$periode."' and nrp='".$nr."' and id_detail_sikap='".$det->id_detail_sikap."'");

	 	$jawaban = $this->input->post("jawaban".$det->id_detail_sikap);

	 	if($hitung_data==0){


				 	$data=array(
				 		'id_hasil_sikap' =>'',
				 		'nrp'=>$nr,
				 		'id_jabatan'=>$id_jabatan,
				 		'periode_penilaian'=>$periode,
				 		'id_detail_sikap'=>$det->id_detail_sikap,
				 		'id_aspek_sikap'=>$id_aspek_sikap,
				 		'jawaban'=>$jawaban,
				 		'nrp_penilai'=>$nrp_penilai,
				 		'tgl_penilaian'=>$tgl_penilaian
				 	);
				 	$data['simpan']=$this->m_models->save_data($data,"ekin_hasil_sikap");

		} else if ($hitung_data>0){
						//function update_data2($array, $data, $table){


					$arr = array('id_detail_sikap'=>$det->id_detail_sikap,'id_aspek_sikap'=>$id_aspek_sikap,'nrp'=>$nr);
					$data=array(
				 		'jawaban'=>$jawaban,
				 		'nrp_penilai'=>$nrp_penilai
				 	);
				 	$data['simpan']=$this->m_models->update_data2($arr,$data,"ekin_hasil_sikap");
		}
	}




	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/input_perilaku_kerja/'.$nr.'/'.$periode);
	 }


	 // Kegiatan Tugas Jabatan
	 function kegiatan_tugas_jabatan(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['tmulai'] = "02/01/".$thini;
	    $data['tselesai'] = "31/12/".$thini;

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/kegiatan_tugas_jabatan',$data);
		$this->load->view('template/footer');
	}


	function simpan_keg_tugasjabatan(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id_unsur = $this->input->post('id_unsur');
	 	$uraian_tugas = $this->input->post('uraian_tugas');
	 	$ak_dasar = $this->input->post('ak_dasar');
	 	$ak = $this->input->post('ak');
	 	$nilai_kuantitas = $this->input->post('nilai_kuantitas');
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas');
	 	$mutu = $this->input->post('mutu');
	 	$nilai_waktu = $this->input->post('nilai_waktu');
	 	$satuan_waktu = $this->input->post('satuan_waktu');
	 	$biaya = $this->input->post('biaya');
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_target_kerja' =>'',
	 		'nrp'=>$nrp,
	 		'id_unsur'=>$id_unsur,
	 		'uraian_tugas'=>$uraian_tugas,
	 		'ak_dasar'=>"0",
	 		'ak'=>$ak,
	 		'nilai_kuantitas'=>$nilai_kuantitas,
	 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
	 		'mutu'=>"0",
	 		'nilai_waktu'=>$nilai_waktu, 
	 		'satuan_waktu'=>$satuan_waktu,
	 		'biaya'=>$biaya,
	 		'periode_tahun'=>$periode_tahun,
	 		'tgl_input'=>$tgl_input,
	 		'time_input'=>$time_input
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_target_kerja");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/kegiatan_tugas_jabatan');
	 }


	 //Hapus Target Bulanan
	 function hapus_keg_tugasjabatan(){
	 	$id_target_kerja=$this->uri->segment(3);
	 	$data['hapus']=$this->m_models->delete_data($id_target_kerja, "id_target_kerja","ekin_target_kerja");



	 	if ($data['hapus'] == TRUE) {
	 		$data['del']=$this->m_models->delete_data($id_target_kerja, "id_target_kerja","ekin_target_bulanan");
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/kegiatan_tugas_jabatan');
	 }

	 // Edit Terget Kerja
	 function edit_keg_tugasjabatan(){
		$this->load->view('template/header');
		$id_target_kerja=$this->uri->segment(3);

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,id_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,id_satuan_kuantitas,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE id_target_kerja='".$id_target_kerja."'");
		
		$this->load->view('ekinerja/edit_keg_tugasjabatan',$data);
		$this->load->view('template/footer');
	}

	//Update

	function simpan_upkeg_tugasjabatan(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id_unsur = $this->input->post('id_unsur');
	 	$id = $this->input->post('id_target_kerja');
	 	$uraian_tugas = $this->input->post('uraian_tugas');
	 	$ak_dasar = $this->input->post('ak_dasar');
	 	$ak = $this->input->post('ak');
	 	$nilai_kuantitas = $this->input->post('nilai_kuantitas');
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas');
	 	$mutu = $this->input->post('mutu');
	 	$nilai_waktu = $this->input->post('nilai_waktu');
	 	$satuan_waktu = $this->input->post('satuan_waktu');
	 	$biaya = $this->input->post('biaya');
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_unsur'=>$id_unsur,
	 		'uraian_tugas'=>$uraian_tugas,
	 		'ak_dasar'=>"0",
	 		'ak'=>$ak,
	 		'nilai_kuantitas'=>$nilai_kuantitas,
	 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
	 		'mutu'=>"0",
	 		'nilai_waktu'=>$nilai_waktu, 
	 		'satuan_waktu'=>$satuan_waktu,
	 		'biaya'=>$biaya
	 	);
	 	//update_data($id, $field, $data, $table){

	 	$data['simpan']=$this->m_models->update_data($id,"id_target_kerja",$data,"ekin_target_kerja");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/kegiatan_tugas_jabatan');
	 }



	  function sasaran_kerja_pegawai(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['tmulai'] = "02/01/".$thini;
	    $data['tselesai'] = "31/12/".$thini;

	    // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }


	    // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jb."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;

	    //cek data
	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");

	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
	    }




	    }
	   


	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/sasaran_kerja_pegawai',$data);
		$this->load->view('template/footer');
	}

	 function print_sasaran_kerja(){
		
		//$nrp=$this->session->userdata['nrp'];
	    //$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    //$thini = date("Y");

	    $nrp=$this->uri->segment(3);
	    $thini=$this->uri->segment(4);
	    $id_sekolah=all("pegawai","nrp",$nrp,"id_sekolah"); 
	    $data['tmulai'] = "02/01/".$thini;
	    $data['tselesai'] = "31/12/".$thini;

	    // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }


	    // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jb."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;

	    //cek data
	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");

	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
	    }

	    }

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/print_sasaran_kerja',$data);
	}


function capaian_skp(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$blini = date("m");
		$thini = date("Y");
		if($tahun==""){
			$tg = $thini;
		} else if ($bulan!=""){
			$tg = $tahun;

		}

	    // Menampilkan target kerja
	    $data['aktva'] = $this->m_models->get_data("*","ekin_m_aktivitas","WHERE status_aktivitas='on'");
	    
	    $data['aktv_kerja'] = $this->m_models->get_data("*","ekin_aktivitas_kerja","WHERE tgl_aktivitas like '".$tg."%'");


	    $data['aktivitas'] = $this->m_models->get_data("*,(SELECT nama_aktivitas from ekin_m_aktivitas where id_m_aktivitas = b.id_m_aktivitas) as nama_aktivitas ","ekin_aktivitas_kerja as b","WHERE periode_tahun_aktivitas =  '".$tg."' and nrp_pengaju='$nrp' order by id_aktivitas asc ");
	    foreach ($data['aktivitas'] as $akt){
	    	$capaian = $this->m_models->get_data("*","ekin_target_kerja"," WHERE id_target_kerja ='".$akt->id_tabel_utama."'");
	    	foreach ($capaian as $cp){
	    		$arr_target[$cp->id_target_kerja]['uraian'] = $cp->uraian_tugas;
	    		$arr_target[$cp->id_target_kerja]['unsur'] = all("ekin_m_unsur","id_unsur",$cp->id_unsur,"nama_unsur");
	    		$arr_target[$cp->id_target_kerja]['ak'] = $cp->ak;
	    		$arr_target[$cp->id_target_kerja]['mutu'] = $cp->ak;
	    		$arr_target[$cp->id_target_kerja]['nilai'] = $cp->nilai_kuantitas;
	    		$arr_target[$cp->id_target_kerja]['satuan_nilai'] = all("ekin_m_satuan_kuantitas","id_satuan_kuantitas",$cp->id_satuan_kuantitas,"nama_satuan_kuantitas");
	    		$arr_target[$cp->id_target_kerja]['nilai_waktu'] = $cp->nilai_waktu;
	    		$arr_target[$cp->id_target_kerja]['satuan_waktu'] = $cp->satuan_waktu;
	    		$arr_target[$cp->id_target_kerja]['biaya'] = $cp->biaya;

	    	}

	    	$data['rendata'] = $arr_target;

	    }



	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");


		
		$this->load->view('ekinerja/capaian_skp',$data);
		$this->load->view('template/footer');
	}


	function simpan_capaian_skp(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id_m_aktivitas = $this->input->post('aktivitas');
	 	$tgl_aktivitas = $this->input->post('tanggal');
	 	$starttime_aktivitas = $this->input->post('starttime_aktivitas');
	 	$endtime_aktivitas = $this->input->post('endtime_aktivitas');
	 	$uraian_aktivitas = $this->input->post('uraian_aktivitas');
	 	$hasil_aktivitas = $this->input->post('hasil_aktivitas');
	 	$id_satuan_kuantitas = $this->input->post('id_satuan_kuantitas');
	 	$status_app = "Proses";
	 	$datetime_pengajuan = date ("Y-m-d H:i:s");
	 	$nrp_pengaju = $this->session->userdata['nrp'];
	 	


	 	// Field Tambahan
	 	$periode_tahun_aktivitas = date("Y");
	 	$ak_real = $this->input->post("ak_real");
	 	$nilai_kuantitas_real = $this->input->post("nilai_kuantitas_real");
	 	$mutu_real = $this->input->post("mutu_real");
	 	$biaya_real = $this->input->post("biaya_real");
	 	$lampiran_upload = $this->input->post("lampiran_upload");
	 	$deskripsi_tugas = $this->input->post("deskripsi_tugas");
	 	$manfaat_tugas = $this->input->post("deskripsi_tugas");
	 	$id_tabel_utama = $this->input->post("id_target_kerja");
	 	$nilai_waktu = $this->input->post("nilai_waktu");
	 	$satuan_waktu = $this->input->post("satuan_waktu");
	 	$id_satuan_kuantitas = $this->input->post("id_satuan_kuantitas");


	 	$data=array(
	 		'id_aktivitas' =>'',
	 		'id_m_aktivitas'=>$id_m_aktivitas,
	 		'tgl_aktivitas'=>"0000-00-00",
	 		'starttime_aktivitas'=>"",
	 		'endtime_aktivitas'=>"",
	 		'uraian_aktivitas'=>"-",
	 		'hasil_aktivitas'=>"-",
	 		'id_satuan_kuantitas'=>$id_satuan_kuantitas,
	 		'id_tabel_utama'=>$id_tabel_utama,
	 		'ak_real'=>$ak_real,
	 		'nilai_kuantitas_real'=>$nilai_kuantitas_real,
	 		'mutu_real'=>$mutu_real,
	 		'nilai_waktu_real'=>$nilai_waktu,
	 		'satuan_waktu_real'=>$satuan_waktu,
	 		'biaya_real'=>$biaya_real,
	 		'periode_tahun_aktivitas'=>$periode_tahun_aktivitas,
	 		'lampiran_upload'=>"-",
	 		'deskripsi_tugas'=>"-",
	 		'manfaat_tugas'=>"-",
	 		'nrp_app'=>'',
	 		'nrp_pengaju'=>$nrp_pengaju,
	 		'status_app'=>$status_app,
	 		'datetime_pengajuan'=>$datetime_pengajuan,
	 		'tgl_app'=>"0000-00-00",
	 		'time_app'=>"00:00:00",
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_aktivitas_kerja");


	 	// Mengupload file jika ada yang harus d upload 



	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/capaian_skp');
	 }


	 function getFormAktivitas2(){
		$nrp=$this->session->userdata['nrp'];
		$id = $this->input->get('aktivitas'); 
		$data['idk'] = $id;
		$tb = date("Y-m");
		$th = date("Y");
		$data['tugas'] = $this->m_models->get_data("uraian_tugas,id_target_kerja","ekin_target_kerja","WHERE periode_tahun ='".$th."' and nrp='$nrp' ");
		$this->load->view('ekinerja/form_capaian_skp', $data);
	}

	function getFormJabatan2(){
		$id = $this->input->get('id_target_kerja'); 
		
		$data['rincian'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas = ekin_target_kerja.id_satuan_kuantitas) as nama_satuan","ekin_target_kerja","WHERE id_target_kerja='$id'");

		$this->load->view('ekinerja/form_target_skp', $data);
	}


	function hapus_capaian_skp(){
    $id=$this->uri->segment(3);
    $data['hapus']=$this->m_models->delete_data($id, "id_peminjaman_aula", "sekdir_peminjaman_aula");

 if ($data['hapus'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data Berhasil Dihapus.');
        }else{
            $this->session->set_flashdata('gagal', 'Data Gagal Dihapus. Silahkan Coba Lagi!!');
        }

    redirect('ekinerja/capaian_skp');
  }



  // Monitor Pegawai
  function monitor_pegawai(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$jabatan=all("pegawai","nrp",$nrp,"id_jabatan");
		$data['idj']=all("pegawai","nrp",$nrp,"id_jabatan");
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date ("Y");

	    $periode = $this->input->post("periode");
	    $div = $this->input->post("jenjang");
	    if($periode==""){
	    	$data['periode'] = $thini;
	    	$prd = $thini;
		} else {
			$data['periode'] = $periode;
			$prd = $periode;
		}


	   
	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");

	  
	    if($div==""){
	    $data['pegawai'] = $this->m_models->get_data("nama,nrp,(select nama_jabatan from jabatan where id_jabatan = pegawai.id_jabatan) as nama_jab","pegawai","WHERE status_aktf='Aktif' and id_jabatan in (select id_jabatan from ekin_alur_penilaian where id_jabatan_atasan='$jabatan') ");
	} else if ($div=="all"){
			$data['pegawai'] = $this->m_models->get_data("nama,nrp,(select nama_jabatan from jabatan where id_jabatan = pegawai.id_jabatan) as nama_jab","pegawai","WHERE status_aktf='Aktif'");
	} else {
			$data['pegawai'] = $this->m_models->get_data("nama,nrp,(select nama_jabatan from jabatan where id_jabatan = pegawai.id_jabatan) as nama_jab","pegawai","WHERE status_aktf='Aktif' and id_sekolah='".$div."'");

	}



	    $data['divisi'] = $this->m_models->get_data("nama,id_sekolah","sekolah","WHERE status_aktif='on'");


	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    	foreach ($data['pegawai'] as $pg){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai","ekin_hasil_sikap","WHERE nrp='".$pg->nrp."' and periode_penilaian='".$prd."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$pg->nrp][$asp->id_aspek_sikap] = $n->total_nilai;

	    			
	    		}
	    		$data['tnilai'] = $arr_total;
	  	  }
	    }
		$this->load->view('ekinerja/monitor_pegawai',$data);
		$this->load->view('template/footer');
	}


	// Validasi Capaian SKP
	function validasi_capaian_skp(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_atasan=all("pegawai","nrp",$nrp,"id_jabatan");
		$data['sekolah_atasan']=all("pegawai","nrp",$nrp,"id_sekolah");
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$blini = date("m");
		$thini = date("Y");
		if($tahun==""){
			$tg = $thini;
		} else if ($bulan!=""){
			$tg = $tahun;

		}

	    // Menampilkan target kerja
	    $data['aktva'] = $this->m_models->get_data("*","ekin_m_aktivitas","WHERE status_aktivitas='on'");
	    
	    $data['aktv_kerja'] = $this->m_models->get_data("*","ekin_aktivitas_kerja","WHERE tgl_aktivitas like '".$tg."%'");

	    $data['aktivitas'] = $this->m_models->get_data("pegawai.id_sekolah,b.*,(SELECT nama_aktivitas from ekin_m_aktivitas where id_m_aktivitas = b.id_m_aktivitas) as nama_aktivitas ","ekin_aktivitas_kerja as b join pegawai on b.nrp_pengaju = pegawai.nrp","WHERE periode_tahun_aktivitas =  '".$tg."' and status_app='Proses' and id_jabatan in (select id_jabatan from ekin_alur_penilaian where id_jabatan_atasan='".$id_atasan."' ) order by id_aktivitas asc ");

	    foreach ($data['aktivitas'] as $akt){
	    	$capaian = $this->m_models->get_data("*","ekin_target_kerja"," WHERE id_target_kerja ='".$akt->id_tabel_utama."'");
	    	foreach ($capaian as $cp){
	    		$arr_target[$cp->id_target_kerja]['uraian'] = $cp->uraian_tugas;
	    		$arr_target[$cp->id_target_kerja]['unsur'] = all("ekin_m_unsur","id_unsur",$cp->id_unsur,"nama_unsur");
	    		$arr_target[$cp->id_target_kerja]['ak'] = $cp->ak;
	    		$arr_target[$cp->id_target_kerja]['mutu'] = $cp->ak;
	    		$arr_target[$cp->id_target_kerja]['nilai'] = $cp->nilai_kuantitas;
	    		$arr_target[$cp->id_target_kerja]['satuan_nilai'] = all("ekin_m_satuan_kuantitas","id_satuan_kuantitas",$cp->id_satuan_kuantitas,"nama_satuan_kuantitas");
	    		$arr_target[$cp->id_target_kerja]['nilai_waktu'] = $cp->nilai_waktu;
	    		$arr_target[$cp->id_target_kerja]['satuan_waktu'] = $cp->satuan_waktu;
	    		$arr_target[$cp->id_target_kerja]['biaya'] = $cp->biaya;
	    	}
	    	$data['rendata'] = $arr_target;
	    }
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");
		$this->load->view('ekinerja/validasi_capaian_skp',$data);
		$this->load->view('template/footer');
	}

	function simpan_validasi_cskp(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$chk = $this->input->post('chk');
	 	$button = $this->input->post('button');


	 	if($button=="Approve"){

	 			$status_app="Ok";
	 	} else if ($button=="Reject"){
	 			$status_app="Koreksi";

	 	}


	 	for ($i=0; $i< count($chk); $i++){
	 		$time_app = date ("H:i:s");
	 		$tgl_app = date ("Y-m-d");
	 		$id = $chk[$i];
	 		$catatan_app = $this->input->post('catatan_aktivitas_'.$id);

	 	$data=array(
	 		'status_app'=>$status_app,
	 		'catatan_app'=>$catatan_app,
	 		'tgl_app'=>$tgl_app,
	 		'nrp_app'=>$nrp,
	 		'time_app'=>$time_app
	 	);

	 	$data['update']=$this->m_models->update_data($id, "id_aktivitas", $data, "ekin_aktivitas_kerja");
	}


	 	if ($data['update'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/validasi_capaian_skp');
	 }



	  function penilaian_capaian_skp(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['thini'] = $thini;
	    $periode_real = $this->input->post("periode_real");
	    $data['pr'] = $periode_real;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {

	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }


	    // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jb."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;

	    //cek data
	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");

	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
	    }




	    }
		
		$this->load->view('ekinerja/penilaian_capaian_skp',$data);
		$this->load->view('template/footer');
	}

	 function catatan_penilaian_perilaku(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['thini'] = $thini;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {

	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    }   
			  


	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai, count(id_detail_sikap) as skp,tgl_penilaian","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
					$arr_jdetail[$pg->nrp][$asp->id_aspek_sikap] = $n->skp;
					
					
					
					$data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' and tgl_update <= '$n->tgl_penilaian' order by nilai asc");
	    		}
	    		$data['tnilai'] = $arr_total;
				$data['tskp'] = $arr_jdetail;
	    }

	    //Mencari data pejabat yang menilai 
	    $tp = $this->m_models->get_data("nrp_penilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' group by nrp");
	    foreach ($tp as $t){
	    //echo $t->nrp_penilai;	
		     $pa = $this->m_models->get_data("nrp,nama","pegawai","WHERE nrp ='".$t->nrp_penilai."'");
				    foreach ($pa as $p){
				    	$data['nama_atasan'] = $p->nama;
				    	$data['nrp_atasan'] = $p->nrp;
			 }
		}
		
		$this->load->view('ekinerja/catatan_penilaian_perilaku',$data);
		$this->load->view('template/footer');
	}

		 function print_catatan_pperilaku(){
		$nrp=$this->uri->segment(3);
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['thini'] = $thini;
	    $tn = $this->uri->segment(4);
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {
	    	$tahun = $this->uri->segment(4); 
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    }   
			  


	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai, count(id_detail_sikap) as skp,tgl_penilaian","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
					$arr_jdetail[$nrp][$asp->id_aspek_sikap] = $n->skp;
					
					$data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' and tgl_update <= '$n->tgl_penilaian' order by nilai asc");
	    		}
	    		$data['tnilai'] = $arr_total;
				$data['tskp'] = $arr_jdetail;
	    }

	    //Mencari data pejabat yang menilai 
	    $tp = $this->m_models->get_data("nrp_penilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' group by nrp");
	    foreach ($tp as $t){
	    //echo $t->nrp_penilai;	
		     $pa = $this->m_models->get_data("nrp,nama","pegawai","WHERE nrp ='".$t->nrp_penilai."'");
				    foreach ($pa as $p){
				    	$data['nama_atasan'] = $p->nama;
				    	$data['nrp_atasan'] = $p->nrp;
			 }
		}
		
		$this->load->view('ekinerja/print_catatan_pperilaku',$data);
	}


	// PENILAIAN PRESTASI KERJA
	function hpenilaian_prestasi_kerja(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['thini'] = $thini;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {

	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }   
			  


	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    		/*$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
	    		}
	    		$data['tnilai'] = $arr_total;*/
				
				$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai, count(id_detail_sikap) as skp,tgl_penilaian","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
					$arr_jdetail[$nrp][$asp->id_aspek_sikap] = $n->skp;
					
					
					$data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' and tgl_update <= '$n->tgl_penilaian' order by nilai asc");
	    		}
	    		$data['tnilai'] = $arr_total;
				$data['tskap'] = $arr_jdetail;
	    }

	    //Mencari data pejabat yang menilai 
	    $tp = $this->m_models->get_data("nrp_penilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' group by nrp");
	    foreach ($tp as $t){
	    //echo $t->nrp_penilai;	
		     $pa = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan,nama,id_sekolah","pegawai as p","WHERE nrp ='".$t->nrp_penilai."'");
				    foreach ($pa as $p){
				    	$id_jbt = $p->id_jabatan;
				    	$id_skl = $p->id_sekolah;
	    	$data['nama_atasan'] = $p->nama;
	    	$data['jabatan_atasan'] = $p->jabatan;
	    	$data['sekolah_atasan'] = $p->nama_unit;
	    	$data['nrp_atasan'] = $p->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$p->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$p->id_golongan,"golongan");
			 }
		}



		// Atasan Pejabat yang menilai
		 // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jbt."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;
		//cek data

	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_skl."'");
	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasanp'] = $pa->nama;
	    	$data['jabatan_atasanp'] = $pa->jabatan;
	    	$data['sekolah_atasanp'] = $pa->nama_unit;
	    	$data['nrp_atasanp'] = $pa->nrp;
	    	$data['pangkat_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_skl."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasanp'] = $pa->nama;
	    	$data['jabatan_atasanp'] = $pa->jabatan;
	    	$data['sekolah_atasanp'] = $pa->nama_unit;
	    	$data['nrp_atasanp'] = $pa->nrp;
	    	$data['pangkat_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
	    }




	    }


		// Menampilkan data tanggapan jika sudah menanggapi
		$data['tanggap'] = $this->m_models->get_data("*","ekin_ajuan_keberatan","WHERE nrp_pengaju='".$nrp."' and tahun_ajuan='".$tahun."'");
		foreach ($data['tanggap'] as $tgp){
			$data['ajuan_keberatan'] = $tgp->ajuan_keberatan;
			$data['tanggapan_atasan'] = $tgp->tanggapan_atasan;
			$data['keputusan_atasan_pejabat'] = $tgp->keputusan_atasan_pejabat;
			$data['keputusan_atasan_pejabat'] = $tgp->keputusan_atasan_pejabat;
			$data['status_tangapan'] = $tgp->status_tanggapan;

		}
		
		$this->load->view('ekinerja/hpenilaian_prestasi_kerja',$data);
		$this->load->view('template/footer');
	}


	function simpan_tanggapan(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$ajuan_keberatan = $this->input->post('keberatan_pegawai');
	 	$nrp_atasan = $this->input->post('nrp_atasan');
	 	$nrp_atasan_pejabat = $this->input->post('nrp_atasan_pejabat');
	 	$tahun = date('Y');


	 	$data=array(
	 		'id_ajuan_keberatan' =>'',
	 		'nrp_pengaju'=>$nrp,
	 		'tgl_ajuan'=>date('Y-m-d'),
	 		'tahun_ajuan'=>$tahun,
	 		'ajuan_keberatan'=>$ajuan_keberatan,
	 		'tanggapan_atasan'=>"",
	 		'status_tanggapan'=>"Proses",
	 		'nrp_atasan'=>$nrp_atasan,
	 		'tgl_tanggapan'=>"0000-00-00",
	 		'keputusan_atasan_pejabat'=>"", 
	 		'status_keputusan'=>"Proses",
	 		'nrp_atasan_pejabat'=>$nrp_atasan_pejabat,
	 		'tgl_keputusan'=>"0000-00-00"
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_ajuan_keberatan");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/hpenilaian_prestasi_kerja');
	 }


	 // Ajuan Keberatan
	 function ajuan_keberatan_penilaian(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_atasan=all("pegawai","nrp",$nrp,"id_jabatan");
		$data['sekolah_atasan']=all("pegawai","nrp",$nrp,"id_sekolah");
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$blini = date("m");
		$thini = date("Y");
		if($tahun==""){
			$tg = $thini;
		} else if ($bulan!=""){
			$tg = $tahun;

		}

	    // Menghitung jumlah 
	    $hitung1 = $this->m_models->getRows("ekin_ajuan_keberatan where nrp_atasan='".$nrp."' and status_tanggapan='Proses' and tahun_ajuan='".$thini."'");

	    if ($hitung1 > 0){
	  		$data['ajuan'] = $this->m_models->get_data("*","ekin_ajuan_keberatan","WHERE status_tanggapan='Proses' and nrp_atasan='".$nrp."'");
	    } else if ($hitung1 == 0){
	    	 $hitung2 = $this->m_models->getRows("ekin_ajuan_keberatan where nrp_atasan_pejabat='".$nrp."' and status_keputusan='Proses' and tahun_ajuan='".$thini."'");
	    	 if($hitung2  > 0){
	    	 	$data['ajuan'] = $this->m_models->get_data("*","ekin_ajuan_keberatan","WHERE status_keputusan='Proses' and nrp_atasan_pejabat='".$nrp."'");

	    	 }

	    }

	   $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");
		$this->load->view('ekinerja/ajuan_keberatan_penilaian',$data);
		$this->load->view('template/footer');
	}




	function simpan_ajuan_keberatan(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$chk = $this->input->post('chk');
	 	$thini = date("Y");


	 	for ($i=0; $i< count($chk); $i++){
	 		$time_app = date ("H:i:s");
	 		$tgl_app = date ("Y-m-d");
	 		$id = $chk[$i];
	 		$catatan_app = $this->input->post('catatan_'.$id);


	 	$hitung1 = $this->m_models->getRows("ekin_ajuan_keberatan where nrp_atasan='".$nrp."' and tahun_ajuan='".$thini."'");

	    if ($hitung1 > 0){
	    	$data=array(
	 		'tanggapan_atasan'=>$catatan_app,
	 		'status_tanggapan'=>"Ya",
	 		'tgl_tanggapan'=>date("Y-m-d")
	 	);

	  		
	    } else if ($hitung1 == 0){
	    	 $hitung2 = $this->m_models->getRows("ekin_ajuan_keberatan where nrp_atasan_pejabat='".$nrp."' tahun_ajuan='".$thini."'");
	    	 if($hitung2  > 0){
	    	 	$data=array(
	 		'keputusan_atasan_pejabat'=>$catatan_app,
	 		'status_keputusan'=>"Ya",
	 		'tgl_keputusan'=>date("Y-m-d")
	 	);


	    	 }

	    }

	 	$data['update']=$this->m_models->update_data($id, "id_ajuan_keberatan", $data, "ekin_ajuan_keberatan");
	}

	 	if ($data['update'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/ajuan_keberatan_penilaian');
	 }


	 // Bab Monitor Pegawai
	 function detail_skp(){
		$this->load->view('template/header');
		//$nrp=$this->session->userdata['nrp'];
		$nrp=$this->uri->segment(3);
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    //$thini = date("Y");
	    $thini = $this->uri->segment(4);
	    $data['tmulai'] = "02/01/".$thini;
	    $data['tselesai'] = "31/12/".$thini;

	    // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }
	    //echo $id_jb."--".$id_sekolah;

	    // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jb."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;

	    //cek data
	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");

	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }




	    }
	   


	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/detail_skp',$data);
		$this->load->view('template/footer');
	}

	 function print_detail_skp(){
		

	    $nrp=$this->uri->segment(3);
	    $thini=$this->uri->segment(4);
	    $id_sekolah=all("pegawai","nrp",$nrp,"id_sekolah"); 
	    $data['tmulai'] = "02/01/".$thini;
	    $data['tselesai'] = "31/12/".$thini;

	    // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }


	    // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jb."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;

	    //cek data
	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");

	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasan'] = $pa->nama;
	    	$data['jabatan_atasan'] = $pa->jabatan;
	    	$data['sekolah_atasan'] = $pa->nama_unit;
	    	$data['nrp_atasan'] = $pa->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
	    }

	    }

	    // Menampilkan jenis
	    $data['unsur'] = $this->m_models->get_data("nama_unsur,id_unsur","ekin_m_unsur","WHERE status_unsur='on'");
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");

	    // Menampilkan target kerja
	    $data['target_kerja'] = $this->m_models->get_data("id_target_kerja,(select nama_unsur from ekin_m_unsur where id_unsur=ekin_target_kerja.id_unsur) as nama_unsur,uraian_tugas,ak_dasar,ak,nilai_kuantitas,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty,mutu,nilai_waktu,satuan_waktu,biaya","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$thini."'");
		
		$this->load->view('ekinerja/print_detail_skp',$data);
	}

	function detail_capaian_skp(){
		$this->load->view('template/header');
		//$nrp=$this->session->userdata['nrp'];
		$nrp=$this->uri->segment(3);
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$blini = date("m");
		//$thini = date("Y");
		$thini = $this->uri->segment(4);
		if($tahun==""){
			$tg = $thini;
		} else if ($bulan!=""){
			$tg = $tahun;

		}
	    // Menampilkan target kerja
	    $data['aktva'] = $this->m_models->get_data("*","ekin_m_aktivitas","WHERE status_aktivitas='on'");
	    $data['aktv_kerja'] = $this->m_models->get_data("*","ekin_aktivitas_kerja","WHERE tgl_aktivitas like '".$tg."%'");


	    $data['aktivitas'] = $this->m_models->get_data("*,(SELECT nama_aktivitas from ekin_m_aktivitas where id_m_aktivitas = b.id_m_aktivitas) as nama_aktivitas ","ekin_aktivitas_kerja as b","WHERE periode_tahun_aktivitas =  '".$tg."' and nrp_pengaju='$nrp' order by id_aktivitas asc ");
	    foreach ($data['aktivitas'] as $akt){
	    	$capaian = $this->m_models->get_data("*","ekin_target_kerja"," WHERE id_target_kerja ='".$akt->id_tabel_utama."'");
	    	foreach ($capaian as $cp){
	    		$arr_target[$cp->id_target_kerja]['uraian'] = $cp->uraian_tugas;
	    		$arr_target[$cp->id_target_kerja]['unsur'] = all("ekin_m_unsur","id_unsur",$cp->id_unsur,"nama_unsur");
	    		$arr_target[$cp->id_target_kerja]['ak'] = $cp->ak;
	    		$arr_target[$cp->id_target_kerja]['mutu'] = $cp->ak;
	    		$arr_target[$cp->id_target_kerja]['nilai'] = $cp->nilai_kuantitas;
	    		$arr_target[$cp->id_target_kerja]['satuan_nilai'] = all("ekin_m_satuan_kuantitas","id_satuan_kuantitas",$cp->id_satuan_kuantitas,"nama_satuan_kuantitas");
	    		$arr_target[$cp->id_target_kerja]['nilai_waktu'] = $cp->nilai_waktu;
	    		$arr_target[$cp->id_target_kerja]['satuan_waktu'] = $cp->satuan_waktu;
	    		$arr_target[$cp->id_target_kerja]['biaya'] = $cp->biaya;
	    	}
	    	$data['rendata'] = $arr_target;
	    }
	    $data['satuan'] = $this->m_models->get_data("nama_satuan_kuantitas,id_satuan_kuantitas","ekin_m_satuan_kuantitas","WHERE status_satuan='on' order by nama_satuan_kuantitas asc");
		$this->load->view('ekinerja/detail_capaian_skp',$data);
		$this->load->view('template/footer');
	}

	 function detail_ncapaian_skp(){
		$this->load->view('template/header');
		//$nrp=$this->session->userdata['nrp'];
		$nrp=$this->uri->segment(3);
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    //$thini = date("Y");
	    $thini = $this->uri->segment(4);
	    $data['thini'] = $thini;
	    $periode_real = $this->input->post("periode_real");
	    $data['pr'] = $periode_real;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {

	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }
	    // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jb."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;

	    //cek data
	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");

	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
		    foreach ($ats as $pa){
		    	$id_jbt = $pa->id_jabatan;
		    	$data['nama_atasan'] = $pa->nama;
		    	$data['jabatan_atasan'] = $pa->jabatan;
		    	$data['sekolah_atasan'] = $pa->nama_unit;
		    	$data['nrp_atasan'] = $pa->nrp;
		    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
		    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
		    }
	    } else if ($cek > 0){
		    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_sekolah."'");
			    foreach ($ats as $pa){
			    	$id_jbt = $pa->id_jabatan;
			    	$data['nama_atasan'] = $pa->nama;
			    	$data['jabatan_atasan'] = $pa->jabatan;
			    	$data['sekolah_atasan'] = $pa->nama_unit;
			    	$data['nrp_atasan'] = $pa->nrp;
			    	$data['pangkat_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
			    	$data['gol_atasan'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
		    }
	    }
		$this->load->view('ekinerja/detail_ncapaian_skp',$data);
		$this->load->view('template/footer');
	}


	function detail_prestasi_kerja(){
		$this->load->view('template/header');
		//$nrp=$this->session->userdata['nrp'];
		$nrp=$this->uri->segment(3);
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	   // $thini = date("Y");
	    $thini = $this->uri->segment(4);
	    $data['thini'] = $thini;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {

	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }   
			  


	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    // Total nilai per aspek
	   /* foreach ($data['aspek'] as $asp){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
	    		}
	    		$data['tnilai'] = $arr_total;
	    }*/
		
		
		foreach ($data['aspek'] as $asp){
	    	//foreach ($data['pegawai'] as $pg){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai, count(id_detail_sikap) as skp,tgl_penilaian","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
					$arr_jdetail[$nrp][$asp->id_aspek_sikap] = $n->skp;
					//echo $n->skp."abc";
					//echo $n->tgl_penilaian."<br>";
					//$data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on' and tgl_update <= '$n->tgl_penilaian' order by nilai asc");
					$data['jskor'] = $this->m_models->getRows("ekin_konversi_nilai where status_nilai='on'  order by nilai asc");
	    		}
	    		$data['tnilai'] = $arr_total;
				$data['tskap'] = $arr_jdetail;
	  	 // }
	    }
		

	    //Mencari data pejabat yang menilai 
	    $tp = $this->m_models->get_data("nrp_penilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' group by nrp");
	    foreach ($tp as $t){
	    //echo $t->nrp_penilai;	
		     $pa = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan,nama,id_sekolah","pegawai as p","WHERE nrp ='".$t->nrp_penilai."'");
				    foreach ($pa as $p){
				    	$id_jbt = $p->id_jabatan;
				    	$id_skl = $p->id_sekolah;
	    	$data['nama_atasan'] = $p->nama;
	    	$data['jabatan_atasan'] = $p->jabatan;
	    	$data['sekolah_atasan'] = $p->nama_unit;
	    	$data['nrp_atasan'] = $p->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$p->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$p->id_golongan,"golongan");
			 }
		}

		// Atasan Pejabat yang menilai
		 // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jbt."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;
		//cek data

	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_skl."'");
	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
		    foreach ($ats as $pa){
		    	$id_jbt = $pa->id_jabatan;
		    	$data['nama_atasanp'] = $pa->nama;
		    	$data['jabatan_atasanp'] = $pa->jabatan;
		    	$data['sekolah_atasanp'] = $pa->nama_unit;
		    	$data['nrp_atasanp'] = $pa->nrp;
		    	$data['pangkat_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
		    	$data['gol_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
		    }
	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_skl."'");
		    foreach ($ats as $pa){
		    	$id_jbt = $pa->id_jabatan;
		    	$data['nama_atasanp'] = $pa->nama;
		    	$data['jabatan_atasanp'] = $pa->jabatan;
		    	$data['sekolah_atasanp'] = $pa->nama_unit;
		    	$data['nrp_atasanp'] = $pa->nrp;
		    	$data['pangkat_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
		    	$data['gol_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
		    }
	    }
		// Menampilkan data tanggapan jika sudah menanggapi
		$data['tanggap'] = $this->m_models->get_data("*","ekin_ajuan_keberatan","WHERE nrp_pengaju='".$nrp."' and tahun_ajuan='".$tahun."'");
		foreach ($data['tanggap'] as $tgp){
			$data['ajuan_keberatan'] = $tgp->ajuan_keberatan;
			$data['tanggapan_atasan'] = $tgp->tanggapan_atasan;
			$data['keputusan_atasan_pejabat'] = $tgp->keputusan_atasan_pejabat;
			$data['keputusan_atasan_pejabat'] = $tgp->keputusan_atasan_pejabat;
			$data['status_tangapan'] = $tgp->status_tanggapan;
		}
		$this->load->view('ekinerja/detail_prestasi_kerja',$data);
		$this->load->view('template/footer');
	}

	function detail_catatan_pperilaku(){
		$this->load->view('template/header');
		//$nrp=$this->session->userdata['nrp'];
		$nrp=$this->uri->segment(3);
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	   // $thini = date("Y");
	    $thini = $this->uri->segment(4);
	    $data['thini'] = $thini;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {
	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    }   
			  


	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
	    		}
	    		$data['tnilai'] = $arr_total;
	    }

	    //Mencari data pejabat yang menilai 
	    $tp = $this->m_models->get_data("nrp_penilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' group by nrp");
	    foreach ($tp as $t){
	    //echo $t->nrp_penilai;	
		     $pa = $this->m_models->get_data("nrp,nama","pegawai","WHERE nrp ='".$t->nrp_penilai."'");
				    foreach ($pa as $p){
				    	$data['nama_atasan'] = $p->nama;
				    	$data['nrp_atasan'] = $p->nrp;
			 }
		}
		
		$this->load->view('ekinerja/detail_catatan_pperilaku',$data);
		$this->load->view('template/footer');
	}
	
	
	# MASTER TUGAS DIVISI #
	public function input_tugas(){
		$nama = $this->input->post('nama');
		$keterangan = $this->input->post('keterangan');
		
		/*if (($nama != "") && ($keterangan != "")){
			$this->db->query("INSERT INTO jabatan VALUES ('', '$nama', '$keterangan','ON')") or die (mysql_error());
			$data['jabatan'] = $this->m_models->getAll('jabatan');
			//$this->load->view('master/jabatan',$data);
			redirect('admin/jabatan');
		} else {
			$data['jabatan'] = $this->m_models->getAll('jabatan');
			$this->load->view('master/jabatan',$data);
		}*/
		
		$this->load->view('ekinerja/input_tugas',$data);
		$this->load->view('template/footer');
	}
	
	public function upload_tugas(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$skl=$this->m_models->getSession($nrp, "id_sekolah");
		$data['unsur'] = $this->m_models->get_data("*","ekin_m_unsur","where status_unsur='on' order by nama_unsur asc");
		if($jabatan=="24"){
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' order by nama_jabatan asc");
		} else {
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' and id_sekolah='$skl' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' and jabatan in (select id_jabatan from pegawai where id_sekolah='$skl') order by nama_jabatan asc");
		}
		
		$this->load->view('ekinerja/upload_tugas',$data);
		$this->load->view('template/footer');
	}
	
	public function edit_tugas(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$skl=$this->m_models->getSession($nrp, "id_sekolah");
		$id=$this->uri->segment(3);
		
		$data['dtg'] = $this->m_models->get_data("*","ekin_m_tugas"," where id_m_tugas='$id'");
		$data['unsur'] = $this->m_models->get_data("*","ekin_m_unsur","where status_unsur='on' order by nama_unsur asc");
		if($jabatan=="24"){
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' order by nama_jabatan asc");
		} else {
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' and id_sekolah='$skl' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' and jabatan in (select id_jabatan from pegawai where id_sekolah='$skl') order by nama_jabatan asc");
		}
		
		$this->load->view('ekinerja/edit_tugas',$data);
		$this->load->view('template/footer');
	}
	
	
	// Save Master Tugas
	public function save_master_tugas(){

	  $ar = $this->session->userdata['nrp'];
	$idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		$fileName = $_FILES['file']['name'];

        $config['upload_path'] = './assets/'; //buat folder dengan nama assets di root folder

        $config['file_name'] = $fileName;

        $config['allowed_types'] = 'xls|xlsx|csv';

        $config['max_size'] = 10000;


        $this->load->library('upload');
        $this->upload->initialize($config);
         
        if(! $this->upload->do_upload('file') )
        $this->upload->display_errors();
             
        $media = $this->upload->data('file');
        //$inputFileName = './assets/'.$media['file_name'];

       $nama_file = str_replace (" ","_",$config['file_name']);
		
		
		//replace data
		
		//$inputFileName = './assets/'.$config['file_name'];

		$inputFileName = './assets/'.$nama_file;
        try {
                $inputFileType = IOFactory::identify($inputFileName);
                $objReader = IOFactory::createReader($inputFileType);
                $objPHPExcel = $objReader->load($inputFileName);
            } catch(Exception $e) {
                die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
            }
 
            $sheet = $objPHPExcel->getSheet(0);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 

                $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL, TRUE, FALSE);

				$nama_tugas = $rowData[0][1];
				$angka_kredit = $rowData[0][2];
				$kuantitas = $rowData[0][3];
				$satuan_kuant = $rowData[0][4];
				$kualitas_mutu = $rowData[0][5];
				$waktu = $rowData[0][6];
				$satuan_waktu = $rowData[0][7];
				$biaya = $rowData[0][8];

				$id_divisi = $this->input->post('id_divisi');
				$id_jabatan = $this->input->post('id_jabatan');
				$id_unsur = $this->input->post('id_unsur');

				$tgl = date("Y-m-d");
				 $ntugas=array(
			    'id_m_tugas' => '',
			    'nama_tugas' => $nama_tugas,
				 'id_unsur' => $id_unsur,
			    'angka_kredit' => $angka_kredit,
			    'kuantitas' => $kuantitas,
			    'satuan_kuant' => $satuan_kuant,
				'kualitas_mutu' => $kualitas_mutu,
				'waktu' => $waktu,
				'satuan_waktu' => $satuan_waktu,
				'biaya' => $biaya,
				'id_sekolah' => $id_divisi,
				'id_jabatan' => $id_jabatan,
			    'nrp_upload' => $ar,
				'tgl_upload' => $tgl,
				'status_mt' => 'on',
				'tgl_in' => date("Y-m-d H:i:s")
				);
				$simpan_ntugas = $this->db->insert("ekin_m_tugas",$ntugas);
				//Menyimpan data riwayat sekolah
				unlink($inputFileName);
            }
	
			 if( $simpan_ntugas >= 1) { 
         echo $this->session->set_flashdata('sukses', 'Data Berhasil Diupload');
        } else {
            echo $this->session->set_flashdata('gagal', 'Data Gagal Diupload !');
        }	
        redirect('ekinerja/upload_tugas');
    }
	
	function save_emaster_tugas(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$id = $this->input->post('id_m_tugas');
		$id_unsur = $this->input->post('id_unsur');
		$id_sekolah = $this->input->post('id_divisi');
		$id_jabatan = $this->input->post('id_jabatan');
	 	$nama_tugas = $this->input->post('nama_tugas');
	 	$angka_kredit = $this->input->post('angka_kredit');
	 	$kuantitas = $this->input->post('kuantitas');
	 	$satuan_kuant = $this->input->post('satuan_kuant');
		$kualitas_mutu = $this->input->post('kualitas_mutu');
		$waktu = $this->input->post('waktu');
		$satuan_waktu = $this->input->post('satuan_waktu');
		$biaya = $this->input->post('biaya');
	 	
	 	$periode_tahun = date("Y");
	 	$tgl_input = date("Y-m-d");
	 	$time_input = date("H:i:s");


	 	$data=array(
	 		'id_unsur'=>$id_unsur,
	 		'nama_tugas'=>$nama_tugas,
			'id_sekolah'=>$id_sekolah,
			'id_jabatan'=>$id_jabatan,
	 		'angka_kredit'=>$angka_kredit,
	 		'kuantitas'=>$kuantitas,
	 		'satuan_kuant'=>$satuan_kuant,
	 		'kualitas_mutu'=>$kualitas_mutu,
	 		'waktu'=>$waktu,
	 		'satuan_waktu'=>$satuan_waktu,
	 		'biaya'=>$biaya
	 	);
	 	//update_data($id, $field, $data, $table){

	 	$data['simpan']=$this->m_models->update_data($id,"id_m_tugas",$data,"ekin_m_tugas");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/data_tugas');
	 }
	
	
	public function data_tugas(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$skl=$this->m_models->getSession($nrp, "id_sekolah");
		$data['unsur'] = $this->m_models->get_data("*","ekin_m_unsur","where status_unsur='on' order by nama_unsur asc");
		if($jabatan=="24"){
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' order by nama asc");
		} else {
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' and id_sekolah='$skl' order by nama asc");
		}
		
		
		$idsekol = $this->input->post("idsekol");
		
		if($idsekol!=""){
			
			$data['tugas'] = $this->m_models->get_data("*","ekin_m_tugas","order by nama_tugas asc");			
		}
		
		$this->load->view('ekinerja/data_tugas',$data);
		$this->load->view('template/footer');
	}
	
	
	# ASPEK PERILAKU KERJA #
	public function aspek_perilaku_kerja(){
		$nama_aspek = $this->input->post('nama_aspek');
		
		
		if (($nama_aspek != "")){
			$this->db->query("INSERT INTO ekin_aspek_sikap VALUES ('', '$nama_aspek', 'on')") or die (mysql_error());
			$data['eskp'] = $this->m_models->getAll('ekin_aspek_sikap order by nama_aspek asc');
			//$this->load->view('master/jabatan',$data);
			redirect('ekinerja/aspek_perilaku_kerja');
		} else {
			$data['eskp'] = $this->m_models->getAll('ekin_aspek_sikap order by nama_aspek_sikap asc');
			$this->load->view('ekinerja/aspek_perilaku_kerja',$data);
		}
	}
	
	function simpan_aspek_perilaku_kerja(){
	 	$nrp=$this->session->userdata['nrp'];
	 	$nama = $this->input->post('nama');
	 	


	 	$data=array(
	 		'id_aspek_sikap' =>'',
	 		'nama_aspek_sikap'=>$nama,
	 		'status_aspek_sikap'=>'on'
	 		
	 	);

	 	$data['simpan']=$this->m_models->save_data($data,"ekin_aspek_sikap");
	 	if ($data['simpan'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/aspek_perilaku_kerja');
	 }


	// Update Status Jabatan
	public function update_aspekp(){
		$id = $this->uri->segment(3);

		$status = all("ekin_aspek_sikap","id_aspek_sikap",$id,"status_aspek_sikap");
		if($status=="on"){
			$stts="off";
		} else if ($status=="off") {
			$stts="on";
		}

		$njabatan=array(
			  'status_aspek_sikap' => $stts);
			  $data['simpan_status'] = $this->m_models->update_data($id,"id_aspek_sikap",$njabatan, "ekin_aspek_sikap");
		


		if ($data['simpan_status'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
      redirect('ekinerja/aspek_perilaku_kerja');
	}
	
	
	# HAPUS TUGAS #
	 function hapus_tugas(){
	 	$id=$this->uri->segment(3);
	 	$data['hapus']=$this->m_models->delete_data($id, "id_m_tugas","ekin_m_tugas");
	 	if ($data['hapus'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/data_tugas');
	 }

	
	
	
	# INDIKATOR PERILAKU #
	public function upload_indikator_perilaku(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$skl=$this->m_models->getSession($nrp, "id_sekolah");
		$data['asp'] = $this->m_models->get_data("*","ekin_aspek_sikap","where status_aspek_sikap='on'");
		$data['unsur'] = $this->m_models->get_data("*","ekin_m_unsur","where status_unsur='on' order by nama_unsur asc");
		if($jabatan=="24"){
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' order by nama_jabatan asc");
		} else {
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' and id_sekolah='$skl' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' and jabatan in (select id_jabatan from pegawai where id_sekolah='$skl') order by nama_jabatan asc");
		}
		
		$this->load->view('ekinerja/upload_indikator_perilaku',$data);
		$this->load->view('template/footer');
	}
	
	public function save_master_indikatorperilaku(){

	  $ar = $this->session->userdata['nrp'];
	$idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		$fileName = $_FILES['file']['name'];

        $config['upload_path'] = './assets/'; //buat folder dengan nama assets di root folder

        $config['file_name'] = $fileName;

        $config['allowed_types'] = 'xls|xlsx|csv';

        $config['max_size'] = 10000;


        $this->load->library('upload');
        $this->upload->initialize($config);
         
        if(! $this->upload->do_upload('file') )
        $this->upload->display_errors();
             
        $media = $this->upload->data('file');
        //$inputFileName = './assets/'.$media['file_name'];

       $nama_file = str_replace (" ","_",$config['file_name']);
		
		
		//replace data
		
		//$inputFileName = './assets/'.$config['file_name'];

		$inputFileName = './assets/'.$nama_file;
        try {
                $inputFileType = IOFactory::identify($inputFileName);
                $objReader = IOFactory::createReader($inputFileType);
                $objPHPExcel = $objReader->load($inputFileName);
            } catch(Exception $e) {
                die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
            }
 
            $sheet = $objPHPExcel->getSheet(0);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = $sheet->getHighestColumn();
            for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 

                $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL, TRUE, FALSE);

				$nama_detail_sikap = $rowData[0][1];
				$id_aspek_sikap = $rowData[0][2];
				

				$id_divisi = $this->input->post('id_divisi');
				$id_jabatan = $this->input->post('id_jabatan');
				$id_unsur = $this->input->post('id_unsur');

				$tgl = date("Y-m-d");
				 $ntugas=array(
			    'id_detail_sikap' => '',
			    'id_aspek_sikap' => $id_aspek_sikap,
				 'nama_detail_sikap' => $nama_detail_sikap,
				'id_sekolah' => $id_divisi,
				'id_jabatan' => $id_jabatan,
			    'nrp_upload' => $ar,
				'tanggal_upload' => $tgl,
				'status_detail_sikap' => 'on'
				);
				$simpan_ntugas = $this->db->insert("ekin_detail_aspek_sikap",$ntugas);
				//Menyimpan data riwayat sekolah
				unlink($inputFileName);
            }
	
			 if( $simpan_ntugas >= 1) { 
         echo $this->session->set_flashdata('sukses', 'Data Berhasil Diupload');
        } else {
            echo $this->session->set_flashdata('gagal', 'Data Gagal Diupload !');
        }	
        redirect('ekinerja/upload_indikator_perilaku');
    }
	
	public function data_indikator_perilaku(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$skl=$this->m_models->getSession($nrp, "id_sekolah");
		$data['unsur'] = $this->m_models->get_data("*","ekin_m_unsur","where status_unsur='on' order by nama_unsur asc");
		if($jabatan=="24"){
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' order by nama asc");
		} else {
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' and id_sekolah='$skl' order by nama asc");
		}
		
		
		$idsekol = $this->input->post("idsekol");
		
		if($idsekol!=""){
			
			$data['tugas'] = $this->m_models->get_data("*","ekin_detail_aspek_sikap","order by id_aspek_sikap asc");			
		}
		
		$this->load->view('ekinerja/data_indikator_perilaku',$data);
		$this->load->view('template/footer');
	}
	
	
	# HAPUS TUGAS #
	 function hapus_indikator(){
	 	$id=$this->uri->segment(3);
	 	$data['hapus']=$this->m_models->delete_data($id, "id_detail_sikap","ekin_detail_aspek_sikap");
	 	if ($data['hapus'] == TRUE) {
            $this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
            $this->session->set_flashdata('gagal', 'Data Sudah Tersedia. Silahkan Cek Kembali !!!');
        }
		redirect('ekinerja/data_indikator_perilaku');
	 }
	 
	 
	 #CETAK#
	 function print_catatan_hprestasi(){
		$nrp=$this->session->userdata['nrp'];
		$data['nrp'] = $nrp;
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
	    $thini = date("Y");
	    $data['thini'] = $thini;	
	    //$data['tahun'] = $this->input->post('tahun');
	    $tn = $this->input->post('tahun');
	    if($tn==""){
	    	$tahun=date(Y);
	    	$data['tahun'] = $tahun;
	    } else {

	    	$tahun = $this->input->post('tahun');
	    	$data['tahun'] = $tahun;
	    }


	$data['target_kerja'] = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_target_kerja.id_satuan_kuantitas) as nama_qty","ekin_target_kerja","WHERE nrp='".$nrp."' and periode_tahun='".$tahun."' order by id_unsur asc");

	// Menampilkan realisasi
	foreach ($data['target_kerja'] as $tk){
		$real = $this->m_models->get_data("*,(select nama_satuan_kuantitas from ekin_m_satuan_kuantitas where id_satuan_kuantitas=ekin_aktivitas_kerja.id_satuan_kuantitas) as nama_qty","ekin_aktivitas_kerja","WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");

		$jm = $this->m_models->getRows("ekin_aktivitas_kerja WHERE id_tabel_utama='".$tk->id_target_kerja."' and status_app='Ok'");
		foreach ($real as $r){

			//echo $r->nilai_waktu_real."--";
			  $arr_real[$tk->id_target_kerja]['ak'] = $r->ak_real;
			  $arr_real[$tk->id_target_kerja]['nilai_qty'] = $r->nilai_kuantitas_real;
			  $arr_real[$tk->id_target_kerja]['mutu'] = $r->mutu_real;
			  $arr_real[$tk->id_target_kerja]['biaya'] = $r->biaya_real;
			  $arr_real[$tk->id_target_kerja]['satuan_waktu'] = $r->satuan_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nilai_waktu'] = $r->nilai_waktu_real;
			  $arr_real[$tk->id_target_kerja]['nama_qty'] = $r->nama_qty;
			  $arr_real[$tk->id_target_kerja]['jmlh'] = $jm;

		}
		$data['real'] = $arr_real;
	}

	$data['jmlh']= $this->m_models->getRows("ekin_aktivitas_kerja WHERE nrp_pengaju='".$nrp."' and status_app='Ok' and periode_tahun_aktivitas='".$tahun."' group by id_tabel_utama");


	  // Identitas pegawai yang di nilai
	    $peg = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE nrp='".$nrp."'");
	    foreach ($peg as $pg){
	    	$id_jb = $pg->id_jabatan;
	    	$data['nama_pegawai'] = $pg->nama;
	    	$data['jabatan'] = $pg->jabatan;
	    	$data['sekolah'] = $pg->nama_unit;
	    	$data['nrp'] = $pg->nrp;
	    	$data['pangkat'] = all("golongan","id_golongan",$pg->id_golongan,"pangkat");
	    	$data['gol'] = all("golongan","id_golongan",$pg->id_golongan,"golongan");
	    }   
			  


	    $data['jml'] = $this->m_models->getRows("ekin_aspek_sikap where status_aspek_sikap='on'");
	    $data['aspek'] = $this->m_models->get_data("id_aspek_sikap,nama_aspek_sikap","ekin_aspek_sikap","WHERE status_aspek_sikap='on'");


	    // Total nilai per aspek
	    foreach ($data['aspek'] as $asp){
	    		$data['nilai'] =  $this->m_models->get_data("sum(jawaban) as total_nilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' and id_aspek_sikap='".$asp->id_aspek_sikap."'");
	    		foreach ($data['nilai'] as $n){
	    			$arr_total[$nrp][$asp->id_aspek_sikap] = $n->total_nilai;
	    		}
	    		$data['tnilai'] = $arr_total;
	    }

	    //Mencari data pejabat yang menilai 
	    $tp = $this->m_models->get_data("nrp_penilai","ekin_hasil_sikap","WHERE nrp='".$nrp."' and periode_penilaian='".$tahun."' group by nrp");
	    foreach ($tp as $t){
	    //echo $t->nrp_penilai;	
		     $pa = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan,nama,id_sekolah","pegawai as p","WHERE nrp ='".$t->nrp_penilai."'");
				    foreach ($pa as $p){
				    	$id_jbt = $p->id_jabatan;
				    	$id_skl = $p->id_sekolah;
	    	$data['nama_atasan'] = $p->nama;
	    	$data['jabatan_atasan'] = $p->jabatan;
	    	$data['sekolah_atasan'] = $p->nama_unit;
	    	$data['nrp_atasan'] = $p->nrp;
	    	$data['pangkat_atasan'] = all("golongan","id_golongan",$p->id_golongan,"pangkat");
	    	$data['gol_atasan'] = all("golongan","id_golongan",$p->id_golongan,"golongan");
			 }
		}



		// Atasan Pejabat yang menilai
		 // Mencari data pejabat yang menilai
	    $cek_jab = $this->m_models->get_data("id_jabatan_atasan","ekin_alur_penilaian","WHERE id_jabatan = '".$id_jbt."' and status_alur='on'");
	    $id_jab_at = $cek_jab[0]->id_jabatan_atasan;
		//cek data

	    $cek = $this->m_models->getRows("pegawai where id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_skl."'");
	    if($cek==0){
	    		 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasanp'] = $pa->nama;
	    	$data['jabatan_atasanp'] = $pa->jabatan;
	    	$data['sekolah_atasanp'] = $pa->nama_unit;
	    	$data['nrp_atasanp'] = $pa->nrp;
	    	$data['pangkat_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");
	    }


	    } else if ($cek > 0){
	    	 $ats = $this->m_models->get_data("nrp,nama,(select nama_jabatan from jabatan where id_jabatan = p.id_jabatan) as jabatan,(select nama from sekolah where id_sekolah = p.id_sekolah) as nama_unit,id_golongan,id_jabatan","pegawai as p","WHERE id_jabatan='".$id_jab_at."' and status_aktf='Aktif' and id_sekolah='".$id_skl."'");
	    foreach ($ats as $pa){
	    	$id_jbt = $pa->id_jabatan;
	    	$data['nama_atasanp'] = $pa->nama;
	    	$data['jabatan_atasanp'] = $pa->jabatan;
	    	$data['sekolah_atasanp'] = $pa->nama_unit;
	    	$data['nrp_atasanp'] = $pa->nrp;
	    	$data['pangkat_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"pangkat");
	    	$data['gol_atasanp'] = all("golongan","id_golongan",$pa->id_golongan,"golongan");;
	    }




	    }


		// Menampilkan data tanggapan jika sudah menanggapi
		$data['tanggap'] = $this->m_models->get_data("*","ekin_ajuan_keberatan","WHERE nrp_pengaju='".$nrp."' and tahun_ajuan='".$tahun."'");
		foreach ($data['tanggap'] as $tgp){
			$data['ajuan_keberatan'] = $tgp->ajuan_keberatan;
			$data['tanggapan_atasan'] = $tgp->tanggapan_atasan;
			$data['keputusan_atasan_pejabat'] = $tgp->keputusan_atasan_pejabat;
			$data['keputusan_atasan_pejabat'] = $tgp->keputusan_atasan_pejabat;
			$data['status_tangapan'] = $tgp->status_tanggapan;

		}
		
		$this->load->view('ekinerja/print_catatan_hprestasi',$data);
	}
	
	
	public function edit_indikator(){
		
		
		
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data[id_sekolah]=$this->m_models->getSession($nrp, "id_sekolah");
	    $data[id_jabatan]=$this->m_models->getSession($nrp, "id_jabatan");
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$skl=$this->m_models->getSession($nrp, "id_sekolah");
		$id=$this->uri->segment(3);
		
		$data['dtg'] = $this->m_models->get_data("*","ekin_detail_aspek_sikap"," where id_detail_sikap='$id'");
		$data['asp'] = $this->m_models->get_data("*","ekin_aspek_sikap","where status_aspek_sikap='on'");
		$data['unsur'] = $this->m_models->get_data("*","ekin_m_unsur","where status_unsur='on' order by nama_unsur asc");
		if($jabatan=="24"){
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' order by nama_jabatan asc");
		} else {
			$data['sekolah'] = $this->m_models->get_data("id_sekolah,nama","sekolah","where status_aktif='on' and id_sekolah='$skl' order by nama asc");
			$data['jabatan'] = $this->m_models->get_data("id_jabatan,nama_jabatan","jabatan","where status_jabatan='ON' and jabatan in (select id_jabatan from pegawai where id_sekolah='$skl') order by nama_jabatan asc");
		}
		
		
		$idsekol = $this->input->post("idsekol");
		
		if($idsekol!=""){
			
			$data['tugas'] = $this->m_models->get_data("*","ekin_detail_aspek_sikap","order by id_aspek_sikap asc");			
		}
		
		
		$this->load->view('ekinerja/edit_indikator',$data);
		$this->load->view('template/footer');
	}



	
}