<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Dppp extends CI_Controller {
	function __construct() {
	    error_reporting(0);
		parent::__construct();
        $this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}
	

	#kriteria penilaian
	public function kriteria(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_kriteria = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");

		if ($id_kriteria != ""){
			$j_off= array('tgl'=>$hariini, 'petugas' => $nrp, 'status'=>$ket);
			if ($this->m_models->update_data($id_kriteria, "id_kriteria", $j_off, "peg_dp3_kriteria") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil di '.$ket.' ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/kriteria');
		}

        $data['kriteria'] = $this->m_models->getTabelOrder("*", "peg_dp3_kriteria", "kriteria", "asc");

		$this->load->view('penilaian_pegawai/kriteria_penilaian',$data);
		$this->load->view('template/footer');
	}

	
	public function simpan_kriteria(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
        $kriteria = $this->input->post('kriteria', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);

		if ($kriteria != ""){
			$nourut = $this->m_models->no_urut("peg_dp3_kriteria");
			$id_kriteria="KRT$nourut";
			$ar = array('id_kriteria'=>$id_kriteria, 'kriteria'=>$kriteria, 'keterangan' => $keterangan, 'status' => 'on', 'tgl' => $hariini, 'petugas' => $nrp);
			if ($this->m_models->save_data($ar, 'peg_dp3_kriteria') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/kriteria');
		}
	}

	#indikator
	public function indikator(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_indikator = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");

		if ($id_indikator != ""){
			$j_off= array('tgl'=>$hariini, 'petugas' => $nrp, 'status'=>$ket);
			if ($this->m_models->update_data($id_indikator, "id_indikator", $j_off, "peg_dp3_indikator") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil di '.$ket.' ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/indikator');
		}

		
		$arr=array('status' => 'on');
		$data['kriteria'] = $this->m_models->getTabelwhere("*", "peg_dp3_kriteria", $arr, "kriteria", "asc");
        $data['indikator'] = $this->m_models->getTabelOrder("*", "peg_dp3_indikator", "id_kriteria, indikator", "asc");

		$this->load->view('penilaian_pegawai/indikator_penilaian',$data);
		$this->load->view('template/footer');
	}

	
	public function simpan_indikator(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
        $kriteria = $this->input->post('kriteria', TRUE);
        $indikator = $this->input->post('indikator', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);
        $pengisi = $this->input->post('pengisi', TRUE);

		if (($kriteria != "") && ($indikator != "")){
			$nourut = $this->m_models->no_urut("peg_dp3_indikator");
			$id_indikator="IDK$nourut";
			$ar = array('id_indikator'=>$id_indikator, 'id_kriteria'=>$kriteria, 'indikator' => $indikator, 'keterangan'=>$keterangan, 'status' => 'on', 'tgl' => $hariini, 'petugas' => $nrp, 'pengisi'=>$pengisi);
			if ($this->m_models->save_data($ar, 'peg_dp3_indikator') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}
		redirect('dppp/indikator');
	}

	#score
	public function score(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_score = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");

		if ($id_score != ""){
			$j_off= array('tgl'=>$hariini, 'petugas' => $nrp, 'status'=>$ket);
			if ($this->m_models->update_data($id_score, "id_score", $j_off, "peg_dp3_score") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil di '.$ket.' ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/score');
		}

        $data['score'] = $this->m_models->getTabelOrder("*", "peg_dp3_score", "score", "asc");

		$this->load->view('penilaian_pegawai/score_penilaian',$data);
		$this->load->view('template/footer');
	}

	
	public function simpan_score(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
        $score = $this->input->post('score', TRUE);
        $nilai = $this->input->post('nilai', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);

		if (($score != "") && ($nilai != "")&& ($keterangan != "")){ 
			$nourut = $this->m_models->no_urut("peg_dp3_score");
			$id_score="SKR$nourut";
			$ar = array('id_score'=>$id_score, 'score'=>$score, 'nilai' => $nilai, 'status' => 'on', 'tgl' => $hariini, 'petugas' => $nrp, 'ket'=>$keterangan);
			if ($this->m_models->save_data($ar, 'peg_dp3_score') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}
		redirect('dppp/score');
	}


	#rumus
	public function rumus(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_rumus = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");

		if ($id_rumus != ""){
			$j_off= array('tgl'=>$hariini, 'petugas' => $nrp, 'status'=>$ket);
			if ($this->m_models->update_data($id_rumus, "id_rumus", $j_off, "peg_dp3_rumus") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil di '.$ket.' ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/rumus');
		}

        $data['rumus'] = $this->m_models->getTabelOrder("*", "peg_dp3_rumus", "dari", "asc");

		$this->load->view('penilaian_pegawai/rumus_penilaian',$data);
		$this->load->view('template/footer');
	}

	
	public function simpan_rumus(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
        $dari = $this->input->post('dari', TRUE);
        $sampai = $this->input->post('sampai', TRUE);
        $nilai = $this->input->post('nilai', TRUE);
        $keterangan = $this->input->post('keterangan', TRUE);

		if (($dari != "") && ($sampai != "") && ($nilai != "")&& ($keterangan != "")){
			$nourut = $this->m_models->no_urut("peg_dp3_rumus");
			$id_rumus="RMS$nourut";
			$ar = array('id_rumus'=>$id_rumus, 'dari'=>$dari, 'sampai' => $sampai, 'ket'=>$keterangan, 'nilai' => $nilai, 'status' => 'on', 'tgl' => $hariini, 'petugas' => $nrp);
			if ($this->m_models->save_data($ar, 'peg_dp3_rumus') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}
		redirect('dppp/rumus');
	}


	#penilaian dari kabag/kadiv
	public function penilaian(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$this->load->view('penilaian_pegawai/penilaian',$data);
		$this->load->view('template/footer');
	}

	public function download_form_penilaian(){
		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");

		//pegawai
		if ($id_sekolah==20){
			$data['pegawai'] = $this->m_models->getAll("pegawai where (id_sekolah='$id_sekolah' or id_sekolah='15') and status_aktf='Aktif' order by nama asc ");
		} else if ($id_sekolah==21){
			$data['pegawai'] = $this->m_models->getAll("pegawai where (id_sekolah='$id_sekolah' or id_sekolah='16') and status_aktf='Aktif' order by nama asc ");
		} else {
			$arr=array('id_sekolah' => $id_sekolah, 'status_aktf'=>'Aktif');
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arr, "nama", "asc");
		}
		

		//kriteria
		$ar = array('peg_dp3_indikator.status' => 'on', 'pengisi'=>'Non HRD');
		$data['indikator'] = $this->m_models->getJoin1where("*", "peg_dp3_indikator", "peg_dp3_kriteria", "peg_dp3_kriteria.id_kriteria=peg_dp3_indikator.id_kriteria", $ar, "peg_dp3_indikator.id_kriteria, indikator", "asc");

		#score
		$as = array('status' => 'on');
        $data['score_min'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "asc");
        $data['score_max'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "desc");
        $data['s_min']=$data['score_min'][0]->score;
        $data['s_max']=$data['score_max'][0]->score;


		$this->load->view('penilaian_pegawai/download_form_penilaian',$data);
	}

	#upload penilaian
	public function upload_penilaian(){
		$petugas=$this->session->userdata['nrp']; 
	  	$fileName = $this->input->post('file', TRUE);

	  	$config['upload_path'] = './assets/upload/'; 
		$config['file_name'] = $fileName;
		$config['allowed_types'] = 'xls|xlsx|csv|ods|ots';
		$config['max_size'] = 10000;

	  	$this->load->library('upload', $config);
	  	$this->upload->initialize($config); 
	  
	  	if (!$this->upload->do_upload('file')) {
		   	$error = array('error' => $this->upload->display_errors());
		   	$this->session->set_flashdata('msg','Ada kesalahan dalam upload'); 
			redirect('dppp/penilaian');
	  	} else { 
		   	$media = $this->upload->data();
		   	$inputFileName = 'assets/upload/'.$media['file_name'];
		   
		  	try {
			    $inputFileType = IOFactory::identify($inputFileName);
			    $objReader = IOFactory::createReader($inputFileType);
			    $objPHPExcel = $objReader->load($inputFileName);
		   	} catch(Exception $e) {
		    	die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
	   		}

		    $sheet = $objPHPExcel->getSheet(0);
		   	$highestRow = $sheet->getHighestRow();
		   	$highestColumn = $sheet->getHighestColumn();
		   	$hariini=date("Y-m-d");
		   	$id_tahun=ta_berjalan();
		   
	   		for ($row = 2; $row <= $highestRow+2; $row++){
		     	$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,
		       	NULL,
		       	TRUE,
		       	FALSE);

		     	$nrp=str_replace("'", "", $rowData[0][1]); 
		     	$id_jabatan=all("pegawai", "nrp", $nrp, "id_jabatan");
		   		$id_sekolah=all("pegawai", "nrp", $nrp, "id_sekolah");
		   		

		   		if (($id_sekolah >= 1) && ($id_sekolah <= 6)){
		   			$idsekolah=$id_sekolah;
				} else {
					$idsekolah=0;
				}

        		//cek penilaian sudah ada tidak
        		$ap = array('nrp' => $nrp, "id_kriteria"=> $rowData[0][3], "id_indikator"=> $rowData[0][5], 'id_tahun'=>$id_tahun);
        		$jnilai= $this->m_models->getRowsAWhere("*", "peg_dp3_penilaian", $ap, "id_nilai", "asc");
        		if ($jnilai != 0){
        			$hapus=$this->m_models->delete_dataarray($ap, "peg_dp3_penilaian");
        		}

		   		$as = array('status' => 'on', 'score'=>$rowData[0][7]);
        		$data['score'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "asc");
        		$id_score=$data['score'][0]->id_score;

			 	$ar_i = array(
			     	"id_nilai"=> '',
			     	"nrp"=> $nrp,
			     	"id_jabatan"=> $id_jabatan,
			     	"id_sekolah"=> $id_sekolah,
			     	"id_kriteria"=> $rowData[0][3],
			     	"id_indikator"=> $rowData[0][5],
			     	"id_score"=> $id_score, 
			     	"tgl"=>$hariini, 
			     	"petugas"=>$petugas,
			     	"id_tahun"=>$id_tahun
	    		); 
	    		if (($nrp != "") && ($rowData[0][3] != "") && ($rowData[0][5] != "") && ($id_score != "")){
	    			$this->m_models->save_data($ar_i, 'peg_dp3_penilaian');
	    		}

	   		} 
		   	// delete file
	        unlink($inputFileName);

	   		$this->session->set_flashdata('msg','Berhasil upload ...!!'); 
	   		redirect('dppp/penilaian'); 
	  	}  
	} 


	#penilaian yg diberikan dari HRD
	public function penilaian_hrd(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$this->load->view('penilaian_pegawai/penilaian_hrd',$data);
		$this->load->view('template/footer');
	}

	public function download_form_penilaian_hrd(){
		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");

		//pegawai
		$arr=array('id_sekolah' => $id_sekolah, 'status_aktf'=>'Aktif');
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arr, "nama", "asc");

		//kriteria
		$ar = array('peg_dp3_indikator.status' => 'on', 'pengisi'=>'HRD');
		$data['indikator'] = $this->m_models->getJoin1where("*", "peg_dp3_indikator", "peg_dp3_kriteria", "peg_dp3_kriteria.id_kriteria=peg_dp3_indikator.id_kriteria", $ar, "peg_dp3_indikator.id_kriteria, indikator", "asc"); 

		#score
		$as = array('status' => 'on');
        $data['score_min'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "asc");
        $data['score_max'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "desc");
        $data['s_min']=$data['score_min'][0]->score;
        $data['s_max']=$data['score_max'][0]->score;


		$this->load->view('penilaian_pegawai/download_form_penilaian_hrd',$data);
	}


	#rekapitulasi nilai DP3
	public function rekap_nilai(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$idsekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$data['sess_sekolah']=$idsekolah;

		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['id_ta']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");

		if (($idsekolah=="8") or ($idsekolah=="13")or ($idsekolah=="39")){
			$arr=array('status_aktif' => 'on');
		} else {
			$arr=array('id_sekolah' => $idsekolah);
		}
		$data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $arr, "nama", "asc");

		$id_tahun = $this->input->post('thn_akdmk', TRUE);
		$id_sekolah = $this->input->post('sekolah', TRUE);
		$data['id_tahun']=$id_tahun;
		$data['id_sekolah']=$id_sekolah;
		if (($id_tahun != "")&&($id_sekolah != "")){
        	$data['kriteria']=$this->m_models->getAll("peg_dp3_kriteria where id_kriteria in (select id_kriteria from peg_dp3_penilaian where id_tahun='$id_tahun' and id_sekolah='$id_sekolah' order by id_kriteria)");
        	foreach ($data['kriteria'] as $k) {
        		$data['jkriteria'][$k->id_kriteria]=$this->m_models->getRows("peg_dp3_indikator where id_kriteria='$k->id_kriteria' and id_indikator in (select id_indikator from peg_dp3_penilaian where id_tahun='$id_tahun' and id_sekolah='$id_sekolah') order by id_kriteria");
        		$data['indikator'][$k->id_kriteria]=$this->m_models->getAll("peg_dp3_indikator where id_kriteria='$k->id_kriteria' and id_indikator in (select id_indikator from peg_dp3_penilaian where id_tahun='$id_tahun' and id_sekolah='$id_sekolah') order by indikator asc ");

        		$ap = array('peg_dp3_penilaian.id_tahun'=>$id_tahun, 'peg_dp3_penilaian.id_sekolah'=>$id_sekolah);
        		$data['pegawai']= $this->m_models->getJoin1whereGroup("*", "peg_dp3_penilaian", "pegawai", "pegawai.nrp=peg_dp3_penilaian.nrp", $ap, "peg_dp3_penilaian.nrp", "nama", "asc");
        		foreach ($data['pegawai'] as $p) {
        			foreach ($data['indikator'][$k->id_kriteria] as $i) {
	        			$ar = array('peg_dp3_penilaian.id_tahun'=>$id_tahun, 'peg_dp3_penilaian.id_sekolah'=>$id_sekolah, 'id_kriteria'=>$k->id_kriteria, 'id_indikator'=>$i->id_indikator, 'nrp'=>$p->nrp);
						$data['penilaian'] = $this->m_models->getJoin1where("*", "peg_dp3_penilaian", "peg_dp3_score", "peg_dp3_score.id_score=peg_dp3_penilaian.id_score", $ar, "id_indikator", "asc");	
						$data['skor'][$i->indikator][$p->nrp]=$data['penilaian'][0]->score;
						$total += $data['penilaian'][0]->score;
						$data['totalskor'][$p->nrp] += $data['penilaian'][0]->score;
	        		}
        		}
        	}
		}

		$this->load->view('penilaian_pegawai/rekap_nilai',$data);
		$this->load->view('template/footer');
	}

	
	public function download_resume_nilai_dp3(){
		$nrp=$this->session->userdata['nrp']; 

		$id_sekolah = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$data['id_tahun']=$id_tahun;
		$data['id_sekolah']=$id_sekolah;
		if (($id_tahun != "")&&($id_sekolah != "")){
			//ttd
			$arr=array('status' => 'on', 'id_sekolah'=>$id_sekolah);
			$data['ttd'] = $this->m_models->getTabelwhere("*", "peg_dp3_nm_ttd", $arr, "id_sekolah", "asc");
			$data['id_jab_ttd']=$data['ttd'][0]->id_jabatan;

			$ar_r=array('id_jabatan' => $data['ttd'][0]->id_jabatan, 'id_sekolah'=>$data['ttd'][0]->id_sekolah);
			$data['nama'] = $this->m_models->getTabelwhere("*", "pegawai", $ar_r, "nama", "asc");
			$data['nrp_ttd2']=$data['nama'][0]->nrp;
			$data['nama_ttd2']=$data['nama'][0]->nama; 
			$data['id_jabatan2']=$data['nama'][0]->id_jabatan;

			/*if ($id_sekolah==13){
				$ar_r=array('id_jabatan' => 13, 'id_sekolah'=>13);
			} else if ($id_sekolah==39){
				$ar_r=array('id_jabatan' => 13, 'id_sekolah'=>39);
			}*/
			
			//$data['nama1'] = $this->m_models->getTabelwhere("*", "pegawai", $ar_r, "nama", "asc");
			//$data['nrp_ttd1']=$data['nama1'][0]->nrp;

			#cek nama kabag sdm am 1 atau 2
			$ars=array('id_sekolah'=>$id_sekolah, 'nama like '=>'%2%');
			$j2 = $this->m_models->getRowsAWhere("nama", "sekolah", $ars, "id_sekolah", "asc");
			if($j2!=0){
				$arpe=array('id_jabatan' => 13, 'id_sekolah'=>39);
				$arpe2=array('id_jabatan' => 136, 'id_sekolah'=>8);
				$data['am']="AM2";
			} else {
				$arpe=array('id_jabatan' => 13, 'id_sekolah'=>13);
				$arpe2=array('id_jabatan' => 64, 'id_sekolah'=>8);
				$data['am']="AM1";
			}
			$data['dtnama1'] = $this->m_models->getTabelwhere("*", "pegawai", $arpe, "nama", "asc");
			$data['nrp_ttd1']=$data['dtnama1'][0]->nrp;

			$data['dtnama2'] = $this->m_models->getTabelwhere("*", "pegawai", $arpe2, "nama", "asc");
			$data['nrp_ttd2']=$data['dtnama2'][0]->nrp; 
			

        	$data['kriteria']=$this->m_models->getAll("peg_dp3_kriteria where id_kriteria in (select id_kriteria from peg_dp3_penilaian where id_tahun='$id_tahun' and id_sekolah='$id_sekolah') order by id_kriteria asc");
        	foreach ($data['kriteria'] as $k) {
        		$data['jkriteria'][$k->id_kriteria]=$this->m_models->getRows("peg_dp3_indikator where id_kriteria='$k->id_kriteria' and id_indikator in (select id_indikator from peg_dp3_penilaian where id_tahun='$id_tahun' and id_sekolah='$id_sekolah')");
        		$data['indikator'][$k->id_kriteria]=$this->m_models->getAll("peg_dp3_indikator where id_kriteria='$k->id_kriteria' and id_indikator in (select id_indikator from peg_dp3_penilaian where id_tahun='$id_tahun' and id_sekolah='$id_sekolah') order by indikator asc");

        		$ap = array('peg_dp3_penilaian.id_tahun'=>$id_tahun, 'peg_dp3_penilaian.id_sekolah'=>$id_sekolah);
        		$data['pegawai']= $this->m_models->getJoin1whereGroup("*", "peg_dp3_penilaian", "pegawai", "pegawai.nrp=peg_dp3_penilaian.nrp", $ap, "peg_dp3_penilaian.nrp", "nama", "asc");
        		foreach ($data['pegawai'] as $p) {
        			foreach ($data['indikator'][$k->id_kriteria] as $i) {
	        			$ar = array('peg_dp3_penilaian.id_tahun'=>$id_tahun, 'peg_dp3_penilaian.id_sekolah'=>$id_sekolah, 'id_kriteria'=>$k->id_kriteria, 'id_indikator'=>$i->id_indikator, 'nrp'=>$p->nrp);
						$data['penilaian'] = $this->m_models->getJoin1where("*", "peg_dp3_penilaian", "peg_dp3_score", "peg_dp3_score.id_score=peg_dp3_penilaian.id_score", $ar, "id_indikator", "asc");	
						$data['skor'][$i->indikator][$p->nrp]=$data['penilaian'][0]->score;
						$data['nilai'][$i->indikator][$p->nrp]=$data['penilaian'][0]->nilai." (".$data['penilaian'][0]->ket.")";
						$total += $data['penilaian'][0]->score;
						$data['totalskor'][$p->nrp] += $data['penilaian'][0]->score; 
	        		}
        		}
        	}
		}

		$this->load->view('penilaian_pegawai/download_resume_nilai_dp3',$data);
	}

	#kelola jabatan untuk yg ttd
	public function kelola_ttd(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_nmttd = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");

		if ($id_nmttd != ""){
			$j_off= array('tgl'=>$hariini, 'petugas' => $nrp, 'status'=>$ket);
			if ($this->m_models->update_data($id_nmttd, "id_nmttd", $j_off, "peg_dp3_nm_ttd") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil di '.$ket.' ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/kelola_ttd');
		}

		$arr=array('status_aktif' => 'on');
		$data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $arr, "nama", "asc");
        $data['jabatan'] = $this->m_models->getTabelOrder("*", "jabatan", "nama_jabatan", "asc");

        $data['nm_ttd'] = $this->m_models->getJoin2("peg_dp3_nm_ttd.*, sekolah.nama, jabatan.nama_jabatan", "peg_dp3_nm_ttd", "sekolah", "sekolah.id_sekolah=peg_dp3_nm_ttd.id_sekolah", "jabatan", "jabatan.id_jabatan=peg_dp3_nm_ttd.id_jabatan", "nama", "asc");

		$this->load->view('penilaian_pegawai/kelola_ttd',$data);
		$this->load->view('template/footer');
	}

	
	public function simpan_kelola_ttd(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
        $sekolah = $this->input->post('sekolah', TRUE);
        $jabatan = $this->input->post('jabatan', TRUE);

		if (($sekolah != "") && ($jabatan != "")){
			$ar = array('id_sekolah'=>$sekolah, 'id_jabatan'=>$jabatan, 'status' => 'on', 'tgl' => $hariini, 'petugas' => $nrp);
			if ($this->m_models->save_data($ar, 'peg_dp3_nm_ttd') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/kelola_ttd');
		}
	}


	#upload ttd pegawai
	public function upload_ttd(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		
		$arr= array('status_aktf'=>'Aktif');
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arr, "nama", "asc");
        $data['ttd'] = $this->m_models->getJoin1where("*", "peg_ttd_pegawai", "pegawai", "pegawai.nrp=peg_ttd_pegawai.nrp", $arr, "nama", "asc");
        foreach ($data['ttd'] as $t) {
        	$ar= array('id_sekolah'=>$t->id_sekolah);
			$data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
			$data['nm_sekolah'][$t->nrp]=$data['sekolah'][0]->nama;
        }

		$this->load->view('penilaian_pegawai/upload_ttd',$data);
		$this->load->view('template/footer');
	}

	public function uploadttd(){
		$nrp=$this->session->userdata['nrp']; 
        $pegawai = $this->input->post('pegawai', TRUE);
        $hariini=date("Y-m-d");

        if ($pegawai != ""){
	        //upload foto
			// setting konfigurasi upload
	        $config['upload_path'] = './ttd/';
	        $config['allowed_types'] = 'jpg|png|jpeg|JPG|PNG|JPEG';
	        $config['encrypt_name'] = TRUE;

	        // load library upload
	        $this->load->library('upload', $config);

	        #foto
	        if (!$this->upload->do_upload('gambar')){
	            $error = $this->upload->display_errors();
	            print_r($error);
	        } else { 
	            $data_upload = $this->upload->data();
	            $data_tabel = array (
					'nrp' => $pegawai,
					'tgl' => $hariini,
					'petugas' => $nrp,
					'nama_file' => $data_upload['file_name']
				);
	            $simpan=$this->m_models->save_data($data_tabel,"peg_ttd_pegawai");
	        } 

			if ($simpan == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('dppp/upload_ttd');
		}
	}

	public function hapus_ttd(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_ttd = $this->uri->segment(3);

		if ($id_ttd != ""){
			if ($this->m_models->delete_data($id_ttd, "id_ttd", "peg_ttd_pegawai") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus ');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}
		redirect('dppp/upload_ttd');
	}

	public function download_penilaian(){
		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$data['id_tahun']=$id_tahun; 
		$data['id_sekolah']=$id_sekolah;
		if (($id_tahun != "")&&($id_sekolah != "")){
			$arr=array('id_sekolah' => $id_sekolah, 'status_aktf'=>'Aktif');
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arr, "nama", "asc");

			//kriteria
			$ar = array('peg_dp3_indikator.status' => 'on');
			$data['indikator'] = $this->m_models->getJoin1where("*", "peg_dp3_indikator", "peg_dp3_kriteria", "peg_dp3_kriteria.id_kriteria=peg_dp3_indikator.id_kriteria", $ar, "peg_dp3_indikator.id_kriteria, indikator", "asc");

			#score
			$as = array('status' => 'on');
	        $data['score_min'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "asc");
	        $data['score_max'] = $this->m_models->getTabelwhere("*", "peg_dp3_score", $as, "score", "desc");
	        $data['s_min']=$data['score_min'][0]->score;
	        $data['s_max']=$data['score_max'][0]->score;

	        #mengambil nilai
	        foreach ($data['pegawai'] as $peg) {
	        	foreach ($data['indikator'] as $i) {
	        		$ap = array('peg_dp3_penilaian.id_tahun'=>$id_tahun, 'peg_dp3_penilaian.id_sekolah'=>$id_sekolah, 'nrp'=>$peg->nrp, 'id_indikator'=>$i->id_indikator);
		       		$data['penilaian']= $this->m_models->getJoin1where("*", "peg_dp3_penilaian", "peg_dp3_score", 'peg_dp3_score.id_score=peg_dp3_penilaian.id_score', $ap, "nrp", "nama", "asc");
		        	foreach ($data['penilaian'] as $nilai) {
		        		$data[nilai][$peg->nrp][$i->id_indikator]=$nilai->score;
		        	}
	        	}
	        }
			        
	    }

		$this->load->view('penilaian_pegawai/download_hasil_penilaian',$data);
	}

	
}


