<?php 
defined('BASEPATH') OR exit('No direct script access allowed');
class Catering extends CI_Controller {	
	function __construct(){
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	public function set_harga(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$nominal  = db_nominal($this->input->post('nominal', TRUE)); 
		if ($nominal != ""){
			$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
			$id_ta=$data['thn_akademik'][0]->id_tahun;
			$hariini=date("Y-m-d");

			$ar_harga = array('nominal'=>$nominal, 'id_tahun' => $id_ta, 'tgl_input'=>$hariini, 'nrp'=>$nrp, 'jenis'=>"catering", 'status'=>'on');
			if ($this->m_models->save_data($ar_harga, 'master_harga') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('catering/set_harga');
		}
		
		$as=array('jenis =' => 'catering');
		$data['set_harga']=$this->m_models->getTabelwhere("*", "master_harga", $as, "id_tahun", "asc");

		$this->load->view('catering/set_harga_catering', $data);
		$this->load->view('template/footer');
	}

	public function update_harga(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_harga = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_harga != ""){
			$j_off= array('status'=>$status, 'tgl_off'=>$hariini, 'nrp_off'=>$nrp);
			if ($this->m_models->update_data($id_harga, "id_harga", $j_off, "master_harga") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('catering/set_harga');
		}
		$this->load->view('template/footer');
	}

	public function anggota_catering(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

	    $ar_sklh = array('status_aktif' => 'on');
	    $arorw = "(id_sekolah='1' or id_sekolah='2' or id_sekolah='3')";
		$data['sekolah'] = $this->m_models->getTabelwhereOr("*", "sekolah", $ar_sklh, $arorw, "nama", "asc");

		$this->load->view('catering/anggota_catering', $data);
		$this->load->view('template/footer');
	}

	public function ceksiswa(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('jenjang', TRUE);
		$data['id_sekolah']=$id_sekolah;

		$kls=$this->input->get('kls', TRUE);
		$ex=explode("-", $kls);
		$idsekolah=$ex[0];
		$data['id_kelas']=$ex[1]; 


		$jnjg=db_jenjang($id_sekolah); 
		$data['jenjang']=$jnjg;
		$id_tahun=ta_berjalan();
		$data['id_tahun']=$id_tahun;

		$ar_sekolah = array('id_sekolah =' => $id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar_sekolah, "nama_kelas", "asc");

		//$ar = array('status_aktif =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
		//$data['siswa'] = $this->m_models->getTabelwhere("*", "siswa_".$jnjg, $ar, "nama_lengkap", "asc");


		$rbel="rombongan_belajar_".$jnjg;
		$sswa="siswa_".$jnjg;
		$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_tahun"=>ta_berjalan(), $rbel.".id_sekolah"=>$id_sekolah);
		$data['siswa'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");
		foreach ($data['siswa'] as $s){
			$data['j_anggota'][$s->id_siswa]=$this->m_models->getRows("k_anggota_catering where id_siswa='".$s->id_siswa."'");
		}


		$this->load->view('catering/ceksiswa', $data);
	}

	public function cekkls(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$kls=$this->input->get('kls', TRUE);
		$ex=explode("-", $kls);
		$idsekolah=$ex[0];
		$data['id_kelas']=$ex[1]; 

	    if ($kls != ""){ 
	    	$jnjg=db_jenjang($idsekolah); 
	    	$data['jenjang']=$jnjg;
			$data['id_tahun']=ta_berjalan();
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$ex[1], $rbel.".id_tahun"=>ta_berjalan(), $rbel.".id_sekolah"=>$idsekolah);
			$data['siswa'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");
	    }

		$this->load->view('catering/ceksiswa', $data);
	}

	public function simpan_anggota_catering(){
		$nrp=$this->session->userdata['nrp']; 
		$ar = array('status_aktif =' => 'on', 'kategori'=>'Sekolah');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "id_sekolah", "asc");
		$id_ta=ta_berjalan();
		$hariini=date("Y-m-d");

		$id_kelas=$this->input->post('id_kelas', TRUE);
		$jenjang=$this->input->post('jenjang', TRUE);
		$no=$this->input->post('no', TRUE);
		$id_siswa=$this->input->post('id_siswa', TRUE);
		if (($jenjang != "") && ($no != "") && ($id_siswa != "")){
			for ($i=0; $i <= $no; $i++){ 
				$idsiswa = $id_siswa[$i];
				if ($idsiswa != 0){
					$ar_cat = array('id_siswa'=>$idsiswa, 'id_tahun' => $id_ta, 'status'=>'on', 'tgl_input'=>$hariini, 'tgl_off'=>"0000-00-00", 'nrp'=>$nrp, 'id_kelas'=>$id_kelas);
					$simpan=$this->m_models->save_data($ar_cat, 'k_anggota_catering');
				}
			}

			if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('catering/anggota_catering');
		}
	}


	public function data_anggota_catering(){
		$this->load->view('template/header');
	    $data['hak_akses']=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];

		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun1", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "desc");
	   // $data[thn_on]=$data['tahun'][0]->id_tahun;

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE); 
		$tahun = $this->input->post('tahun', TRUE); 
		$ex = explode("-", $this->input->post('id_sekolah', TRUE));
		$data['ds']="$dari-$sampai";
		$id_sekolah = $ex[1];
		//$id_sekolah = $this->input->post('id_sekolah', TRUE);
		//$ta = $ex[0];
		$ta = $tahun;
		//if (($dari != "") && ($sampai != "") && ($id_sekolah != "")&& ($kelas != "")){
		if (($id_sekolah != "")){ 
			//$data['kelas']=$kelas;
			$data['id']="$ta-$kelas";
			$jnjg=db_jenjang($id_sekolah);
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			//$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun"=>$ta, $rbel.".id_sekolah"=>$id_sekolah);
			$ar_r = array('status_aktif =' => 'Aktif',$rbel.".id_tahun"=>$ta, $rbel.".id_sekolah"=>$id_sekolah);
		    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

		    //pemasukan dan pengambilan tabungan
		    foreach ($data['rombel'] as $s){
		    	//$ar = array('id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta, 'status'=>'on', 'id_kelas'=>$kelas);
		    	$ar = array('id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta);
	   			$data['cat'] = $this->m_models->getTabelGroup("*", "k_anggota_catering", $ar, "id_siswa", "tgl_input", "asc");
	   			foreach ($data['cat'] as $c) { 
	   				$data['status'][$s->id_siswa]=$c->status;
	   				$data['id_a_catering'][$s->id_siswa]=$c->id_a_catering;
	   			}
	   			$data['kelas'][$s->id_siswa]=kelas($jnjg, $s->id_siswa, $tahun);
		    }
		} else {
			$this->session->set_flashdata('gagal_cari', 'Silahkan lakukan pencarian !!!');
		}

		$this->load->view('catering/dt_anggota_catering', $data);
		$this->load->view('template/footer');
	}


	public function update_a_catering(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_a_catering = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_a_catering != ""){
			$j_off= array('status'=>$status, 'tgl_off'=>$hariini, 'nrp'=>$nrp);
			if ($this->m_models->update_data($id_a_catering, "id_a_catering", $j_off, "k_anggota_catering") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('catering/data_anggota_catering');
		}
		$this->load->view('template/footer');
	}

	# inputan untuk setting jumlah hari dalam sebulan untuk catering
	public function set_hari(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");

		$bln = $this->input->post('bln', TRUE);
		$tahun = $this->input->post('tahun', TRUE);
		$hari = $this->input->post('hari', TRUE);
		$periode = $tahun."-".$bln."-00";
		$id_tahun=ta_berjalan();
		$hariini=date("Y-m-d");

		if (($bln != "") && ($tahun != "") && ($hari != "")){
			$ar_hari = array('jumlah'=>$hari, 'periode' => $periode, 'id_tahun'=>$id_tahun, 'tgl'=>$hariini, 'nrp'=>$nrp);
			if ($this->m_models->save_data($ar_hari, 'k_catering_hari') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('catering/set_hari');
		}


		$data['biaya_catering']=$this->m_models->getTabelOrder("*", "k_catering_hari", "periode", "asc");

		$this->load->view('catering/set_hari', $data);
		$this->load->view('template/footer');
	}

	#data siswa yang mengikuti catering
	public function data_catering(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['thn_akademik'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", "ON", "tahun2", "desc");
		$data['thn_on']=$data['thn_akademik'][0]->id_tahun;
		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thnon']=date("Y");


		$bulan  = $this->input->post('bln', TRUE);
		$thn  = $this->input->post('thn', TRUE); 
		$id_tahun  = $this->input->post('tahun', TRUE); 
		$periode = $thn."-".$bulan."-00";
        $data['bln_pilih'] = $bulan;
        $data['id_tahun']=$id_tahun;
        $data['periode']=$periode;
 
		if (($id_tahun != "") && ($bulan != "")){
			//menampilkan hari
			$ar_hari=array('id_tahun'=>$id_tahun, 'periode'=>$periode);
			$data['hari_catering']=$this->m_models->getTabelwhere("*", "k_catering_hari", $ar_hari, "tgl", "desc");
			$data['hari']=$data['hari_catering'][0]->jumlah;

			//menampikan harga
			$ar_harga=array('id_tahun'=>$id_tahun, 'status'=>'on', 'jenis'=>'catering');
			$data['harga_catering']=$this->m_models->getTabelwhere("*", "master_harga", $ar_harga, "id_harga", "desc");
			$data['harga']=$data['harga_catering'][0]->nominal;

			$ac=array('status =' => 'on', 'k_anggota_catering.id_tahun'=>$id_tahun);
			$data['anggota_catering']=$this->m_models->getJoin1whereGroup("*", "k_anggota_catering", "kelas", "kelas.id_kelas=k_anggota_catering.id_kelas", $ac, "k_anggota_catering.id_kelas", "nama_kelas", "asc");
			foreach ($data['anggota_catering'] as $key) {
				$data['nm_kelas'][$key->id_kelas]=all("kelas", "id_kelas", $key->id_kelas, "nama_kelas");
				$data['ket_kelas'][$key->id_kelas]=all("kelas", "id_kelas", $key->id_kelas, "keterangan");
				$ar_cat=array('status =' => 'on', 'id_tahun'=>$id_tahun, 'id_kelas'=>$key->id_kelas);
				$data['jml_ac'][$key->id_kelas]=$this->m_models->getRowsAWhere("*", "k_anggota_catering", $ar_cat, "id_kelas", "asc");
			}
		}

		$this->load->view('catering/data_catering_bulanan', $data);
		$this->load->view('template/footer');
	}
	
	public function detail_dt_catering(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_kelas = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$periode = $this->uri->segment(5);
		$data['periode']=$periode;

		if (($id_kelas != "")&&($id_tahun != "")&&($periode != "")){
			$ar_cat=array('status'=>'on', 'id_tahun'=>$id_tahun, 'id_kelas'=>$id_kelas);
			$data['anggota_catering']=$this->m_models->getTabelwhere("*", "k_anggota_catering", $ar_cat, "id_kelas", "asc");

			//menampilkan hari
			$ar_hari=array('id_tahun'=>$id_tahun, 'periode'=>$periode);
			$data['hari_catering']=$this->m_models->getTabelwhere("*", "k_catering_hari", $ar_hari, "tgl", "desc");
			$data['hari']=$data['hari_catering'][0]->jumlah;

			//menampikan harga
			$ar_harga=array('id_tahun'=>$id_tahun, 'status'=>'on', 'jenis'=>'catering');
			$data['harga_catering']=$this->m_models->getTabelwhere("*", "master_harga", $ar_harga, "id_harga", "desc");
			$data['harga']=$data['harga_catering'][0]->nominal;
		}
		$this->load->view('catering/detail_dt_catering', $data);
		$this->load->view('template/footer');
	}

	#resume data siswa yg mengikuti catering
	public function riwayat_siswa(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun1", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "desc");

		$tahun = $this->input->post('tahun', TRUE);
		$kelas = $this->input->post('kelas', TRUE);
		$ex = explode("-", $this->input->post('idsekolah', TRUE));
		$data['ds']="$dari-$sampai";
		$id_sekolah = $ex[1];
		$data['thn'] = $tahun;

		if (($id_sekolah != "")&& ($kelas != "") && ($tahun != "")){
			$ar_cat=array('id_tahun'=>$tahun, 'id_kelas'=>$kelas);
			$data['anggota_catering']=$this->m_models->getTabelwhere("*", "k_anggota_catering", $ar_cat, "id_kelas", "asc");
		}
		$this->load->view('catering/resume_siswa_catering', $data);
		$this->load->view('template/footer');
	}

	public function ceksekolah(){
		//$this->load->view('template/head');
		//$this->load->view('template/js');
  		//$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$tahun=$this->input->get('tahun', TRUE); 
		$data[tahun]=$tahun;

		$ex=explode("-", $this->input->get('id_sekolah', TRUE));
		$id_sekolah=$ex[1];
		$id_tahun=$ex[0];
		$data[id_sekolah]=$this->input->get('id_sekolah', TRUE);

		$ar_sklh = array('status_aktif' => 'on');
		if (($id_sekolah==1) or ($id_sekolah==2) or ($id_sekolah==3)){
			 $arorw = "(id_sekolah='$id_sekolah')";
		} else {
			 $arorw = "(id_sekolah='1' or id_sekolah='2' or id_sekolah='3')";
		}
	   
		$data[sekolah] = $this->m_models->getTabelwhereOr("*", "sekolah", $ar_sklh, $arorw, "nama", "asc");

		$ar = array('id_sekolah'=>$id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar, "nama_kelas", "asc");

		$this->load->view('catering/ceksekolah_tab', $data);
	}
}