<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Boarding extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
		$this->load->library(array('upload','image_lib'));
	}

	function getAksesPembinaan($level_user){ 
		/*  level user di pembinaan
			20	Kabag Pembinaan Putra
			21	Kabag Pembinaan Putri
			45	Wali Asrama Putra
			46	Wali Asrama Putri
			87	Staff Kesehatan
			104	Kanit Kesehatan
			118	Staff Pembinaan Putri
			119	Staff Pembinaan Putra
			109	Kanit Kedisiplinan Putra
			120	Kanit Kedisiplinan Putri
			110	Kanit Keasramaan Putra
			121	Kanit Keasramaan Putri
			82 Kanit HTB Putra
			124 Kanit HTB Putri
			106 Kanit OSMA Putra
			123 Kanit OSMA Putri
			80 Kanit Ibadah Putra
			122 Kanit Ibadah Putri
		 */
		# level user Pembinaan Putra
		$user_pembinaan_putra = array('20+127', '45+127', '119+127', '109+127', '110+127', '80+127', '106+127', '82+127', '126+127+119');
		# level user Pembinaan Putri
		$user_pembinaan_putri = array('21+127', '21+127+133', '46+127', '118+127', '120+127', '121+127', '122+127', '123+127', '124+127');
		# level user Pembinaan Putra Putri
		$user_pembinaan_all = array('87+127', '104+127');

		$akses = '';

		# cek lever user ada di user pembinaan mana
		if (in_array($level_user, $user_pembinaan_putra)) {
			$akses = 'Putra';
		}
		if (in_array($level_user, $user_pembinaan_putri)) {
			$akses = 'Putri';
		}
		if (in_array($level_user, $user_pembinaan_all)) {
			$akses = 'PutraPutri';
		}

		# kirim hasilnya
		return $akses;
	}

	function getRayon(){
		$d_asrama = $this->m_models->getJoin1("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", "b_kamar.nama", "ASC");
		foreach ($d_asrama as $key) {
			$asrama[$key->id_kamar] = $key->nama_asrama;
		//	$kamar[$key->id_kamar] = $key->nama;
		}
		return $asrama;
	}

	function getPoin(){
	//	$this->load->view('template/head');
		$unit = $this->input->get('unit'); 

		$exp = explode("-", $unit);
		$id_unit = $exp[0];
		$jenis = $exp[1];

		$data['jenis'] = $jenis;
		$data['data_poin'] = $this->m_models->getAll("b_poin where id_unit='$id_unit' AND jenis='$jenis' AND status='On'");

		$this->load->view('boarding/data_point', $data);
		
	//	$this->load->view('template/js');
	}

	function asrama(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		$akses_pembinaan = $this->getAksesPembinaan($level_user);

		# ambil data asrama
		$arraywhere = array('b_asrama.jenis' => $akses_pembinaan);
		$data[asrama] = $this->m_models->getJoin1where("alamat.nama_alamat, b_asrama.*", "b_asrama", "alamat", "b_asrama.id_alamat=alamat.id_alamat", $arraywhere, "b_asrama.nama", "ASC");

		# ambil data alamat
		$data[alamat] = $this->m_models->getAll("alamat ORDER BY nama_alamat ASC");
		# tampilkan data ke view
		$this->load->view('boarding/asrama', $data); 

		$this->load->view('template/footer');
	}

	function tambah_asrama(){
		$nama = $this->input->post('nama', TRUE);
        $jenis  = $this->input->post('jenis', TRUE);
        $alamat  = $this->input->post('alamat', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'jenis'  => $jenis,
		    'id_alamat'  => $alamat
		);

		# proses simpan
		if ($this->m_models->save_data($data,"b_asrama") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/asrama');
	}

	function edit_asrama(){
		$id_asrama = $this->input->post('id_asrama', TRUE);
		$nama = $this->input->post('nama', TRUE);
        $jenis  = $this->input->post('jenis', TRUE);
        $alamat  = $this->input->post('alamat', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'jenis'  => $jenis,
		    'id_alamat'  => $alamat
		);

		# proses simpan
		if ($this->m_models->update_data($id_asrama, 'id_asrama',$data,"b_asrama") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/asrama');
	}

	function hapus_asrama(){
		$id_asrama = $this->input->post('id_asrama', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_asrama, 'id_asrama', 'b_asrama') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('boarding/asrama');
	}

	#kamar
	function kamar(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		$akses_pembinaan = $this->getAksesPembinaan($level_user);

		# ambil data kamar
		$arraywhere = array('b_asrama.jenis' => $akses_pembinaan);
		$data['kamar'] = $this->m_models->getJoin1where("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", $arraywhere, "b_kamar.nama", "ASC");
		# ambil data asrama
		$data['asrama'] = $this->m_models->getAll("b_asrama WHERE jenis='$akses_pembinaan' ORDER BY nama ASC");
		# tampilkan data ke view
		$this->load->view('boarding/kamar', $data); 

		$this->load->view('template/footer');
	}

	function tambah_kamar(){
		$nama = $this->input->post('nama', TRUE);
        $kapasitas  = $this->input->post('kapasitas', TRUE);
        $asrama  = $this->input->post('asrama', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'kapasitas'  => $kapasitas,
		    'id_asrama'  => $asrama,
		    'status' => '1'
		);

		# proses simpan
		if ($this->m_models->save_data($data,"b_kamar") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/kamar');
	}

	function edit_kamar(){
		$id_kamar = $this->input->post('id_kamar', TRUE);
		$nama = $this->input->post('nama', TRUE);
        $kapasitas  = $this->input->post('kapasitas', TRUE);
        $asrama  = $this->input->post('asrama', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'kapasitas'  => $kapasitas,
		    'id_asrama'  => $asrama
		);

		# proses simpan
		if ($this->m_models->update_data($id_kamar, 'id_kamar', $data, "b_kamar") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/kamar');
	}

	function hapus_kamar(){
		$id_kamar = $this->input->post('id_kamar', TRUE);

		$data = array ('status' => '0');

		# proses hapus
		if ($this->m_models->update_data($id_kamar, 'id_kamar', $data, 'b_kamar') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('boarding/kamar');
	}


	# mengambil data sekolah boarding
	#getSekolahBoarding
	public function getSekolahBoarding(){
		$arraywhere=array('sekolah.kategori' => 'Sekolah', 'sekolah.boarding' => 'Ya');
		return $this->m_models->getJoin1where("sekolah.id_sekolah, sekolah.nama, sekolah.id_jenjang, sekolah.kode_pengenal, jenjang_pendidikan.nama_jenjang", "sekolah","jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", $arraywhere, "id_sekolah", "ASC");
	}

	# fungsi mengambil data siswa kelas buat JS
	#getsiswa
	public function getsiswa(){
		$this->load->view('template/head');
		$sekolah=$this->input->get('kelas'); 
		
		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';
		$id_sekolah = str_replace("0", "", $kode_sekolah);
		$id_kelas = $exp[2];

		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;
		
		# query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun, $tabel_rombel.".id_kelas" => $id_kelas);
		$data['siswa'] = $this->m_models->getJoin1where($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, "nama_lengkap", "ASC");
		# ambil data siswa yang sudah masuk kamar buat di disable di table santri yang di view
		$arr_siswa_kamar = array();
		$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun, $tabel_rombel.".id_kelas" => $id_kelas, "b_kamar_santri.id_tahun" => $id_tahun);
		$siswa_kamar = $this->m_models->getJoin1where("b_kamar_santri.id_siswa,".$tabel_rombel.".*", $tabel_rombel, 'b_kamar_santri', $tabel_rombel.".id_siswa="."b_kamar_santri.id_siswa", $arraywhere, "b_kamar_santri.id_siswa", "ASC");
		foreach ($siswa_kamar as $key) {
			$arr_siswa_kamar[] = $key->id_siswa;
		}

		$data['siswa_kamar'] = $arr_siswa_kamar;

		$this->load->view('boarding/siswa_kelas',$data);
		
		$this->load->view('template/js');
	}

	# fungsi mengambil data siswa kelas buat JS
	#getsantri
	public function getsantri(){
	//	$this->load->view('template/head');
		$id_kamar=$this->input->get('kamar'); 

		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;
		
		$santri = $this->m_models->get_data("*", "b_kamar_santri", "WHERE id_kamar='$id_kamar' AND status='in' AND id_tahun='$id_tahun' ");

		foreach ($santri as $key) {
			$id_siswa = $key->id_siswa;
			$d_santri['id_siswa'][] = $id_siswa;
			$d_santri['id_kamar_santri'][] = $key->id_kamar_santri;

			$jenjang=db_siswa($id_siswa);

			$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
			$d_santri['nama'][] = $nama;
			$nis=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nis");
			$d_santri['nis'][] = $nis;
		}

		$data['jumlah_santri'] = count($santri);
		
		if (count($santri)!=NULL) {
			$data['santri'] = $d_santri;
		}

		$this->load->view('boarding/siswa_kamar',$data);

	//	$this->load->view('template/js');
	}

	#kamar_santri
	# Fungsi untuk penempatan baru, penempatan ulang tahunan, mutasi keluar santri 
	function kamar_santri(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];

		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		//------------------ MENGAMBIL DATA KELAS YANG AKTIF SESUAI TAHUN AKADEMIK ---------------//
		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;

		# ambil data sekolah boarding
		$data['sekolah'] = $this->getSekolahBoarding();
		# ambil data tingkatan kelas ex: kelas X, XI, XII
		$tingkat = $this->m_models->get_data("id_tingkatan_kelas, id_jenjang, tingkat", "tingkatan_kelas", "ORDER BY id_tingkatan_kelas");
		foreach ($tingkat as $key) {
			$nama_tingkat[$key->id_jenjang][] = $key->tingkat;
			$id_tingkat[$key->id_jenjang][] = $key->id_tingkatan_kelas;
		}
		$data['nama_tingkat'] = $nama_tingkat;
		$data['id_tingkat'] = $id_tingkat;

		# ambil data kelas yang sekolahnya boarding aja
		$arraywhere=array('sekolah.kategori' => 'Sekolah', 'sekolah.boarding' => 'Ya', 'kelas.id_tahun' => $id_tahun);
		$data['d_kelas']= $this->m_models->getJoin1where("sekolah.id_sekolah, kelas.id_kelas, kelas.nama_kelas, kelas.id_tingkatan_kelas", "kelas","sekolah", "kelas.id_sekolah=sekolah.id_sekolah", $arraywhere, "kelas.nama_kelas", "ASC");
		#buat array sekolah berdasarkan id sekolah dan tingkat kelas
		$jumlah_kelas = 0;
		foreach ($data['d_kelas'] as $key) {
			$arr_kelas[$key->id_sekolah][$key->id_tingkatan_kelas][] = $key->nama_kelas;
			$arr_id_kelas[$key->id_sekolah][$key->id_tingkatan_kelas][] = $key->id_kelas;
			$jumlah_kelas++;
		}

		$data['kelas'] = $arr_kelas;
		$data['id_kelas'] = $arr_id_kelas;
		$data['jumlah_kelas'] = $jumlah_kelas;

		//----------------------------------------------------------------------------------------//
		//------------------------------- MENGAMBIL DATA ASRAMA ----------------------------------//
		# ambil data asrama
		if ($akses_pembinaaan == 'PutraPutri') {
			$data['asrama'] = $this->m_models->getAll("b_asrama ORDER BY nama ASC");
		}else{
			$data['asrama'] = $this->m_models->get_data("*","b_asrama", "WHERE jenis='$akses_pembinaaan' ORDER BY nama ASC");
		}
		
		# ambil data kamar		
		$arraywhere = array('b_kamar.status' => '1');
		$kamar = $this->m_models->getJoin1where("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", $arraywhere, "b_kamar.nama", "ASC");
		$jumlah_kamar = 0;
		foreach ($kamar as $key) {
			$jumlah_kamar++;
			$d_kamar[$key->id_asrama][] = $key->nama;
			$d_id_kamar[$key->id_asrama][] = $key->id_kamar;
		}

		$data['kamar'] = $d_kamar;
		$data['id_kamar'] = $d_id_kamar;
		$data['jumlah_kamar'] = $jumlah_kamar;
		//----------------------------------------------------------------------------------------//
		//
		# ambil data tahun akademik yang sedang aktif
		$data['ta'] = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE status_berjalan='ON'");

		$this->load->view('boarding/kamar_santri', $data); 

		$this->load->view('template/footer');
	}

	function proses_kamar(){
		$proses = false;
		$simpan_masuk = $this->input->post('simpan_masuk');	
		$simpan_pindah = $this->input->post('simpan_pindah');
		$simpan_keluar = $this->input->post('simpan_keluar');	


		if ($simpan_masuk != null) {
			$siswa = $this->input->post('siswa');
			$jml_siswa = count($this->input->post('siswa'));
			$tanggal_masuk = date_db($this->input->post('tanggal_masuk'));
			$tahun_akademik = $this->input->post('tahun_akademik');
			$siswa_pindahan = $this->input->post('siswa_pindahan');
			$kamar = $this->input->post('kamar');	

			# cari kapasitas kamar
			$data_kamar = $this->m_models->get_data("kapasitas", "b_kamar", "WHERE id_kamar='$kamar' ");
			$kapasitas = $data_kamar[0]->kapasitas;

			# cari isi kamar santri sekarang
			$isi_kamar = $this->m_models->getRows("b_kamar_santri WHERE id_kamar='$kamar' AND status='in' AND id_tahun='$tahun_akademik' ");

			# htiung sisa kuota
			$kuota = $kapasitas - $isi_kamar;

			if ($kamar != null) {
				if ($jml_siswa <= $kuota) {
					for ($i=0;$i<$jml_siswa;$i++){ 
						$data = array(
							'id_siswa' => $siswa[$i], 
							'id_kamar' => $kamar, 
							'masuk' => $tanggal_masuk, 
							'keluar' => '0000-00-00', 
							'pindah' => '0000-00-00',
							'id_tahun' => $tahun_akademik,
							'siswa_pindahan' => $siswa_pindahan,
							'status' => 'in' 
						);
						$proses = $this->m_models->save_data($data, 'b_kamar_santri');
					}
				}else{
					$this->session->set_flashdata('gagal', 'Data gagal disimpan, jumlah santri yang dipilih melebihi kapasitas kamar.');
				}
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kamar Tujuan tidak dipilih.');
			}

		}elseif ($simpan_pindah != null) {
			$siswa = $this->input->post('siswa');
			// $id = $this->input->post('id_kamar_santri');
			$jml_siswa = count($this->input->post('siswa'));
			$tanggal_pindah = date_db($this->input->post('tanggal_pindah'));
			$tahun_akademik = $this->input->post('tahun_akademik');
			$kamar_pindah = $this->input->post('kamar_pindah');	

			# cari kapasitas kamar
			$data_kamar = $this->m_models->get_data("kapasitas", "b_kamar", "WHERE id_kamar='$kamar_pindah' ");
			$kapasitas = 0;
			if (isset($data_kamar[0]->kapasitas)) {
				$kapasitas = $data_kamar[0]->kapasitas;
			}
			
			# cari isi kamar santri sekarang
			$isi_kamar = $this->m_models->getRows("b_kamar_santri WHERE id_kamar='$kamar_pindah' AND status='in' AND id_tahun='$tahun_akademik' ");

			# htiung sisa kuota
			$kuota = $kapasitas - $isi_kamar;

			if ($kamar_pindah != null) {
				if ($jml_siswa <= $kuota) {
					for ($i=0;$i<$jml_siswa;$i++){ 
						$exp = explode("_", $siswa[$i]);
						$id_siswa = $exp[0];
						$id_kamar_santri = $exp[1];

						$data_update = array('pindah' => $tanggal_pindah, 'status' => 'out');
						$proses = $this->m_models->update_data($id_kamar_santri, 'id_kamar_santri' ,$data_update, 'b_kamar_santri');

						$data = array(
							'id_siswa' => $id_siswa, 
							'id_kamar' => $kamar_pindah, 
							'masuk' => $tanggal_pindah, 
							'keluar' => '0000-00-00', 
							'pindah' => '0000-00-00',
							'id_tahun' => $tahun_akademik,
							'siswa_pindahan' => '0',
							'status' => 'in' 
						);
						$proses = $this->m_models->save_data($data, 'b_kamar_santri');	
					}
				}else{
					$this->session->set_flashdata('gagal', 'Data gagal disimpan, jumlah santri yang dipilih melebihi kapasitas kamar.');
				}
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kamar Tujuan tidak dipilih.');
			}
		}elseif ($simpan_keluar != null) {
			$siswa = $this->input->post('siswa');
			// $id = $this->input->post('id_kamar_santri');
			$jml_siswa = count($this->input->post('siswa'));
			$tanggal_keluar = date_db($this->input->post('tanggal_keluar'));

			for ($i=0;$i<$jml_siswa;$i++){ 
				$exp = explode("_", $siswa[$i]);
				//$id_siswa = $exp[0];
				$id_kamar_santri = $exp[1];

				$data = array('keluar' => $tanggal_keluar, 'status' => 'out' );
				$proses = $this->m_models->update_data($id_kamar_santri, 'id_kamar_santri' ,$data, 'b_kamar_santri');	
			}

		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
		//	$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/kamar_santri');
	
	}

	#santri
	function santri(){
		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$sekolah = $this->input->post('sekolah', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);

     	# kirim data form buat selected form
     	$data['sekolahpilih'] = $sekolah;
     	$data['tapilih'] = $tahun_akademik;

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$id_sekolah = $exp[1].'%';
		$kode_pengenal = $exp[2].'%';

		
		if ($sekolah != null AND $tahun_akademik != null) {

			# mencari data kamar santri
			$arraywhere = array('b_kamar_santri.id_siswa like ' => $kode_pengenal);
			$santri = $this->m_models->getJoin1where("b_kamar_santri.id_siswa, b_kamar_santri.id_kamar, b_kamar.nama", "b_kamar_santri", "b_kamar", "b_kamar_santri.id_kamar=b_kamar.id_kamar", $arraywhere, "b_kamar_santri.id_siswa", "ASC");
			foreach ($santri as $key) {
				$id_siswa = $key->id_siswa;
				$d_santri['kamar'][$id_siswa] = $key->nama;
				$d_santri['id_kamar'][$id_siswa] = $key->id_kamar;
			}

			# ambil data kamar untuk mecari nama asrama
			$d_asrama = $this->m_models->getJoin1("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", "b_kamar.nama", "ASC");
			foreach ($d_asrama as $key) {
				$asrama[$key->id_kamar] = $key->nama_asrama;
			}

			# mencari data wali asrama
			$walaswhere = array('b_walas.id_tahun ' => $tahun_akademik);
			$d_walas = $this->m_models->getJoin1where("b_walas.id_kamar, pegawai.nama, pegawai.tlp", "b_walas", "pegawai", "b_walas.nrp=pegawai.nrp", $walaswhere, "b_walas.id_walas", "ASC");
			foreach ($d_walas as $key) {
				$walas['nama'][$key->id_kamar] = $key->nama;
				$walas['telepon'][$key->id_kamar] = $key->tlp;
			}

			# mencari master data pegawai
			$d_pegawai = $this->m_models->get_data("nrp, nama, tlp", "pegawai", "");
			foreach ($d_pegawai as $key) {
				$pegawai['nama'][$key->nrp] = $key->nama;
				$pegawai['telepon'][$key->nrp] = $key->tlp;
			}

			$arrWhere=array($tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
			# cari data siswa dengan kriteria kondisi arrWhere di atas
			$siswa = $this->m_models->getJoin2Awhere($tabel_rombel.".*,".$tabel_siswa.".*, kelas.nama_kelas, kelas.nrp as wali_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas",  $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arrWhere,"", "id_siswa","asc");

			$jml_siswa = 0;

			foreach ($siswa as $key) {
				# cari id kamar siswa
				$id_kamar = $d_santri['id_kamar'][$key->id_siswa];

				# membuat data array yang akan ditampilkan berdasarkan data yang didapat
				$arr_resume['id_siswa'][] = $key->id_siswa;
				$arr_resume['nis'][] = $key->nis;
				$arr_resume['nisn'][] = $key->nisn;
 				$arr_resume['nama'][] = $key->nama_lengkap;
 				$arr_resume['kelas'][] = $key->nama_kelas;
 				$arr_resume['jk'][] = $key->jk;
 				$arr_resume['kamar'][] = $d_santri['kamar'][$key->id_siswa];
 				$arr_resume['asrama'][] = $asrama[$id_kamar];
 				$arr_resume['walas'][] = $walas['nama'][$id_kamar];
 				$arr_resume['telepon_walas'][] = $walas['telepon'][$id_kamar];
 				$arr_resume['wali_kelas'][] = $pegawai['nama'][$key->wali_kelas];
 				$arr_resume['telepon_wali_kelas'][] = $pegawai['telepon'][$key->wali_kelas]; 				
				$arr_resume['tempat_lahir'][] = $key->tempat_lahir;
				$arr_resume['tanggal_lahir'][] = $key->tanggal_lahir;
				$arr_resume['agama'][] = $key->agama;
				$arr_resume['warga_negara'][] = $key->warga_negara;
				$arr_resume['status_anak'][] = $key->status_anak;
				$arr_resume['anak_ke'][] = $key->anak_ke;
				$arr_resume['sdr_kandung'][] = $key->sdr_kandung;
				$arr_resume['rt'][] = $key->rt;
				$arr_resume['rw'][] = $key->rw;
				$arr_resume['jalan'][] = $key->jalan;
				$arr_resume['desa'][] = desa($key->desa);
				$arr_resume['kec'][] = kecamatan($key->kec);
				$arr_resume['kab'][] = kabupaten($key->kab);
				$arr_resume['provinsi'][] = provinsi($key->provinsi);
				$arr_resume['kodepos'][] = $key->kodepos;


 				# hitung jumlah siswa
				$jml_siswa = $jml_siswa + 1;
			}

		}

 		# kirim dara lengkap
 		$data['santri'] = $arr_resume;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;
		# kirim tabel siswanya
		$data['tabel_siswa'] = $tabel_siswa;
		# kirim tahun bulan cari
		$data['bulan_cari'] = $thnbln;

 		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahBoarding();

		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");

		# tampilkan data ke view
		$this->load->view('boarding/santri', $data); 

		$this->load->view('template/footer');		
	}

	#santri_walas
	function santri_walas(){
		$this->load->view('template/header');
        # Cek Level User untuk menentukan akses pembinaan
        $level_user = $this->session->userdata['hak_akses'];

        # get akses pembinaan
        $akses_pembinaaan = $this->getAksesPembinaan($level_user);

 		# ambil data dari form pencarian
		$sekolah = $this->input->post('sekolah', TRUE);
		$nrp_walas = $this->input->post('walas', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);

     	# kirim data form buat selected form
     	$data['sekolahpilih'] = $sekolah;
     	$data['walaspilih'] = $nrp_walas;
     	$data['tapilih'] = $tahun_akademik;

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$id_sekolah = $exp[1].'%';
		$kode_pengenal = $exp[2].'%';

		
		if ($sekolah != null AND $tahun_akademik != null) {

			# mencari data kamar santri
			$arraywhere = array('b_kamar_santri.id_siswa like ' => $kode_pengenal);
			$santri = $this->m_models->getJoin1where("b_kamar_santri.id_siswa, b_kamar_santri.id_kamar, b_kamar.nama", "b_kamar_santri", "b_kamar", "b_kamar_santri.id_kamar=b_kamar.id_kamar", $arraywhere, "b_kamar_santri.id_siswa", "ASC");
			foreach ($santri as $key) {
				$id_siswa = $key->id_siswa;
				$d_santri['kamar'][$id_siswa] = $key->nama;
				$d_santri['id_kamar'][$id_siswa] = $key->id_kamar;
			}

			# ambil data kamar untuk mecari nama asrama
			$d_asrama = $this->m_models->getJoin1("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", "b_kamar.nama", "ASC");
			foreach ($d_asrama as $key) {
				$asrama[$key->id_kamar] = $key->nama_asrama;
			}

			# mencari data wali asrama
			$walaswhere = array('b_walas.id_tahun ' => $tahun_akademik);
			$d_walas = $this->m_models->getJoin1where("b_walas.id_kamar, b_walas.nrp, pegawai.nama, pegawai.tlp", "b_walas", "pegawai", "b_walas.nrp=pegawai.nrp", $walaswhere, "b_walas.id_walas", "ASC");
			foreach ($d_walas as $key) {
				$walas['nrp'][$key->id_kamar] = $key->nrp;
				$walas['nama'][$key->id_kamar] = $key->nama;
				$walas['telepon'][$key->id_kamar] = $key->tlp;
			}

			# mencari master data pegawai
			$d_pegawai = $this->m_models->get_data("nrp, nama, tlp", "pegawai", "");
			foreach ($d_pegawai as $key) {
				$pegawai['nama'][$key->nrp] = $key->nama;
				$pegawai['telepon'][$key->nrp] = $key->tlp;
			}

			$arrWhere=array($tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah, 'b_kamar_santri.id_tahun' => $tahun_akademik);
			# cari data siswa dengan kriteria kondisi arrWhere di atas
			$siswa = $this->m_models->getJoin3where($tabel_rombel.".*,".$tabel_siswa.".*, kelas.nama_kelas, kelas.nrp as wali_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas",  $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", "b_kamar_santri", $tabel_rombel.".id_siswa=b_kamar_santri.id_siswa", $arrWhere,"", "id_siswa","asc");

			$jml_siswa = 0;

			foreach ($siswa as $key) {
				# cari id kamar siswa
				$id_kamar = $d_santri['id_kamar'][$key->id_siswa];

				if ($walas['nrp'][$id_kamar] == $nrp_walas) {
				
				# membuat data array yang akan ditampilkan berdasarkan data yang didapat
				$arr_resume['id_siswa'][] = $key->id_siswa;
				$arr_resume['nis'][] = $key->nis;
				$arr_resume['nisn'][] = $key->nisn;
 				$arr_resume['nama'][] = $key->nama_lengkap;
 				$arr_resume['kelas'][] = $key->nama_kelas;
 				$arr_resume['jk'][] = $key->jk;
 				$arr_resume['kamar'][] = $d_santri['kamar'][$key->id_siswa];
 				$arr_resume['asrama'][] = $asrama[$id_kamar];
 				$arr_resume['walas'][] = $walas['nama'][$id_kamar];
 				$arr_resume['telepon_walas'][] = $walas['telepon'][$id_kamar];
 				$arr_resume['wali_kelas'][] = $pegawai['nama'][$key->wali_kelas];
 				$arr_resume['telepon_wali_kelas'][] = $pegawai['telepon'][$key->wali_kelas]; 				
				$arr_resume['tempat_lahir'][] = $key->tempat_lahir;
				$arr_resume['tanggal_lahir'][] = $key->tanggal_lahir;
				$arr_resume['agama'][] = $key->agama;
				$arr_resume['warga_negara'][] = $key->warga_negara;
				$arr_resume['status_anak'][] = $key->status_anak;
				$arr_resume['anak_ke'][] = $key->anak_ke;
				$arr_resume['sdr_kandung'][] = $key->sdr_kandung;
				$arr_resume['rt'][] = $key->rt;
				$arr_resume['rw'][] = $key->rw;
				$arr_resume['jalan'][] = $key->jalan;
				$arr_resume['desa'][] = desa($key->desa);
				$arr_resume['kec'][] = kecamatan($key->kec);
				$arr_resume['kab'][] = kabupaten($key->kab);
				$arr_resume['provinsi'][] = provinsi($key->provinsi);
				$arr_resume['kodepos'][] = $key->kodepos;


 				# hitung jumlah siswa
				$jml_siswa = $jml_siswa + 1;

				}
			}

		}

 		# kirim dara lengkap
 		$data['santri'] = $arr_resume;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;
		# kirim tabel siswanya
		$data['tabel_siswa'] = $tabel_siswa;
		# kirim tahun bulan cari
		$data['bulan_cari'] = $thnbln;

 		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahBoarding();

		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");

        if ($akses_pembinaaan=='Putra') {
            $data['walas'] = $this->m_models->get_data("nrp, nama", "pegawai", "WHERE (id_sekolah='20' OR id_sekolah='21' OR id_sekolah='22') AND jk='Laki-laki' ORDER BY nama ASC");
        }elseif($akses_pembinaaan=='Putri') {
            $data['walas'] = $this->m_models->get_data("nrp, nama", "pegawai", "WHERE (id_sekolah='20' OR id_sekolah='21' OR id_sekolah='22') AND jk='Perempuan' ORDER BY nama ASC");
        }else{
            $data['walas'] = $this->m_models->get_data("nrp, nama", "pegawai", "WHERE (id_sekolah='20' OR id_sekolah='21' OR id_sekolah='22') ORDER BY nama ASC");
        }

		# tampilkan data ke view
		$this->load->view('boarding/santri_walas', $data); 

		$this->load->view('template/footer');	
	}
		
	

	#bagi_walas
	function bagi_walas(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

 		# ambil data dari form pencarian
		//$pembinaan = $this->input->post('pembinaan', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);

        #ini untuk akses pembinaan yang dari sesion bukan dari form pencarian
        $pembinaan = $akses_pembinaaan;

     	# kirim data form buat selected form
     	$data['pembinaanpilih'] = $pembinaan;
     	$data['tapilih'] = $tahun_akademik;

     	if ($pembinaan != null AND $tahun_akademik != null) {
			# mencari data kamar santri
			$data['kamar'] = $this->m_models->get_data("b_kamar.*, b_asrama.nama as nama_rayon", "b_kamar", "JOIN b_asrama ON b_kamar.id_asrama=b_asrama.id_asrama WHERE id_kamar NOT IN ( SELECT id_kamar FROM b_walas WHERE id_tahun='$tahun_akademik') AND b_kamar.status='1' AND b_asrama.jenis='$pembinaan' ");

			# mencari data karyawan yang jabatan walas
			if ($pembinaan=='Putra') {
				$jk = 'Laki-laki';
			}else{
				$jk = 'Perempuan';
			}

			$data['walas'] = $this->m_models->get_data("nrp, nama", "pegawai", "WHERE (id_sekolah='20' OR id_sekolah='21' OR id_sekolah='22') AND jk='$jk' ORDER BY nama ASC");

			# mencari data walas sebelum tahun akademik yang di pilih
			$tahun_akademik_sebelum = $tahun_akademik - 1;
			$walas_dulu = $this->m_models->get_data("nrp, id_kamar", "b_walas", "WHERE id_tahun='$tahun_akademik_sebelum'");
			foreach ($walas_dulu as $key) {
				$walas_sebelum[$key->id_kamar] = $key->nrp;
			}

			$data['walas_sebelum'] = $walas_sebelum;
     	}


		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");

		# tampilkan data ke view
		$this->load->view('boarding/bagi_walas', $data); 

		$this->load->view('template/footer');		
	}

	function simpan_walas(){
		$proses = false;
		$submit = $this->input->post('submit');	
	
		if ($submit != null) {
			$kamar = $this->input->post('kamar');
			$nrp = $this->input->post('nrp');
			$tahun_akademik = $this->input->post('tahun_akademik');
			$pembinaan = $this->input->post('pembinaan');
				
			if (count($kamar) > 0) { 
			for ($i = 0; $i < count($kamar); $i++){ 
				$id_kamar = $kamar[$i];
				if ($nrp[$id_kamar] != '') {
					# masukan ke array buat di simpan sekaligus
					$data[$i]['id_walas'] = '';
					$data[$i]['id_kamar'] = $id_kamar;
					$data[$i]['nrp'] = $nrp[$id_kamar];
					$data[$i]['id_tahun'] = $tahun_akademik;
					$data[$i]['pembinaan'] = $pembinaan;
				}
			}

			# proses simpan ke tabel perpus_anggota
			$proses = $this->m_models->save_batch($data,"b_walas");
			}

		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/bagi_walas');
	}

	function walas(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

 		# ambil data dari form pencarian
		//$pembinaan = $this->input->post('pembinaan', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);

        #ini untuk akses pembinaan yang dari sesion bukan dari form pencarian
        $pembinaan = $akses_pembinaaan;

     	# kirim data form buat selected form
     	//$data['pembinaanpilih'] = $pembinaan;
     	$data['tapilih'] = $tahun_akademik;

     	if ($pembinaan != null AND $tahun_akademik != null) {
			# mencari data kamar santri
			if ($akses_pembinaaan == 'PutraPutri') {
				$arraywhere = array('b_walas.id_tahun ' => $tahun_akademik);
			}else{
				$arraywhere = array('b_walas.id_tahun ' => $tahun_akademik, 'b_walas.pembinaan' => $pembinaan);
			}
			
			$data['walas'] = $this->m_models->getJoin2Awhere("b_walas.*, b_kamar.nama as nama_kamar, pegawai.nama", "b_walas", "b_kamar", "b_walas.id_kamar=b_kamar.id_kamar", "pegawai", "b_walas.nrp=pegawai.nrp", $arraywhere, "b_walas.id_walas", "ASC");

			if ($pembinaan=='Putra') {
				$jk = 'Laki-laki';
			}else{
				$jk = 'Perempuan';
			}
			# mencari data karyawan yang jabatan walas dan jenis kelamin sesuai putra putri
			$data['pegawai'] = $this->m_models->get_data("nrp, nama", "pegawai", "WHERE (id_sekolah='20' OR id_sekolah='21' OR id_sekolah='22') AND jk='$jk' ORDER BY nama ASC");

			# ambil data kamar nama asrama
			$asrama = $this->m_models->getJoin1("b_asrama.nama as nama_rayon, b_kamar.id_kamar", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", "b_kamar.id_kamar", "ASC");
			foreach ($asrama as $key) {
				$asrama[$key->id_kamar] = $key->nama_rayon;
			}

			$data['asrama'] = $asrama;

     	}

		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");
		# ambil data tahun akademik aktif
		$data['ta_aktif'] = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON' ORDER BY periode DESC");

		# tampilkan data ke view
		$this->load->view('boarding/walas', $data); 

		$this->load->view('template/footer');			
	}

	function edit_walas(){
		$id_walas = $this->input->post('id_walas', TRUE);
		$nrp = $this->input->post('nrp', TRUE);

 		$data = array ('nrp' => $nrp);

		# proses simpan
		if ($this->m_models->update_data($id_walas, 'id_walas', $data, "b_walas") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/walas');
	}

	function getTahunAkademik($tanggal){
		# ambil data tahun akademik 
		$data = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE tanggal_mulai <= '$tanggal' AND tanggal_selesai >= '$tanggal'");
		$id_tahun = $data[0]->id_tahun;

		return $id_tahun;
	}

	#mutasi
	function mutasi(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# ambil data dari post pencarian
		$rentang_tanggal = $this->input->post('rentang_tanggal', TRUE); 
		$jenis_mutasi = $this->input->post('mutasi', TRUE);
		$data['mutasi_pilih'] = $jenis_mutasi;

		if ($rentang_tanggal != null AND $jenis_mutasi != null) {
			$exp = explode("-",$rentang_tanggal);
			$tanggal_dari = date_db(trim($exp[0]));
			$tanggal_sampai = date_db(trim($exp[1]));

			$rayon = $this->getRayon();

			if ($jenis_mutasi == 'mutasi_masuk') {
				$santri = $this->m_models->get_data("b_kamar_santri.id_siswa, b_kamar_santri.masuk, b_kamar_santri.id_kamar, b_kamar.nama as nama_kamar", "b_kamar_santri", "JOIN b_kamar ON b_kamar_santri.id_kamar=b_kamar.id_kamar WHERE b_kamar_santri.siswa_pindahan='1' AND b_kamar_santri.masuk >= '$tanggal_dari' AND  b_kamar_santri.masuk <= '$tanggal_sampai' ORDER BY b_kamar_santri.masuk ASC");
			}else{
				$santri = $this->m_models->get_data("b_kamar_santri.id_siswa, b_kamar_santri.keluar, b_kamar_santri.id_kamar, b_kamar.nama as nama_kamar", "b_kamar_santri", "JOIN b_kamar ON b_kamar_santri.id_kamar=b_kamar.id_kamar WHERE b_kamar_santri.keluar >= '$tanggal_dari' AND  b_kamar_santri.keluar <= '$tanggal_sampai' ORDER BY b_kamar_santri.keluar ASC");
			}

			foreach ($santri as $key) {
				$id_siswa = $key->id_siswa;
				$jenjang=db_siswa($id_siswa);

				if ($jenis_mutasi == 'mutasi_masuk') {
					$d_santri['tanggal'][] = mediumdate_indo($key->masuk);
					$id_tahun = $this->getTahunAkademik($key->masuk);
				}else{
					$d_santri['tanggal'][] = mediumdate_indo($key->keluar);
					$id_tahun = $this->getTahunAkademik($key->keluar);					
				}

				$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'][] = $nama;
				$nis=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nis");
				$d_santri['nis'][] = $nis;
				$d_santri['kamar'][] = $key->nama_kamar;
				$d_santri['rayon'][] = $rayon[$key->id_kamar];
				$d_santri['jenjang'][] = strtoupper($jenjang);

				$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $id_tahun, 
					'rombongan_belajar_'.$jenjang.'.id_siswa' => $id_siswa);
				$kelas = $this->m_models->getJoin1where("kelas.nama_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
				$d_santri['kelas'][] = $kelas[0]->nama_kelas;

			}
			$data['jumlah_santri'] = count($santri);
			
			$data['santri'] = $d_santri;	
		}

		$this->load->view('boarding/mutasi',$data);

		$this->load->view('template/footer');		
	}

	#resume_mutasi
	function resume_mutasi(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# ambil data dari post pencarian
		$bulan  = $this->input->post('bln', TRUE);
        $tahun  = $this->input->post('thn', TRUE);
        $thnbln = $tahun.'-'.$bulan;
        $thnblntgl = $tahun.'-'.$bulan.'-15';
        $akhir_bulan = date('Y-m-t', strtotime($thnbln.'-01'));
        $bln_sebelum = date('m', strtotime($thnblntgl . '- 1 month'));
        $bulan_sebelum = date('Y-m', strtotime($thnblntgl . '- 1 month'));
		$akhir_bulan_sebelum = date('Y-m-t', strtotime($bulan_sebelum.'-01'));

        $data['bln_pilih'] = $bulan;
        $data['bln_sebelum'] = $bln_sebelum;
        $data['thn_pilih'] = $tahun;

        if ($bulan != NULL AND $tahun != NULL) {
        	$id_tahun = $this->getTahunAkademik($thnbln.'-01');

        	$rayon = $this->getRayon();
       	
        	
        	# ambil data walas order by nama untuk dapatkan nama semua wala
        	$walas = $this->m_models->get_data("b_walas.*, pegawai.nama as nama_walas", "b_walas", " JOIN pegawai ON b_walas.nrp=pegawai.nrp WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' GROUP BY b_walas.nrp ORDER BY pegawai.nama ASC ");
        	foreach ($walas as $key) {
        		# set kosong tiap perulangan
        		$nama_rayon = '';
        		$nama_kamar = '';
        		$nama_rayon_tmp = '';
        		$total_jml_santri_bulan_cari = 0;
        		$total_jml_santri_sebelum_bulan_cari = 0;
        		$total_jml_santri_keluar_bulan_cari = 0;
        		$nama_kelas = '';
        		$nama_kelas_tmp = '';
        		$nama_kelas_tmp1 = '';

		        # mencari data kamar tiap walas
		        $kamar = $this->m_models->get_data("b_kamar.nama as nama_kamar, b_walas.id_kamar", "b_walas", " JOIN b_kamar ON b_walas.id_kamar=b_kamar.id_kamar WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' AND b_walas.nrp='$key->nrp' ORDER BY b_kamar.id_asrama DESC");
		        foreach ($kamar as $kam) {
		        	# mengisi nama-nama kamar
		        	$nama = $kam->nama_kamar;
		        	if ($nama_kamar == '') {
		        		$nama_kamar = $nama;
		        	}else{
		        		$nama_kamar = $nama_kamar.', '.$nama;
		        	}

		        	# mengisi nama rayon
		        	if ($nama_rayon == '') {
		        		$nama_rayon = $rayon[$kam->id_kamar];
		        	}elseif ($nama_rayon_tmp != $rayon[$kam->id_kamar]) {
		        		$nama_rayon = $nama_rayon .' &bull; '.$rayon[$kam->id_kamar];
		        	}
		        	$nama_rayon_tmp = $rayon[$kam->id_kamar];

		        	# mengisi nama kelas
		        	$nama_kelas_tmp1 = $this->get1Kelas($kam->id_kamar, $id_tahun);
		        	if ($nama_kelas == '') {
		        		$nama_kelas = $nama_kelas_tmp1;
		        	}elseif ($nama_kelas_tmp != $nama_kelas_tmp1) {
		        		$nama_kelas = $nama_kelas  .' &bull; '. $nama_kelas_tmp1;
		        	}
		        	$nama_kelas_tmp = $nama_kelas_tmp1;

		        	# mencari jumlah santri aktif pada bulan cari
		        	$jml_santri_bulan_cari = $this->JumlahSantriPerKamar($kam->id_kamar, $akhir_bulan, $id_tahun);
		        	$total_jml_santri_bulan_cari += $jml_santri_bulan_cari;
		        	$sum_santri_bulan_cari += $jml_santri_bulan_cari;

		        	# mencari jumlah santri aktif sebelum bulan cari
		        	$jml_santri_sebelum_bulan_cari = $this->JumlahSantriPerKamar($kam->id_kamar, $akhir_bulan_sebelum, $id_tahun);
		        	$total_jml_santri_sebelum_bulan_cari += $jml_santri_sebelum_bulan_cari;
		        	$sum_santri_sebelum_bulan_cari += $jml_santri_sebelum_bulan_cari;

		        	# mencari jumlah santri pindah pada bulan cari
		        	$jml_santri_pindah_bulan_cari = $this->JumlahMutasiMasuk($kam->id_kamar, $thnbln, $id_tahun);
		        	$total_jml_santri_pindah_bulan_cari += $jml_santri_pindah_bulan_cari;
		        	$sum_santri_pindah_bulan_cari += $jml_santri_pindah_bulan_cari;;

		        	# mencari jumlah santri keluar pada bulan cari
		        	$jml_santri_keluar_bulan_cari = $this->JumlahMutasiKeluar($kam->id_kamar, $thnbln, $id_tahun);
		        	$total_jml_santri_keluar_bulan_cari += $jml_santri_keluar_bulan_cari;
		        	$sum_santri_keluar_bulan_cari += $jml_santri_keluar_bulan_cari;

		        	# mencari kelas berdasarkan sample santri karena biasanya sama kelasnya
		        	//$kelas = $this->get1Kelas($kam->id_kamar, $id_tahun);
		        }

        		$d_resume['walas'][] = $key->nama_walas;
        		$d_resume['kelas'][] = $nama_kelas;
        		$d_resume['rayon'][] = $nama_rayon;
        		$d_resume['kamar'][] = $nama_kamar;
        		$d_resume['jml_sebelum_bulan_cari'][] = $total_jml_santri_sebelum_bulan_cari;
        		$d_resume['jml_santri_pindahan'][] = $total_jml_santri_pindah_bulan_cari;
        		$d_resume['jml_santri_keluar'][] = $total_jml_santri_keluar_bulan_cari;
        		$d_resume['jml_bulan_cari'][] = $total_jml_santri_bulan_cari;
        	}

        	$data['resume'] = $d_resume;
   			$data['sum_santri_bulan_cari'] = $sum_santri_bulan_cari;
   			$data['sum_santri_sebelum_bulan_cari'] = $sum_santri_sebelum_bulan_cari;
   			$data['sum_santri_pindah_bulan_cari'] = $sum_santri_pindah_bulan_cari;
   			$data['sum_santri_keluar_bulan_cari'] = $sum_santri_keluar_bulan_cari;
        	$data['jumlah_walas'] = count($walas);

        }

		$this->load->view('boarding/resume_mutasi',$data);

		$this->load->view('template/footer');			
	}
/*
	function getKamarPerWalas($akses_pembinaaan, $nrp, $id_tahun){
        # mencari data kamar tiap walas
        $kamar = $this->m_models->get_data("b_kamar.nama", "b_walas", " JOIN b_kamar ON b_walas.id_kamar=b_kamar.id_kamar WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' AND b_walas.nrp='$nrp' ORDER BY b_kamar.id_asrama ASC");
        foreach ($kamar as $key) {
        	$nama = $key->nama;
        	echo $key->nama;
        	if ($nama_kamar == '') {
        		$nama_kamar = $nama;
        	}else{
        		$nama_kamar = $nama_kamar.','.$nama;
        	}
        } 

        return $nama_kamar;
	}
*/
	#JumlahSantriPerKamar
	function JumlahSantriPerKamar($id_kamar, $akhir_bulan, $tahun_akademik){
		# cari jumlah santri baru yang masuk, yang siswa_pindah false
		$arraywhere = array(
			'b_kamar_santri.id_kamar' => $id_kamar,
			'b_kamar_santri.siswa_pindahan' => '0', 
			'b_kamar_santri.id_tahun' => $tahun_akademik
		);
		$santri_baru = $this->m_models->getRowsAWhere("id_siswa", "b_kamar_santri", $arraywhere, "id_siswa", "ASC");

		# cari jumlah santri yang masuk pindahan sampai akhir bulan tgl cari
		$arraywhere2 = array(
			'b_kamar_santri.id_kamar' => $id_kamar,
			'b_kamar_santri.siswa_pindahan' => '1', 
			'b_kamar_santri.id_tahun' => $tahun_akademik,
			'b_kamar_santri.masuk <=' => $akhir_bulan
		);
		$santri_pindahan = $this->m_models->getRowsAWhere("id_siswa", "b_kamar_santri", $arraywhere2, "id_siswa", "ASC");		

		# cari jumlah santri yang keluar sampai akhir bulan tgl cari
		$arraywhere3 = array(
			'b_kamar_santri.id_kamar' => $id_kamar,
			'b_kamar_santri.id_tahun' => $tahun_akademik,
			'b_kamar_santri.keluar !=' => '0000-00-00',
			'b_kamar_santri.keluar <=' => $akhir_bulan
		);
		$santri_keluar = $this->m_models->getRowsAWhere("id_siswa", "b_kamar_santri", $arraywhere3, "id_siswa", "ASC");

		# hitung santri aktif pada bulan cari
		$jumlah_santri = $santri_baru + $santri_pindahan - $santri_keluar;
		return $jumlah_santri;
	}

	function JumlahMutasiMasuk($id_kamar, $bulan, $tahun_akademik){
		# cari jumlah santri yang masuk pindahan sampai akhir bulan tgl cari
		$arraywhere = array(
			'b_kamar_santri.id_kamar' => $id_kamar,
			'b_kamar_santri.siswa_pindahan' => '1', 
			'b_kamar_santri.id_tahun' => $tahun_akademik,
			'b_kamar_santri.masuk like' => $bulan.'%'
		);
		$santri_pindahan = $this->m_models->getRowsAWhere("id_siswa", "b_kamar_santri", $arraywhere, "id_siswa", "ASC");		

		return $santri_pindahan;
	}

	function JumlahMutasiKeluar($id_kamar, $bulan, $tahun_akademik){
		# cari jumlah santri yang masuk pindahan sampai akhir bulan tgl cari
		$arraywhere = array(
			'b_kamar_santri.id_kamar' => $id_kamar,
			'b_kamar_santri.id_tahun' => $tahun_akademik,
			'b_kamar_santri.keluar like' => $bulan.'%'
		);
		$santri_keluar = $this->m_models->getRowsAWhere("id_siswa", "b_kamar_santri", $arraywhere, "id_siswa", "ASC");		

		return $santri_keluar;
	}

	function get1Kelas($id_kamar, $tahun_akademik){

		$santri = $this->m_models->get_data("id_siswa", "b_kamar_santri", "WHERE id_kamar='$id_kamar' AND id_tahun='$tahun_akademik'");

		$id_siswa = $santri[0]->id_siswa; 

		$jenjang=db_siswa($id_siswa);

		if ($jenjang != '') {
			$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $tahun_akademik, 
							'rombongan_belajar_'.$jenjang.'.id_siswa' => $id_siswa);
			$kelas = $this->m_models->getJoin1where("kelas.nama_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
			$nama_kelas = $kelas[0]->nama_kelas;
		}

		return $nama_kelas;
	}

	function getTingkatKelas($nama_kelas, $tahun_akademik){
		$arraywhere = array('kelas.nama_kelas' => $nama_kelas, 'kelas.id_tahun' =>  $tahun_akademik);
		$kelas = $this->m_models->getJoin1where("tingkatan_kelas.tingkat", "kelas", "tingkatan_kelas", "kelas.id_tingkatan_kelas=tingkatan_kelas.id_tingkatan_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
		$tingkat = $kelas[0]->tingkat;

		return $tingkat;		
	}

	#jumlah_santri
	function jumlah_santri(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# ambil data dari post pencarian
		$jenjang  = $this->input->post('jenjang', TRUE); 
		$bulan  = $this->input->post('bln', TRUE);
        $tahun  = $this->input->post('thn', TRUE);
        $thnbln = $tahun.'-'.$bulan;
        $thnblntgl = $tahun.'-'.$bulan.'-15';
        $akhir_bulan = date('Y-m-t', strtotime($thnbln.'-01'));
        $bln_sebelum = date('m', strtotime($thnblntgl . '- 1 month'));
        $bulan_sebelum = date('Y-m', strtotime($thnblntgl . '- 1 month'));
		$akhir_bulan_sebelum = date('Y-m-t', strtotime($bulan_sebelum.'-01'));

		$data['kamar'] = $this->m_models->get_data("b_kamar.nama, b_kamar.id_kamar", "b_kamar", " GROUP BY nama ORDER BY id_kamar ASC");
		$tot_kamar = count($data['kamar']);
		$data['tot_kamar'] = $tot_kamar;

		$data['jenjangpilih'] = $jenjang;
        $data['bln_pilih'] = $bulan;
        $data['bln_sebelum'] = $bln_sebelum;
        $data['thn_pilih'] = $tahun;

        if ($bulan != NULL AND $tahun != NULL) {
        	$id_tahun = $this->getTahunAkademik($thnbln.'-01');

        	# ambil data seua rayon sesuai akses pembinaan
        	$x = 0;
        	$rayon = $this->m_models->get_data("*", "b_asrama", "WHERE jenis='$akses_pembinaaan' ORDER BY nama ASC");
        	foreach ($rayon as $key) {
        		$jumlah_kamar_per_rayon = 0;
        		$jumlah_santri_per_rayon = 0;
        		$nama_kelas_tmp1 = array('');
        		$kelas = '';
        		$jumlah_santri_per_kamar = 0;

        	 	# cari data kamar sesuai id_asrama
        	 	$kamar = $this->m_models->get_data("id_kamar, nama", "b_kamar", "WHERE id_asrama='$key->id_asrama' AND status='1'");
        	 	foreach ($kamar as $kam) {
        	 		$nama_rayon = $key->nama;
        	 		
        	 		# mencari kelas tiap rayon
        	 		$n_kelas = $this->get1Kelas($kam->id_kamar, $id_tahun);
		        	$nama_kelas_tmp1[] = $n_kelas;

		        //	$exp = explode(' ', $n_kelas);
		        //	$tingkatan_kelas = $exp[0];
		        	$tingkatan_kelas = $this->getTingkatKelas($n_kelas, $id_tahun);

		        	# cek jejang cari sama dengan data jenjang santri, jika ya sama baru itung
		        	$jenjang_santri = $this->cekJenjang($tingkatan_kelas);
		        	if ($jenjang_santri == $jenjang OR $jenjang == 'SMPSMA') { 
	        	 		# cari jumlah santri per kamar
	        	 		$jumlah_santri_per_kamar = $this->JumlahSantriPerKamar($kam->id_kamar, $akhir_bulan, $id_tahun);
	        	 		$santri_per_kamar[$kam->nama][$nama_rayon] = $jumlah_santri_per_kamar;

	        	 		# buat jumlah santri per tingkatan kelas di array
	        	 		$jumlah_santri_per_kelas[$tingkatan_kelas][$x] = $jumlah_santri_per_kamar;

	        	 		# buat ngecek aja data sebenarnya yang ke ambil
	        	 		//$santri_per_kamar_rayon[$x] = $key->nama . ' '.$jumlah_santri_per_kamar;

	        	 		# simpan tingakatan kelas 
	        	 		$tingkatan[$x] = $tingkatan_kelas;

	        	 		# perhitungan jumlah santri per rayon
	        	 		$jumlah_santri_per_rayon += $jumlah_santri_per_kamar; 

	        	 		# nama rayon
	        	 		$d_rayon[$x] = $nama_rayon;

	        	 		$x++;
		        	}
        	 	}

	        	 	# mengisi data kelas
	        	 	$arr_kelas = array_unique($nama_kelas_tmp1);
	        	 	foreach ($arr_kelas as $key => $value) {
	        	 		if ($value != '') {
	        	 			$nm_kelas = $value.'<br>';
	        	 			$kelas = $kelas.$nm_kelas;
	        	 		}
	        	 	}
	        	 	$nama_kelas[$nama_rayon] = $kelas;

	        	 	# jumlah santri per rayon
	        	 	$jumlah_santri[$nama_rayon] = $jumlah_santri_per_rayon;

	        	 	# jumlah kamar per rayon
	        	 	$jumlah_kamar[$nama_rayon] = count($kamar);
	        	 	$nama_rayon = '';

        	 } 

        	$rayon_unix = array_unique($d_rayon);
        	$data['rayon'] = $rayon_unix;

        	$data['jumlah_rayon'] = $i;
        	$data['kelas'] = $nama_kelas;
        	$data['santri_per_kamar'] = $santri_per_kamar;

        	// buat ngecek aja
        	//$data['santri_per_kamar_rayon'] = $santri_per_kamar_rayon;

        	$data['jumlah_kamar'] = $jumlah_kamar;
        	$data['jumlah_santri'] = $jumlah_santri;
        	$data['total_kamar'] = array_sum($jumlah_kamar);
        	$data['total_santri'] =array_sum($jumlah_santri);

        	# perhitungan buat jumlah santri per tingkatan kelas
        	
        	$tingkatan_unik = array_unique($tingkatan);
        	foreach ($tingkatan_unik as $key => $value) {
				$jml_tmp = 0;
			    for ($a=0; $a <= $x; $a++) { 
        			$jml_tmp += $jumlah_santri_per_kelas[$value][$a];
        		}	
        		$arr_jumlah_per_tingkatan_kelas[$value] = $jml_tmp;
        	}
        	
        	$data['jumlah_santri_per_tingkatan'] = $arr_jumlah_per_tingkatan_kelas;
        }
		
		$this->load->view('boarding/jumlah_santri',$data);
		
		if ($bulan != NULL AND $tahun != NULL) {
			$this->load->view('boarding/jumlah_santri_per_kelas',$data);
		}


		$this->load->view('template/footer');			
	}

	function cekJenjang($tingkatan_kelas){
		$SMP = array('VII', 'VIII', 'IX');
		$SMA = array('X', 'XI', 'XII');

		if (in_array(trim($tingkatan_kelas), $SMP)) {
			return 'SMP';
		}

		if (in_array(trim($tingkatan_kelas), $SMA)) {
			return 'SMA';
		}
	}

	#input_siswa_sakit
	# Fungsi untuk input siswa yang sakit
	function input_siswa_sakit(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];

		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		//------------------ MENGAMBIL DATA KELAS YANG AKTIF SESUAI TAHUN AKADEMIK ---------------//
		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;

		# ambil data sekolah boarding
		$data['sekolah'] = $this->getSekolahBoarding();
		# ambil data tingkatan kelas ex: kelas X, XI, XII
		$tingkat = $this->m_models->get_data("id_tingkatan_kelas, id_jenjang, tingkat", "tingkatan_kelas", "ORDER BY id_tingkatan_kelas");
		foreach ($tingkat as $key) {
			$nama_tingkat[$key->id_jenjang][] = $key->tingkat;
			$id_tingkat[$key->id_jenjang][] = $key->id_tingkatan_kelas;
		}
		$data['nama_tingkat'] = $nama_tingkat;
		$data['id_tingkat'] = $id_tingkat;

		# ambil data kelas yang sekolahnya boarding aja
		$arraywhere=array('sekolah.kategori' => 'Sekolah', 'sekolah.boarding' => 'Ya', 'kelas.id_tahun' => $id_tahun);
		$data['d_kelas']= $this->m_models->getJoin1where("sekolah.id_sekolah, kelas.id_kelas, kelas.nama_kelas, kelas.id_tingkatan_kelas", "kelas","sekolah", "kelas.id_sekolah=sekolah.id_sekolah", $arraywhere, "kelas.nama_kelas", "ASC");
		#buat array sekolah berdasarkan id sekolah dan tingkat kelas
		$jumlah_kelas = 0;
		foreach ($data['d_kelas'] as $key) {
			$arr_kelas[$key->id_sekolah][$key->id_tingkatan_kelas][] = $key->nama_kelas;
			$arr_id_kelas[$key->id_sekolah][$key->id_tingkatan_kelas][] = $key->id_kelas;
			$jumlah_kelas++;
		}

		$data['kelas'] = $arr_kelas;
		$data['id_kelas'] = $arr_id_kelas;
		$data['jumlah_kelas'] = $jumlah_kelas;

		//----------------------------------------------------------------------------------------//
		//------------------------------- MENGAMBIL DATA ASRAMA ----------------------------------//
		# ambil data asrama
		/*
		if ($akses_pembinaaan == 'PutraPutri') {
			$data['asrama'] = $this->m_models->getAll("b_asrama ORDER BY nama ASC");
		}else{
			$data['asrama'] = $this->m_models->get_data("*","b_asrama", "WHERE jenis='$akses_pembinaaan' ORDER BY nama ASC");
		}
		
		# ambil data kamar		
		$kamar = $this->m_models->getJoin1("b_asrama.nama as nama_asrama, b_asrama.id_asrama, b_kamar.*", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", "b_kamar.nama", "ASC");
		$jumlah_kamar = 0;
		foreach ($kamar as $key) {
			$jumlah_kamar++;
			$d_kamar[$key->id_asrama][] = $key->nama;
			$d_id_kamar[$key->id_asrama][] = $key->id_kamar;
		}

		$data['kamar'] = $d_kamar;
		$data['id_kamar'] = $d_id_kamar;
		$data['jumlah_kamar'] = $jumlah_kamar;
		*/
		//----------------------------------------------------------------------------------------//
		//
		# ambil data tahun akademik yang sedang aktif
		$data['ta'] = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE status_berjalan='ON'");

		$this->load->view('kesehatan/input_siswa_sakit', $data); 

		$this->load->view('template/footer');
	}

	function simpan_siswa_sakit(){
		$user = $this->session->userdata['nrp'];
		$proses = false;
		$simpan = $this->input->post('simpan');		
		$jml_siswa = count($this->input->post('siswa'));

		if ($simpan!= null AND $jml_siswa != 0) {
			$siswa = $this->input->post('siswa');
			$tanggal_sakit = date_db($this->input->post('tanggal_sakit'));
			$penyakit = $this->input->post('penyakit');
			$tahun_akademik = $this->input->post('tahun_akademik');			
			$id_kelas = $this->input->post('id_kelas');	
			$jk = $this->input->post('jk');
			if ($jk == 'Laki-laki') {
				$pembinaan = 'Putra';
			}else{
				$pembinaan = 'Putri';
			}

			for ($i=0;$i <$jml_siswa;$i ++){ 	
				$cek_data = $this->m_models->getRows("siswa_sakit WHERE id_siswa='$siswa[$i]' AND tanggal_sakit='$tanggal_sakit' ");
				$id_siswa = $siswa[$i];
				$penyakit_siswa = $penyakit[$id_siswa];
				if ($cek_data == 0 AND $penyakit != '') { 
					$data = array(
						'id_siswa' => $id_siswa, 
						'id_kelas' => $id_kelas, 
						'id_tahun' => $tahun_akademik,
						'id_penyakit' => $penyakit_siswa,
						'tanggal_sakit' => $tanggal_sakit, 
						'pembinaan' => $pembinaan, 
						'nrp' => $user 
					);

					$proses = $this->m_models->save_data($data, 'siswa_sakit');
				}
			}
		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/input_siswa_sakit');
	}

	function input_sakit(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];

		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		//------------------ MENGAMBIL DATA KELAS YANG AKTIF SESUAI TAHUN AKADEMIK ---------------//
		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;

		# ambil data sekolah boarding
		$data['sekolah'] = $this->getSekolahBoarding();
		# ambil data tingkatan kelas ex: kelas X, XI, XII
		$tingkat = $this->m_models->get_data("id_tingkatan_kelas, id_jenjang, tingkat", "tingkatan_kelas", "ORDER BY id_tingkatan_kelas");
		foreach ($tingkat as $key) {
			$nama_tingkat[$key->id_jenjang][] = $key->tingkat;
			$id_tingkat[$key->id_jenjang][] = $key->id_tingkatan_kelas;
		}
		$data['nama_tingkat'] = $nama_tingkat;
		$data['id_tingkat'] = $id_tingkat;

		# ambil data kelas yang sekolahnya boarding aja
		$arraywhere=array('sekolah.kategori' => 'Sekolah', 'sekolah.boarding' => 'Ya', 'kelas.id_tahun' => $id_tahun);
		$data['d_kelas']= $this->m_models->getJoin1where("sekolah.id_sekolah, kelas.id_kelas, kelas.nama_kelas, kelas.id_tingkatan_kelas", "kelas","sekolah", "kelas.id_sekolah=sekolah.id_sekolah", $arraywhere, "kelas.nama_kelas", "ASC");
		#buat array sekolah berdasarkan id sekolah dan tingkat kelas
		$jumlah_kelas = 0;
		foreach ($data['d_kelas'] as $key) {
			$arr_kelas[$key->id_sekolah][$key->id_tingkatan_kelas][] = $key->nama_kelas;
			$arr_id_kelas[$key->id_sekolah][$key->id_tingkatan_kelas][] = $key->id_kelas;
			$jumlah_kelas++;
		}

		$data['kelas'] = $arr_kelas;
		$data['id_kelas'] = $arr_id_kelas;
		$data['jumlah_kelas'] = $jumlah_kelas;

		# ambil data tahun akademik yang sedang aktif
		$data['ta'] = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE status_berjalan='ON'");

		$this->load->view('kesehatan/input_sakit', $data); 

		$this->load->view('template/footer');
	}
	#simpan_sakit
	function simpan_sakit(){
		$user = $this->session->userdata['nrp'];
		$proses = false;
		$simpan = $this->input->post('simpan');		

		if ($simpan!= null) {
			$siswa = $this->input->post('pasien');
			$tanggal_sakit = date_db($this->input->post('tanggal_sakit'));
			$penyakit = $this->input->post('penyakit');
			$keluhan = $this->input->post('keluhan');
			$therapy = $this->input->post('therapy');
			$tahun_akademik = $this->input->post('tahun_akademik');			
			$id_kelas = $this->input->post('id_kelas');	
			$id_sekolah = $this->input->post('id_sekolah');
			# jika id sekolah 7 yang arttinya STQ ga usah isi pembinaan
			if ($id_sekolah != '7') {
				$jk = $this->input->post('jk');
			}
			
			if ($jk == 'Laki-laki') {
				$pembinaan = 'Putra';
			}elseif($jk == 'Perempuan'){
				$pembinaan = 'Putri';
			}else{
				$pembinaan = '';
			}
 	
				$cek_data = $this->m_models->getRows("siswa_sakit WHERE id_siswa='$siswa' AND tanggal_sakit='$tanggal_sakit' ");
				$id_siswa = $siswa;
				if ($cek_data == 0 AND $penyakit != '') { 
					$data = array(
						'id_siswa' => $id_siswa, 
						'id_kelas' => $id_kelas, 
						'id_sekolah' => $id_sekolah, 
						'id_tahun' => $tahun_akademik,
						'id_penyakit' => $penyakit,
						'tanggal_sakit' => $tanggal_sakit, 
						'pembinaan' => $pembinaan, 
						'nrp' => $user,
						'keluhan' => $keluhan, 
						'therapy' => $therapy
					);

					$proses = $this->m_models->save_data($data, 'siswa_sakit');
				}
		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/input_sakit');
	}

	# fungsi mengambil data siswa kelas buat JS
	public function getsiswa2(){
		$this->load->view('template/head');
		$sekolah=$this->input->get('kelas'); 
		
		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';
		$id_sekolah = str_replace("0", "", $exp[1]);
		$id_kelas = $exp[2];
		# kirim data 
		$data['id_kelas'] = $id_kelas;
		$data['id_sekolah'] = $id_sekolah;
		$nrp = $this->session->userdata['nrp'];
		$data['petugas'] = $this->m_models->get_data("nama, nrp", "pegawai", "WHERE nrp='$nrp'");

		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;
		
		# query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		if ($tabel_siswa == 'siswa_pt') {
			$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun);
		}else{
			$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun, $tabel_rombel.".id_kelas" => $id_kelas);
		}
		
		$data['siswa'] = $this->m_models->getJoin1where($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, "nama_lengkap", "ASC");

		$data['jk'] = '';
		if (isset($data['siswa'][0]->jk)) {
			$data['jk'] = $data['siswa'][0]->jk;
		}
		
		# ambil data penyakit
		$data['penyakit'] = $this->m_models->getAll("penyakit WHERE status='ON' ORDER BY nama_penyakit ASC");

		$this->load->view('kesehatan/form_sakit',$data);
		
		$this->load->view('template/js');
	}

	# fungsi mengambil data mahasantri buat JS
	public function getSDM(){
		$this->load->view('template/head');
		
		$nrp = $this->session->userdata['nrp'];
		$data['petugas'] = $this->m_models->get_data("nama, nrp", "pegawai", "WHERE nrp='$nrp'");
		
		$data['sdm'] = $this->m_models->get_data("pegawai.nama, pegawai.nrp", "pegawai", "WHERE status_aktf='Aktif' ORDER By nama ASC");

		# ambil data penyakit
		$data['penyakit'] = $this->m_models->getAll("penyakit WHERE status='ON' ORDER BY nama_penyakit ASC");

		$this->load->view('kesehatan/form_sakit_sdm', $data);
		
		$this->load->view('template/js');
	}

	/* --------------------------------- PERIZINAN --------------------------------------- */

	function waktu_perizinan(){
		$this->load->view('template/header');

		# ambil data asrama
		$data[waktu_perizinan] = $this->m_models->get_data("*", "b_waktu_perizinan", "");

		# tampilkan data ke view
		$this->load->view('boarding/waktu_perizinan', $data); 

		$this->load->view('template/footer');
	}

	function edit_waktu_perizinan(){
		$nama_waktu = $this->input->post('nama_waktu', TRUE);
        $jam  = $this->input->post('jam', TRUE);

 		$data = array ('jam'  => $jam );

		# proses simpan
		if ($this->m_models->update_data($nama_waktu, 'nama_waktu', $data,"b_waktu_perizinan") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/waktu_perizinan');
	}

	# fungsi mengambil data siswa kelas buat JS
	#getsantri
	public function getSantriChekOut(){
		$this->load->view('template/head');
		$nrp = $this->session->userdata['nrp'];
	//	$nrp = '989899';
		$ta = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $ta[0]->id_tahun;

		$tanggal_check_out = to_Ymd($this->input->get('tanggal')); 
		$data['tanggal_check_out'] = $tanggal_check_out;

		$rayon = $this->getRayon();
		
		$santri = $this->m_models->get_data("b_kamar_santri.id_kamar, b_kamar_santri.id_siswa, b_kamar.nama as nama_kamar", "b_kamar_santri", "JOIN b_walas ON b_kamar_santri.id_kamar=b_walas.id_kamar JOIN b_kamar ON b_kamar_santri.id_kamar=b_kamar.id_kamar WHERE b_walas.nrp='$nrp' AND b_walas.id_tahun='$id_tahun' AND b_kamar_santri.id_tahun='$id_tahun' AND b_kamar_santri.status='in' AND b_kamar_santri.id_siswa NOT IN (SELECT id_siswa FROM b_izin WHERE tanggal='$tanggal_check_out') ORDER BY  nama_kamar ASC");

		foreach ($santri as $key) {
			$id_siswa = $key->id_siswa;
			$d_santri['id_siswa'][] = $id_siswa;

			# CEK JEJANG
			$jenjang=db_siswa($id_siswa);
			# mencari kelas
			$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $ta[0]->id_tahun, 
							'rombongan_belajar_'.$jenjang.'.id_siswa' => $id_siswa);
			$kelas = $this->m_models->getJoin1where("kelas.nama_kelas, kelas.id_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
			$d_santri['nama_kelas'][] = $kelas[0]->nama_kelas;
			$d_santri['id_kelas'][] = $kelas[0]->id_kelas;

			$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
			$d_santri['nama'][] = $nama;
			$d_santri['rayon'][] = $rayon[$key->id_kamar];
			$d_santri['nama_kamar'][] = $key->nama_kamar;
			$d_santri['id_kamar'][] = $key->id_kamar;
		}
		# jumlah santri yang ada di bwah walas login
		$data['jumlah_santri'] = count($santri);
		# kirim data santri
		if (count($santri)!=NULL) {
			$data['santri'] = $d_santri;
		}

		# data seting jam maximal pulang izin
		$data['max_check_in'] = $this->m_models->get_data('jam', 'b_waktu_perizinan', "where nama_waktu='Berakhir'");

		$this->load->view('boarding/santri_check_out', $data);

		$this->load->view('template/js');
	}

	#input_perizinan_pekanan
	function input_perizinan_pekanan(){
		$this->load->view('template/header');
		$nrp = $this->session->userdata['nrp'];

		$rayon = $this->getRayon();

		$arraywhere = array('b_izin.check_in' => '00:00:00', 'b_izin.nrp' => $nrp, 'b_izin.jenis' => 'Pekanan');
		$izin = $this->m_models->getJoin2Awhere("b_izin.*, b_kamar.nama as nama_kamar, kelas.nama_kelas", "b_izin", "b_kamar", "b_izin.id_kamar=b_kamar.id_kamar", "kelas", "b_izin.id_kelas=kelas.id_kelas", $arraywhere, "b_izin.id_siswa", "ASC");

		foreach ($izin as $key) {
			$id_siswa = $key->id_siswa;
			$d_santri['id_izin'][] = $key->id_izin;

			# CEK JEJANG
			$jenjang=db_siswa($id_siswa);

			$d_santri['nama_kelas'][] = $key->nama_kelas;

			$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
			$d_santri['nama'][] = $nama;
			$d_santri['rayon'][] = $rayon[$key->id_kamar];
			$d_santri['nama_kamar'][] = $key->nama_kamar;
			$d_santri['minta_izin'][] = $key->minta_izin;
			$d_santri['tgl_max_check_in'][] = $key->tgl_max_check_in;
			$d_santri['max_check_in'][] = $key->max_check_in;
			$d_santri['check_out'][] = $key->check_out;
			$d_santri['tujuan'][] = $key->tujuan;
			$d_santri['tanggal'][] = $key->tanggal;
			$d_santri['tgl_check_in'][] = $key->tgl_check_in;

		}
		# jumlah santri yang ada di bwah walas login
		$data['jumlah_santri'] = count($izin);
		# kirim data santri
		if (count($izin)!=NULL) {
			$data['santri'] = $d_santri;
		}

		# tampilkan data ke view
		$this->load->view('boarding/input_perizinan_pekanan', $data); 

		$this->load->view('template/footer');		
	}

	function simpan_perizinan_pekanan(){
		$proses = false;
		$simpan = $this->input->post('simpan');	
		$jml_siswa = count($this->input->post('siswa'));

		if ($simpan != null AND $jml_siswa != 0) {
			$siswa = $this->input->post('siswa');
			$tanggal = $this->input->post('tanggal');
			$max_check_in = $this->input->post('max_check_in');
			$id_kamar = $this->input->post('id_kamar');
			$id_kelas = $this->input->post('id_kelas');
			$nrp = $this->session->userdata['nrp'];
			$minta_izin = $this->input->post('minta_izin');		
			$check_out = $this->input->post('check_out');
			$tujuan = $this->input->post('tujuan');
			$keterangan = $this->input->post('keterangan');	
			$pendamping = $this->input->post('pendamping');		

			
			for ($i=0;$i<$jml_siswa;$i++){ 
				$id_siswa = $siswa[$i];
				if ($tujuan[$id_siswa] != '') {
					# masukan data ke array buat disimpan sekaligus
					$data[$i]['id_izin'] = '';
					$data[$i]['tanggal'] = $tanggal;
					$data[$i]['id_siswa'] = $id_siswa;
					$data[$i]['id_kamar'] = $id_kamar[$id_siswa];
					$data[$i]['id_kelas'] = $id_kelas[$id_siswa];
					$data[$i]['nrp'] = $nrp;
					$data[$i]['jenis'] = 'Pekanan';
					$data[$i]['minta_izin'] = $minta_izin[$id_siswa];
					$data[$i]['tgl_max_check_in'] = $tanggal;
					$data[$i]['max_check_in'] = $max_check_in;
					$data[$i]['check_out'] = time_db($check_out[$id_siswa]);
					$data[$i]['tgl_check_in'] = $tanggal;
					$data[$i]['check_in'] = '00:00:00';
					$data[$i]['telat'] = 0;
					$data[$i]['tujuan'] = $tujuan[$id_siswa];
					$data[$i]['keterangan'] = $keterangan[$id_siswa];
					$data[$i]['memo'] = '';
					$data[$i]['pendamping'] = $pendamping[$id_siswa];
				}
			}

			# proses simpan ke tabel perpus_anggota
			if (is_array($data) && count($data)>0) {
				$proses = $this->m_models->save_batch($data,"b_izin");
			}

		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/input_perizinan_pekanan');		
	}

	#update_perizinan_pekanan dan perizinan insidentil
	function update_perizinan_pekanan(){
		$this->load->helper('absen');
		$proses = false;
		$simpan = $this->input->post('simpan');	
		$jml_siswa = count($this->input->post('id_izin'));

		if ($simpan != null AND $jml_siswa != 0) {
			$id_izin = $this->input->post('id_izin');
			$tgl_check_in = $this->input->post('tgl_check_in');
			$check_in = $this->input->post('check_in');
			$tgl_max_check_in = $this->input->post('tgl_max_check_in');
			$max_check_in = $this->input->post('max_check_in');
			
			for ($i=0;$i<$jml_siswa;$i++){ 
				$id = $id_izin[$i];
				if ($check_in[$id] != '') {
					// $check_in_db = time_db($check_in[$id]);
					// $int_check_in = strtotime($check_in_db); 
					// $int_max_check_in = strtotime($max_check_in[$id]);
					// # cari jumlah telat dalam menit 
					// if ($int_check_in > $int_max_check_in) {
					// 	$telat = cek_telat_masuk($max_check_in[$id], $check_in_db);
					// }else{
					// 	$telat = 0;
					// }


					# konversi ke tanggal unik
			        $unix_tgl_check_in = strtotime($tgl_check_in[$id]);
			        $unix_check_in = strtotime($check_in[$id]);
			        $unix_tgl_max_check_in = strtotime($tgl_max_check_in[$id]);
			        $unix_max_check_in = strtotime($max_check_in[$id].":00");
			        # cek kondisi dan hitung telat
			        if ($unix_tgl_check_in > $unix_tgl_max_check_in) {
			        	$telat = get_selisih_menit($tgl_max_check_in[$id], $max_check_in[$id], $tgl_check_in[$id], $check_in[$id]);
			        }elseif($unix_tgl_check_in == $unix_tgl_max_check_in AND $unix_check_in > $unix_max_check_in){
			        	$telat = get_selisih_menit($tgl_max_check_in[$id], $max_check_in[$id], $tgl_check_in[$id], $check_in[$id]);
			        }else{
			        	$telat = 0;
			        }

					# masukan data ke array buat disimpan sekaligus
					$data[$i]['id_izin'] = $id;
					$data[$i]['tgl_check_in'] = $tgl_check_in[$id];
					$data[$i]['check_in'] = time_db($check_in[$id]);
					$data[$i]['telat'] = $telat;

					$data[$i]['tgl_max_check_in'] = $tgl_max_check_in[$id];
					$data[$i]['max_check_in'] = $max_check_in[$id].":00";
				}
			}

			# proses simpan ke tabel perpus_anggota
			$proses = $this->m_models->update_batch($data,"b_izin", "id_izin");

		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		if ($simpan=='simpan_check_in') {
			redirect('boarding/input_perizinan_insidentil');
		}else{
			redirect('boarding/input_perizinan_pekanan');
		}
				
	}

	#input_perizinan_insidentil
	function input_perizinan_insidentil(){
		$this->load->view('template/header');
		$nrp = $this->session->userdata['nrp'];
		$rayon = $this->getRayon();
		
		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;

		$santri = $this->m_models->get_data("b_kamar_santri.id_kamar, b_kamar_santri.id_siswa, b_kamar.nama as nama_kamar", "b_kamar_santri", "JOIN b_walas ON b_kamar_santri.id_kamar=b_walas.id_kamar JOIN b_kamar ON b_kamar_santri.id_kamar=b_kamar.id_kamar WHERE b_walas.nrp='$nrp' AND b_walas.id_tahun='$id_tahun' AND b_kamar_santri.id_tahun='$id_tahun' ORDER BY  nama_kamar ASC");

		foreach ($santri as $key) {
			$id_siswa = $key->id_siswa;
			$d_santri['id_siswa'][] = $id_siswa;

			# CEK JEJANG
			$jenjang=db_siswa($id_siswa);

			$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
			$d_santri['nama'][] = $nama;
		}
		# jumlah santri yang ada di bwah walas login
		$data['jumlah_santri'] = count($santri);
		# kirim data santri
		if (count($santri)!=NULL) {
			$data['santri'] = $d_santri;
		}
		

		$arraywhere = array('b_izin.check_in' => '00:00:00', 'b_izin.nrp' => $nrp, 'b_izin.jenis' => 'Insidentil');
		$izin = $this->m_models->getJoin2Awhere("b_izin.*, b_kamar.nama as nama_kamar, kelas.nama_kelas", "b_izin", "b_kamar", "b_izin.id_kamar=b_kamar.id_kamar", "kelas", "b_izin.id_kelas=kelas.id_kelas", $arraywhere, "b_izin.id_siswa", "ASC");

		foreach ($izin as $key) {
			$id_siswa = $key->id_siswa;
			$d_siswa['id_izin'][] = $key->id_izin;

			# CEK JEJANG
			$jenjang=db_siswa($id_siswa);

			$d_santri['nama_kelas'][] = $key->nama_kelas;

			$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
			$d_siswa['nama'][] = $nama;
			$d_siswa['rayon'][] = $rayon[$key->id_kamar];
			$d_siswa['nama_kamar'][] = $key->nama_kamar;
			$d_siswa['nama_kelas'][] = $key->nama_kelas;
			$d_siswa['minta_izin'][] = $key->minta_izin;
			$d_siswa['tgl_max_check_in'][] = $key->tgl_max_check_in;
			$d_siswa['max_check_in'][] = $key->max_check_in;
			$d_siswa['check_out'][] = $key->check_out;
			$d_siswa['tujuan'][] = $key->tujuan;
			$d_siswa['tanggal'][] = $key->tanggal;

		}
		# jumlah santri yang ada di bwah walas login
		$data['jumlah_siswa'] = count($izin);
		# kirim data santri
		if (count($izin)!=NULL) {
			$data['siswa'] = $d_siswa;
		}

		# tampilkan data ke view
		$this->load->view('boarding/input_perizinan_insidentil', $data); 

		$this->load->view('template/footer');		
	}

	function simpan_perizinan_insidentil(){
		$proses = false;
		$simpan = $this->input->post('simpan');	

		if ($simpan != null) {
			$siswa = $this->input->post('siswa');
			$jml_siswa = count($this->input->post('siswa'));
			$tanggal = to_Ymd($this->input->post('tanggal'));
			$tgl_max_check_in = to_Ymd($this->input->post('tgl_max_check_in'));
			$max_check_in = $this->input->post('max_check_in').":00";
			$nrp = $this->session->userdata['nrp'];		
			$check_out = $this->input->post('check_out').":00";
			$tujuan = $this->input->post('tujuan');	
			$memo = $this->input->post('memo');	

			$ta = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
			$id_tahun = $ta[0]->id_tahun;
			
			for ($i=0;$i<$jml_siswa;$i++){
				if ($tujuan[$i] != '') {
					$jenjang=db_siswa($siswa[$i]);
					# mencari kelas
					
					$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $id_tahun, 
									'rombongan_belajar_'.$jenjang.'.id_siswa' => $siswa[$i]);
					$kelas = $this->m_models->getJoin1where("kelas.id_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");

					# mencari id kamar
					$kamar = $this->m_models->get_data("id_kamar", "b_kamar_santri", "WHERE id_siswa='$siswa[$i]' AND id_tahun='$id_tahun' ");

					# masukan data ke array buat disimpan sekaligus
					$data[$i]['id_izin'] = '';
					$data[$i]['tanggal'] = $tanggal;
					$data[$i]['id_siswa'] = $siswa[$i];
					$data[$i]['id_kamar'] = $kamar[0]->id_kamar;
					$data[$i]['id_kelas'] = $kelas[0]->id_kelas;
					$data[$i]['nrp'] = $nrp;
					$data[$i]['jenis'] = 'Insidentil';
					$data[$i]['minta_izin'] = '1';
					$data[$i]['tgl_max_check_in'] = $tgl_max_check_in;
					$data[$i]['max_check_in'] = $max_check_in;
					$data[$i]['check_out'] = time_db($check_out);
					$data[$i]['tgl_check_in'] = '0000-00-00';
					$data[$i]['check_in'] = '00:00:00';
					$data[$i]['telat'] = 0;
					$data[$i]['tujuan'] = $tujuan;
					$data[$i]['keterangan'] = '';
					$data[$i]['memo'] = $memo;
					$data[$i]['pendamping'] = '';
				}
			}

			# proses simpan ke tabel perpus_anggota
			$proses = $this->m_models->save_batch($data,"b_izin");

		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/input_perizinan_insidentil');		
	}

	function chek_in_izin_insidentil(){
		$this->load->helper('absen');

		$id_izin = $this->input->post('id_izin', TRUE);
		$tgl_check_in = $this->input->post('tgl_check_in', TRUE);
        $check_in  = $this->input->post('check_in', TRUE).":00";
        $tgl_max_check_in = $this->input->post('tgl_max_check_in', TRUE);
        $max_check_in = $this->input->post('max_check_in', TRUE);
        # konversi ke tanggal unik
        $unix_tgl_check_in = strtotime($tgl_check_in);
        $unix_check_in = strtotime($check_in);
        $unix_tgl_max_check_in = strtotime($tgl_max_check_in);
        $unix_max_check_in = strtotime($max_check_in);
        # cek kondisi dan hitung telat
        if ($unix_tgl_check_in > $unix_tgl_max_check_in) {
        	$telat = get_selisih_menit($tgl_max_check_in, $max_check_in, $tgl_check_in, $check_in);
        }elseif($unix_tgl_check_in == $unix_tgl_max_check_in AND $unix_check_in > $unix_max_check_in){
        	$telat = get_selisih_menit($tgl_max_check_in, $max_check_in, $tgl_check_in, $check_in);
        }else{
        	$telat = 0;
        }
        
        $keterangan  = $this->input->post('keterangan', TRUE);

 		$data = array (
		    'id_izin' => $id_izin,
		    'tgl_max_check_in'  => $tgl_max_check_in,
		    'max_check_in'  => $max_check_in,
		    'tgl_check_in'  => $tgl_check_in,
		    'check_in'  => $check_in,
		    'telat' => $telat,
		    'keterangan'  => $keterangan
		);

		# proses simpan
		if ($this->m_models->update_data($id_izin, 'id_izin', $data, "b_izin") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/input_perizinan_insidentil');				
	}

	#perizinan
	function perizinan(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
	//	$level_user = 78;
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);
	//	$akses_pembinaaan = 'Putri';

		# ambil data dari post pencarian
		$rentang_tanggal = $this->input->post('rentang_tanggal', TRUE); 
		$jenis_perizinan = $this->input->post('perizinan', TRUE);
		$walas = $this->input->post('walas', TRUE);

		# kirim data untuk pencarian
		$data['perizinan_pilih'] = $jenis_perizinan;
		$data['walaspilih'] = $walas;
		# data walas sesaui akses pembinaan putra ato putri untuk pencarian
		$arrWhere = array('b_walas.pembinaan' => $akses_pembinaaan);
		$data['walas'] = $this->m_models->getJoin1whereGroup("b_walas.*, pegawai.nama", "b_walas", "pegawai", "b_walas.nrp=pegawai.nrp", $arrWhere, "b_walas.nrp", "pegawai.nama", "ASC");

		if ($rentang_tanggal != null AND $jenis_perizinan != null) {
			$exp = explode("-",$rentang_tanggal);
			$tanggal_dari = date_db(trim($exp[0]));
			$tanggal_sampai = date_db(trim($exp[1]));
			# kirim data tgl cari
			$data[tgl_dari] = $tanggal_dari;
			$data[tgl_sampai] = $tanggal_sampai;

			$rayon = $this->getRayon();

			# ambil nrp walas login atau dari pencarian
			if ($level_user=='45+127' OR $level_user=='46+127') {
				$nrp = $this->session->userdata['nrp'];
			}else{
				$nrp = $walas;
			}
			# kirim data nrp walas buat print
			$data[nrp] = $nrp;

			if ($jenis_perizinan == 'semuaizin') {
				$arraywhere = array('b_izin.tanggal >=' => $tanggal_dari, 'b_izin.tanggal <=' => $tanggal_sampai,
									'b_izin.nrp' => $nrp);
			}else{
				$arraywhere = array('b_izin.tanggal >=' => $tanggal_dari, 'b_izin.tanggal <=' => $tanggal_sampai, 
									'b_izin.jenis' => $jenis_perizinan, 'b_izin.nrp' => $nrp);
			}
			
			$santri = $this->m_models->getJoin2Awhere("b_izin.*, b_kamar.nama as nama_kamar, kelas.nama_kelas", "b_izin", "b_kamar", "b_izin.id_kamar=b_kamar.id_kamar", "kelas", "b_izin.id_kelas=kelas.id_kelas", $arraywhere, "b_izin.id_siswa", "ASC");

			foreach ($santri as $key) {
				$id_siswa = $key->id_siswa;
				$d_santri['id_izin'][] = $key->id_izin;
				$d_santri['tanggal'][] = $key->tanggal;

				# CEK JEJANG
				$jenjang=db_siswa($id_siswa);
				$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'][] = $nama;
				$d_santri['rayon'][] = $rayon[$key->id_kamar];
				$d_santri['nama_kamar'][] = $key->nama_kamar;
				$d_santri['nama_kelas'][] = $key->nama_kelas;
				$d_santri['minta_izin'][] = $key->minta_izin;
				$d_santri['tgl_max_check_in'][] = $key->tgl_max_check_in;
				$d_santri['max_check_in'][] = $key->max_check_in;
				$d_santri['check_out'][] = $key->check_out;
				$d_santri['tgl_check_in'][] = $key->tgl_check_in;
				$d_santri['check_in'][] = $key->check_in;
				$d_santri['tujuan'][] = $key->tujuan;
				$d_santri['memo'][] = $key->memo;
				$d_santri['keterangan'][] = $key->keterangan;
				$d_santri['jenis'][] = $key->jenis;
			}
			$data['jumlah_santri'] = count($santri);
			
			$data['santri'] = $d_santri;	
		}
	
		# tampilkan data ke view
		if ($level_user=='45+127' OR $level_user=='46+127') {
			$this->load->view('boarding/perizinan', $data);
		}else{
			$this->load->view('boarding/perizinan_santri', $data);
		}
	
		$this->load->view('template/footer');			
	}

	#perizinan_print
	function perizinan_print($tgl_dari, $tgl_sampai, $nrp_walas, $jenis){
		$this->load->helper('absen');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
	//	$level_user = 78;
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);
	//	$akses_pembinaaan = 'Putri';

		# data walas sesaui akses pembinaan putra ato putri untuk pencarian
		$arrWhere = array('b_walas.pembinaan' => $akses_pembinaaan);
		$data['walas'] = $this->m_models->getJoin1whereGroup("b_walas.*, pegawai.nama", "b_walas", "pegawai", "b_walas.nrp=pegawai.nrp", $arrWhere, "b_walas.nrp", "pegawai.nama", "ASC");

			$jenis_perizinan = $jenis;
			$tanggal_dari = $tgl_dari;
			$tanggal_sampai = $tgl_sampai;

			$rayon = $this->getRayon();

			$nrp = $nrp_walas;

			if ($jenis_perizinan == 'semuaizin') {
				$arraywhere = array('b_izin.tanggal >=' => $tanggal_dari, 'b_izin.tanggal <=' => $tanggal_sampai,
									'b_izin.nrp' => $nrp);
			}else{
				$arraywhere = array('b_izin.tanggal >=' => $tanggal_dari, 'b_izin.tanggal <=' => $tanggal_sampai, 
									'b_izin.jenis' => $jenis_perizinan, 'b_izin.nrp' => $nrp);
			}
			
			$santri = $this->m_models->getJoin2Awhere("b_izin.*, b_kamar.nama as nama_kamar, kelas.nama_kelas", "b_izin", "b_kamar", "b_izin.id_kamar=b_kamar.id_kamar", "kelas", "b_izin.id_kelas=kelas.id_kelas", $arraywhere, "b_izin.id_kamar", "ASC");

			foreach ($santri as $key) {
				$id_siswa = $key->id_siswa;
				$d_santri['id_izin'][] = $key->id_izin;
				$d_santri['tanggal'][] = $key->tanggal;

				# CEK JEJANG
				$jenjang=db_siswa($id_siswa);
				$nama=all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'][] = $nama;
				$data_rayon[] = $rayon[$key->id_kamar];
				$d_santri['nama_kamar'][] = $key->nama_kamar;
				$d_santri['nama_kelas'][] = $key->nama_kelas;
			//	$d_santri['minta_izin'][] = $key->minta_izin;
				$d_santri['check_out'][] = $key->check_out;
				$d_santri['tgl_max_check_in'][] = $key->tgl_max_check_in;
				$d_santri['max_check_in'][] = $key->max_check_in;
				$tgl_max_check_in = $key->tgl_max_check_in;
				$max_check_in = $key->max_check_in;
			//	$d_santri['check_out'][] = $key->check_out;
				$tgl_check_in = $key->tgl_check_in;
				$check_in = $key->check_in;
				$d_santri['tujuan'][] = $key->tujuan;
				$data_tujuan[] = $key->tujuan;
				$d_santri['memo'][] = $key->memo;
				$d_santri['keterangan'][] = $key->keterangan;
				$d_santri['jenis'][] = $key->jenis;
				$d_santri['pendamping'][] = $key->pendamping;

				# hitung ketelatan
		        $unix_tgl_check_in = strtotime($tgl_check_in);
		        $unix_check_in = strtotime($check_in);
		        $unix_tgl_max_check_in = strtotime($tgl_max_check_in);
		        $unix_max_check_in = strtotime($max_check_in);
		        # cek kondisi dan hitung telat
		        if ($unix_tgl_check_in > $unix_tgl_max_check_in) {
		        	$telat = get_selisih_menit($tgl_max_check_in, $max_check_in, $tgl_check_in, $check_in);
		        }elseif($unix_tgl_check_in == $unix_tgl_max_check_in AND $unix_check_in > $unix_max_check_in){
		        	$telat = get_selisih_menit($tgl_max_check_in, $max_check_in, $tgl_check_in, $check_in);
		        }else{
		        	$telat = 0;
		        }

		        # simpaan data OT Telat
		        
		        if ($telat <= 30) {
		        	$data_ot[] = 1;
		        	$d_santri['ot'][] = 'Ya';
		        }elseif($telat > 30 AND $telat <= 120){
		        	$data_telat1[] = 1;
		        	$d_santri['terlambat'][] = $telat;
		        }else{
		        	$data_telat2[] = 1;
		        	$d_santri['terlambat'][] = $telat;
		        }
		        
			}
			$data['jumlah_santri'] = count($santri);
			
			$data['santri'] = $d_santri;	

		# cari tahun akademik
		$data_ta = $this->m_models->get_data("periode", "tahun_akademik", "WHERE tanggal_mulai <= '$tanggal_dari' AND tanggal_selesai >= '$tanggal_dari'");
		$data[tahun_akademik] = $data_ta[0]->periode;
		# tanggal rekap
		$data[tanggal_rekap] = $tanggal_dari;
		# mencari nama bulan
		$data[bulan] = bulan(ltrim(substr($tanggal_dari,5,2), '0'));
		# mencari pekan ke berapa
	    $data[pekan] = weekNumberOfMonth($tanggal_dari);
	    # mencari nama walas
	    $data[walas] = pegawai($nrp);
	   
	    if ($akses_pembinaaan == 'Putra') {
	    	$data[ust] = 'Ust';
	    	$data[pembinaan] = 'IKHWAN';
	    }else{
	    	$data[ust] = 'Ustdh';
	    	$data[pembinaan] = 'AKHWAT';
	    }
	    # mencari rayon
	    $rayon_unix = array_unique($data_rayon);
	    $jumlah_rayon = count($rayon_unix);
	    $x = 1;
	    foreach ($rayon_unix as $key => $value) {
	    	if($x == 1){
	    		$nama_rayon = $value;
	    	}else{
	    		$nama_rayon = $nama_rayon .' & '. $value;
	    	}
	    	$x++;
	    }
	    $data[rayon] = $nama_rayon;

	    # menghitung rekap perizinan tujuan
	    $tujuan = array_count_values($data_tujuan);
	    $tujuan[1] = $tujuan[Fajar] + $tujuan[Surya] + $tujuan[Krucuk] + $tujuan[Cilimus];
		$tujuan[2] = $tujuan[Kuningan];
		$tujuan[3] = $tujuan[Cirebon];
		$tujuan[4] = $tujuan[Pulang] + $tujuan[Lainnya];

		$data[tujuan] = $tujuan;
		$data[total_tujuan] = count($data_tujuan);

		# kirim data kehadirran
		$data[ot] = count($data_ot);
		$data[telat1] = count($data_telat1);
		$data[telat2] = count($data_telat2);

	    $this->load->library('pdf');

	//    $customPaper = array(0,0,269.291339,368.503937);
		$this->pdf->setPaper('A4', 'potrait');
	   	$this->pdf->load_view('boarding/perizinan_print', $data);
	   	$this->pdf->render();

	   	$this->pdf->stream("laporan_perizinan.pdf", array('Attachment'=>0));		
	}

	#edit_izin
	function edit_izin(){
		$this->load->helper('absen');

		$id_izin = $this->input->post('id_izin', TRUE);
		$tanggal = $this->input->post('tanggal', TRUE);
		$minta_izin = $this->input->post('minta_izin', TRUE);
        $tujuan  = $this->input->post('tujuan', TRUE);
        $check_out  = $this->input->post('check_out', TRUE);
        $tgl_check_in  = $this->input->post('tgl_check_in', TRUE);
        $check_in  = $this->input->post('check_in', TRUE);
        $tgl_max_check_in = $this->input->post('tgl_max_check_in', TRUE);
        $max_check_in = $this->input->post('max_check_in', TRUE);
        $telat = cek_telat_masuk($max_check_in, $check_in);
        # konversi ke tanggal unik
        $unix_tgl_check_in = strtotime($tgl_check_in);
        $unix_check_in = strtotime($check_in);
        $unix_tgl_max_check_in = strtotime($tgl_max_check_in);
        $unix_max_check_in = strtotime($max_check_in);
        # cek kondisi dan hitung telat
        if ($unix_tgl_check_in > $unix_tgl_max_check_in) {
        	$telat = get_selisih_menit($tgl_max_check_in, $max_check_in, $tgl_check_in, $check_in);
        }elseif($unix_tgl_check_in == $unix_tgl_max_check_in AND $unix_check_in > $unix_max_check_in){
        	$telat = get_selisih_menit($tgl_max_check_in, $max_check_in, $tgl_check_in, $check_in);
        }else{
        	$telat = 0;
        }
        $memo  = $this->input->post('memo', TRUE);
        $keterangan  = $this->input->post('keterangan', TRUE);

 		$data = array (
		    'id_izin' => $id_izin,
		    'tanggal' => $tanggal,
		    'minta_izin'  => $minta_izin,
		    'tujuan'  => $tujuan,
		    'check_out'  => $check_out,
		    'tgl_max_check_in'  => $tgl_max_check_in,
		    'max_check_in'  => $max_check_in,
		    'tgl_check_in'  => $tgl_check_in,
		    'check_in'  => $check_in,
		    'telat' => $telat,
		    'memo'  => $memo,
		    'keterangan'  => $keterangan
		);

		# proses simpan
		if ($this->m_models->update_data($id_izin, 'id_izin', $data, "b_izin") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/perizinan');		
	}

	#hapus_izin
	function hapus_izin(){
		$id_izin = $this->input->post('id_izin', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_izin, 'id_izin', 'b_izin') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('boarding/perizinan');		
	}

	#resume_perizinan
	function resume_perizinan(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		//$level_user = 78;
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);
		//$akses_pembinaaan = 'Putri';

		# ambil data dari post pencarian
		$rentang_tanggal = $this->input->post('rentang_tanggal', TRUE); 
		$jenis_perizinan = $this->input->post('perizinan', TRUE);
		$walas = $this->input->post('walas', TRUE);

		# kirim data untuk pencarian
		$data['perizinan_pilih'] = $jenis_perizinan;
		$data['walaspilih'] = $walas;
		# data walas sesaui akses pembinaan putra ato putri untuk pencarian
		$arrWhere = array('b_walas.pembinaan' => $akses_pembinaaan);
		$data['walas'] = $this->m_models->getJoin1whereGroup("b_walas.*, pegawai.nama", "b_walas", "pegawai", "b_walas.nrp=pegawai.nrp", $arrWhere, "b_walas.nrp", "pegawai.nama", "ASC");

		if ($rentang_tanggal != null AND $jenis_perizinan != null) {
			$exp = explode("-",$rentang_tanggal);
			$tanggal_dari = date_db(trim($exp[0]));
			$tanggal_sampai = date_db(trim($exp[1]));

			$rayon = $this->getRayon();

			# ambil nrp walas login atau dari pencarian
			if ($level_user=='45+127' OR $level_user=='46+127') {
				$nrp = $this->session->userdata['nrp'];
			}else{
				$nrp = $walas;
			}

			if ($jenis_perizinan == 'semuaizin') {
				$arraywhere = array('b_izin.tanggal >=' => $tanggal_dari, 'b_izin.tanggal <=' => $tanggal_sampai,
									'b_izin.nrp' => $nrp);
			}else{
				$arraywhere = array('b_izin.tanggal >=' => $tanggal_dari, 'b_izin.tanggal <=' => $tanggal_sampai, 
									'b_izin.jenis' => $jenis_perizinan, 'b_izin.nrp' => $nrp);
			}
			
			$santri = $this->m_models->getJoin2AwhereGroup(
				"b_izin.*, COUNT(b_izin.id_siswa) AS jumlah_izin, 
				SUM(IF(b_izin.minta_izin=1,1,0)) AS izin, 
				SUM(IF(b_izin.minta_izin=0,1,0)) AS tidak_izin, 
				SUM(IF(b_izin.telat!=0,1,0)) AS jumlah_terlambat, 
				SUM(b_izin.telat) as waktu_terlambat, 
				b_kamar.nama as nama_kamar, kelas.nama_kelas", 
				"b_izin", "b_kamar", "b_izin.id_kamar=b_kamar.id_kamar", "kelas", "b_izin.id_kelas=kelas.id_kelas", $arraywhere, "b_izin.id_siswa", "b_izin.id_siswa", "ASC");

			foreach ($santri as $key) {
				$id_siswa = $key->id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$nis = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nis");
				$d_santri['nis'][] = $nis;
				$d_santri['nama'][] = $nama;
				$d_santri['rayon'][] = $rayon[$key->id_kamar];
				$d_santri['nama_kamar'][] = $key->nama_kamar;
				$d_santri['nama_kelas'][] = $key->nama_kelas;
				$d_santri['jumlah_izin'][] = $key->jumlah_izin;
				$d_santri['izin'][] = $key->izin;
				$d_santri['tidak_izin'][] = $key->tidak_izin;
				$d_santri['jumlah_terlambat'][] = $key->jumlah_terlambat;
				$d_santri['waktu_terlambat'][] = $key->waktu_terlambat;
			}

			$data['jumlah_santri'] = count($santri);
			
			$data['santri'] = $d_santri;	
		}
	
		# tampilkan data ke view
		if ($level_user=='45+127' OR $level_user=='46+127') {
			$this->load->view('boarding/resume_perizinan', $data);
		}else{
			$this->load->view('boarding/resume_perizinan_santri', $data);
		}
	
		$this->load->view('template/footer');				
	}

	#unit
	function unit(){
		$this->load->view('template/header');

		# ambil data unit
		$data[unit] = $this->m_models->getAll("b_unit WHERE status='1' ORDER BY nama ASC ");
		# tampilkan data ke view
		$this->load->view('boarding/unit', $data); 

		$this->load->view('template/footer');
	}

	#tambah_unit
	function tambah_unit(){
		$nama = $this->input->post('nama', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'status' => 1
		);

		# proses simpan
		if ($this->m_models->save_data($data,"b_unit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/unit');
	}

	#edit_unit
	function edit_unit(){
		$id_unit = $this->input->post('id_unit', TRUE);
		$nama = $this->input->post('nama', TRUE);

 		$data = array (
		    'nama' => $nama,
		);

		# proses simpan
		if ($this->m_models->update_data($id_unit, 'id_unit', $data, "b_unit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/unit');
	}

	#hapus_unit
	function hapus_unit(){
		$id_unit = $this->input->post('id_unit', TRUE);

 		$data = array (
		    'status' => 0,
		);

		# proses simpan
		if ($this->m_models->update_data($id_unit, 'id_unit', $data, "b_unit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/unit');
	}

	#data_reward_point
	function data_reward_point(){
		$this->load->view('template/header');

		# ambil data unit
		$arraywhere = array('b_poin.jenis' => 'reward' );
		$data[poin] = $this->m_models->getJoin1where("b_poin.*, b_unit.nama as nama_unit", "b_poin", "b_unit", "b_poin.id_unit=b_unit.id_unit", $arraywhere, "b_unit.nama", "ASC");
		# tampilkan data ke view
		$this->load->view('boarding/data_reward_point', $data); 

		$this->load->view('template/footer');
	}

	#edit_reward_pointt
	function edit_reward_point(){
		$id_poin = $this->input->post('id_poin', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$poin = $this->input->post('poin', TRUE);
		$status = $this->input->post('status', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'poin' => $poin,
		    'status' => $status
		);

		# proses simpan
		if ($this->m_models->update_data($id_poin, 'id_poin', $data, "b_poin") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/data_reward_point');
	}

	#add_reward_point
	function add_reward_point(){
		$this->load->view('template/header');

		$proses = false;
		$simpan = $this->input->post('simpan');

		if ($simpan != null) {
			$unit = $this->input->post('unit');
			$nama = $this->input->post('nama_input');
			$jml_data = count($this->input->post('nama_input'));
			$poin = $this->input->post('poin_input');

			# cari id terakhir terakhir
			$id_akhir = $this->m_models->get_data("MAX(id_poin) AS id", "b_poin", "WHERE jenis='reward' ");
			$id_akhirnya = $id_akhir[0]->id;

			if ($id_akhirnya=='') {
				$no_urut = 0;
			}else{
				$no_urut = (int) substr($id_akhirnya,1,4);
			}

			for ($i=0;$i <$jml_data;$i++){  
				if ($nama[$i] != '' AND $poin[$i] != '') { 
					# buat id baru terurut
					$no_urut++;
					$id_baru = 'R'.sprintf("%04s", $no_urut); 
					# masukan data ke array buat disimpan sekaligus
					$data[$i]['id_poin'] = $id_baru;
					$data[$i]['nama'] = $nama[$i];
					$data[$i]['poin'] = $poin[$i];
					$data[$i]['jenis'] = 'reward';
					$data[$i]['id_unit'] = $unit;
					$data[$i]['status'] = 'On';
				}
			}

			# proses simpan ke tabel b_poin
			if (count($data) != 0) {
				$proses = $this->m_models->save_batch($data, "b_poin");
			}
			
			# proses simpan
			if ($proses == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}

			redirect('boarding/data_reward_point');
		}

		# ambil data unit untuk ditampilkan di form
		$data[unit] = $this->m_models->getAll("b_unit WHERE status='1' ORDER BY nama ASC");

		$this->load->view('boarding/add_reward_point', $data); 

		$this->load->view('template/footer');
	}

	#data_reward_point
	function data_punish_point(){
		$this->load->view('template/header');

		# ambil data unit
		$arraywhere = array('b_poin.jenis' => 'punish' );
		$data[poin] = $this->m_models->getJoin1where("b_poin.*, b_unit.nama as nama_unit", "b_poin", "b_unit", "b_poin.id_unit=b_unit.id_unit", $arraywhere, "b_unit.nama", "ASC");
		# tampilkan data ke view
		$this->load->view('boarding/data_punish_point', $data); 

		$this->load->view('template/footer');
	}

	#edit_punish_point
	function edit_punish_point(){
		$id_poin = $this->input->post('id_poin', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$klasifikasi = $this->input->post('klasifikasi', TRUE);
		$poin = $this->input->post('poin', TRUE);
		$status = $this->input->post('status', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'klasifikasi' => $klasifikasi,
		    'poin' => $poin,
		    'status' => $status
		);

		# proses simpan
		if ($this->m_models->update_data($id_poin, 'id_poin', $data, "b_poin") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('boarding/data_punish_point');
	}

	#add_reward_point
	function add_punish_point(){
		$this->load->view('template/header');

		$proses = false;
		$simpan = $this->input->post('simpan');

		if ($simpan != null) {
			$unit = $this->input->post('unit');
			$nama = $this->input->post('nama_input');
			$jml_data = count($this->input->post('nama_input'));
			$poin = $this->input->post('poin_input');
			$klasifikasi = $this->input->post('sanksi');

			# cari id terakhir terakhir
			$id_akhir = $this->m_models->get_data("MAX(id_poin) AS id", "b_poin", "WHERE jenis='punish' ");
			$id_akhirnya = $id_akhir[0]->id;

			if ($id_akhirnya=='') {
				$no_urut = 0;
			}else{
				$no_urut = (int) substr($id_akhirnya,1,4);
			}

			for ($i=0;$i <$jml_data;$i++){  
				if ($nama[$i] != '' AND $poin[$i] != '') { 
					# buat id baru terurut
					$no_urut++;
					$id_baru = 'P'.sprintf("%04s", $no_urut); 
					# masukan data ke array buat disimpan sekaligus
					$data[$i]['id_poin'] = $id_baru;
					$data[$i]['nama'] = $nama[$i];
					$data[$i]['poin'] = $poin[$i];
					$data[$i]['jenis'] = 'punish';
					$data[$i]['klasifikasi'] = $klasifikasi[$i];
					$data[$i]['id_unit'] = $unit;
					$data[$i]['status'] = 'On';
				}
			}

			# proses simpan ke tabel b_poin
			if (count($data) != 0) {
				$proses = $this->m_models->save_batch($data, "b_poin");
			}
			
			# proses simpan
			if ($proses == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}

			redirect('boarding/data_punish_point');
		}

		# ambil data unit untuk ditampilkan di form
		$data[unit] = $this->m_models->getAll("b_unit WHERE status='1' ORDER BY nama ASC");

		$this->load->view('boarding/add_punish_point', $data); 

		$this->load->view('template/footer');
	}

	#point_punish
	function point_punish(){
		$this->load->view('template/header');

		/* ------ DATA UNTUK FORM TAMBAH DATA ---- */
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		//$level_user = 78;
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);
		//$akses_pembinaaan = 'Putri';
		
		# ambil walas yang login aktif
		$nrp = $this->session->userdata['nrp'];
		# ambil data tahun akademik yang sedang aktif
		$data['ta'] = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE status_berjalan='ON'");
		# ambil data santri berdasarkan wali santri
		$arraywhere = array('b_walas.nrp' => $nrp, 'b_walas.id_tahun' => $data[ta][0]->id_tahun, 'b_kamar_santri.status' => 'in', 'b_kamar_santri.id_tahun' => $data[ta][0]->id_tahun);
		$santri_walas = $this->m_models->getJoin1where("b_kamar_santri.id_siswa", "b_kamar_santri", "b_walas", "b_kamar_santri.id_kamar=b_walas.id_kamar", $arraywhere, "b_kamar_santri.id_siswa", "ASC");
		foreach ($santri_walas as $key) {
			$d_santri_walas[id_siswa][] = $key->id_siswa;
			# CEK JEJANG
			$jenjang = db_siswa($key->id_siswa);
			$nama = all("siswa_".$jenjang, "id_siswa", $key->id_siswa, "nama_lengkap");
			$d_santri_walas[nama][] = $nama;
		}
		# kirim data santri untuk pencarian santri input point
		$data['jumlah_santri_walas'] = count($santri_walas);
		$data['santri_walas'] = $d_santri_walas;

		# mencari data poin punish
		//$arraywhere = array('b_poin.jenis' => 'punish', 'b_poin.status' => 'On' );
		//$data[poin] = $this->m_models->getJoin1where("b_poin.*, b_unit.nama as nama_unit", "b_poin", "b_unit", "b_poin.id_unit=b_unit.id_unit", $arraywhere, "b_unit.nama", "ASC");		
		
		# mencari data unit
		$data[unit] = $this->m_models->getAll("b_unit WHERE status='1'");

		/* ------ END DATA UNTUK FORM TAMBAH DATA ---- */

		/* ------ Data untuk tampil setelah pencarian --- */
        $ta  = $this->input->post('tahun_akademik', TRUE);
        $kelas  = $this->input->post('kelas', TRUE);	

        if ($ta != null AND $kelas != null) {
	        $data[tapilih] = $ta;
	        $data[kelaspilih] = $kelas;

	        # mengambil data rayon
			$rayon = $this->getRayon();

			if ($akses_pembinaaan == 'Putra') {
				$jk = 'Laki-laki';
			}elseif ($akses_pembinaaan == 'Putri') {
				$jk = 'Perempuan';
			}

			if ($akses_pembinaaan == 'PutraPutri') {
				$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'kelas.id_tingkatan_kelas' => $kelas, 'b_poin.jenis' => 'punish');
			}else{
				$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'kelas.id_tingkatan_kelas' => $kelas, 'pegawai.jk' => $jk, 'b_poin.jenis' => 'punish');
			}
			
			$poin_santri = $this->m_models->getJoin4whereGroup("b_poin_santri.id_siswa, b_poin_santri.id_kamar, b_kamar.nama as nama_kamar, kelas.nama_kelas, SUM(b_poin_santri.poin) AS jumlah_poin", "b_poin_santri", 
				"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
				"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
				"pegawai", "b_poin_santri.nrp=pegawai.nrp",
				"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
				$arraywhere, "b_poin_santri.id_siswa", "b_poin_santri.id_siswa", "ASC");
			
			foreach ($poin_santri as $key) { 
				$id_siswa = $key->id_siswa;
				$d_santri['id_siswa'][] = $id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'][] = $nama;
				$d_santri['nis'][] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'][] = $rayon[$key->id_kamar];
				$d_santri['kamar'][] = $key->nama_kamar;
				$d_santri['kelas'][] = $key->nama_kelas;
				$d_santri['poin'][] = $key->jumlah_poin; 
			}
			# jumlah santri yang ada di bwah walas login
			$data['jumlah_santri'] = count($poin_santri);
			# kirim data santri
			if (count($poin_santri)!=NULL) {
				$data['santri'] = $d_santri;
			}
        }
		
		$data['tak'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");
		# tampilkan data ke view
		$this->load->view('boarding/point_punish', $data); 

		$this->load->view('template/footer');
	}

	function add_point_punish(){
		$file_bukti = '';

		/* -- upload berkas -- */
		$this->upload->initialize(array(
			'file_name' => 'file_'.time(),
	        'upload_path' => './assets/file_bukti', // nama folder gambar
	        'allowed_types' => 'jpg|png|jpeg|bmp', // format gambar
	        )); 

		if($this->upload->do_upload('file_bukti')){
        	$data_upload = $this->upload->data();
        	# ambil nama buat di simpan di tabel database
        	$file_bukti = $data_upload['file_name'];       		
		}else{
			$error = $this->upload->display_errors();
			print_r($error);
		}
		/* -- end upload berkas --*/

		# get data dari form
		$tanggal = to_Ymd($this->input->post('tanggal', TRUE));
        $tahun_akademik  = $this->input->post('tahun_akademik', TRUE);
        $id_siswa  = $this->input->post('id_siswa', TRUE);
        $kronologi  = $this->input->post('kronologi', TRUE);
        $poin  = $this->input->post('poin', TRUE);
        $nrp = $this->session->userdata['nrp'];

        # mencari poin dan id_poin
        $exp = explode("-", $poin);
        $id_poin = $exp[0];
        $poin = $exp[1];
        $sanksi = $exp[2];

        #cari id_kamar
        $kamar = $this->m_models->get_data("id_kamar", "b_kamar_santri", "WHERE id_siswa='$id_siswa' AND id_tahun='$tahun_akademik' AND status='in' ");
        $id_kamar = $kamar[0]->id_kamar;

		# CEK JEJANG
		$jenjang=db_siswa($id_siswa);
		# mencari kelas
		$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $tahun_akademik, 
							'rombongan_belajar_'.$jenjang.'.id_siswa' => $id_siswa);
		$kelas = $this->m_models->getJoin1where("kelas.id_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
		$id_kelas = $kelas[0]->id_kelas;

 		$data = array (
		    'tanggal' => $tanggal,
		    'id_siswa' => $id_siswa,
		    'id_poin' => $id_poin,
		    'poin' => $poin,
		    'sanksi' => $sanksi,
		    'kronologi' => $kronologi,
		    'komentar' => '',
		    'id_tahun' => $tahun_akademik,
		    'id_kamar' => $id_kamar,
		    'id_kelas' => $id_kelas,
		    'nrp' => $nrp,
		    'file_bukti' => $file_bukti
		);

		# proses simpan
		if ($this->m_models->save_data($data,"b_poin_santri") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/point_punish');
	}

	#detail_punish
	function detail_punish($id_siswa, $tahun_akademik){
		$this->load->view('template/header');
		# ambil post dari form cari
		$data[id_siswa] = $id_siswa;
		$data[tahun_akademik] = $tahun_akademik;
    //    $tahun_akademik  = $this->input->post('tahun_akademik', TRUE);
    //    $id_siswa  = $this->input->post('id_siswa', TRUE);
    
		# Cek nrp untuk mengaktifkan link delete, jika nrp login sama dengan nrp poin santri maka tampilkan link
		$data[nrp_walas] = $this->session->userdata['nrp'];

		$rayon = $this->getRayon();

		$arraywhere = array('b_poin_santri.id_tahun' => $tahun_akademik, 'b_poin_santri.id_siswa' => $id_siswa, 'b_poin.jenis' => 'punish');
		$data[poin] = $this->m_models->getJoin4where("b_poin_santri.*, b_kamar.nama as nama_kamar, kelas.nama_kelas, pegawai.nama as walas, b_poin.nama as nama_poin, b_poin.id_unit", "b_poin_santri", 
			"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
			"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
			"pegawai", "b_poin_santri.nrp=pegawai.nrp", 
			"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
			$arraywhere, "b_poin.id_unit", "ASC");

			# mencari data santri
			foreach ($data[poin] as $key) {
				$id_siswa = $key->id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'] = $nama;
				$d_santri['nis'] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'] = $rayon[$key->id_kamar];
				$d_santri['kamar'] = $key->nama_kamar;
				$d_santri['kelas'] = $key->nama_kelas;
				$d_santri['total_poin'] = $key->jumlah_poin;

				break;
			}

			#kirim data santri
			$data['santri'] = $d_santri;
			$data['periode'] = $this->m_models->get_data("periode", "tahun_akademik", "WHERE id_tahun='$tahun_akademik'");

			# mencari detail poin santri
			foreach ($data[poin] as $key) {
				$d_poin[$key->id_unit]['id_poin_santri'][] = $key->id_poin_santri;
				$d_poin[$key->id_unit]['nama_poin'][] = $key->nama_poin;
				$d_poin[$key->id_unit]['kronologi'][] = $key->kronologi;
				$d_poin[$key->id_unit]['sanksi'][] = $key->sanksi;
				$d_poin[$key->id_unit]['tanggal'][] = $key->tanggal;
				$d_poin[$key->id_unit]['walas'][] = $key->walas;
				$d_poin[$key->id_unit]['nrp'][] = $key->nrp;
				$d_poin[$key->id_unit]['poin'][] = $key->poin;
				$d_poin[$key->id_unit]['file_bukti'][] = $key->file_bukti;
				$arr_unit[] = $key->id_unit; 
				$jumlah_poin += $key->poin;
			}
			# jumlah data poin semuanya
			$data['jumlah_data'] = count($data[poin]);
			$data['dat'] = $d_poin;
			$data['total_poin'] = $jumlah_poin;

			# cari data unit buat header perulangan unit poin
			$unit = $this->m_models->getAll("b_unit ORDER BY nama ASC");
			foreach ($unit as $key) {
				$d_unit[$key->id_unit] = $key->nama;
			}
			$data[unit] = $d_unit;

			# data unit poin yang ada di pencarian
			$unit_unik = array_unique($arr_unit);
			foreach ($unit_unik as $key => $value) {
				$arr_unik[] = $value; 
			}
			$data[unit_poin] = $arr_unik;
        
		# tampilkan data ke view
		$this->load->view('boarding/detail_punish', $data); 

		$this->load->view('template/footer');
	}

	function hapus_poin($jenis){
		$id_poin_santri = $this->input->post('id_poin_santri', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_poin_santri, 'id_poin_santri', 'b_poin_santri') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		if ($jenis == 'reward') {
			redirect('boarding/point_rewards');
		}else{
			redirect('boarding/point_punish');
		}	
	}

	function download_file($nm_file){
		$this->load->helper('download');
		
		force_download('assets/file_bukti/'.$nm_file, NULL);
	}

	function file_bukti($nama_file){
		$this->load->view('template/header');

		$data[nama_file] = $nama_file;
		# tampilkan data ke view
		$this->load->view('boarding/file_bukti', $data); 

		$this->load->view('template/footer');
	}

	#point_rewards
	function point_rewards(){
		$this->load->view('template/header');

		/* ------ DATA UNTUK FORM TAMBAH DATA ---- */
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		//$level_user = 78;
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);
		//$akses_pembinaaan = 'Putri';
		
		# ambil walas yang login aktif
		$nrp = $this->session->userdata['nrp'];
		# ambil data tahun akademik yang sedang aktif
		$data['ta'] = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE status_berjalan='ON'");
		# ambil data santri berdasarkan wali santri
		$arraywhere = array('b_walas.nrp' => $nrp, 'b_walas.id_tahun' => $data[ta][0]->id_tahun, 'b_kamar_santri.status' => 'in');
		$santri_walas = $this->m_models->getJoin1where("b_kamar_santri.id_siswa", "b_kamar_santri", "b_walas", "b_kamar_santri.id_kamar=b_walas.id_kamar", $arraywhere, "b_kamar_santri.id_siswa", "ASC");
		foreach ($santri_walas as $key) {
			$d_santri_walas[id_siswa][] = $key->id_siswa;
			# CEK JEJANG
			$jenjang = db_siswa($key->id_siswa);
			$nama = all("siswa_".$jenjang, "id_siswa", $key->id_siswa, "nama_lengkap");
			$d_santri_walas[nama][] = $nama;
		}
		# kirim data santri untuk pencarian santri input point
		$data['jumlah_santri_walas'] = count($santri_walas);
		$data['santri_walas'] = $d_santri_walas;

		# mencari data poin punish
		//$arraywhere = array('b_poin.jenis' => 'reward', 'b_poin.status' => 'On' );
		//$data[poin] = $this->m_models->getJoin1where("b_poin.*, b_unit.nama as nama_unit", "b_poin", "b_unit", "b_poin.id_unit=b_unit.id_unit", $arraywhere, "b_unit.nama", "ASC");		

		# mencari data unit
		$data[unit] = $this->m_models->getAll("b_unit WHERE status='1'");

		/* ------ END DATA UNTUK FORM TAMBAH DATA ---- */

		/* ------ Data untuk tampil setelah pencarian --- */
        $ta  = $this->input->post('tahun_akademik', TRUE);
        $kelas  = $this->input->post('kelas', TRUE);	

        if ($ta != null AND $kelas != null) {
	        $data[tapilih] = $ta;
	        $data[kelaspilih] = $kelas;

	        # mengambil data rayon
			$rayon = $this->getRayon();

			if ($akses_pembinaaan == 'Putra') {
				$jk = 'Laki-laki';
			}elseif ($akses_pembinaaan == 'Putri') {
				$jk = 'Perempuan';
			}

			if ($akses_pembinaaan == 'PutraPutri') {
				$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'kelas.id_tingkatan_kelas' => $kelas, 'b_poin.jenis' => 'reward');
			}else{
				$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'kelas.id_tingkatan_kelas' => $kelas, 'pegawai.jk' => $jk, 'b_poin.jenis' => 'reward');
			}
			
			$poin_santri = $this->m_models->getJoin4whereGroup("b_poin_santri.id_siswa, b_poin_santri.id_kamar, b_kamar.nama as nama_kamar, kelas.nama_kelas, SUM(b_poin_santri.poin) AS jumlah_poin", "b_poin_santri", 
				"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
				"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
				"pegawai", "b_poin_santri.nrp=pegawai.nrp",
				"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
				$arraywhere, "b_poin_santri.id_siswa", "b_poin_santri.id_siswa", "ASC");
			
			foreach ($poin_santri as $key) { 
				$id_siswa = $key->id_siswa;
				$d_santri['id_siswa'][] = $id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'][] = $nama;
				$d_santri['nis'][] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'][] = $rayon[$key->id_kamar];
				$d_santri['kamar'][] = $key->nama_kamar;
				$d_santri['kelas'][] = $key->nama_kelas;
				$d_santri['poin'][] = $key->jumlah_poin; 
			}
			# jumlah santri yang ada di bwah walas login
			$data['jumlah_santri'] = count($poin_santri);
			# kirim data santri
			if (count($poin_santri)!=NULL) {
				$data['santri'] = $d_santri;
			}
        }
		
		$data['tak'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");
		# tampilkan data ke view
		$this->load->view('boarding/point_rewards', $data); 

		$this->load->view('template/footer');


	}

	function add_point_rewards(){
		$file_bukti = '';

		/* -- upload berkas -- */
		$this->upload->initialize(array(
			'file_name' => 'file_'.time(),
	        'upload_path' => './assets/file_bukti', // nama folder gambar
	        'allowed_types' => 'jpg|png|jpeg|bmp', // format gambar
	        )); 

		if($this->upload->do_upload('file_bukti')){
        	$data_upload = $this->upload->data();
        	# ambil nama buat di simpan di tabel database
        	$file_bukti = $data_upload['file_name'];       		
		}else{
			$error = $this->upload->display_errors();
			print_r($error);
		}
		/* -- end upload berkas --*/

		# get data dari form
		$tanggal = to_Ymd($this->input->post('tanggal', TRUE));
        $tahun_akademik  = $this->input->post('tahun_akademik', TRUE);
        $id_siswa  = $this->input->post('id_siswa', TRUE);
        $komentar  = $this->input->post('komentar', TRUE);
        $kronologi  = $this->input->post('kronologi', TRUE);
        $poin  = $this->input->post('poin', TRUE);
        $nrp = $this->session->userdata['nrp'];

        # mencari poin dan id_poin
        $exp = explode("-", $poin);
        $id_poin = $exp[0];
        $poin = $exp[1];

        #cari id_kamar
        $kamar = $this->m_models->get_data("id_kamar", "b_kamar_santri", "WHERE id_siswa='$id_siswa' AND id_tahun='$tahun_akademik' AND status='in' ");
        $id_kamar = $kamar[0]->id_kamar;

		# CEK JEJANG
		$jenjang=db_siswa($id_siswa);
		# mencari kelas
		$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $tahun_akademik, 
							'rombongan_belajar_'.$jenjang.'.id_siswa' => $id_siswa);
		$kelas = $this->m_models->getJoin1where("kelas.id_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
		$id_kelas = $kelas[0]->id_kelas;

 		$data = array (
		    'tanggal' => $tanggal,
		    'id_siswa' => $id_siswa,
		    'id_poin' => $id_poin,
		    'poin' => $poin,
		    'sanksi' => '',
		    'kronologi' => $kronologi,
		    'komentar' => $komentar,
		    'id_tahun' => $tahun_akademik,
		    'id_kamar' => $id_kamar,
		    'id_kelas' => $id_kelas,
		    'nrp' => $nrp,
		    'file_bukti' => $file_bukti
		);

		# proses simpan
		if ($this->m_models->save_data($data,"b_poin_santri") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('boarding/point_rewards');
	}

	function detail_rewards($id_siswa, $tahun_akademik){
		$this->load->view('template/header');

		$data[id_siswa] = $id_siswa;
		$data[tahun_akademik] = $tahun_akademik;
		# ambil post dari form cari
    //    $tahun_akademik  = $this->input->post('tahun_akademik', TRUE);
    //    $id_siswa  = $this->input->post('id_siswa', TRUE);
	
		# Cek nrp untuk mengaktifkan link delete, jika nrp login sama dengan nrp poin santri maka tampilkan link
		$data[nrp_walas] = $this->session->userdata['nrp'];

		$rayon = $this->getRayon();

		$arraywhere = array('b_poin_santri.id_tahun' => $tahun_akademik, 'b_poin_santri.id_siswa' => $id_siswa, 'b_poin.jenis' => 'reward');
		$data[poin] = $this->m_models->getJoin4where("b_poin_santri.*, b_kamar.nama as nama_kamar, kelas.nama_kelas, pegawai.nama as walas, b_poin.nama as nama_poin, b_poin.id_unit", "b_poin_santri", 
			"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
			"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
			"pegawai", "b_poin_santri.nrp=pegawai.nrp", 
			"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
			$arraywhere, "b_poin.id_unit", "ASC");

			# mencari data santri
			foreach ($data[poin] as $key) {
				$id_siswa = $key->id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'] = $nama;
				$d_santri['nis'] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'] = $rayon[$key->id_kamar];
				$d_santri['kamar'] = $key->nama_kamar;
				$d_santri['kelas'] = $key->nama_kelas;
				$d_santri['total_poin'] = $key->jumlah_poin;

				break;
			}

			#kirim data santri
			$data['santri'] = $d_santri;
			$data['periode'] = $this->m_models->get_data("periode", "tahun_akademik", "WHERE id_tahun='$tahun_akademik'");

			# mencari detail poin santri
			foreach ($data[poin] as $key) {
				$d_poin[$key->id_unit]['id_poin_santri'][] = $key->id_poin_santri;
				$d_poin[$key->id_unit]['nama_poin'][] = $key->nama_poin;
				$d_poin[$key->id_unit]['kronologi'][] = $key->kronologi;
				$d_poin[$key->id_unit]['sanksi'][] = $key->sanksi;
				$d_poin[$key->id_unit]['tanggal'][] = $key->tanggal;
				$d_poin[$key->id_unit]['walas'][] = $key->walas;
				$d_poin[$key->id_unit]['nrp'][] = $key->nrp;
				$d_poin[$key->id_unit]['poin'][] = $key->poin;
				$d_poin[$key->id_unit]['file_bukti'][] = $key->file_bukti;
				$arr_unit[] = $key->id_unit; 
				$jumlah_poin += $key->poin;
			}
			# jumlah data poin semuanya
			$data['jumlah_data'] = count($data[poin]);
			$data['dat'] = $d_poin;
			$data['total_poin'] = $jumlah_poin;

			# cari data unit buat header perulangan unit poin
			$unit = $this->m_models->getAll("b_unit ORDER BY nama ASC");
			foreach ($unit as $key) {
				$d_unit[$key->id_unit] = $key->nama;
			}
			$data[unit] = $d_unit;

			# data unit poin yang ada di pencarian
			$unit_unik = array_unique($arr_unit);
			foreach ($unit_unik as $key => $value) {
				$arr_unik[] = $value; 
			}
			$data[unit_poin] = $arr_unik;
        
		# tampilkan data ke view
		$this->load->view('boarding/detail_rewards', $data); 

		$this->load->view('template/footer');
	}

	#report_by_punish_point
	function report_by_punish_point(){
		$this->load->view('template/header');

		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		//$level_user = 78;
		# get akses pembinaan
		$data[akses_pembinaaan] = $this->getAksesPembinaan($level_user);
		$akses_pembinaaan = 'Putri';

		/* ------ Data untuk tampil setelah pencarian --- */
        $ta  = $this->input->post('tahun_akademik', TRUE);
        $unit  = $this->input->post('unit', TRUE);	
        $pembinaan  = $this->input->post('pembinaan', TRUE);

        if ($ta != null AND $unit != null) {
	        $data[tapilih] = $ta;
	        $data[unitpilih] = $unit;
	        $data[pembinaanpilih] = $pembinaan;

	        # mengambil data rayon
			$rayon = $this->getRayon();
			if ($pembinaan == 'Putra') {
				$jk = 'Laki-laki';
			}elseif ($pembinaan == 'Putri') {
				$jk = 'Perempuan';
			}

			if ($pembinaan == 'PutraPutri') {
				if ($unit == 'SemuaUnit') {
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'b_poin.jenis' => 'punish');
				}else{
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'b_poin.jenis' => 'punish', 'b_poin.id_unit' => $unit);
				}
			}else{
				if ($unit == 'SemuaUnit') {
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'pegawai.jk' => $jk, 'b_poin.jenis' => 'punish');
				}else{
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'pegawai.jk' => $jk, 'b_poin.jenis' => 'punish', 'b_poin.id_unit' => $unit);
				}				
			}
			
			$poin_santri = $this->m_models->getJoin4whereGroup("b_poin_santri.id_siswa, b_poin_santri.id_kamar, b_poin.poin as nilai_poin, b_poin.nama, b_poin.id_unit, COUNT(b_poin_santri.id_poin) AS freq", "b_poin_santri", 
				"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
				"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
				"pegawai", "b_poin_santri.nrp=pegawai.nrp",
				"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
				$arraywhere, "b_poin_santri.id_poin", "b_poin_santri.id_poin", "ASC");
			
			foreach ($poin_santri as $key) { 
			/*	$d_poin[$key->id_unit]['nama_poin'][] = $key->nama;
				$d_poin[$key->id_unit]['poin'][] = $key->nilai_poin;
				$d_poin[$key->id_unit]['freq'][] = $key->freq;
				$total = $key->nilai_poin * $key->freq;
				$d_poin[$key->id_unit]['total'][] = $total;
			*/
				$d_poin['id_unit'][] = $key->id_unit;
				$d_poin['nama_poin'][] = $key->nama;
				$d_poin['poin'][] = $key->nilai_poin;
				$d_poin['freq'][] = $key->freq;
				$total = $key->nilai_poin * $key->freq;
				$d_poin['total'][] = $total;
				$arr_unit[] = $key->id_unit; 
				$jumlah_poin += $total;
			}
			# jumlah data poin semuanya
			$data['jumlah_data'] = count($poin_santri);
			$data['dat'] = $d_poin;
			$data['total_poin'] = $jumlah_poin;

			# cari data unit buat header perulangan unit poin
			$data[d_unit] = $this->m_models->getAll("b_unit ORDER BY nama ASC");
			foreach ($data[d_unit] as $key) {
				$d_unit[$key->id_unit] = $key->nama;
			}
			$data[unit] = $d_unit;

			# data unit poin yang ada di pencarian
			$unit_unik = array_unique($arr_unit);
			foreach ($unit_unik as $key => $value) {
				$arr_unik[] = $value; 
			}
			$data[unit_poin] = $arr_unik;
        }
		
		$data[d_unit] = $this->m_models->getAll("b_unit ORDER BY nama ASC");

		$data['tak'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");
		# tampilkan data ke view
		$this->load->view('boarding/report_by_punish_point', $data); 

		$this->load->view('template/footer');
	}

	#report_by_reward_point
	function report_by_reward_point(){
		$this->load->view('template/header');

		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		//$level_user = 78;
		# get akses pembinaan
		$data[akses_pembinaaan] = $this->getAksesPembinaan($level_user);
	//	$akses_pembinaaan = 'Putri';

		/* ------ Data untuk tampil setelah pencarian --- */
        $ta  = $this->input->post('tahun_akademik', TRUE);
        $unit  = $this->input->post('unit', TRUE);	
        $pembinaan  = $this->input->post('pembinaan', TRUE);

        if ($ta != null AND $unit != null) {
	        $data[tapilih] = $ta;
	        $data[unitpilih] = $unit;
	        $data[pembinaanpilih] = $pembinaan;

	        # mengambil data rayon
			$rayon = $this->getRayon();
			if ($pembinaan == 'Putra') {
				$jk = 'Laki-laki';
			}elseif ($pembinaan == 'Putri') {
				$jk = 'Perempuan';
			}

			if ($pembinaan == 'PutraPutri') {
				if ($unit == 'SemuaUnit') {
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'b_poin.jenis' => 'reward');
				}else{
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'b_poin.jenis' => 'reward', 'b_poin.id_unit' => $unit);
				}
			}else{
				if ($unit == 'SemuaUnit') {
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'pegawai.jk' => $jk, 'b_poin.jenis' => 'reward');
				}else{
					$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'pegawai.jk' => $jk, 'b_poin.jenis' => 'reward', 'b_poin.id_unit' => $unit);
				}				
			}
			
			$poin_santri = $this->m_models->getJoin4whereGroup("b_poin_santri.id_siswa, b_poin_santri.id_kamar, b_poin.poin as nilai_poin, b_poin.nama, b_poin.id_unit, COUNT(b_poin_santri.id_poin) AS freq", "b_poin_santri", 
				"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
				"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
				"pegawai", "b_poin_santri.nrp=pegawai.nrp",
				"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
				$arraywhere, "b_poin_santri.id_poin", "b_poin_santri.id_poin", "ASC");
			
			foreach ($poin_santri as $key) { 
			/*	$d_poin[$key->id_unit]['nama_poin'][] = $key->nama;
				$d_poin[$key->id_unit]['poin'][] = $key->nilai_poin;
				$d_poin[$key->id_unit]['freq'][] = $key->freq;
				$total = $key->nilai_poin * $key->freq;
				$d_poin[$key->id_unit]['total'][] = $total;
			*/
				$d_poin['id_unit'][] = $key->id_unit;
				$d_poin['nama_poin'][] = $key->nama;
				$d_poin['poin'][] = $key->nilai_poin;
				$d_poin['freq'][] = $key->freq;
				$total = $key->nilai_poin * $key->freq;
				$d_poin['total'][] = $total;
				$arr_unit[] = $key->id_unit; 
				$jumlah_poin += $total;
			}
			# jumlah data poin semuanya
			$data['jumlah_data'] = count($poin_santri);
			$data['dat'] = $d_poin;
			$data['total_poin'] = $jumlah_poin;

			# cari data unit buat header perulangan unit poin
			$data[d_unit] = $this->m_models->getAll("b_unit ORDER BY nama ASC");
			foreach ($data[d_unit] as $key) {
				$d_unit[$key->id_unit] = $key->nama;
			}
			$data[unit] = $d_unit;

			# data unit poin yang ada di pencarian
			$unit_unik = array_unique($arr_unit);
			foreach ($unit_unik as $key => $value) {
				$arr_unik[] = $value; 
			}
			$data[unit_poin] = $arr_unik;
        }

        $data[d_unit] = $this->m_models->getAll("b_unit ORDER BY nama ASC");
		
		$data['tak'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");
		# tampilkan data ke view
		$this->load->view('boarding/report_by_reward_point', $data); 

		$this->load->view('template/footer');
	}

	#report_by_student
	function report_by_student(){
		$this->load->view('template/header');

		/* ------ DATA UNTUK FORM TAMBAH DATA ---- */
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
	//	$level_user = 78;
		# get akses pembinaan
		$data[akses_pembinaan] = $this->getAksesPembinaan($level_user);
	//	$data[akses_pembinaan] = 'PutraPutri';

		/* ------ Data untuk tampil setelah pencarian --- */
        $ta  = $this->input->post('tahun_akademik', TRUE);
        $kelas  = $this->input->post('kelas', TRUE);	
        $pembinaan  = $this->input->post('pembinaan', TRUE);

        if ($ta != null AND $kelas != null) {
	        $data[tapilih] = $ta;
	        $data[kelaspilih] = $kelas;
	        $data[pembinaanpilih] = $pembinaan;

	        # mengambil data rayon
			$rayon = $this->getRayon();

			if ($pembinaan == 'Putra') {
				$jk = 'Laki-laki';
			}elseif ($pembinaan == 'Putri') {
				$jk = 'Perempuan';
			}

			if ($pembinaan == 'PutraPutri') {
				$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'kelas.id_tingkatan_kelas' => $kelas);
			}else{
				$arraywhere = array('b_poin_santri.id_tahun' => $ta, 'kelas.id_tingkatan_kelas' => $kelas, 'pegawai.jk' => $jk);
			}
			
			$poin_santri = $this->m_models->getJoin4whereGroup("b_poin_santri.id_siswa, b_poin_santri.id_kamar, b_kamar.nama as nama_kamar, kelas.nama_kelas, 
				SUM(IF(b_poin.jenis='punish', b_poin_santri.poin, 0)) AS punish_poin, 
				SUM(IF(b_poin.jenis='reward', b_poin_santri.poin, 0)) AS reward_poin", "b_poin_santri", 
				"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
				"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
				"pegawai", "b_poin_santri.nrp=pegawai.nrp",
				"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
				$arraywhere, "b_poin_santri.id_siswa", "b_poin_santri.id_siswa", "ASC");
			
			foreach ($poin_santri as $key) { 
				$id_siswa = $key->id_siswa;
				$d_santri['id_siswa'][] = $id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'][] = $nama;
				$d_santri['nis'][] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'][] = $rayon[$key->id_kamar];
				$d_santri['kamar'][] = $key->nama_kamar;
				$d_santri['kelas'][] = $key->nama_kelas;
				$d_santri['punish_poin'][] = $key->punish_poin; 
				$d_santri['reward_poin'][] = $key->reward_poin;
				$d_santri['saldo'][] = $key->reward_poin - $key->punish_poin;
			}
			# jumlah santri yang ada di bwah walas login
			$data['jumlah_santri'] = count($poin_santri);
			# kirim data santri
			if (count($poin_santri)!=NULL) {
				$data['santri'] = $d_santri;
			}
        }
		
		$data['tak'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");
		# tampilkan data ke view
		$this->load->view('boarding/report_by_student', $data); 

		$this->load->view('template/footer');

	}

	function getKlasifikasi(){
		$this->load->view('template/head');
		$poin = $this->input->get('poin'); 

		$exp = explode("-", $poin);
		$id_poin = $exp[0];
	//	$jenis = $exp[1];

		$data['klasifikasi'] = $this->m_models->get_data("klasifikasi", "b_poin", "where id_poin='$id_poin' ");
	//	$data['poin'] = $this->m_models->get_data("*", "b_poin", "where id_unit='$id_unit' AND jenis='$jenis' AND status='On'");

		$this->load->view('boarding/klasifikasi', $data);
		
		$this->load->view('template/js');
	}

	#cetak_poin
	function detail_rewards_print($id_siswa, $tahun_akademik){

		$data[nrp_walas] = $this->session->userdata['nrp'];

		$rayon = $this->getRayon();

		$arraywhere = array('b_poin_santri.id_tahun' => $tahun_akademik, 'b_poin_santri.id_siswa' => $id_siswa, 'b_poin.jenis' => 'reward');
		$data[poin] = $this->m_models->getJoin4where("b_poin_santri.*, b_kamar.nama as nama_kamar, kelas.nama_kelas, pegawai.nama as walas, b_poin.nama as nama_poin, b_poin.id_unit", "b_poin_santri", 
			"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
			"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
			"pegawai", "b_poin_santri.nrp=pegawai.nrp", 
			"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
			$arraywhere, "b_poin.id_unit", "ASC");

			# mencari data santri
			foreach ($data[poin] as $key) {
				$id_siswa = $key->id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'] = $nama;
				$d_santri['nis'] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'] = $rayon[$key->id_kamar];
				$d_santri['kamar'] = $key->nama_kamar;
				$d_santri['kelas'] = $key->nama_kelas;
				$d_santri['total_poin'] = $key->jumlah_poin;

				break;
			}

			#kirim data santri
			$data['santri'] = $d_santri;
			$data['periode'] = $this->m_models->get_data("periode", "tahun_akademik", "WHERE id_tahun='$tahun_akademik'");

			# mencari detail poin santri
			foreach ($data[poin] as $key) {
				$d_poin[$key->id_unit]['id_poin_santri'][] = $key->id_poin_santri;
				$d_poin[$key->id_unit]['nama_poin'][] = $key->nama_poin;
				$d_poin[$key->id_unit]['kronologi'][] = $key->kronologi;
				$d_poin[$key->id_unit]['sanksi'][] = $key->sanksi;
				$d_poin[$key->id_unit]['tanggal'][] = $key->tanggal;
				$d_poin[$key->id_unit]['walas'][] = $key->walas;
				$d_poin[$key->id_unit]['nrp'][] = $key->nrp;
				$d_poin[$key->id_unit]['poin'][] = $key->poin;
				$d_poin[$key->id_unit]['file_bukti'][] = $key->file_bukti;
				$arr_unit[] = $key->id_unit; 
				$jumlah_poin += $key->poin;
			}
			# jumlah data poin semuanya
			$data['jumlah_data'] = count($data[poin]);
			$data['dat'] = $d_poin;
			$data['total_poin'] = $jumlah_poin;

			# cari data unit buat header perulangan unit poin
			$unit = $this->m_models->getAll("b_unit ORDER BY nama ASC");
			foreach ($unit as $key) {
				$d_unit[$key->id_unit] = $key->nama;
			}
			$data[unit] = $d_unit;

			# data unit poin yang ada di pencarian
			$unit_unik = array_unique($arr_unit);
			foreach ($unit_unik as $key => $value) {
				$arr_unik[] = $value; 
			}
			$data[unit_poin] = $arr_unik;

	    $this->load->library('pdf');

	//    $customPaper = array(0,0,269.291339,368.503937);
		$this->pdf->setPaper('A4', 'potrait');
	   	$this->pdf->load_view('boarding/detail_rewards_print', $data);
	   	$this->pdf->render();

	   	$this->pdf->stream("point_rewards.pdf", array('Attachment'=>0));
	}

	#cetak_poin
	function detail_punish_print($id_siswa, $tahun_akademik){

		$data[nrp_walas] = $this->session->userdata['nrp'];

		$rayon = $this->getRayon();

		$arraywhere = array('b_poin_santri.id_tahun' => $tahun_akademik, 'b_poin_santri.id_siswa' => $id_siswa, 'b_poin.jenis' => 'punish');
		$data[poin] = $this->m_models->getJoin4where("b_poin_santri.*, b_kamar.nama as nama_kamar, kelas.nama_kelas, pegawai.nama as walas, b_poin.nama as nama_poin, b_poin.id_unit", "b_poin_santri", 
			"b_kamar", "b_poin_santri.id_kamar=b_kamar.id_kamar", 
			"kelas", "b_poin_santri.id_kelas=kelas.id_kelas", 
			"pegawai", "b_poin_santri.nrp=pegawai.nrp", 
			"b_poin", "b_poin_santri.id_poin=b_poin.id_poin",
			$arraywhere, "b_poin.id_unit", "ASC");

			# mencari data santri
			foreach ($data[poin] as $key) {
				$id_siswa = $key->id_siswa;

				# CEK JEJANG
				$jenjang = db_siswa($id_siswa);
				$nama = all("siswa_".$jenjang, "id_siswa", $id_siswa, "nama_lengkap");
				$d_santri['nama'] = $nama;
				$d_santri['nis'] = substr($id_siswa, 3, strlen($id_siswa));
				$d_santri['rayon'] = $rayon[$key->id_kamar];
				$d_santri['kamar'] = $key->nama_kamar;
				$d_santri['kelas'] = $key->nama_kelas;
				$d_santri['total_poin'] = $key->jumlah_poin;

				break;
			}

			#kirim data santri
			$data['santri'] = $d_santri;
			$data['periode'] = $this->m_models->get_data("periode", "tahun_akademik", "WHERE id_tahun='$tahun_akademik'");

			# mencari detail poin santri
			foreach ($data[poin] as $key) {
				$d_poin[$key->id_unit]['id_poin_santri'][] = $key->id_poin_santri;
				$d_poin[$key->id_unit]['nama_poin'][] = $key->nama_poin;
				$d_poin[$key->id_unit]['kronologi'][] = $key->kronologi;
				$d_poin[$key->id_unit]['sanksi'][] = $key->sanksi;
				$d_poin[$key->id_unit]['tanggal'][] = $key->tanggal;
				$d_poin[$key->id_unit]['walas'][] = $key->walas;
				$d_poin[$key->id_unit]['nrp'][] = $key->nrp;
				$d_poin[$key->id_unit]['poin'][] = $key->poin;
				$d_poin[$key->id_unit]['file_bukti'][] = $key->file_bukti;
				$arr_unit[] = $key->id_unit; 
				$jumlah_poin += $key->poin;
			}
			# jumlah data poin semuanya
			$data['jumlah_data'] = count($data[poin]);
			$data['dat'] = $d_poin;
			$data['total_poin'] = $jumlah_poin;

			# cari data unit buat header perulangan unit poin
			$unit = $this->m_models->getAll("b_unit ORDER BY nama ASC");
			foreach ($unit as $key) {
				$d_unit[$key->id_unit] = $key->nama;
			}
			$data[unit] = $d_unit;

			# data unit poin yang ada di pencarian
			$unit_unik = array_unique($arr_unit);
			foreach ($unit_unik as $key => $value) {
				$arr_unik[] = $value; 
			}
			$data[unit_poin] = $arr_unik;

	    $this->load->library('pdf');

	//    $customPaper = array(0,0,269.291339,368.503937);
		$this->pdf->setPaper('A4', 'potrait');
	   	$this->pdf->load_view('boarding/detail_punish_print', $data);
	   	$this->pdf->render();

	   	$this->pdf->stream("point_punish.pdf", array('Attachment'=>0));
	}

	function info_kamar(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# ambil data dari post pencarian
		$jenjang  = 'SMPSMA'; 
		$bulan  = date('m');
        $tahun  = date('Y');
        $thnbln = $tahun.'-'.$bulan;
        $thnblntgl = $tahun.'-'.$bulan.'-15';
        $akhir_bulan = date('Y-m-t', strtotime($thnbln.'-01'));
    //    $bln_sebelum = date('m', strtotime($thnblntgl . '- 1 month'));
    //    $bulan_sebelum = date('Y-m', strtotime($thnblntgl . '- 1 month'));
	//	$akhir_bulan_sebelum = date('Y-m-t', strtotime($bulan_sebelum.'-01'));

	//	$data['kamar'] = $this->m_models->get_data("b_kamar.nama, b_kamar.id_kamar", "b_kamar", " GROUP BY nama ORDER BY id_kamar ASC");
		$arraywhere = array('b_asrama.jenis' => $akses_pembinaaan);
		$data['kamar'] = $this->m_models->getJoin1whereGroup("b_kamar.nama, b_kamar.id_kamar", "b_kamar", "b_asrama", "b_kamar.id_asrama=b_asrama.id_asrama", $arraywhere, "b_kamar.nama", "b_kamar.id_kamar", "ASC");
		$tot_kamar = count($data['kamar']);
		$data['tot_kamar'] = $tot_kamar;

	//	$data['jenjangpilih'] = $jenjang;
    //   $data['bln_pilih'] = $bulan;
    //    $data['bln_sebelum'] = $bln_sebelum;
    //    $data['thn_pilih'] = $tahun;

        if ($bulan != NULL AND $tahun != NULL) {
        	$id_tahun = $this->getTahunAkademik($thnbln.'-01');

        	# ambil data seua rayon sesuai akses pembinaan
        	$i = 0;
        	$rayon = $this->m_models->get_data("*", "b_asrama", "WHERE jenis='$akses_pembinaaan' ORDER BY nama ASC");
        	foreach ($rayon as $key) {
        		$jumlah_kamar_per_rayon = 0;
        		$jumlah_santri_per_rayon = 0;
        		$jumlah_tersedia_per_rayon = 0;

        	 	# cari data kamar sesuai id_asrama
        	 	$kamar = $this->m_models->get_data("id_kamar, nama, kapasitas", "b_kamar", "WHERE id_asrama='$key->id_asrama' AND status='1'");
        	 	foreach ($kamar as $kam) {
		        	if ($jenjang == 'SMPSMA') { 
	        	 		# cari jumlah santri per kamar
	        	 		$jumlah_santri_per_kamar = $this->JumlahSantriPerKamar($kam->id_kamar, $akhir_bulan, $id_tahun);
	        	 		$santri_per_kamar[$kam->nama][$i] = $jumlah_santri_per_kamar;
	        	 		$kapasitas[$kam->nama][$i] = $kam->kapasitas;
	        	 		$total_kapasitas += $kam->kapasitas;
	        	 		$masih_tersedia = $kam->kapasitas - $jumlah_santri_per_kamar;
	        	 		$tersedia[$kam->nama][$i] = $masih_tersedia;

	        	 		# perhitungan jumlah santri per rayon
	        	 		$jumlah_santri_per_rayon += $jumlah_santri_per_kamar; 

	        	 		# perhitugan jumlah ketersediaan kamar per rayon
	        	 		$jumlah_tersedia_per_rayon += $masih_tersedia;
		        	}
        	 	}

		       	if ($jenjang == 'SMPSMA') {
		       		# data untuk list rayon
        	 		$d_rayon[] = $key->nama;

	        	 	# jumlah santri per rayon
	        	 	$jumlah_santri[] = $jumlah_santri_per_rayon;

	        	 	# jumlah ketersediaan per rayon
	        	 	$jumlah_tersedia[] = $jumlah_tersedia_per_rayon;

	        	 	# jumlah kamar per rayon
	        	 	$jumlah_kamar[] = count($kamar);

	        	 	$i++;
	        	}
        	 } 

        	$data['rayon'] = $d_rayon;
        	$data['jumlah_rayon'] = count($d_rayon);
        	$data['santri_per_kamar'] = $santri_per_kamar;
        	$data['kapasitas'] = $kapasitas;
        	$data['tersedia'] = $tersedia;
        	$data['jumlah_kamar'] = $jumlah_kamar;
        	$data['jumlah_santri'] = $jumlah_santri;
        	$data['jumlah_tersedia'] = $jumlah_tersedia;
        	$data['total_kamar'] = array_sum($jumlah_kamar);
        	$data['total_santri'] = array_sum($jumlah_santri);
        	$data['total_tersedia'] = array_sum($jumlah_tersedia);
        	$data['total_kapasitas'] = $total_kapasitas;
        }
		
		$this->load->view('boarding/info_kamar',$data);

		$this->load->view('template/footer');			
	}

	function pengelolaan_santri(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;
		$data['tahun_akademik_aktif'] = $id_tahun;

		# ambil data tahun akademik
		$data['tahun_akademik'] = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE id_tahun >= '8' ORDER BY id_tahun DESC");

		# mencari data pegawai untuk walas
		if ( $akses_pembinaaan=='Putra' ) {
			$jk = 'Laki-laki';
			$jenis_asrama = 'Putra';
		}else{
			$jk = 'Perempuan';
			$jenis_asrama = 'Putri';
		}

		$data['walas'] = $this->m_models->get_data("nrp, nama", "pegawai", "WHERE (id_sekolah='20' OR id_sekolah='21' OR id_sekolah='22') AND jk='$jk' ORDER BY nama ASC");

		$data['asrama'] = $this->m_models->get_data("*", "b_asrama", "WHERE jenis='$jenis_asrama' ORDER BY nama ASC");

		$arraywhere = array('sekolah.kategori' => 'Sekolah', 'sekolah.simtitis' => 'Ya');
		$data['sekolah'] = $this->m_models->getJoin1where("sekolah.id_sekolah, sekolah.nama, sekolah.id_jenjang, sekolah.kode_pengenal, sekolah.id_jenjang, jenjang_pendidikan.nama_jenjang", "sekolah","jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", $arraywhere, "id_sekolah", "ASC");

		$this->load->view('boarding/pengelolaan_santri', $data); 

		$this->load->view('template/footer');
	}

	function data_kamar_santri(){
		$tahun_akademik = $this->input->post('tahun_akademik');	
		$tahun_akademik = 8;
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		//$akses_pembinaaan = $this->getAksesPembinaan($level_user);
		$akses_pembinaaan = 'Putri';
		# ambil data asrama
		$where_akses_pembinaan_asrama = '';
		$where_akses_pembinaan_walas = '';
		if ($akses_pembinaaan != 'PutraPutri') {
			$where_akses_pembinaan_asrama = "WHERE jenis='".$akses_pembinaaan."' ";
			$where_akses_pembinaan_walas = "AND pembinaan='".$akses_pembinaaan."' ";
		}

		$d_asrama = $this->m_models->get_data("*", "b_asrama", $where_akses_pembinaan_asrama." ORDER BY nama ASC");
		$asrama = array();
		foreach ($d_asrama as $key) {
			$asrama[$key->id_asrama] = $key->nama;
		}
		$data['asrama'] = $asrama;

		$data['walas'] = $this->m_models->get_data("w.*, p.nama, k.id_asrama, k.nama as nama_kamar","b_walas w", "JOIN pegawai p ON w.nrp=p.nrp JOIN b_kamar k ON w.id_kamar=k.id_kamar WHERE id_tahun='$tahun_akademik'  ".$where_akses_pembinaan_walas." ORDER BY w.id_walas DESC" );


		$this->load->view('boarding/data_kamar_santri', $data); 
	}

	function getKamarKosong(){
		$id_asrama_ta = $this->input->get('id_asrama'); 

		$exp = explode("-", $id_asrama_ta);
	//	echo $exp[0] . ' ' . $exp[1];
		$id_asrama = $exp[0];
		$tahun_akademik = $exp[1];

	//	$data['kamar'] = $this->m_models->get_data("id_kamar, nama", "b_kamar", "WHERE id_kamar NOT IN (SELECT id_kamar FROM b_walas WHERE id_tahun='$tahun_akademik') AND id_asrama='$id_asrama' ORDER BY id_kamar ASC");
		$data['kamar'] = $this->m_models->get_data("id_kamar, nama", "b_kamar", "WHERE id_asrama='$id_asrama' AND status='1' ORDER BY id_kamar ASC");

		$d_kamar_isi = $this->m_models->get_data("id_kamar, nama", "b_kamar", "WHERE id_kamar IN (SELECT id_kamar FROM b_walas WHERE id_tahun='$tahun_akademik') AND id_asrama='$id_asrama' ORDER BY id_kamar ASC");
		$kamar_isi = array();
		foreach ($d_kamar_isi as $key) {
			$kamar_isi[] = $key->id_kamar;
		}
		$data['kamar_isi'] = $kamar_isi;


		$this->load->view('boarding/kamar_kosong', $data); 
	}

	function getSiswaSekolah(){
		$sekolah = $this->input->get('sekolah'); 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$id_sekolah = $exp[1];
		$id_tahun = $exp[2];
		
		#query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		$arraywhere = array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun);
		$data['siswa'] = $this->m_models->getJoin1where($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, "nama_lengkap", "ASC");

		 $this->load->view('boarding/data_siswa_sekolah', $data);
		 $this->load->view('template/js');

	}

	function detail_data_kamar_santri(){
		$id_walas = $this->input->post('id', TRUE);
		// echo $id_walas;

		$this->load->view('boarding/detail_data_kamar_santri', $data);

	}

	#santri_by_walas
	function santri_by_walas(){
		$this->load->view('template/header');
        # Cek Level User untuk menentukan akses pembinaan
        $level_user = $this->session->userdata['hak_akses'];

        # get akses pembinaan
        $akses_pembinaaan = $this->getAksesPembinaan($level_user);


        if ($akses_pembinaaan=='PutraPutri') {
            $data['walas'] = $this->m_models->get_data("w.nrp, p.nama", "b_walas w", "JOIN pegawai p ON w.nrp=p.nrp GROUP BY w.nrp ORDER BY p.nama ASC");
        }else{
            $data['walas'] = $this->m_models->get_data("w.nrp, p.nama", "b_walas w", "JOIN pegawai p ON w.nrp=p.nrp WHERE w.pembinaan='$akses_pembinaaan' GROUP BY w.nrp ORDER BY p.nama ASC");
        }

		# tampilkan data ke view
		$this->load->view('boarding/santri_by_walas', $data); 

		$this->load->view('template/footer');	
	}

	#santri_walas
	function santri_by_walas_data(){
        # Cek Level User untuk menentukan akses pembinaan
        $level_user = $this->session->userdata['hak_akses'];

        # get akses pembinaan
        $akses_pembinaaan = $this->getAksesPembinaan($level_user);

 		# ambil data dari form pencarian
		$nrp_walas = $this->input->post('walas', TRUE);
        //$bulan = to_Ym($this->input->post('bulan', TRUE));
        $bulan = date('Y-m', strtotime($this->input->post('bulan', TRUE)));
        $awal_bulan = $bulan.'-01';
        $akhir_bulan = date('Y-m-t', strtotime($awal_bulan));

    	$tahun_akademik = $this->getTahunAkademik($bulan.'-01');

    	$kamar_walas = $this->m_models->get_data("k.nama AS nama_kamar, a.nama AS nama_rayon, k.id_kamar", "b_kamar k", "JOIN b_walas w ON k.id_kamar=w.id_kamar JOIN b_asrama a ON k.id_asrama=a.id_asrama WHERE w.nrp='$nrp_walas' AND w.id_tahun='$tahun_akademik' ORDER BY k.nama ASC");
        
        $nama_rayon = array();
    	$santri_kamar = array();
    	foreach ($kamar_walas as $key){
    		$santri = $this->m_models->get_data("id_siswa", "b_kamar_santri", "WHERE id_kamar='$key->id_kamar' AND id_tahun='$tahun_akademik' AND (
    			(masuk<='$awal_bulan' AND keluar='0000-00-00' AND pindah='0000-00-00') OR 
    			(masuk<='$awal_bulan' AND keluar>='$akhir_bulan' AND pindah='0000-00-00') OR
    			(masuk<='$awal_bulan' AND keluar='0000-00-00' AND pindah>='$akhir_bulan') OR
    			(masuk<='$awal_bulan' AND keluar>='$akhir_bulan' AND pindah>='$akhir_bulan')
    		) ");
    		foreach ($santri as $santri) {
    			$jenjang = db_siswa($santri->id_siswa);
				$nama_siswa = all("siswa_".$jenjang, "id_siswa", $santri->id_siswa, "nama_lengkap");
				$kelas_siswa = $this->m_models->get_data("k.nama_kelas", "rombongan_belajar_".$jenjang." r", "JOIN kelas k ON r.id_kelas=k.id_kelas WHERE r.id_siswa='$santri->id_siswa' AND r.id_tahun='$tahun_akademik' ");

    			$santri_kamar[$key->id_kamar]['nama'][$santri->id_siswa] = $nama_siswa;
    			$santri_kamar[$key->id_kamar]['kelas'][$santri->id_siswa] = $kelas_siswa[0]->nama_kelas;
    		}

    		$nama_rayon[] = $key->nama_rayon;
    	}

    	$data['kamar_walas'] = $kamar_walas;
    	$data['santri_kamar'] = $santri_kamar;

    	if ($this->input->post('data_excel', TRUE) == 'data_excel') {
    		$data['nama_rayon'] = array_unique($nama_rayon);

    		$pegawai = $this->m_models->get_data("nama", "pegawai", "WHERE nrp='$nrp_walas'");
    		$data['walas'] = $pegawai[0]->nama;

    		$ta = $this->m_models->get_data("periode", "tahun_akademik", "WHERE id_tahun='$tahun_akademik' ");
			$data['tahun_akademik'] = $ta[0]->periode;

			$data['pembinaan'] = $akses_pembinaaan;

			if ($akses_pembinaaan == 'Putri') {
				$data['jenis_santri'] = "AKHWAT";
			}else{
				$data['jenis_santri'] = "IKHWAN";
			}

			$exp = explode("-", $bulan);
			$data['periode'] = bulan($exp[1]).' '.$exp[0];

    		$this->load->view('boarding/santri_by_walas_data_excel', $data);
    	}else{
			# tampilkan data ke view
			$this->load->view('boarding/santri_by_walas_data', $data);     		
    	}

	}

	#jumlah_santri_by_walas
	function jumlah_santri_by_walas(){
		$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# ambil data dari post pencarian
		$bulan  = $this->input->post('bln', TRUE);
        $tahun  = $this->input->post('thn', TRUE);
        $thnbln = $tahun.'-'.$bulan;
        $thnblntgl = $tahun.'-'.$bulan.'-15';
        $akhir_bulan = date('Y-m-t', strtotime($thnbln.'-01'));
        $bln_sebelum = date('m', strtotime($thnblntgl . '- 1 month'));
        $bulan_sebelum = date('Y-m', strtotime($thnblntgl . '- 1 month'));
		$akhir_bulan_sebelum = date('Y-m-t', strtotime($bulan_sebelum.'-01'));

        $data['bln_pilih'] = $bulan;
        $data['bln_sebelum'] = $bln_sebelum;
        $data['thn_pilih'] = $tahun;

        if ($bulan != NULL AND $tahun != NULL) {
        	$id_tahun = $this->getTahunAkademik($thnbln.'-01');

        	$rayon = $this->getRayon();
       	
        	
        	# ambil data walas order by nama untuk dapatkan nama semua wala
        	$walas = $this->m_models->get_data("b_walas.*, pegawai.nama as nama_walas", "b_walas", " JOIN pegawai ON b_walas.nrp=pegawai.nrp WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' GROUP BY b_walas.nrp ORDER BY pegawai.nama ASC ");
        	$idx = 0;
        	foreach ($walas as $key) {
        		# set kosong tiap perulangan
        		$nama_rayon = '';
        		$nama_kamar = '';
        		$nama_rayon_tmp = '';
        		$total_jml_santri_bulan_cari = 0;
        		$total_jml_santri_sebelum_bulan_cari = 0;
        		$total_jml_santri_keluar_bulan_cari = 0;
        		$nama_kelas = '';
        		$nama_kelas_tmp = '';
        		$nama_kelas_tmp1 = '';

		        # mencari data kamar tiap walas
		        $kamar = $this->m_models->get_data("b_kamar.nama as nama_kamar, b_walas.id_kamar", "b_walas", " JOIN b_kamar ON b_walas.id_kamar=b_kamar.id_kamar WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' AND b_walas.nrp='$key->nrp' ORDER BY b_kamar.id_asrama DESC, b_kamar.nama ASC");
		        foreach ($kamar as $kam) {
		        	# mengisi nama-nama kamar
		        	$nama = $kam->nama_kamar;
		        	if ($nama_kamar == '') {
		        		$nama_kamar = $nama;
		        	}else{
		        		$nama_kamar = $nama_kamar.', '.$nama;
		        	}

		        	# mengisi nama rayon
		        	if ($nama_rayon == '') {
		        		$nama_rayon = $rayon[$kam->id_kamar];
		        	}elseif ($nama_rayon_tmp != $rayon[$kam->id_kamar]) {
		        		$nama_rayon = $nama_rayon .' &bull; '.$rayon[$kam->id_kamar];
		        	}
		        	$nama_rayon_tmp = $rayon[$kam->id_kamar];

		        	# mengisi nama kelas
		        	$nama_kelas_tmp1 = $this->get1TingkatKelas($kam->id_kamar, $id_tahun);
		        	if ($nama_kelas == '') {
		        		$nama_kelas = $nama_kelas_tmp1;
		        	}elseif ($nama_kelas_tmp != $nama_kelas_tmp1) {
		        	//	$nama_kelas = $nama_kelas  .' &bull; '. $nama_kelas_tmp1;

		        		$d_resume['walas'][$idx] = $key->nama_walas;
		        		$d_resume['kelas'][$idx] = $nama_kelas;
		        		$d_resume['rayon'][$idx] = $nama_rayon;

		        		$d_resume['kamar'][$idx] = substr($nama_kamar, 0, strlen($nama_kamar)-strlen($nama)-2);
		        		$d_resume['jml_bulan_cari'][$idx] = $total_jml_santri_bulan_cari;

		        		$total_jml_santri_bulan_cari = 0;
		        		$nama_kelas = $nama_kelas_tmp1;
		        		$nama_kamar = $nama;
		        		$idx++;

		        	}
		        	$nama_kelas_tmp = $nama_kelas_tmp1;

		        	# mencari jumlah santri aktif pada bulan cari
		        	$jml_santri_bulan_cari = $this->JumlahSantriPerKamar($kam->id_kamar, $akhir_bulan, $id_tahun);
		        	$total_jml_santri_bulan_cari += $jml_santri_bulan_cari;
		        	$sum_santri_bulan_cari += $jml_santri_bulan_cari;

		        }

        		$d_resume['walas'][$idx] = $key->nama_walas;
        		$d_resume['kelas'][$idx] = $nama_kelas;
        		$d_resume['rayon'][$idx] = $nama_rayon;
        		$d_resume['kamar'][$idx] = $nama_kamar;
        		$d_resume['jml_bulan_cari'][$idx] = $total_jml_santri_bulan_cari;
        		$idx++;
        	}

        	$data['resume'] = $d_resume;
   			$data['sum_santri_bulan_cari'] = $sum_santri_bulan_cari;
        	$data['jumlah_walas'] = $idx;


	        $tingkatan_kelas = array('VII', 'VIII', 'IX', 'X', 'XI', 'XII');
	        $data_jumlah = array();
	        foreach ($tingkatan_kelas as $key => $value) {
	        	$arr_jumlah = array();
	        	$a = 0;
	            for ($i=0; $i < $idx ; $i++ ) { 
	            	if ($d_resume['kelas'][$i] == $value) {
		            	$arr_jumlah['walas'][$a] = $d_resume['walas'][$i];
		            	$arr_jumlah['kelas'][$a] = $d_resume['kelas'][$i];
		            	$arr_jumlah['rayon'][$a] = $d_resume['rayon'][$i];
		            	$arr_jumlah['kamar'][$a] = $d_resume['kamar'][$i];
		            	$arr_jumlah['jml_per_rayon'][$a] = $d_resume['jml_bulan_cari'][$i];
		            	$a++;
	            	}
	            }

	            $data_jumlah[$value] = $arr_jumlah;
	            $jumlah_per_angkatan[$value] = array_sum($arr_jumlah['jml_per_rayon']); 
	        }

	        $data['jumlah_santri'] = $data_jumlah;
	        $data['jumlah_per_angkatan'] = $jumlah_per_angkatan;
	        $data['jumlah_total'] = array_sum($jumlah_per_angkatan);

        }

        $this->load->view('boarding/jumlah_santri_by_walas',$data);

		$this->load->view('template/footer');			
	}

	function get1TingkatKelas($id_kamar, $tahun_akademik){

		$santri = $this->m_models->get_data("id_siswa", "b_kamar_santri", "WHERE id_kamar='$id_kamar' AND id_tahun='$tahun_akademik'");

		$id_siswa = $santri[0]->id_siswa; 

		$jenjang=db_siswa($id_siswa);

		if ($jenjang != '') {
			$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $tahun_akademik, 
							'rombongan_belajar_'.$jenjang.'.id_siswa' => $id_siswa);
			$kelas = $this->m_models->getJoin1where("kelas.nama_kelas, kelas.id_tingkatan_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
			//$nama_kelas = $kelas[0]->nama_kelas;
			$id_tingkatan_kelas = $kelas[0]->id_tingkatan_kelas;

			$tingkat = $this->m_models->get_data("tingkat", "tingkatan_kelas", "WHERE id_tingkatan_kelas='$id_tingkatan_kelas' ");
			$nama_tingkat = $tingkat[0]->tingkat;
		}

		return $nama_tingkat;
	}

	#jumlah_santri_by_walas
	function jumlah_santri_by_walas_excel($bln, $thn){
	//	$this->load->view('template/header');
		# Cek Level User untuk menentukan akses pembinaan
		$level_user = $this->session->userdata['hak_akses'];
		# get akses pembinaan
		$akses_pembinaaan = $this->getAksesPembinaan($level_user);

		# ambil data dari post pencarian
		$bulan  = $bln;
        $tahun  = $thn;
        $thnbln = $tahun.'-'.$bulan;
        $thnblntgl = $tahun.'-'.$bulan.'-15';
        $akhir_bulan = date('Y-m-t', strtotime($thnbln.'-01'));
        $bln_sebelum = date('m', strtotime($thnblntgl . '- 1 month'));
        $bulan_sebelum = date('Y-m', strtotime($thnblntgl . '- 1 month'));
		$akhir_bulan_sebelum = date('Y-m-t', strtotime($bulan_sebelum.'-01'));

        $data['bln_pilih'] = $bulan;
        $data['bln_sebelum'] = $bln_sebelum;
        $data['thn_pilih'] = $tahun;

        if ($bulan != NULL AND $tahun != NULL) {
        	$id_tahun = $this->getTahunAkademik($thnbln.'-01');

        	$rayon = $this->getRayon();
       	
        	
        	# ambil data walas order by nama untuk dapatkan nama semua wala
        	$walas = $this->m_models->get_data("b_walas.*, pegawai.nama as nama_walas", "b_walas", " JOIN pegawai ON b_walas.nrp=pegawai.nrp WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' GROUP BY b_walas.nrp ORDER BY pegawai.nama ASC ");
        	$idx = 0;
        	foreach ($walas as $key) {
        		# set kosong tiap perulangan
        		$nama_rayon = '';
        		$nama_kamar = '';
        		$nama_rayon_tmp = '';
        		$total_jml_santri_bulan_cari = 0;
        		$total_jml_santri_sebelum_bulan_cari = 0;
        		$total_jml_santri_keluar_bulan_cari = 0;
        		$nama_kelas = '';
        		$nama_kelas_tmp = '';
        		$nama_kelas_tmp1 = '';

		        # mencari data kamar tiap walas
		        $kamar = $this->m_models->get_data("b_kamar.nama as nama_kamar, b_walas.id_kamar", "b_walas", " JOIN b_kamar ON b_walas.id_kamar=b_kamar.id_kamar WHERE b_walas.pembinaan='$akses_pembinaaan' AND b_walas.id_tahun='$id_tahun' AND b_walas.nrp='$key->nrp' ORDER BY b_kamar.id_asrama DESC, b_kamar.nama ASC");
		        foreach ($kamar as $kam) {
		        	# mengisi nama-nama kamar
		        	$nama = $kam->nama_kamar;
		        	if ($nama_kamar == '') {
		        		$nama_kamar = $nama;
		        	}else{
		        		$nama_kamar = $nama_kamar.', '.$nama;
		        	}

		        	# mengisi nama rayon
		        	if ($nama_rayon == '') {
		        		$nama_rayon = $rayon[$kam->id_kamar];
		        	}elseif ($nama_rayon_tmp != $rayon[$kam->id_kamar]) {
		        		$nama_rayon = $nama_rayon .' &bull; '.$rayon[$kam->id_kamar];
		        	}
		        	$nama_rayon_tmp = $rayon[$kam->id_kamar];

		        	# mengisi nama kelas
		        	$nama_kelas_tmp1 = $this->get1TingkatKelas($kam->id_kamar, $id_tahun);
		        	if ($nama_kelas == '') {
		        		$nama_kelas = $nama_kelas_tmp1;
		        	}elseif ($nama_kelas_tmp != $nama_kelas_tmp1) {
		        	//	$nama_kelas = $nama_kelas  .' &bull; '. $nama_kelas_tmp1;

		        		$d_resume['walas'][$idx] = $key->nama_walas;
		        		$d_resume['kelas'][$idx] = $nama_kelas;
		        		$d_resume['rayon'][$idx] = $nama_rayon;

		        		$d_resume['kamar'][$idx] = substr($nama_kamar, 0, strlen($nama_kamar)-strlen($nama)-2);
		        		$d_resume['jml_bulan_cari'][$idx] = $total_jml_santri_bulan_cari;

		        		$total_jml_santri_bulan_cari = 0;
		        		$nama_kelas = $nama_kelas_tmp1;
		        		$nama_kamar = $nama;
		        		$idx++;

		        	}
		        	$nama_kelas_tmp = $nama_kelas_tmp1;

		        	# mencari jumlah santri aktif pada bulan cari
		        	$jml_santri_bulan_cari = $this->JumlahSantriPerKamar($kam->id_kamar, $akhir_bulan, $id_tahun);
		        	$total_jml_santri_bulan_cari += $jml_santri_bulan_cari;
		        	$sum_santri_bulan_cari += $jml_santri_bulan_cari;

		        }

        		$d_resume['walas'][$idx] = $key->nama_walas;
        		$d_resume['kelas'][$idx] = $nama_kelas;
        		$d_resume['rayon'][$idx] = $nama_rayon;
        		$d_resume['kamar'][$idx] = $nama_kamar;
        		$d_resume['jml_bulan_cari'][$idx] = $total_jml_santri_bulan_cari;
        		$idx++;
        	}

        	$data['resume'] = $d_resume;
   			$data['sum_santri_bulan_cari'] = $sum_santri_bulan_cari;
        	$data['jumlah_walas'] = $idx;


	        $tingkatan_kelas = array('VII', 'VIII', 'IX', 'X', 'XI', 'XII');
	        $data_jumlah = array();
	        foreach ($tingkatan_kelas as $key => $value) {
	        	$arr_jumlah = array();
	        	$a = 0;
	            for ($i=0; $i < $idx ; $i++ ) { 
	            	if ($d_resume['kelas'][$i] == $value) {
		            	$arr_jumlah['walas'][$a] = $d_resume['walas'][$i];
		            	$arr_jumlah['kelas'][$a] = $d_resume['kelas'][$i];
		            	$arr_jumlah['rayon'][$a] = $d_resume['rayon'][$i];
		            	$arr_jumlah['kamar'][$a] = $d_resume['kamar'][$i];
		            	$arr_jumlah['jml_per_rayon'][$a] = $d_resume['jml_bulan_cari'][$i];
		            	$a++;
	            	}
	            }

	            $data_jumlah[$value] = $arr_jumlah;
	            $jumlah_per_angkatan[$value] = array_sum($arr_jumlah['jml_per_rayon']); 
	        }

	        $data['jumlah_santri'] = $data_jumlah;
	        $data['jumlah_per_angkatan'] = $jumlah_per_angkatan;
	        $data['jumlah_total'] = array_sum($jumlah_per_angkatan);

        }


		$ta = $this->m_models->get_data("periode", "tahun_akademik", "WHERE id_tahun='$id_tahun' ");
		$data['tahun_akademik'] = $ta[0]->periode;

		$data['pembinaan'] = $akses_pembinaaan;

		if ($akses_pembinaaan == 'Putri') {
			$data['jenis_santri'] = "AKHWAT";
		}else{
			$data['jenis_santri'] = "IKHWAN";
		}

		$exp = explode("-", $thnbln);
		$data['periode'] = bulan($exp[1]).' '.$exp[0];
     	$this->load->view('boarding/jumlah_santri_by_walas_excel',$data);
		
	}
	

}