<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Angket extends CI_Controller {
	function __construct() {
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	//angket kepuasan untuk Siswa
	public function angket_kepuasan(){
		$this->load->view('template/head'); 
		$id_siswa=$this->session->userdata['id_siswa']; 
		$ar_angket=array('status =' => "on", 'kategori =' => 'Siswa');
		$data['pertanyaan_angket'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $ar_angket, "pertanyaan", "asc");

		$arraywhere=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arraywhere, "nama", "asc");


		//data favorit
		$ak=array('jenis =' => 'kriteria', 'status =' => 'on');
		$data['kriteria'] = $this->m_models->getTabelwhere("*", "peg_saran", $ak, "nama_saran", "asc");
		$af=array('jenis =' => 'favorit', 'status =' => 'on');
		$data['favorit'] = $this->m_models->getTabelwhere("*", "peg_saran", $af, "nama_saran", "asc");
		foreach ($data['favorit'] as $f){
			if ($f->id_saran=="7"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and jk='Laki-laki' and ((id_jabatan = '6' or id_jabatan = '7') or (id_jabatan2 = '6' or id_jabatan2 = '7')) order by pegawai.nama asc");
			} else if ($f->id_saran=="8"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and jk='Perempuan' and ((id_jabatan = '6' or id_jabatan = '7') or (id_jabatan2 = '6' or id_jabatan2 = '7')) order by pegawai.nama asc");
			} else if ($f->id_saran=="9"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and ((id_jabatan = '52' or id_jabatan = '83') or (id_jabatan2 = '52' or id_jabatan2 = '83')) order by pegawai.nama asc");
			} else if ($f->id_saran=="10"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and ((id_jabatan = '45' or id_jabatan = '61' or id_jabatan = '66') or (id_jabatan2 = '45' or id_jabatan2 = '61' or id_jabatan2 = '66')) order by pegawai.nama asc");
			} else if ($f->id_saran=="11"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and (id_jabatan = '42' or id_jabatan2 = '42') order by pegawai.nama asc");
			} else if ($f->id_saran=="12"){
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and (id_jabatan = '65' or id_jabatan2 = '65') order by pegawai.nama asc");
			} else {
				$data['pegawai_fav'][$f->id_saran] = $this->m_models->getDataJoin("pegawai.*, sekolah.nama as nm_sekolah", "pegawai", "join sekolah on pegawai.id_sekolah=sekolah.id_sekolah where status_aktf ='Aktif' and (id_jabatan != '' or id_jabatan2 != '') order by pegawai.nama asc");
			}
		}

		$this->load->view('angket/angket_kepuasan_santri',$data);
		$this->load->view('template/js');
	}
	
	public function simpan_angket_kepuasan(){
		$hariini=date("Y-m-d");
		$no = $this->input->post('no', TRUE);
		$nrp = $this->input->post('nrp', TRUE);
		$kesan = $this->input->post('kesan', TRUE);
		$idpq = $this->input->post('id_pq', TRUE);
		for ($i=0; $i<=$no; $i++){
			$id_pq = $idpq[$i];
			$pilihan = $this->input->post('pilihan'.$id_pq, TRUE); 

			if ($id_pq != ""){
				if ($pilihan == ""){
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $kesan);
				} else {
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $pilihan);
				}
				if ($this->m_models->save_data($j_pq, 'peg_jawaban_angket') == TRUE){
					$this->session->set_flashdata('sukses', 'Terima kasih telah bersedia mengisi Angket !!!');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				
			}
		}



		//data favorit
		$nrp_input=$this->session->userdata['nrp']; 
		$id_siswa=$this->session->userdata['id_siswa']; 
		if ($nrp_input != ""){
			$user=$nrp_input;
		} else {
			$user=$id_siswa;
		}
		$no1 = $this->input->post('no1', TRUE);
		$idsaran = $this->input->post('id_saran', TRUE);
		if ($no1 != ""){
			for ($i=0; $i <= $no1; $i++) { 
				$id_saran=$idsaran[$i]; 
				$nrp_fav = $this->input->post('nrp'.$id_saran, TRUE); 
				if (($id_saran != "")&&($nrp_fav != "")){
					$j_fav= array('tgl'=>$hariini, 'nrp_input' => $user, 'id_saran' => $id_saran, 'nrp_fav' => $nrp_fav);
				}
				//$data[s_fav]=$this->m_models->save_data($j_fav, 'peg_favorit');
				if ($this->m_models->save_data($j_fav, 'peg_favorit') == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			}
		}
		redirect('angket_siswa');
	}


	//angket kepuasan untuk Orang Tua
	public function angket_kepuasan_ortu(){
		$this->load->view('template/head'); 
		$ar_angket=array('status =' => "on", 'kategori =' => 'Orang Tua');
		$data['pertanyaan_angket'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $ar_angket, "pertanyaan", "asc");

		$arraywhere=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arraywhere, "nama", "asc");

		$this->load->view('angket/angket_kepuasan_ortu',$data);
		$this->load->view('template/js');
	}

	public function simpan_angket_ortu(){
		$hariini=date("Y-m-d");
		$no = $this->input->post('no', TRUE);
		$nrp = $this->input->post('nrp', TRUE);
		$kesan = $this->input->post('kesan', TRUE);
		$idpq = $this->input->post('id_pq', TRUE); 
		for ($i=0; $i<=$no; $i++){
			$id_pq = $idpq[$i];
			$pilihan = $this->input->post('pilihan'.$id_pq, TRUE); 

			if ($id_pq != ""){
				if ($pilihan == ""){
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $kesan);
				} else {
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $pilihan);
				}
				if ($this->m_models->save_data($j_pq, 'peg_jawaban_angket') == TRUE){
					$this->session->set_flashdata('sukses', 'Terima kasih telah bersedia mengisi Angket !!!');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				
			}
		}
		redirect('angket_ortu');
	}


	//angket kepuasan untuk SDM
	public function angket_kepuasan_sdm(){
		$this->load->view('template/head'); 
		$ar_angket=array('status =' => "on", 'kategori =' => 'Pegawai');
		$data['pertanyaan_angket'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $ar_angket, "pertanyaan", "asc");

		$arraywhere=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arraywhere, "nama", "asc");

		$this->load->view('angket/angket_kepuasan_sdm',$data);
		$this->load->view('template/js');
	}

	public function simpan_angket_sdm(){
		$hariini=date("Y-m-d");
		$no = $this->input->post('no', TRUE);
		$nrp = $this->input->post('nrp', TRUE);
		$kesan = $this->input->post('kesan', TRUE);
		$idpq = $this->input->post('id_pq', TRUE); 
		for ($i=0; $i<=$no; $i++){
			$id_pq = $idpq[$i];
			$pilihan = $this->input->post('pilihan'.$id_pq, TRUE); 

			if ($id_pq != ""){
				if ($pilihan == ""){
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $kesan);
				} else {
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $pilihan);
				}
				if ($this->m_models->save_data($j_pq, 'peg_jawaban_angket') == TRUE){
					$this->session->set_flashdata('sukses', 'Terima kasih telah bersedia mengisi Angket !!!');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				
			}
		}
		redirect('angket_sdm');
	}

	//angket kepuasan untuk Pihak Luar
	public function angket_kepuasan_pihakluar(){
		$this->load->view('template/head'); 
		$ar_angket=array('status =' => "on", 'kategori =' => 'Pihak Luar');
		$data['pertanyaan_angket'] = $this->m_models->getTabelwhere("*", "peg_angket_pertanyaan", $ar_angket, "pertanyaan", "asc");

		$arraywhere=array('status_aktf =' => "Aktif");
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $arraywhere, "nama", "asc");

		$this->load->view('angket/angket_kepuasan_pihakluar',$data);
		$this->load->view('template/js');
	}

	public function simpan_angket_pihakluar(){
		$hariini=date("Y-m-d");
		$no = $this->input->post('no', TRUE);
		$nrp = $this->input->post('nrp', TRUE);
		$kesan = $this->input->post('kesan', TRUE);
		$idpq = $this->input->post('id_pq', TRUE); 
		for ($i=0; $i<=$no; $i++){
			$id_pq = $idpq[$i];
			$pilihan = $this->input->post('pilihan'.$id_pq, TRUE); 

			if ($id_pq != ""){
				if ($pilihan == ""){
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $kesan);
				} else {
					$j_pq = array('tgl'=>$hariini, 'nrp' => $nrp, 'id_p_angket' => $id_pq, 'jawaban' => $pilihan);
				}
				if ($this->m_models->save_data($j_pq, 'peg_jawaban_angket') == TRUE){
					$this->session->set_flashdata('sukses', 'Terima kasih telah bersedia mengisi Angket !!!');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				
			}
		}
		redirect('angket_pihakluar');
	}

	#angket kesediaan untuk pegawai akan melanjutkan bekerja atau tidak
	public function angket_kesediaan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['nrp']=$nrp;
		$data['nama']=$this->m_models->getSession($nrp, "nama_pegawai");
		$data['divisi']=$this->m_models->getSession($nrp, "nama_sekolah");

		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$id_jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$kesediaan = $this->input->post('kesediaan', TRUE);
		$alasan = $this->input->post('alasan', TRUE);
		$saran = $this->input->post('saran', TRUE);
		$hariini=date("Y-m-d");
		$waktu=date("H:i:s");
		$id_tahun=ta_berjalan();

		if (($nrp != "")&&($kesediaan != "")){
			if ($kesediaan=="Melanjutkan"){
				$j_pq = array('nrp'=>$nrp, 'id_sekolah' => $id_sekolah, 'id_jabatan' => $id_jabatan, 'kesediaan' => $kesediaan, 'saran_masukan'=>$saran, 'tgl_input'=>$hariini, 'waktu_input'=>$waktu, 'id_tahun'=>$id_tahun);
			} else if ($kesediaan=="Tidak Melanjutkan"){
				$j_pq = array('nrp'=>$nrp, 'id_sekolah' => $id_sekolah, 'id_jabatan' => $id_jabatan, 'kesediaan' => $kesediaan, 'alasan'=>$alasan, 'tgl_input'=>$hariini, 'waktu_input'=>$waktu, 'id_tahun'=>$id_tahun);
			}

			#mengecek data sudah di input atau tidak
			$arraywhere=array('nrp'=>$nrp, 'id_tahun'=>$id_tahun);
			$jangket = $this->m_models->getRowsAWhere("*", "peg_angket_kesediaan", $arraywhere, "id_sekolah", "asc");
			if ($jangket==0){
				if ($this->m_models->save_data($j_pq, 'peg_angket_kesediaan') == TRUE){
					$this->session->set_flashdata('sukses', 'Terima kasih telah bersedia mengisi Angket !!!');
				} else {
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
			} else {
				$this->session->set_flashdata('gagal', 'Maaf. Data sudah ada.');
			}

			redirect('angket/angket_kesediaan');
		}

		$this->load->view('angket/angket_kesediaan',$data);
		$this->load->view('template/footer');
	}

	public function ceksedia(){
		$data['kesediaan'] = $this->input->get('kesediaan', TRUE);

		$this->load->view('angket/cekkesediaan',$data);
	}

	
	public function dt_angket_kesediaan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=ta_berjalan();

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$data['dari']=$dari;
		$data['sampai']=$sampai;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('tgl_input >=' => $dari, 'tgl_input <='=>$sampai);
			$data['angket_kesediaan'] = $this->m_models->getTabelwhere("*", "peg_angket_kesediaan", $arraywhere, "id_sekolah", "asc");
		}
		$this->load->view('angket/resume_angket_kesediaan',$data);
		$this->load->view('template/footer');
	}

	public function cetak_resume_angket_kesediaan(){
		$nrp=$this->session->userdata['nrp'];
		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=ta_berjalan();

		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$data['dari']=$dari;
		$data['sampai']=$sampai;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('tgl_input >=' => $dari, 'tgl_input <='=>$sampai);
			$data['angket_kesediaan'] = $this->m_models->getTabelwhere("*", "peg_angket_kesediaan", $arraywhere, "id_sekolah", "asc");
		}
		$this->load->view('angket/cetak_resume_angket_kesediaan',$data);
	}

	
	public function download_surat_kesediaan(){
		$id = $this->uri->segment(3);
		
		$ar_ajuan = array('id_a_kesediaan' => $id);
		$data['angket']=$this->m_models->getTabelwhere("*", "peg_angket_kesediaan", $ar_ajuan, "id_sekolah", "asc");

		$this->load->view('angket/download_surat_kesediaan',$data);
	}


}