<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Akun extends CI_Controller {
	function __construct() {
		error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}


	public function point_akun(){
		$this->load->view('template/header');

		$id_pa = $this->input->post('id_pa', TRUE);
		$nama_pa = $this->input->post('nama_pa', TRUE);
		$id_pakun = $this->input->post('id_pakun', TRUE);
		$id="$id_pa$id_pakun";
		if (($id_pa != "")&&($nama_pa != "")){
			$a_pa= array('id_point'=>$id, 'nama_point' => $nama_pa);
			if ($this->m_models->save_data($a_pa, 'point_akun') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/point_akun');
		}

        $data['point_akun'] = $this->m_models->getTabelOrder("*", "point_akun", "id_point", "asc");
		$this->load->view('akun/point_akun',$data);
		$this->load->view('template/footer');
	}

	public function delete_point_akun(){
		$id_point = $this->uri->segment(3);
		if ($id_point != ""){
			if ($this->m_models->delete_data($id_point, "id_point", "point_akun") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/point_akun');
		}
	}

	public function sub_point_akun(){
		$this->load->view('template/header');
        $data['point_akun'] = $this->m_models->getTabelOrder("*", "point_akun", "id_point", "asc");
        

		$point_akun = $this->input->post('point_akun', TRUE);
		$id_pa = $this->input->post('id_pa', TRUE);
		$id_sa = $this->input->post('id_sa', TRUE);
		$id_sakun = $this->input->post('id_sakun', TRUE);
		$nama_sa = $this->input->post('nama_sa', TRUE);
		$id="$id_pa$id_sa$id_sakun";
		if (($id_sa != "")&&($nama_sa != "")){
			$a_sa= array('id_point'=>$point_akun, 'id_subpoint_akun' => $id, 'nama_subpoint_akun'=>$nama_sa);
			if ($this->m_models->save_data($a_sa, 'subpoint_akun') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/sub_point_akun');
		}

        $data['sub_point_akun'] = $this->m_models->getTabelOrder("*", "subpoint_akun", "id_subpoint_akun", "asc");
		$this->load->view('akun/sub_point_akun',$data);
		$this->load->view('template/footer');
	}

	public function cekpointakun(){
		$point_akun = $this->input->get('point_akun', TRUE);
		$ex=explode(".", $point_akun);
		$data['id_point']=$ex[0];
		$this->load->view('akun/cekpointakun',$data);
	}

	public function delete_sub_point_akun(){
		$id_subpoint_akun = $this->uri->segment(3);
		if ($id_subpoint_akun != ""){
			if ($this->m_models->delete_data($id_subpoint_akun, "id_subpoint_akun", "subpoint_akun") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/sub_point_akun');
		}
	}

	public function sub_akun(){
		$this->load->view('template/header');
        $data['sub_point_akun'] = $this->m_models->getTabelOrder("*", "subpoint_akun", "id_subpoint_akun", "asc");
        

		$sub_point_akun = $this->input->post('sub_point_akun', TRUE);
		$id_spa = $this->input->post('id_spa', TRUE);
		$id_sa = $this->input->post('id_sa', TRUE);
		$nama_sa = $this->input->post('nama_sa', TRUE);
		$id="$id_spa$id_sa";
		if (($id_sa != "")&&($nama_sa != "")){
			$a_sa= array('id_point'=>$sub_point_akun, 'id_sub_akun' => $id, 'nama_sub_akun'=>$nama_sa);
			if ($this->m_models->save_data($a_sa, 'sub_akun') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/sub_akun');
		}

        $data['sub_akun'] = $this->m_models->getTabelOrder("*", "sub_akun", "id_sub_akun", "asc");
		$this->load->view('akun/sub_akun',$data);
		$this->load->view('template/footer');
	}

	public function ceksubpointakun(){
		$sub_point_akun = $this->input->get('sub_point_akun', TRUE);
		$ex=explode(".", $sub_point_akun);
		$data['id_subpoint_akun']="$ex[0].$ex[1]";
		$this->load->view('akun/ceksubpointakun',$data);
	}

	
	public function delete_sub_akun(){
		$id_sub_akun = $this->uri->segment(3);
		if ($id_sub_akun != ""){
			if ($this->m_models->delete_data($id_sub_akun, "id_sub_akun", "sub_akun") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/sub_akun');
		}
	}

	public function rules_akun(){
		$this->load->view('template/header');
        $data['sub_akun'] = $this->m_models->getTabelOrder("*", "sub_akun", "id_sub_akun", "asc");
        

		$sub_akun = $this->input->post('sub_akun', TRUE);
		$debet = $this->input->post('debet', TRUE);
		$kredit = $this->input->post('kredit', TRUE);
		$posisi = $this->input->post('posisi', TRUE);
		$id_sa = $this->input->post('id_sa', TRUE);
		$id_a = $this->input->post('id_a', TRUE);
		$nama_a = $this->input->post('nama_a', TRUE);
		$id="$id_sa$id_a";
		if (($id_a != "")&&($nama_a != "")){
			$a_ra= array('id_akun'=>$id, 'debet' => $debet, 'kredit'=>$debet, 'normal'=>$posisi);
			$rulusakun=$this->m_models->save_data($a_ra, 'rules_akun');

			$a_a= array('id_sub_akun'=>$sub_akun, 'id_akun' => $id, 'nama_akun'=>$nama_a);
			if ($this->m_models->save_data($a_a, 'akun') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/rules_akun');
		}

        $data['rules_akun'] = $this->m_models->getJoin1("*", "akun", "rules_akun", "rules_akun.id_akun=akun.id_akun", "akun.id_akun", "asc");
		$this->load->view('akun/rules_akun',$data);
		$this->load->view('template/footer');
	}

	public function ceksubakun(){
		$data['sub_akun'] = $this->input->get('sub_akun', TRUE);
		$this->load->view('akun/ceksubakun',$data);
	}

	public function delete_akun(){
		$id_akun = $this->uri->segment(3);
		if ($id_akun != ""){
			$del_akun=$this->m_models->delete_data($id_akun, "id_akun", "rules_akun");
			if ($this->m_models->delete_data($id_akun, "id_akun", "akun") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/rules_akun');
		}
	}


	public function batasan_akun(){
		$this->load->view('template/header');
		$data['akun'] = $this->m_models->getJoin1("*", "akun", "rules_akun", "rules_akun.id_akun=akun.id_akun", "akun.id_akun", "asc");
        $data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", "on", "nama", "asc");
        $jdiv = $this->m_models->getRowsWhere("*", "sekolah", "status_aktif", "on", "nama", "asc");

		$akun = $this->input->post('akun', TRUE);
		$id_sekolah = $this->input->post('id_sekolah', TRUE);
		if ($akun != ""){
			for ($i=0; $i <= $jdiv; $i++) { 
				$idsekolah=$id_sekolah[$i];
				if (($idsekolah != "")&&($akun != "")){
					$a_pa= array('id_akun'=>$akun, 'id_sekolah' => $idsekolah, 'status'=>'on');
					if ($this->m_models->save_data($a_pa, 'pilihan_akun') == TRUE){
						$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
					}else{
						$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
					}
				}
			}
			redirect('akun/batasan_akun');
		}
			

        $data['pilihan_akun'] = $this->m_models->getTabelOrder("*", "pilihan_akun", "id_akun", "asc");
        
		$this->load->view('akun/batasan_akun',$data);
		$this->load->view('template/footer');
	}

	public function update_batasan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_akun = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_akun != ""){
			$j_off= array('status'=>$status);
			if ($this->m_models->update_data($id_akun, "id_akun", $j_off, "pilihan_akun") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('akun/batasan_akun');
		}
		$this->load->view('template/footer');
	}
	
}