<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Absensi extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
		$this->load->model('absensi_models');
	}
	
	
	//fungsi menampilkan data absensi
	public function data_absensi(){
		$this->load->view('template/header');

		$nrp = $this->input->post('nrp', TRUE);
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);

		$arraywhere = array('date >= ' => $tgl_dari, 'date <= ' => $tgl_sampai);
		if ($tgl_dari!= null AND $tgl_sampai != null) {
			if ($nrp != 'semua_pegawai') {
				$arraywhere['absensi.user_id'] = $nrp; 
				$data['log_absen'] = $this->m_models->getJoin1where('absensi.*, pegawai.nama', 'absensi', 'pegawai', 'absensi.user_id=pegawai.nrp', $arraywhere, 'date', 'ASC');
			}else{
				$data['log_absen'] = $this->m_models->getJoin1where('absensi.*, pegawai.nama', 'absensi', 'pegawai', 'absensi.user_id=pegawai.nrp', $arraywhere, 'date', 'ASC');
			}
		}

		$data['pegawai'] = $this->m_models->get_data("nrp, nama", "pegawai ORDER BY nama ASC","");
		
		$this->load->view('absensi/log_absensi', $data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function import_absensi(){
		$this->load->view('template/header');

		$this->load->view('absensi/import_absensi');

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

 	public function rekap_absensi(){
 		$this->load->view('template/header');
 		$this->load->helper('absen');

 		$sekolah  = $this->input->post('sekolah', TRUE);
		$bulan  = $this->input->post('bln', TRUE);
        $tahun  = $this->input->post('thn', TRUE);
        $thnbln = $tahun.'-'.$bulan;

        $data['sekolah_pilih'] = $sekolah;
        $data['bln_pilih'] = $bulan;
        $data['thn_pilih'] = $tahun;

        $jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;
        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"date like '$thnbln%'");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			# membuat array nrp
			$hadir[] =  $nrp;
			# cek waktu masuk
			$menit_telat_masuk = cek_telat_masuk(get_standar_jam_masuk($key->date), $key->time_in);
		//cho $menit_telat_masuk."<br>";
			if ($menit_telat_masuk != 0) {
				# membuat array waktu menit terlambat dengan nrp dan waktu
				$menit_terlambat[$nrp][] = $menit_telat_masuk;
				# membuat array hari telat masuk dengan menyimpan nrp
				$waktu_terlambat[] =  $nrp;
			}

			# cek waktu pulang
			$menit_pulang_cepat = cek_pulang_cepat(get_standar_jam_pulang($key->date), $key->time_out);
			//	echo $menit_pulang_cepat."<br>";
			if ($menit_pulang_cepat != 0) {
				# membuat array waktu menit pulang cepat dengan nrp dan waktu
				$menit_pc[$nrp][] = $menit_pulang_cepat;
				# membuat array hari pulang cepat dengan menyimpan nrp
				$waktu_pc[] =  $nrp;
			}

		}
		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		$terlambat_waktu = array_count_values($waktu_terlambat);
		$pc_waktu = array_count_values($waktu_pc);

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_terlambat);

		foreach ($arr_nrp as $key => $value) {
			$jml_terlambat_waktu = 0;
			for ($i=0; $i < $terlambat_waktu[$value]; $i++) { 
				$jml_terlambat_waktu += $menit_terlambat[$value][$i];
			}
			$terlambat_menit[$value] = $jml_terlambat_waktu;
		}

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_pc);

		foreach ($arr_nrp as $key => $value) {
			$jml_pc_waktu = 0;
			for ($i=0; $i < $pc_waktu[$value]; $i++) { 
				$jml_pc_waktu += $menit_pc[$value][$i];
			}
			$pc_menit[$value] = $jml_pc_waktu;
		}
		
		if ($sekolah == 'semua_sekolah') {
			//$data['pegawai'] = $this->m_models->get_data('nrp, nama','pegawai order by nama ASC');
			$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai", "WHERE status_aktf='Aktif' order by nama ASC");
		}else{
			$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai", "WHERE id_sekolah='$sekolah' and status_aktf='Aktif' order by nama ASC");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['waktu_terlambat'][] = $terlambat_waktu[$key->nrp];
			$arr_rekap['menit_terlambat'][] = $terlambat_menit[$key->nrp];
			$arr_rekap['waktu_pc'][] = $pc_waktu[$key->nrp];
			$arr_rekap['menit_pc'][] = $pc_menit[$key->nrp];	
			$arr_rekap['setandar_hadir'][] = $setandar_hadir;
			$arr_rekap['hadir'][] = $kehadiran[$key->nrp];	
			$arr_rekap['tidak'][] = $setandar_hadir - $kehadiran[$key->nrp];	
		}

		if (isset($bulan) AND isset($tahun)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}

		$data['sekolah'] = $this->m_models->getwhere("id_sekolah, nama", "sekolah", "status_aktif", 'on', "nama", "asc");

		$this->load->view('absensi/rekap_absensi', $data); 

		$this->load->view('template/footer');
	} 


	public function input_absensi(){
		$this->load->view('template/header');
	
		$data['karyawan']=$this->m_models->getAll('pegawai order by nama asc');
		$this->load->view('absensi/input_absensi', $data);

		$data['log_absen'] = $this->absensi_models->get_absensi_limit();
		$this->load->view('absensi/data_input_absensi', $data);

		$this->load->view('template/footer');		
	}

	public function cekabsensi(){
		$data['absensi']=$this->input->get('absensi', TRUE); 
		$this->load->view('absensi/cekabsensi', $data);
	}

	public function save_input_absensi(){
		$this->load->view('template/header');

		$id = '';
        $nrp  = $this->input->post('nrp', TRUE);
        $tanggal  = $this->input->post('tgl_absen', TRUE);
        $jam_masuk  = $this->input->post('jam_masuk', TRUE);
        $jam_pulang  = $this->input->post('jam_pulang', TRUE);
        $absensi = $this->input->post('absensi', TRUE);
        $ket = $this->input->post('ket', TRUE);

        $tanggal = date_db($tanggal);
        $jam_masuk = time_db($jam_masuk);
        $jam_pulang = time_db($jam_pulang);

        $jumlah_data = $this->m_models->getRows("absensi WHERE user_id='$nrp' AND date='$tanggal'");

        if ($jumlah_data == 0) {
        	if ($ket != ""){
        		$data = array (
        			'absensi_id' => $id,
        			'user_id'  => $nrp,
        			'date'  => $tanggal,
        			'time_in'  => $jam_masuk,
        			'time_out'=> $jam_pulang,
        			'absensi'=> $absensi,
        			'keterangan'=>$ket
        		);
        	} else {
        		$data = array (
        			'absensi_id' => $id,
        			'user_id'  => $nrp,
        			'date'  => $tanggal,
        			'time_in'  => $jam_masuk,
        			'time_out'=> $jam_pulang,
        			'absensi'=> $absensi
        		);
        	}
	        
	    	//;
	    	if($this->m_models->save_data($data,"absensi") == TRUE){
	    		$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    	}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
        }else{
        	$this->session->set_flashdata('sudah_ada', 'Data sudah ada di database, Silahkan edit data jika ada perubahan !!!');
        }

      	redirect('absensi/input_absensi');	
	}

	function edit_log(){
		$this->load->view('template/header');

        $id  = $this->input->post('absensi_id', TRUE);
        $tanggal  = $this->input->post('tanggal', TRUE);
        $jam_masuk  = $this->input->post('jam_masuk', TRUE);
        $jam_pulang  = $this->input->post('jam_pulang', TRUE);
        $ket  = $this->input->post('ket', TRUE);
        if ($ket==""){
        	$data = array (
        		'absensi_id' => $id,
        		'date'  => $tanggal,
        		'time_in'  => $jam_masuk,
        		'time_out'=> $jam_pulang
        	);
        } else {
        	$data = array (
        		'absensi_id' => $id,
        		'date'  => $tanggal,
        		'time_in'  => $jam_masuk,
        		'time_out'=> $jam_pulang,
        		'keterangan'=> $ket
        	);
        }
	    

	    if($this->m_models->update_data($id, 'absensi_id', $data, "absensi") == TRUE){
	    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    }

      	redirect('absensi/data_absensi');			
	}

	function hapus_log(){
		$absensi_id = $this->input->post('absensi_id', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($absensi_id, 'absensi_id', 'absensi') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('absensi/data_absensi');
	}

	public function set_in_out(){
		$this->load->view('template/header');
	
		$this->load->view('absensi/input_in_out');

		$data['in_out'] = $this->m_models->getAll('in_out_absen order by tgl_awal asc');
		$this->load->view('absensi/data_in_out', $data);

		$this->load->view('template/footer');		
	}

	public function save_input_in_out(){
		$this->load->view('template/header');

        $tgl_aktif  = $this->input->post('tgl_aktif', TRUE);
        $jam_masuk  = $this->input->post('jam_masuk', TRUE);
        $jam_pulang  = $this->input->post('jam_pulang', TRUE);

        $exp = explode('-', $tgl_aktif);
        $tgl_awal = str_replace(' ', '', date_db($exp[0]));
        $tgl_akhir = str_replace(' ', '', date_db($exp[1]));
        $jam_masuk = time_db($jam_masuk);
        $jam_pulang = time_db($jam_pulang);

        $jumlah_data = $this->m_models->getRows("in_out_absen WHERE tgl_akhir>='$tgl_awal'");

        if ($jumlah_data == 0) {
	        $data = array (
	            'id' => '',
	            'jam_masuk'  => $jam_masuk,
	            'jam_pulang'  => $jam_pulang,
	            'tgl_awal'  => $tgl_awal,
	            'tgl_akhir'=> $tgl_akhir
	        );
	       
	    	if($this->m_models->save_data($data,"in_out_absen") == TRUE){
	    		$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    	}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	} 
        }else{
        	$this->session->set_flashdata('sudah_ada', 'Tanggal aktif yang dimasukan sudah di set !!!');
        }

      	redirect('absensi/set_in_out');	
	}

	public function update_in_out($id){
		$this->load->view('template/header');
	
		$data['edit_in_out']=$this->m_models->getDataByID('in_out_absen','id', $id);
		$this->load->view('absensi/update_in_out', $data);

		$data['in_out'] = $this->m_models->getAll('in_out_absen order by tgl_awal asc');
		$this->load->view('absensi/data_in_out', $data);

		$this->load->view('template/footer');		
	}

	public function save_update_in_out(){
		$this->load->view('template/header');
		$id  = $this->input->post('id', TRUE);
        $tgl_awal  = date_db($this->input->post('tgl_awal', TRUE));
		$tgl_akhir  = date_db($this->input->post('tgl_akhir', TRUE));
        $jam_masuk  = $this->input->post('jam_masuk', TRUE);
        $jam_pulang  = $this->input->post('jam_pulang', TRUE);

        $jam_masuk = time_db($jam_masuk);
        $jam_pulang = time_db($jam_pulang);

        $data=array('jam_masuk ' => $jam_masuk, 'jam_pulang' => $jam_pulang, 'tgl_awal' => $tgl_awal, 'tgl_akhir' => $tgl_akhir);

        if ($this->m_models->update_data($id, 'id', $data, "in_out_absen") == TRUE) {
        	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
        }else{
        	$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
        }

        redirect('absensi/set_in_out');	
	}

	public function download_berkas($nm_file, $tipe_file){
		$this->load->view('template/header');
		$this->load->helper('download');
		
		force_download('assets/upload/'.$nm_file.'.'.$tipe_file, NULL);
	}

	function export_excel($bln, $thn, $sekolah){
	//	$this->load->view('template/head');
 		$this->load->helper('absen');
 		$this->load->helper('tgl_indo');

		$bulan  = $bln;
        $tahun  = $thn;
        $thnbln = $tahun.'-'.$bulan;

        $data['bulan_pilih'] = bulan((int) $bulan);
        $data['tahun_pilih'] = $tahun;

        if ($sekolah == 'semua_sekolah') {
        	$data['sekolah_pilih'] = 'SDM Al-Multazam';
        }else{
        	$d_sekolah = $this->m_models->get_data("nama", "sekolah", "where id_sekolah='$sekolah'");
        	$data['sekolah_pilih'] = $d_sekolah[0]->nama;
        }

        $jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;
        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"date like '$thnbln%'");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			# membuat array nrp
			$hadir[] =  $nrp;
			# cek waktu masuk
			$menit_telat_masuk = cek_telat_masuk(get_standar_jam_masuk($key->date), $key->time_in);
		//cho $menit_telat_masuk."<br>";
			if ($menit_telat_masuk != 0) {
				# membuat array waktu menit terlambat dengan nrp dan waktu
				$menit_terlambat[$nrp][] = $menit_telat_masuk;
				# membuat array hari telat masuk dengan menyimpan nrp
				$waktu_terlambat[] =  $nrp;
			}




			# cek waktu pulang
			$menit_pulang_cepat = cek_pulang_cepat(get_standar_jam_pulang($key->date), $key->time_out);
			//	echo $menit_pulang_cepat."<br>";
			if ($menit_pulang_cepat != 0) {
				# membuat array waktu menit pulang cepat dengan nrp dan waktu
				$menit_pc[$nrp][] = $menit_pulang_cepat;
				# membuat array hari pulang cepat dengan menyimpan nrp
				$waktu_pc[] =  $nrp;
			}

		}
		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		$terlambat_waktu = array_count_values($waktu_terlambat);
		$pc_waktu = array_count_values($waktu_pc);

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_terlambat);

		foreach ($arr_nrp as $key => $value) {
			$jml_terlambat_waktu = 0;
			for ($i=0; $i < $terlambat_waktu[$value]; $i++) { 
				$jml_terlambat_waktu += $menit_terlambat[$value][$i];
			}
			$terlambat_menit[$value] = $jml_terlambat_waktu;
		}

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_pc);

		foreach ($arr_nrp as $key => $value) {
			$jml_pc_waktu = 0;
			for ($i=0; $i < $pc_waktu[$value]; $i++) { 
				$jml_pc_waktu += $menit_pc[$value][$i];
			}
			$pc_menit[$value] = $jml_pc_waktu;
		}
	
		if ($sekolah == 'semua_sekolah') {
			//$data['pegawai'] = $this->m_models->get_data('nrp, nama','pegawai order by nama ASC');
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama ASC");
		}else{
			$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai", "WHERE id_sekolah='$sekolah' and status_aktf='Aktif' order by nama ASC");
		}

		foreach ($data['pegawai'] as $key) {
			#ambil nilai dari data array yang sudah dicari
			if (in_array($key->nrp, $waktu_terlambat)) {
				$waktu_telat = $terlambat_waktu[$key->nrp];
			}else{
				$waktu_telat = 0;
			}

			if (in_array($key->nrp, $waktu_terlambat)) {
				$menit_telat = $terlambat_menit[$key->nrp];
			}else{
				$menit_telat = 0;
			}

			if (in_array($key->nrp, $waktu_pc)) {
				$waktu_pc1 = $pc_waktu[$key->nrp];
			}else{
				$waktu_pc1 = 0;
			}

			if (in_array($key->nrp, $waktu_pc)) {
				$menit_pc1 = $pc_menit[$key->nrp];
			}else{
				$menit_pc1 = 0;
			}			

			if (in_array($key->nrp, $hadir)) {
				$hadir1 = $kehadiran[$key->nrp];
			}else{
				$hadir1 = 0;
			}
			# masukan data
			$arr_rekap['nrp'][] = $key->nrp;
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['waktu_terlambat'][] = $waktu_telat;
			$arr_rekap['menit_terlambat'][] = $menit_telat;
			$arr_rekap['waktu_pc'][] = $waktu_pc1;
			$arr_rekap['menit_pc'][] = $menit_pc1;	
			$arr_rekap['setandar_hadir'][] = $setandar_hadir;
			$arr_rekap['hadir'][] = $hadir1;	
			$arr_rekap['tidak'][] = $setandar_hadir - $hadir1;	
		}

		$data['rekap'] = $arr_rekap;
		$data['jml_pegawai'] = count($data['pegawai']);

		$this->load->view('absensi/laporan_excel', $data);	
	}

	function laporan_absensi(){
		$this->load->view('absensi/v_laporan_absensi');
	}

	
	public function rekapitulasi_absensi(){
 		/*$this->load->view('template/header');
 		$this->load->helper('absen');

		$data['divisi'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");

		$bulan  = $this->input->post('bln', TRUE);
        $tahun  = $this->input->post('thn', TRUE);
        $jenjang  = $this->input->post('jenjang', TRUE);
        $thnbln = $tahun.'-'.$bulan;

        $data['bln_pilih'] = $bulan;
        $data['thn_pilih'] = $tahun;
        $data['jenjang'] = $jenjang;

        $jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;
        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"date like '$thnbln%'");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			# membuat array nrp
			$hadir[] =  $nrp;
		}
		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		if ($jenjang=="all"){
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama ASC");
		} else {
			$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai where id_sekolah='$jenjang' and status_aktf='Aktif' order by nama ASC");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['hadir'][] = $kehadiran[$key->nrp];		
		}

		if (isset($bulan) AND isset($tahun)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}

		$this->load->view('absensi/rekapitulasi_absensi', $data); 

		$this->load->view('template/footer');*/



		$this->load->view('template/header');
 		$this->load->helper('absen');

 		$sekolah  = $this->input->post('sekolah', TRUE);
		//$bulan  = $this->input->post('bln', TRUE);
        //$tahun  = $this->input->post('thn', TRUE);
        //$thnbln = $tahun.'-'.$bulan;
		
		$dari  = $this->input->post('dari');
		$dari2  = $this->input->post('dari');
		$sampai  = $this->input->post('sampai');

        $data['sekolah_pilih'] = $sekolah;
        $data['bln_pilih'] = $bulan;
        $data['thn_pilih'] = $tahun;

		//$total_hari = $sampai - $sampai;
		//echo $total_hari;
		
        //$jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_bulan = ((abs(strtotime ($sampai) - strtotime ($dari)))/(60*60*24))+1;
       // $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
	   
	   $hari_min=0;
	    while (strtotime($dari2) <= strtotime($sampai)) {
			$datte=$dari2;
			$tgll=explode("-",$datte);
			$hari=date("l", mktime(0, 0, 0, $tgll[1], $tgll[2], $tgll[0])); 
			if($hari=="Sunday"){
				$hari_min++;
			}
			$dari2 = date ("Y-m-d", strtotime("+1 day", strtotime($dari2)));
		}
		$jml_hari_minggu = intval($hari_min);
		
	   
	   
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;
        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"absensi='H' and (date >= '$dari' and date <= '$sampai') ");
	//	$data['log'] = $this->m_models->getAll("absensi where absensi='H' and date between '$dari' and '$sampai' ");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			  
			
			# membuat array nrp
			$hadir[] =  $nrp;
			# cek waktu masuk
			$menit_telat_masuk = cek_telat_masuk(get_standar_jam_masuk($key->date), $key->time_in);
		//cho $menit_telat_masuk."<br>";
			if ($menit_telat_masuk != 0) {
				# membuat array waktu menit terlambat dengan nrp dan waktu
				$menit_terlambat[$nrp][] = $menit_telat_masuk; 
				# membuat array hari telat masuk dengan menyimpan nrp
				$waktu_terlambat[] =  $nrp;
			}

			# cek waktu pulang
			$menit_pulang_cepat = cek_pulang_cepat(get_standar_jam_pulang($key->date), $key->time_out);
			//	echo $menit_pulang_cepat."<br>";
			if ($menit_pulang_cepat != 0) {
				# membuat array waktu menit pulang cepat dengan nrp dan waktu
				$menit_pc[$nrp][] = $menit_pulang_cepat;
				# membuat array hari pulang cepat dengan menyimpan nrp
				$waktu_pc[] =  $nrp;
			}

		}




		// Jika Sakit
		$data['logsk'] = $this->m_models->getSpesific('absensi',"absensi='S' and (date >= '$dari' and date <= '$sampai') ");
		foreach ($data['logsk'] as $key1) {
			$nrp1 = $key1->user_id;
			# membuat array nrp
			$skt[] =  $nrp1;
		}

		// Jika Izin
		$data['logiz'] = $this->m_models->getSpesific('absensi',"absensi='I' and (date >= '$dari' and date <= '$sampai') ");
		foreach ($data['logiz'] as $key2) {
			$nrp2 = $key2->user_id;
			# membuat array nrp
			$izn[] =  $nrp2;
		}

		// Jika Cuti
		//$data['logcuti'] = $this->m_models->getSpesific("peg_cuti"," tanggal_mulai >= '$dari' and tanggal_selesai <= '$sampai'");
		//$data['logcuti'] = $this->m_models->getAll("peg_cuti join pegawai on peg_cuti.nrp = pegawai.nrp where tgl_mulai <='$tanggal' and tgl_selesai >= '$tanggal'");



		// Menghitun Hari yang Belum di Lalui
		//$hari_sudah = $this->m_models->getRows("absensi where date >= '$dari' and date <= '$sampai' group by date");
		/*$tahun = date('Y'); //Mengambil tahun saat ini
        $bulan = date('m'); //Mengambil bulan saat ini
        $hari_sudah = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);*/


        $hari_sudah = (((abs(strtotime ($sampai) - strtotime ($dari)))/(60*60*24))+1);


 	



		
		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		$sakit = array_count_values($skt);
		$izin = array_count_values($izn);
		$terlambat_waktu = array_count_values($waktu_terlambat);
		$pc_waktu = array_count_values($waktu_pc);

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_terlambat);

		foreach ($arr_nrp as $key => $value) {
			$jml_terlambat_waktu = 0;
			for ($i=0; $i < $terlambat_waktu[$value]; $i++) { 
				$jml_terlambat_waktu += $menit_terlambat[$value][$i];
			}
			$terlambat_menit[$value] = $jml_terlambat_waktu;
		}

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_pc);

		foreach ($arr_nrp as $key => $value) {
			$jml_pc_waktu = 0;
			for ($i=0; $i < $pc_waktu[$value]; $i++) { 
				$jml_pc_waktu += $menit_pc[$value][$i];
			}
			$pc_menit[$value] = $jml_pc_waktu;
		}
		
		if ($sekolah == 'semua_sekolah') {
			$data['pegawai'] = $this->m_models->get_data('nrp, nama,id_jabatan','pegawai order by nama ASC','');
		}else{
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama, id_jabatan","pegawai", "WHERE id_sekolah='$sekolah' order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai where pegawai.id_sekolah='$sekolah' and status_aktf='Aktif' order by nama asc");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			
			//Menampilkan Jabatan
			$jab = all("jabatan","id_jabatan",$key->id_jabatan,"nama_jabatan");
			
			//echo $jab;
			$arr_rekap['jabatan'][] = $jab;
			
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['waktu_terlambat'][] = $terlambat_waktu[$key->nrp];
			$arr_rekap['menit_terlambat'][] = $terlambat_menit[$key->nrp];
			$arr_rekap['waktu_pc'][] = $pc_waktu[$key->nrp];
			$arr_rekap['menit_pc'][] = $pc_menit[$key->nrp];	
			$arr_rekap['setandar_hadir'][] = $setandar_hadir;
			$arr_rekap['hadir'][] = $kehadiran[$key->nrp];	
			$arr_rekap['sakit'][] = $sakit[$key->nrp];	 
			$arr_rekap['izin'][] = $izin[$key->nrp];
			//$arr_rekap['alpa'][] = ($setandar_hadir - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			//$arr_rekap['alpa'][] = ($hari_sudah - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			$arr_rekap['alpa'][] = (($hari_sudah - $jml_hari_minggu)  - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]); 
			//$arr_rekap['tidak'][] = $setandar_hadir - $kehadiran[$key->nrp];	
			$arr_rekap['tidak'][] =  (($hari_sudah - $jml_hari_minggu)  - $kehadiran[$key->nrp]);	

			


			// Prosesntase
			$arr_rekap['prosen'][] = ($kehadiran[$key->nrp] / $setandar_hadir) * 100;
		}

		if (isset($dari) AND isset($sampai)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}

		//$data['sekolah'] = $this->m_models->getwhere("id_sekolah, nama", "sekolah", "status_aktif", 'on', "nama", "asc");
		
		$ar = $this->session->userdata['nrp'];
        $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		
		$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   $data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");

	   if (($idsekolah=="8") or ($idsekolah=="13")){
	    	$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   		$data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");
		}

		$this->load->view('absensi/rekapitulasi_absensi', $data); 

		$this->load->view('template/footer');





	} 

	function download_rekapitulasiabs($bln, $thn){
 		error_reporting(0);
 		$this->load->helper('absen');

		$bulan = $this->uri->segment(3);
		$tahun = $this->uri->segment(4);
		$jenjang = $this->uri->segment(5);
        $thnbln = $tahun.'-'.$bulan;
        

		$data['bln_pilih'] = $bulan;
        $data['thn_pilih'] = $tahun;
        $data['jenjang'] = $jenjang;

        $jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;
        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"date like '$thnbln%'");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			# membuat array nrp
			$hadir[] =  $nrp;
		}
		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		if ($jenjang=="all"){
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai", "order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama ASC");
		} else {
			$data['pegawai'] = $this->m_models->get_data("nrp, nama","pegawai where id_sekolah='$jenjang' and status_aktf='Aktif' order by nama ASC","");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			$arr_rekap['nama'][] = $key->nama; 
			if ($kehadiran[$key->nrp]!=0){
				$arr_rekap['hadir'][] = $kehadiran[$key->nrp];
			} else {
				$arr_rekap['hadir'][] = 0;
			}
					
		}

		if (isset($bulan) AND isset($tahun)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}

		$this->load->view('absensi/rekapitulasiabsen_excel', $data);	
	}


	// Function Download di HRD
	public function export_excel_rekapitulasi_absensi(){
 		$this->load->helper('absen');

 		//$sekolah  = $this->input->post('sekolah', TRUE);
		//$bulan  = $this->input->post('bln', TRUE);
        //$tahun  = $this->input->post('thn', TRUE);
        //$thnbln = $tahun.'-'.$bulan;
		
		$dari  = $this->uri->segment(3);
		$dari2  = $this->uri->segment(3);
		$sampai  = $this->uri->segment(4);
		$sekolah  = $this->uri->segment(5, TRUE);

        $data['sekolah_pilih'] = $sekolah;
        

		//$total_hari = $sampai - $sampai;
		//echo $total_hari;
		
        //$jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_bulan = ((abs(strtotime ($sampai) - strtotime ($dari)))/(60*60*24))+1;
       // $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
	   
	   $hari_min=0;
	    while (strtotime($dari2) <= strtotime($sampai)) {
			$datte=$dari2;
			$tgll=explode("-",$datte);
			$hari=date("l", mktime(0, 0, 0, $tgll[1], $tgll[2], $tgll[0])); 
			if($hari=="Sunday"){
				$hari_min++;
			}
			$dari2 = date ("Y-m-d", strtotime("+1 day", strtotime($dari2)));
		}
		$jml_hari_minggu = intval($hari_min);
		
	   
	   
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;
        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"absensi='H' and (date >= '$dari' and date <= '$sampai') ");
	//	$data['log'] = $this->m_models->getAll("absensi where absensi='H' and date between '$dari' and '$sampai' ");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			  
			
			# membuat array nrp
			$hadir[] =  $nrp;
			# cek waktu masuk
			$menit_telat_masuk = cek_telat_masuk(get_standar_jam_masuk($key->date), $key->time_in);
		//cho $menit_telat_masuk."<br>";
			if ($menit_telat_masuk != 0) {
				# membuat array waktu menit terlambat dengan nrp dan waktu
				$menit_terlambat[$nrp][] = $menit_telat_masuk;
				# membuat array hari telat masuk dengan menyimpan nrp
				$waktu_terlambat[] =  $nrp;
			}

			# cek waktu pulang
			$menit_pulang_cepat = cek_pulang_cepat(get_standar_jam_pulang($key->date), $key->time_out);
			//	echo $menit_pulang_cepat."<br>";
			if ($menit_pulang_cepat != 0) {
				# membuat array waktu menit pulang cepat dengan nrp dan waktu
				$menit_pc[$nrp][] = $menit_pulang_cepat;
				# membuat array hari pulang cepat dengan menyimpan nrp
				$waktu_pc[] =  $nrp;
			}

		}




// Menghitun Hari yang Belum di Lalui
		//$hari_sudah = $this->m_models->getRows("absensi where date >= '$dari' and date <= '$sampai' group by date");
		 $hari_sudah = (((abs(strtotime ($sampai) - strtotime ($dari)))/(60*60*24))+1);


		// Jika Sakit

		$data['logsk'] = $this->m_models->getSpesific('absensi',"absensi='S' and (date >= '$dari' and date <= '$sampai') ");
		foreach ($data['logsk'] as $key1) {
			$nrp1 = $key1->user_id;
			# membuat array nrp
			$skt[] =  $nrp1;
		}

		// Jika Izin
		$data['logiz'] = $this->m_models->getSpesific('absensi',"absensi='I' and (date >= '$dari' and date <= '$sampai') ");
		foreach ($data['logiz'] as $key2) {
			$nrp2 = $key2->user_id;
			# membuat array nrp
			$izn[] =  $nrp2;
		}



		// Jika Cuti
		//$data['logcuti'] = $this->m_models->getSpesific("peg_cuti"," tanggal_mulai >= '$dari' and tanggal_selesai <= '$sampai'");
		//$data['logcuti'] = $this->m_models->getAll("peg_cuti join pegawai on peg_cuti.nrp = pegawai.nrp where tgl_mulai <='$tanggal' and tgl_selesai >= '$tanggal'");



		// Jika Tidak Absen

		

		
		
		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		$sakit = array_count_values($skt);
		$izin = array_count_values($izn);
		$terlambat_waktu = array_count_values($waktu_terlambat);
		$pc_waktu = array_count_values($waktu_pc);


		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_terlambat);

		foreach ($arr_nrp as $key => $value) {
			$jml_terlambat_waktu = 0;
			for ($i=0; $i < $terlambat_waktu[$value]; $i++) { 
				$jml_terlambat_waktu += $menit_terlambat[$value][$i];
			}
			$terlambat_menit[$value] = $jml_terlambat_waktu;
		}

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_pc);

		foreach ($arr_nrp as $key => $value) {
			$jml_pc_waktu = 0;
			for ($i=0; $i < $pc_waktu[$value]; $i++) { 
				$jml_pc_waktu += $menit_pc[$value][$i];
			}
			$pc_menit[$value] = $jml_pc_waktu;
		}
		
		if ($sekolah == 'semua_sekolah') {
			//$data['pegawai'] = $this->m_models->get_data('nrp, nama,id_jabatan','pegawai order by nama ASC');
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama asc");
		}else{
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama, id_jabatan","pegawai", "WHERE id_sekolah='$sekolah' order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai where pegawai.id_sekolah='$sekolah' and status_aktf='Aktif' order by nama asc");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			
			//Menampilkan Jabatan
			$jab = all("jabatan","id_jabatan",$key->id_jabatan,"nama_jabatan");
			
			//echo $jab;
			$arr_rekap['jabatan'][] = $jab;
			
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['waktu_terlambat'][] = $terlambat_waktu[$key->nrp];
			$arr_rekap['menit_terlambat'][] = $terlambat_menit[$key->nrp];
			$arr_rekap['waktu_pc'][] = $pc_waktu[$key->nrp];
			$arr_rekap['menit_pc'][] = $pc_menit[$key->nrp];	
			$arr_rekap['setandar_hadir'][] = $setandar_hadir;
			$arr_rekap['hadir'][] = $kehadiran[$key->nrp];	
			$arr_rekap['sakit'][] = $sakit[$key->nrp];	
			$arr_rekap['izin'][] = $izin[$key->nrp];
			//$arr_rekap['alpa'][] = ($setandar_hadir - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			$arr_rekap['alpa'][] = (($hari_sudah - $jml_hari_minggu)  - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			//$arr_rekap['tidak'][] = $setandar_hadir - $kehadiran[$key->nrp];	

			$arr_rekap['tidak'][] =  (($hari_sudah - $jml_hari_minggu)  - $kehadiran[$key->nrp]);

			// Prosesntase
			$arr_rekap['prosen'][] = ($kehadiran[$key->nrp] / $setandar_hadir) * 100;
		}

		if (isset($dari) AND isset($sampai)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}

		//$data['sekolah'] = $this->m_models->getwhere("id_sekolah, nama", "sekolah", "status_aktif", 'on', "nama", "asc");
		
		$ar = $this->session->userdata['nrp'];
        $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		
		$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   $data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");

	   if (($idsekolah=="8") or ($idsekolah=="13")){
	    	$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   		$data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");
		}

		$this->load->view('absensi/export_excel_rekapitulasi_absensi', $data);


	} 



public function export_excel_rekapitulasi_absensi2(){
 		$this->load->helper('absen');

 		error_reporting(0);

 		//$sekolah  = $this->input->post('sekolah', TRUE);
		//$bulan  = $this->input->post('bln', TRUE);
        //$tahun  = $this->input->post('thn', TRUE);
        //$thnbln = $tahun.'-'.$bulan;
		
		$dari  = $this->uri->segment(3);
		$dari2  = $this->uri->segment(3);
		$sampai  = $this->uri->segment(4);
		$sekolah  = $this->uri->segment(5, TRUE);

        $data['sekolah_pilih'] = $sekolah;
        $data['dsekolah'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
        

		//$total_hari = $sampai - $sampai;
		//echo $total_hari;
		
        //$jml_hari_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
        $jml_hari_bulan = ((abs(strtotime ($sampai) - strtotime ($dari)))/(60*60*24))+1;
       // $jml_hari_minggu = jml_hari_minggu_bulan($bulan, $tahun);
	   
	   $hari_min=0;
	    while (strtotime($dari2) <= strtotime($sampai)) {
			$datte=$dari2;
			$tgll=explode("-",$datte);
			$hari=date("l", mktime(0, 0, 0, $tgll[1], $tgll[2], $tgll[0])); 
			if($hari=="Sunday"){
				$hari_min++;
			}
			$dari2 = date ("Y-m-d", strtotime("+1 day", strtotime($dari2)));
		}
		$jml_hari_minggu = intval($hari_min);
		
	   
	   
        $setandar_hadir = $jml_hari_bulan - $jml_hari_minggu;





        # mengambil data log absnesi sesuai bulan pencarian
		$data['log'] = $this->m_models->getSpesific('absensi',"absensi='H' and (date >= '$dari' and date <= '$sampai') ");
	//	$data['log'] = $this->m_models->getAll("absensi where absensi='H' and date between '$dari' and '$sampai' ");
		
		//echo  cek_telat_masuk(2,2);
		//ho get_standar_jam_masuk('2017-09-09');
		foreach ($data['log'] as $key) {
			$nrp = $key->user_id;
			  
			
			# membuat array nrp
			$hadir[] =  $nrp;
			# cek waktu masuk
			$menit_telat_masuk = cek_telat_masuk(get_standar_jam_masuk($key->date), $key->time_in);
		//cho $menit_telat_masuk."<br>";
			if ($menit_telat_masuk != 0) {
				# membuat array waktu menit terlambat dengan nrp dan waktu
				$menit_terlambat[$nrp][] = $menit_telat_masuk;
				# membuat array hari telat masuk dengan menyimpan nrp
				$waktu_terlambat[] =  $nrp;
			}

			# cek waktu pulang
			$menit_pulang_cepat = cek_pulang_cepat(get_standar_jam_pulang($key->date), $key->time_out);
			//	echo $menit_pulang_cepat."<br>";
			if ($menit_pulang_cepat != 0) {
				# membuat array waktu menit pulang cepat dengan nrp dan waktu
				$menit_pc[$nrp][] = $menit_pulang_cepat;
				# membuat array hari pulang cepat dengan menyimpan nrp
				$waktu_pc[] =  $nrp;
			}

		}



		// Jika Sakit
		$data['logsk'] = $this->m_models->getSpesific('absensi',"absensi='S' and (date >= '$dari' and date <= '$sampai') ");
		foreach ($data['logsk'] as $key1) {
			$nrp1 = $key1->user_id;
			# membuat array nrp
			$skt[] =  $nrp1;
		}

		// Jika Izin
		$data['logiz'] = $this->m_models->getSpesific('absensi',"absensi='I' and (date >= '$dari' and date <= '$sampai') ");
		foreach ($data['logiz'] as $key2) {
			$nrp2 = $key2->user_id;
			# membuat array nrp
			$izn[] =  $nrp2;
		}



		// Jika Cuti
		//$data['logcuti'] = $this->m_models->getSpesific("peg_cuti"," tanggal_mulai >= '$dari' and tanggal_selesai <= '$sampai'");
		//$data['logcuti'] = $this->m_models->getAll("peg_cuti join pegawai on peg_cuti.nrp = pegawai.nrp where tgl_mulai <='$tanggal' and tgl_selesai >= '$tanggal'");


// Menghitun Hari yang Belum di Lalui
		//$hari_sudah = $this->m_models->getRows("absensi where date >= '$dari' and date <= '$sampai' group by date");
 $hari_sudah = (((abs(strtotime ($sampai) - strtotime ($dari)))/(60*60*24))+1);

		// Jika Tidak Absen

		
if(array_count_values($skt)=="null")
{
	$sakit = 0;
} else {

	$sakit = array_count_values($skt);
}

if(array_count_values($izn)=="null")
{
	$izin = 0;
} else {

	$izin = array_count_values($izn);
}

		


		# menghitung kehadiran setiap nrp
		# mengambil nilainya dengan cara $var['kehadiran']
		$kehadiran = array_count_values($hadir);
		//$sakit = array_count_values($skt);
		//$izin = array_count_values($izn);
		$terlambat_waktu = array_count_values($waktu_terlambat);
		$pc_waktu = array_count_values($waktu_pc);


		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_terlambat);

		foreach ($arr_nrp as $key => $value) {
			$jml_terlambat_waktu = 0;
			for ($i=0; $i < $terlambat_waktu[$value]; $i++) { 
				$jml_terlambat_waktu += $menit_terlambat[$value][$i];
			}
			$terlambat_menit[$value] = $jml_terlambat_waktu;
		}

		$arr_nrp = array();
		$arr_nrp = array_unique($waktu_pc);

		foreach ($arr_nrp as $key => $value) {
			$jml_pc_waktu = 0;
			for ($i=0; $i < $pc_waktu[$value]; $i++) { 
				$jml_pc_waktu += $menit_pc[$value][$i];
			}
			$pc_menit[$value] = $jml_pc_waktu;
		}
		
		if ($sekolah == 'semua_sekolah') {
			//$data['pegawai'] = $this->m_models->get_data('nrp, nama,id_jabatan','pegawai order by nama ASC');
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama asc");
		}else{
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama, id_jabatan","pegawai", "WHERE id_sekolah='$sekolah' order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai where pegawai.id_sekolah='$sekolah' and status_aktf='Aktif' order by nama asc");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			
			//Menampilkan Jabatan
			$jab = all("jabatan","id_jabatan",$key->id_jabatan,"nama_jabatan");
			
			//echo $jab;
			$arr_rekap['jabatan'][] = $jab;




			
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['id_skl'][] = $key->id_sekolah;
			$arr_rekap['waktu_terlambat'][] = $terlambat_waktu[$key->nrp];
			$arr_rekap['menit_terlambat'][] = $terlambat_menit[$key->nrp];
			$arr_rekap['waktu_pc'][] = $pc_waktu[$key->nrp];
			$arr_rekap['menit_pc'][] = $pc_menit[$key->nrp];	
			$arr_rekap['setandar_hadir'][] = $setandar_hadir;
			$arr_rekap['hadir'][] = $kehadiran[$key->nrp];	
			$arr_rekap['sakit'][] = $sakit[$key->nrp];	
			$arr_rekap['izin'][] = $izin[$key->nrp];
			//$arr_rekap['alpa'][] = ($setandar_hadir - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			//$arr_rekap['alpa'][] = ($hari_sudah - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			$arr_rekap['alpa'][] = ($hari_sudah - $kehadiran[$key->nrp]) - ($sakit[$key->nrp] + $izin[$key->nrp]);
			//$arr_rekap['tidak'][] = $setandar_hadir - $kehadiran[$key->nrp];
			$arr_rekap['tidak'][] =  (($hari_sudah - $jml_hari_minggu)  - $kehadiran[$key->nrp]);	

			// Prosesntase
			$arr_rekap['prosen'][] = ($kehadiran[$key->nrp] / $setandar_hadir) * 100;
		}

		if (isset($dari) AND isset($sampai)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}

		//$data['sekolah'] = $this->m_models->getwhere("id_sekolah, nama", "sekolah", "status_aktif", 'on', "nama", "asc");
		
		$ar = $this->session->userdata['nrp'];
        $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		
		$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   $data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");

	   if (($idsekolah=="8") or ($idsekolah=="13")){
	    	$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   		$data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");
		}
		$this->load->view('absensi/export_excel_rekapitulasi_absensi2', $data);
	}


	# REKAPITULASI YANG ABSEN IZIN DAN SAKIT #


	public function rekapitulasi_sakit_izin(){
		$this->load->view('template/header');
 		$this->load->helper('absen');

 		$sekolah  = $this->input->post('sekolah', TRUE);
		
		$dari  = $this->input->post('dari');
		$dari2  = $this->input->post('dari');
		$sampai  = $this->input->post('sampai');

        $data['sekolah_pilih'] = $sekolah;
        $data['bln_pilih'] = $bulan;
        $data['thn_pilih'] = $tahun;

		if ($sekolah == 'semua_sekolah') {
			//$data['pegawai'] = $this->m_models->get_data('nrp, nama,id_jabatan','pegawai order by nama ASC');
			$data['pegawai'] = $this->m_models->getAll("pegawai join absensi on pegawai.nrp = absensi.user_id where status_aktf='Aktif' and (absensi='I' or absensi='S')  and date between '$dari' and '$sampai' order by date,nama asc");
		}else{
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama, id_jabatan","pegawai", "WHERE id_sekolah='$sekolah' order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai join absensi on pegawai.nrp = absensi.user_id where pegawai.id_sekolah='$sekolah' and status_aktf='Aktif' and (absensi='I' or absensi='S') and date between '$dari' and '$sampai' order by date,nama asc");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			
			//Menampilkan Jabatan
			$jab = all("jabatan","id_jabatan",$key->id_jabatan,"nama_jabatan");


			//Menampilkan Sekolah
			$nama_sekolah = all("sekolah","id_sekolah",$key->id_sekolah,"nama");
			
			//echo $jab;
			$arr_rekap['jabatan'][] = $jab;
			$arr_rekap['tanggal'][] = $key->date;
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['absensi'][] = $key->absensi;
			$arr_rekap['nama_sekolah'][] = $nama_sekolah;
			
		}

		if (isset($dari) AND isset($sampai)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}
		
		$ar = $this->session->userdata['nrp'];
        $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		
		$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   $data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");

	   if (($idsekolah=="8") or ($idsekolah=="13")){
	    	$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   		$data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");
		}

		$this->load->view('absensi/rekapitulasi_sakit_izin', $data);
		$this->load->view('template/footer');		
	}


	public function export_excel_rekapitulasi_sakit_izin(){
		//$this->load->view('template/header');
 		$this->load->helper('absen');
 		error_reporting(0);

 		//$sekolah  = $this->input->post('sekolah', TRUE);
		
		/*$dari  = $this->input->post('dari');
		$dari2  = $this->input->post('dari');
		$sampai  = $this->input->post('sampai');*/

		
		$dari  = $this->uri->segment(3);
		$dari2  = $this->uri->segment(3);
		$sampai  = $this->uri->segment(4);
		$sekolah  = $this->uri->segment(5, TRUE);

        $data['sekolah_pilih'] = $sekolah;
        $data['bln_pilih'] = $bulan;
        $data['thn_pilih'] = $tahun;

		if ($sekolah == 'semua_sekolah') {
			//$data['pegawai'] = $this->m_models->get_data('nrp, nama,id_jabatan','pegawai order by nama ASC');
			$data['pegawai'] = $this->m_models->getAll("pegawai join absensi on pegawai.nrp = absensi.user_id where status_aktf='Aktif' and (absensi='I' or absensi='S')  and date between '$dari' and '$sampai' order by date,nama asc");
		}else{
			//$data['pegawai'] = $this->m_models->get_data("nrp, nama, id_jabatan","pegawai", "WHERE id_sekolah='$sekolah' order by nama ASC");
			$data['pegawai'] = $this->m_models->getAll("pegawai join absensi on pegawai.nrp = absensi.user_id where pegawai.id_sekolah='$sekolah' and status_aktf='Aktif' and (absensi='I' or absensi='S') and date between '$dari' and '$sampai' order by date,nama asc");
		}
		
		foreach ($data['pegawai'] as $key) {
			$arr_rekap['nrp'][] = $key->nrp;
			
			//Menampilkan Jabatan
			$jab = all("jabatan","id_jabatan",$key->id_jabatan,"nama_jabatan");


			//Menampilkan Sekolah
			$nama_sekolah = all("sekolah","id_sekolah",$key->id_sekolah,"nama");
			
			//echo $jab;
			$arr_rekap['jabatan'][] = $jab;
			$arr_rekap['tanggal'][] = $key->date;
			$arr_rekap['nama'][] = $key->nama;
			$arr_rekap['absensi'][] = $key->absensi;
			$arr_rekap['nama_sekolah'][] = $nama_sekolah;
			
		}

		if (isset($dari) AND isset($sampai)) {
			$data['rekap'] = $arr_rekap;
			$data['jml_pegawai'] = count($data['pegawai']);
		}
		
		$ar = $this->session->userdata['nrp'];
        $idsekolah = $this->m_models->getSession($ar, "id_sekolah"); 
		
		$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   $data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");

	   if (($idsekolah=="8") or ($idsekolah=="13")){
	    	$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "status_aktif", 'on', "nama", "asc");
		} else {
			$arrayw=array('status_aktif ='=>'on','kategori ='=>'Sekolah','id_sekolah'=>$idsekolah);
	   		$data['sekolah']  = $this->m_models->getTabelwhere("*", "sekolah",$arrayw,"id_sekolah","asc");
		}

		$this->load->view('absensi/export_excel_rekapitulasi_sakit_izin', $data);
	}
	
	public function data_absensi_peg(){
		$this->load->view('template/header');

		$nrp = $this->input->post('nrp', TRUE);
		$tgl_dari = $this->input->post('dari', TRUE);
		$tgl_sampai = $this->input->post('sampai', TRUE);

		$arraywhere = array('date >= ' => $tgl_dari, 'date <= ' => $tgl_sampai);
		if ($tgl_dari!= null AND $tgl_sampai != null) {
			if ($nrp != 'semua_pegawai') {
				$arraywhere['absensi.user_id'] = $nrp; 
				$data['log_absen'] = $this->m_models->getJoin1where('absensi.*, pegawai.nama', 'absensi', 'pegawai', 'absensi.user_id=pegawai.nrp', $arraywhere, 'date', 'ASC');
				
				
				foreach($data['log_absen'] as $lg){
					$detail = $this->m_models->get_data("*","absen_detail","where nrp='$lg->user_id' and date='$lg->date'");
					foreach($detail as $de){
						$arr_fmasuk[$de->nrp][$de->date]['masuk'] = $de->foto_masuk;
						$arr_fkeluar[$de->nrp][$de->date]['keluar'] = $de->foto_keluar;
						
						
					}
					
					
				}
			}else{
				$data['log_absen'] = $this->m_models->getJoin1where('absensi.*, pegawai.nama', 'absensi', 'pegawai', 'absensi.user_id=pegawai.nrp', $arraywhere, 'date', 'ASC');
				foreach($data['log_absen'] as $lg){
					$detail = $this->m_models->get_data("*","absen_detail","where nrp='$lg->user_id' and date='$lg->date'");
					foreach($detail as $de){
						$arr_fmasuk[$de->nrp][$de->date]['masuk'] = $de->foto_masuk;
						$arr_fkeluar[$de->nrp][$de->date]['keluar'] = $de->foto_keluar;
						
						
					}
					
					
				}
			}
			
			$data['fotmasuk'] = $arr_fmasuk;
			$data['fotkeluar'] = $arr_fkeluar;
		}

		$data['pegawai'] = $this->m_models->get_data("nrp, nama", "pegawai ORDER BY nama ASC","");
		
		$this->load->view('absensi/log_absensi_peg', $data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	# Upload Absensi #
	public function import_absensii(){
		$this->load->view('template/header');

		$this->load->view('absensi/import_absensii');

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}


}
?>